--

ALTER TABLE `users` ADD `openweathermap_city_id` int(11) NOT NULL DEFAULT 0;

CREATE TABLE `all_cities` (
  `id` int NOT NULL,
  `name` varchar(128) NOT NULL DEFAULT '',
  `name_ru` varchar(128) NOT NULL DEFAULT '',
  `country` varchar(64) NOT NULL DEFAULT '',
  `country_id` int NOT NULL DEFAULT 0,
  `admin1_code` varchar(64) NOT NULL DEFAULT '',
  `admin2_code` varchar(64) NOT NULL DEFAULT '',
  `admin3_code` varchar(64) NOT NULL DEFAULT '',
  `admin4_code` varchar(64) NOT NULL DEFAULT '',
  `lat` varchar(32) NOT NULL DEFAULT '',
  `lon` varchar(32) NOT NULL DEFAULT '',
  `timezone` varchar(64) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `country_id` (`country_id`),
  KEY `timezone` (`timezone`)
) DEFAULT CHARSET=utf8;

CREATE TABLE `openweathermap_cache` (
  `id` int NOT NULL AUTO_INCREMENT,
  `current` text,
  `forecast` text,
  `updated_current` timestamp null default null,
  `updated_forecast` timestamp null default null,
  `city_id` int NOT NULL DEFAULT 0,
  `last_request` timestamp null default null,
  PRIMARY KEY (`id`),
  UNIQUE KEY `city_id` (`city_id`)
) DEFAULT CHARSET=utf8;

ALTER TABLE `weatherco_cache` ADD `updated_current` timestamp null default null;
ALTER TABLE `weatherco_cache` ADD `updated_forecast` timestamp null default null;
UPDATE weatherco_cache SET updated_current = updated, updated_forecast=updated;

SET NAMES utf8;

INSERT INTO all_cities (`id`, `name`, `name_ru`, `country`, `country_id`, `admin1_code`, `admin2_code`, `admin3_code`, `admin4_code`, `lat`, `lon`, `timezone`) VALUES
("290594", "Umm al Qaywayn", "Умм-эль-Кайвайн", "AE", "784", "", "07", "", "", "25.56473", "55.55517", "Asia/Dubai"),
("291074", "Ras al-Khaimah", "Рас-эль-Хайма", "AE", "784", "", "05", "", "", "25.78953", "55.9432", "Asia/Dubai"),
("291279", "Muzayri‘", "", "AE", "784", "", "01", "", "", "23.14355", "53.7881", "Asia/Dubai"),
("291696", "Khawr Fakkān", "Хор-Факкан", "AE", "784", "", "06", "", "", "25.33132", "56.34199", "Asia/Dubai"),
("292223", "Dubai", "Дубай", "AE", "784", "", "03", "", "", "25.0657", "55.17128", "Asia/Dubai"),
("292231", "Dibba Al-Fujairah", "", "AE", "784", "", "04", "", "", "25.59246", "56.26176", "Asia/Dubai"),
("292239", "Dibba Al-Hisn", "Дибба Аль-Хисн", "AE", "784", "", "04", "", "", "25.61955", "56.27291", "Asia/Dubai"),
("292672", "Sharjah", "Шарджа", "AE", "784", "", "06", "", "", "25.33737", "55.41206", "Asia/Dubai"),
("292688", "Ar Ruways", "Ар-Руваис", "AE", "784", "AE", "01", "", "", "24.11028", "52.73056", "Asia/Dubai"),
("292878", "Al Fujayrah", "Фуджейра", "AE", "784", "", "04", "", "", "25.11641", "56.34141", "Asia/Dubai"),
("292913", "Al Ain", "Аль-Айн", "AE", "784", "", "01", "", "", "24.19167", "55.76056", "Asia/Dubai"),
("292932", "Ajman", "", "AE", "784", "", "02", "", "", "25.41111", "55.43504", "Asia/Dubai"),
("292953", "Adh Dhayd", "", "AE", "784", "", "06", "", "", "25.28812", "55.88157", "Asia/Dubai"),
("292968", "Abu Dhabi", "Абу-Даби", "AE", "784", "", "01", "", "", "24.46667", "54.36667", "Asia/Dubai"),
("1120483", "Kuhsān", "", "AF", "4", "", "11", "", "", "34.65389", "61.19778", "Asia/Kabul"),
("1120487", "Tukzār", "", "AF", "4", "", "33", "", "", "35.94831", "66.42132", "Asia/Kabul"),
("1120711", "Zindah Jān", "", "AF", "4", "", "11", "", "", "34.34264", "61.74675", "Asia/Kabul"),
("1120863", "Zarghūn Shahr", "", "AF", "4", "", "29", "", "", "32.84734", "68.44573", "Asia/Kabul"),
("1120879", "Zaṟah Sharan", "", "AF", "4", "", "29", "", "", "33.14641", "68.79213", "Asia/Kabul"),
("1120985", "Zaranj", "Зарани", "AF", "4", "", "19", "7053297", "", "30.95962", "61.86037", "Asia/Kabul"),
("1121271", "Yangī Qal‘ah", "", "AF", "4", "", "26", "", "", "37.46572", "69.61131", "Asia/Kabul"),
("1122408", "Tīr Pul", "", "AF", "4", "", "11", "", "", "34.59431", "61.26895", "Asia/Kabul"),
("1122747", "Tarinkot", "", "AF", "4", "", "39", "7054035", "", "32.62998", "65.87806", "Asia/Kabul"),
("1123004", "Taloqan", "Таликан", "AF", "4", "", "26", "", "", "36.73605", "69.53451", "Asia/Kabul"),
("1123343", "Tagāw-Bāy", "", "AF", "4", "", "33", "", "", "35.69941", "66.06164", "Asia/Kabul"),
("1123424", "Tagāb", "", "AF", "4", "", "14", "", "", "34.85501", "69.64917", "Asia/Kabul"),
("1125155", "Shīnḏanḏ", "Шинданд", "AF", "4", "", "11", "", "", "33.30294", "62.1474", "Asia/Kabul"),
("1125444", "Shibirghān", "Шеберган", "AF", "4", "", "31", "", "", "36.66757", "65.7529", "Asia/Kabul"),
("1125896", "Shahrak", "", "AF", "4", "", "09", "", "", "34.10737", "64.3052", "Asia/Kabul"),
("1126606", "Sidqābād", "", "AF", "4", "", "14", "7053088", "", "35.02298", "69.35112", "Asia/Kabul"),
("1127110", "Sar-e Pul", "Сари-Пуль", "AF", "4", "", "33", "", "", "36.21544", "65.93249", "Asia/Kabul"),
("1127547", "Sangīn", "", "AF", "4", "", "10", "", "", "32.07275", "64.8359", "Asia/Kabul"),
("1127628", "Sang-e Chārak", "", "AF", "4", "", "33", "", "", "35.84972", "66.43694", "Asia/Kabul"),
("1127768", "Aībak", "Саманган", "AF", "4", "", "32", "", "", "36.26468", "68.01551", "Asia/Kabul"),
("1128239", "Rūdbār", "", "AF", "4", "", "19", "", "", "30.15", "62.6", "Asia/Kabul"),
("1128265", "Rustāq", "", "AF", "4", "", "26", "", "", "37.12604", "69.83045", "Asia/Kabul"),
("1129516", "Qarqīn", "Кханика", "AF", "4", "", "31", "", "", "37.41853", "66.04358", "Asia/Kabul"),
("1129636", "Qarchī Gak", "", "AF", "4", "", "30", "", "", "37.03999", "66.78891", "Asia/Kabul"),
("1129648", "Qarāwul", "", "AF", "4", "", "24", "", "", "37.21959", "68.7802", "Asia/Kabul"),
("1129678", "Qarah Bāgh", "", "AF", "4", "", "11", "", "", "34.94023", "61.77589", "Asia/Kabul"),
("1129867", "Qala i Naw", "", "AF", "4", "", "02", "", "", "34.98735", "63.12891", "Asia/Kabul"),
("1130065", "Qal‘ah-ye Shahr", "", "AF", "4", "", "33", "", "", "35.54729", "65.5676", "Asia/Kabul"),
("1130131", "Qalāt", "", "AF", "4", "", "28", "", "", "32.10575", "66.90833", "Asia/Kabul"),
("1130469", "Pārūn", "", "AF", "4", "", "38", "7054028", "", "35.42064", "70.92261", "Asia/Kabul"),
("1130490", "Pul-e Khumrī", "Пули-Хумри", "AF", "4", "", "03", "", "", "35.94458", "68.71512", "Asia/Kabul"),
("1130497", "Pul-e ‘Alam", "", "AF", "4", "", "17", "", "", "33.99529", "69.02274", "Asia/Kabul"),
("1131162", "Panjāb", "", "AF", "4", "", "05", "", "", "34.38795", "67.02327", "Asia/Kabul"),
("1131316", "Paghmān", "Пагман", "AF", "4", "", "13", "", "", "34.58787", "68.95091", "Asia/Kabul"),
("1131462", "Uruzgān", "", "AF", "4", "", "39", "", "", "32.92775", "66.63253", "Asia/Kabul"),
("1131833", "Nīlī", "", "AF", "4", "", "41", "", "", "33.72178", "66.13023", "Asia/Kabul"),
("1132495", "Nahrīn", "Нахрин", "AF", "4", "", "03", "", "", "36.0649", "69.13343", "Asia/Kabul"),
("1133270", "Mīr Bachah Kōṯ", "", "AF", "4", "", "13", "", "", "34.74999", "69.11899", "Asia/Kabul"),
("1133310", "Mīrābād", "", "AF", "4", "", "19", "", "", "30.43624", "61.8383", "Asia/Kabul"),
("1133453", "Maymana", "Меймене", "AF", "4", "", "07", "", "", "35.92139", "64.78361", "Asia/Kabul"),
("1133574", "Mehtar Lām", "Митарлам", "AF", "4", "", "35", "", "", "34.67139", "70.20944", "Asia/Kabul"),
("1133616", "Mazār-e Sharīf", "Мазари-Шариф", "AF", "4", "", "30", "", "", "36.70904", "67.11087", "Asia/Kabul"),
("1134720", "Lashkar Gāh", "Лашкаргах", "AF", "4", "", "10", "", "", "31.59382", "64.37161", "Asia/Kabul"),
("1134762", "Larkird", "", "AF", "4", "", "33", "", "", "35.48936", "66.66409", "Asia/Kabul"),
("1135158", "Kushk", "Кушк", "AF", "4", "", "11", "", "", "33.29565", "61.95221", "Asia/Kabul"),
("1135689", "Kunduz", "Кундуз", "AF", "4", "", "24", "", "", "36.72895", "68.857", "Asia/Kabul"),
("1136469", "Khōst", "Хост", "AF", "4", "", "37", "", "", "33.33951", "69.92041", "Asia/Kabul"),
("1136575", "Khulm", "Ташкурган", "AF", "4", "", "30", "", "", "36.69736", "67.69826", "Asia/Kabul"),
("1136863", "Khāsh", "", "AF", "4", "", "19", "", "", "31.52919", "62.79055", "Asia/Kabul"),
("1137148", "Khandūd", "", "AF", "4", "", "01", "", "", "36.95127", "72.318", "Asia/Kabul"),
("1137168", "Khanabad", "Ханабад", "AF", "4", "", "24", "", "", "36.6825", "69.11556", "Asia/Kabul"),
("1137807", "Karukh", "", "AF", "4", "", "11", "", "", "34.48108", "62.5863", "Asia/Kabul"),
("1138336", "Kandahār", "Кандагар", "AF", "4", "", "23", "", "", "31.61332", "65.71013", "Asia/Kabul"),
("1138958", "Kabul", "Кабул", "AF", "4", "", "13", "", "", "34.52813", "69.17233", "Asia/Kabul"),
("1139085", "Jurm", "", "AF", "4", "", "01", "", "", "36.86477", "70.83421", "Asia/Kabul"),
("1139715", "Jalālābād", "Джалалабад", "AF", "4", "", "18", "", "", "34.42647", "70.45153", "Asia/Kabul"),
("1139807", "Jabal os Saraj", "Dzhabal’-Ussaradzh", "AF", "4", "", "40", "", "", "35.11833", "69.23778", "Asia/Kabul"),
("1140026", "Herāt", "Герат", "AF", "4", "", "11", "", "", "34.34817", "62.19967", "Asia/Kabul"),
("1141089", "Ghormach", "", "AF", "4", "", "02", "7052787", "", "35.73062", "63.78264", "Asia/Kabul"),
("1141269", "Ghazni", "Газни", "AF", "4", "", "08", "", "", "33.55391", "68.42096", "Asia/Kabul"),
("1141540", "Gereshk", "Герешк", "AF", "4", "", "10", "", "", "31.82089", "64.57005", "Asia/Kabul"),
("1141857", "Gardez", "Гардез", "AF", "4", "", "36", "7053978", "", "33.59744", "69.22592", "Asia/Kabul"),
("1142170", "Fayzabad", "Файзабад", "AF", "4", "", "01", "", "", "37.11664", "70.58002", "Asia/Kabul"),
("1142239", "Farkhār", "", "AF", "4", "", "26", "", "", "36.57288", "69.85783", "Asia/Kabul"),
("1142264", "Farah", "", "AF", "4", "", "06", "", "", "32.37451", "62.11638", "Asia/Kabul"),
("1142404", "Kafir Qala", "", "AF", "4", "", "11", "", "", "34.66667", "61.06667", "Asia/Kabul"),
("1142545", "Imām Şāḩib", "", "AF", "4", "", "24", "", "", "37.18897", "68.93644", "Asia/Kabul"),
("1143838", "Dasht-e Archī", "", "AF", "4", "", "24", "", "", "37.13333", "69.16667", "Asia/Kabul"),
("1143874", "Darzāb", "", "AF", "4", "", "31", "", "", "35.97744", "65.37828", "Asia/Kabul"),
("1143901", "Markaz-e Ḩukūmat-e Darwēshān", "", "AF", "4", "", "10", "", "", "31.13231", "64.1934", "Asia/Kabul"),
("1144942", "Chīras", "", "AF", "4", "", "33", "", "", "35.41674", "65.98234", "Asia/Kabul"),
("1145352", "Charikar", "Чарикар", "AF", "4", "", "40", "", "", "35.01361", "69.17139", "Asia/Kabul"),
("1145866", "Chahār Burj", "", "AF", "4", "", "11", "", "", "34.24475", "62.19165", "Asia/Kabul"),
("1145904", "Fayrōz Kōh", "", "AF", "4", "", "09", "", "", "34.51952", "65.25093", "Asia/Kabul"),
("1146822", "Bāsawul", "", "AF", "4", "", "18", "", "", "34.24749", "70.87218", "Asia/Kabul"),
("1147066", "Baraki Barak", "", "AF", "4", "", "17", "", "", "33.96744", "68.9492", "Asia/Kabul"),
("1147242", "Bāmyān", "", "AF", "4", "", "05", "", "", "34.82156", "67.82734", "Asia/Kabul"),
("1147290", "Balkh", "Балх", "AF", "4", "", "30", "", "", "36.75635", "66.8972", "Asia/Kabul"),
("1147540", "Baghlān", "Баглан", "AF", "4", "", "03", "", "", "36.13068", "68.70829", "Asia/Kabul"),
("1147851", "Ḩukūmatī Azrah", "", "AF", "4", "", "17", "", "", "34.17355", "69.64573", "Asia/Kabul"),
("1148106", "Ārt Khwājah", "", "AF", "4", "", "26", "", "", "37.08571", "69.47958", "Asia/Kabul"),
("1148205", "Āsmār", "", "AF", "4", "", "34", "", "", "35.03333", "71.35809", "Asia/Kabul"),
("1148268", "Ashkāsham", "", "AF", "4", "", "01", "", "", "36.68333", "71.53333", "Asia/Kabul"),
("1148311", "Asadābād", "Асадабад", "AF", "4", "", "34", "", "", "34.87311", "71.14697", "Asia/Kabul"),
("1148658", "Andkhōy", "", "AF", "4", "", "07", "", "", "36.95293", "65.12376", "Asia/Kabul"),
("1148709", "Anār Darah", "", "AF", "4", "", "06", "", "", "32.7587", "61.65397", "Asia/Kabul"),
("1149052", "‘Alāqahdārī Dīshū", "", "AF", "4", "", "10", "", "", "30.43206", "63.29802", "Asia/Kabul"),
("1429434", "Bāzārak", "Базарак", "AF", "4", "", "42", "", "", "35.31292", "69.51519", "Asia/Kabul"),
("1456960", "Maydanshakhr", "", "AF", "4", "", "27", "", "", "34.39561", "68.86618", "Asia/Kabul"),
("1469706", "Markaz-e Woluswalī-ye Āchīn", "", "AF", "4", "", "18", "", "", "34.12583", "70.70778", "Asia/Kabul"),
("8534261", "Sharan", "", "AF", "4", "", "29", "7053785", "", "33.17568", "68.73045", "Asia/Kabul"),
("363243", "Sarandë", "Саранда", "AL", "8", "", "51", "20", "", "39.87556", "20.00528", "Europe/Tirane"),
("781443", "Tepelenë", "", "AL", "8", "", "45", "23", "", "40.29583", "20.01917", "Europe/Tirane"),
("781979", "Poliçan", "", "AL", "8", "", "40", "01", "", "40.61222", "20.09806", "Europe/Tirane"),
("782061", "Peshkopi", "", "AL", "8", "", "41", "", "", "41.685", "20.42889", "Europe/Tirane"),
("782070", "Përmet", "", "AL", "8", "", "45", "17", "", "40.23361", "20.35167", "Europe/Tirane"),
("782661", "Kukës", "Кукес", "AL", "8", "", "47", "", "", "42.07694", "20.42194", "Europe/Tirane"),
("782756", "Korçë", "Корча", "AL", "8", "", "46", "09", "", "40.61861", "20.78083", "Europe/Tirane"),
("783059", "Gramsh", "", "AL", "8", "", "43", "07", "", "40.86972", "20.18444", "Europe/Tirane"),
("783148", "Gjirokastër", "Гирокастра", "AL", "8", "", "45", "", "", "40.07583", "20.13889", "Europe/Tirane"),
("783259", "Ersekë", "", "AL", "8", "", "46", "08", "", "40.33778", "20.67889", "Europe/Tirane"),
("783263", "Elbasan", "Эльбасан", "AL", "8", "", "43", "", "", "41.1125", "20.08222", "Europe/Tirane"),
("783408", "Çorovodë", "", "AL", "8", "", "40", "22", "", "40.50417", "20.22722", "Europe/Tirane"),
("783493", "Burrel", "Буррель", "AL", "8", "", "41", "15", "", "41.61028", "20.00889", "Europe/Tirane"),
("783508", "Bulqizë", "", "AL", "8", "", "41", "29", "", "41.49167", "20.22194", "Europe/Tirane"),
("783606", "Bilisht", "", "AL", "8", "", "46", "31", "", "40.6275", "20.99", "Europe/Tirane"),
("832209", "Librazhd-Qendër", "", "AL", "8", "", "43", "13", "", "41.19694", "20.33556", "Europe/Tirane"),
("3183719", "Vlorë", "Влёра", "AL", "8", "", "51", "", "", "40.46667", "19.48972", "Europe/Tirane"),
("3183875", "Tirana", "Тирана", "AL", "8", "", "50", "", "", "41.3275", "19.81889", "Europe/Tirane"),
("3184081", "Shkodër", "Шкодер", "AL", "8", "", "49", "21", "", "42.06828", "19.51258", "Europe/Tirane"),
("3184099", "Shijak", "", "AL", "8", "", "42", "03", "", "41.34556", "19.56722", "Europe/Tirane"),
("3184197", "Selenicë", "", "AL", "8", "", "51", "27", "", "40.53056", "19.63583", "Europe/Tirane"),
("3184252", "Rrogozhinë", "", "AL", "8", "", "50", "33", "", "41.07639", "19.66528", "Europe/Tirane"),
("3184264", "Rrëshen", "", "AL", "8", "", "48", "16", "", "41.7675", "19.87556", "Europe/Tirane"),
("3184290", "Roskovec", "", "AL", "8", "", "44", "05", "", "40.7375", "19.70222", "Europe/Tirane"),
("3184388", "Pukë", "", "AL", "8", "", "49", "19", "", "42.04444", "19.89972", "Europe/Tirane"),
("3184497", "Peqin", "", "AL", "8", "", "43", "38", "", "41.04611", "19.75111", "Europe/Tirane"),
("3184517", "Patos Fshat", "", "AL", "8", "", "44", "", "", "40.64278", "19.65083", "Europe/Tirane"),
("3184806", "Mamurras", "", "AL", "8", "", "48", "35", "", "41.5775", "19.69222", "Europe/Tirane"),
("3184862", "Lushnjë", "Люшня", "AL", "8", "", "44", "14", "", "40.94194", "19.705", "Europe/Tirane"),
("3184935", "Lezhë", "Лежа", "AL", "8", "", "48", "", "", "41.78361", "19.64361", "Europe/Tirane"),
("3185012", "Laç", "Лак", "AL", "8", "", "48", "35", "", "41.63556", "19.71306", "Europe/Tirane"),
("3185060", "Kuçovë", "Кучова", "AL", "8", "", "40", "34", "", "40.80028", "19.91667", "Europe/Tirane"),
("3185082", "Krujë", "Круе", "AL", "8", "", "42", "10", "", "41.50917", "19.79278", "Europe/Tirane"),
("3185211", "Kavajë", "Кавайе", "AL", "8", "", "50", "33", "", "41.18556", "19.55694", "Europe/Tirane"),
("3185270", "Kamëz", "", "AL", "8", "", "50", "28", "", "41.38167", "19.76028", "Europe/Tirane"),
("3185638", "Fushë-Krujë", "", "AL", "8", "", "42", "10", "", "41.47833", "19.71778", "Europe/Tirane"),
("3185670", "Fier-Çifçi", "", "AL", "8", "", "44", "", "", "40.71667", "19.56667", "Europe/Tirane"),
("3185672", "Fier", "Фиери", "AL", "8", "", "44", "", "", "40.72389", "19.55611", "Europe/Tirane"),
("3185728", "Durrës", "Дуррес", "AL", "8", "", "42", "", "", "41.32306", "19.44139", "Europe/Tirane"),
("3185897", "Cërrik", "", "AL", "8", "", "43", "04", "", "41.03167", "19.97583", "Europe/Tirane"),
("3186084", "Berat", "Берат", "AL", "8", "", "40", "01", "", "40.70583", "19.95222", "Europe/Tirane"),
("3186145", "Ballsh", "", "AL", "8", "", "44", "37", "", "40.59889", "19.73472", "Europe/Tirane"),
("174710", "Yeghegnadzor", "", "AM", "51", "", "10", "", "", "39.76389", "45.33239", "Asia/Yerevan"),
("174725", "Vedi", "", "AM", "51", "", "02", "", "", "39.91388", "44.7251", "Asia/Yerevan"),
("174726", "Vayk’", "", "AM", "51", "", "10", "", "", "39.6889", "45.46668", "Asia/Yerevan"),
("174875", "Kapan", "Капан", "AM", "51", "", "08", "", "", "39.20755", "46.40576", "Asia/Yerevan"),
("174895", "Goris", "Горис", "AM", "51", "", "08", "", "", "39.51111", "46.34168", "Asia/Yerevan"),
("174972", "Hats’avan", "Ацаван", "AM", "51", "", "08", "", "", "39.46405", "45.97047", "Asia/Yerevan"),
("174979", "Artashat", "Арташат", "AM", "51", "", "02", "", "", "39.96144", "44.54447", "Asia/Yerevan"),
("174991", "Ararat", "Арарат", "AM", "51", "", "02", "", "", "39.83069", "44.70569", "Asia/Yerevan"),
("616052", "Yerevan", "Ереван", "AM", "51", "", "11", "", "", "40.18111", "44.51361", "Asia/Yerevan"),
("616062", "Ejmiatsin", "Вагаршапат", "AM", "51", "", "03", "", "", "40.16557", "44.29462", "Asia/Yerevan"),
("616065", "Yeghvard", "", "AM", "51", "", "05", "", "", "40.32507", "44.48608", "Asia/Yerevan"),
("616108", "Vardenis", "", "AM", "51", "", "04", "", "", "40.18329", "45.73053", "Asia/Yerevan"),
("616109", "Vardenik", "", "AM", "51", "", "04", "", "", "40.13348", "45.44311", "Asia/Yerevan"),
("616178", "Tashir", "", "AM", "51", "", "06", "", "", "41.12072", "44.28462", "Asia/Yerevan"),
("616194", "Step’anavan", "", "AM", "51", "", "06", "", "", "41.00995", "44.38531", "Asia/Yerevan"),
("616199", "Spitak", "Спитак", "AM", "51", "", "06", "", "", "40.83221", "44.26731", "Asia/Yerevan"),
("616250", "Sevan", "Севан", "AM", "51", "", "04", "", "", "40.5473", "44.94171", "Asia/Yerevan"),
("616255", "Sarukhan", "", "AM", "51", "", "04", "", "", "40.29169", "45.13068", "Asia/Yerevan"),
("616328", "Sardarapat", "", "AM", "51", "", "03", "", "", "40.13206", "44.00969", "Asia/Yerevan"),
("616333", "Noyemberyan", "", "AM", "51", "", "09", "", "", "41.17244", "44.99917", "Asia/Yerevan"),
("616361", "Noratus", "", "AM", "51", "", "04", "", "", "40.37793", "45.18048", "Asia/Yerevan"),
("616375", "Nerk’in Getashen", "", "AM", "51", "", "04", "", "", "40.14172", "45.27087", "Asia/Yerevan"),
("616417", "Metsamor", "", "AM", "51", "", "03", "", "", "40.07233", "44.29169", "Asia/Yerevan"),
("616435", "Masis", "Масис", "AM", "51", "", "02", "", "", "40.06542", "44.41618", "Asia/Yerevan"),
("616438", "Martuni", "", "AM", "51", "", "04", "", "", "40.13892", "45.30548", "Asia/Yerevan"),
("616530", "Vanadzor", "Кировакан", "AM", "51", "", "06", "", "", "40.80456", "44.4939", "Asia/Yerevan"),
("616576", "Karanlukh", "", "AM", "51", "", "04", "", "", "40.10444", "45.28972", "Asia/Yerevan"),
("616599", "Gavarr", "Гавар", "AM", "51", "", "04", "", "", "40.35398", "45.12386", "Asia/Yerevan"),
("616627", "Ijevan", "", "AM", "51", "", "09", "", "", "40.87877", "45.14851", "Asia/Yerevan"),
("616629", "Hrazdan", "Раздан", "AM", "51", "", "05", "", "", "40.49748", "44.7662", "Asia/Yerevan"),
("616631", "Armavir", "Армавир", "AM", "51", "", "03", "", "", "40.15446", "44.03815", "Asia/Yerevan"),
("616635", "Gyumri", "Гюмри", "AM", "51", "", "07", "", "", "40.7942", "43.84528", "Asia/Yerevan"),
("616697", "Garrni", "", "AM", "51", "", "05", "", "", "40.11931", "44.73442", "Asia/Yerevan"),
("616752", "Dilijan", "", "AM", "51", "", "09", "", "", "40.7417", "44.8501", "Asia/Yerevan"),
("616786", "Chambarak", "", "AM", "51", "", "04", "", "", "40.59655", "45.35498", "Asia/Yerevan"),
("616790", "Byureghavan", "", "AM", "51", "", "05", "", "", "40.31417", "44.59333", "Asia/Yerevan"),
("616802", "Berd", "", "AM", "51", "", "09", "", "", "40.88135", "45.38901", "Asia/Yerevan"),
("616877", "Ashtarak", "Аштарак", "AM", "51", "", "01", "", "", "40.2991", "44.36204", "Asia/Yerevan"),
("616953", "Aparan", "", "AM", "51", "", "01", "", "", "40.59323", "44.3589", "Asia/Yerevan"),
("616974", "Alaverdi", "", "AM", "51", "", "06", "", "", "41.09766", "44.67316", "Asia/Yerevan"),
("616989", "Akhuryan", "", "AM", "51", "", "07", "", "", "40.78003", "43.90027", "Asia/Yerevan"),
("617026", "Abovyan", "Абовян", "AM", "51", "", "05", "", "", "40.27368", "44.63348", "Asia/Yerevan"),
("145531", "Saurimo", "Сауримо", "AO", "24", "", "18", "", "", "-9.66078", "20.39155", "Africa/Luanda"),
("145724", "Lucapa", "Лукапа", "AO", "24", "", "17", "", "", "-8.41915", "20.74466", "Africa/Luanda"),
("876177", "Luau", "Луау", "AO", "24", "", "14", "", "", "-10.70727", "22.22466", "Africa/Luanda"),
("876233", "Léua", "", "AO", "24", "", "14", "", "", "-11.65", "20.45", "Africa/Luanda"),
("2236568", "Uíge", "Уиже", "AO", "24", "", "15", "", "", "-7.60874", "15.06131", "Africa/Luanda"),
("2236967", "Soio", "Сойу", "AO", "24", "", "16", "", "", "-6.1349", "12.36894", "Africa/Luanda"),
("2239001", "Nzeto", "Нзето", "AO", "24", "", "16", "", "", "-7.23116", "12.8666", "Africa/Luanda"),
("2239076", "N’dalatando", "", "AO", "24", "", "05", "", "", "-9.29782", "14.91162", "Africa/Luanda"),
("2239520", "Mbanza Congo", "", "AO", "24", "", "16", "", "", "-6.26703", "14.2401", "Africa/Luanda"),
("2239862", "Malanje", "Маланже", "AO", "24", "", "12", "2239859", "", "-9.54015", "16.34096", "Africa/Luanda"),
("2240449", "Luanda", "Луанда", "AO", "24", "", "20", "", "", "-8.83682", "13.23432", "Africa/Luanda"),
("2242001", "Caxito", "Кашито", "AO", "24", "", "19", "", "", "-8.57848", "13.66425", "Africa/Luanda"),
("2242885", "Camabatela", "", "AO", "24", "", "05", "", "", "-8.18812", "15.37495", "Africa/Luanda"),
("2243271", "Cabinda", "Кабинда", "AO", "24", "", "03", "", "", "-5.55", "12.2", "Africa/Luanda"),
("3345497", "Uacu Cungo", "", "AO", "24", "", "06", "", "", "-11.35669", "15.11719", "Africa/Luanda"),
("3346015", "Sumbe", "Сумбе", "AO", "24", "", "06", "", "", "-11.20605", "13.84371", "Africa/Luanda"),
("3346598", "Quibala", "", "AO", "24", "", "06", "", "", "-10.73366", "14.97995", "Africa/Luanda"),
("3346821", "Ondjiva", "", "AO", "24", "", "07", "", "", "-17.06667", "15.73333", "Africa/Luanda"),
("3347019", "Namibe", "Намибе", "AO", "24", "", "13", "", "", "-15.19611", "12.15222", "Africa/Luanda"),
("3347353", "Menongue", "Менонге", "AO", "24", "AO", "04", "", "", "-14.6585", "17.69099", "Africa/Luanda"),
("3347719", "Luena", "Луэна", "AO", "24", "", "14", "", "", "-11.78333", "19.91667", "Africa/Luanda"),
("3347762", "Lubango", "Лубанго", "AO", "24", "", "09", "", "", "-14.91717", "13.4925", "Africa/Luanda"),
("3347853", "Longonjo", "Логонжу", "AO", "24", "", "08", "", "", "-12.90667", "15.25333", "Africa/Luanda"),
("3347939", "Lobito", "Лобиту", "AO", "24", "", "01", "", "", "-12.3644", "13.53601", "Africa/Luanda"),
("3348078", "Cuito", "Куито", "AO", "24", "", "02", "", "", "-12.38333", "16.93333", "Africa/Luanda"),
("3348313", "Huambo", "Уамбо", "AO", "24", "", "08", "", "", "-12.77611", "15.73917", "Africa/Luanda"),
("3349580", "Chissamba", "", "AO", "24", "", "02", "", "", "-12.16667", "17.33333", "Africa/Luanda"),
("3350246", "Catumbela", "Катумбела", "AO", "24", "", "01", "", "", "-12.43002", "13.54677", "Africa/Luanda"),
("3350372", "Catabola", "Катабола", "AO", "24", "", "02", "", "", "-12.15", "17.28333", "Africa/Luanda"),
("3351014", "Camacupa", "Камакупа", "AO", "24", "", "02", "", "", "-12.01667", "17.48333", "Africa/Luanda"),
("3351024", "Caluquembe", "Калукембе", "AO", "24", "", "09", "", "", "-13.78333", "14.68333", "Africa/Luanda"),
("3351380", "Caconda", "", "AO", "24", "", "09", "", "", "-13.73333", "15.06667", "Africa/Luanda"),
("3351500", "Caála", "Каале", "AO", "24", "", "08", "", "", "-12.8525", "15.56056", "Africa/Luanda"),
("3351663", "Benguela", "Бенгела", "AO", "24", "", "01", "", "", "-12.57626", "13.40547", "Africa/Luanda"),
("9376229", "Chela", "", "AO", "24", "", "08", "3347879", "", "-12.30261", "15.43358", "Africa/Luanda"),
("3427213", "Zárate", "Зарате", "AR", "32", "", "01", "06882", "", "-34.09814", "-59.02858", "America/Argentina/Buenos_Aires"),
("3427388", "Villa Ocampo", "", "AR", "32", "", "21", "82049", "", "-28.48752", "-59.35515", "America/Argentina/Cordoba"),
("3427399", "Villa María Grande", "", "AR", "32", "", "08", "30084", "", "-31.66565", "-59.90182", "America/Argentina/Cordoba"),
("3427408", "Villa Lugano", "", "AR", "32", "", "07", "", "", "-34.67907", "-58.47263", "America/Argentina/Buenos_Aires"),
("3427420", "Villa Hernandarias", "", "AR", "32", "", "08", "30084", "", "-31.23101", "-59.985", "America/Argentina/Cordoba"),
("3427428", "Villaguay", "", "AR", "32", "", "08", "30113", "", "-31.8653", "-59.02689", "America/Argentina/Cordoba"),
("3427431", "Villa Gesell", "Вилья-Хесель", "AR", "32", "", "01", "06868", "", "-37.26394", "-56.97304", "America/Argentina/Buenos_Aires"),
("3427443", "Villa Elisa", "", "AR", "32", "", "08", "30008", "", "-32.1632", "-58.40082", "America/Argentina/Cordoba"),
("3427537", "Veinticinco de Mayo", "", "AR", "32", "", "14", "54119", "", "-27.37679", "-54.74312", "America/Argentina/Cordoba"),
("3427582", "Urdinarrain", "", "AR", "32", "", "08", "30056", "", "-32.68573", "-58.89323", "America/Argentina/Cordoba"),
("3427761", "Tigre", "Тигре", "AR", "32", "AR", "01", "06805", "", "-34.42603", "-58.57962", "America/Argentina/Buenos_Aires"),
("3427833", "Tandil", "Тандиль", "AR", "32", "", "01", "06791", "", "-37.32167", "-59.13316", "America/Argentina/Buenos_Aires"),
("3428068", "San Vicente", "", "AR", "32", "", "14", "54112", "", "-26.61667", "-54.13333", "America/Argentina/Cordoba"),
("3428071", "Santo Tomé", "", "AR", "32", "", "06", "18168", "", "-28.54939", "-56.04077", "America/Argentina/Cordoba"),
("3428079", "Santo Pipó", "", "AR", "32", "", "14", "54098", "", "-27.14132", "-55.40867", "America/Argentina/Cordoba"),
("3428182", "Santa Rosa", "", "AR", "32", "", "06", "18028", "", "-28.26318", "-58.11891", "America/Argentina/Cordoba"),
("3428287", "Santa Lucía", "", "AR", "32", "", "06", "18091", "", "-28.98746", "-59.10287", "America/Argentina/Cordoba"),
("3428359", "Santa Elena", "", "AR", "32", "", "08", "30070", "", "-30.94768", "-59.78696", "America/Argentina/Cordoba"),
("3428481", "San Salvador", "", "AR", "32", "", "08", "30088", "", "-31.62487", "-58.50524", "America/Argentina/Cordoba"),
("3428577", "San Pedro", "", "AR", "32", "", "14", "54112", "", "-26.62207", "-54.10842", "America/Argentina/Cordoba"),
("3428644", "San Miguel", "", "AR", "32", "", "06", "18154", "", "-27.99585", "-57.58964", "America/Argentina/Cordoba"),
("3428708", "San Luis del Palmar", "", "AR", "32", "", "06", "18140", "", "-27.5079", "-58.55454", "America/Argentina/Cordoba"),
("3428759", "San Lorenzo", "", "AR", "32", "", "06", "18126", "", "-28.13306", "-58.76733", "America/Argentina/Cordoba"),
("3428858", "San José de Feliciano", "", "AR", "32", "", "08", "30042", "", "-30.38452", "-58.75167", "America/Argentina/Cordoba"),
("3428928", "San José", "", "AR", "32", "", "14", "54007", "", "-27.76979", "-55.7826", "America/Argentina/Cordoba"),
("3428975", "San Javier", "", "AR", "32", "", "21", "82098", "", "-30.57781", "-59.9317", "America/Argentina/Cordoba"),
("3428992", "San Isidro", "", "AR", "32", "", "01", "06756", "", "-34.4721", "-58.52708", "America/Argentina/Buenos_Aires"),
("3429160", "San Clemente del Tuyú", "", "AR", "32", "", "01", "06420", "", "-36.35694", "-56.72351", "America/Argentina/Buenos_Aires"),
("3429403", "Saladas", "", "AR", "32", "", "06", "18126", "", "-28.25384", "-58.62591", "America/Argentina/Cordoba"),
("3429439", "Rosario del Tala", "", "AR", "32", "", "08", "30091", "", "-32.30286", "-59.14545", "America/Argentina/Cordoba"),
("3429576", "Retiro", "Ретиро", "AR", "32", "", "07", "", "", "-34.58333", "-58.38333", "America/Argentina/Buenos_Aires"),
("3429577", "Resistencia", "Ресистенсия", "AR", "32", "", "03", "22140", "", "-27.46056", "-58.98389", "America/Argentina/Cordoba"),
("3429594", "Reconquista", "Реконкиста", "AR", "32", "", "21", "82049", "", "-29.15", "-59.65", "America/Argentina/Cordoba"),
("3429652", "Quilmes", "Кильмес", "AR", "32", "", "01", "06658", "", "-34.72904", "-58.26374", "America/Argentina/Buenos_Aires"),
("3429713", "Puerto Vilelas", "", "AR", "32", "", "03", "22140", "", "-27.51414", "-58.93906", "America/Argentina/Cordoba"),
("3429721", "Puerto Tirol", "", "AR", "32", "", "03", "22077", "", "-27.37218", "-59.08206", "America/Argentina/Cordoba"),
("3429732", "Puerto Rico", "", "AR", "32", "", "14", "54077", "", "-26.79598", "-55.02402", "America/Argentina/Cordoba"),
("3429738", "Puerto Piray", "", "AR", "32", "", "14", "54084", "", "-26.46779", "-54.71476", "America/Argentina/Cordoba"),
("3429764", "Puerto Libertad", "", "AR", "32", "", "14", "54063", "", "-25.91641", "-54.62089", "America/Argentina/Cordoba"),
("3429777", "Puerto Iguazú", "Пуэрто-Игуасу", "AR", "32", "AR", "14", "54063", "", "-25.59912", "-54.57355", "America/Argentina/Cordoba"),
("3429786", "Puerto Esperanza", "", "AR", "32", "", "14", "54063", "", "-26.01517", "-54.67306", "America/Argentina/Cordoba"),
("3429790", "Puerto Eldorado", "", "AR", "32", "", "14", "54042", "", "-26.40843", "-54.69463", "America/Argentina/Cordoba"),
("3429866", "Presidencia de la Plaza", "", "AR", "32", "", "03", "22119", "", "-27.00147", "-59.84243", "America/Argentina/Cordoba"),
("3429886", "Posadas", "Посадас", "AR", "32", "", "14", "54028", "", "-27.36708", "-55.89608", "America/Argentina/Cordoba"),
("3429902", "Pontevedra", "", "AR", "32", "", "01", "06539", "", "-34.74785", "-58.70072", "America/Argentina/Buenos_Aires"),
("3429949", "Pirané", "", "AR", "32", "", "09", "34056", "", "-25.73239", "-59.10879", "America/Argentina/Cordoba"),
("3430029", "Perugorría", "", "AR", "32", "", "06", "18035", "", "-29.34132", "-58.61059", "America/Argentina/Cordoba"),
("3430104", "Paso de los Libres", "", "AR", "32", "", "06", "18119", "", "-29.71251", "-57.08771", "America/Argentina/Cordoba"),
("3430105", "Paso de la Patria", "", "AR", "32", "", "06", "18133", "", "-27.31676", "-58.57197", "America/Argentina/Cordoba"),
("3430178", "Panambí", "", "AR", "32", "", "14", "54091", "", "-27.72369", "-54.91515", "America/Argentina/Cordoba"),
("3430180", "Pampa del Indio", "", "AR", "32", "", "03", "22084", "", "-26.06468", "-59.91898", "America/Argentina/Cordoba"),
("3430186", "Palo Santo", "", "AR", "32", "", "09", "34056", "", "-25.56332", "-59.33781", "America/Argentina/Cordoba"),
("3430340", "Oberá", "Обера", "AR", "32", "", "14", "54091", "", "-27.48706", "-55.11994", "America/Argentina/Cordoba"),
("3430402", "Nuestra Señora del Rosario de Caa Catí", "", "AR", "32", "", "06", "18063", "", "-27.75072", "-57.62073", "America/Argentina/Cordoba"),
("3430443", "Necochea", "", "AR", "32", "", "01", "06581", "", "-38.5545", "-58.73961", "America/Argentina/Buenos_Aires"),
("3430545", "Morón", "", "AR", "32", "", "01", "06568", "", "-34.6509", "-58.61956", "America/Argentina/Buenos_Aires"),
("3430598", "Monte Caseros", "", "AR", "32", "", "06", "18112", "", "-30.25359", "-57.63626", "America/Argentina/Cordoba"),
("3430601", "Montecarlo", "", "AR", "32", "", "14", "54084", "", "-26.5662", "-54.757", "America/Argentina/Cordoba"),
("3430648", "Mocoretá", "", "AR", "32", "", "06", "18112", "", "-30.61891", "-57.96344", "America/Argentina/Cordoba"),
("3430708", "Mercedes", "", "AR", "32", "", "01", "06532", "", "-34.65145", "-59.43068", "America/Argentina/Buenos_Aires"),
("3430709", "Mercedes", "Мерседес", "AR", "32", "", "06", "18105", "", "-29.18416", "-58.07519", "America/Argentina/Cordoba"),
("3430760", "Mburucuyá", "", "AR", "32", "", "06", "18098", "", "-28.04532", "-58.22835", "America/Argentina/Cordoba"),
("3430857", "Margarita Belén", "", "AR", "32", "", "03", "22126", "", "-27.2616", "-58.97219", "America/Argentina/Cordoba"),
("3430863", "Mar del Plata", "Мар-дель-Плата", "AR", "32", "", "01", "06357", "", "-38.00228", "-57.55754", "America/Argentina/Buenos_Aires"),
("3430940", "Malabrigo", "", "AR", "32", "", "21", "82049", "", "-29.34636", "-59.96957", "America/Argentina/Cordoba"),
("3430968", "Maciá", "", "AR", "32", "", "08", "30091", "", "-32.1722", "-59.39947", "America/Argentina/Cordoba"),
("3430988", "Luján", "Лухан", "AR", "32", "", "01", "06497", "", "-34.57028", "-59.105", "America/Argentina/Buenos_Aires"),
("3431606", "Las Toscas", "", "AR", "32", "", "21", "82049", "", "-28.3529", "-59.25795", "America/Argentina/Cordoba"),
("3431916", "Larroque", "", "AR", "32", "", "08", "30056", "", "-33.03595", "-59.00125", "America/Argentina/Cordoba"),
("3432043", "La Plata", "Ла-Плата", "AR", "32", "", "01", "06441", "", "-34.92145", "-57.95453", "America/Argentina/Buenos_Aires"),
("3432079", "La Paz", "", "AR", "32", "", "08", "30070", "", "-30.74485", "-59.64566", "America/Argentina/Cordoba"),
("3432355", "La Leonesa", "", "AR", "32", "", "03", "22014", "", "-27.03786", "-58.70347", "America/Argentina/Cordoba"),
("3432760", "La Cruz", "", "AR", "32", "", "06", "18147", "", "-29.17443", "-56.64326", "America/Argentina/Cordoba"),
("3433349", "Jardín América", "", "AR", "32", "", "14", "54098", "", "-27.04346", "-55.22698", "America/Argentina/Cordoba"),
("3433363", "Itatí", "", "AR", "32", "", "06", "18077", "", "-27.27043", "-58.24458", "America/Argentina/Cordoba"),
("3433513", "Ibarreta", "", "AR", "32", "", "09", "34035", "", "-25.21438", "-59.85851", "America/Argentina/Cordoba"),
("3433658", "Gualeguaychú", "Гуалегуайчу", "AR", "32", "", "08", "30056", "", "-33.00937", "-58.51722", "America/Argentina/Cordoba"),
("3433663", "Gualeguay", "", "AR", "32", "", "08", "30049", "", "-33.14156", "-59.30966", "America/Argentina/Cordoba"),
("3433715", "Goya", "Гойя", "AR", "32", "", "06", "18070", "", "-29.14395", "-59.2651", "America/Argentina/Cordoba"),
("3433743", "Gobernador Roca", "", "AR", "32", "", "14", "54098", "", "-27.18636", "-55.46433", "America/Argentina/Cordoba"),
("3433753", "Gobernador Ingeniero Valentín Virasoro", "", "AR", "32", "", "06", "18168", "", "-28.05", "-56.03333", "America/Argentina/Cordoba"),
("3433803", "General José de San Martín", "", "AR", "32", "", "03", "22084", "", "-26.53743", "-59.34158", "America/Argentina/Cordoba"),
("3433836", "Garupá", "", "AR", "32", "", "14", "54028", "", "-27.48171", "-55.82921", "America/Argentina/Cordoba"),
("3433839", "Garuhapé", "", "AR", "32", "", "14", "54077", "", "-26.81768", "-54.95665", "America/Argentina/Cordoba"),
("3433899", "Formosa", "Формоза", "AR", "32", "", "09", "34014", "", "-26.17753", "-58.17814", "America/Argentina/Cordoba"),
("3433901", "Fontana", "", "AR", "32", "", "03", "22140", "", "-27.41813", "-59.02392", "America/Argentina/Cordoba"),
("3433956", "Federal", "", "AR", "32", "", "08", "30035", "", "-30.95465", "-58.78326", "America/Argentina/Cordoba"),
("3433959", "Federación", "", "AR", "32", "", "08", "30028", "", "-31.00621", "-57.89962", "America/Argentina/Cordoba"),
("3434095", "Esquina", "", "AR", "32", "", "06", "18049", "", "-30.01444", "-59.52719", "America/Argentina/Cordoba"),
("3434291", "El Soberbio", "", "AR", "32", "", "14", "54056", "", "-27.29847", "-54.19877", "America/Argentina/Cordoba"),
("3434731", "El Colorado", "", "AR", "32", "", "09", "34056", "", "-26.30808", "-59.37291", "America/Argentina/Cordoba"),
("3434932", "El Alcázar", "", "AR", "32", "", "14", "54077", "", "-26.71459", "-54.81523", "America/Argentina/Cordoba"),
("3434995", "Dos de Mayo", "", "AR", "32", "", "14", "54014", "", "-27.02277", "-54.68669", "America/Argentina/Cordoba"),
("3435038", "Dolores", "", "AR", "32", "", "01", "06238", "", "-36.31321", "-57.67918", "America/Argentina/Buenos_Aires"),
("3435103", "Curuzú Cuatiá", "", "AR", "32", "", "06", "18035", "", "-29.79171", "-58.0546", "America/Argentina/Cordoba"),
("3435217", "Corrientes", "Корриентес", "AR", "32", "", "06", "18021", "", "-27.4806", "-58.8341", "America/Argentina/Cordoba"),
("3435261", "Concordia", "Конкордия", "AR", "32", "", "08", "30015", "", "-31.39296", "-58.02089", "America/Argentina/Cordoba"),
("3435264", "Concepción del Uruguay", "Консепсьон-дель-Уругвай", "AR", "32", "", "08", "30098", "", "-32.48249", "-58.23722", "America/Argentina/Cordoba"),
("3435266", "Concepción de la Sierra", "", "AR", "32", "", "14", "54035", "", "-27.98311", "-55.52031", "America/Argentina/Cordoba"),
("3435283", "Comandante Fontana", "", "AR", "32", "", "09", "34035", "", "-25.33453", "-59.68212", "America/Argentina/Cordoba"),
("3435290", "Colonia Wanda", "", "AR", "32", "", "14", "54063", "", "-25.97408", "-54.42806", "America/Argentina/Cordoba"),
("3435344", "Colonia Aurora", "", "AR", "32", "", "14", "54119", "", "-27.47428", "-54.52498", "America/Argentina/Cordoba"),
("3435356", "Colegiales", "", "AR", "32", "", "07", "", "", "-34.57365", "-58.44924", "America/Argentina/Buenos_Aires"),
("3435364", "Clorinda", "", "AR", "32", "", "09", "34049", "", "-25.28481", "-57.71851", "America/Argentina/Cordoba"),
("3435486", "Chajarí", "", "AR", "32", "", "08", "30028", "", "-30.75048", "-57.97962", "America/Argentina/Cordoba"),
("3435532", "Cerro Azul", "", "AR", "32", "", "14", "54070", "", "-27.6331", "-55.4962", "America/Argentina/Cordoba"),
("3435701", "Capioví", "", "AR", "32", "", "14", "54077", "", "-26.92998", "-55.06084", "America/Argentina/Cordoba"),
("3435734", "Candelaria", "", "AR", "32", "", "14", "54021", "", "-27.4595", "-55.74536", "America/Argentina/Cordoba"),
("3435750", "Campo Viera", "", "AR", "32", "", "14", "54091", "", "-27.38333", "-55.03333", "America/Argentina/Cordoba"),
("3435765", "Campo Ramón", "", "AR", "32", "", "14", "54091", "", "-27.46108", "-55.01901", "America/Argentina/Cordoba"),
("3435789", "Campo Grande", "", "AR", "32", "", "14", "54014", "", "-27.2077", "-54.97977", "America/Argentina/Cordoba"),
("3435810", "Campana", "Кампана", "AR", "32", "", "01", "06126", "", "-34.16874", "-58.95914", "America/Argentina/Buenos_Aires"),
("3435910", "Buenos Aires", "Буэнос-Айрес", "AR", "32", "", "07", "", "", "-34.61315", "-58.37723", "America/Argentina/Buenos_Aires"),
("3435966", "Bovril", "", "AR", "32", "", "08", "30070", "", "-31.34311", "-59.44512", "America/Argentina/Cordoba"),
("3436030", "Bernardo de Irigoyen", "", "AR", "32", "", "14", "54049", "", "-26.2552", "-53.64581", "America/Argentina/Cordoba"),
("3436124", "Barranqueras", "", "AR", "32", "", "03", "22140", "", "-27.48132", "-58.93925", "America/Argentina/Cordoba"),
("3436199", "Azul", "Азул", "AR", "32", "", "01", "06049", "", "-36.77698", "-59.85854", "America/Argentina/Buenos_Aires"),
("3436230", "Avellaneda", "", "AR", "32", "", "21", "82049", "", "-29.11761", "-59.65834", "America/Argentina/Cordoba"),
("3436287", "Aristóbulo del Valle", "", "AR", "32", "", "14", "54014", "", "-27.09625", "-54.89626", "America/Argentina/Cordoba"),
("3436370", "Alvear", "", "AR", "32", "", "06", "18056", "", "-29.09683", "-56.55043", "America/Argentina/Cordoba"),
("3436448", "Alba Posse", "", "AR", "32", "", "14", "54119", "", "-27.56978", "-54.68262", "America/Argentina/Cordoba"),
("3832132", "Zapala", "Сапала", "AR", "32", "", "15", "58112", "", "-38.89916", "-70.05442", "America/Argentina/Salta"),
("3832189", "Yuto", "", "AR", "32", "", "10", "38035", "", "-23.64342", "-64.47194", "America/Argentina/Jujuy"),
("3832260", "Yerba Buena", "", "AR", "32", "", "24", "90119", "", "-26.81667", "-65.31667", "America/Argentina/Tucuman"),
("3832376", "Yacimiento Río Turbio", "", "AR", "32", "", "20", "78021", "", "-51.57321", "-72.3508", "America/Argentina/Rio_Gallegos"),
("3832647", "Villa Regina", "", "AR", "32", "", "16", "62042", "", "-39.1", "-67.06667", "America/Argentina/Salta"),
("3832653", "Villa Paula de Sarmiento", "", "AR", "32", "", "18", "70042", "", "-31.4933", "-68.53838", "America/Argentina/San_Juan"),
("3832658", "Villa Ojo de Agua", "", "AR", "32", "", "22", "86126", "", "-29.50003", "-63.69377", "America/Argentina/Cordoba"),
("3832662", "Villa Nueva", "", "AR", "32", "", "05", "14042", "", "-32.43293", "-63.24763", "America/Argentina/Cordoba"),
("3832694", "Villa María", "", "AR", "32", "", "05", "14042", "", "-32.40751", "-63.24016", "America/Argentina/Cordoba"),
("3832711", "Villa La Angostura", "", "AR", "32", "", "15", "58070", "", "-40.76173", "-71.64631", "America/Argentina/Salta"),
("3832719", "Villa Huidobro", "", "AR", "32", "", "05", "14035", "", "-34.83826", "-64.58686", "America/Argentina/Cordoba"),
("3832734", "Villa General Belgrano", "", "AR", "32", "", "05", "14007", "", "-31.97542", "-64.5559", "America/Argentina/Cordoba"),
("3832756", "Villa Dolores", "", "AR", "32", "", "05", "14133", "", "-31.94585", "-65.18958", "America/Argentina/Cordoba"),
("3832759", "Villa de Soto", "", "AR", "32", "", "05", "14028", "", "-30.85523", "-64.99947", "America/Argentina/Cordoba"),
("3832763", "Villa del Totoral", "", "AR", "32", "", "05", "14168", "", "-30.81667", "-63.71667", "America/Argentina/Cordoba"),
("3832778", "Villa Constitución", "", "AR", "32", "", "21", "82028", "", "-33.22778", "-60.3297", "America/Argentina/Cordoba"),
("3832783", "Chañar Ladeado", "", "AR", "32", "", "21", "82014", "", "-33.32524", "-62.03831", "America/Argentina/Cordoba"),
("3832791", "Villa Carlos Paz", "Карлос-Паз", "AR", "32", "", "05", "14091", "", "-31.42414", "-64.49778", "America/Argentina/Cordoba"),
("3832793", "Villa Cañás", "", "AR", "32", "", "21", "82042", "", "-34.00565", "-61.60757", "America/Argentina/Cordoba"),
("3832797", "Villa Berthet", "", "AR", "32", "", "03", "22147", "", "-27.29174", "-60.41263", "America/Argentina/Cordoba"),
("3832811", "Villa Ángela", "", "AR", "32", "", "03", "22098", "", "-27.57383", "-60.71526", "America/Argentina/Cordoba"),
("3832815", "Villa Allende", "", "AR", "32", "", "05", "14021", "", "-31.29458", "-64.29538", "America/Argentina/Cordoba"),
("3832899", "Viedma", "Вьедма", "AR", "32", "", "16", "62007", "", "-40.81345", "-62.99668", "America/Argentina/Salta"),
("3832917", "Vicuña Mackenna", "", "AR", "32", "", "05", "14098", "", "-33.91965", "-64.39215", "America/Argentina/Cordoba"),
("3832923", "Victorica", "", "AR", "32", "", "11", "42098", "", "-36.21505", "-65.43586", "America/Argentina/Salta"),
("3832934", "Victoria", "Виктория", "AR", "32", "", "08", "30105", "", "-32.61841", "-60.15478", "America/Argentina/Cordoba"),
("3832959", "Viale", "", "AR", "32", "", "08", "30084", "", "-31.86782", "-60.00722", "America/Argentina/Cordoba"),
("3833027", "Vera", "", "AR", "32", "", "21", "82133", "", "-29.4593", "-60.21261", "America/Argentina/Cordoba"),
("3833062", "Venado Tuerto", "Неукен", "AR", "32", "", "21", "82042", "", "-33.74556", "-61.96885", "America/Argentina/Cordoba"),
("3833111", "Veinticinco de Mayo", "", "AR", "32", "", "11", "42112", "", "-37.7741", "-67.71638", "America/Argentina/Salta"),
("3833112", "Veinticinco de Mayo", "", "AR", "32", "", "01", "06854", "", "-35.4323", "-60.17271", "America/Argentina/Buenos_Aires"),
("3833211", "Valle Hermoso", "", "AR", "32", "", "05", "14091", "", "-31.11732", "-64.48084", "America/Argentina/Cordoba"),
("3833367", "Ushuaia", "Ушуая", "AR", "32", "", "23", "94014", "", "-54.8", "-68.3", "America/Argentina/Ushuaia"),
("3833412", "Unquillo", "", "AR", "32", "", "05", "14021", "", "-31.23073", "-64.31615", "America/Argentina/Cordoba"),
("3833675", "Trevelin", "", "AR", "32", "", "04", "26035", "", "-43.0858", "-71.46386", "America/Argentina/Catamarca"),
("3833794", "Tres Isletas", "", "AR", "32", "", "03", "22091", "", "-26.34067", "-60.43207", "America/Argentina/Cordoba"),
("3833859", "Tres Arroyos", "", "AR", "32", "", "01", "06833", "", "-38.37394", "-60.27978", "America/Argentina/Buenos_Aires"),
("3833883", "Trelew", "", "AR", "32", "", "04", "26077", "", "-43.24895", "-65.30505", "America/Argentina/Catamarca"),
("3833947", "Trancas", "", "AR", "32", "", "24", "90112", "", "-26.21575", "-65.28492", "America/Argentina/Tucuman"),
("3833995", "Totoras", "", "AR", "32", "", "21", "82056", "", "-32.5844", "-61.16852", "America/Argentina/Cordoba"),
("3834048", "Tostado", "", "AR", "32", "", "21", "82077", "", "-29.23202", "-61.76917", "America/Argentina/Cordoba"),
("3834361", "Tinogasta", "", "AR", "32", "", "02", "10105", "", "-28.06319", "-67.56488", "America/Argentina/Catamarca"),
("3834397", "Tilisarao", "", "AR", "32", "", "19", "74028", "", "-32.73292", "-65.29109", "America/Argentina/San_Luis"),
("3834403", "Tilcara", "", "AR", "32", "", "10", "38094", "", "-23.57757", "-65.3509", "America/Argentina/Jujuy"),
("3834502", "Termas de Río Hondo", "", "AR", "32", "", "22", "86147", "", "-27.49362", "-64.85972", "America/Argentina/Cordoba"),
("3834601", "Tartagal", "Тартагал", "AR", "32", "", "17", "66056", "", "-22.51637", "-63.80131", "America/Argentina/Salta"),
("3834665", "Tancacha", "", "AR", "32", "", "05", "14161", "", "-32.24309", "-63.9807", "America/Argentina/Cordoba"),
("3834813", "Tafí Viejo", "", "AR", "32", "", "24", "90105", "", "-26.73201", "-65.25921", "America/Argentina/Tucuman"),
("3834843", "Taco Pozo", "", "AR", "32", "", "03", "22007", "", "-25.61667", "-63.28333", "America/Argentina/Cordoba"),
("3834961", "Suncho Corral", "", "AR", "32", "", "22", "86098", "", "-27.93357", "-63.42938", "America/Argentina/Cordoba"),
("3834971", "Sunchales", "", "AR", "32", "", "21", "82021", "", "-30.94404", "-61.56148", "America/Argentina/Cordoba"),
("3835238", "Simoca", "", "AR", "32", "", "24", "90091", "", "-27.26272", "-65.35647", "America/Argentina/Tucuman"),
("3835297", "Sierra Grande", "", "AR", "32", "", "16", "62077", "", "-41.60603", "-65.35574", "America/Argentina/Salta"),
("3835372", "Senillosa", "", "AR", "32", "", "15", "58035", "", "-39.01412", "-68.43281", "America/Argentina/Salta"),
("3835695", "Sastre", "", "AR", "32", "", "21", "82126", "", "-31.76762", "-61.82887", "America/Argentina/Cordoba"),
("3835710", "Sarmiento", "", "AR", "32", "", "04", "26091", "", "-45.58815", "-69.06996", "America/Argentina/Catamarca"),
("3835793", "Santo Tomé", "", "AR", "32", "", "21", "82063", "", "-31.66274", "-60.7653", "America/Argentina/Cordoba"),
("3835869", "Santiago del Estero", "Сантьяго-дель-Эстеро", "AR", "32", "", "22", "86049", "", "-27.79511", "-64.26149", "America/Argentina/Cordoba"),
("3835921", "Santa Sylvina", "", "AR", "32", "", "03", "22043", "", "-27.83261", "-61.13747", "America/Argentina/Cordoba"),
("3835938", "Santa Rosa de Río Primero", "", "AR", "32", "", "05", "14105", "", "-31.15231", "-63.40191", "America/Argentina/Cordoba"),
("3835943", "Santa Rosa de Calamuchita", "", "AR", "32", "", "05", "14007", "", "-32.06905", "-64.53631", "America/Argentina/Cordoba"),
("3835994", "Santa Rosa", "Санта-Роса", "AR", "32", "", "11", "42021", "", "-36.61667", "-64.28333", "America/Argentina/Salta"),
("3836194", "Santa Lucía", "", "AR", "32", "", "18", "70098", "", "-31.53987", "-68.49503", "America/Argentina/San_Juan"),
("3836277", "Santa Fe de la Vera Cruz", "Санта-Фе", "AR", "32", "", "21", "82063", "", "-31.63333", "-60.7", "America/Argentina/Cordoba"),
("3836564", "San Salvador de Jujuy", "Сан Сальвадор де Жужуй", "AR", "32", "", "10", "38021", "", "-24.19457", "-65.29712", "America/Argentina/Jujuy"),
("3836620", "San Ramón de la Nueva Orán", "", "AR", "32", "", "17", "66126", "", "-23.13705", "-64.32426", "America/Argentina/Salta"),
("3836669", "San Rafael", "Сан-Рафаэль", "AR", "32", "", "13", "50105", "", "-34.61772", "-68.33007", "America/Argentina/Mendoza"),
("3836772", "San Pedro", "", "AR", "32", "", "10", "38063", "", "-24.23127", "-64.86614", "America/Argentina/Jujuy"),
("3836846", "San Nicolás de los Arroyos", "", "AR", "32", "", "01", "06763", "", "-33.33578", "-60.22523", "America/Argentina/Buenos_Aires"),
("3836873", "San Miguel de Tucumán", "Сан-Мигель-де-Тукуман", "AR", "32", "", "24", "90084", "", "-26.82414", "-65.2226", "America/Argentina/Tucuman"),
("3836951", "San Martín de los Andes", "Сан-Мартин-Де-Лос-Андес", "AR", "32", "", "15", "58056", "", "-40.15789", "-71.35337", "America/Argentina/Salta"),
("3836992", "San Martín", "", "AR", "32", "", "13", "50098", "", "-33.08103", "-68.46814", "America/Argentina/Mendoza"),
("3836993", "San Martín", "", "AR", "32", "", "18", "70091", "", "-31.42957", "-68.50065", "America/Argentina/San_Juan"),
("3837056", "San Luis", "Сан-Луис", "AR", "32", "", "19", "74056", "", "-33.29501", "-66.33563", "America/Argentina/San_Luis"),
("3837124", "San Justo", "", "AR", "32", "", "21", "82112", "", "-30.78913", "-60.59189", "America/Argentina/Cordoba"),
("3837213", "San Juan", "Сан-Хуан", "AR", "32", "", "18", "70028", "", "-31.5375", "-68.53639", "America/Argentina/San_Juan"),
("3837240", "San José de Jáchal", "", "AR", "32", "", "18", "70056", "", "-30.24057", "-68.74693", "America/Argentina/San_Juan"),
("3837441", "San Jorge", "", "AR", "32", "", "21", "82126", "", "-31.89618", "-61.85984", "America/Argentina/Cordoba"),
("3837675", "San Francisco", "", "AR", "32", "", "05", "14140", "", "-31.42797", "-62.08266", "America/Argentina/Cordoba"),
("3837702", "San Fernando del Valle de Catamarca", "Сан-Фернандо-дель-Валье-де-Катамарка", "AR", "32", "", "02", "10049", "", "-28.46957", "-65.78524", "America/Argentina/Catamarca"),
("3837823", "San Cristóbal", "", "AR", "32", "", "21", "82091", "", "-30.31053", "-61.23724", "America/Argentina/Cordoba"),
("3837857", "San Carlos Centro", "", "AR", "32", "", "21", "82070", "", "-31.72864", "-61.09192", "America/Argentina/Cordoba"),
("3837943", "San Bernardo", "", "AR", "32", "", "03", "22112", "", "-27.28782", "-60.71252", "America/Argentina/Cordoba"),
("3837956", "San Benito", "", "AR", "32", "", "08", "30084", "", "-31.78371", "-60.44156", "America/Argentina/Cordoba"),
("3837980", "San Antonio Oeste", "", "AR", "32", "", "16", "62077", "", "-40.73193", "-64.94769", "America/Argentina/Salta"),
("3838158", "San Agustín de Valle Fértil", "", "AR", "32", "", "18", "70119", "", "-30.63353", "-67.46821", "America/Argentina/San_Juan"),
("3838201", "Sampacho", "", "AR", "32", "", "05", "14098", "", "-33.3839", "-64.72211", "America/Argentina/Cordoba"),
("3838233", "Salta", "Сальта", "AR", "32", "", "17", "66028", "", "-24.7859", "-65.41166", "America/Argentina/Salta"),
("3838235", "Salsipuedes", "", "AR", "32", "", "05", "14021", "", "-31.13725", "-64.29589", "America/Argentina/Cordoba"),
("3838506", "Rufino", "", "AR", "32", "", "21", "82042", "", "-34.26827", "-62.71262", "America/Argentina/Cordoba"),
("3838583", "Rosario", "Росарио", "AR", "32", "", "21", "82084", "", "-32.94682", "-60.63932", "America/Argentina/Cordoba"),
("3838638", "Roldán", "", "AR", "32", "", "21", "82119", "", "-32.89846", "-60.90681", "America/Argentina/Cordoba"),
("3838793", "Río Tercero", "", "AR", "32", "", "05", "14161", "", "-32.17301", "-64.11405", "America/Argentina/Cordoba"),
("3838797", "Río Segundo", "", "AR", "32", "", "05", "14119", "", "-31.6526", "-63.9099", "America/Argentina/Cordoba"),
("3838859", "Río Gallegos", "Рио-Гальегос", "AR", "32", "", "20", "78021", "", "-51.62261", "-69.21813", "America/Argentina/Rio_Gallegos"),
("3838874", "Río Cuarto", "Рио-Куарто", "AR", "32", "", "05", "14098", "", "-33.13067", "-64.34992", "America/Argentina/Cordoba"),
("3838902", "Río Ceballos", "", "AR", "32", "", "05", "14021", "", "-31.16486", "-64.32241", "America/Argentina/Cordoba"),
("3839262", "Recreo", "", "AR", "32", "", "21", "82063", "", "-31.49076", "-60.73299", "America/Argentina/Cordoba"),
("3839263", "Recreo", "", "AR", "32", "", "02", "10070", "", "-29.28184", "-65.06096", "America/Argentina/Catamarca"),
("3839282", "Realicó", "", "AR", "32", "", "11", "42133", "", "-35.03658", "-64.2447", "America/Argentina/Salta"),
("3839307", "Rawson", "Роусон", "AR", "32", "", "04", "26077", "", "-43.30016", "-65.10228", "America/Argentina/Catamarca"),
("3839479", "Rafaela", "Рафаэла", "AR", "32", "", "21", "82021", "", "-31.25033", "-61.4867", "America/Argentina/Cordoba"),
("3839482", "Rada Tilly", "", "AR", "32", "AR", "04", "", "", "-45.93333", "-67.53333", "America/Argentina/Catamarca"),
("3839490", "Quitilipi", "", "AR", "32", "", "03", "22133", "", "-26.86913", "-60.21683", "America/Argentina/Cordoba"),
("3839565", "Quimilí", "", "AR", "32", "", "22", "86119", "", "-27.63333", "-62.41667", "America/Argentina/Cordoba"),
("3839982", "Punta Alta", "Пунта-Альта", "AR", "32", "", "01", "06182", "", "-38.87588", "-62.07359", "America/Argentina/Buenos_Aires"),
("3840082", "San Julián", "", "AR", "32", "", "20", "78042", "", "-49.30554", "-67.72743", "America/Argentina/Rio_Gallegos"),
("3840092", "Puerto Madryn", "Пуэрто-Мадрин", "AR", "32", "", "04", "26007", "", "-42.7692", "-65.03851", "America/Argentina/Catamarca"),
("3840104", "Puerto Deseado", "", "AR", "32", "", "20", "78014", "", "-47.75034", "-65.89382", "America/Argentina/Rio_Gallegos"),
("3840300", "Presidencia Roque Sáenz Peña", "", "AR", "32", "", "03", "22021", "", "-26.78522", "-60.43876", "America/Argentina/Cordoba"),
("3840470", "Pozo del Molle", "", "AR", "32", "", "05", "14119", "", "-32.0186", "-62.91984", "America/Argentina/Cordoba"),
("3840860", "Pocito", "", "AR", "32", "", "18", "70070", "", "-31.68333", "-68.58333", "America/Argentina/San_Juan"),
("3840885", "Plottier", "", "AR", "32", "", "15", "58035", "", "-38.96667", "-68.23333", "America/Argentina/Salta"),
("3840896", "Plaza Huincul", "", "AR", "32", "", "15", "58035", "", "-38.92598", "-69.20863", "America/Argentina/Salta"),
("3841149", "Pilar", "", "AR", "32", "", "05", "14119", "", "-31.6789", "-63.87964", "America/Argentina/Cordoba"),
("3841309", "Pico Truncado", "", "AR", "32", "", "20", "78014", "", "-46.7949", "-67.95731", "America/Argentina/Rio_Gallegos"),
("3841490", "Pergamino", "Пергамино", "AR", "32", "", "01", "06623", "", "-33.88995", "-60.57357", "America/Argentina/Buenos_Aires"),
("3841500", "Pérez", "", "AR", "32", "", "21", "82084", "", "-32.99835", "-60.76791", "America/Argentina/Cordoba"),
("3841956", "Paraná", "Парана", "AR", "32", "", "08", "30084", "", "-31.73197", "-60.5238", "America/Argentina/Cordoba"),
("3842142", "Pampa del Infierno", "", "AR", "32", "", "03", "22007", "", "-26.50517", "-61.17436", "America/Argentina/Cordoba"),
("3842190", "Palpalá", "", "AR", "32", "", "10", "38042", "", "-24.25647", "-65.21163", "America/Argentina/Jujuy"),
("3842268", "Palma Sola", "", "AR", "32", "", "10", "38070", "", "-23.96336", "-64.29872", "America/Argentina/Jujuy"),
("3842621", "Oncativo", "", "AR", "32", "", "05", "14119", "", "-31.91353", "-63.68201", "America/Argentina/Cordoba"),
("3842662", "Oliva", "", "AR", "32", "", "05", "14161", "", "-32.04158", "-63.56978", "America/Argentina/Cordoba"),
("3842670", "Olavarría", "Олаваррия", "AR", "32", "", "01", "06595", "", "-36.89272", "-60.32254", "America/Argentina/Buenos_Aires"),
("3842881", "Nueve de Julio", "Нев-де-Хулио", "AR", "32", "", "01", "06588", "", "-35.44437", "-60.88313", "America/Argentina/Buenos_Aires"),
("3842882", "Nueve de Julio", "", "AR", "32", "", "18", "70063", "", "-31.66914", "-68.39023", "America/Argentina/San_Juan"),
("3843123", "Neuquén", "Неукен", "AR", "32", "", "15", "58035", "", "-38.95161", "-68.0591", "America/Argentina/Salta"),
("3843619", "Morteros", "", "AR", "32", "", "05", "14140", "", "-30.71164", "-61.99862", "America/Argentina/Cordoba"),
("3843803", "Monteros", "", "AR", "32", "", "24", "90070", "", "-27.16741", "-65.49832", "America/Argentina/Tucuman"),
("3843830", "Monte Maíz", "", "AR", "32", "", "05", "14182", "", "-33.20462", "-62.60085", "America/Argentina/Cordoba"),
("3843871", "Monte Cristo", "", "AR", "32", "", "05", "14021", "", "-31.34312", "-63.94437", "America/Argentina/Cordoba"),
("3843881", "Monte Buey", "", "AR", "32", "", "05", "14063", "", "-32.91642", "-62.45669", "America/Argentina/Cordoba"),
("3844229", "Mina Clavero", "", "AR", "32", "", "05", "14126", "", "-31.72101", "-65.00619", "America/Argentina/Cordoba"),
("3844377", "Merlo", "", "AR", "32", "", "19", "74049", "", "-32.34288", "-65.01396", "America/Argentina/San_Luis"),
("3844421", "Mendoza", "Мендоса", "AR", "32", "", "13", "50028", "", "-32.89084", "-68.82717", "America/Argentina/Mendoza"),
("3844899", "Marcos Juárez", "", "AR", "32", "", "05", "14063", "", "-32.6978", "-62.10672", "America/Argentina/Cordoba"),
("3845073", "Malvinas Argentinas", "", "AR", "32", "", "05", "14014", "", "-31.38333", "-64.06667", "America/Argentina/Cordoba"),
("3845202", "Malagueño", "", "AR", "32", "", "05", "14147", "", "-31.46467", "-64.3584", "America/Argentina/Cordoba"),
("3845330", "Machagai", "", "AR", "32", "", "03", "22168", "", "-26.92614", "-60.04955", "America/Argentina/Cordoba"),
("3846175", "Los Frentones", "", "AR", "32", "", "03", "22007", "", "-26.4077", "-61.41367", "America/Argentina/Cordoba"),
("3846514", "Los Altos", "", "AR", "32", "", "02", "10098", "", "-28.04845", "-65.49945", "America/Argentina/Catamarca"),
("3846864", "Lincoln", "", "AR", "32", "", "01", "06469", "", "-34.86649", "-61.5302", "America/Argentina/Buenos_Aires"),
("3846915", "Libertador General San Martín", "", "AR", "32", "", "10", "38035", "", "-23.80644", "-64.78757", "America/Argentina/Jujuy"),
("3846991", "Leones", "", "AR", "32", "", "05", "14063", "", "-32.66174", "-62.29678", "America/Argentina/Cordoba"),
("3847482", "La Toma", "", "AR", "32", "", "19", "74021", "", "-33.05258", "-65.62385", "America/Argentina/San_Luis"),
("3847613", "Las Varillas", "", "AR", "32", "", "05", "14140", "", "-31.87208", "-62.71946", "America/Argentina/Cordoba"),
("3847836", "Las Rosas", "", "AR", "32", "", "21", "82007", "", "-32.47661", "-61.58041", "America/Argentina/Cordoba"),
("3847933", "Las Parejas", "", "AR", "32", "", "21", "82007", "", "-32.68478", "-61.51637", "America/Argentina/Cordoba"),
("3848164", "Las Lomitas", "", "AR", "32", "", "09", "34035", "", "-24.70955", "-60.59303", "America/Argentina/Cordoba"),
("3848209", "Las Lajitas", "", "AR", "32", "", "17", "66007", "", "-24.68333", "-64.25", "America/Argentina/Salta"),
("3848343", "Las Higueras", "", "AR", "32", "", "05", "14098", "", "-33.09231", "-64.28899", "America/Argentina/Cordoba"),
("3848353", "Las Heras", "", "AR", "32", "", "20", "78014", "", "-46.54186", "-68.93593", "America/Argentina/Rio_Gallegos"),
("3848687", "Las Breñas", "", "AR", "32", "", "03", "22105", "", "-27.08966", "-61.08161", "America/Argentina/Cordoba"),
("3848950", "La Rioja", "Ла-Риоха", "AR", "32", "", "12", "46014", "", "-29.41105", "-66.85067", "America/Argentina/La_Rioja"),
("3849140", "La Quiaca", "", "AR", "32", "", "10", "38112", "", "-22.10236", "-65.59299", "America/Argentina/Jujuy"),
("3850005", "Lamarque", "", "AR", "32", "", "16", "62014", "", "-39.42304", "-65.70208", "America/Argentina/Salta"),
("3850920", "Laguna Paiva", "", "AR", "32", "", "21", "82063", "", "-31.30391", "-60.65894", "America/Argentina/Cordoba"),
("3850929", "Laguna Larga", "", "AR", "32", "", "05", "14119", "", "-31.77652", "-63.80104", "America/Argentina/Cordoba"),
("3851331", "La Falda", "", "AR", "32", "", "05", "14091", "", "-31.08841", "-64.48987", "America/Argentina/Cordoba"),
("3851798", "La Cumbre", "", "AR", "32", "", "05", "14091", "", "-30.98201", "-64.49139", "America/Argentina/Cordoba"),
("3851985", "La Cocha", "", "AR", "32", "", "24", "90049", "", "-27.77729", "-65.57035", "America/Argentina/Tucuman"),
("3852279", "La Carlota", "", "AR", "32", "", "05", "14056", "", "-33.41993", "-63.29769", "America/Argentina/Cordoba"),
("3852374", "La Calera", "", "AR", "32", "", "05", "14021", "", "-31.34377", "-64.33529", "America/Argentina/Cordoba"),
("3852468", "Laboulaye", "", "AR", "32", "", "05", "14084", "", "-34.12662", "-63.39119", "America/Argentina/Cordoba"),
("3852480", "Laborde", "", "AR", "32", "", "05", "14182", "", "-33.15319", "-62.85661", "America/Argentina/Cordoba"),
("3853330", "Justo Daract", "", "AR", "32", "", "19", "74035", "", "-33.8594", "-65.18277", "America/Argentina/San_Luis"),
("3853331", "Justiniano Posse", "", "AR", "32", "", "05", "14182", "", "-32.88411", "-62.67788", "America/Argentina/Cordoba"),
("3853350", "Junín de los Andes", "", "AR", "32", "", "15", "58049", "", "-39.95043", "-71.06936", "America/Argentina/Salta"),
("3853354", "Junín", "", "AR", "32", "", "01", "06413", "", "-34.58382", "-60.94332", "America/Argentina/Buenos_Aires"),
("3853491", "Joaquín V. González", "", "AR", "32", "", "17", "66112", "", "-25.08333", "-64.18333", "America/Argentina/Salta"),
("3853510", "Jesús María", "", "AR", "32", "", "05", "14021", "", "-30.98153", "-64.09424", "America/Argentina/Cordoba"),
("3853745", "Intendente Alvear", "", "AR", "32", "", "11", "42056", "", "-35.23383", "-63.59205", "America/Argentina/Salta"),
("3853767", "Ingenio La Esperanza", "", "AR", "32", "", "10", "38063", "", "-24.22554", "-64.83896", "America/Argentina/Jujuy"),
("3853782", "Ingeniero Luis A. Huergo", "", "AR", "32", "AR", "16", "62042", "", "-39.08333", "-67.23333", "America/Argentina/Salta"),
("3853786", "Ingeniero Jacobacci", "", "AR", "32", "", "16", "62091", "", "-41.3292", "-69.55015", "America/Argentina/Salta"),
("3853788", "Ingeniero Guillermo N. Juárez", "", "AR", "32", "", "09", "34028", "", "-23.9", "-61.85", "America/Argentina/Cordoba"),
("3853935", "Icaño", "", "AR", "32", "", "02", "10070", "", "-28.91934", "-65.32817", "America/Argentina/Catamarca"),
("3853967", "Humahuaca", "", "AR", "32", "", "10", "38028", "", "-23.20544", "-65.35048", "America/Argentina/Jujuy"),
("3853974", "Huinca Renancó", "", "AR", "32", "", "05", "14035", "", "-34.84038", "-64.3758", "America/Argentina/Cordoba"),
("3853981", "Huillapima", "", "AR", "32", "", "02", "10042", "", "-28.72533", "-65.9787", "America/Argentina/Catamarca"),
("3854008", "Huerta Grande", "", "AR", "32", "", "05", "14091", "", "-31.07524", "-64.49063", "America/Argentina/Cordoba"),
("3854331", "Hernando", "", "AR", "32", "", "05", "14161", "", "-32.42657", "-63.73333", "America/Argentina/Cordoba"),
("3854336", "Hermoso Campo", "", "AR", "32", "", "03", "22039", "", "-27.60816", "-61.34441", "America/Argentina/Cordoba"),
("3854493", "Guatraché", "", "AR", "32", "", "11", "42070", "", "-37.66776", "-63.53021", "America/Argentina/Salta"),
("3854724", "Graneros", "", "AR", "32", "", "24", "90035", "", "-27.64934", "-65.4383", "America/Argentina/Tucuman"),
("3854895", "Granadero Baigorria", "", "AR", "32", "", "21", "82084", "", "-32.85683", "-60.71754", "America/Argentina/Cordoba"),
("3854985", "Gobernador Gálvez", "", "AR", "32", "", "21", "82084", "", "-33.03016", "-60.64045", "America/Argentina/Cordoba"),
("3855041", "General Villegas", "", "AR", "32", "", "01", "06392", "", "-35.03285", "-63.01252", "America/Argentina/Buenos_Aires"),
("3855065", "General Roca", "Хенераль", "AR", "32", "", "16", "62042", "", "-39.03333", "-67.58333", "America/Argentina/Salta"),
("3855067", "General Ramírez", "", "AR", "32", "", "08", "30021", "", "-32.17601", "-60.20079", "America/Argentina/Cordoba"),
("3855074", "General Pinedo", "", "AR", "32", "", "03", "22036", "", "-27.31667", "-61.28333", "America/Argentina/Cordoba"),
("3855075", "General Pico", "", "AR", "32", "", "11", "42105", "", "-35.65662", "-63.75682", "America/Argentina/Salta"),
("3855098", "General Levalle", "", "AR", "32", "", "05", "14084", "", "-34.01472", "-63.92413", "America/Argentina/Cordoba"),
("3855114", "General Fernández Oro", "", "AR", "32", "", "16", "62042", "", "-38.95297", "-67.92489", "America/Argentina/Salta"),
("3855116", "General Enrique Mosconi", "", "AR", "32", "", "17", "66056", "", "-22.59588", "-63.81255", "America/Argentina/Salta"),
("3855121", "General Conesa", "", "AR", "32", "", "16", "62028", "", "-40.1", "-64.43333", "America/Argentina/Salta"),
("3855124", "General Cabrera", "", "AR", "32", "", "05", "14056", "", "-32.81313", "-63.87243", "America/Argentina/Cordoba"),
("3855143", "General Acha", "", "AR", "32", "", "11", "42154", "", "-37.37698", "-64.60431", "America/Argentina/Salta"),
("3855244", "Gálvez", "", "AR", "32", "", "21", "82105", "", "-32.02927", "-61.22103", "America/Argentina/Cordoba"),
("3855284", "Gaimán", "", "AR", "32", "", "04", "26042", "", "-43.2897", "-65.4929", "America/Argentina/Catamarca"),
("3855302", "Funes", "", "AR", "32", "", "21", "82084", "", "-32.91568", "-60.80995", "America/Argentina/Cordoba"),
("3855368", "Fray Luis Beltrán", "", "AR", "32", "AR", "16", "62014", "", "-39.31667", "-65.76667", "America/Argentina/Salta"),
("3855370", "Fray Luis A. Beltrán", "", "AR", "32", "", "21", "82119", "", "-32.79122", "-60.72819", "America/Argentina/Cordoba"),
("3855394", "Fraile Pintado", "", "AR", "32", "", "10", "38035", "", "-23.94079", "-64.79943", "America/Argentina/Jujuy"),
("3855554", "Firmat", "", "AR", "32", "", "21", "82042", "", "-33.45937", "-61.4832", "America/Argentina/Cordoba"),
("3855588", "Fiambalá", "", "AR", "32", "", "02", "10105", "", "-27.68705", "-67.6149", "America/Argentina/Catamarca"),
("3855666", "Famaillá", "", "AR", "32", "", "24", "90028", "", "-27.05413", "-65.40329", "America/Argentina/Tucuman"),
("3855974", "Esquel", "Эскель", "AR", "32", "", "04", "26035", "", "-42.91147", "-71.31947", "America/Argentina/Catamarca"),
("3856022", "Esperanza", "", "AR", "32", "", "21", "82070", "", "-31.4488", "-60.93173", "America/Argentina/Cordoba"),
("3856231", "Embarcación", "", "AR", "32", "", "17", "66056", "", "-23.21003", "-64.09965", "America/Argentina/Salta"),
("3856235", "Embalse", "", "AR", "32", "", "05", "14007", "", "-32.18", "-64.41809", "America/Argentina/Cordoba"),
("3856436", "El Trébol", "", "AR", "32", "", "21", "82126", "", "-32.2008", "-61.7014", "America/Argentina/Cordoba"),
("3857012", "El Quebrachal", "", "AR", "32", "", "17", "66007", "", "-25.28333", "-64.06667", "America/Argentina/Salta"),
("3857974", "El Galpón", "", "AR", "32", "", "17", "66112", "", "-25.38069", "-64.65259", "America/Argentina/Salta"),
("3858553", "El Carril", "", "AR", "32", "", "17", "66042", "", "-25.0741", "-65.49174", "America/Argentina/Salta"),
("3858677", "El Calafate", "", "AR", "32", "AR", "20", "78028", "", "-50.34075", "-72.27682", "America/Argentina/Rio_Gallegos"),
("3858765", "El Bolsón", "", "AR", "32", "", "16", "62021", "", "-41.96051", "-71.53336", "America/Argentina/Salta"),
("3859036", "Eduardo Castex", "", "AR", "32", "", "11", "42035", "", "-35.91501", "-64.29448", "America/Argentina/Salta"),
("3859384", "Diamante", "", "AR", "32", "", "08", "30021", "", "-32.06641", "-60.63837", "America/Argentina/Cordoba"),
("3859409", "Devoto", "", "AR", "32", "", "05", "14140", "", "-31.40431", "-62.30634", "America/Argentina/Cordoba"),
("3859429", "Despeñaderos", "", "AR", "32", "", "05", "14147", "", "-31.81626", "-64.28989", "America/Argentina/Cordoba"),
("3859512", "Deán Funes", "", "AR", "32", "", "05", "14049", "", "-30.42036", "-64.34984", "America/Argentina/Cordoba"),
("3859552", "Cutral-Có", "", "AR", "32", "", "15", "58035", "", "-38.93424", "-69.23052", "America/Argentina/Salta"),
("3859828", "Cruz del Eje", "", "AR", "32", "", "05", "14028", "", "-30.72644", "-64.80387", "America/Argentina/Cordoba"),
("3859839", "Cruz Alta", "", "AR", "32", "", "05", "14063", "", "-33.00887", "-61.80746", "America/Argentina/Cordoba"),
("3859904", "Crespo", "", "AR", "32", "", "08", "30084", "", "-32.02873", "-60.30658", "America/Argentina/Cordoba"),
("3859965", "Cosquín", "", "AR", "32", "", "05", "14091", "", "-31.24508", "-64.46563", "America/Argentina/Cordoba"),
("3859974", "Corzuela", "", "AR", "32", "", "03", "22049", "", "-26.95374", "-60.96928", "America/Argentina/Cordoba"),
("3860129", "Corral de Bustos", "", "AR", "32", "", "05", "14063", "", "-33.28205", "-62.18463", "America/Argentina/Cordoba"),
("3860164", "Coronel Suárez", "Коронель-Суарез", "AR", "32", "", "01", "06203", "", "-37.45467", "-61.93343", "America/Argentina/Buenos_Aires"),
("3860178", "Coronel Moldes", "", "AR", "32", "", "05", "14098", "", "-33.6227", "-64.59711", "America/Argentina/Cordoba"),
("3860197", "Coronel Du Graty", "", "AR", "32", "", "03", "22098", "", "-27.68038", "-60.91462", "America/Argentina/Cordoba"),
("3860199", "Coronel Dorrego", "", "AR", "32", "", "01", "06189", "", "-38.71867", "-61.28733", "America/Argentina/Buenos_Aires"),
("3860217", "Coronda", "", "AR", "32", "", "21", "82105", "", "-31.97263", "-60.91983", "America/Argentina/Cordoba"),
("3860259", "Córdoba", "Кордова", "AR", "32", "", "05", "14014", "", "-31.4135", "-64.18105", "America/Argentina/Cordoba"),
("3860419", "Concepción del Bermejo", "", "AR", "32", "", "03", "22007", "", "-26.59926", "-60.94617", "America/Argentina/Cordoba"),
("3860443", "Comodoro Rivadavia", "Комодоро-Ривадавия", "AR", "32", "", "04", "26021", "", "-45.86413", "-67.49656", "America/Argentina/Catamarca"),
("3861002", "Clodomira", "", "AR", "32", "", "22", "86035", "", "-27.5744", "-64.13108", "America/Argentina/Cordoba"),
("3861056", "Cipolletti", "Чиполлетти", "AR", "32", "", "16", "62042", "", "-38.93392", "-67.99032", "America/Argentina/Salta"),
("3861061", "Cinco Saltos", "", "AR", "32", "", "16", "62042", "", "-38.82225", "-68.06293", "America/Argentina/Salta"),
("3861262", "Chos Malal", "", "AR", "32", "", "15", "58042", "", "-37.37809", "-70.27085", "America/Argentina/Salta"),
("3861329", "Choele Choel", "", "AR", "32", "", "16", "62014", "", "-39.26667", "-65.68333", "America/Argentina/Salta"),
("3861344", "Chivilcoy", "", "AR", "32", "", "01", "06224", "", "-34.89566", "-60.01667", "America/Argentina/Buenos_Aires"),
("3861416", "Chimbas", "", "AR", "32", "", "18", "70042", "", "-31.48333", "-68.53333", "America/Argentina/San_Juan"),
("3861445", "Chilecito", "", "AR", "32", "", "12", "46042", "", "-29.16195", "-67.4974", "America/Argentina/La_Rioja"),
("3861494", "Chicoana", "", "AR", "32", "", "17", "66042", "", "-25.10088", "-65.5331", "America/Argentina/Salta"),
("3861678", "Charata", "", "AR", "32", "", "03", "22028", "", "-27.21438", "-61.18795", "America/Argentina/Cordoba"),
("3861824", "Chamical", "", "AR", "32", "", "12", "46035", "", "-30.36002", "-66.31399", "America/Argentina/La_Rioja"),
("3861953", "Chacabuco", "Чакабуко", "AR", "32", "", "01", "06210", "", "-34.64167", "-60.47389", "America/Argentina/Buenos_Aires"),
("3861966", "Cervantes", "", "AR", "32", "", "16", "62042", "", "-39.05", "-67.38333", "America/Argentina/Salta"),
("3862100", "Ceres", "", "AR", "32", "", "21", "82091", "", "-29.881", "-61.94504", "America/Argentina/Cordoba"),
("3862144", "Centenario", "", "AR", "32", "", "15", "58035", "", "-38.82955", "-68.1318", "America/Argentina/Salta"),
("3862240", "Caucete", "", "AR", "32", "", "18", "70035", "", "-31.65179", "-68.28105", "America/Argentina/San_Juan"),
("3862254", "Catriel", "", "AR", "32", "", "16", "62042", "", "-37.87907", "-67.7956", "America/Argentina/Salta"),
("3862320", "Castelli", "", "AR", "32", "", "03", "22063", "", "-25.94679", "-60.61947", "America/Argentina/Cordoba"),
("3862351", "Casilda", "", "AR", "32", "", "21", "82014", "", "-33.04417", "-61.16806", "America/Argentina/Cordoba"),
("3862655", "Carcarañá", "", "AR", "32", "", "21", "82119", "", "-32.85679", "-61.15331", "America/Argentina/Cordoba"),
("3862738", "Capitán Bermúdez", "", "AR", "32", "", "21", "82119", "", "-32.82262", "-60.71852", "America/Argentina/Cordoba"),
("3862761", "Capilla del Monte", "", "AR", "32", "", "05", "14091", "", "-30.86088", "-64.52515", "America/Argentina/Cordoba"),
("3862772", "Capayán", "", "AR", "32", "", "02", "10042", "", "-28.76105", "-66.05025", "America/Argentina/Catamarca"),
("3862883", "Canals", "", "AR", "32", "", "05", "14182", "", "-33.56542", "-62.88927", "America/Argentina/Cordoba"),
("3862981", "Cañada de Gómez", "Канада-де-Гомес", "AR", "32", "", "21", "82056", "", "-32.81636", "-61.39493", "America/Argentina/Cordoba"),
("3863095", "Campo Largo", "", "AR", "32", "", "03", "22070", "", "-26.80077", "-60.84215", "America/Argentina/Cordoba"),
("3863136", "Campo Gallo", "", "AR", "32", "", "22", "86014", "", "-26.58333", "-62.85", "America/Argentina/Cordoba"),
("3863362", "Calingasta", "", "AR", "32", "", "18", "70021", "", "-31.33084", "-69.40783", "America/Argentina/San_Juan"),
("3863366", "Calilegua", "", "AR", "32", "", "10", "38035", "", "-23.77368", "-64.77002", "America/Argentina/Jujuy"),
("3863379", "Caleta Olivia", "Калета-Оливия", "AR", "32", "", "20", "78014", "", "-46.43929", "-67.52814", "America/Argentina/Rio_Gallegos"),
("3863419", "Calchaquí", "", "AR", "32", "", "21", "82133", "", "-29.88767", "-60.28697", "America/Argentina/Cordoba"),
("3863491", "Caimancito", "", "AR", "32", "", "10", "38035", "", "-23.74069", "-64.5937", "America/Argentina/Jujuy"),
("3863503", "Cafayate", "", "AR", "32", "AR", "17", "66021", "", "-26.07286", "-65.97766", "America/Argentina/Salta"),
("3863833", "Brinkmann", "", "AR", "32", "", "05", "14140", "", "-30.86589", "-62.03742", "America/Argentina/Cordoba"),
("3864274", "Berrotarán", "", "AR", "32", "", "05", "14098", "", "-32.451", "-64.38867", "America/Argentina/Cordoba"),
("3864328", "Beltrán", "", "AR", "32", "", "22", "86161", "", "-27.82913", "-64.06098", "America/Argentina/Cordoba"),
("3864331", "Bell Ville", "", "AR", "32", "", "05", "14182", "", "-32.62591", "-62.68873", "America/Argentina/Cordoba"),
("3864375", "Bella Vista", "", "AR", "32", "", "24", "90056", "", "-27.03424", "-65.30196", "America/Argentina/Tucuman"),
("3864888", "Balnearia", "", "AR", "32", "", "05", "14140", "", "-31.0088", "-62.66733", "America/Argentina/Cordoba"),
("3865086", "Bahía Blanca", "Байя-Бланка", "AR", "32", "", "01", "06056", "", "-38.71959", "-62.27243", "America/Argentina/Buenos_Aires"),
("3865186", "Aviá Terai", "", "AR", "32", "", "03", "22070", "", "-26.68532", "-60.7292", "America/Argentina/Cordoba"),
("3865385", "Arroyo Seco", "", "AR", "32", "", "21", "82084", "", "-33.15489", "-60.50863", "America/Argentina/Cordoba"),
("3865424", "Arroyito", "", "AR", "32", "", "05", "14140", "", "-31.42022", "-63.05002", "America/Argentina/Cordoba"),
("3865449", "Armstrong", "", "AR", "32", "", "21", "82007", "", "-32.78215", "-61.60222", "America/Argentina/Cordoba"),
("3865474", "Arias", "", "AR", "32", "", "05", "14063", "", "-33.64411", "-62.40272", "America/Argentina/Cordoba"),
("3865579", "Arauco", "", "AR", "32", "", "12", "46007", "", "-28.5805", "-66.79438", "America/Argentina/La_Rioja"),
("3865605", "Apolinario Saravia", "", "AR", "32", "", "17", "66007", "", "-24.43276", "-63.99535", "America/Argentina/Salta"),
("3865802", "Andalgalá", "", "AR", "32", "", "02", "10021", "", "-27.60012", "-66.31794", "America/Argentina/Catamarca"),
("3865840", "Añatuya", "", "AR", "32", "", "22", "86077", "", "-28.46064", "-62.83472", "America/Argentina/Cordoba"),
("3866163", "Alta Gracia", "Альта-Грация", "AR", "32", "", "05", "14147", "", "-31.65292", "-64.42826", "America/Argentina/Cordoba"),
("3866237", "Almafuerte", "", "AR", "32", "", "05", "14161", "", "-32.19296", "-64.25559", "America/Argentina/Cordoba"),
("3866242", "Allen", "", "AR", "32", "", "16", "62042", "", "-38.97736", "-67.82714", "America/Argentina/Salta"),
("3866367", "Alderetes", "", "AR", "32", "", "24", "90014", "", "-26.81667", "-65.13333", "America/Argentina/Tucuman"),
("3866425", "Albardón", "", "AR", "32", "", "18", "70007", "", "-31.43722", "-68.52556", "America/Argentina/San_Juan"),
("3866496", "Aguilares", "", "AR", "32", "", "24", "90077", "", "-27.4338", "-65.61427", "America/Argentina/Tucuman"),
("3866935", "Adelia María", "", "AR", "32", "", "05", "14098", "", "-33.63152", "-64.02097", "America/Argentina/Cordoba"),
("3867009", "Abra Pampa", "", "AR", "32", "", "10", "38007", "", "-22.72049", "-65.69697", "America/Argentina/Jujuy"),
("6693230", "Villa Santa Rita", "", "AR", "32", "", "07", "", "", "-34.61082", "-58.481", "America/Argentina/Buenos_Aires"),
("7116866", "Villa Mercedes", "", "AR", "32", "", "19", "74035", "", "-33.67571", "-65.45783", "America/Argentina/San_Luis"),
("7284819", "La Punta", "", "AR", "32", "", "19", "74056", "", "-33.18368", "-66.3127", "America/Argentina/San_Luis"),
("7647007", "San Carlos de Bariloche", "Сан Карлос де Барилоче", "AR", "32", "", "16", "62021", "3837856", "-41.14557", "-71.30822", "America/Argentina/Salta"),
("8521759", "Río Turbio", "", "AR", "32", "", "20", "78021", "", "-51.53587", "-72.33673", "America/Argentina/Rio_Gallegos"),
("10172104", "Adrogué", "", "AR", "32", "", "01", "06028", "", "-34.80041", "-58.38384", "America/Argentina/Buenos_Aires"),
("2601384", "Neu-Guntramsdorf", "", "AT", "40", "", "03", "317", "31710", "48.0642", "16.31573", "Europe/Vienna"),
("2760415", "Zwettl Stift", "", "AT", "40", "", "03", "325", "32530", "48.61667", "15.2", "Europe/Vienna"),
("2760510", "Zistersdorf", "", "AT", "40", "", "03", "308", "30863", "48.53333", "16.75", "Europe/Vienna"),
("2760523", "Zirl", "", "AT", "40", "", "07", "703", "70369", "47.28333", "11.23333", "Europe/Vienna"),
("2760610", "Zeltweg", "", "AT", "40", "", "06", "620", "62038", "47.18333", "14.75", "Europe/Vienna"),
("2760634", "Zell am See", "", "AT", "40", "", "05", "506", "50628", "47.32556", "12.79444", "Europe/Vienna"),
("2760772", "Ybbs an der Donau", "", "AT", "40", "", "03", "315", "31549", "48.16667", "15.08333", "Europe/Vienna"),
("2760854", "Wörgl", "", "AT", "40", "", "07", "705", "70531", "47.48906", "12.06174", "Europe/Vienna"),
("2760855", "Wördern", "", "AT", "40", "", "03", "321", "32142", "48.334", "16.21016", "Europe/Vienna"),
("2760887", "Wolkersdorf im Weinviertel", "", "AT", "40", "", "03", "316", "31655", "48.38333", "16.51667", "Europe/Vienna"),
("2760894", "Wolfurt", "", "AT", "40", "", "08", "802", "80240", "47.46667", "9.75", "Europe/Vienna"),
("2760910", "Wolfsberg", "", "AT", "40", "", "02", "209", "20923", "46.84056", "14.84417", "Europe/Vienna"),
("2761186", "Wilhelmsburg", "", "AT", "40", "", "03", "319", "31947", "48.10571", "15.60539", "Europe/Vienna"),
("2761353", "Wiener Neustadt", "Винер-Нойштадт", "AT", "40", "", "03", "304", "30401", "47.8", "16.25", "Europe/Vienna"),
("2761354", "Wiener Neudorf", "", "AT", "40", "", "03", "317", "31725", "48.08278", "16.31384", "Europe/Vienna"),
("2761369", "Vienna", "Вена", "AT", "40", "", "09", "900", "901", "48.20849", "16.37208", "Europe/Vienna"),
("2761436", "Wetzelsdorf", "", "AT", "40", "", "06", "601", "60101", "47.05293", "15.39923", "Europe/Vienna"),
("2761475", "Wernberg", "", "AT", "40", "", "02", "207", "20727", "46.61667", "13.93333", "Europe/Vienna"),
("2761524", "Wels", "Вельс", "AT", "40", "", "04", "403", "40301", "48.16667", "14.03333", "Europe/Vienna"),
("2761531", "Weiz", "", "AT", "40", "", "06", "617", "61755", "47.21667", "15.61667", "Europe/Vienna"),
("2761669", "Weinzierl bei Krems", "", "AT", "40", "", "03", "313", "31327", "48.4", "15.6", "Europe/Vienna"),
("2761834", "Wattens", "", "AT", "40", "", "07", "703", "70367", "47.28333", "11.6", "Europe/Vienna"),
("2762077", "Waidhofen an der Ybbs", "", "AT", "40", "", "03", "303", "30301", "47.96004", "14.77361", "Europe/Vienna"),
("2762079", "Waidhofen an der Thaya", "", "AT", "40", "", "03", "322", "32220", "48.81667", "15.28333", "Europe/Vienna"),
("2762290", "Vorchdorf", "", "AT", "40", "", "04", "407", "40720", "48.00388", "13.92122", "Europe/Vienna"),
("2762304", "Völs", "", "AT", "40", "", "07", "703", "70364", "47.25", "11.33333", "Europe/Vienna"),
("2762315", "Völkermarkt", "", "AT", "40", "", "02", "208", "20817", "46.66222", "14.63444", "Europe/Vienna"),
("2762327", "Voitsberg", "", "AT", "40", "", "06", "616", "61625", "47.03333", "15.15", "Europe/Vienna"),
("2762343", "Vöcklabruck", "", "AT", "40", "", "04", "417", "41746", "48.01667", "13.65", "Europe/Vienna"),
("2762372", "Villach", "Филлах", "AT", "40", "", "02", "202", "20201", "46.61028", "13.85583", "Europe/Vienna"),
("2762453", "Velden am Wörthersee", "", "AT", "40", "", "02", "207", "20725", "46.61301", "14.0413", "Europe/Vienna"),
("2763266", "Tulln", "", "AT", "40", "", "03", "321", "32135", "48.32829", "16.05858", "Europe/Vienna"),
("2763332", "Trofaiach", "", "AT", "40", "", "06", "611", "61120", "47.42524", "15.00681", "Europe/Vienna"),
("2763423", "Traun", "", "AT", "40", "", "04", "410", "41021", "48.22656", "14.23459", "Europe/Vienna"),
("2763459", "Traismauer", "", "AT", "40", "", "03", "319", "31943", "48.35", "15.73333", "Europe/Vienna"),
("2763460", "Traiskirchen", "", "AT", "40", "", "03", "306", "30639", "48.01485", "16.29324", "Europe/Vienna"),
("2763595", "Timelkam", "", "AT", "40", "", "04", "417", "41743", "48.00394", "13.6076", "Europe/Vienna"),
("2763749", "Thalgau", "", "AT", "40", "", "05", "503", "50337", "47.83333", "13.25", "Europe/Vienna"),
("2763795", "Ternitz", "Терниц", "AT", "40", "", "03", "318", "31839", "47.71565", "16.03575", "Europe/Vienna"),
("2763810", "Telfs", "", "AT", "40", "", "07", "703", "70357", "47.30707", "11.06817", "Europe/Vienna"),
("2763929", "Tamsweg", "", "AT", "40", "", "05", "505", "50510", "47.12808", "13.81102", "Europe/Vienna"),
("2764172", "Strasswalchen", "", "AT", "40", "", "05", "503", "50335", "47.98333", "13.25", "Europe/Vienna"),
("2764175", "Strasshof an der Nordbahn", "", "AT", "40", "", "03", "308", "30856", "48.31667", "16.66667", "Europe/Vienna"),
("2764279", "Stockerau", "", "AT", "40", "", "03", "312", "31230", "48.38333", "16.21667", "Europe/Vienna"),
("2764359", "Steyr", "Штайр", "AT", "40", "", "04", "402", "40201", "48.04274", "14.42127", "Europe/Vienna"),
("2764786", "Spittal an der Drau", "Шпитталь-ан-дер-Драу", "AT", "40", "", "02", "206", "20635", "46.8", "13.5", "Europe/Vienna"),
("2764958", "Hall in Tirol", "", "AT", "40", "AT", "07", "703", "70354", "47.28333", "11.51667", "Europe/Vienna"),
("2765080", "Sierning", "", "AT", "40", "", "04", "415", "41516", "48.04343", "14.30935", "Europe/Vienna"),
("2765091", "Sieghartskirchen", "", "AT", "40", "", "03", "321", "32131", "48.25531", "16.01223", "Europe/Vienna"),
("2765257", "Seekirchen am Wallersee", "", "AT", "40", "", "05", "503", "50339", "47.9", "13.13333", "Europe/Vienna"),
("2765286", "Seeboden", "", "AT", "40", "", "02", "206", "20634", "46.81909", "13.5143", "Europe/Vienna"),
("2765388", "Schwechat", "Швехат", "AT", "40", "", "03", "324", "32419", "48.13333", "16.46667", "Europe/Vienna"),
("2765390", "Schwaz", "", "AT", "40", "", "07", "709", "70926", "47.35169", "11.71014", "Europe/Vienna"),
("2765602", "Schrems", "", "AT", "40", "", "03", "309", "30935", "48.78333", "15.06667", "Europe/Vienna"),
("2766359", "Sankt Veit an der Glan", "", "AT", "40", "", "02", "205", "20527", "46.76806", "14.36028", "Europe/Vienna"),
("2766365", "Sankt Valentin", "", "AT", "40", "", "03", "305", "30531", "48.16667", "14.51667", "Europe/Vienna"),
("2766429", "Sankt Pölten", "Санкт-Пёльтен", "AT", "40", "", "03", "302", "30201", "48.2", "15.63333", "Europe/Vienna"),
("2766643", "Sankt Johann im Pongau", "", "AT", "40", "", "05", "504", "50418", "47.35", "13.2", "Europe/Vienna"),
("2766772", "Sankt Andrä", "", "AT", "40", "", "02", "209", "20913", "46.76829", "14.81991", "Europe/Vienna"),
("2766824", "Salzburg", "Зальцбург", "AT", "40", "", "05", "501", "50101", "47.79941", "13.04399", "Europe/Vienna"),
("2766922", "Saalfelden am Steinernen Meer", "Зальфельден-ам-Штайнернен-Меер", "AT", "40", "", "05", "506", "50619", "47.42681", "12.848", "Europe/Vienna"),
("2766971", "Rum", "", "AT", "40", "", "07", "703", "70346", "47.28333", "11.45", "Europe/Vienna"),
("2767034", "Rottenmann", "", "AT", "40", "", "06", "612", "61238", "47.51667", "14.35", "Europe/Vienna"),
("2767471", "Ried im Innkreis", "", "AT", "40", "", "04", "412", "41225", "48.21123", "13.48855", "Europe/Vienna"),
("2767511", "Reutte", "", "AT", "40", "", "07", "708", "70828", "47.48333", "10.71667", "Europe/Vienna"),
("2767974", "Rankweil", "", "AT", "40", "", "08", "804", "80414", "47.27108", "9.64308", "Europe/Vienna"),
("2768232", "Purkersdorf", "", "AT", "40", "", "03", "324", "32416", "48.20769", "16.17539", "Europe/Vienna"),
("2768236", "Purgstall", "", "AT", "40", "", "03", "320", "32008", "48.05841", "15.13478", "Europe/Vienna"),
("2768348", "Pressbaum", "", "AT", "40", "", "03", "324", "32415", "48.18333", "16.08333", "Europe/Vienna"),
("2768450", "Poysdorf", "", "AT", "40", "", "03", "316", "31644", "48.66667", "16.63333", "Europe/Vienna"),
("2768472", "Pottendorf", "", "AT", "40", "", "03", "306", "30626", "47.9", "16.38333", "Europe/Vienna"),
("2768811", "Pinkafeld", "", "AT", "40", "", "01", "109", "10918", "47.36667", "16.11667", "Europe/Vienna"),
("2769105", "Perg", "", "AT", "40", "", "04", "411", "41116", "48.25", "14.63333", "Europe/Vienna"),
("2769110", "Perchtoldsdorf", "", "AT", "40", "", "03", "317", "31719", "48.11935", "16.26607", "Europe/Vienna"),
("2769212", "Paternion", "", "AT", "40", "", "02", "207", "20720", "46.71417", "13.63611", "Europe/Vienna"),
("2769225", "Pasching", "", "AT", "40", "", "04", "410", "41017", "48.25931", "14.20369", "Europe/Vienna"),
("2769623", "Oberwart", "", "AT", "40", "", "01", "109", "10917", "47.28971", "16.20595", "Europe/Vienna"),
("2770684", "Neusiedl am See", "", "AT", "40", "", "01", "107", "10713", "47.94901", "16.8417", "Europe/Vienna"),
("2770711", "Neunkirchen", "", "AT", "40", "", "03", "318", "31818", "47.72096", "16.08107", "Europe/Vienna"),
("2770885", "Nenzing", "", "AT", "40", "", "08", "801", "80116", "47.18436", "9.70539", "Europe/Vienna"),
("2770993", "Mürzzuschlag", "", "AT", "40", "", "06", "621", "62121", "47.6", "15.68333", "Europe/Vienna"),
("2771335", "Mödling", "Мёдлинг", "AT", "40", "", "03", "317", "31717", "48.08605", "16.28921", "Europe/Vienna"),
("2771385", "Mittersill", "", "AT", "40", "", "05", "506", "50613", "47.28333", "12.48333", "Europe/Vienna"),
("2771557", "Mistelbach", "", "AT", "40", "", "03", "316", "31633", "48.57", "16.57667", "Europe/Vienna"),
("2771619", "Micheldorf in Oberösterreich", "", "AT", "40", "", "04", "409", "40908", "47.87764", "14.13357", "Europe/Vienna"),
("2771682", "Melk", "", "AT", "40", "", "03", "315", "31524", "48.22737", "15.33186", "Europe/Vienna"),
("2771817", "Mattersburg", "", "AT", "40", "", "01", "106", "10606", "47.73333", "16.4", "Europe/Vienna"),
("2771828", "Matrei in Osttirol", "", "AT", "40", "", "07", "707", "70717", "47", "12.53333", "Europe/Vienna"),
("2771867", "Sankt Florian", "", "AT", "40", "AT", "04", "410", "41013", "48.20568", "14.37836", "Europe/Vienna"),
("2771896", "Mariatrost", "", "AT", "40", "", "06", "601", "60101", "47.1", "15.5", "Europe/Vienna"),
("2771940", "Maria Enzersdorf", "", "AT", "40", "", "03", "317", "31716", "48.1", "16.28333", "Europe/Vienna"),
("2771962", "Marchtrenk", "", "AT", "40", "", "04", "418", "41812", "48.18333", "14.11667", "Europe/Vienna"),
("2772173", "Lustenau", "Лустенау", "AT", "40", "", "08", "803", "80303", "47.42642", "9.65851", "Europe/Vienna"),
("2772345", "Lochau", "", "AT", "40", "", "08", "802", "80226", "47.53333", "9.75", "Europe/Vienna"),
("2772400", "Linz", "Линц", "AT", "40", "", "04", "401", "40101", "48.30639", "14.28611", "Europe/Vienna"),
("2772480", "Liezen", "", "AT", "40", "", "06", "612", "61223", "47.56667", "14.23333", "Europe/Vienna"),
("2772505", "Lienz", "", "AT", "40", "", "07", "707", "70716", "46.8289", "12.76903", "Europe/Vienna"),
("2772635", "Leonding", "Леондинг", "AT", "40", "", "04", "410", "41012", "48.27965", "14.2533", "Europe/Vienna"),
("2772649", "Leoben", "Леобен", "AT", "40", "", "06", "611", "61108", "47.3765", "15.09144", "Europe/Vienna"),
("2772653", "Lenzing", "", "AT", "40", "", "04", "417", "41713", "47.97326", "13.60846", "Europe/Vienna"),
("2772753", "Leibnitz", "", "AT", "40", "", "06", "610", "61022", "46.78161", "15.53836", "Europe/Vienna"),
("2772827", "Lauterach", "", "AT", "40", "", "08", "802", "80224", "47.48306", "9.73306", "Europe/Vienna"),
("2772998", "Langenzersdorf", "", "AT", "40", "", "03", "312", "31214", "48.3", "16.35", "Europe/Vienna"),
("2773010", "Langenlois", "", "AT", "40", "", "03", "313", "31322", "48.46667", "15.66667", "Europe/Vienna"),
("2773070", "Landeck", "", "AT", "40", "", "07", "706", "70614", "47.13988", "10.56593", "Europe/Vienna"),
("2773215", "Laakirchen", "", "AT", "40", "", "04", "407", "40711", "47.98188", "13.82166", "Europe/Vienna"),
("2773229", "Laa an der Thaya", "", "AT", "40", "", "03", "316", "31629", "48.71667", "16.38333", "Europe/Vienna"),
("2773300", "Kufstein", "Куфштайн", "AT", "40", "", "07", "705", "70513", "47.58333", "12.16667", "Europe/Vienna"),
("2773304", "Kuchl", "", "AT", "40", "", "05", "502", "50207", "47.62647", "13.1448", "Europe/Vienna"),
("2773447", "Krieglach", "", "AT", "40", "", "06", "621", "62115", "47.53333", "15.55", "Europe/Vienna"),
("2773538", "Kremsmünster", "", "AT", "40", "", "04", "409", "40907", "48.0529", "14.12919", "Europe/Vienna"),
("2773549", "Krems an der Donau", "Кремс-на-Дунае", "AT", "40", "", "03", "301", "30101", "48.40921", "15.61415", "Europe/Vienna"),
("2773653", "Kottingbrunn", "", "AT", "40", "", "03", "306", "30618", "47.95096", "16.22715", "Europe/Vienna"),
("2773698", "Korneuburg", "", "AT", "40", "", "03", "312", "31213", "48.35", "16.33333", "Europe/Vienna"),
("2773848", "Köflach", "", "AT", "40", "", "06", "616", "61609", "47.06667", "15.08333", "Europe/Vienna"),
("2773887", "Knittelfeld", "", "AT", "40", "", "06", "620", "62013", "47.21667", "14.81667", "Europe/Vienna"),
("2773913", "Klosterneuburg", "Клостернойбург", "AT", "40", "", "03", "324", "32408", "48.30521", "16.32522", "Europe/Vienna"),
("2774326", "Klagenfurt am Wörthersee", "Клагенфурт", "AT", "40", "", "02", "201", "20101", "46.62472", "14.30528", "Europe/Vienna"),
("2774347", "Kitzbühel", "", "AT", "40", "", "07", "704", "70411", "47.44637", "12.39215", "Europe/Vienna"),
("2774437", "Kindberg", "", "AT", "40", "", "06", "621", "62114", "47.5", "15.45", "Europe/Vienna"),
("2774773", "Kapfenberg", "Капфенберг", "AT", "40", "", "06", "621", "62113", "47.44458", "15.29331", "Europe/Vienna"),
("2775020", "Judenburg", "", "AT", "40", "", "06", "620", "62011", "47.16667", "14.66667", "Europe/Vienna"),
("2775093", "Jenbach", "", "AT", "40", "", "07", "709", "70917", "47.39173", "11.77245", "Europe/Vienna"),
("2775220", "Innsbruck", "Инсбрук", "AT", "40", "", "07", "701", "70101", "47.26266", "11.39454", "Europe/Vienna"),
("2775307", "Imst", "", "AT", "40", "", "07", "702", "70203", "47.24504", "10.73974", "Europe/Vienna"),
("2775497", "Hörsching", "", "AT", "40", "", "04", "410", "41007", "48.22627", "14.17786", "Europe/Vienna"),
("2775516", "Horn", "", "AT", "40", "", "03", "311", "31109", "48.66274", "15.65663", "Europe/Vienna"),
("2775531", "Hörbranz", "", "AT", "40", "", "08", "802", "80218", "47.55", "9.75", "Europe/Vienna"),
("2775541", "Hopfgarten im Brixental", "", "AT", "40", "", "07", "704", "70406", "47.45", "12.16667", "Europe/Vienna"),
("2775636", "Hollabrunn", "", "AT", "40", "", "03", "310", "31022", "48.55", "16.08333", "Europe/Vienna"),
("2775742", "Hohenems", "", "AT", "40", "", "08", "803", "80302", "47.36667", "9.68306", "Europe/Vienna"),
("2775950", "Höchst", "", "AT", "40", "", "08", "802", "80217", "47.45934", "9.6405", "Europe/Vienna"),
("2776401", "Himberg", "", "AT", "40", "", "03", "324", "32406", "48.08333", "16.43333", "Europe/Vienna"),
("2776470", "Herzogenburg", "", "AT", "40", "", "03", "319", "31912", "48.28137", "15.69431", "Europe/Vienna"),
("2776497", "Hermagor", "", "AT", "40", "", "02", "203", "20305", "46.62722", "13.36722", "Europe/Vienna"),
("2776801", "Hartberg", "", "AT", "40", "", "06", "622", "62219", "47.28333", "15.96667", "Europe/Vienna"),
("2776874", "Hard", "", "AT", "40", "", "08", "802", "80215", "47.48306", "9.68306", "Europe/Vienna"),
("2776951", "Hallein", "Халлайн", "AT", "40", "", "05", "502", "50205", "47.68333", "13.1", "Europe/Vienna"),
("2776988", "Hainburg an der Donau", "", "AT", "40", "", "03", "307", "30710", "48.14627", "16.94504", "Europe/Vienna"),
("2777836", "Groß-Enzersdorf", "", "AT", "40", "", "03", "308", "30821", "48.20278", "16.55083", "Europe/Vienna"),
("2777921", "Grödig", "", "AT", "40", "", "05", "503", "50314", "47.73333", "13.03333", "Europe/Vienna"),
("2778067", "Graz", "Грац", "AT", "40", "", "06", "601", "60101", "47.06667", "15.45", "Europe/Vienna"),
("2778085", "Gratkorn", "", "AT", "40", "", "06", "606", "60613", "47.13333", "15.35", "Europe/Vienna"),
("2778218", "Götzis", "", "AT", "40", "", "08", "804", "80408", "47.33306", "9.63306", "Europe/Vienna"),
("2778255", "Gösting", "", "AT", "40", "", "06", "601", "60101", "47.09788", "15.39777", "Europe/Vienna"),
("2778436", "Gmunden", "", "AT", "40", "", "04", "407", "40705", "47.91839", "13.79933", "Europe/Vienna"),
("2778439", "Gmünd", "", "AT", "40", "", "03", "309", "30908", "48.7683", "14.9808", "Europe/Vienna"),
("2778455", "Gloggnitz", "", "AT", "40", "", "03", "318", "31810", "47.67487", "15.93893", "Europe/Vienna"),
("2778478", "Gleisdorf", "", "AT", "40", "", "06", "617", "61713", "47.10559", "15.71011", "Europe/Vienna"),
("2778690", "Gerasdorf bei Wien", "", "AT", "40", "", "03", "324", "32404", "48.29447", "16.46765", "Europe/Vienna"),
("2778843", "Garsten", "", "AT", "40", "", "04", "415", "41506", "48.0224", "14.40747", "Europe/Vienna"),
("2778877", "Gänserndorf", "", "AT", "40", "", "03", "308", "30817", "48.33925", "16.72016", "Europe/Vienna"),
("2778966", "Gallneukirchen", "", "AT", "40", "", "04", "416", "41607", "48.35363", "14.41604", "Europe/Vienna"),
("2779115", "Fürstenfeld", "", "AT", "40", "", "06", "622", "62212", "47.05", "16.08333", "Europe/Vienna"),
("2779202", "Frohnleiten", "", "AT", "40", "", "06", "606", "60610", "47.26667", "15.31667", "Europe/Vienna"),
("2779229", "Friesach", "", "AT", "40", "", "02", "205", "20505", "46.95528", "14.40583", "Europe/Vienna"),
("2779275", "Freistadt", "", "AT", "40", "", "04", "406", "40601", "48.51103", "14.50453", "Europe/Vienna"),
("2779380", "Frankenburg", "", "AT", "40", "", "04", "417", "41709", "48.06844", "13.49065", "Europe/Vienna"),
("2779450", "Fohnsdorf", "", "AT", "40", "", "06", "620", "62007", "47.2", "14.68333", "Europe/Vienna"),
("2779640", "Ferlach", "", "AT", "40", "", "02", "204", "20405", "46.52694", "14.30194", "Europe/Vienna"),
("2779669", "Feldkirchen in Kärnten", "", "AT", "40", "", "02", "210", "21002", "46.72368", "14.0958", "Europe/Vienna"),
("2779672", "Feldkirchen an der Donau", "", "AT", "40", "", "04", "416", "41606", "48.34524", "14.05134", "Europe/Vienna"),
("2779674", "Feldkirch", "Фельдкирх", "AT", "40", "", "08", "804", "80404", "47.23306", "9.6", "Europe/Vienna"),
("2780048", "Enns", "", "AT", "40", "", "04", "410", "41005", "48.21346", "14.47612", "Europe/Vienna"),
("2780057", "Engerwitzdorf", "", "AT", "40", "", "04", "416", "41605", "48.34507", "14.44204", "Europe/Vienna"),
("2780190", "Eisenstadt", "", "AT", "40", "", "01", "101", "10101", "47.84565", "16.52327", "Europe/Vienna"),
("2780207", "Eisenerz", "", "AT", "40", "", "06", "611", "61101", "47.53333", "14.88333", "Europe/Vienna"),
("2780501", "Ebreichsdorf", "", "AT", "40", "", "03", "306", "30607", "47.95", "16.4", "Europe/Vienna"),
("2780531", "Eberndorf", "", "AT", "40", "", "02", "208", "20803", "46.59139", "14.64361", "Europe/Vienna"),
("2780544", "Ebenthal", "", "AT", "40", "", "02", "204", "20402", "46.60806", "14.36417", "Europe/Vienna"),
("2780547", "Ebensee", "", "AT", "40", "", "04", "407", "40704", "47.80716", "13.779", "Europe/Vienna"),
("2780579", "Ebbs", "", "AT", "40", "", "07", "705", "70508", "47.63333", "12.21667", "Europe/Vienna"),
("2780741", "Dornbirn", "Дорнбирн", "AT", "40", "", "08", "803", "80301", "47.41427", "9.74195", "Europe/Vienna"),
("2781017", "Deutsch-Wagram", "", "AT", "40", "", "03", "308", "30808", "48.29972", "16.56667", "Europe/Vienna"),
("2781023", "Deutschlandsberg", "", "AT", "40", "", "06", "603", "60302", "46.81528", "15.22222", "Europe/Vienna"),
("2781371", "Bruck an der Mur", "", "AT", "40", "", "06", "621", "62106", "47.41667", "15.28333", "Europe/Vienna"),
("2781373", "Bruck an der Leitha", "", "AT", "40", "", "03", "307", "30704", "48.01667", "16.76667", "Europe/Vienna"),
("2781503", "Bregenz", "Брегенц", "AT", "40", "", "08", "802", "80207", "47.50311", "9.7471", "Europe/Vienna"),
("2781520", "Braunau am Inn", "Браунау-ам-Инн", "AT", "40", "", "04", "404", "40404", "48.25628", "13.04343", "Europe/Vienna"),
("2781680", "Bludenz", "", "AT", "40", "", "08", "801", "80103", "47.15476", "9.82255", "Europe/Vienna"),
("2781735", "Bischofshofen", "", "AT", "40", "", "05", "504", "50404", "47.41667", "13.21667", "Europe/Vienna"),
("2781837", "Berndorf", "", "AT", "40", "", "03", "306", "30605", "47.94567", "16.10973", "Europe/Vienna"),
("2781859", "Bergheim", "", "AT", "40", "", "05", "503", "50303", "47.83333", "13.03333", "Europe/Vienna"),
("2782043", "Bad Vöslau", "", "AT", "40", "", "03", "306", "30603", "47.96533", "16.21359", "Europe/Vienna"),
("2782052", "Bad Ischl", "", "AT", "40", "", "04", "407", "40703", "47.71109", "13.61893", "Europe/Vienna"),
("2782053", "Bad Hofgastein", "", "AT", "40", "", "05", "504", "50402", "47.17274", "13.09871", "Europe/Vienna"),
("2782055", "Bad Goisern", "", "AT", "40", "", "04", "407", "40702", "47.64252", "13.61609", "Europe/Vienna"),
("2782058", "Bad Gastein", "", "AT", "40", "", "05", "504", "50403", "47.11547", "13.13467", "Europe/Vienna"),
("2782067", "Baden", "Баден", "AT", "40", "", "03", "306", "30604", "48.00543", "16.23264", "Europe/Vienna"),
("2782070", "Bad Aussee", "", "AT", "40", "", "06", "612", "61207", "47.60998", "13.78243", "Europe/Vienna"),
("2782302", "Asten", "", "AT", "40", "", "04", "410", "41003", "48.21941", "14.41784", "Europe/Vienna"),
("2782408", "Arnoldstein", "", "AT", "40", "", "02", "207", "20702", "46.54611", "13.71", "Europe/Vienna"),
("2782480", "Ansfelden", "", "AT", "40", "", "04", "410", "41002", "48.20969", "14.29004", "Europe/Vienna"),
("2782555", "Amstetten", "Амштеттен", "AT", "40", "", "03", "305", "30502", "48.1229", "14.87206", "Europe/Vienna"),
("2782627", "Altmünster", "", "AT", "40", "", "04", "407", "40701", "47.90219", "13.76415", "Europe/Vienna"),
("2782728", "Altach", "", "AT", "40", "", "08", "804", "80401", "47.35", "9.65", "Europe/Vienna"),
("2783050", "Abtenau", "", "AT", "40", "", "05", "502", "50201", "47.56373", "13.34599", "Europe/Vienna"),
("2783058", "Absam", "", "AT", "40", "", "07", "703", "70301", "47.3", "11.5", "Europe/Vienna"),
("3218464", "Finkenstein am Faaker See", "", "AT", "40", "", "02", "207", "20711", "46.56556", "13.86528", "Europe/Vienna"),
("3233832", "Attnang-Puchheim", "", "AT", "40", "", "04", "417", "41703", "48.00833", "13.71667", "Europe/Vienna"),
("3323063", "Ansfelden", "", "AT", "40", "", "05", "503", "50332", "47.965", "13.04944", "Europe/Vienna"),
("2058430", "Whyalla", "Уайалла", "AU", "36", "", "05", "48540", "", "-33.03268", "137.56483", "Australia/Adelaide"),
("2058682", "Wembley", "", "AU", "36", "", "08", "51310", "", "-31.93333", "115.8", "Australia/Perth"),
("2059124", "Wanneroo", "", "AU", "36", "", "08", "58760", "", "-31.75", "115.8", "Australia/Perth"),
("2059470", "Victor Harbor", "", "AU", "36", "", "05", "48050", "", "-35.55042", "138.62154", "Australia/Adelaide"),
("2060771", "Swan View", "", "AU", "36", "", "08", "56090", "", "-31.88333", "116.05", "Australia/Perth"),
("2060886", "Subiaco", "", "AU", "36", "", "08", "56580", "", "-31.9485", "115.8268", "Australia/Perth"),
("2061224", "Spearwood", "", "AU", "36", "", "08", "51820", "", "-32.10534", "115.77797", "Australia/Perth"),
("2061261", "South Perth", "", "AU", "36", "", "08", "57840", "", "-31.98333", "115.86667", "Australia/Perth"),
("2061758", "Seaton", "", "AU", "36", "", "05", "41060", "", "-34.9", "138.51667", "Australia/Adelaide"),
("2061840", "Scarborough", "", "AU", "36", "", "08", "57910", "", "-31.89578", "115.76431", "Australia/Perth"),
("2062013", "Salisbury", "", "AU", "36", "", "05", "47140", "", "-34.76667", "138.63333", "Australia/Adelaide"),
("2062057", "Safety Bay", "", "AU", "36", "", "08", "57490", "", "-32.30463", "115.74213", "Australia/Perth"),
("2062338", "Rockingham", "", "AU", "36", "", "08", "57490", "", "-32.27682", "115.72978", "Australia/Perth"),
("2062944", "Prospect", "", "AU", "36", "", "05", "46510", "", "-34.88241", "138.5933", "Australia/Adelaide"),
("2063030", "Port Pirie", "", "AU", "36", "", "05", "46450", "", "-33.19176", "138.01746", "Australia/Adelaide"),
("2063036", "Port Lincoln", "", "AU", "36", "", "05", "46300", "", "-34.72625", "135.87442", "Australia/Adelaide"),
("2063042", "Port Hedland", "Порт-Хедленд", "AU", "36", "", "08", "57280", "", "-20.31215", "118.61059", "Australia/Perth"),
("2063055", "Port Augusta West", "", "AU", "36", "", "05", "46090", "", "-32.48611", "137.75833", "Australia/Adelaide"),
("2063056", "Port Augusta", "", "AU", "36", "", "05", "46090", "", "-32.49597", "137.77281", "Australia/Adelaide"),
("2063523", "Perth", "Перт", "AU", "36", "", "08", "57080", "", "-31.95224", "115.8614", "Australia/Perth"),
("2064340", "Nuriootpa", "", "AU", "36", "", "05", "40310", "", "-34.46825", "138.99767", "Australia/Adelaide"),
("2064550", "Northam", "", "AU", "36", "", "08", "56730", "", "-31.64932", "116.67423", "Australia/Perth"),
("2064768", "Newman", "", "AU", "36", "", "08", "53220", "", "-23.35644", "119.73553", "Australia/Perth"),
("2064874", "Nedlands", "", "AU", "36", "", "08", "56580", "", "-31.98184", "115.8073", "Australia/Perth"),
("2065176", "Murray Bridge", "Марри-Бридж", "AU", "36", "", "05", "45040", "", "-35.11986", "139.27345", "Australia/Adelaide"),
("2065594", "Mount Isa", "Маунт-Айза", "AU", "36", "", "04", "35300", "", "-20.72523", "139.49727", "Australia/Brisbane"),
("2065665", "Mount Barker", "", "AU", "36", "", "05", "44550", "", "-35.06667", "138.86667", "Australia/Adelaide"),
("2065710", "Mosman Park", "", "AU", "36", "", "08", "55740", "", "-32.00538", "115.7638", "Australia/Perth"),
("2065740", "Morphett Vale", "", "AU", "36", "", "05", "45340", "", "-35.13333", "138.51667", "Australia/Adelaide"),
("2066041", "Modbury", "", "AU", "36", "", "05", "47700", "", "-34.83333", "138.68333", "Australia/Adelaide"),
("2066653", "McMinns Lagoon", "", "AU", "36", "", "03", "72300", "", "-12.55397", "131.11165", "Australia/Darwin"),
("2066756", "Maylands", "", "AU", "36", "", "08", "50420", "", "-31.93097", "115.89486", "Australia/Perth"),
("2066981", "Margaret River", "", "AU", "36", "", "08", "50280", "", "-33.95504", "115.07599", "Australia/Perth"),
("2067119", "Mandurah", "Мандъюра", "AU", "36", "", "08", "55110", "", "-32.5269", "115.7217", "Australia/Perth"),
("2067260", "Maddington", "", "AU", "36", "", "08", "53780", "", "-32.05", "115.98333", "Australia/Perth"),
("2068079", "Kwinana", "", "AU", "36", "", "08", "54830", "", "-32.23013", "115.78128", "Australia/Perth"),
("2068110", "Kununurra", "", "AU", "36", "", "08", "59520", "", "-15.77825", "128.74208", "Australia/Perth"),
("2068569", "Kenwick", "", "AU", "36", "", "08", "53780", "", "-32.03333", "115.96667", "Australia/Perth"),
("2068594", "Kelmscott", "", "AU", "36", "", "08", "50210", "", "-32.12434", "116.0259", "Australia/Perth"),
("2068655", "Katherine", "", "AU", "36", "", "03", "72200", "", "-14.46517", "132.26347", "Australia/Darwin"),
("2068823", "Kalgoorlie", "Калгурли", "AU", "36", "", "08", "54280", "", "-30.74614", "121.4742", "Australia/Perth"),
("2069375", "Ingle Farm", "", "AU", "36", "", "05", "47140", "", "-34.83333", "138.63333", "Australia/Adelaide"),
("2069646", "Hope Valley", "", "AU", "36", "", "05", "47700", "", "-34.83333", "138.7", "Australia/Adelaide"),
("2070106", "Happy Valley", "", "AU", "36", "", "05", "44060", "", "-35.08333", "138.53333", "Australia/Adelaide"),
("2070515", "Grange", "", "AU", "36", "", "05", "41060", "", "-34.90223", "138.49022", "Australia/Adelaide"),
("2070571", "Gosnells", "", "AU", "36", "", "08", "53780", "", "-32.081", "116.0054", "Australia/Perth"),
("2070711", "Golden Grove", "", "AU", "36", "", "05", "47700", "", "-34.78333", "138.73333", "Australia/Adelaide"),
("2070998", "Geraldton", "Джералдтон", "AU", "36", "", "08", "53520", "", "-28.77897", "114.61459", "Australia/Perth"),
("2071059", "Gawler", "Голер", "AU", "36", "", "05", "42030", "", "-34.60251", "138.74902", "Australia/Adelaide"),
("2071223", "Fremantle", "Фримантл", "AU", "36", "", "08", "53430", "", "-32.05454", "115.75127", "Australia/Perth"),
("2071601", "Findon", "", "AU", "36", "", "05", "41060", "", "-34.9", "138.53333", "Australia/Adelaide"),
("2071860", "Esperance", "", "AU", "36", "", "08", "53290", "", "-33.85919", "121.89164", "Australia/Perth"),
("2073124", "Darwin", "Дарвин", "AU", "36", "", "03", "71000", "", "-12.46113", "130.84185", "Australia/Darwin"),
("2073603", "Cottesloe", "", "AU", "36", "", "08", "56930", "", "-32", "115.76667", "Australia/Perth"),
("2074113", "Collie", "", "AU", "36", "", "08", "51890", "", "-33.36206", "116.15617", "Australia/Perth"),
("2074865", "Carnarvon", "", "AU", "36", "", "08", "51540", "", "-24.88258", "113.65713", "Australia/Perth"),
("2075056", "Campbelltown", "", "AU", "36", "AU", "05", "40910", "", "-34.88333", "138.66667", "Australia/Adelaide"),
("2075265", "Busselton", "", "AU", "36", "", "08", "51260", "", "-33.65249", "115.3455", "Australia/Perth"),
("2075432", "Bunbury", "Банбери", "AU", "36", "", "08", "51190", "", "-33.32711", "115.64137", "Australia/Perth"),
("2075720", "Broome", "", "AU", "36", "", "08", "50980", "", "-17.95538", "122.23922", "Australia/Perth"),
("2075988", "Boulder", "", "AU", "36", "", "08", "54280", "", "-30.78204", "121.4912", "Australia/Perth"),
("2076752", "Bentley", "", "AU", "36", "", "08", "51330", "", "-32", "115.91667", "Australia/Perth"),
("2077030", "Bassendean", "", "AU", "36", "", "08", "50350", "", "-31.90906", "115.9437", "Australia/Perth"),
("2077454", "Australind", "", "AU", "36", "", "08", "53990", "", "-33.2792", "115.71504", "Australia/Perth"),
("2077579", "Armadale", "", "AU", "36", "", "08", "50210", "", "-32.14607", "116.0093", "Australia/Perth"),
("2077641", "Applecross", "", "AU", "36", "", "08", "55320", "", "-32.01667", "115.83333", "Australia/Perth"),
("2077895", "Alice Springs", "Алис-Спрингс", "AU", "36", "", "03", "70200", "", "-23.69748", "133.88362", "Australia/Darwin"),
("2077935", "Aldinga", "", "AU", "36", "", "05", "45340", "", "-35.28333", "138.48333", "Australia/Adelaide"),
("2077963", "Albany", "Олбани", "AU", "36", "", "08", "50080", "", "-35.0031", "117.86595", "Australia/Perth"),
("2078025", "Adelaide", "Аделаида", "AU", "36", "", "05", "40070", "", "-34.92866", "138.59863", "Australia/Adelaide"),
("2078313", "Eaton", "", "AU", "36", "", "08", "52660", "", "-33.31664", "115.70503", "Australia/Perth"),
("2078766", "Quinns Rocks", "", "AU", "36", "", "08", "58760", "", "-31.67379", "115.70372", "Australia/Perth"),
("2078894", "East Fremantle", "", "AU", "36", "", "08", "53150", "", "-32.03823", "115.7676", "Australia/Perth"),
("2078904", "Claremont", "", "AU", "36", "", "08", "51750", "", "-31.97961", "115.7823", "Australia/Perth"),
("2078907", "Bicton", "", "AU", "36", "", "08", "55320", "", "-32.02778", "115.78333", "Australia/Perth"),
("2078908", "Attadale", "", "AU", "36", "", "08", "55320", "", "-32.02489", "115.802", "Australia/Perth"),
("2079183", "Warnbro", "", "AU", "36", "", "08", "57490", "", "-32.34017", "115.7473", "Australia/Perth"),
("2079189", "Mullaloo", "", "AU", "36", "", "08", "54170", "", "-31.77896", "115.73676", "Australia/Perth"),
("2142245", "Young", "", "AU", "36", "", "02", "18750", "", "-34.3135", "148.30107", "Australia/Sydney"),
("2142316", "Yeppoon", "", "AU", "36", "", "04", "36360", "", "-23.12683", "150.74406", "Australia/Brisbane"),
("2142412", "Yass", "", "AU", "36", "", "02", "18710", "", "-34.84036", "148.90987", "Australia/Sydney"),
("2142447", "Yarrawonga", "", "AU", "36", "", "07", "24900", "", "-36.01923", "145.99973", "Australia/Sydney"),
("2142457", "Yarraville", "", "AU", "36", "", "07", "24330", "", "-37.81667", "144.9", "Australia/Melbourne"),
("2142747", "Wynyard", "", "AU", "36", "", "06", "65410", "", "-40.9897", "145.72617", "Australia/Hobart"),
("2142750", "Wynnum", "", "AU", "36", "", "04", "31000", "", "-27.44527", "153.15813", "Australia/Brisbane"),
("2143069", "Woodridge", "", "AU", "36", "", "04", "34590", "", "-27.63333", "153.1", "Australia/Brisbane"),
("2143285", "Wodonga", "Уодонга", "AU", "36", "", "07", "27170", "", "-36.12179", "146.88809", "Australia/Melbourne"),
("2143407", "Windsor", "", "AU", "36", "", "07", "26350", "", "-37.85344", "144.99241", "Australia/Melbourne"),
("2143561", "Williamstown", "", "AU", "36", "", "07", "23110", "", "-37.857", "144.89769", "Australia/Melbourne"),
("2144095", "Werribee", "", "AU", "36", "", "07", "27260", "", "-37.9", "144.66667", "Australia/Melbourne"),
("2144157", "Wellington Point", "", "AU", "36", "", "04", "36250", "", "-27.48333", "153.25", "Australia/Brisbane"),
("2144168", "Wellington", "", "AU", "36", "", "02", "18150", "", "-32.55588", "148.94508", "Australia/Sydney"),
("2144397", "Watsonia", "", "AU", "36", "", "07", "20660", "", "-37.71667", "145.08333", "Australia/Melbourne"),
("2144502", "Warwick", "", "AU", "36", "", "04", "36660", "", "-28.21901", "152.03438", "Australia/Brisbane"),
("2144528", "Warrnambool", "Уорнамбул", "AU", "36", "", "07", "26730", "", "-38.38176", "142.48799", "Australia/Melbourne"),
("2144583", "Warrandyte", "", "AU", "36", "", "07", "24210", "", "-37.75", "145.23333", "Australia/Melbourne"),
("2144604", "Warragul", "", "AU", "36", "", "07", "20830", "", "-38.15912", "145.93118", "Australia/Melbourne"),
("2144728", "Wantirna South", "", "AU", "36", "", "07", "23670", "", "-37.88333", "145.21667", "Australia/Melbourne"),
("2144729", "Wantirna", "", "AU", "36", "", "07", "23670", "", "-37.85", "145.21667", "Australia/Melbourne"),
("2144764", "Wangaratta", "Уангаратта", "AU", "36", "", "07", "26700", "", "-36.35846", "146.32056", "Australia/Melbourne"),
("2145110", "Wagga Wagga", "Уогга Уогга", "AU", "36", "", "02", "17750", "", "-35.12577", "147.35375", "Australia/Sydney"),
("2145214", "Victoria Point", "", "AU", "36", "", "04", "36250", "", "-27.58329", "153.31172", "Australia/Brisbane"),
("2145267", "Vermont", "", "AU", "36", "", "07", "26980", "", "-37.83616", "145.19428", "Australia/Melbourne"),
("2145392", "Urangan", "", "AU", "36", "", "04", "33220", "", "-25.29214", "152.90535", "Australia/Brisbane"),
("2145409", "Upwey", "", "AU", "36", "", "07", "27450", "", "-37.9", "145.33333", "Australia/Melbourne"),
("2145461", "Upper Coomera", "", "AU", "36", "", "04", "33430", "", "-27.9", "153.3", "Australia/Brisbane"),
("2145532", "Ulverstone", "", "AU", "36", "", "06", "60810", "", "-41.16026", "146.18242", "Australia/Hobart"),
("2145554", "Ulladulla", "", "AU", "36", "", "02", "16950", "", "-35.35906", "150.47247", "Australia/Sydney"),
("2145875", "Tumut", "", "AU", "36", "", "02", "17500", "", "-35.30016", "148.22505", "Australia/Sydney"),
("2145921", "Tullamarine", "", "AU", "36", "", "07", "23270", "", "-37.70128", "144.881", "Australia/Melbourne"),
("2145990", "Truganina", "", "AU", "36", "", "07", "27260", "", "-37.81667", "144.75", "Australia/Melbourne"),
("2146108", "Traralgon", "Траралгон", "AU", "36", "", "07", "23810", "", "-38.19528", "146.5415", "Australia/Melbourne"),
("2146142", "Townsville", "Таунсвилл", "AU", "36", "", "04", "37010", "", "-19.26639", "146.80569", "Australia/Brisbane"),
("2146219", "Torquay", "", "AU", "36", "", "04", "33220", "", "-25.28496", "152.87886", "Australia/Brisbane"),
("2146268", "Toowoomba", "Тувумба", "AU", "36", "", "04", "36910", "", "-27.56056", "151.95386", "Australia/Brisbane"),
("2146291", "Toorak", "", "AU", "36", "", "07", "26350", "", "-37.84165", "145.01438", "Australia/Melbourne"),
("2146793", "Thornbury", "", "AU", "36", "", "07", "21890", "", "-37.75", "145", "Australia/Melbourne"),
("2146827", "Thomastown", "", "AU", "36", "", "07", "27070", "", "-37.68333", "145.01667", "Australia/Melbourne"),
("2146997", "Tewantin", "", "AU", "36", "", "04", "36710", "", "-26.39104", "153.03432", "Australia/Brisbane"),
("2147139", "Templestowe Lower", "", "AU", "36", "", "07", "24210", "", "-37.76667", "145.11667", "Australia/Melbourne"),
("2147336", "Tarragindi", "", "AU", "36", "", "04", "31000", "", "-27.53333", "153.03333", "Australia/Brisbane"),
("2147357", "Tarneit", "", "AU", "36", "", "07", "27260", "", "-37.86667", "144.66667", "Australia/Melbourne"),
("2147381", "Taree", "Тари", "AU", "36", "", "02", "13350", "", "-31.91099", "152.45387", "Australia/Sydney"),
("2147497", "Tamworth", "Тамуорт", "AU", "36", "", "02", "17310", "", "-31.09048", "150.92905", "Australia/Sydney"),
("2147714", "Sydney", "Сидней", "AU", "36", "", "02", "17200", "", "-33.86785", "151.20732", "Australia/Sydney"),
("2147717", "Sydenham", "", "AU", "36", "", "07", "21180", "", "-37.7", "144.76667", "Australia/Melbourne"),
("2147756", "Swan Hill", "", "AU", "36", "", "07", "26610", "", "-35.33781", "143.5544", "Australia/Melbourne"),
("2147826", "Surrey Hills", "", "AU", "36", "", "07", "21110", "", "-37.81667", "145.1", "Australia/Melbourne"),
("2147849", "Surfers Paradise", "Сёрферс Парадайз", "AU", "36", "", "04", "33430", "", "-28.00274", "153.42999", "Australia/Brisbane"),
("2147892", "Sunnybank", "", "AU", "36", "", "04", "31000", "", "-27.58333", "153.05", "Australia/Brisbane"),
("2147914", "Sunbury", "Санбери", "AU", "36", "", "07", "23270", "", "-37.57742", "144.72607", "Australia/Melbourne"),
("2148070", "Strathpine", "", "AU", "36", "", "04", "35010", "", "-27.30414", "152.98977", "Australia/Brisbane"),
("2148398", "Port Stephens", "", "AU", "36", "AU", "02", "16400", "", "-32.71314", "152.06623", "Australia/Sydney"),
("2148431", "Stawell", "", "AU", "36", "", "07", "25810", "", "-37.05632", "142.78088", "Australia/Melbourne"),
("2148588", "Springvale South", "", "AU", "36", "", "07", "22670", "", "-37.96667", "145.15", "Australia/Melbourne"),
("2148591", "Springvale", "", "AU", "36", "", "07", "22670", "", "-37.94853", "145.15274", "Australia/Melbourne"),
("2148928", "Southport", "", "AU", "36", "", "04", "33430", "", "-27.96724", "153.39796", "Australia/Brisbane"),
("2148955", "South Melbourne", "", "AU", "36", "", "07", "25900", "", "-37.83333", "144.96667", "Australia/Melbourne"),
("2148997", "South Grafton", "", "AU", "36", "", "02", "11730", "", "-29.7076", "152.92627", "Australia/Sydney"),
("2149128", "Somerville", "", "AU", "36", "", "07", "25340", "", "-38.21667", "145.16667", "Australia/Melbourne"),
("2149349", "Slacks Creek", "", "AU", "36", "", "04", "34590", "", "-27.65", "153.15", "Australia/Brisbane"),
("2149475", "Singleton", "", "AU", "36", "", "02", "17000", "", "-32.56742", "151.16603", "Australia/Sydney"),
("2149645", "Shepparton", "Шеппартон", "AU", "36", "", "07", "22830", "", "-36.38047", "145.39867", "Australia/Melbourne"),
("2149936", "Sebastopol", "", "AU", "36", "", "07", "20570", "", "-37.58532", "143.83953", "Australia/Melbourne"),
("2149975", "Seaford", "", "AU", "36", "", "07", "22170", "", "-38.1", "145.13333", "Australia/Melbourne"),
("2150093", "Scoresby", "", "AU", "36", "", "07", "23670", "", "-37.9", "145.23333", "Australia/Melbourne"),
("2150615", "Sale", "", "AU", "36", "", "07", "26810", "", "-38.11095", "147.06802", "Australia/Melbourne"),
("2150660", "Saint Kilda", "", "AU", "36", "", "07", "25900", "", "-37.8676", "144.98099", "Australia/Melbourne"),
("2150717", "Saint Albans", "", "AU", "36", "", "07", "21180", "", "-37.73333", "144.8", "Australia/Melbourne"),
("2150765", "Rye", "", "AU", "36", "", "07", "", "", "-38.36667", "144.81667", "Australia/Melbourne"),
("2150791", "Rutherford", "", "AU", "36", "", "02", "15050", "", "-32.71667", "151.53333", "Australia/Sydney"),
("2150894", "Rowville", "", "AU", "36", "", "07", "23670", "", "-37.93333", "145.23333", "Australia/Melbourne"),
("2151120", "Rosebud", "", "AU", "36", "", "07", "25340", "", "-38.35542", "144.9068", "Australia/Melbourne"),
("2151146", "Rosanna", "", "AU", "36", "", "07", "20660", "", "-37.75", "145.06667", "Australia/Melbourne"),
("2151187", "Roma", "", "AU", "36", "", "04", "34860", "", "-26.56741", "148.78751", "Australia/Brisbane"),
("2151437", "Rockhampton", "Рокхемптон", "AU", "36", "", "04", "36360", "", "-23.38032", "150.50595", "Australia/Brisbane"),
("2151522", "Riverstone", "", "AU", "36", "", "02", "10750", "", "-33.68333", "150.86667", "Australia/Sydney"),
("2151575", "Ringwood East", "", "AU", "36", "", "07", "24410", "", "-37.81667", "145.25", "Australia/Melbourne"),
("2151649", "Richmond", "", "AU", "36", "", "07", "27350", "", "-37.81819", "145.00176", "Australia/Melbourne"),
("2151650", "Richmond", "", "AU", "36", "", "02", "13800", "", "-33.59956", "150.75142", "Australia/Sydney"),
("2151716", "Reservoir", "", "AU", "36", "", "07", "21890", "", "-37.71667", "145", "Australia/Melbourne"),
("2151886", "Redlynch", "", "AU", "36", "", "04", "32070", "", "-16.88333", "145.7", "Australia/Brisbane"),
("2151905", "Red Hill", "", "AU", "36", "", "04", "37340", "", "-20.31667", "148.5", "Australia/Brisbane"),
("2151932", "Redfern", "", "AU", "36", "", "02", "17200", "", "-33.89279", "151.20415", "Australia/Sydney"),
("2152071", "Rathmines", "", "AU", "36", "", "02", "14650", "", "-33.03773", "151.58443", "Australia/Sydney"),
("2152286", "Queanbeyan", "Куинбеян", "AU", "36", "", "02", "16470", "", "-35.35493", "149.232", "Australia/Sydney"),
("2152329", "Quakers Hill", "", "AU", "36", "", "02", "10750", "", "-33.73333", "150.88333", "Australia/Sydney"),
("2152361", "Pymble", "", "AU", "36", "", "02", "17200", "", "-33.74386", "151.14188", "Australia/Sydney"),
("2152558", "Preston", "", "AU", "36", "", "07", "21890", "", "-37.75", "145.01667", "Australia/Melbourne"),
("2152658", "Port Melbourne", "", "AU", "36", "", "07", "25900", "", "-37.83961", "144.94228", "Australia/Melbourne"),
("2152659", "Port Macquarie", "Порт Маккуори", "AU", "36", "", "02", "16380", "", "-31.43084", "152.90894", "Australia/Sydney"),
("2152667", "Portland", "", "AU", "36", "", "07", "22410", "", "-38.3462", "141.60257", "Australia/Melbourne"),
("2152819", "Point Cook", "", "AU", "36", "", "07", "27260", "", "-37.91482", "144.75088", "Australia/Melbourne"),
("2153467", "Penshurst", "", "AU", "36", "", "02", "14150", "", "-33.96667", "151.08333", "Australia/Sydney"),
("2153471", "Penrith", "", "AU", "36", "", "02", "16350", "", "-33.75", "150.7", "Australia/Sydney"),
("2153483", "Pennant Hills", "", "AU", "36", "", "02", "14000", "", "-33.73783", "151.07216", "Australia/Sydney"),
("2153720", "Pascoe Vale", "", "AU", "36", "", "07", "25250", "", "-37.73333", "144.93333", "Australia/Melbourne"),
("2153770", "Parkville", "", "AU", "36", "", "07", "24600", "", "-37.78333", "144.95", "Australia/Melbourne"),
("2153778", "Parkes", "", "AU", "36", "", "02", "16200", "", "-33.1372", "148.1759", "Australia/Sydney"),
("2153784", "Parkdale", "", "AU", "36", "", "07", "23430", "", "-37.98333", "145.06667", "Australia/Melbourne"),
("2153925", "Palm Beach", "", "AU", "36", "", "04", "33430", "", "-28.11694", "153.46584", "Australia/Brisbane"),
("2153951", "Pakenham South", "", "AU", "36", "", "07", "21450", "", "-38.13333", "145.51667", "Australia/Melbourne"),
("2154172", "Ormond", "", "AU", "36", "", "07", "22310", "", "-37.9", "145.03333", "Australia/Melbourne"),
("2154219", "Orange", "Орандж", "AU", "36", "", "02", "16150", "", "-33.28397", "149.10018", "Australia/Sydney"),
("2154544", "Oatley", "", "AU", "36", "", "02", "14150", "", "-33.98004", "151.07201", "Australia/Sydney"),
("2154720", "Nunawading", "", "AU", "36", "", "07", "26980", "", "-37.82043", "145.17308", "Australia/Melbourne"),
("2154787", "Nowra", "Новра", "AU", "36", "", "02", "16950", "", "-34.88422", "150.60036", "Australia/Sydney"),
("2154826", "North Wonthaggi", "", "AU", "36", "", "07", "20740", "", "-38.6", "145.6", "Australia/Melbourne"),
("2154855", "North Sydney", "", "AU", "36", "", "02", "15950", "", "-33.839", "151.2072", "Australia/Sydney"),
("2154912", "North Melbourne", "", "AU", "36", "", "07", "24600", "", "-37.8", "144.96667", "Australia/Melbourne"),
("2154913", "Northmead", "", "AU", "36", "", "02", "16250", "", "-33.78333", "150.98333", "Australia/Sydney"),
("2154962", "North Fitzroy", "", "AU", "36", "", "07", "27350", "", "-37.78862", "144.97885", "Australia/Melbourne"),
("2155001", "Northcote", "", "AU", "36", "", "07", "21890", "", "-37.76667", "145", "Australia/Melbourne"),
("2155132", "Noosaville", "", "AU", "36", "", "04", "36710", "", "-26.4", "153.06667", "Australia/Brisbane"),
("2155204", "Noble Park", "", "AU", "36", "", "07", "22670", "", "-37.96667", "145.16667", "Australia/Melbourne"),
("2155386", "Newtown", "", "AU", "36", "", "02", "15200", "", "-33.89835", "151.17754", "Australia/Sydney"),
("2155411", "Newport", "", "AU", "36", "", "07", "23110", "", "-37.84427", "144.88483", "Australia/Melbourne"),
("2155412", "Newport", "", "AU", "36", "", "02", "16370", "", "-33.65639", "151.31401", "Australia/Sydney"),
("2155415", "New Norfolk", "", "AU", "36", "", "06", "61510", "", "-42.78261", "147.0587", "Australia/Hobart"),
("2155416", "Newnham", "", "AU", "36", "", "06", "64010", "", "-41.39714", "147.13127", "Australia/Hobart"),
("2155472", "Newcastle", "Ньюкасл", "AU", "36", "", "02", "15900", "", "-32.92715", "151.77647", "Australia/Sydney"),
("2155542", "Nerang", "", "AU", "36", "", "04", "33430", "", "-27.98941", "153.33633", "Australia/Brisbane"),
("2155562", "Nelson Bay", "", "AU", "36", "", "02", "16400", "", "-32.72043", "152.14398", "Australia/Sydney"),
("2155717", "Narre Warren North", "", "AU", "36", "", "07", "21610", "", "-37.98333", "145.31667", "Australia/Melbourne"),
("2155718", "Narre Warren", "", "AU", "36", "", "07", "21610", "", "-38.03333", "145.3", "Australia/Melbourne"),
("2155742", "Narrabri", "", "AU", "36", "", "02", "15750", "", "-30.32488", "149.78266", "Australia/Sydney"),
("2155745", "Narrabeen", "", "AU", "36", "", "02", "18000", "", "-33.71277", "151.29736", "Australia/Sydney"),
("2155772", "Narellan", "", "AU", "36", "", "02", "11450", "", "-34.03333", "150.73333", "Australia/Sydney"),
("2155783", "Narara", "", "AU", "36", "", "02", "13100", "", "-33.4", "151.35", "Australia/Sydney"),
("2155787", "Narangba", "", "AU", "36", "", "04", "35010", "", "-27.20338", "152.95923", "Australia/Brisbane"),
("2155796", "Naracoorte", "", "AU", "36", "", "05", "45090", "", "-36.95785", "140.7383", "Australia/Adelaide"),
("2155858", "Nambucca Heads", "", "AU", "36", "", "02", "15700", "", "-30.64318", "153.00884", "Australia/Sydney"),
("2155859", "Nambucca", "", "AU", "36", "", "02", "15700", "", "-30.63333", "152.98333", "Australia/Sydney"),
("2155862", "Nambour", "", "AU", "36", "", "04", "36710", "", "-26.62613", "152.95941", "Australia/Brisbane"),
("2156034", "Muswellbrook", "", "AU", "36", "", "02", "15650", "", "-32.26118", "150.89009", "Australia/Sydney"),
("2156049", "Murwillumbah", "", "AU", "36", "", "02", "17550", "", "-28.32732", "153.39339", "Australia/Sydney"),
("2156067", "Murrumbeena", "", "AU", "36", "", "07", "22310", "", "-37.9", "145.06667", "Australia/Melbourne"),
("2156340", "Mulgrave", "", "AU", "36", "", "07", "24970", "", "-37.91667", "145.2", "Australia/Melbourne"),
("2156404", "Mudgee", "", "AU", "36", "", "02", "15270", "", "-32.59426", "149.5871", "Australia/Sydney"),
("2156578", "Mount Martha", "", "AU", "36", "", "07", "25340", "", "-38.26667", "145.01667", "Australia/Melbourne"),
("2156643", "Mount Gambier", "Маунт-Гамбиер", "AU", "36", "", "05", "44620", "", "-37.8318", "140.77919", "Australia/Adelaide"),
("2156652", "Mount Evelyn", "", "AU", "36", "", "07", "27450", "", "-37.78333", "145.38333", "Australia/Melbourne"),
("2156663", "Mount Eliza", "", "AU", "36", "", "07", "25340", "", "-38.18333", "145.08333", "Australia/Melbourne"),
("2156671", "Mount Druitt", "", "AU", "36", "", "02", "10750", "", "-33.76667", "150.81667", "Australia/Sydney"),
("2156694", "Mount Colah", "", "AU", "36", "", "02", "14000", "", "-33.68333", "151.11667", "Australia/Sydney"),
("2156777", "Moss Vale", "", "AU", "36", "", "02", "18350", "", "-34.55374", "150.37115", "Australia/Sydney"),
("2156813", "Mosman", "Мосман", "AU", "36", "", "02", "15350", "", "-33.83902", "151.23956", "Australia/Sydney"),
("2156825", "Morwell", "", "AU", "36", "", "07", "23810", "", "-38.23476", "146.39499", "Australia/Melbourne"),
("2156853", "Mortdale", "", "AU", "36", "", "02", "14150", "", "-33.96667", "151.08333", "Australia/Sydney"),
("2156878", "Mornington", "Морнингтон", "AU", "36", "", "07", "25340", "", "-38.21792", "145.03876", "Australia/Melbourne"),
("2156927", "Moree", "", "AU", "36", "", "02", "15300", "", "-29.46278", "149.84157", "Australia/Sydney"),
("2156933", "Mordialloc", "", "AU", "36", "", "07", "23430", "", "-38", "145.08333", "Australia/Melbourne"),
("2156934", "Morayfield", "", "AU", "36", "", "04", "35010", "", "-27.10876", "152.94907", "Australia/Brisbane"),
("2157026", "Moorabbin", "", "AU", "36", "", "07", "20910", "", "-37.93667", "145.03417", "Australia/Melbourne"),
("2157056", "Moonee Ponds", "", "AU", "36", "", "07", "25060", "", "-37.76667", "144.91667", "Australia/Melbourne"),
("2157090", "Moonah", "", "AU", "36", "", "06", "62610", "", "-42.84617", "147.30228", "Australia/Hobart"),
("2157109", "Mooloolaba", "", "AU", "36", "", "04", "36710", "", "-26.68164", "153.11925", "Australia/Brisbane"),
("2157161", "Montrose", "", "AU", "36", "", "07", "27450", "", "-37.81667", "145.35", "Australia/Melbourne"),
("2157167", "Montmorency", "", "AU", "36", "", "07", "20660", "", "-37.71667", "145.11667", "Australia/Melbourne"),
("2157343", "Moe", "Мои", "AU", "36", "", "07", "23810", "", "-38.17828", "146.26099", "Australia/Melbourne"),
("2157373", "Mittagong", "", "AU", "36", "", "02", "18350", "", "-34.45002", "150.44572", "Australia/Sydney"),
("2157410", "Mitcham", "", "AU", "36", "", "07", "26980", "", "-37.81667", "145.2", "Australia/Melbourne"),
("2157495", "Miranda", "", "AU", "36", "", "02", "17150", "", "-34.03857", "151.10005", "Australia/Sydney"),
("2157635", "Mill Park", "", "AU", "36", "", "07", "27070", "", "-37.66667", "145.06667", "Australia/Melbourne"),
("2157652", "Millicent", "", "AU", "36", "", "05", "48340", "", "-37.59389", "140.34947", "Australia/Adelaide"),
("2157698", "Mildura", "Милдьюра", "AU", "36", "", "07", "24780", "", "-34.18551", "142.16251", "Australia/Melbourne"),
("2157995", "Merrylands", "", "AU", "36", "", "02", "13950", "", "-33.83333", "150.98333", "Australia/Sydney"),
("2158020", "Merimbula", "", "AU", "36", "", "02", "10550", "", "-36.88901", "149.90961", "Australia/Sydney"),
("2158051", "Mernda", "", "AU", "36", "", "07", "27070", "", "-37.60075", "145.09555", "Australia/Melbourne"),
("2158109", "Mentone", "", "AU", "36", "", "07", "23430", "", "-37.98333", "145.06667", "Australia/Melbourne"),
("2158130", "Menai", "", "AU", "36", "", "02", "17150", "", "-34.01667", "151.01667", "Australia/Sydney"),
("2158145", "Melton South", "", "AU", "36", "", "07", "24650", "", "-37.70773", "144.57493", "Australia/Melbourne"),
("2158151", "Melton", "Мелтон", "AU", "36", "", "07", "24650", "", "-37.68339", "144.58543", "Australia/Melbourne"),
("2158177", "Melbourne", "Мельбурн", "AU", "36", "", "07", "24600", "", "-37.814", "144.96332", "Australia/Melbourne"),
("2158220", "Medowie", "", "AU", "36", "", "02", "16400", "", "-32.7415", "151.8676", "Australia/Sydney"),
("2158307", "McKinnon", "", "AU", "36", "", "07", "22310", "", "-37.91667", "145.05", "Australia/Melbourne"),
("2158504", "Matraville", "", "AU", "36", "", "02", "16550", "", "-33.95", "151.23333", "Australia/Sydney"),
("2158538", "Mascot", "", "AU", "36", "", "02", "11100", "", "-33.92598", "151.19347", "Australia/Sydney"),
("2158561", "Maryborough", "", "AU", "36", "", "07", "21670", "", "-37.04562", "143.73923", "Australia/Melbourne"),
("2158562", "Maryborough", "Мэриборо", "AU", "36", "", "04", "33220", "", "-25.54073", "152.70493", "Australia/Brisbane"),
("2158626", "Marrickville", "", "AU", "36", "", "02", "15200", "", "-33.90318", "151.15176", "Australia/Sydney"),
("2158651", "Maroubra", "", "AU", "36", "", "02", "16550", "", "-33.95", "151.23333", "Australia/Sydney"),
("2158724", "Maribyrnong", "", "AU", "36", "", "07", "24330", "", "-37.78333", "144.88333", "Australia/Melbourne"),
("2158745", "Margate", "", "AU", "36", "", "04", "35010", "", "-27.24761", "153.09809", "Australia/Brisbane"),
("2158767", "Mareeba", "", "AU", "36", "", "04", "36810", "", "-16.99096", "145.42306", "Australia/Brisbane"),
("2158867", "Manly", "", "AU", "36", "", "02", "15150", "", "-33.79798", "151.28826", "Australia/Sydney"),
("2159045", "Maitland", "Мейтленд", "AU", "36", "", "02", "15050", "", "-32.73308", "151.5574", "Australia/Sydney"),
("2159177", "Macleod", "", "AU", "36", "", "07", "20660", "", "-37.73333", "145.06667", "Australia/Melbourne"),
("2159220", "Mackay", "Макей", "AU", "36", "", "04", "34770", "", "-21.15345", "149.16554", "Australia/Brisbane"),
("2159291", "Lysterfield", "", "AU", "36", "", "07", "27450", "", "-37.93333", "145.3", "Australia/Melbourne"),
("2159654", "Long Jetty", "", "AU", "36", "", "02", "18550", "", "-33.35795", "151.48135", "Australia/Sydney"),
("2159851", "Liverpool", "", "AU", "36", "", "02", "12850", "", "-33.9", "150.93333", "Australia/Sydney"),
("2160053", "Lithgow", "", "AU", "36", "", "02", "14870", "", "-33.48247", "150.13631", "Australia/Sydney"),
("2160063", "Lismore", "Лизмор", "AU", "36", "", "02", "14850", "", "-28.81354", "153.2773", "Australia/Sydney"),
("2160070", "Lisarow", "", "AU", "36", "", "02", "13100", "", "-33.38333", "151.36667", "Australia/Sydney"),
("2160113", "Lindisfarne", "", "AU", "36", "", "06", "61410", "", "-42.84837", "147.36192", "Australia/Hobart"),
("2160114", "Lindfield", "", "AU", "36", "", "02", "14500", "", "-33.78333", "151.16667", "Australia/Sydney"),
("2160188", "Lilydale", "", "AU", "36", "", "07", "27450", "", "-37.75", "145.35", "Australia/Melbourne"),
("2160258", "Lidcombe", "", "AU", "36", "", "02", "10200", "", "-33.86436", "151.0397", "Australia/Sydney"),
("2160299", "Leumeah", "", "AU", "36", "", "02", "11500", "", "-34.05", "150.83333", "Australia/Sydney"),
("2160336", "Leopold", "", "AU", "36", "", "07", "22750", "", "-38.19001", "144.46825", "Australia/Melbourne"),
("2160386", "Leichhardt", "", "AU", "36", "", "02", "14800", "", "-33.88341", "151.15625", "Australia/Sydney"),
("2160413", "Leeton", "", "AU", "36", "", "02", "14750", "", "-34.55105", "146.40483", "Australia/Sydney"),
("2160493", "Lavington", "", "AU", "36", "", "02", "10050", "", "-36.03976", "146.93958", "Australia/Sydney"),
("2160517", "Launceston", "Лонсестон", "AU", "36", "", "06", "64010", "", "-41.43876", "147.13467", "Australia/Hobart"),
("2160560", "Lara", "", "AU", "36", "", "07", "22750", "", "-38.02388", "144.40617", "Australia/Melbourne"),
("2160582", "Langwarrin", "", "AU", "36", "", "07", "22170", "", "-38.16667", "145.16667", "Australia/Melbourne"),
("2160706", "Lalor", "", "AU", "36", "", "07", "27070", "", "-37.66667", "145.01667", "Australia/Melbourne"),
("2160735", "Lakes Entrance", "", "AU", "36", "", "07", "22110", "", "-37.86679", "148.00159", "Australia/Melbourne"),
("2160744", "Lakemba", "", "AU", "36", "", "02", "11550", "", "-33.91972", "151.07592", "Australia/Sydney"),
("2160774", "Lake Albert", "", "AU", "36", "", "02", "17750", "", "-35.16667", "147.38333", "Australia/Sydney"),
("2160910", "Kyabram", "", "AU", "36", "", "07", "21370", "", "-36.31335", "145.05035", "Australia/Melbourne"),
("2160922", "Kurri Kurri", "", "AU", "36", "", "02", "11720", "", "-32.81933", "151.47908", "Australia/Sydney"),
("2161311", "Kingston", "", "AU", "36", "", "06", "63610", "", "-42.97638", "147.30351", "Australia/Hobart"),
("2161335", "Kingscliff", "", "AU", "36", "", "02", "17550", "", "-28.25983", "153.57816", "Australia/Sydney"),
("2161376", "Kingaroy", "", "AU", "36", "", "04", "36630", "", "-26.53994", "151.8373", "Australia/Brisbane"),
("2161408", "Kilsyth", "", "AU", "36", "", "07", "27450", "", "-37.8", "145.31667", "Australia/Melbourne"),
("2161515", "Kiama", "", "AU", "36", "", "02", "14400", "", "-34.66828", "150.85219", "Australia/Sydney"),
("2161532", "Keysborough", "", "AU", "36", "", "07", "22670", "", "-37.99116", "145.17385", "Australia/Melbourne"),
("2161540", "Kew", "", "AU", "36", "", "07", "21110", "", "-37.80639", "145.03086", "Australia/Melbourne"),
("2161602", "Kenthurst", "", "AU", "36", "", "02", "10500", "", "-33.65527", "151.00503", "Australia/Sydney"),
("2161608", "Kensington", "", "AU", "36", "", "02", "16550", "", "-33.92019", "151.22241", "Australia/Sydney"),
("2161609", "Kensington", "", "AU", "36", "", "07", "25060", "", "-37.78333", "144.93333", "Australia/Melbourne"),
("2161613", "Kennington", "", "AU", "36", "", "07", "22620", "", "-36.78333", "144.3", "Australia/Melbourne"),
("2161658", "Kempsey", "", "AU", "36", "", "02", "14350", "", "-31.07898", "152.83093", "Australia/Sydney"),
("2161678", "Kelso", "", "AU", "36", "", "02", "10470", "", "-33.41667", "149.6", "Australia/Sydney"),
("2161719", "Keilor", "", "AU", "36", "", "07", "21180", "", "-37.71667", "144.83333", "Australia/Melbourne"),
("2161776", "Katoomba", "Катумба", "AU", "36", "", "02", "10900", "", "-33.71977", "150.30739", "Australia/Sydney"),
("2161903", "Kangaroo Flat", "", "AU", "36", "", "07", "22620", "", "-36.8", "144.25", "Australia/Melbourne"),
("2162419", "Jannali", "", "AU", "36", "", "02", "17150", "", "-34.01643", "151.06065", "Australia/Sydney"),
("2162662", "Inverell", "", "AU", "36", "", "02", "14200", "", "-29.77403", "151.11166", "Australia/Sydney"),
("2162683", "Innisfail", "", "AU", "36", "", "04", "32260", "", "-17.52209", "146.03102", "Australia/Brisbane"),
("2162733", "Ingleburn", "", "AU", "36", "", "02", "11500", "", "-34", "150.86667", "Australia/Sydney"),
("2162737", "Ingham", "", "AU", "36", "", "04", "33800", "", "-18.64552", "146.16248", "Australia/Brisbane"),
("2162970", "Hughesdale", "", "AU", "36", "", "07", "24970", "", "-37.9", "145.08333", "Australia/Melbourne"),
("2163055", "Horsham", "", "AU", "36", "", "07", "23190", "", "-36.71131", "142.19981", "Australia/Melbourne"),
("2163137", "Hornsby", "", "AU", "36", "", "02", "14000", "", "-33.70244", "151.09931", "Australia/Sydney"),
("2163355", "Hobart", "Хобарт", "AU", "36", "AU", "06", "62810", "", "-42.87936", "147.32941", "Australia/Hobart"),
("2163472", "Highett", "", "AU", "36", "", "07", "23430", "", "-37.95", "145.05", "Australia/Melbourne"),
("2163641", "Helensburgh", "", "AU", "36", "", "02", "18450", "", "-34.17836", "150.99522", "Australia/Sydney"),
("2163653", "Heidelberg West", "", "AU", "36", "", "07", "20660", "", "-37.75", "145.03333", "Australia/Melbourne"),
("2163654", "Heidelberg", "", "AU", "36", "", "07", "20660", "", "-37.75", "145.06667", "Australia/Melbourne"),
("2163684", "Heathmont", "", "AU", "36", "", "07", "24410", "", "-37.83333", "145.25", "Australia/Melbourne"),
("2163697", "Heathcote", "", "AU", "36", "", "02", "17150", "", "-34.0841", "151.01305", "Australia/Sydney"),
("2163701", "Healesville", "", "AU", "36", "", "07", "27450", "", "-37.65395", "145.51718", "Australia/Melbourne"),
("2163776", "Hawthorn South", "", "AU", "36", "", "07", "21110", "", "-37.8329", "145.0367", "Australia/Melbourne"),
("2163837", "Hastings", "", "AU", "36", "", "07", "25340", "", "-38.3", "145.18333", "Australia/Melbourne"),
("2163990", "Hampton Park", "", "AU", "36", "", "07", "21610", "", "-38.03333", "145.25", "Australia/Melbourne"),
("2163994", "Hampton", "", "AU", "36", "", "07", "", "", "-37.95", "145", "Australia/Melbourne"),
("2164025", "Hamilton", "", "AU", "36", "", "07", "26260", "", "-37.74425", "142.02202", "Australia/Melbourne"),
("2164062", "Hallam", "", "AU", "36", "", "07", "21610", "", "-38.01667", "145.26667", "Australia/Melbourne"),
("2164123", "Haberfield", "", "AU", "36", "", "02", "17200", "", "-33.88333", "151.2", "Australia/Sydney"),
("2164129", "Gympie", "", "AU", "36", "", "04", "33620", "", "-26.18979", "152.66499", "Australia/Brisbane"),
("2164206", "Gunnedah", "", "AU", "36", "", "02", "13550", "", "-30.98065", "150.25838", "Australia/Sydney"),
("2164422", "Griffith", "Гриффит", "AU", "36", "", "02", "13450", "", "-34.28853", "146.05093", "Australia/Sydney"),
("2164495", "Greenvale", "", "AU", "36", "", "07", "23270", "", "-37.63333", "144.86667", "Australia/Melbourne"),
("2164515", "Greensborough", "", "AU", "36", "", "07", "20660", "", "-37.70462", "145.10302", "Australia/Melbourne"),
("2164691", "Granville", "", "AU", "36", "", "02", "16250", "", "-33.83333", "151.01667", "Australia/Sydney"),
("2164771", "Grafton", "", "AU", "36", "", "02", "11730", "", "-29.68104", "152.93394", "Australia/Sydney"),
("2164837", "Goulburn", "Гулберн", "AU", "36", "", "02", "13310", "", "-34.75155", "149.72086", "Australia/Sydney"),
("2164855", "Gorokan", "", "AU", "36", "", "02", "18550", "", "-33.25764", "151.5097", "Australia/Sydney"),
("2164904", "Gordon", "", "AU", "36", "", "02", "11730", "", "-29.3", "152.71667", "Australia/Sydney"),
("2164966", "Goonellabah", "", "AU", "36", "", "02", "14850", "", "-28.81667", "153.31667", "Australia/Sydney"),
("2164972", "Goondiwindi", "", "AU", "36", "", "04", "33610", "", "-28.54709", "150.30546", "Australia/Brisbane"),
("2165025", "Goodna", "", "AU", "36", "", "04", "33960", "", "-27.61046", "152.89896", "Australia/Brisbane"),
("2165087", "Gold Coast", "Голд Коуст", "AU", "36", "", "04", "33430", "", "-28.00029", "153.43088", "Australia/Brisbane"),
("2165200", "Glenroy", "", "AU", "36", "", "07", "25250", "", "-37.7", "144.93333", "Australia/Melbourne"),
("2165229", "Glenorchy", "", "AU", "36", "", "06", "62610", "", "-42.83343", "147.27593", "Australia/Hobart"),
("2165291", "Glen Innes", "", "AU", "36", "", "02", "13010", "", "-29.73485", "151.7385", "Australia/Sydney"),
("2165303", "Glenhaven", "", "AU", "36", "", "02", "10500", "", "-33.7", "151", "Australia/Sydney"),
("2165326", "Glenfield", "", "AU", "36", "", "02", "11500", "", "-33.96667", "150.9", "Australia/Sydney"),
("2165329", "Glenferrie", "", "AU", "36", "", "07", "21110", "", "-37.83333", "145.05", "Australia/Melbourne"),
("2165403", "Glenbrook", "", "AU", "36", "", "02", "10900", "", "-33.76667", "150.61667", "Australia/Sydney"),
("2165478", "Gladstone", "Глэдстон", "AU", "36", "", "04", "33360", "", "-23.84852", "151.25775", "Australia/Brisbane"),
("2165796", "Geelong West", "", "AU", "36", "", "07", "22750", "", "-38.13888", "144.34842", "Australia/Melbourne"),
("2165798", "Geelong", "Джилонг", "AU", "36", "", "07", "22750", "", "-38.14711", "144.36069", "Australia/Melbourne"),
("2165828", "Gatton", "", "AU", "36", "", "04", "34580", "", "-27.55873", "152.27618", "Australia/Brisbane"),
("2166143", "Frankston East", "Френкстон", "AU", "36", "", "07", "22170", "", "-38.13333", "145.13333", "Australia/Melbourne"),
("2166144", "Frankston", "", "AU", "36", "", "07", "22170", "", "-38.14458", "145.12291", "Australia/Melbourne"),
("2166309", "Forster", "", "AU", "36", "", "02", "13400", "", "-32.18136", "152.51715", "Australia/Sydney"),
("2166340", "Forest Hill", "", "AU", "36", "", "07", "26980", "", "-37.83333", "145.18333", "Australia/Melbourne"),
("2166370", "Footscray", "", "AU", "36", "", "07", "24330", "", "-37.8", "144.9", "Australia/Melbourne"),
("2166584", "Fitzroy", "", "AU", "36", "", "07", "27350", "", "-37.79839", "144.97833", "Australia/Melbourne"),
("2166819", "Fawkner", "", "AU", "36", "", "07", "25250", "", "-37.71667", "144.96667", "Australia/Melbourne"),
("2167208", "Essendon", "", "AU", "36", "", "07", "25060", "", "-37.76667", "144.91667", "Australia/Melbourne"),
("2167279", "Epping", "", "AU", "36", "", "07", "27070", "", "-37.65", "145.03333", "Australia/Melbourne"),
("2167280", "Epping", "", "AU", "36", "", "02", "16250", "", "-33.77271", "151.08184", "Australia/Sydney"),
("2167312", "Engadine", "", "AU", "36", "", "02", "17150", "", "-34.06564", "151.01266", "Australia/Sydney"),
("2167425", "Emerald", "", "AU", "36", "", "07", "21450", "", "-37.93167", "145.44093", "Australia/Melbourne"),
("2167426", "Emerald", "", "AU", "36", "", "04", "32270", "", "-23.52296", "148.15784", "Australia/Brisbane"),
("2167444", "Eltham North", "", "AU", "36", "", "07", "25710", "", "-37.7", "145.15", "Australia/Melbourne"),
("2167445", "Eltham", "", "AU", "36", "", "07", "25710", "", "-37.73333", "145.15", "Australia/Melbourne"),
("2167751", "Edithvale", "", "AU", "36", "", "07", "23430", "", "-38.03724", "145.10974", "Australia/Melbourne"),
("2167817", "Echuca", "Ичука", "AU", "36", "", "07", "21370", "", "-36.14057", "144.75185", "Australia/Melbourne"),
("2167869", "East Maitland", "", "AU", "36", "", "02", "15050", "", "-32.75", "151.58333", "Australia/Sydney"),
("2167943", "East Ballina", "", "AU", "36", "", "02", "10250", "", "-28.86667", "153.58333", "Australia/Sydney"),
("2167949", "Earlwood", "", "AU", "36", "", "02", "14150", "", "-33.95", "151.1", "Australia/Sydney"),
("2168305", "Dubbo", "Даббо", "AU", "36", "", "02", "12600", "", "-32.24295", "148.60484", "Australia/Sydney"),
("2168386", "Dromana", "", "AU", "36", "", "07", "25340", "", "-38.33375", "144.96458", "Australia/Melbourne"),
("2168537", "Doreen", "", "AU", "36", "", "07", "25710", "", "-37.6", "145.15", "Australia/Melbourne"),
("2168556", "Doonside", "", "AU", "36", "", "02", "10750", "", "-33.76667", "150.86667", "Australia/Sydney"),
("2168579", "Donvale", "", "AU", "36", "", "07", "24210", "", "-37.7891", "145.17488", "Australia/Melbourne"),
("2168605", "Doncaster East", "", "AU", "36", "", "07", "24210", "", "-37.78761", "145.14888", "Australia/Melbourne"),
("2168607", "Doncaster", "", "AU", "36", "", "07", "24210", "", "-37.78828", "145.12373", "Australia/Melbourne"),
("2168807", "Dingley Village", "", "AU", "36", "", "07", "23430", "", "-37.9827", "145.1342", "Australia/Melbourne"),
("2168919", "Diamond Creek", "", "AU", "36", "", "07", "25710", "", "-37.66667", "145.15", "Australia/Melbourne"),
("2168943", "Devonport", "Девонпорт", "AU", "36", "", "06", "61610", "", "-41.17695", "146.35152", "Australia/Hobart"),
("2169018", "Derrimut", "", "AU", "36", "", "07", "21180", "", "-37.79238", "144.76994", "Australia/Melbourne"),
("2169068", "Deniliquin", "", "AU", "36", "", "02", "12500", "", "-35.53245", "144.95364", "Australia/Sydney"),
("2169145", "Deer Park", "", "AU", "36", "", "07", "21180", "", "-37.76667", "144.78333", "Australia/Melbourne"),
("2169220", "Deception Bay", "", "AU", "36", "", "04", "35010", "", "-27.19354", "153.02631", "Australia/Brisbane"),
("2169378", "Darlinghurst", "", "AU", "36", "", "02", "17200", "", "-33.87939", "151.21925", "Australia/Sydney"),
("2169423", "Dapto", "", "AU", "36", "", "02", "18450", "", "-34.5", "150.78333", "Australia/Sydney"),
("2169460", "Dandenong", "", "AU", "36", "", "07", "22670", "", "-37.98333", "145.2", "Australia/Melbourne"),
("2169535", "Dalby", "", "AU", "36", "", "04", "37310", "", "-27.18169", "151.26205", "Australia/Brisbane"),
("2169866", "Croydon North", "", "AU", "36", "", "07", "24410", "", "-37.78333", "145.3", "Australia/Melbourne"),
("2169868", "Croydon", "", "AU", "36", "", "02", "10150", "", "-33.88333", "151.11667", "Australia/Sydney"),
("2169956", "Cronulla", "", "AU", "36", "", "02", "17150", "", "-34.06251", "151.14961", "Australia/Sydney"),
("2170078", "Cranbourne", "", "AU", "36", "", "07", "21610", "", "-38.1", "145.28333", "Australia/Melbourne"),
("2170079", "Cranbourne", "", "AU", "36", "", "07", "21610", "", "-38.11342", "145.28326", "Australia/Melbourne"),
("2170089", "Craigieburn", "", "AU", "36", "", "07", "23270", "", "-37.6", "144.95", "Australia/Melbourne"),
("2170139", "Cowra", "", "AU", "36", "", "02", "12350", "", "-33.83554", "148.69663", "Australia/Sydney"),
("2170253", "Corrimal", "", "AU", "36", "", "02", "18450", "", "-34.37864", "150.90356", "Australia/Sydney"),
("2170260", "Corowa", "", "AU", "36", "", "02", "12300", "", "-35.99704", "146.38552", "Australia/Sydney"),
("2170577", "Cooma", "", "AU", "36", "", "02", "12050", "", "-36.23517", "149.12408", "Australia/Sydney"),
("2170581", "Coolum Beach", "", "AU", "36", "", "04", "36710", "", "-26.5283", "153.08809", "Australia/Brisbane"),
("2170697", "Coogee", "", "AU", "36", "", "02", "16550", "", "-33.9205", "151.25522", "Australia/Sydney"),
("2170852", "Concord", "", "AU", "36", "", "02", "11520", "", "-33.84722", "151.10381", "Australia/Sydney"),
("2171000", "Collingwood", "", "AU", "36", "", "07", "27350", "", "-37.8", "144.98333", "Australia/Melbourne"),
("2171069", "Colac", "", "AU", "36", "", "07", "21750", "", "-38.339", "143.58489", "Australia/Melbourne"),
("2171085", "Coffs Harbour", "Кофс-Харбор", "AU", "36", "", "02", "11800", "", "-30.29626", "153.11351", "Australia/Sydney"),
("2171168", "Coburg", "", "AU", "36", "", "07", "25250", "", "-37.75", "144.96667", "Australia/Melbourne"),
("2171320", "Clifton Springs", "", "AU", "36", "", "07", "22750", "", "-38.1567", "144.5551", "Australia/Melbourne"),
("2171324", "Clifton Hill", "", "AU", "36", "", "07", "27350", "", "-37.79798", "144.99533", "Australia/Melbourne"),
("2171360", "Cleveland", "", "AU", "36", "", "04", "36250", "", "-27.52677", "153.26516", "Australia/Brisbane"),
("2171395", "Clayton South", "", "AU", "36", "", "07", "23430", "", "-37.93333", "145.11667", "Australia/Melbourne"),
("2171400", "Clayton", "", "AU", "36", "", "07", "24970", "", "-37.91667", "145.11667", "Australia/Melbourne"),
("2171452", "Clarinda", "", "AU", "36", "", "07", "23430", "", "-37.93333", "145.11667", "Australia/Melbourne"),
("2171476", "Claremont", "", "AU", "36", "", "06", "62610", "", "-42.78333", "147.25", "Australia/Hobart"),
("2171507", "Wollongong", "Вуллонгонг", "AU", "36", "", "02", "18450", "", "-34.424", "150.89345", "Australia/Sydney"),
("2171586", "Chipping Norton", "", "AU", "36", "", "02", "12850", "", "-33.9", "150.95", "Australia/Sydney"),
("2171693", "Chelsea Heights", "", "AU", "36", "", "07", "23430", "", "-38.03333", "145.13333", "Australia/Melbourne"),
("2171694", "Chelsea", "", "AU", "36", "", "07", "23430", "", "-38.05", "145.11667", "Australia/Melbourne"),
("2171707", "Chatswood", "", "AU", "36", "", "02", "18250", "", "-33.8", "151.18333", "Australia/Sydney"),
("2171722", "Charters Towers", "", "AU", "36", "", "04", "32310", "", "-20.07671", "146.26353", "Australia/Brisbane"),
("2171766", "Charlestown", "", "AU", "36", "", "02", "14650", "", "-32.95", "151.66667", "Australia/Sydney"),
("2171845", "Cessnock", "Сеснок", "AU", "36", "", "02", "11720", "", "-32.83211", "151.35623", "Australia/Sydney"),
("2171945", "Caulfield North", "", "AU", "36", "", "07", "22310", "", "-37.8739", "145.02485", "Australia/Melbourne"),
("2172106", "Castlemaine", "", "AU", "36", "", "07", "25430", "", "-37.06709", "144.21684", "Australia/Melbourne"),
("2172111", "Castle Hill", "", "AU", "36", "", "02", "10500", "", "-33.73333", "151", "Australia/Sydney"),
("2172153", "Casino", "", "AU", "36", "", "02", "16610", "", "-28.85819", "153.04748", "Australia/Sydney"),
("2172191", "Carrum Downs", "", "AU", "36", "", "07", "22170", "", "-38.09968", "145.17248", "Australia/Melbourne"),
("2172264", "Carnegie", "", "AU", "36", "", "07", "26350", "", "-37.88333", "145.06667", "Australia/Melbourne"),
("2172289", "Carlton North", "", "AU", "36", "", "07", "27350", "", "-37.78333", "144.96667", "Australia/Melbourne"),
("2172293", "Carlton", "", "AU", "36", "", "07", "24600", "", "-37.8", "144.96667", "Australia/Melbourne"),
("2172303", "Carlingford", "", "AU", "36", "", "02", "16250", "", "-33.78269", "151.04888", "Australia/Sydney"),
("2172311", "Caringbah", "", "AU", "36", "", "02", "17150", "", "-34.04726", "151.12051", "Australia/Sydney"),
("2172517", "Canberra", "Канберра", "AU", "36", "", "01", "", "", "-35.28346", "149.12807", "Australia/Sydney"),
("2172563", "Camperdown", "", "AU", "36", "", "02", "15200", "", "-33.88965", "151.17642", "Australia/Sydney"),
("2172586", "Campbelltown", "", "AU", "36", "", "02", "11500", "", "-34.06667", "150.81667", "Australia/Sydney"),
("2172607", "Campbellfield", "", "AU", "36", "", "07", "23270", "", "-37.68333", "144.95", "Australia/Melbourne"),
("2172686", "Camberwell", "", "AU", "36", "", "07", "21110", "", "-37.84205", "145.0694", "Australia/Melbourne"),
("2172710", "Caloundra", "Калундра", "AU", "36", "", "04", "36710", "", "-26.80346", "153.12195", "Australia/Brisbane"),
("2172797", "Cairns", "Кернс", "AU", "36", "", "04", "32070", "", "-16.92304", "145.76625", "Australia/Brisbane"),
("2172832", "Caboolture", "", "AU", "36", "", "04", "35010", "", "-27.08465", "152.9511", "Australia/Brisbane"),
("2172880", "Byron Bay", "", "AU", "36", "", "02", "11350", "", "-28.64201", "153.61194", "Australia/Sydney"),
("2172994", "Burwood East", "", "AU", "36", "", "07", "26980", "", "-37.85", "145.15", "Australia/Melbourne"),
("2173099", "Burpengary", "", "AU", "36", "", "04", "35010", "", "-27.15746", "152.95758", "Australia/Brisbane"),
("2173125", "Burnie", "Берни", "AU", "36", "", "06", "60610", "", "-41.05584", "145.90375", "Australia/Hobart"),
("2173310", "Bundamba", "", "AU", "36", "", "04", "33960", "", "-27.60947", "152.81133", "Australia/Brisbane"),
("2173323", "Bundaberg", "Бандаберг", "AU", "36", "", "04", "31820", "", "-24.86621", "152.3479", "Australia/Brisbane"),
("2173445", "Bulli", "", "AU", "36", "", "02", "18450", "", "-34.33834", "150.91347", "Australia/Sydney"),
("2173464", "Bulleen", "", "AU", "36", "", "07", "24210", "", "-37.76667", "145.08333", "Australia/Melbourne"),
("2173605", "Buderim", "", "AU", "36", "", "04", "36710", "", "-26.68443", "153.05705", "Australia/Brisbane"),
("2173734", "Brunswick West", "", "AU", "36", "", "07", "25250", "", "-37.76461", "144.94383", "Australia/Melbourne"),
("2173739", "Brunswick East", "", "AU", "36", "", "07", "25250", "", "-37.77255", "144.97241", "Australia/Melbourne"),
("2173741", "Brunswick", "", "AU", "36", "", "07", "25250", "", "-37.76667", "144.96667", "Australia/Melbourne"),
("2173911", "Broken Hill", "Брокен-Хилл", "AU", "36", "", "02", "11250", "", "-31.9652", "141.4512", "Australia/Broken_Hill"),
("2173964", "Broadmeadows", "", "AU", "36", "", "07", "23270", "", "-37.68015", "144.91877", "Australia/Melbourne"),
("2174003", "Brisbane", "Брисбен", "AU", "36", "", "04", "31000", "", "-27.46794", "153.02809", "Australia/Brisbane"),
("2174040", "Brighton", "", "AU", "36", "", "04", "31000", "", "-27.29582", "153.05721", "Australia/Brisbane"),
("2174079", "Bridgewater", "", "AU", "36", "", "06", "60410", "", "-42.73719", "147.22784", "Australia/Hobart"),
("2174360", "Box Hill", "", "AU", "36", "", "07", "26980", "", "-37.81887", "145.12545", "Australia/Melbourne"),
("2174400", "Bowral", "", "AU", "36", "", "02", "18350", "", "-34.4775", "150.4204", "Australia/Sydney"),
("2174444", "Bowen", "", "AU", "36", "", "04", "37340", "", "-20.01367", "148.24754", "Australia/Brisbane"),
("2174563", "Botany", "", "AU", "36", "", "02", "11100", "", "-33.94599", "151.19591", "Australia/Sydney"),
("2174580", "Boronia", "", "AU", "36", "", "07", "23670", "", "-37.86667", "145.28333", "Australia/Melbourne"),
("2174933", "Bongaree", "", "AU", "36", "", "04", "35010", "", "-27.08367", "153.15942", "Australia/Brisbane"),
("2174976", "Bomaderry", "", "AU", "36", "", "02", "16950", "", "-34.84967", "150.61093", "Australia/Sydney"),
("2175341", "Blaxland", "", "AU", "36", "", "02", "10900", "", "-33.75", "150.6", "Australia/Sydney"),
("2175403", "Blackwater", "", "AU", "36", "", "04", "32270", "", "-23.58351", "148.87912", "Australia/Brisbane"),
("2175411", "Blacktown", "", "AU", "36", "", "02", "10750", "", "-33.76667", "150.91667", "Australia/Sydney"),
("2175527", "Blackmans Bay", "", "AU", "36", "", "06", "63610", "", "-43.00311", "147.31694", "Australia/Hobart"),
("2175819", "Biloela", "", "AU", "36", "", "04", "30370", "", "-24.39589", "150.51504", "Australia/Brisbane"),
("2176031", "Berwick", "", "AU", "36", "", "07", "21610", "", "-38.03333", "145.35", "Australia/Melbourne"),
("2176088", "Berkeley Vale", "", "AU", "36", "", "02", "18550", "", "-33.35", "151.43333", "Australia/Sydney"),
("2176090", "Berkeley", "", "AU", "36", "", "02", "18450", "", "-34.48333", "150.85", "Australia/Sydney"),
("2176123", "Bentleigh", "", "AU", "36", "", "07", "22310", "", "-37.91806", "145.03544", "Australia/Melbourne"),
("2176187", "Bendigo", "Бендиго", "AU", "36", "", "07", "22620", "", "-36.75818", "144.28024", "Australia/Melbourne"),
("2176225", "Benalla", "", "AU", "36", "", "07", "21010", "", "-36.55113", "145.98425", "Australia/Melbourne"),
("2176412", "Beenleigh", "", "AU", "36", "", "04", "34590", "", "-27.71137", "153.2029", "Australia/Brisbane"),
("2176487", "Beaumaris", "", "AU", "36", "", "07", "20910", "", "-37.98534", "145.03361", "Australia/Melbourne"),
("2176566", "Bayswater", "", "AU", "36", "", "07", "23670", "", "-37.85", "145.26667", "Australia/Melbourne"),
("2176592", "Baulkham Hills", "", "AU", "36", "", "02", "10500", "", "-33.75881", "150.99292", "Australia/Sydney"),
("2176632", "Bathurst", "Бэтхерст", "AU", "36", "", "02", "10470", "", "-33.41665", "149.5806", "Australia/Sydney"),
("2176639", "Batemans Bay", "", "AU", "36", "", "02", "12750", "", "-35.70658", "150.17541", "Australia/Sydney"),
("2176934", "Banora Point", "", "AU", "36", "", "02", "17550", "", "-28.21298", "153.53634", "Australia/Sydney"),
("2176947", "Bankstown", "", "AU", "36", "", "02", "10350", "", "-33.91667", "151.03333", "Australia/Sydney"),
("2177026", "Balwyn", "", "AU", "36", "", "07", "21110", "", "-37.81667", "145.06667", "Australia/Melbourne"),
("2177052", "Balmain", "", "AU", "36", "", "02", "14800", "", "-33.85481", "151.1833", "Australia/Sydney"),
("2177069", "Ballina", "", "AU", "36", "", "02", "10250", "", "-28.86414", "153.56541", "Australia/Sydney"),
("2177091", "Ballarat", "Балларат", "AU", "36", "", "07", "20570", "", "-37.56622", "143.84957", "Australia/Melbourne"),
("2177114", "Balgowlah", "", "AU", "36", "", "02", "15150", "", "-33.79494", "151.2572", "Australia/Sydney"),
("2177207", "Balaclava", "", "AU", "36", "", "07", "22310", "", "-37.86667", "145", "Australia/Melbourne"),
("2177233", "Bairnsdale", "", "AU", "36", "", "07", "22110", "", "-37.82289", "147.61041", "Australia/Melbourne"),
("2177394", "Bacchus Marsh", "", "AU", "36", "", "07", "25150", "", "-37.67268", "144.43829", "Australia/Melbourne"),
("2177413", "Ayr", "", "AU", "36", "", "04", "31900", "", "-19.57393", "147.40666", "Australia/Brisbane"),
("2177513", "Auburn", "", "AU", "36", "", "02", "10200", "", "-33.85", "151.03333", "Australia/Sydney"),
("2177541", "Atherton", "", "AU", "36", "", "04", "36810", "", "-17.26864", "145.47522", "Australia/Brisbane"),
("2177547", "Aspendale", "", "AU", "36", "", "07", "23430", "", "-38.02913", "145.10266", "Australia/Melbourne"),
("2177565", "Ashfield", "", "AU", "36", "", "02", "10150", "", "-33.88834", "151.12274", "Australia/Sydney"),
("2177571", "Ashburton", "", "AU", "36", "", "07", "21110", "", "-37.86667", "145.08333", "Australia/Melbourne"),
("2177576", "Ascot Vale", "", "AU", "36", "", "07", "24600", "", "-37.78333", "144.91667", "Australia/Melbourne"),
("2177626", "Artarmon", "", "AU", "36", "", "02", "18250", "", "-33.81667", "151.18333", "Australia/Sydney"),
("2177671", "Armidale", "Армидейл", "AU", "36", "", "02", "10110", "", "-30.50828", "151.67123", "Australia/Sydney"),
("2177756", "Ararat", "", "AU", "36", "", "07", "20260", "", "-37.28542", "142.92728", "Australia/Melbourne"),
("2177992", "Altona", "", "AU", "36", "", "07", "23110", "", "-37.86964", "144.83036", "Australia/Melbourne"),
("2178174", "Albury", "Олбери", "AU", "36", "", "02", "10050", "", "-36.07482", "146.92401", "Australia/Sydney"),
("2178190", "Albert Park", "", "AU", "36", "", "07", "27350", "", "-37.83333", "145", "Australia/Melbourne"),
("2205631", "Raymond Terrace", "", "AU", "36", "", "02", "16400", "", "-32.75", "151.75", "Australia/Sydney"),
("2205969", "Gymea", "", "AU", "36", "", "02", "17150", "", "-34.03637", "151.08528", "Australia/Sydney"),
("2205970", "Kirrawee", "", "AU", "36", "", "02", "17150", "", "-34.03831", "151.06903", "Australia/Sydney"),
("2205979", "Gymea Bay", "", "AU", "36", "", "02", "17150", "", "-34.05209", "151.08795", "Australia/Sydney"),
("2205999", "Brighton-Le-Sands", "", "AU", "36", "", "02", "16650", "", "-33.96009", "151.1511", "Australia/Sydney"),
("2206003", "Blakehurst", "", "AU", "36", "", "02", "14450", "", "-33.99152", "151.10876", "Australia/Sydney"),
("2206006", "Lugarno", "", "AU", "36", "", "02", "14150", "", "-33.98267", "151.04184", "Australia/Sydney"),
("2206068", "New Town", "", "AU", "36", "", "06", "62810", "", "-42.85758", "147.30869", "Australia/Hobart"),
("2206089", "Sandy Bay", "", "AU", "36", "", "06", "62810", "", "-42.89449", "147.32439", "Australia/Hobart"),
("2206108", "Fairy Meadow", "", "AU", "36", "", "02", "18450", "", "-34.39303", "150.89275", "Australia/Sydney"),
("2207259", "South Brisbane", "", "AU", "36", "", "04", "31000", "", "-27.48034", "153.02049", "Australia/Brisbane"),
("2207330", "Scarborough", "", "AU", "36", "", "04", "35010", "", "-27.20118", "153.10939", "Australia/Brisbane"),
("2207538", "Bonbeach", "", "AU", "36", "", "07", "23430", "", "-38.06528", "145.12278", "Australia/Melbourne"),
("2207618", "Cheltenham", "", "AU", "36", "", "07", "20910", "", "-37.96944", "145.04806", "Australia/Melbourne"),
("2207748", "Bellevue Hill", "", "AU", "36", "", "02", "18500", "", "-33.87899", "151.25101", "Australia/Sydney"),
("2207753", "Paddington", "", "AU", "36", "", "02", "18500", "", "-33.88419", "151.23151", "Australia/Sydney"),
("2207762", "Lilyfield", "", "AU", "36", "", "02", "14800", "", "-33.87499", "151.1653", "Australia/Sydney"),
("2207783", "Drummoyne", "", "AU", "36", "", "02", "11520", "", "-33.85237", "151.15491", "Australia/Sydney"),
("2207796", "Greenwich", "", "AU", "36", "", "02", "14700", "", "-33.83954", "151.183", "Australia/Sydney"),
("2207809", "Hunters Hill", "", "AU", "36", "", "02", "14100", "", "-33.83432", "151.1459", "Australia/Sydney"),
("2207822", "Cammeray", "", "AU", "36", "", "02", "15950", "", "-33.82132", "151.21609", "Australia/Sydney"),
("2207880", "Neutral Bay", "", "AU", "36", "", "02", "15950", "", "-33.83784", "151.2175", "Australia/Sydney"),
("2208285", "Randwick", "", "AU", "36", "", "02", "16550", "", "-33.91439", "151.24895", "Australia/Sydney"),
("2208288", "Bronte", "", "AU", "36", "", "02", "18050", "", "-33.90198", "151.26556", "Australia/Sydney"),
("2208290", "Bondi", "", "AU", "36", "", "02", "18050", "", "-33.89429", "151.26444", "Australia/Sydney"),
("2208292", "Gladesville", "", "AU", "36", "", "02", "14100", "", "-33.83333", "151.13333", "Australia/Sydney"),
("2208302", "Forestville", "", "AU", "36", "", "02", "18000", "", "-33.76667", "151.20833", "Australia/Sydney"),
("2208305", "Dee Why", "", "AU", "36", "", "02", "18000", "", "-33.75", "151.3", "Australia/Sydney"),
("2208313", "Umina", "", "AU", "36", "", "02", "13100", "", "-33.52314", "151.31325", "Australia/Sydney"),
("6290236", "Airport West", "", "AU", "36", "", "07", "25060", "", "-37.7247", "144.88126", "Australia/Melbourne"),
("6290241", "Gladstone Park", "", "AU", "36", "", "07", "23270", "", "-37.68742", "144.88675", "Australia/Melbourne"),
("6301965", "Palmerston", "Палмерстон", "AU", "36", "", "03", "72800", "", "-12.48602", "130.9833", "Australia/Darwin"),
("6533368", "Moranbah", "", "AU", "36", "", "04", "33980", "", "-22.00163", "148.04661", "Australia/Brisbane"),
("6619483", "Kaleen", "", "AU", "36", "", "01", "", "", "-35.21814", "149.10516", "Australia/Sydney"),
("6620339", "Karratha", "", "AU", "36", "", "08", "57560", "", "-20.73765", "116.84629", "Australia/Perth"),
("6621336", "Hillarys", "", "AU", "36", "", "08", "54170", "", "-31.80698", "115.74045", "Australia/Perth"),
("6621337", "Kingsford", "", "AU", "36", "", "02", "16550", "", "-33.92399", "151.22749", "Australia/Sydney"),
("6621338", "Klemzig", "", "AU", "36", "", "05", "45890", "", "-34.87928", "138.63562", "Australia/Adelaide"),
("6621340", "Maidstone", "", "AU", "36", "", "07", "24330", "", "-37.78035", "144.87353", "Australia/Melbourne"),
("6621357", "Woollahra", "", "AU", "36", "", "02", "18500", "", "-33.8878", "151.23681", "Australia/Sydney"),
("6690772", "Corlette", "", "AU", "36", "", "02", "16400", "", "-32.72014", "152.10846", "Australia/Sydney"),
("6692248", "Howrah", "", "AU", "36", "", "06", "61410", "", "-42.88728", "147.40554", "Australia/Hobart"),
("6693769", "North Narrabeen", "", "AU", "36", "", "02", "16370", "", "-33.70935", "151.29607", "Australia/Sydney"),
("6695255", "Joondalup", "", "AU", "36", "", "08", "54170", "", "-31.74445", "115.76835", "Australia/Perth"),
("6695266", "Como", "", "AU", "36", "", "08", "57840", "", "-31.99119", "115.86336", "Australia/Perth"),
("6695559", "Arncliffe", "", "AU", "36", "", "02", "16650", "", "-33.93627", "151.14819", "Australia/Sydney"),
("6697124", "East Lismore", "", "AU", "36", "", "02", "14850", "", "-28.82591", "153.2888", "Australia/Sydney"),
("6697141", "Mindarie", "", "AU", "36", "", "08", "58760", "", "-31.68932", "115.70698", "Australia/Perth"),
("6697150", "Clarkson", "", "AU", "36", "", "08", "58760", "", "-31.68282", "115.7247", "Australia/Perth"),
("6697151", "Kinross", "", "AU", "36", "", "08", "54170", "", "-31.71868", "115.73839", "Australia/Perth"),
("6697152", "Currambine", "", "AU", "36", "", "08", "54170", "", "-31.73306", "115.74766", "Australia/Perth"),
("6697155", "Heathridge", "", "AU", "36", "", "08", "54170", "", "-31.76244", "115.75895", "Australia/Perth"),
("6930431", "Freshwater", "", "AU", "36", "", "02", "18000", "", "-33.77867", "151.28569", "Australia/Sydney"),
("6931018", "Taringa", "", "AU", "36", "", "04", "31000", "", "-27.49061", "152.97861", "Australia/Brisbane"),
("6931021", "Inala", "", "AU", "36", "", "04", "31000", "", "-27.59715", "152.97432", "Australia/Brisbane"),
("6941710", "Mount Lawley", "", "AU", "36", "", "08", "58570", "", "-31.93439", "115.8716", "Australia/Perth"),
("6943454", "Paradise", "", "AU", "36", "", "05", "40910", "", "-34.87361", "138.66896", "Australia/Adelaide"),
("6943474", "Athelstone", "", "AU", "36", "", "05", "40910", "", "-34.87019", "138.6999", "Australia/Adelaide"),
("6943551", "Wooloowin", "", "AU", "36", "", "04", "31000", "", "-27.42244", "153.04204", "Australia/Brisbane"),
("6943555", "Zillmere", "", "AU", "36", "", "04", "31000", "", "-27.35591", "153.04453", "Australia/Brisbane"),
("6943556", "Taigum", "", "AU", "36", "", "04", "31000", "", "-27.34265", "153.04444", "Australia/Brisbane"),
("6943558", "Bracken Ridge", "", "AU", "36", "", "04", "31000", "", "-27.3171", "153.03097", "Australia/Brisbane"),
("6943579", "Windsor", "", "AU", "36", "", "04", "31000", "", "-27.43631", "153.02882", "Australia/Brisbane"),
("6945028", "Bridegman Downs", "", "AU", "36", "", "04", "31000", "", "-27.35538", "152.99432", "Australia/Brisbane"),
("6949377", "Canterbury", "", "AU", "36", "", "02", "11550", "", "-33.91192", "151.11862", "Australia/Sydney"),
("6951440", "Tamborine Mountain", "", "AU", "36", "", "04", "36510", "", "-27.96954", "153.19937", "Australia/Brisbane"),
("7281782", "North Ryde", "", "AU", "36", "", "02", "16700", "", "-33.79677", "151.12436", "Australia/Sydney"),
("7281785", "Stirling", "", "AU", "36", "", "08", "57910", "", "-31.88343", "115.8099", "Australia/Perth"),
("7281804", "North Melbourne", "", "AU", "36", "", "07", "24600", "", "-37.80289", "144.94816", "Australia/Melbourne"),
("7281805", "Caroline Springs", "", "AU", "36", "", "07", "24650", "", "-37.74124", "144.73631", "Australia/Melbourne"),
("7281807", "Hoppers Crossing", "", "AU", "36", "", "07", "27260", "", "-37.88264", "144.7003", "Australia/Melbourne"),
("7281823", "Rouse Hill", "", "AU", "36", "", "02", "10750", "", "-33.68207", "150.9154", "Australia/Sydney"),
("7281838", "Logan City", "", "AU", "36", "", "04", "34590", "", "-27.63917", "153.10944", "Australia/Brisbane"),
("7281839", "Carindale", "", "AU", "36", "", "04", "31000", "", "-27.50578", "153.10236", "Australia/Brisbane"),
("7281840", "Paramatta", "", "AU", "36", "", "02", "16250", "", "-33.8178", "151.00348", "Australia/Sydney"),
("7281850", "Ferntree Gully", "", "AU", "36", "", "07", "23670", "", "-37.88461", "145.29539", "Australia/Melbourne"),
("7302259", "City of Parramatta", "", "AU", "36", "", "02", "16250", "", "-33.81667", "151", "Australia/Sydney"),
("7302624", "Phillip Island", "", "AU", "36", "", "07", "20740", "", "-38.48349", "145.23102", "Australia/Melbourne"),
("7302625", "Springwood", "", "AU", "36", "", "04", "34590", "", "-27.61183", "153.12899", "Australia/Brisbane"),
("7302628", "Adelaide Hills", "", "AU", "36", "", "05", "40120", "", "-34.91119", "138.70735", "Australia/Adelaide"),
("7302631", "Canning Vale", "", "AU", "36", "", "08", "51330", "", "-32.05799", "115.91814", "Australia/Perth"),
("7302634", "Varsity Lakes", "", "AU", "36", "", "04", "33430", "", "-28.0894", "153.4122", "Australia/Brisbane"),
("7302638", "Oxenford", "", "AU", "36", "", "04", "33430", "", "-27.89033", "153.31309", "Australia/Brisbane"),
("7302640", "Toormina", "", "AU", "36", "", "02", "11800", "", "-30.35384", "153.08843", "Australia/Sydney"),
("7302642", "Glenmore Park", "", "AU", "36", "", "02", "16350", "", "-33.79068", "150.6693", "Australia/Sydney"),
("7302683", "Southbank", "", "AU", "36", "", "07", "24600", "", "-37.8228", "144.96434", "Australia/Melbourne"),
("7303250", "St Kilda East", "", "AU", "36", "", "07", "25900", "", "-37.86594", "145.00018", "Australia/Melbourne"),
("7521471", "Docklands", "", "AU", "36", "", "07", "24600", "", "-37.8149", "144.95052", "Australia/Melbourne"),
("7932573", "Melton West", "", "AU", "36", "", "07", "24650", "", "-37.67852", "144.56883", "Australia/Melbourne"),
("7932575", "Kurunjang", "", "AU", "36", "", "07", "24650", "", "-37.67587", "144.5969", "Australia/Melbourne"),
("7932611", "Ashwood", "", "AU", "36", "", "07", "24970", "", "-37.86659", "145.10553", "Australia/Melbourne"),
("7932612", "Glen Iris", "", "AU", "36", "", "07", "26350", "", "-37.85995", "145.05489", "Australia/Melbourne"),
("7932618", "Caulfield North", "", "AU", "36", "", "07", "22310", "", "-37.87255", "145.02262", "Australia/Melbourne"),
("7932619", "Elsternwick", "", "AU", "36", "", "07", "22310", "", "-37.88441", "145.00434", "Australia/Melbourne"),
("7932620", "Elwood", "", "AU", "36", "", "07", "25900", "", "-37.88214", "144.98215", "Australia/Melbourne"),
("7932622", "Burwood", "", "AU", "36", "", "07", "26980", "", "-37.84978", "145.11901", "Australia/Melbourne"),
("7932623", "Box Hill South", "", "AU", "36", "", "07", "26980", "", "-37.83236", "145.12098", "Australia/Melbourne"),
("7932624", "Blackburn", "", "AU", "36", "", "07", "26980", "", "-37.81901", "145.15326", "Australia/Melbourne"),
("7932625", "Canterbury", "", "AU", "36", "", "07", "21110", "", "-37.8247", "145.08476", "Australia/Melbourne"),
("7932627", "Hawthorn East", "", "AU", "36", "", "07", "21110", "", "-37.82484", "145.0464", "Australia/Melbourne"),
("7932628", "Kew East", "", "AU", "36", "", "07", "21110", "", "-37.79758", "145.05378", "Australia/Melbourne"),
("7932629", "Balwyn North", "", "AU", "36", "", "07", "21110", "", "-37.79086", "145.09386", "Australia/Melbourne"),
("7932630", "Mont Albert North", "", "AU", "36", "", "07", "26980", "", "-37.80043", "145.10828", "Australia/Melbourne"),
("7932631", "Box Hill North", "", "AU", "36", "", "07", "26980", "", "-37.80266", "145.12656", "Australia/Melbourne"),
("7932632", "Blackburn North", "", "AU", "36", "", "07", "26980", "", "-37.80931", "145.1518", "Australia/Melbourne"),
("7932634", "Blackburn South", "", "AU", "36", "", "07", "26980", "", "-37.83975", "145.15549", "Australia/Melbourne"),
("7932635", "Chadstone", "", "AU", "36", "", "07", "24970", "", "-37.88766", "145.09519", "Australia/Melbourne"),
("7932638", "Malvern East", "", "AU", "36", "", "07", "26350", "", "-37.87397", "145.04253", "Australia/Melbourne"),
("7932640", "Oakleigh South", "", "AU", "36", "", "07", "24970", "", "-37.92416", "145.09146", "Australia/Melbourne"),
("7932643", "Caulfield South", "", "AU", "36", "", "07", "22310", "", "-37.89562", "145.02597", "Australia/Melbourne"),
("7932646", "Brighton East", "", "AU", "36", "", "07", "20910", "", "-37.90232", "145.01734", "Australia/Melbourne"),
("7932652", "Black Rock", "", "AU", "36", "", "07", "20910", "", "-37.97357", "145.01636", "Australia/Melbourne"),
("7932653", "Aspendale Gardens", "", "AU", "36", "", "07", "23430", "", "-38.02277", "145.11798", "Australia/Melbourne"),
("7932654", "Booval", "", "AU", "36", "", "04", "33960", "", "-27.61328", "152.78944", "Australia/Brisbane"),
("7932659", "Brassall", "", "AU", "36", "", "04", "33960", "", "-27.59753", "152.74755", "Australia/Brisbane"),
("7932664", "Raceview", "", "AU", "36", "", "04", "33960", "", "-27.63472", "152.77519", "Australia/Brisbane"),
("7932666", "Flinders View", "", "AU", "36", "", "04", "33960", "", "-27.65046", "152.77451", "Australia/Brisbane"),
("7932670", "Redbank Plains", "", "AU", "36", "", "04", "33960", "", "-27.64613", "152.85965", "Australia/Brisbane"),
("7932671", "Collingwood Park", "", "AU", "36", "", "04", "33960", "", "-27.61282", "152.86008", "Australia/Brisbane"),
("7932687", "Clontarf", "", "AU", "36", "", "04", "35010", "", "-27.25341", "153.07835", "Australia/Brisbane"),
("8014922", "Ballarat Central", "", "AU", "36", "", "07", "20570", "", "-37.56206", "143.85082", "Australia/Melbourne"),
("8015209", "St Albans", "", "AU", "36", "", "07", "21180", "", "-37.74496", "144.80049", "Australia/Melbourne"),
("8029813", "Eleebana", "", "AU", "36", "", "02", "14650", "", "-32.9896", "151.63642", "Australia/Sydney"),
("8029814", "Summer Hill", "", "AU", "36", "", "02", "10150", "", "-33.89146", "151.13825", "Australia/Sydney"),
("8298607", "Altona North", "", "AU", "36", "", "07", "23110", "", "-37.83487", "144.84735", "Australia/Melbourne"),
("8299269", "Balcatta", "", "AU", "36", "", "08", "57910", "", "-31.87501", "115.82839", "Australia/Perth"),
("8299578", "Belmont", "", "AU", "36", "", "08", "50490", "", "-31.9435", "115.9255", "Australia/Perth"),
("8310668", "Bateau Bay", "", "AU", "36", "", "02", "18550", "", "-33.38334", "151.46671", "Australia/Sydney"),
("8335007", "East Perth", "", "AU", "36", "", "08", "57080", "", "-31.95872", "115.87109", "Australia/Perth"),
("8335327", "Alexandria", "", "AU", "36", "", "02", "17200", "", "-33.90219", "151.20037", "Australia/Sydney"),
("8347324", "Doveton", "", "AU", "36", "", "07", "21610", "", "-37.99346", "145.23891", "Australia/Melbourne"),
("8347325", "Endeavour Hills", "", "AU", "36", "", "07", "21610", "", "-37.97695", "145.25866", "Australia/Melbourne"),
("8347750", "Tapping", "", "AU", "36", "", "08", "58760", "", "-31.71947", "115.79559", "Australia/Perth"),
("8347847", "Taylors Lakes", "", "AU", "36", "", "07", "21180", "", "-37.69863", "144.78631", "Australia/Melbourne"),
("8347891", "Woodvale", "", "AU", "36", "", "08", "54170", "", "-31.78928", "115.79676", "Australia/Perth"),
("8347896", "Roxburgh Park", "", "AU", "36", "", "07", "23270", "", "-37.62581", "144.92555", "Australia/Melbourne"),
("8347945", "Beeliar", "", "AU", "36", "", "08", "51820", "", "-32.13339", "115.80637", "Australia/Perth"),
("8347982", "Lynbrook", "", "AU", "36", "", "07", "21610", "", "-38.05588", "145.25615", "Australia/Melbourne"),
("8348078", "Wyndham Vale", "", "AU", "36", "", "07", "27260", "", "-37.8415", "144.54101", "Australia/Melbourne"),
("8348101", "Willetton", "", "AU", "36", "", "08", "51330", "", "-32.05251", "115.88782", "Australia/Perth"),
("8348173", "Carramar", "", "AU", "36", "", "08", "58760", "", "-31.69023", "115.77159", "Australia/Perth"),
("8348266", "Alexander Heights", "", "AU", "36", "", "08", "58760", "", "-31.82758", "115.86501", "Australia/Perth"),
("8348306", "Delahey", "", "AU", "36", "", "07", "21180", "", "-37.7198", "144.77732", "Australia/Melbourne"),
("8348314", "Wilson", "", "AU", "36", "", "08", "51330", "", "-32.02058", "115.91181", "Australia/Perth"),
("8348326", "Butler", "", "AU", "36", "", "08", "58760", "", "-31.64298", "115.70431", "Australia/Perth"),
("8348333", "Darch", "", "AU", "36", "", "08", "58760", "", "-31.81255", "115.8458", "Australia/Perth"),
("8348392", "Innaloo", "", "AU", "36", "", "08", "57910", "", "-31.89272", "115.79508", "Australia/Perth"),
("8348406", "Booragoon", "", "AU", "36", "", "08", "55320", "", "-32.03945", "115.83369", "Australia/Perth"),
("8348424", "Seville Grove", "", "AU", "36", "", "08", "50210", "", "-32.13645", "115.98905", "Australia/Perth"),
("8348442", "Murrumba Downs", "", "AU", "36", "", "04", "35010", "", "-27.26733", "153.01053", "Australia/Brisbane"),
("8348488", "Knoxfield", "", "AU", "36", "", "07", "23670", "", "-37.88978", "145.24962", "Australia/Melbourne"),
("8348536", "Little Mountain", "", "AU", "36", "", "04", "36710", "", "-26.78436", "153.09218", "Australia/Brisbane"),
("8348565", "Glendenning", "", "AU", "36", "", "02", "10750", "", "-33.7483", "150.85411", "Australia/Sydney"),
("8348655", "Padbury", "", "AU", "36", "", "08", "54170", "", "-31.80645", "115.7688", "Australia/Perth"),
("8348675", "East Victoria Park", "", "AU", "36", "", "08", "58510", "", "-31.98894", "115.90388", "Australia/Perth"),
("8348699", "Palmyra", "", "AU", "36", "", "08", "55320", "", "-32.04502", "115.78589", "Australia/Perth"),
("8348779", "Bell Park", "", "AU", "36", "", "07", "22750", "", "-38.10793", "144.33839", "Australia/Melbourne"),
("8348813", "Golden Square", "", "AU", "36", "", "07", "22620", "", "-36.77265", "144.25271", "Australia/Melbourne"),
("8348815", "Annerley", "", "AU", "36", "", "04", "31000", "", "-27.51228", "153.03248", "Australia/Brisbane"),
("8348836", "Dulwich Hill", "", "AU", "36", "", "02", "15200", "", "-33.9041", "151.13945", "Australia/Sydney"),
("8348843", "Viewbank", "", "AU", "36", "", "07", "20660", "", "-37.73991", "145.09323", "Australia/Melbourne"),
("8348898", "Chirnside Park", "", "AU", "36", "", "07", "27450", "", "-37.7386", "145.31431", "Australia/Melbourne"),
("8348967", "Meadow Heights", "", "AU", "36", "", "07", "23270", "", "-37.65117", "144.91855", "Australia/Melbourne"),
("8349002", "Westminster", "", "AU", "36", "", "08", "57910", "", "-31.86744", "115.83919", "Australia/Perth"),
("8349024", "Bibra Lake", "", "AU", "36", "", "08", "51820", "", "-32.09764", "115.81921", "Australia/Perth"),
("8349071", "Kardinya", "", "AU", "36", "", "08", "55320", "", "-32.06561", "115.81483", "Australia/Perth"),
("8349072", "Karrinyup", "", "AU", "36", "", "08", "57910", "", "-31.87233", "115.77684", "Australia/Perth"),
("8349075", "Kewdale", "", "AU", "36", "", "08", "50490", "", "-31.97886", "115.95159", "Australia/Perth"),
("8349092", "Ocean Reef", "", "AU", "36", "", "08", "54170", "", "-31.75871", "115.73601", "Australia/Perth"),
("8349098", "Port Kennedy", "", "AU", "36", "", "08", "57490", "", "-32.37342", "115.7515", "Australia/Perth"),
("8349100", "Secret Harbour", "", "AU", "36", "", "08", "57490", "", "-32.40589", "115.75852", "Australia/Perth"),
("8349105", "Tuart Hill", "", "AU", "36", "", "08", "57910", "", "-31.89808", "115.83495", "Australia/Perth"),
("8349108", "Thornlie", "", "AU", "36", "", "08", "53780", "", "-32.06003", "115.955", "Australia/Perth"),
("8349115", "Winthrop", "", "AU", "36", "", "08", "55320", "", "-32.05216", "115.82972", "Australia/Perth"),
("8349117", "Yangebup", "", "AU", "36", "", "08", "51820", "", "-32.12065", "115.81623", "Australia/Perth"),
("8349118", "Yokine", "", "AU", "36", "", "08", "57910", "", "-31.90113", "115.85319", "Australia/Perth"),
("8349243", "Hillside", "", "AU", "36", "", "07", "24650", "", "-37.69047", "144.74172", "Australia/Melbourne"),
("8349257", "Wavell Heights", "", "AU", "36", "", "04", "31000", "", "-27.39385", "153.04698", "Australia/Brisbane"),
("8349364", "Braybrook", "", "AU", "36", "", "07", "24330", "", "-37.78671", "144.85484", "Australia/Melbourne"),
("8349376", "Cairnlea", "", "AU", "36", "", "07", "21180", "", "-37.75931", "144.78781", "Australia/Melbourne"),
("8349381", "Bundoora", "", "AU", "36", "", "07", "20660", "", "-37.69825", "145.05967", "Australia/Melbourne"),
("8349399", "Patterson Lakes", "", "AU", "36", "", "07", "23430", "", "-38.06934", "145.14327", "Australia/Melbourne"),
("8349439", "Skye", "", "AU", "36", "", "07", "22170", "", "-38.10505", "145.2163", "Australia/Melbourne"),
("8436118", "Beaumont Hills", "", "AU", "36", "", "02", "10500", "", "-33.69993", "150.9411", "Australia/Sydney"),
("8469169", "North Adelaide", "", "AU", "36", "", "05", "40070", "", "-34.90733", "138.59141", "Australia/Adelaide"),
("8478275", "Victoria Park", "", "AU", "36", "", "08", "58510", "", "-31.97619", "115.90525", "Australia/Perth"),
("8555644", "Bondi Junction", "", "AU", "36", "", "02", "18050", "", "-33.89275", "151.24723", "Australia/Sydney"),
("8556202", "Bald Hills", "", "AU", "36", "", "04", "31000", "", "-27.32112", "153.00857", "Australia/Brisbane"),
("8629873", "Beecroft", "", "AU", "36", "", "02", "14000", "", "-33.74954", "151.0648", "Australia/Sydney"),
("9172072", "Lane Cove North", "", "AU", "36", "", "02", "18250", "", "-33.80543", "151.16638", "Australia/Sydney"),
("9883890", "Ascot", "", "AU", "36", "", "04", "31000", "", "-27.43154", "153.058", "Australia/Brisbane"),
("9957323", "Chermside West", "", "AU", "36", "", "04", "31000", "", "-27.38383", "153.01586", "Australia/Brisbane"),
("9957324", "Everton Park", "", "AU", "36", "", "04", "31000", "", "-27.40732", "152.9884", "Australia/Brisbane"),
("9957327", "Stafford", "", "AU", "36", "", "04", "31000", "", "-27.41044", "153.01105", "Australia/Brisbane"),
("9957328", "Stafford Heights", "", "AU", "36", "", "04", "31000", "", "-27.39354", "153.0105", "Australia/Brisbane"),
("9957340", "Forest Lake", "", "AU", "36", "", "04", "31000", "", "-27.62563", "152.96883", "Australia/Brisbane"),
("9957342", "Greenslopes", "", "AU", "36", "", "04", "31000", "", "-27.50815", "153.04951", "Australia/Brisbane"),
("9957346", "Mansfield", "", "AU", "36", "", "04", "31000", "", "-27.53929", "153.09895", "Australia/Brisbane"),
("9957347", "Mount Gravatt East", "", "AU", "36", "", "04", "31000", "", "-27.5405", "153.08221", "Australia/Brisbane"),
("9957350", "Sunnybank Hills", "", "AU", "36", "", "04", "31000", "", "-27.61025", "153.05388", "Australia/Brisbane"),
("9957351", "Upper Mount Gravatt", "", "AU", "36", "", "04", "31000", "", "-27.56128", "153.08453", "Australia/Brisbane"),
("9957353", "Yeronga", "", "AU", "36", "", "04", "31000", "", "-27.51571", "153.01642", "Australia/Brisbane"),
("9957444", "Camp Hill", "", "AU", "36", "", "04", "31000", "", "-27.49354", "153.07629", "Australia/Brisbane"),
("9957521", "Manly West", "", "AU", "36", "", "04", "31000", "", "-27.47382", "153.16641", "Australia/Brisbane"),
("9957543", "Morningside", "", "AU", "36", "", "04", "31000", "", "-27.46165", "153.07511", "Australia/Brisbane"),
("9957637", "Wynnum West", "", "AU", "36", "", "04", "31000", "", "-27.45824", "153.15319", "Australia/Brisbane"),
("9957703", "Springfield", "", "AU", "36", "", "04", "33960", "", "-27.65365", "152.91716", "Australia/Brisbane"),
("9958114", "Rochedale South", "", "AU", "36", "", "04", "34590", "", "-27.59521", "153.12332", "Australia/Brisbane"),
("9958129", "Waterford West", "", "AU", "36", "", "04", "34590", "", "-27.69056", "153.13319", "Australia/Brisbane"),
("9958153", "Ferny Hills", "", "AU", "36", "", "04", "35010", "", "-27.39594", "152.93737", "Australia/Brisbane"),
("9958500", "Samford Valley", "", "AU", "36", "", "04", "35010", "", "-27.3727", "152.86699", "Australia/Brisbane"),
("9972408", "Flemington", "", "AU", "36", "", "07", "25060", "", "-37.78825", "144.93001", "Australia/Melbourne"),
("9972411", "Fairfield", "", "AU", "36", "", "07", "21890", "", "-37.77977", "145.01764", "Australia/Melbourne"),
("9972412", "Heidelberg Heights", "", "AU", "36", "", "07", "20660", "", "-37.74313", "145.05695", "Australia/Melbourne"),
("9972415", "Westmeadows", "", "AU", "36", "", "07", "23270", "", "-37.67604", "144.88701", "Australia/Melbourne"),
("9972422", "Keilor East", "", "AU", "36", "", "07", "25060", "", "-37.73261", "144.86504", "Australia/Melbourne"),
("9972423", "Coburg North", "", "AU", "36", "", "07", "25250", "", "-37.72867", "144.96134", "Australia/Melbourne"),
("9972464", "Hadfield", "", "AU", "36", "", "07", "25250", "", "-37.70728", "144.9416", "Australia/Melbourne"),
("9972465", "Oak Park", "", "AU", "36", "", "07", "25250", "", "-37.71842", "144.91945", "Australia/Melbourne"),
("9972466", "Pascoe Vale South", "", "AU", "36", "", "07", "25250", "", "-37.73973", "144.94615", "Australia/Melbourne"),
("9972470", "Bayswater North", "", "AU", "36", "", "07", "24410", "", "-37.82612", "145.29831", "Australia/Melbourne"),
("9972471", "Croydon Hills", "", "AU", "36", "", "07", "24410", "", "-37.77651", "145.26355", "Australia/Melbourne"),
("9972487", "Vermont South", "", "AU", "36", "", "07", "26980", "", "-37.85747", "145.1827", "Australia/Melbourne"),
("9972515", "Cranbourne East", "", "AU", "36", "", "07", "21610", "", "-38.11531", "145.29814", "Australia/Melbourne"),
("9972516", "Cranbourne North", "", "AU", "36", "", "07", "21610", "", "-38.08292", "145.27805", "Australia/Melbourne"),
("9972517", "Cranbourne West", "", "AU", "36", "", "07", "21610", "", "-38.0965", "145.26707", "Australia/Melbourne"),
("9972518", "Narre Warren South", "", "AU", "36", "", "07", "21610", "", "-38.04369", "145.2923", "Australia/Melbourne"),
("9972522", "Dandenong North", "", "AU", "36", "", "07", "22670", "", "-37.96649", "145.2081", "Australia/Melbourne"),
("9972524", "Noble Park North", "", "AU", "36", "", "07", "22670", "", "-37.94978", "145.19257", "Australia/Melbourne"),
("9972526", "Frankston North", "", "AU", "36", "", "07", "22170", "", "-38.12352", "145.14836", "Australia/Melbourne"),
("9972527", "Frankston South", "", "AU", "36", "", "07", "22170", "", "-38.16604", "145.13643", "Australia/Melbourne"),
("9972569", "Keilor Downs", "", "AU", "36", "", "07", "21180", "", "-37.72337", "144.80839", "Australia/Melbourne"),
("9972577", "Sunshine North", "", "AU", "36", "", "07", "21180", "", "-37.76987", "144.82787", "Australia/Melbourne"),
("9972578", "Sunshine West", "", "AU", "36", "", "07", "21180", "", "-37.79117", "144.81637", "Australia/Melbourne"),
("9972579", "Altona Meadows", "", "AU", "36", "", "07", "23110", "", "-37.88413", "144.78367", "Australia/Melbourne"),
("9972583", "West Footscray", "", "AU", "36", "", "07", "24330", "", "-37.79746", "144.87727", "Australia/Melbourne"),
("9972586", "Taylors Hill", "", "AU", "36", "", "07", "24650", "", "-37.70988", "144.75483", "Australia/Melbourne"),
("9972597", "Allambie Heights", "", "AU", "36", "", "02", "18000", "", "-33.76655", "151.24981", "Australia/Sydney"),
("9972601", "Belfield", "", "AU", "36", "", "02", "11550", "", "-33.90354", "151.08467", "Australia/Sydney"),
("9972602", "Berala", "", "AU", "36", "", "02", "10200", "", "-33.87197", "151.03386", "Australia/Sydney"),
("9972604", "Berowra Heights", "", "AU", "36", "", "02", "14000", "", "-33.61211", "151.13754", "Australia/Sydney"),
("9972618", "Bondi Beach", "", "AU", "36", "", "02", "18050", "", "-33.89079", "151.27852", "Australia/Sydney"),
("9972621", "Cabramatta West", "", "AU", "36", "", "02", "12850", "", "-33.89669", "150.91056", "Australia/Sydney"),
("9972622", "Cambridge Park", "", "AU", "36", "", "02", "16350", "", "-33.74784", "150.72208", "Australia/Sydney"),
("9972625", "Caringbah South", "", "AU", "36", "", "02", "17150", "", "-34.05662", "151.12149", "Australia/Sydney"),
("9972648", "Concord West", "", "AU", "36", "", "02", "11520", "", "-33.84809", "151.08609", "Australia/Sydney"),
("9972670", "Ermington", "", "AU", "36", "", "02", "16250", "", "-33.81483", "151.05467", "Australia/Sydney"),
("9972671", "Fairfield East", "", "AU", "36", "", "02", "12850", "", "-33.86938", "150.97129", "Australia/Sydney"),
("9972672", "Fairfield Heights", "", "AU", "36", "", "02", "12850", "", "-33.86445", "150.93884", "Australia/Sydney"),
("9972673", "Fairlight", "", "AU", "36", "", "02", "15150", "", "-33.79575", "151.27346", "Australia/Sydney"),
("9972707", "Harris Park", "", "AU", "36", "", "02", "16250", "", "-33.82285", "151.00781", "Australia/Sydney"),
("9972759", "Hornsby Heights", "", "AU", "36", "", "02", "14000", "", "-33.6713", "151.09428", "Australia/Sydney"),
("9972778", "Killara", "", "AU", "36", "", "02", "14500", "", "-33.76604", "151.16213", "Australia/Sydney"),
("9972786", "Kingswood Park", "", "AU", "36", "", "02", "16350", "", "-33.76651", "150.7144", "Australia/Sydney"),
("9972815", "Macquarie Park", "", "AU", "36", "", "02", "16700", "", "-33.775", "151.11248", "Australia/Sydney"),
("9972821", "Marsfield", "", "AU", "36", "", "02", "16700", "", "-33.77784", "151.10574", "Australia/Sydney"),
("9972832", "Narellan Vale", "", "AU", "36", "", "02", "11450", "", "-34.04974", "150.74392", "Australia/Sydney"),
("9972833", "Narraweena", "", "AU", "36", "", "02", "18000", "", "-33.75519", "151.27659", "Australia/Sydney"),
("9972847", "North Bondi", "", "AU", "36", "", "02", "18050", "", "-33.88787", "151.28075", "Australia/Sydney"),
("9972937", "South Coogee", "", "AU", "36", "", "02", "16550", "", "-33.93106", "151.25599", "Australia/Sydney"),
("9972943", "South Windsor", "", "AU", "36", "", "02", "13800", "", "-33.61808", "150.80443", "Australia/Sydney"),
("9972945", "Stanhope Gardens", "", "AU", "36", "", "02", "10750", "", "-33.72206", "150.92597", "Australia/Sydney"),
("9972948", "Telopea", "", "AU", "36", "", "02", "16250", "", "-33.79279", "151.03858", "Australia/Sydney"),
("9972964", "West Pennant", "", "AU", "36", "", "02", "10500", "", "-33.7457", "151.04764", "Australia/Sydney"),
("9972965", "West Ryde", "", "AU", "36", "", "02", "16700", "", "-33.80543", "151.07386", "Australia/Sydney"),
("9972972", "Wollstonecraft", "", "AU", "36", "", "02", "15950", "", "-33.8328", "151.18981", "Australia/Sydney"),
("9973091", "Henley Beach", "", "AU", "36", "", "05", "41060", "", "-34.92029", "138.49442", "Australia/Adelaide"),
("10035407", "City Beach", "", "AU", "36", "", "08", "51310", "", "-31.9344", "115.76174", "Australia/Perth"),
("10055413", "Kallaroo", "", "AU", "36", "", "08", "54170", "", "-31.79098", "115.75298", "Australia/Perth"),
("10056968", "Mount Pleasant", "", "AU", "36", "", "08", "55320", "", "-32.03974", "115.84993", "Australia/Perth"),
("10056976", "Parmelia", "", "AU", "36", "", "08", "54830", "", "-32.25784", "115.82208", "Australia/Perth"),
("10056984", "Rivervale", "", "AU", "36", "", "08", "50490", "", "-31.95546", "115.91306", "Australia/Perth"),
("10057011", "South Lake", "", "AU", "36", "", "08", "51820", "", "-32.11125", "115.83873", "Australia/Perth"),
("10057017", "Wembley Downs", "", "AU", "36", "", "08", "57910", "", "-31.91169", "115.77358", "Australia/Perth"),
("10062591", "West Moonah", "", "AU", "36", "", "06", "62610", "", "-42.84996", "147.28181", "Australia/Hobart"),
("10063050", "Burleigh Waters", "", "AU", "36", "", "04", "33430", "", "-28.09975", "153.42463", "Australia/Brisbane"),
("10103846", "Elermore Vale", "", "AU", "36", "", "02", "15900", "", "-32.91621", "151.67665", "Australia/Sydney"),
("10103855", "Mayfield", "", "AU", "36", "", "02", "15900", "", "-32.89793", "151.73613", "Australia/Sydney"),
("10103878", "Belmont North", "", "AU", "36", "", "02", "14650", "", "-33.02081", "151.66849", "Australia/Sydney"),
("10103951", "Toronto", "", "AU", "36", "", "02", "14650", "", "-33.01357", "151.59373", "Australia/Sydney"),
("10108696", "Albion Park Rail", "", "AU", "36", "", "02", "16900", "", "-34.56123", "150.79675", "Australia/Sydney"),
("10108731", "Barrack Heights", "", "AU", "36", "", "02", "16900", "", "-34.56601", "150.85516", "Australia/Sydney"),
("10109423", "Cordeaux Heights", "", "AU", "36", "", "02", "18450", "", "-34.44043", "150.83748", "Australia/Sydney"),
("10110993", "Hamlyn Heights", "", "AU", "36", "", "07", "22750", "", "-38.12108", "144.32799", "Australia/Melbourne"),
("10114292", "Tweed Heads West", "", "AU", "36", "", "02", "17550", "", "-28.18736", "153.52278", "Australia/Sydney"),
("10114318", "Rangeville", "", "AU", "36", "", "04", "36910", "", "-27.58318", "151.97997", "Australia/Brisbane"),
("10114319", "Darling Heights", "", "AU", "36", "", "04", "36910", "", "-27.59659", "151.93045", "Australia/Brisbane"),
("10114321", "East Toowoomba", "", "AU", "36", "", "04", "36910", "", "-27.57086", "151.97422", "Australia/Brisbane"),
("10114338", "South Tamworth", "", "AU", "36", "", "02", "17310", "", "-31.11", "150.92254", "Australia/Sydney"),
("10116056", "East Albury", "", "AU", "36", "", "02", "10050", "", "-36.08144", "146.92991", "Australia/Sydney"),
("10116099", "North Albury", "", "AU", "36", "", "02", "10050", "", "-36.05745", "146.92995", "Australia/Sydney"),
("11073472", "Marangaroo", "", "AU", "36", "", "08", "58760", "", "-31.82711", "115.83843", "Australia/Perth"),
("146858", "Sharur City", "", "AZ", "31", "", "35", "147997", "", "39.55298", "44.97993", "Asia/Baku"),
("146862", "Prishibinskoye", "", "AZ", "31", "", "15", "", "", "39.11817", "48.59255", "Asia/Baku"),
("146901", "Zangilan", "", "AZ", "31", "", "69", "", "", "39.0884", "46.6513", "Asia/Baku"),
("146958", "Yaycı", "", "AZ", "31", "", "35", "148132", "", "38.94052", "45.73244", "Asia/Baku"),
("146961", "Yardımlı", "", "AZ", "31", "", "66", "", "", "38.90771", "48.24052", "Asia/Baku"),
("146969", "Novyy Karanlug", "", "AZ", "31", "", "65", "", "", "39.79546", "47.10989", "Asia/Baku"),
("146970", "Xankandi", "Степанакерт", "AZ", "31", "", "61", "", "", "39.8177", "46.7528", "Asia/Baku"),
("147059", "Əhmədbəyli", "Tel’mankend", "AZ", "31", "", "45", "", "", "39.87867", "48.39901", "Asia/Baku"),
("147105", "Shushi", "Шуша", "AZ", "31", "", "55", "", "", "39.76006", "46.74989", "Asia/Baku"),
("147271", "Salyan", "Сальян", "AZ", "31", "", "49", "", "", "39.59621", "48.98479", "Asia/Baku"),
("147288", "Saatlı", "Саатлы", "AZ", "31", "", "45", "", "", "39.93214", "48.36892", "Asia/Baku"),
("147305", "Qubadlı", "", "AZ", "31", "", "43", "", "", "39.34441", "46.58183", "Asia/Baku"),
("147368", "Ordubad", "", "AZ", "31", "", "35", "147365", "", "38.90961", "46.02274", "Asia/Baku"),
("147425", "Neftçala", "Нефтечала", "AZ", "31", "", "36", "", "", "39.3768", "49.247", "Asia/Baku"),
("147429", "Nakhchivan", "Нахичевань", "AZ", "31", "", "35", "7669114", "", "39.20889", "45.41222", "Asia/Baku"),
("147504", "Mincivan", "", "AZ", "31", "", "69", "", "", "39.03058", "46.7214", "Asia/Baku"),
("147552", "Masally", "", "AZ", "31", "", "32", "", "", "39.03532", "48.6654", "Asia/Baku"),
("147611", "Lerik", "", "AZ", "31", "", "31", "", "", "38.77388", "48.41497", "Asia/Baku"),
("147622", "Lankaran", "Ленкорань", "AZ", "31", "", "29", "", "", "38.75428", "48.85062", "Asia/Baku"),
("147625", "Laçın", "", "AZ", "31", "", "28", "", "", "39.59881", "46.55045", "Asia/Baku"),
("147774", "Xocalı", "", "AZ", "31", "", "64", "", "", "39.91297", "46.79028", "Asia/Baku"),
("147982", "Imishli", "Имишли", "AZ", "31", "", "24", "", "", "39.87095", "48.05995", "Asia/Baku"),
("148106", "Fizuli", "Физули", "AZ", "31", "", "18", "", "", "39.60094", "47.14529", "Asia/Baku"),
("148141", "Jebrail", "", "AZ", "31", "", "14", "", "", "39.39917", "47.02835", "Asia/Baku"),
("148177", "Dünyamalılar", "", "AZ", "31", "AZ", "12", "", "", "39.77278", "47.75889", "Asia/Baku"),
("148251", "Culfa", "", "AZ", "31", "", "35", "148132", "", "38.95397", "45.62961", "Asia/Baku"),
("148290", "Dzhalilabad", "", "AZ", "31", "", "15", "", "", "39.20963", "48.49186", "Asia/Baku"),
("148291", "Cahri", "", "AZ", "31", "", "35", "7669114", "", "39.34837", "45.41557", "Asia/Baku"),
("148323", "Boradigah", "", "AZ", "31", "", "32", "", "", "38.93013", "48.7092", "Asia/Baku"),
("148340", "Pushkino", "", "AZ", "31", "", "13", "", "", "39.45833", "48.545", "Asia/Baku"),
("148354", "Beylagan", "", "AZ", "31", "", "12", "", "", "39.77556", "47.61861", "Asia/Baku"),
("148375", "Severo-Vostotchnyi Bank", "", "AZ", "31", "", "36", "", "", "39.41117", "49.24792", "Asia/Baku"),
("148445", "Astara", "Астара", "AZ", "31", "", "08", "", "", "38.45598", "48.87498", "Asia/Baku"),
("148565", "Şirvan", "Ширван", "AZ", "31", "", "07", "", "", "39.93778", "48.929", "Asia/Baku"),
("148619", "Ağdam", "Агдам", "AZ", "31", "", "03", "", "", "39.99096", "46.92736", "Asia/Baku"),
("393927", "Avşar", "", "AZ", "31", "AZ", "02", "", "", "39.97389", "47.42389", "Asia/Baku"),
("584562", "Zyrya", "", "AZ", "31", "", "09", "", "", "40.36613", "50.29198", "Asia/Baku"),
("584586", "Zardob", "", "AZ", "31", "", "71", "", "", "40.21991", "47.70997", "Asia/Baku"),
("584596", "Zaqatala", "Закаталы", "AZ", "31", "", "70", "", "", "41.6316", "46.64479", "Asia/Baku"),
("584614", "Zabrat", "Забрат", "AZ", "31", "", "09", "", "", "40.47746", "49.94174", "Asia/Baku"),
("584649", "Yevlakh", "Евлах", "AZ", "31", "", "68", "", "", "40.61832", "47.15014", "Asia/Baku"),
("584715", "Xudat", "", "AZ", "31", "", "60", "", "", "41.63052", "48.68161", "Asia/Baku"),
("584716", "Yelenendorf", "Гёйгёль", "AZ", "31", "", "62", "", "", "40.58584", "46.3189", "Asia/Baku"),
("584717", "Xaçmaz", "Хачмас", "AZ", "31", "", "60", "", "", "41.46426", "48.80565", "Asia/Baku"),
("584791", "Ujar", "Уджары", "AZ", "31", "", "59", "", "", "40.51902", "47.65423", "Asia/Baku"),
("584792", "Türkan", "", "AZ", "31", "", "09", "", "", "40.3646", "50.22075", "Asia/Baku"),
("584821", "Tovuz", "", "AZ", "31", "", "58", "", "", "40.99249", "45.62838", "Asia/Baku"),
("584871", "Terter", "Тертер", "AZ", "31", "", "57", "", "", "40.34179", "46.93242", "Asia/Baku"),
("584923", "Sumqayıt", "Сумгаит", "AZ", "31", "", "54", "", "", "40.58972", "49.66861", "Asia/Baku"),
("584954", "Kyzyl-Burun", "", "AZ", "31", "", "53", "", "", "41.07754", "49.11257", "Asia/Baku"),
("585103", "Qaraçuxur", "Гарачухур", "AZ", "31", "", "09", "", "", "40.39667", "49.97361", "Asia/Baku"),
("585145", "Saray", "", "AZ", "31", "", "01", "", "", "40.53299", "49.71681", "Asia/Baku"),
("585152", "Shamkhor", "Шамкир", "AZ", "31", "", "51", "", "", "40.82975", "46.0178", "Asia/Baku"),
("585156", "Shamakhi", "Шемаха", "AZ", "31", "", "50", "", "", "40.63141", "48.64137", "Asia/Baku"),
("585170", "Sheki", "Шеки", "AZ", "31", "", "48", "", "", "41.19194", "47.17056", "Asia/Baku"),
("585177", "Samux", "", "AZ", "31", "", "52", "", "", "40.76485", "46.40868", "Asia/Baku"),
("585184", "Sabunçu", "Сабунчи", "AZ", "31", "", "09", "", "", "40.4425", "49.94806", "Asia/Baku"),
("585187", "Sabirabad", "Сабирабад", "AZ", "31", "", "46", "", "", "40.00869", "48.47701", "Asia/Baku"),
("585220", "Qusar", "Кусары", "AZ", "31", "", "44", "", "", "41.4275", "48.4302", "Asia/Baku"),
("585221", "Quba", "Куба", "AZ", "31", "", "42", "", "", "41.36108", "48.51341", "Asia/Baku"),
("585223", "Qobustan", "", "AZ", "31", "", "09", "", "", "40.08238", "49.41205", "Asia/Baku"),
("585225", "Hacıqabul", "Кази-Магомед", "AZ", "31", "", "23", "", "", "40.03874", "48.94286", "Asia/Baku"),
("585226", "Qazax", "Казах", "AZ", "31", "", "40", "", "", "41.09246", "45.36561", "Asia/Baku"),
("585227", "Qax", "", "AZ", "31", "", "39", "", "", "41.41826", "46.92043", "Asia/Baku"),
("585231", "Qutqashen", "", "AZ", "31", "", "38", "", "", "40.98247", "47.84909", "Asia/Baku"),
("585333", "Oğuz", "", "AZ", "31", "", "37", "", "", "41.07128", "47.46528", "Asia/Baku"),
("585379", "Hacı Zeynalabdin", "", "AZ", "31", "", "54", "", "", "40.62333", "49.55861", "Asia/Baku"),
("585388", "Nardaran", "", "AZ", "31", "", "09", "", "", "40.55611", "50.00556", "Asia/Baku"),
("585400", "Naftalan", "", "AZ", "31", "", "34", "", "", "40.50821", "46.8203", "Asia/Baku"),
("585514", "Mingelchaur", "Мингечаур", "AZ", "31", "", "33", "", "", "40.76395", "47.05953", "Asia/Baku"),
("585557", "Maştağa", "Маштага", "AZ", "31", "", "09", "", "", "40.52983", "50.00616", "Asia/Baku"),
("585568", "Mardakan", "Мардакян", "AZ", "31", "", "09", "", "", "40.49182", "50.14292", "Asia/Baku"),
("585570", "Qobustan", "", "AZ", "31", "", "41", "", "", "40.5336", "48.92819", "Asia/Baku"),
("585630", "Lökbatan", "Локбатан", "AZ", "31", "", "09", "", "", "40.3256", "49.73376", "Asia/Baku"),
("585666", "Qızılhacılı", "", "AZ", "31", "", "21", "", "", "40.57362", "46.849", "Asia/Baku"),
("585763", "Kyurdarmir", "Кюрдамир", "AZ", "31", "", "27", "", "", "40.34532", "48.15085", "Asia/Baku"),
("585838", "Qobu", "", "AZ", "31", "", "01", "", "", "40.40472", "49.71306", "Asia/Baku"),
("585909", "Khyzy", "", "AZ", "31", "", "63", "", "", "40.90576", "49.08127", "Asia/Baku"),
("585915", "Khirdalan", "Хырдалан", "AZ", "31", "", "01", "", "", "40.44808", "49.75502", "Asia/Baku"),
("585940", "Khodzhi-Gasan", "", "AZ", "31", "", "09", "", "", "40.41293", "49.76904", "Asia/Baku"),
("586135", "Qarayeri", "", "AZ", "31", "", "52", "", "", "40.78825", "46.3072", "Asia/Baku"),
("586268", "Kerbakhiar", "", "AZ", "31", "", "26", "", "", "40.10984", "46.04446", "Asia/Baku"),
("586318", "İsmayıllı", "", "AZ", "31", "", "25", "", "", "40.78485", "48.15141", "Asia/Baku"),
("586340", "Yeni Suraxanı", "", "AZ", "31", "", "09", "", "", "40.43026", "50.03598", "Asia/Baku"),
("586427", "Geoktschai", "Геокчай", "AZ", "31", "", "22", "", "", "40.65055", "47.74219", "Asia/Baku"),
("586429", "Hövsan", "Говсан", "AZ", "31", "", "09", "", "", "40.37444", "50.08528", "Asia/Baku"),
("586430", "Goranboy", "", "AZ", "31", "", "21", "", "", "40.61028", "46.78972", "Asia/Baku"),
("586523", "Ganja", "Гянджа", "AZ", "31", "", "20", "", "", "40.68278", "46.36056", "Asia/Baku"),
("586573", "Kyadabek", "", "AZ", "31", "", "19", "", "", "40.57055", "45.81229", "Asia/Baku"),
("586631", "Corat", "", "AZ", "31", "", "54", "", "", "40.57176", "49.70509", "Asia/Baku"),
("586652", "Ceyranbatan", "", "AZ", "31", "", "01", "", "", "40.54194", "49.66073", "Asia/Baku"),
("586692", "Dzagam", "", "AZ", "31", "", "51", "", "", "40.9033", "45.88564", "Asia/Baku"),
("586763", "Divichibazar", "Дивичи", "AZ", "31", "", "17", "", "", "41.20117", "48.98712", "Asia/Baku"),
("586765", "Yukhary-Dashkesan", "", "AZ", "31", "", "16", "", "", "40.52393", "46.08186", "Asia/Baku"),
("586845", "Çinarlı", "", "AZ", "31", "", "39", "", "", "41.46965", "46.91582", "Asia/Baku"),
("586925", "Buzovna", "Бузовна", "AZ", "31", "", "09", "", "", "40.51903", "50.11438", "Asia/Baku"),
("586967", "Binagadi", "", "AZ", "31", "", "09", "", "", "40.46602", "49.82783", "Asia/Baku"),
("586968", "Biny Selo", "Бина", "AZ", "31", "", "09", "", "", "40.45076", "50.08686", "Asia/Baku"),
("586971", "Bilajer", "", "AZ", "31", "", "09", "", "", "40.56441", "50.04002", "Asia/Baku"),
("587057", "Barda", "Барда", "AZ", "31", "", "11", "", "", "40.37577", "47.12619", "Asia/Baku"),
("587070", "Belokany", "", "AZ", "31", "", "10", "", "", "41.72626", "46.40478", "Asia/Baku"),
("587071", "Balakhani", "", "AZ", "31", "", "09", "", "", "40.46344", "49.91893", "Asia/Baku"),
("587078", "Bilajari", "", "AZ", "31", "", "09", "", "", "40.4444", "49.80566", "Asia/Baku"),
("587084", "Baku", "Баку", "AZ", "31", "", "09", "", "", "40.37767", "49.89201", "Asia/Baku"),
("587207", "Pirallahı", "", "AZ", "31", "", "09", "", "", "40.47013", "50.32476", "Asia/Baku"),
("587261", "Amirdzhan", "", "AZ", "31", "", "09", "", "", "40.42639", "49.98361", "Asia/Baku"),
("587319", "Aliabad", "", "AZ", "31", "", "70", "", "", "41.4829", "46.63483", "Asia/Baku"),
("587361", "Aghsu", "Ахсу", "AZ", "31", "", "06", "", "", "40.57028", "48.40087", "Asia/Baku"),
("587362", "Aghstafa", "", "AZ", "31", "", "05", "", "", "41.11889", "45.45389", "Asia/Baku"),
("587378", "Ağdaş", "Агдаш", "AZ", "31", "", "04", "", "", "40.64699", "47.4738", "Asia/Baku"),
("587379", "Martakert", "", "AZ", "31", "", "57", "", "", "40.21238", "46.82086", "Asia/Baku"),
("587384", "Agdzhabedy", "Агджабеди", "AZ", "31", "", "02", "", "", "40.05015", "47.45937", "Asia/Baku"),
("824003", "Bakıxanov", "Бакиханова", "AZ", "31", "", "09", "", "", "40.41894", "49.96693", "Asia/Baku"),
("824050", "Aran", "", "AZ", "31", "", "67", "", "", "40.62528", "46.97556", "Asia/Baku"),
("863732", "Ramana", "", "AZ", "31", "", "09", "", "", "40.44222", "49.98056", "Asia/Baku"),
("863761", "Badamdar", "", "AZ", "31", "", "09", "", "", "40.34024", "49.8045", "Asia/Baku"),
("3186246", "Zvornik", "", "BA", "70", "", "02", "", "", "44.38605", "19.10247", "Europe/Sarajevo"),
("3186423", "Živinice", "", "BA", "70", "", "01", "", "", "44.44929", "18.64978", "Europe/Sarajevo"),
("3186567", "Žepče", "", "BA", "70", "", "01", "", "", "44.42667", "18.03778", "Europe/Sarajevo"),
("3186573", "Zenica", "Зеница", "BA", "70", "", "01", "", "", "44.20169", "17.90397", "Europe/Sarajevo"),
("3186588", "Željezno Polje", "", "BA", "70", "", "01", "", "", "44.39875", "17.94103", "Europe/Sarajevo"),
("3186717", "Zavidovići", "", "BA", "70", "", "01", "", "", "44.44583", "18.14972", "Europe/Sarajevo"),
("3187162", "Vrnograč", "", "BA", "70", "", "01", "", "", "45.16369", "15.95444", "Europe/Sarajevo"),
("3187464", "Vogošća", "", "BA", "70", "", "01", "", "", "43.90225", "18.34438", "Europe/Sarajevo"),
("3187590", "Vitez", "", "BA", "70", "", "01", "", "", "44.15424", "17.79009", "Europe/Sarajevo"),
("3187609", "Visoko", "Високо", "BA", "70", "", "01", "", "", "43.98889", "18.17806", "Europe/Sarajevo"),
("3187681", "Višegrad", "", "BA", "70", "", "02", "", "", "43.7826", "19.29256", "Europe/Sarajevo"),
("3188199", "Velika Obarska", "", "BA", "70", "", "02", "", "", "44.80461", "19.16183", "Europe/Sarajevo"),
("3188225", "Velika Kladuša", "Велика-Кладуша", "BA", "70", "", "01", "", "", "45.18497", "15.80579", "Europe/Sarajevo"),
("3188357", "Varoška Rijeka", "", "BA", "70", "", "01", "", "", "45.08936", "16.01906", "Europe/Sarajevo"),
("3188366", "Vareš", "", "BA", "70", "", "01", "", "", "44.16444", "18.32833", "Europe/Sarajevo"),
("3188582", "Tuzla", "Тузла", "BA", "70", "", "01", "", "", "44.53842", "18.66709", "Europe/Sarajevo"),
("3188691", "Tržačka Raštela", "", "BA", "70", "", "01", "", "", "44.97597", "15.78489", "Europe/Sarajevo"),
("3188817", "Trn", "", "BA", "70", "", "02", "", "", "44.85829", "17.23583", "Europe/Sarajevo"),
("3188893", "Trebinje", "Требинье", "BA", "70", "", "02", "", "", "42.71197", "18.34362", "Europe/Sarajevo"),
("3188924", "Travnik", "Травник", "BA", "70", "", "01", "", "", "44.22637", "17.66583", "Europe/Sarajevo"),
("3189046", "Tojšići", "", "BA", "70", "", "01", "", "", "44.50133", "18.78523", "Europe/Sarajevo"),
("3189143", "Teslić", "", "BA", "70", "", "02", "", "", "44.60639", "17.85972", "Europe/Sarajevo"),
("3189146", "Tešanj", "", "BA", "70", "", "01", "", "", "44.61191", "17.98552", "Europe/Sarajevo"),
("3189602", "Šturlić", "", "BA", "70", "", "01", "", "", "45.06389", "15.77806", "Europe/Sarajevo"),
("3189823", "Stolac", "", "BA", "70", "", "01", "", "", "43.084", "17.95995", "Europe/Sarajevo"),
("3189884", "Stijena", "", "BA", "70", "", "01", "", "", "44.9363", "16.02224", "Europe/Sarajevo"),
("3190158", "Srebrenik", "", "BA", "70", "", "01", "", "", "44.70819", "18.48834", "Europe/Sarajevo"),
("3190172", "Srbac", "", "BA", "70", "", "02", "", "", "45.0973", "17.52331", "Europe/Sarajevo"),
("3190385", "Sokolac", "", "BA", "70", "", "02", "", "", "43.93817", "18.80079", "Europe/Sarajevo"),
("3190733", "Kneževo", "", "BA", "70", "", "02", "", "", "44.49071", "17.38161", "Europe/Sarajevo"),
("3190837", "Šipovo", "", "BA", "70", "", "02", "", "", "44.28237", "17.08597", "Europe/Sarajevo"),
("3191156", "Šekovići", "", "BA", "70", "", "02", "", "", "44.29896", "18.85532", "Europe/Sarajevo"),
("3191281", "Sarajevo", "Сараево", "BA", "70", "", "01", "3343737", "", "43.84864", "18.35644", "Europe/Sarajevo"),
("3191297", "Sanski Most", "", "BA", "70", "", "01", "", "", "44.7667", "16.667", "Europe/Sarajevo"),
("3191302", "Sanica", "", "BA", "70", "", "01", "", "", "44.61354", "16.64062", "Europe/Sarajevo"),
("3191589", "Rodoč", "", "BA", "70", "", "01", "", "", "43.31453", "17.8029", "Europe/Sarajevo"),
("3192236", "Novi Travnik", "", "BA", "70", "", "01", "", "", "44.17133", "17.65816", "Europe/Sarajevo"),
("3192279", "Prozor", "", "BA", "70", "", "01", "", "", "43.82222", "17.60917", "Europe/Sarajevo"),
("3192327", "Prnjavor", "", "BA", "70", "", "02", "", "", "44.87021", "17.66256", "Europe/Sarajevo"),
("3192409", "Prijedor", "Приедора", "BA", "70", "", "02", "", "", "44.97991", "16.71401", "Europe/Sarajevo"),
("3192653", "Potoci", "", "BA", "70", "", "01", "", "", "43.40953", "17.87855", "Europe/Sarajevo"),
("3192878", "Podzvizd", "", "BA", "70", "", "01", "", "", "45.17417", "15.87361", "Europe/Sarajevo"),
("3193008", "Podhum", "", "BA", "70", "", "01", "", "", "43.72295", "16.99887", "Europe/Sarajevo"),
("3193542", "Pećigrad", "", "BA", "70", "", "01", "", "", "45.05444", "15.89694", "Europe/Sarajevo"),
("3193692", "Pale", "", "BA", "70", "", "02", "", "", "43.81664", "18.56949", "Europe/Sarajevo"),
("3193776", "Otoka", "", "BA", "70", "", "01", "", "", "44.96", "16.17917", "Europe/Sarajevo"),
("3193821", "Ostrožac", "", "BA", "70", "", "01", "", "", "44.90866", "15.94045", "Europe/Sarajevo"),
("3194061", "Orahovica Donja", "", "BA", "70", "", "01", "", "", "44.65345", "18.36951", "Europe/Sarajevo"),
("3194120", "Omarska", "", "BA", "70", "", "02", "", "", "44.8917", "16.89814", "Europe/Sarajevo"),
("3194199", "Odžak", "", "BA", "70", "", "01", "", "", "45.02461", "18.32107", "Europe/Sarajevo"),
("3194510", "Nevesinje", "", "BA", "70", "", "02", "", "", "43.25861", "18.11333", "Europe/Sarajevo"),
("3194724", "Mrkonjić Grad", "", "BA", "70", "", "02", "", "", "44.41729", "17.08288", "Europe/Sarajevo"),
("3194828", "Mostar", "Мостар", "BA", "70", "", "01", "3343740", "", "43.34333", "17.80806", "Europe/Sarajevo"),
("3195066", "Mionica", "", "BA", "70", "", "01", "", "", "44.86646", "18.46603", "Europe/Sarajevo"),
("3195128", "Milići", "", "BA", "70", "", "02", "", "", "44.17016", "19.09195", "Europe/Sarajevo"),
("3195839", "Mala Kladuša", "", "BA", "70", "", "01", "", "", "45.13443", "15.85217", "Europe/Sarajevo"),
("3195930", "Mahala", "", "BA", "70", "", "01", "", "", "44.01194", "18.25528", "Europe/Sarajevo"),
("3195946", "Maglaj", "", "BA", "70", "", "01", "", "", "44.54771", "18.10003", "Europe/Sarajevo"),
("3196324", "Ljubuški", "", "BA", "70", "", "01", "", "", "43.19694", "17.545", "Europe/Sarajevo"),
("3196410", "Livno", "", "BA", "70", "", "01", "", "", "43.82695", "17.00746", "Europe/Sarajevo"),
("3196428", "Široki Brijeg", "", "BA", "70", "", "01", "", "", "43.3829", "17.59416", "Europe/Sarajevo"),
("3196792", "Laktaši", "", "BA", "70", "", "02", "", "", "44.90857", "17.30135", "Europe/Sarajevo"),
("3197532", "Kotor Varoš", "", "BA", "70", "", "02", "", "", "44.61831", "17.37204", "Europe/Sarajevo"),
("3198050", "Ključ", "", "BA", "70", "", "01", "", "", "44.53251", "16.77682", "Europe/Sarajevo"),
("3198126", "Kladanj", "", "BA", "70", "", "01", "", "", "44.22669", "18.69274", "Europe/Sarajevo"),
("3198138", "Kiseljak", "", "BA", "70", "", "01", "", "", "43.94295", "18.08132", "Europe/Sarajevo"),
("3198462", "Kalenderovci Donji", "", "BA", "70", "", "02", "", "", "44.94673", "17.83785", "Europe/Sarajevo"),
("3198490", "Kakanj", "", "BA", "70", "", "01", "", "", "44.13311", "18.12292", "Europe/Sarajevo"),
("3198895", "Janja", "", "BA", "70", "", "02", "", "", "44.66554", "19.24691", "Europe/Sarajevo"),
("3198934", "Jajce", "", "BA", "70", "", "01", "", "", "44.34203", "17.27059", "Europe/Sarajevo"),
("3199142", "Ilijaš", "", "BA", "70", "", "01", "", "", "43.95128", "18.27128", "Europe/Sarajevo"),
("3199438", "Hadžići", "", "BA", "70", "", "01", "", "", "43.82222", "18.20667", "Europe/Sarajevo"),
("3199525", "Gromiljak", "", "BA", "70", "", "01", "", "", "43.96668", "18.05504", "Europe/Sarajevo"),
("3199744", "Gradačac", "", "BA", "70", "", "01", "", "", "44.87851", "18.42764", "Europe/Sarajevo"),
("3199779", "Gračanica", "", "BA", "70", "", "01", "", "", "44.70307", "18.3101", "Europe/Sarajevo"),
("3199862", "Gostovići", "", "BA", "70", "", "01", "", "", "44.41124", "18.17029", "Europe/Sarajevo"),
("3199904", "Gornji Vakuf", "", "BA", "70", "", "01", "", "", "43.93806", "17.58833", "Europe/Sarajevo"),
("3200396", "Goražde", "Горажде", "BA", "70", "", "01", "", "", "43.66795", "18.97564", "Europe/Sarajevo"),
("3200829", "Fojnica", "", "BA", "70", "", "01", "", "", "43.95952", "17.90288", "Europe/Sarajevo"),
("3200837", "Foča", "", "BA", "70", "", "02", "", "", "43.50646", "18.77854", "Europe/Sarajevo"),
("3200930", "Tomislavgrad", "", "BA", "70", "", "01", "", "", "43.71849", "17.22515", "Europe/Sarajevo"),
("3201376", "Donji Vakuf", "", "BA", "70", "", "01", "", "", "44.14361", "17.4", "Europe/Sarajevo"),
("3201662", "Donja Mahala", "", "BA", "70", "", "01", "", "", "45.04327", "18.66996", "Europe/Sarajevo"),
("3201984", "Doboj", "Добой", "BA", "70", "", "02", "", "", "44.73179", "18.08698", "Europe/Sarajevo"),
("3202014", "Divičani", "", "BA", "70", "", "01", "", "", "44.36682", "17.32678", "Europe/Sarajevo"),
("3202081", "Derventa", "", "BA", "70", "", "02", "", "", "44.97839", "17.90779", "Europe/Sarajevo"),
("3202564", "Čitluk", "", "BA", "70", "", "01", "", "", "43.22861", "17.70083", "Europe/Sarajevo"),
("3202822", "Cazin", "", "BA", "70", "", "01", "", "", "44.96694", "15.94306", "Europe/Sarajevo"),
("3202873", "Čapljina", "", "BA", "70", "", "01", "", "", "43.12139", "17.68444", "Europe/Sarajevo"),
("3202935", "Bužim", "", "BA", "70", "", "01", "", "", "45.05361", "16.03254", "Europe/Sarajevo"),
("3203099", "Bugojno", "Бугойно", "BA", "70", "", "01", "", "", "44.05722", "17.45083", "Europe/Sarajevo"),
("3203521", "Brčko", "Брчко", "BA", "70", "", "BRC", "", "", "44.86995", "18.81012", "Europe/Sarajevo"),
("3203644", "Bosansko Grahovo", "", "BA", "70", "", "01", "", "", "44.17944", "16.36389", "Europe/Sarajevo"),
("3203647", "Novi Grad", "", "BA", "70", "", "02", "", "", "45.04643", "16.37782", "Europe/Sarajevo"),
("3203651", "Brod", "", "BA", "70", "", "02", "", "", "45.13747", "17.98722", "Europe/Sarajevo"),
("3203653", "Bosanska Krupa", "Босанска Крупа", "BA", "70", "", "01", "", "", "44.8825", "16.15139", "Europe/Sarajevo"),
("3203656", "Gradiška", "", "BA", "70", "", "02", "", "", "45.14484", "17.25453", "Europe/Sarajevo"),
("3203657", "Kozarska Dubica", "", "BA", "70", "", "02", "", "", "45.17667", "16.80944", "Europe/Sarajevo"),
("3203950", "Blatnica", "", "BA", "70", "", "02", "", "", "44.48677", "17.82278", "Europe/Sarajevo"),
("3204161", "Bileća", "", "BA", "70", "", "02", "3294539", "", "42.87645", "18.42967", "Europe/Sarajevo"),
("3204186", "Bijeljina", "Биелине", "BA", "70", "", "02", "", "", "44.75874", "19.21437", "Europe/Sarajevo"),
("3204222", "Bihać", "Бихач", "BA", "70", "", "01", "", "", "44.81694", "15.87083", "Europe/Sarajevo"),
("3204520", "Banovići", "", "BA", "70", "", "00", "", "", "44.40596", "18.52648", "Europe/Sarajevo"),
("3204541", "Banja Luka", "Баня-Лука", "BA", "70", "", "02", "", "", "44.77842", "17.19386", "Europe/Sarajevo"),
("3210439", "Jelah", "", "BA", "70", "", "01", "", "", "44.654", "17.95897", "Europe/Sarajevo"),
("3247554", "Čelinac", "", "BA", "70", "", "02", "", "", "44.72453", "17.32431", "Europe/Sarajevo"),
("3253010", "Tešanjka", "", "BA", "70", "", "01", "", "", "44.67228", "18.01109", "Europe/Sarajevo"),
("3257948", "Kovači", "", "BA", "70", "", "01", "", "", "44.44874", "18.20521", "Europe/Sarajevo"),
("3259075", "Ćoralići", "", "BA", "70", "", "01", "", "", "45.00694", "15.87194", "Europe/Sarajevo"),
("3262021", "Crnići", "", "BA", "70", "", "01", "", "", "43.13156", "17.86452", "Europe/Sarajevo"),
("3289093", "Kačuni", "", "BA", "70", "", "01", "", "", "44.06433", "17.93894", "Europe/Sarajevo"),
("3301568", "Todorovo", "", "BA", "70", "", "01", "", "", "45.08833", "15.93083", "Europe/Sarajevo"),
("3337476", "Konjic", "", "BA", "70", "", "01", "", "", "43.65126", "17.96082", "Europe/Sarajevo"),
("3344411", "Jablanica", "", "BA", "70", "", "01", "", "", "43.66028", "17.76167", "Europe/Sarajevo"),
("8335444", "Mejdan - Obilićevo", "", "BA", "70", "", "02", "", "", "44.76324", "17.19012", "Europe/Sarajevo"),
("3373430", "Welchman Hall", "", "BB", "52", "", "11", "", "", "13.18676", "-59.57663", "America/Barbados"),
("3373477", "Crane", "", "BB", "52", "", "10", "", "", "13.10487", "-59.44861", "America/Barbados"),
("3373505", "Speightstown", "", "BB", "52", "", "09", "", "", "13.25072", "-59.64396", "America/Barbados"),
("3373652", "Oistins", "", "BB", "52", "", "01", "", "", "13.07067", "-59.54637", "America/Barbados"),
("3373790", "Holetown", "", "BB", "52", "", "04", "", "", "13.18672", "-59.63808", "America/Barbados"),
("3373831", "Greenland", "", "BB", "52", "", "02", "", "", "13.25808", "-59.57763", "America/Barbados"),
("3373877", "Four Cross Roads", "", "BB", "52", "", "05", "", "", "13.17018", "-59.52186", "America/Barbados"),
("3373993", "Checker Hall", "", "BB", "52", "", "07", "", "", "13.28445", "-59.64223", "America/Barbados"),
("3374036", "Bridgetown", "Бриджтаун", "BB", "52", "", "08", "", "", "13.10732", "-59.62021", "America/Barbados"),
("3374083", "Bathsheba", "", "BB", "52", "", "06", "", "", "13.21133", "-59.52596", "America/Barbados"),
("1185092", "Thākurgaon", "", "BD", "50", "", "87", "5594", "559494", "26.03097", "88.46989", "Asia/Dhaka"),
("1185095", "Teknāf", "", "BD", "50", "", "84", "2022", "202290", "20.85829", "92.29773", "Asia/Dhaka"),
("1185098", "Tungi", "", "BD", "50", "", "81", "3033", "303330", "23.89154", "90.40232", "Asia/Dhaka"),
("1185099", "Sylhet", "Силхет", "BD", "50", "", "86", "6091", "609162", "24.89904", "91.87198", "Asia/Dhaka"),
("1185100", "Dohār", "", "BD", "50", "", "81", "3026", "302618", "23.59311", "90.14251", "Asia/Dhaka"),
("1185106", "Jamālpur", "", "BD", "50", "", "H", "3039", "303936", "24.91965", "89.94812", "Asia/Dhaka"),
("1185108", "Shibganj", "", "BD", "50", "", "83", "5070", "507088", "24.68501", "88.15638", "Asia/Dhaka"),
("1185111", "Sātkhira", "", "BD", "50", "", "82", "4087", "408782", "22.70817", "89.07185", "Asia/Dhaka"),
("1185115", "Sirājganj", "Сираджгандж", "BD", "50", "", "83", "5088", "508878", "24.45771", "89.70802", "Asia/Dhaka"),
("1185116", "Netrakona", "", "BD", "50", "", "H", "3072", "307274", "24.88352", "90.72898", "Asia/Dhaka"),
("1185117", "Narsingdi", "", "BD", "50", "", "81", "3068", "306860", "23.92298", "90.71768", "Asia/Dhaka"),
("1185120", "Sandwīp", "Сандвип", "BD", "50", "", "84", "2015", "201578", "22.51409", "91.45491", "Asia/Dhaka"),
("1185121", "Shāhzādpur", "", "BD", "50", "", "83", "5088", "508867", "24.17687", "89.5988", "Asia/Dhaka"),
("1185127", "Rāmganj", "", "BD", "50", "", "84", "2051", "205165", "23.1006", "90.84989", "Asia/Dhaka"),
("1185128", "Rājshāhi", "Раджшахи", "BD", "50", "", "83", "5081", "508122", "24.374", "88.60114", "Asia/Dhaka"),
("1185138", "Pirojpur", "", "BD", "50", "", "85", "1079", "107980", "22.57965", "89.97521", "Asia/Dhaka"),
("1185141", "Panchagarh", "", "BD", "50", "", "87", "5577", "557773", "26.33338", "88.55777", "Asia/Dhaka"),
("1185148", "Patiya", "", "BD", "50", "", "84", "2015", "201561", "22.29543", "91.979", "Asia/Dhaka"),
("1185149", "Parbatipur", "", "BD", "50", "", "87", "5527", "552777", "25.66369", "88.93093", "Asia/Dhaka"),
("1185155", "Nārāyanganj", "", "BD", "50", "", "81", "3067", "306758", "23.61352", "90.50298", "Asia/Dhaka"),
("1185156", "Nālchiti", "", "BD", "50", "", "85", "1042", "104273", "22.63696", "90.27195", "Asia/Dhaka"),
("1185159", "Nāgarpur", "", "BD", "50", "BD", "81", "3093", "309376", "24.05783", "89.87696", "Asia/Dhaka"),
("1185160", "Nageswari", "", "BD", "50", "", "87", "5549", "554961", "25.96817", "89.69153", "Asia/Dhaka"),
("1185162", "Mymensingh", "Майменсингх", "BD", "50", "", "H", "3061", "306152", "24.75636", "90.40646", "Asia/Dhaka"),
("1185164", "Muktāgācha", "", "BD", "50", "", "H", "3061", "306165", "24.76484", "90.25698", "Asia/Dhaka"),
("1185165", "Mirzāpur", "Мирзапур", "BD", "50", "", "81", "3093", "309366", "24.10287", "90.09841", "Asia/Dhaka"),
("1185166", "Maulavi Bāzār", "", "BD", "50", "", "86", "6058", "605874", "24.48888", "91.77075", "Asia/Dhaka"),
("1185167", "Morrelgonj", "", "BD", "50", "", "82", "4001", "400160", "22.45566", "89.85584", "Asia/Dhaka"),
("1185171", "Mehendiganj", "", "BD", "50", "", "85", "1006", "100662", "22.82257", "90.52859", "Asia/Dhaka"),
("1185173", "Mathba", "", "BD", "50", "", "85", "1079", "107958", "22.28616", "89.95883", "Asia/Dhaka"),
("1185181", "Lalmanirhat", "", "BD", "50", "", "87", "5552", "555255", "25.91719", "89.44595", "Asia/Dhaka"),
("1185183", "Lākshām", "", "BD", "50", "", "84", "2019", "201972", "23.24018", "91.12143", "Asia/Dhaka"),
("1185186", "Comilla", "Комилле", "BD", "50", "", "84", "2019", "201967", "23.46186", "91.18503", "Asia/Dhaka"),
("1185188", "Rangpur", "Рангпур", "BD", "50", "", "87", "5585", "558549", "25.74664", "89.25166", "Asia/Dhaka"),
("1185191", "Kushtia", "", "BD", "50", "", "82", "4050", "405079", "23.9028", "89.11943", "Asia/Dhaka"),
("1185199", "Kālīganj", "", "BD", "50", "", "82", "4044", "404433", "23.40964", "89.13801", "Asia/Dhaka"),
("1185204", "Jhingergācha", "", "BD", "50", "", "82", "4041", "404123", "23.11134", "89.09061", "Asia/Dhaka"),
("1185206", "Joypur Hāt", "", "BD", "50", "", "83", "5038", "503847", "25.10147", "89.02734", "Asia/Dhaka"),
("1185207", "Ishurdi", "", "BD", "50", "", "83", "5076", "507639", "24.12858", "89.06573", "Asia/Dhaka"),
("1185209", "Habiganj", "", "BD", "50", "", "86", "6036", "603644", "24.38044", "91.41299", "Asia/Dhaka"),
("1185210", "Gaurnadi", "", "BD", "50", "", "85", "1006", "100632", "22.97372", "90.22376", "Asia/Dhaka"),
("1185218", "Gafargaon", "", "BD", "50", "", "H", "3061", "306122", "24.432", "90.5585", "Asia/Dhaka"),
("1185224", "Feni", "", "BD", "50", "", "84", "2030", "203029", "23.0144", "91.3966", "Asia/Dhaka"),
("1185236", "Rāipur", "Райпур", "BD", "50", "", "84", "2051", "205158", "23.0391", "90.76808", "Asia/Dhaka"),
("1185239", "Sarankhola", "", "BD", "50", "", "82", "4001", "400177", "22.31006", "89.79113", "Asia/Dhaka"),
("1185241", "Dhaka", "Дакка", "BD", "50", "", "81", "3026", "302640", "23.7104", "90.40744", "Asia/Dhaka"),
("1185247", "Chilmāri", "", "BD", "50", "", "87", "5549", "554909", "25.55613", "89.67097", "Asia/Dhaka"),
("1185249", "Chhāgalnāiya", "", "BD", "50", "", "84", "2030", "203014", "23.02475", "91.51091", "Asia/Dhaka"),
("1185251", "Lālmohan", "", "BD", "50", "", "85", "1009", "100954", "22.33774", "90.73708", "Asia/Dhaka"),
("1185252", "Khagrachhari", "Кхаграчари", "BD", "50", "", "84", "2046", "204649", "23.10787", "91.97007", "Asia/Dhaka"),
("1185254", "Chhātak", "", "BD", "50", "", "86", "6090", "609023", "25.03852", "91.66958", "Asia/Dhaka"),
("1185260", "Bhātpāra Abhaynagar", "", "BD", "50", "", "82", "4041", "404104", "23.01472", "89.43936", "Asia/Dhaka"),
("1185262", "Bherāmāra", "", "BD", "50", "", "82", "4050", "405015", "24.02452", "88.99234", "Asia/Dhaka"),
("1185263", "Bhairab Bāzār", "", "BD", "50", "", "81", "3048", "304811", "24.0524", "90.9764", "Asia/Dhaka"),
("1185270", "Bāndarban", "Бандарбан", "BD", "50", "", "84", "2003", "200314", "22.19534", "92.21946", "Asia/Dhaka"),
("1185272", "Kālia", "Калия", "BD", "50", "", "82", "4065", "406528", "23.043", "89.63094", "Asia/Dhaka"),
("1185274", "Baniachang", "", "BD", "50", "", "86", "6036", "603611", "24.51863", "91.35787", "Asia/Dhaka"),
("1185276", "Bājitpur", "", "BD", "50", "", "81", "3048", "304806", "24.21623", "90.95002", "Asia/Dhaka"),
("1185283", "Badarganj", "", "BD", "50", "", "87", "5585", "558503", "25.67419", "89.05377", "Asia/Dhaka"),
("1185293", "Narail", "", "BD", "50", "", "82", "4065", "406576", "23.15509", "89.49515", "Asia/Dhaka"),
("1185920", "Tungipāra", "", "BD", "50", "", "81", "3035", "303591", "22.89983", "89.90326", "Asia/Dhaka"),
("1188569", "Sarishābāri", "", "BD", "50", "", "H", "3039", "303985", "24.75127", "89.83126", "Asia/Dhaka"),
("1189056", "Sakhipur", "", "BD", "50", "", "81", "3093", "309385", "24.31988", "90.16943", "Asia/Dhaka"),
("1189638", "Raojān", "", "BD", "50", "", "84", "2015", "201574", "22.53511", "91.91919", "Asia/Dhaka"),
("1191139", "Phultala", "", "BD", "50", "", "82", "4047", "404712", "22.71673", "89.51194", "Asia/Dhaka"),
("1191368", "Pālang", "", "BD", "50", "", "81", "3086", "308669", "23.21824", "90.35076", "Asia/Dhaka"),
("1192366", "Pār Naogaon", "", "BD", "50", "", "83", "5064", "506460", "24.80418", "88.94875", "Asia/Dhaka"),
("1193823", "Nabīnagar", "", "BD", "50", "", "84", "2012", "201285", "23.88791", "90.96792", "Asia/Dhaka"),
("1196292", "Lakshmīpur", "", "BD", "50", "", "84", "2051", "205143", "22.9443", "90.83005", "Asia/Dhaka"),
("1197895", "Kesabpur", "", "BD", "50", "", "82", "4041", "404138", "22.90725", "89.21954", "Asia/Dhaka"),
("1201753", "Hājīganj", "", "BD", "50", "", "84", "2013", "201349", "23.25191", "90.85508", "Asia/Dhaka"),
("1203344", "Farīdpur", "", "BD", "50", "", "81", "3029", "302947", "23.60612", "89.84064", "Asia/Dhaka"),
("1203891", "Dinājpur", "", "BD", "50", "", "87", "5527", "552764", "25.62745", "88.63779", "Asia/Dhaka"),
("1205481", "Uttar Char Fasson", "", "BD", "50", "", "82", "", "", "22.22647", "90.71275", "Asia/Dhaka"),
("1205733", "Chittagong", "Читтагонг", "BD", "50", "", "84", "2015", "201541", "22.3384", "91.83168", "Asia/Dhaka"),
("1207047", "Char Bhadrāsan", "", "BD", "50", "", "81", "3054", "305487", "23.30916", "90.22698", "Asia/Dhaka"),
("1209562", "Bera", "Беру", "BD", "50", "", "83", "5076", "507616", "24.07821", "89.63262", "Asia/Dhaka"),
("1210565", "Burhānuddin", "", "BD", "50", "", "85", "1009", "100921", "22.49518", "90.72391", "Asia/Dhaka"),
("1336133", "Sātkania", "", "BD", "50", "", "84", "2015", "201582", "22.07639", "92.04955", "Asia/Dhaka"),
("1336134", "Cox’s Bāzār", "Кокс-Базар", "BD", "50", "", "84", "2022", "202224", "21.43973", "92.00955", "Asia/Dhaka"),
("1336135", "Khulna", "Кхулна", "BD", "50", "", "82", "4047", "404751", "22.80979", "89.56439", "Asia/Dhaka"),
("1336136", "Bhola", "Бхола", "BD", "50", "", "85", "1009", "100918", "22.68759", "90.64403", "Asia/Dhaka"),
("1336137", "Barisāl", "Барисал", "BD", "50", "", "85", "1006", "100651", "22.70497", "90.37013", "Asia/Dhaka"),
("1336140", "Jessore", "", "BD", "50", "", "82", "4041", "404147", "23.16971", "89.21371", "Asia/Dhaka"),
("1336143", "Pābna", "Пабне", "BD", "50", "", "83", "5076", "507655", "24.00644", "89.2372", "Asia/Dhaka"),
("1336144", "Tāngāil", "", "BD", "50", "", "81", "3093", "309395", "24.24984", "89.91655", "Asia/Dhaka"),
("1337233", "Bogra", "Богра", "BD", "50", "", "83", "5010", "501020", "24.85098", "89.37108", "Asia/Dhaka"),
("1337239", "Pīrgaaj", "", "BD", "50", "", "87", "5594", "559482", "25.85587", "88.35943", "Asia/Dhaka"),
("1337240", "Nawābganj", "", "BD", "50", "", "83", "5070", "507066", "24.59025", "88.27444", "Asia/Dhaka"),
("1337245", "Mādārīpur", "", "BD", "50", "", "81", "3054", "305454", "23.17097", "90.20935", "Asia/Dhaka"),
("1337248", "Sherpur", "", "BD", "50", "", "H", "3089", "308988", "25.01881", "90.01751", "Asia/Dhaka"),
("1337249", "Kishorganj", "", "BD", "50", "", "81", "3048", "304849", "24.43944", "90.78291", "Asia/Dhaka"),
("1462681", "Manikchari", "", "BD", "50", "", "84", "2046", "204667", "22.83957", "91.84128", "Asia/Dhaka"),
("1477498", "Bhāndāria", "", "BD", "50", "", "85", "1079", "107914", "22.48898", "90.06273", "Asia/Dhaka"),
("6414184", "Fatikchari", "", "BD", "50", "", "84", "2015", "201533", "22.68768", "91.78123", "Asia/Dhaka"),
("6545349", "Saidpur", "", "BD", "50", "", "83", "", "", "25.77769", "88.89169", "Asia/Dhaka"),
("7701354", "Azimpur", "", "BD", "50", "", "81", "3026", "302640", "23.7298", "90.3854", "Asia/Dhaka"),
("9827976", "Paltan", "", "BD", "50", "", "81", "3026", "302640", "23.73625", "90.41426", "Asia/Dhaka"),
("2783081", "Zwijndrecht", "", "BE", "56", "", "VLG", "VAN", "11", "51.21979", "4.32664", "Europe/Brussels"),
("2783089", "Zwevegem", "", "BE", "56", "", "VLG", "VWV", "34", "50.81268", "3.33848", "Europe/Brussels"),
("2783143", "Zutendaal", "", "BE", "56", "", "VLG", "VLI", "71", "50.93306", "5.5753", "Europe/Brussels"),
("2783151", "Zulte", "", "BE", "56", "", "VLG", "VOV", "44", "50.91954", "3.44859", "Europe/Brussels"),
("2783170", "Zoutleeuw", "", "BE", "56", "", "VLG", "VBR", "24", "50.83316", "5.10376", "Europe/Brussels"),
("2783175", "Zottegem", "Зоттегем", "BE", "56", "", "VLG", "VOV", "41", "50.86955", "3.81052", "Europe/Brussels"),
("2783184", "Zonnebeke", "", "BE", "56", "", "VLG", "VWV", "33", "50.8726", "2.98725", "Europe/Brussels"),
("2783188", "Zonhoven", "", "BE", "56", "", "VLG", "VLI", "71", "50.99064", "5.36819", "Europe/Brussels"),
("2783195", "Zomergem", "", "BE", "56", "", "VLG", "VOV", "44", "51.11994", "3.56496", "Europe/Brussels"),
("2783204", "Zoersel", "", "BE", "56", "", "VLG", "VAN", "11", "51.26825", "4.71296", "Europe/Brussels"),
("2783215", "Zingem", "", "BE", "56", "", "VLG", "VOV", "45", "50.90409", "3.65305", "Europe/Brussels"),
("2783274", "Zemst", "Земст", "BE", "56", "", "VLG", "VBR", "23", "50.98318", "4.46079", "Europe/Brussels"),
("2783278", "Zelzate", "", "BE", "56", "", "VLG", "VOV", "43", "51.18963", "3.80777", "Europe/Brussels"),
("2783293", "Zele", "Зеле", "BE", "56", "", "VLG", "VOV", "42", "51.06566", "4.0403", "Europe/Brussels"),
("2783308", "Zedelgem", "Зедельгем", "BE", "56", "", "VLG", "VWV", "31", "51.14236", "3.1368", "Europe/Brussels"),
("2783310", "Zaventem", "", "BE", "56", "", "VLG", "VBR", "23", "50.88365", "4.47298", "Europe/Brussels"),
("2783347", "Zandhoven", "", "BE", "56", "", "VLG", "VAN", "11", "51.21488", "4.66164", "Europe/Brussels"),
("2783385", "Yvoir", "", "BE", "56", "", "WAL", "WNA", "91", "50.3279", "4.88059", "Europe/Brussels"),
("2783416", "Wuustwezel", "", "BE", "56", "", "VLG", "VAN", "11", "51.39214", "4.59546", "Europe/Brussels"),
("2783462", "Wommelgem", "", "BE", "56", "", "VLG", "VAN", "11", "51.20452", "4.5225", "Europe/Brussels"),
("2783586", "Wingene", "", "BE", "56", "", "VLG", "VWV", "37", "51.05782", "3.27359", "Europe/Brussels"),
("2783632", "Willebroek", "Виллебрук", "BE", "56", "", "VLG", "VAN", "12", "51.06041", "4.36019", "Europe/Brussels"),
("2783684", "Wijnegem", "", "BE", "56", "", "VLG", "VAN", "11", "51.22787", "4.51895", "Europe/Brussels"),
("2783717", "Wielsbeke", "", "BE", "56", "", "VLG", "VWV", "37", "50.9", "3.36667", "Europe/Brussels"),
("2783728", "Wichelen", "", "BE", "56", "", "VLG", "VOV", "42", "51.00526", "3.97683", "Europe/Brussels"),
("2783737", "Wezembeek-Oppem", "", "BE", "56", "", "VLG", "VBR", "23", "50.8395", "4.49427", "Europe/Brussels"),
("2783759", "Wevelgem", "Вевельгеме", "BE", "56", "", "VLG", "VWV", "34", "50.8", "3.16667", "Europe/Brussels"),
("2783763", "Wetteren", "Веттерен", "BE", "56", "", "VLG", "VOV", "42", "51.00526", "3.88341", "Europe/Brussels"),
("2783801", "Westerlo", "Вестерло", "BE", "56", "", "VLG", "VAN", "13", "51.09049", "4.91544", "Europe/Brussels"),
("2783820", "Wervik", "", "BE", "56", "", "VLG", "VWV", "33", "50.78069", "3.03854", "Europe/Brussels"),
("2783856", "Wemmel", "", "BE", "56", "", "VLG", "VBR", "23", "50.90812", "4.30613", "Europe/Brussels"),
("2783864", "Wellen", "", "BE", "56", "", "VLG", "VLI", "73", "50.84096", "5.33867", "Europe/Brussels"),
("2783870", "Welkenraedt", "", "BE", "56", "", "WAL", "WLG", "63", "50.6605", "5.97034", "Europe/Brussels"),
("2783941", "Wavre", "Вавр", "BE", "56", "", "WAL", "WBR", "25", "50.71717", "4.60138", "Europe/Brussels"),
("2783985", "Waterloo", "Ватерлоо", "BE", "56", "", "WAL", "WBR", "25", "50.71469", "4.3991", "Europe/Brussels"),
("2784066", "Waremme", "", "BE", "56", "", "WAL", "WLG", "64", "50.6976", "5.25524", "Europe/Brussels"),
("2784068", "Waregem", "Варегем", "BE", "56", "", "VLG", "VWV", "34", "50.88898", "3.42756", "Europe/Brussels"),
("2784092", "Wanze", "", "BE", "56", "", "WAL", "WLG", "61", "50.53907", "5.20846", "Europe/Brussels"),
("2784168", "Walhain-Saint-Paul", "", "BE", "56", "", "WAL", "WBR", "25", "50.62627", "4.69837", "Europe/Brussels"),
("2784189", "Walcourt", "Валькур", "BE", "56", "", "WAL", "WNA", "93", "50.25401", "4.43796", "Europe/Brussels"),
("2784199", "Waimes", "", "BE", "56", "", "WAL", "WLG", "63", "50.41488", "6.11207", "Europe/Brussels"),
("2784227", "Wachtebeke", "", "BE", "56", "", "VLG", "VOV", "44", "51.16852", "3.87183", "Europe/Brussels"),
("2784231", "Waasmunster", "", "BE", "56", "", "VLG", "VOV", "42", "51.10572", "4.08573", "Europe/Brussels"),
("2784237", "Waarschoot", "", "BE", "56", "", "VLG", "VOV", "44", "51.1525", "3.605", "Europe/Brussels"),
("2784349", "Vosselaar", "", "BE", "56", "", "VLG", "VAN", "13", "51.30856", "4.8896", "Europe/Brussels"),
("2784370", "Vorselaar", "", "BE", "56", "", "VLG", "VAN", "13", "51.20243", "4.77259", "Europe/Brussels"),
("2784548", "Visé", "", "BE", "56", "", "WAL", "WLG", "62", "50.7376", "5.69907", "Europe/Brussels"),
("2784555", "Virton", "", "BE", "56", "", "WAL", "WLX", "85", "49.56824", "5.53259", "Europe/Brussels"),
("2784604", "Vilvoorde", "Вилворде", "BE", "56", "", "VLG", "VBR", "23", "50.92814", "4.42938", "Europe/Brussels"),
("2784639", "Villers-le-Bouillet", "", "BE", "56", "", "WAL", "WLG", "61", "50.57708", "5.25945", "Europe/Brussels"),
("2784641", "Villers-la-Ville", "", "BE", "56", "", "WAL", "WBR", "25", "50.56667", "4.51667", "Europe/Brussels"),
("2784775", "Vielsalm", "", "BE", "56", "", "WAL", "WLX", "82", "50.28407", "5.91502", "Europe/Brussels"),
("2784804", "Veurne", "", "BE", "56", "", "VLG", "VWV", "38", "51.07316", "2.66803", "Europe/Brussels"),
("2784821", "Verviers", "Вервье", "BE", "56", "", "WAL", "WLG", "63", "50.58907", "5.86241", "Europe/Brussels"),
("2785141", "Turnhout", "Турнхоут", "BE", "56", "", "VLG", "VAN", "13", "51.32254", "4.94471", "Europe/Brussels"),
("2785169", "Tubize", "Тюбиз", "BE", "56", "", "WAL", "WBR", "25", "50.69059", "4.2009", "Europe/Brussels"),
("2785208", "Trooz", "", "BE", "56", "", "WAL", "WLG", "62", "50.57026", "5.69521", "Europe/Brussels"),
("2785293", "Tremelo", "", "BE", "56", "", "VLG", "VBR", "24", "50.99231", "4.70807", "Europe/Brussels"),
("2785341", "Tournai", "Турне", "BE", "56", "", "WAL", "WHT", "57", "50.60715", "3.38932", "Europe/Brussels"),
("2785364", "Torhout", "Торхоут", "BE", "56", "", "VLG", "VWV", "31", "51.0656", "3.10085", "Europe/Brussels"),
("2785389", "Tongeren", "Тонгерен", "BE", "56", "", "VLG", "VLI", "73", "50.78054", "5.46484", "Europe/Brussels"),
("2785470", "Tienen", "Тинен", "BE", "56", "", "VLG", "VBR", "24", "50.80745", "4.9378", "Europe/Brussels"),
("2785476", "Tielt", "", "BE", "56", "", "VLG", "VWV", "37", "50.99931", "3.32707", "Europe/Brussels"),
("2785517", "Thuin", "", "BE", "56", "", "WAL", "WHT", "56", "50.33933", "4.28604", "Europe/Brussels"),
("2785593", "Theux", "", "BE", "56", "", "WAL", "WLG", "63", "50.53323", "5.81245", "Europe/Brussels"),
("2785612", "Tessenderlo", "", "BE", "56", "", "VLG", "VLI", "71", "51.06513", "5.08856", "Europe/Brussels"),
("2785622", "Tervuren", "Тервюрен", "BE", "56", "", "VLG", "VBR", "24", "50.82372", "4.51418", "Europe/Brussels"),
("2785654", "Ternat", "", "BE", "56", "", "VLG", "VBR", "23", "50.86654", "4.16682", "Europe/Brussels"),
("2785778", "Temse", "Темсе", "BE", "56", "", "VLG", "VOV", "46", "51.12794", "4.21372", "Europe/Brussels"),
("2786087", "Stekene", "", "BE", "56", "", "VLG", "VOV", "46", "51.2099", "4.03651", "Europe/Brussels"),
("2786124", "Steenokkerzeel", "", "BE", "56", "", "VLG", "VBR", "23", "50.91851", "4.50989", "Europe/Brussels"),
("2786185", "Stavelot", "", "BE", "56", "", "WAL", "WLG", "63", "50.395", "5.93124", "Europe/Brussels"),
("2786226", "Staden", "", "BE", "56", "", "VLG", "VWV", "36", "50.97456", "3.01469", "Europe/Brussels"),
("2786229", "Stabroek", "", "BE", "56", "", "VLG", "VAN", "11", "51.33189", "4.37127", "Europe/Brussels"),
("2786242", "Sprimont", "", "BE", "56", "", "WAL", "WLG", "62", "50.50922", "5.6595", "Europe/Brussels"),
("2786318", "Spa", "", "BE", "56", "", "WAL", "WLG", "63", "50.48375", "5.86674", "Europe/Brussels"),
("2786344", "Soumagne", "Сумань", "BE", "56", "", "WAL", "WLG", "62", "50.61385", "5.74679", "Europe/Brussels"),
("2786390", "Sombreffe", "", "BE", "56", "", "WAL", "WNA", "92", "50.52865", "4.60087", "Europe/Brussels"),
("2786420", "Soignies", "Суанье", "BE", "56", "", "WAL", "WHT", "55", "50.57904", "4.07129", "Europe/Brussels"),
("2786545", "Sint-Truiden", "Синт-Трюйден", "BE", "56", "", "VLG", "VLI", "71", "50.81679", "5.18647", "Europe/Brussels"),
("2786559", "Sint-Pieters-Leeuw", "", "BE", "56", "", "VLG", "VBR", "23", "50.77926", "4.24355", "Europe/Brussels"),
("2786578", "Sint-Niklaas", "Синт-Никлас", "BE", "56", "", "VLG", "VOV", "46", "51.16509", "4.1437", "Europe/Brussels"),
("2786587", "Sint-Martens-Lennik", "", "BE", "56", "", "VLG", "VBR", "23", "50.81158", "4.16965", "Europe/Brussels"),
("2786591", "Sint-Martens-Latem", "", "BE", "56", "", "VLG", "VOV", "44", "51.01459", "3.63779", "Europe/Brussels"),
("2786603", "Sint-Maria-Lierde", "", "BE", "56", "", "VLG", "VOV", "45", "50.82172", "3.84814", "Europe/Brussels"),
("2786616", "Sint-Lievens-Houtem", "", "BE", "56", "", "VLG", "VOV", "41", "50.9197", "3.86225", "Europe/Brussels"),
("2786626", "Sint-Laureins", "", "BE", "56", "", "VLG", "VOV", "43", "51.24202", "3.52441", "Europe/Brussels"),
("2786634", "Sint-Kruis", "", "BE", "56", "", "VLG", "VWV", "31", "51.21399", "3.24949", "Europe/Brussels"),
("2786641", "Sint-Katelijne-Waver", "", "BE", "56", "", "VLG", "VAN", "12", "51.06691", "4.53469", "Europe/Brussels"),
("2786694", "Sint-Gillis-Waas", "", "BE", "56", "", "VLG", "VOV", "46", "51.21914", "4.12374", "Europe/Brussels"),
("2786700", "Sint-Genesius-Rode", "", "BE", "56", "", "VLG", "VBR", "23", "50.74645", "4.35754", "Europe/Brussels"),
("2786746", "Sint-Amands", "", "BE", "56", "", "VLG", "VAN", "12", "51.05645", "4.20957", "Europe/Brussels"),
("2786769", "Silly", "", "BE", "56", "", "WAL", "WHT", "55", "50.64877", "3.92363", "Europe/Brussels"),
("2786824", "Seraing", "Серен", "BE", "56", "", "WAL", "WLG", "62", "50.58362", "5.50115", "Europe/Brussels"),
("2786852", "Seneffe", "", "BE", "56", "", "WAL", "WHT", "52", "50.53135", "4.26301", "Europe/Brussels"),
("2786963", "Schoten", "", "BE", "56", "", "VLG", "VAN", "11", "51.25251", "4.50268", "Europe/Brussels"),
("2787048", "Schilde", "Шильде", "BE", "56", "", "VLG", "VAN", "11", "51.24107", "4.58336", "Europe/Brussels"),
("2787080", "Schelle", "", "BE", "56", "", "VLG", "VAN", "11", "51.12615", "4.34114", "Europe/Brussels"),
("2787315", "Saint-Vith", "", "BE", "56", "", "WAL", "WLG", "63", "50.28146", "6.12724", "Europe/Brussels"),
("2787356", "Saint-Nicolas", "Санкт-Никола", "BE", "56", "", "WAL", "WLG", "62", "50.62837", "5.53243", "Europe/Brussels"),
("2787407", "Saint-Hubert", "", "BE", "56", "", "WAL", "WLX", "84", "50.02668", "5.37401", "Europe/Brussels"),
("2787416", "Saint-Ghislain", "Санкт-Гилене", "BE", "56", "", "WAL", "WHT", "53", "50.44816", "3.81886", "Europe/Brussels"),
("2787521", "Rumst", "", "BE", "56", "", "VLG", "VAN", "11", "51.08153", "4.42217", "Europe/Brussels"),
("2787547", "Ruiselede", "", "BE", "56", "", "VLG", "VWV", "37", "51.04039", "3.39416", "Europe/Brussels"),
("2787662", "Rotselaar", "", "BE", "56", "", "VLG", "VBR", "24", "50.95302", "4.71665", "Europe/Brussels"),
("2787769", "Ronse", "Ронсе", "BE", "56", "", "VLG", "VOV", "45", "50.74574", "3.6005", "Europe/Brussels"),
("2787878", "Roeulx", "", "BE", "56", "", "WAL", "WHT", "", "50.50365", "4.11163", "Europe/Brussels"),
("2787889", "Roeselare", "Руселаре", "BE", "56", "", "VLG", "VWV", "36", "50.94653", "3.12269", "Europe/Brussels"),
("2787948", "Rochefort", "", "BE", "56", "", "WAL", "WNA", "91", "50.1631", "5.2216", "Europe/Brussels"),
("2787989", "Rixensart", "Риксенсарт", "BE", "56", "", "WAL", "WBR", "25", "50.71229", "4.52529", "Europe/Brussels"),
("2788051", "Rijkevorsel", "", "BE", "56", "", "VLG", "VAN", "13", "51.34795", "4.76053", "Europe/Brussels"),
("2788088", "Riemst", "", "BE", "56", "", "VLG", "VLI", "73", "50.80995", "5.60131", "Europe/Brussels"),
("2788138", "Retie", "", "BE", "56", "", "VLG", "VAN", "13", "51.26652", "5.08242", "Europe/Brussels"),
("2788211", "Remicourt", "", "BE", "56", "", "WAL", "WLG", "64", "50.68069", "5.32785", "Europe/Brussels"),
("2788299", "Rebecq-Rognon", "", "BE", "56", "", "WAL", "WBR", "25", "50.65147", "4.10683", "Europe/Brussels"),
("2788312", "Ravels", "", "BE", "56", "", "VLG", "VAN", "13", "51.37274", "4.9921", "Europe/Brussels"),
("2788348", "Ranst", "", "BE", "56", "", "VLG", "VAN", "11", "51.18983", "4.56533", "Europe/Brussels"),
("2788381", "Ramillies", "", "BE", "56", "", "WAL", "WBR", "25", "50.63395", "4.90119", "Europe/Brussels"),
("2788410", "Raeren", "", "BE", "56", "", "WAL", "WLG", "63", "50.6672", "6.11535", "Europe/Brussels"),
("2788444", "Quiévrain", "", "BE", "56", "", "WAL", "WHT", "53", "50.40737", "3.68351", "Europe/Brussels"),
("2788446", "Quévy-le-Petit", "", "BE", "56", "", "WAL", "WHT", "53", "50.36879", "3.93602", "Europe/Brussels"),
("2788499", "Quaregnon", "", "BE", "56", "", "WAL", "WHT", "53", "50.44067", "3.8653", "Europe/Brussels"),
("2788506", "Puurs", "", "BE", "56", "", "VLG", "VAN", "12", "51.07409", "4.28844", "Europe/Brussels"),
("2788521", "Putte", "", "BE", "56", "", "VLG", "VAN", "12", "51.05337", "4.63263", "Europe/Brussels"),
("2788577", "Profondeville", "", "BE", "56", "", "WAL", "WNA", "92", "50.37581", "4.86506", "Europe/Brussels"),
("2788726", "Poperinge", "Поперинге", "BE", "56", "", "VLG", "VWV", "33", "50.85386", "2.72659", "Europe/Brussels"),
("2788765", "Pont-à-Celles", "", "BE", "56", "", "WAL", "WHT", "52", "50.50518", "4.36887", "Europe/Brussels"),
("2788849", "Plombières", "", "BE", "56", "", "WAL", "WLG", "63", "50.73656", "5.95922", "Europe/Brussels"),
("2788925", "Pittem", "", "BE", "56", "", "VLG", "VWV", "37", "50.99279", "3.26317", "Europe/Brussels"),
("2789016", "Philippeville", "", "BE", "56", "", "WAL", "WNA", "93", "50.19612", "4.54374", "Europe/Brussels"),
("2789156", "Perwez", "", "BE", "56", "", "WAL", "WBR", "25", "50.62426", "4.81354", "Europe/Brussels"),
("2789162", "Péruwelz", "Перювельз", "BE", "56", "", "WAL", "WHT", "57", "50.50819", "3.59373", "Europe/Brussels"),
("2789190", "Pepinster", "", "BE", "56", "", "WAL", "WLG", "63", "50.57375", "5.8049", "Europe/Brussels"),
("2789232", "Peer", "", "BE", "56", "", "VLG", "VLI", "72", "51.1303", "5.45952", "Europe/Brussels"),
("2789236", "Pecq", "", "BE", "56", "", "WAL", "WHT", "57", "50.68619", "3.33789", "Europe/Brussels"),
("2789354", "Paliseul", "", "BE", "56", "", "WAL", "WLX", "84", "49.90395", "5.13537", "Europe/Brussels"),
("2789403", "Overpelt", "", "BE", "56", "", "VLG", "VLI", "72", "51.21038", "5.41557", "Europe/Brussels"),
("2789413", "Overijse", "Оверийсе", "BE", "56", "", "VLG", "VBR", "23", "50.77436", "4.53461", "Europe/Brussels"),
("2789471", "Oupeye", "Упе", "BE", "56", "", "WAL", "WLG", "62", "50.71184", "5.6468", "Europe/Brussels"),
("2789483", "Oud-Turnhout", "", "BE", "56", "", "VLG", "VAN", "13", "51.31978", "4.9841", "Europe/Brussels"),
("2789492", "Oud-Heverlee", "", "BE", "56", "", "VLG", "VBR", "24", "50.83522", "4.66421", "Europe/Brussels"),
("2789519", "Oudenburg", "", "BE", "56", "", "VLG", "VWV", "35", "51.18489", "3.00035", "Europe/Brussels"),
("2789529", "Oudenaarde", "Оуденаарде", "BE", "56", "", "VLG", "VOV", "45", "50.85168", "3.60891", "Europe/Brussels"),
("2789570", "Ottignies", "", "BE", "56", "", "WAL", "WBR", "25", "50.66535", "4.56679", "Europe/Brussels"),
("2789654", "Opwijk", "", "BE", "56", "", "VLG", "VBR", "23", "50.96724", "4.18442", "Europe/Brussels"),
("2789714", "Opglabbeek", "", "BE", "56", "", "VLG", "VLI", "71", "51.04258", "5.58346", "Europe/Brussels"),
("2789737", "Oostrozebeke", "", "BE", "56", "", "VLG", "VWV", "37", "50.92093", "3.33799", "Europe/Brussels"),
("2789745", "Oostmalle", "", "BE", "56", "", "VLG", "VAN", "11", "51.3", "4.73333", "Europe/Brussels"),
("2789751", "Oostkamp", "Осткамп", "BE", "56", "", "VLG", "VWV", "31", "51.15432", "3.23128", "Europe/Brussels"),
("2789771", "Oosterzele", "", "BE", "56", "", "VLG", "VOV", "44", "50.95261", "3.79826", "Europe/Brussels"),
("2789786", "Ostend", "Остенде", "BE", "56", "", "VLG", "VWV", "35", "51.21551", "2.927", "Europe/Brussels"),
("2789886", "Olen", "", "BE", "56", "", "VLG", "VAN", "13", "51.14391", "4.8598", "Europe/Brussels"),
("2790101", "Nivelles", "Нивель", "BE", "56", "", "WAL", "WBR", "25", "50.59833", "4.32848", "Europe/Brussels"),
("2790114", "Ninove", "Нинове", "BE", "56", "", "VLG", "VOV", "41", "50.82776", "4.02657", "Europe/Brussels"),
("2790135", "Nijlen", "", "BE", "56", "", "VLG", "VAN", "12", "51.16096", "4.67008", "Europe/Brussels"),
("2790150", "Nieuwpoort", "", "BE", "56", "", "VLG", "VWV", "38", "51.13008", "2.75135", "Europe/Brussels"),
("2790179", "Nieuwerkerken", "", "BE", "56", "", "VLG", "VLI", "71", "50.8638", "5.19467", "Europe/Brussels"),
("2790225", "Niel", "", "BE", "56", "", "VLG", "VAN", "11", "51.11096", "4.33428", "Europe/Brussels"),
("2790235", "Nevele", "", "BE", "56", "", "VLG", "VOV", "44", "51.03531", "3.54574", "Europe/Brussels"),
("2790286", "Neufchâteau", "", "BE", "56", "", "WAL", "WLX", "84", "49.84074", "5.43535", "Europe/Brussels"),
("2790357", "Neerpelt", "", "BE", "56", "", "VLG", "VLI", "72", "51.22807", "5.4427", "Europe/Brussels"),
("2790433", "Nazareth", "", "BE", "56", "", "VLG", "VOV", "44", "50.95686", "3.59425", "Europe/Brussels"),
("2790451", "Nassogne", "", "BE", "56", "", "WAL", "WLX", "83", "50.12849", "5.34274", "Europe/Brussels"),
("2790467", "Nandrin", "", "BE", "56", "", "WAL", "WLG", "61", "50.50675", "5.41905", "Europe/Brussels"),
("2790471", "Namur", "Намюр", "BE", "56", "", "WAL", "WNA", "92", "50.4669", "4.86746", "Europe/Brussels"),
("2790595", "Mouscron", "Мускрон", "BE", "56", "", "WAL", "WHT", "54", "50.74497", "3.20639", "Europe/Brussels"),
("2790676", "Mortsel", "Мортсел", "BE", "56", "", "VLG", "VAN", "11", "51.16697", "4.45127", "Europe/Brussels"),
("2790697", "Morlanwelz-Mariemont", "", "BE", "56", "", "WAL", "WHT", "56", "50.45502", "4.24519", "Europe/Brussels"),
("2790729", "Moorslede", "", "BE", "56", "", "VLG", "VWV", "36", "50.8919", "3.06117", "Europe/Brussels"),
("2790756", "Mont-Saint-Guibert", "", "BE", "56", "", "WAL", "WBR", "25", "50.63427", "4.61061", "Europe/Brussels"),
("2790869", "Mons", "Монс", "BE", "56", "", "WAL", "WHT", "53", "50.45413", "3.95229", "Europe/Brussels"),
("2790906", "Momignies", "", "BE", "56", "", "WAL", "WHT", "56", "50.0271", "4.16519", "Europe/Brussels"),
("2791067", "Mol", "Мол", "BE", "56", "", "VLG", "VAN", "13", "51.19188", "5.11662", "Europe/Brussels"),
("2791120", "Moerbeke", "", "BE", "56", "", "VLG", "VOV", "44", "51.17409", "3.93001", "Europe/Brussels"),
("2791194", "Middelkerke", "", "BE", "56", "", "VLG", "VWV", "35", "51.18532", "2.82077", "Europe/Brussels"),
("2791255", "Meulebeke", "", "BE", "56", "", "VLG", "VWV", "37", "50.95136", "3.28804", "Europe/Brussels"),
("2791261", "Mettet", "", "BE", "56", "", "WAL", "WNA", "92", "50.32119", "4.66232", "Europe/Brussels"),
("2791272", "Messancy", "", "BE", "56", "", "WAL", "WLX", "81", "49.59201", "5.81879", "Europe/Brussels"),
("2791297", "Merksplas", "", "BE", "56", "", "VLG", "VAN", "13", "51.35851", "4.86513", "Europe/Brussels"),
("2791315", "Merelbeke", "Мерелбеке", "BE", "56", "", "VLG", "VOV", "44", "50.99447", "3.74621", "Europe/Brussels"),
("2791323", "Merchtem", "", "BE", "56", "", "VLG", "VBR", "23", "50.95129", "4.23197", "Europe/Brussels"),
("2791343", "Menen", "Менен", "BE", "56", "", "VLG", "VWV", "34", "50.79722", "3.12245", "Europe/Brussels"),
("2791385", "Melle", "", "BE", "56", "", "VLG", "VOV", "44", "51.00232", "3.80526", "Europe/Brussels"),
("2791424", "Meise", "", "BE", "56", "", "VLG", "VBR", "23", "50.93934", "4.32655", "Europe/Brussels"),
("2791494", "Meerhout", "", "BE", "56", "", "VLG", "VAN", "13", "51.1321", "5.07842", "Europe/Brussels"),
("2791537", "Mechelen", "Мехелен", "BE", "56", "", "VLG", "VAN", "12", "51.02574", "4.47762", "Europe/Brussels"),
("2791733", "Marchin", "", "BE", "56", "", "WAL", "WLG", "61", "50.46707", "5.2428", "Europe/Brussels"),
("2791744", "Marche-en-Famenne", "Марш-ан-Фамен", "BE", "56", "", "WAL", "WLX", "83", "50.22678", "5.34416", "Europe/Brussels"),
("2791814", "Manage", "", "BE", "56", "", "WAL", "WHT", "52", "50.50312", "4.23589", "Europe/Brussels"),
("2791834", "Malmédy", "", "BE", "56", "", "WAL", "WLG", "63", "50.42686", "6.02794", "Europe/Brussels"),
("2791857", "Maldegem", "Мальдегем", "BE", "56", "", "VLG", "VOV", "43", "51.20737", "3.44511", "Europe/Brussels"),
("2791951", "Machelen", "", "BE", "56", "", "VLG", "VBR", "23", "50.91061", "4.44174", "Europe/Brussels"),
("2791961", "Maasmechelen", "Маасмехелене", "BE", "56", "", "VLG", "VLI", "73", "50.96545", "5.69452", "Europe/Brussels"),
("2791964", "Maaseik", "Маасейк", "BE", "56", "", "VLG", "VLI", "72", "51.09802", "5.78379", "Europe/Brussels"),
("2792007", "Lummen", "", "BE", "56", "", "VLG", "VLI", "71", "50.98772", "5.19121", "Europe/Brussels"),
("2792034", "Lubbeek", "", "BE", "56", "", "VLG", "VBR", "24", "50.88278", "4.83896", "Europe/Brussels"),
("2792057", "Lovendegem", "", "BE", "56", "", "VLG", "VOV", "44", "51.10168", "3.61298", "Europe/Brussels"),
("2792073", "Louvain-la-Neuve", "Лувен-ла-Нев", "BE", "56", "", "WAL", "WBR", "25", "50.66829", "4.61443", "Europe/Brussels"),
("2792165", "Londerzeel", "", "BE", "56", "", "VLG", "VBR", "23", "51.00468", "4.30304", "Europe/Brussels"),
("2792179", "Lommel", "Ломмел", "BE", "56", "", "VLG", "VLI", "72", "51.23074", "5.31349", "Europe/Brussels"),
("2792196", "Lokeren", "Локерен", "BE", "56", "", "VLG", "VOV", "46", "51.10364", "3.99339", "Europe/Brussels"),
("2792235", "Lochristi", "", "BE", "56", "", "VLG", "VOV", "44", "51.09644", "3.83194", "Europe/Brussels"),
("2792245", "Lobbes", "", "BE", "56", "", "WAL", "WHT", "56", "50.35258", "4.26716", "Europe/Brussels"),
("2792292", "Lint", "", "BE", "56", "", "VLG", "VAN", "11", "51.12707", "4.49669", "Europe/Brussels"),
("2792348", "Limbourg", "", "BE", "56", "", "WAL", "WLG", "63", "50.61222", "5.9412", "Europe/Brussels"),
("2792360", "Lille", "", "BE", "56", "", "VLG", "VAN", "13", "51.24197", "4.82313", "Europe/Brussels"),
("2792397", "Lier", "Льер", "BE", "56", "", "VLG", "VAN", "12", "51.13128", "4.57041", "Europe/Brussels"),
("2792413", "Liège", "Льеж", "BE", "56", "", "WAL", "WLG", "62", "50.63373", "5.56749", "Europe/Brussels"),
("2792423", "Liedekerke", "", "BE", "56", "", "VLG", "VBR", "23", "50.86892", "4.08743", "Europe/Brussels"),
("2792428", "Lichtervelde", "", "BE", "56", "", "VLG", "VWV", "36", "51.03333", "3.15", "Europe/Brussels"),
("2792482", "Leuven", "Лёвен", "BE", "56", "", "VLG", "VBR", "24", "50.87959", "4.70093", "Europe/Brussels"),
("2792567", "Lessines", "Лессин", "BE", "56", "", "WAL", "WHT", "55", "50.71104", "3.83579", "Europe/Brussels"),
("2792856", "Leopoldsburg", "", "BE", "56", "", "VLG", "VLI", "71", "51.11667", "5.25", "Europe/Brussels"),
("2792879", "Lendelede", "", "BE", "56", "", "VLG", "VWV", "34", "50.88626", "3.23747", "Europe/Brussels"),
("2793067", "Ledegem", "", "BE", "56", "", "VLG", "VWV", "36", "50.85785", "3.12409", "Europe/Brussels"),
("2793070", "Ledeberg", "", "BE", "56", "", "VLG", "VOV", "44", "51.03859", "3.74458", "Europe/Brussels"),
("2793077", "Lede", "", "BE", "56", "", "VLG", "VOV", "41", "50.96626", "3.98594", "Europe/Brussels"),
("2793144", "Lebbeke", "", "BE", "56", "", "VLG", "VOV", "42", "51.00464", "4.13457", "Europe/Brussels"),
("2793429", "Landen", "", "BE", "56", "", "VLG", "VBR", "24", "50.75267", "5.082", "Europe/Brussels"),
("2793446", "Lanaken", "", "BE", "56", "", "VLG", "VLI", "73", "50.89318", "5.6468", "Europe/Brussels"),
("2793508", "La Louvière", "Ла-Лувьер", "BE", "56", "", "WAL", "WHT", "55", "50.48657", "4.18785", "Europe/Brussels"),
("2793548", "La Hulpe", "", "BE", "56", "", "WAL", "WBR", "25", "50.73091", "4.48577", "Europe/Brussels"),
("2793722", "La Calamine", "", "BE", "56", "", "WAL", "WLG", "63", "50.71809", "6.01107", "Europe/Brussels"),
("2793733", "La Bruyère", "", "BE", "56", "", "WAL", "WNA", "", "50.39478", "4.61444", "Europe/Brussels"),
("2793797", "Laarne", "", "BE", "56", "", "VLG", "VOV", "42", "51.03078", "3.85077", "Europe/Brussels"),
("2793857", "Kuurne", "", "BE", "56", "", "VLG", "VWV", "34", "50.85143", "3.2824", "Europe/Brussels"),
("2793907", "Kruishoutem", "", "BE", "56", "", "VLG", "VOV", "45", "50.90168", "3.52588", "Europe/Brussels"),
("2793940", "Kruibeke", "", "BE", "56", "", "VLG", "VOV", "46", "51.17048", "4.31444", "Europe/Brussels"),
("2794016", "Kraainem", "", "BE", "56", "", "VLG", "VBR", "23", "50.86155", "4.46946", "Europe/Brussels"),
("2794055", "Kortrijk", "Кортрейк", "BE", "56", "", "VLG", "VWV", "34", "50.82803", "3.26487", "Europe/Brussels"),
("2794063", "Kortessem", "", "BE", "56", "", "VLG", "VLI", "73", "50.8589", "5.38974", "Europe/Brussels"),
("2794070", "Kortenberg", "", "BE", "56", "", "VLG", "VBR", "24", "50.88982", "4.54353", "Europe/Brussels"),
("2794072", "Kortenaken", "", "BE", "56", "", "VLG", "VBR", "24", "50.90862", "5.05968", "Europe/Brussels"),
("2794074", "Kortemark", "", "BE", "56", "", "VLG", "VWV", "32", "51.02951", "3.04112", "Europe/Brussels"),
("2794117", "Kontich", "Контич", "BE", "56", "", "VLG", "VAN", "11", "51.13213", "4.44706", "Europe/Brussels"),
("2794166", "Koksijde", "Коксийде", "BE", "56", "", "VLG", "VWV", "38", "51.11642", "2.63772", "Europe/Brussels"),
("2794194", "Koekelare", "", "BE", "56", "", "VLG", "VWV", "32", "51.09047", "2.9783", "Europe/Brussels"),
("2794210", "Knokke-Heist", "Кнокке-Хейст", "BE", "56", "", "VLG", "VWV", "31", "51.35", "3.26667", "Europe/Brussels"),
("2794223", "Knesselare", "", "BE", "56", "", "VLG", "VOV", "44", "51.13932", "3.41282", "Europe/Brussels"),
("2794445", "Kinrooi", "", "BE", "56", "", "VLG", "VLI", "72", "51.14543", "5.74207", "Europe/Brussels"),
("2794619", "Keerbergen", "", "BE", "56", "", "VLG", "VBR", "24", "51.00295", "4.63434", "Europe/Brussels"),
("2794663", "Kasterlee", "", "BE", "56", "", "VLG", "VAN", "13", "51.24118", "4.96651", "Europe/Brussels"),
("2794707", "Kaprijke", "", "BE", "56", "", "VLG", "VOV", "43", "51.2172", "3.61519", "Europe/Brussels"),
("2794724", "Kapelle-op-den-Bos", "", "BE", "56", "", "VLG", "VBR", "23", "51.0097", "4.36303", "Europe/Brussels"),
("2794730", "Kapellen", "Капеллене", "BE", "56", "", "VLG", "VAN", "11", "51.31377", "4.43539", "Europe/Brussels"),
("2794763", "Kampenhout", "", "BE", "56", "", "VLG", "VBR", "23", "50.9421", "4.55103", "Europe/Brussels"),
("2794788", "Kalmthout", "", "BE", "56", "", "VLG", "VAN", "11", "51.38442", "4.47556", "Europe/Brussels"),
("2794852", "Jurbise", "", "BE", "56", "", "WAL", "WHT", "53", "50.531", "3.90942", "Europe/Brussels"),
("2794854", "Juprelle", "", "BE", "56", "", "WAL", "WLG", "62", "50.7076", "5.53127", "Europe/Brussels"),
("2794895", "Jodoigne", "", "BE", "56", "", "WAL", "WBR", "25", "50.72357", "4.86914", "Europe/Brussels"),
("2794989", "Jalhay", "", "BE", "56", "", "WAL", "WLG", "63", "50.55876", "5.96764", "Europe/Brussels"),
("2794999", "Jabbeke", "", "BE", "56", "", "VLG", "VWV", "31", "51.18185", "3.08935", "Europe/Brussels"),
("2795009", "Izegem", "Изегем", "BE", "56", "", "VLG", "VWV", "36", "50.91396", "3.21378", "Europe/Brussels"),
("2795017", "Ittre", "", "BE", "56", "", "WAL", "WBR", "25", "50.64396", "4.26476", "Europe/Brussels"),
("2795056", "Ingelmunster", "", "BE", "56", "", "VLG", "VWV", "36", "50.92081", "3.25571", "Europe/Brussels"),
("2795100", "Ieper", "Ипр", "BE", "56", "", "VLG", "VWV", "33", "50.85114", "2.88569", "Europe/Brussels"),
("2795106", "Ichtegem", "", "BE", "56", "", "VLG", "VWV", "35", "51.09572", "3.01549", "Europe/Brussels"),
("2795113", "Huy", "Юи", "BE", "56", "", "WAL", "WLG", "61", "50.51894", "5.23284", "Europe/Brussels"),
("2795170", "Hulshout", "", "BE", "56", "", "VLG", "VAN", "13", "51.07451", "4.79081", "Europe/Brussels"),
("2795184", "Huldenberg", "", "BE", "56", "", "VLG", "VBR", "24", "50.78939", "4.5831", "Europe/Brussels"),
("2795232", "Hove", "", "BE", "56", "", "VLG", "VAN", "11", "51.15446", "4.4707", "Europe/Brussels"),
("2795255", "Houthulst", "", "BE", "56", "", "VLG", "VWV", "32", "50.97824", "2.9505", "Europe/Brussels"),
("2795261", "Houthalen", "", "BE", "56", "", "VLG", "VLI", "72", "51.03427", "5.37429", "Europe/Brussels"),
("2795398", "Hoogstraten", "Хогстратен", "BE", "56", "", "VLG", "VAN", "13", "51.40029", "4.76034", "Europe/Brussels"),
("2795423", "Hooglede", "", "BE", "56", "", "VLG", "VWV", "36", "50.98333", "3.08333", "Europe/Brussels"),
("2795511", "Holsbeek", "", "BE", "56", "", "VLG", "VBR", "24", "50.92097", "4.75747", "Europe/Brussels"),
("2795648", "Hoeselt", "", "BE", "56", "", "VLG", "VLI", "73", "50.84714", "5.48767", "Europe/Brussels"),
("2795699", "Hoeilaart", "", "BE", "56", "", "VLG", "VBR", "23", "50.7673", "4.46835", "Europe/Brussels"),
("2795703", "Hoegaarden", "", "BE", "56", "", "VLG", "VBR", "24", "50.7756", "4.88952", "Europe/Brussels"),
("2795730", "Hoboken", "", "BE", "56", "BE", "VLG", "VAN", "11", "51.17611", "4.34844", "Europe/Brussels"),
("2795800", "Heusden", "", "BE", "56", "", "VLG", "VLI", "71", "51.03664", "5.28013", "Europe/Brussels"),
("2795908", "Herzele", "", "BE", "56", "", "VLG", "VOV", "41", "50.88681", "3.89014", "Europe/Brussels"),
("2795912", "Herve", "Эрв", "BE", "56", "", "WAL", "WLG", "63", "50.64083", "5.79353", "Europe/Brussels"),
("2795930", "Herstal", "Эрсталь", "BE", "56", "", "WAL", "WLG", "62", "50.66415", "5.62346", "Europe/Brussels"),
("2795933", "Herselt", "", "BE", "56", "", "VLG", "VAN", "13", "51.05159", "4.88231", "Europe/Brussels"),
("2795956", "Herne", "", "BE", "56", "", "VLG", "VBR", "23", "50.72423", "4.03481", "Europe/Brussels"),
("2795985", "Herk-de-Stad", "", "BE", "56", "", "VLG", "VLI", "71", "50.94013", "5.16636", "Europe/Brussels"),
("2796005", "Herenthout", "", "BE", "56", "", "VLG", "VAN", "13", "51.1401", "4.75572", "Europe/Brussels"),
("2796009", "Herentals", "Херенталс", "BE", "56", "", "VLG", "VAN", "13", "51.17655", "4.83248", "Europe/Brussels"),
("2796012", "Herent", "", "BE", "56", "", "VLG", "VBR", "24", "50.90861", "4.67056", "Europe/Brussels"),
("2796056", "Hensies", "", "BE", "56", "", "WAL", "WHT", "53", "50.43263", "3.68411", "Europe/Brussels"),
("2796085", "Hemiksem", "", "BE", "56", "", "VLG", "VAN", "11", "51.14484", "4.33874", "Europe/Brussels"),
("2796132", "Helchteren", "", "BE", "56", "", "VLG", "VLI", "72", "51.05591", "5.38244", "Europe/Brussels"),
("2796153", "Heist-op-den-Berg", "", "BE", "56", "", "VLG", "VAN", "12", "51.07537", "4.72827", "Europe/Brussels"),
("2796297", "Heers", "", "BE", "56", "", "VLG", "VLI", "73", "50.75383", "5.3021", "Europe/Brussels"),
("2796482", "Hastière-Lavaux", "", "BE", "56", "", "WAL", "WNA", "91", "50.21849", "4.82446", "Europe/Brussels"),
("2796491", "Hasselt", "Хасселт", "BE", "56", "", "VLG", "VLI", "71", "50.93106", "5.33781", "Europe/Brussels"),
("2796542", "Harelbeke", "Харелбеке", "BE", "56", "", "VLG", "VWV", "34", "50.85343", "3.30935", "Europe/Brussels"),
("2796583", "Hannut", "", "BE", "56", "", "WAL", "WLG", "64", "50.67142", "5.07898", "Europe/Brussels"),
("2796627", "Hamois", "", "BE", "56", "", "WAL", "WNA", "91", "50.3402", "5.15619", "Europe/Brussels"),
("2796637", "Hamme", "Хамме", "BE", "56", "", "VLG", "VOV", "42", "51.09822", "4.13705", "Europe/Brussels"),
("2796696", "Halle", "Галле", "BE", "56", "", "VLG", "VBR", "23", "50.73385", "4.23454", "Europe/Brussels"),
("2796715", "Halen", "", "BE", "56", "", "VLG", "VLI", "71", "50.94837", "5.11096", "Europe/Brussels"),
("2796807", "Habay-la-Vieille", "", "BE", "56", "", "WAL", "WLX", "85", "49.72329", "5.61999", "Europe/Brussels"),
("2796833", "Haaltert", "", "BE", "56", "", "VLG", "VOV", "41", "50.90634", "4.00093", "Europe/Brussels"),
("2796844", "Haacht", "", "BE", "56", "", "VLG", "VBR", "24", "50.97737", "4.63777", "Europe/Brussels"),
("2797094", "Grobbendonk", "", "BE", "56", "", "VLG", "VAN", "13", "51.19043", "4.73562", "Europe/Brussels"),
("2797114", "Grimbergen", "Гримберген", "BE", "56", "", "VLG", "VBR", "23", "50.93409", "4.37213", "Europe/Brussels"),
("2797128", "Grez-Doiceau", "", "BE", "56", "", "WAL", "WBR", "25", "50.73901", "4.69829", "Europe/Brussels"),
("2797417", "Gooik", "", "BE", "56", "", "VLG", "VBR", "23", "50.79443", "4.11378", "Europe/Brussels"),
("2797500", "Glabbeek-Zuurbemde", "", "BE", "56", "", "VLG", "VBR", "24", "50.87348", "4.94442", "Europe/Brussels"),
("2797517", "Gistel", "", "BE", "56", "", "VLG", "VWV", "35", "51.15612", "2.96387", "Europe/Brussels"),
("2797523", "Gingelom", "", "BE", "56", "", "VLG", "VLI", "71", "50.74792", "5.13422", "Europe/Brussels"),
("2797581", "Gesves", "", "BE", "56", "", "WAL", "WNA", "92", "50.40146", "5.07457", "Europe/Brussels"),
("2797598", "Gerpinnes", "", "BE", "56", "", "WAL", "WHT", "52", "50.33789", "4.52731", "Europe/Brussels"),
("2797638", "Geraardsbergen", "Герардсберген", "BE", "56", "", "VLG", "VOV", "41", "50.77343", "3.88223", "Europe/Brussels"),
("2797656", "Gent", "Гент", "BE", "56", "", "VLG", "VOV", "44", "51.05", "3.71667", "Europe/Brussels"),
("2797670", "Genk", "Генк", "BE", "56", "", "VLG", "VLI", "71", "50.965", "5.50082", "Europe/Brussels"),
("2797694", "Genappe", "", "BE", "56", "", "WAL", "WBR", "25", "50.61173", "4.45152", "Europe/Brussels"),
("2797713", "Gembloux", "Гемблуа", "BE", "56", "", "WAL", "WNA", "92", "50.56149", "4.69889", "Europe/Brussels"),
("2797761", "Geetbets", "", "BE", "56", "", "VLG", "VBR", "24", "50.89431", "5.11199", "Europe/Brussels"),
("2797779", "Geel", "Геел", "BE", "56", "", "VLG", "VAN", "13", "51.16557", "4.98917", "Europe/Brussels"),
("2797798", "Gavere", "", "BE", "56", "", "VLG", "VOV", "44", "50.92917", "3.66184", "Europe/Brussels"),
("2797851", "Galmaarden", "", "BE", "56", "", "VLG", "VBR", "23", "50.75389", "3.97121", "Europe/Brussels"),
("2797979", "Frasnes-lez-Buissenal", "", "BE", "56", "", "WAL", "WHT", "51", "50.66783", "3.62047", "Europe/Brussels"),
("2798023", "Frameries", "Фрамерис", "BE", "56", "", "WAL", "WHT", "53", "50.40578", "3.89603", "Europe/Brussels"),
("2798099", "Fosses-la-Ville", "", "BE", "56", "", "WAL", "WNA", "92", "50.39517", "4.69623", "Europe/Brussels"),
("2798272", "Florenville", "", "BE", "56", "", "WAL", "WLX", "85", "49.69983", "5.3074", "Europe/Brussels"),
("2798276", "Florennes", "", "BE", "56", "", "WAL", "WNA", "93", "50.25127", "4.60636", "Europe/Brussels"),
("2798279", "Floreffe", "", "BE", "56", "", "WAL", "WNA", "92", "50.43452", "4.7596", "Europe/Brussels"),
("2798297", "Fleurus", "Флерус", "BE", "56", "", "WAL", "WHT", "52", "50.48351", "4.55006", "Europe/Brussels"),
("2798301", "Fléron", "Флерон", "BE", "56", "", "WAL", "WLG", "62", "50.61516", "5.68062", "Europe/Brussels"),
("2798307", "Flémalle-Haute", "", "BE", "56", "", "WAL", "WLG", "62", "50.59994", "5.44471", "Europe/Brussels"),
("2798470", "Farciennes", "", "BE", "56", "", "WAL", "WHT", "52", "50.43006", "4.54152", "Europe/Brussels"),
("2798551", "Evergem", "Эвергем", "BE", "56", "", "VLG", "VOV", "44", "51.10529", "3.704", "Europe/Brussels"),
("2798573", "Eupen", "Эйпен", "BE", "56", "", "WAL", "WLG", "63", "50.6279", "6.03647", "Europe/Brussels"),
("2798593", "Étalle", "", "BE", "56", "", "WAL", "WLX", "85", "49.67385", "5.60019", "Europe/Brussels"),
("2798597", "Estinnes-au-Val", "", "BE", "56", "", "WAL", "WHT", "56", "50.41016", "4.10477", "Europe/Brussels"),
("2798604", "Estaimpuis", "", "BE", "56", "", "WAL", "WHT", "57", "50.70485", "3.26785", "Europe/Brussels"),
("2798615", "Essen", "", "BE", "56", "", "VLG", "VAN", "11", "51.46791", "4.46901", "Europe/Brussels"),
("2798636", "Esneux", "", "BE", "56", "", "WAL", "WLG", "62", "50.53596", "5.56775", "Europe/Brussels"),
("2798666", "Erquelinnes", "", "BE", "56", "", "WAL", "WHT", "56", "50.30688", "4.11129", "Europe/Brussels"),
("2798743", "Engis", "", "BE", "56", "", "WAL", "WLG", "62", "50.58156", "5.39916", "Europe/Brussels"),
("2798747", "Enghien", "", "BE", "56", "", "WAL", "WHT", "55", "50.68373", "4.03284", "Europe/Brussels"),
("2798836", "Ellezelles", "", "BE", "56", "", "WAL", "WHT", "51", "50.73512", "3.67985", "Europe/Brussels"),
("2798949", "Éghezée", "", "BE", "56", "", "WAL", "WNA", "92", "50.59076", "4.91175", "Europe/Brussels"),
("2798987", "Eeklo", "Экло", "BE", "56", "", "VLG", "VOV", "43", "51.18703", "3.55654", "Europe/Brussels"),
("2799007", "Edegem", "", "BE", "56", "", "VLG", "VAN", "11", "51.15662", "4.44504", "Europe/Brussels"),
("2799024", "Écaussinnes-d’Enghien", "", "BE", "56", "", "WAL", "WHT", "55", "50.56822", "4.1658", "Europe/Brussels"),
("2799047", "Durbuy", "", "BE", "56", "", "WAL", "WLX", "83", "50.35291", "5.45631", "Europe/Brussels"),
("2799090", "Duffel", "", "BE", "56", "", "VLG", "VAN", "12", "51.09554", "4.50903", "Europe/Brussels"),
("2799226", "Dour", "", "BE", "56", "", "WAL", "WHT", "53", "50.39583", "3.77792", "Europe/Brussels"),
("2799347", "Dison", "", "BE", "56", "", "WAL", "WLG", "63", "50.61004", "5.8534", "Europe/Brussels"),
("2799357", "Dinant", "", "BE", "56", "", "WAL", "WNA", "91", "50.25807", "4.91166", "Europe/Brussels"),
("2799365", "Dilbeek", "Дилбек", "BE", "56", "", "VLG", "VBR", "23", "50.84799", "4.25972", "Europe/Brussels"),
("2799369", "Diksmuide", "", "BE", "56", "", "VLG", "VWV", "32", "51.03248", "2.86384", "Europe/Brussels"),
("2799397", "Diest", "", "BE", "56", "", "VLG", "VBR", "24", "50.98923", "5.05062", "Europe/Brussels"),
("2799412", "Diepenbeek", "", "BE", "56", "", "VLG", "VLI", "71", "50.90769", "5.41875", "Europe/Brussels"),
("2799416", "Diegem", "", "BE", "56", "", "VLG", "VBR", "23", "50.89727", "4.43354", "Europe/Brussels"),
("2799496", "Destelbergen", "", "BE", "56", "", "VLG", "VOV", "44", "51.05952", "3.79899", "Europe/Brussels"),
("2799511", "Dessel", "", "BE", "56", "", "VLG", "VAN", "13", "51.23855", "5.11448", "Europe/Brussels"),
("2799570", "De Pinte", "", "BE", "56", "", "VLG", "VOV", "44", "50.99339", "3.64747", "Europe/Brussels"),
("2799577", "De Panne", "", "BE", "56", "", "VLG", "VWV", "38", "51.09793", "2.59368", "Europe/Brussels"),
("2799586", "Dentergem", "", "BE", "56", "", "VLG", "VWV", "37", "50.96429", "3.41617", "Europe/Brussels"),
("2799645", "Dendermonde", "Дендермонде", "BE", "56", "", "VLG", "VOV", "42", "51.02869", "4.10106", "Europe/Brussels"),
("2799647", "Denderleeuw", "", "BE", "56", "", "VLG", "VOV", "41", "50.88506", "4.07601", "Europe/Brussels"),
("2799746", "Deinze", "Дейнзе", "BE", "56", "", "VLG", "VOV", "44", "50.98175", "3.53096", "Europe/Brussels"),
("2799779", "De Haan", "", "BE", "56", "", "VLG", "VWV", "35", "51.27261", "3.03446", "Europe/Brussels"),
("2799797", "Deerlijk", "", "BE", "56", "", "VLG", "VWV", "34", "50.85337", "3.35416", "Europe/Brussels"),
("2799885", "Damme", "", "BE", "56", "", "VLG", "VWV", "31", "51.25147", "3.28144", "Europe/Brussels"),
("2799897", "Dalhem", "", "BE", "56", "", "WAL", "WLG", "62", "50.71315", "5.72774", "Europe/Brussels"),
("2800025", "Couvin", "", "BE", "56", "", "WAL", "WNA", "93", "50.05284", "4.49495", "Europe/Brussels"),
("2800042", "Court-Saint-Étienne", "", "BE", "56", "", "WAL", "WBR", "25", "50.63378", "4.56851", "Europe/Brussels"),
("2800063", "Courcelles", "Курсель", "BE", "56", "", "WAL", "WHT", "52", "50.46379", "4.3747", "Europe/Brussels"),
("2800204", "Comblain-au-Pont", "", "BE", "56", "", "WAL", "WLG", "62", "50.47488", "5.57711", "Europe/Brussels"),
("2800220", "Colfontaine", "", "BE", "56", "", "WAL", "WHT", "53", "50.4141", "3.85569", "Europe/Brussels"),
("2800298", "Ciney", "", "BE", "56", "", "WAL", "WNA", "91", "50.29449", "5.10015", "Europe/Brussels"),
("2800325", "Chimay", "", "BE", "56", "", "WAL", "WHT", "56", "50.04856", "4.31712", "Europe/Brussels"),
("2800328", "Chièvres", "", "BE", "56", "", "WAL", "WHT", "51", "50.58787", "3.80711", "Europe/Brussels"),
("2800430", "Chaumont-Gistoux", "", "BE", "56", "", "WAL", "WBR", "25", "50.67753", "4.7212", "Europe/Brussels"),
("2800438", "Chaudfontaine", "", "BE", "56", "", "WAL", "WLG", "62", "50.5828", "5.6341", "Europe/Brussels"),
("2800448", "Châtelet", "Шатле", "BE", "56", "", "WAL", "WHT", "52", "50.40338", "4.52826", "Europe/Brussels"),
("2800457", "Chastre-Villeroux-Blanmont", "", "BE", "56", "", "WAL", "WBR", "25", "50.60857", "4.64198", "Europe/Brussels"),
("2800461", "Chasse Royale", "", "BE", "56", "", "WAL", "WHT", "", "50.42842", "3.95001", "Europe/Brussels"),
("2800481", "Charleroi", "Шарлеруа", "BE", "56", "", "WAL", "WHT", "52", "50.41136", "4.44448", "Europe/Brussels"),
("2800500", "Chapelle-lez-Herlaimont", "", "BE", "56", "", "WAL", "WHT", "52", "50.4713", "4.28227", "Europe/Brussels"),
("2800605", "Celles", "", "BE", "56", "", "WAL", "WHT", "57", "50.71229", "3.45733", "Europe/Brussels"),
("2800711", "Butgenbach", "", "BE", "56", "", "WAL", "WLG", "63", "50.42689", "6.20504", "Europe/Brussels"),
("2800782", "Bullange", "", "BE", "56", "", "WAL", "WLG", "63", "50.40731", "6.25749", "Europe/Brussels"),
("2800816", "Buggenhout", "", "BE", "56", "", "VLG", "VOV", "42", "51.0159", "4.20173", "Europe/Brussels"),
("2800866", "Brussels", "Брюссель", "BE", "56", "", "BRU", "BRU", "21", "50.85045", "4.34878", "Europe/Brussels"),
("2800883", "Brunehault", "", "BE", "56", "", "WAL", "WHT", "", "50.50524", "4.43209", "Europe/Brussels"),
("2800931", "Brugge", "Брюгге", "BE", "56", "", "VLG", "VWV", "31", "51.20892", "3.22424", "Europe/Brussels"),
("2801093", "Bree", "", "BE", "56", "", "VLG", "VLI", "72", "51.14152", "5.5969", "Europe/Brussels"),
("2801103", "Bredene", "", "BE", "56", "", "VLG", "VWV", "35", "51.23489", "2.97559", "Europe/Brussels"),
("2801106", "Brecht", "Брехт", "BE", "56", "", "VLG", "VAN", "11", "51.35024", "4.63829", "Europe/Brussels"),
("2801117", "Brasschaat", "Брасхат", "BE", "56", "", "VLG", "VAN", "11", "51.2912", "4.49182", "Europe/Brussels"),
("2801147", "Braives", "", "BE", "56", "", "WAL", "WLG", "64", "50.61745", "5.13302", "Europe/Brussels"),
("2801150", "Braine-le-Comte", "Брем-ле-Конт", "BE", "56", "", "WAL", "WHT", "55", "50.60979", "4.14658", "Europe/Brussels"),
("2801152", "Braine-le-Château", "", "BE", "56", "", "WAL", "WBR", "25", "50.6799", "4.27385", "Europe/Brussels"),
("2801154", "Braine-l'Alleud", "Брен-л'Аллё", "BE", "56", "", "WAL", "WBR", "25", "50.68363", "4.36784", "Europe/Brussels"),
("2801215", "Boutersem", "", "BE", "56", "", "VLG", "VBR", "24", "50.83511", "4.8345", "Europe/Brussels"),
("2801226", "Boussu", "Боуссу", "BE", "56", "", "WAL", "WHT", "53", "50.43417", "3.7944", "Europe/Brussels"),
("2801283", "Bouillon", "", "BE", "56", "", "WAL", "WLX", "84", "49.79324", "5.06703", "Europe/Brussels"),
("2801438", "Borsbeek", "", "BE", "56", "", "VLG", "VAN", "11", "51.19661", "4.48543", "Europe/Brussels"),
("2801447", "Bornem", "", "BE", "56", "", "VLG", "VAN", "12", "51.09716", "4.24364", "Europe/Brussels"),
("2801467", "Borgloon", "", "BE", "56", "", "VLG", "VLI", "73", "50.80505", "5.34366", "Europe/Brussels"),
("2801483", "Boortmeerbeek", "", "BE", "56", "", "VLG", "VBR", "24", "50.97929", "4.57443", "Europe/Brussels"),
("2801494", "Boom", "", "BE", "56", "", "VLG", "VAN", "11", "51.09242", "4.3717", "Europe/Brussels"),
("2801539", "Bonheiden", "", "BE", "56", "", "VLG", "VAN", "12", "51.02261", "4.54714", "Europe/Brussels"),
("2801743", "Boechout", "", "BE", "56", "", "VLG", "VAN", "11", "51.15959", "4.49195", "Europe/Brussels"),
("2801754", "Bocholt", "", "BE", "56", "", "VLG", "VLI", "72", "51.17337", "5.57994", "Europe/Brussels"),
("2801820", "Blégny", "", "BE", "56", "", "WAL", "WLG", "62", "50.67255", "5.72508", "Europe/Brussels"),
("2801858", "Blankenberge", "Бланкенберге", "BE", "56", "", "VLG", "VWV", "31", "51.31306", "3.13227", "Europe/Brussels"),
("2801922", "Binche", "Бенш", "BE", "56", "", "WAL", "WHT", "56", "50.41155", "4.16469", "Europe/Brussels"),
("2801924", "Bilzen", "Билзен", "BE", "56", "", "VLG", "VLI", "73", "50.87325", "5.5184", "Europe/Brussels"),
("2801998", "Bierbeek", "", "BE", "56", "", "VLG", "VBR", "24", "50.82876", "4.75949", "Europe/Brussels"),
("2802015", "Beyne-Heusay", "", "BE", "56", "", "WAL", "WLG", "62", "50.62251", "5.66508", "Europe/Brussels"),
("2802031", "Beveren", "Беверен", "BE", "56", "", "VLG", "VOV", "46", "51.21187", "4.25633", "Europe/Brussels"),
("2802106", "Bertrix", "", "BE", "56", "", "WAL", "WLX", "84", "49.85596", "5.25539", "Europe/Brussels"),
("2802123", "Bertem", "", "BE", "56", "", "VLG", "VBR", "24", "50.86403", "4.62918", "Europe/Brussels"),
("2802135", "Bernissart", "", "BE", "56", "", "WAL", "WHT", "51", "50.4746", "3.64961", "Europe/Brussels"),
("2802154", "Berlare", "", "BE", "56", "", "VLG", "VOV", "42", "51.03333", "4", "Europe/Brussels"),
("2802156", "Berlaar", "", "BE", "56", "", "VLG", "VAN", "12", "51.1176", "4.65835", "Europe/Brussels"),
("2802170", "Beringen", "Берингене", "BE", "56", "", "VLG", "VLI", "71", "51.04954", "5.22606", "Europe/Brussels"),
("2802292", "Beloeil", "", "BE", "56", "", "WAL", "WHT", "51", "50.55047", "3.73484", "Europe/Brussels"),
("2802374", "Bekkevoort", "", "BE", "56", "", "VLG", "VBR", "24", "50.94074", "4.969", "Europe/Brussels"),
("2802405", "Begijnendijk", "", "BE", "56", "", "VLG", "VBR", "24", "51.01942", "4.78377", "Europe/Brussels"),
("2802433", "Beersel", "Берсел", "BE", "56", "", "VLG", "VBR", "23", "50.76589", "4.3002", "Europe/Brussels"),
("2802435", "Beerse", "", "BE", "56", "", "VLG", "VAN", "13", "51.31927", "4.85304", "Europe/Brussels"),
("2802437", "Beernem", "", "BE", "56", "", "VLG", "VWV", "31", "51.13981", "3.33896", "Europe/Brussels"),
("2802483", "Beauvechain", "", "BE", "56", "", "WAL", "WBR", "25", "50.78195", "4.7718", "Europe/Brussels"),
("2802501", "Beauraing", "", "BE", "56", "", "WAL", "WNA", "91", "50.11042", "4.95554", "Europe/Brussels"),
("2802510", "Beaumont", "", "BE", "56", "", "WAL", "WHT", "56", "50.23699", "4.23926", "Europe/Brussels"),
("2802583", "Bastogne", "", "BE", "56", "", "WAL", "WLX", "82", "50.00347", "5.71844", "Europe/Brussels"),
("2802606", "Bassenge", "", "BE", "56", "", "WAL", "WLG", "62", "50.75883", "5.60989", "Europe/Brussels"),
("2802610", "Basse Lasne", "", "BE", "56", "", "WAL", "WHT", "", "50.69503", "4.49218", "Europe/Brussels"),
("2802743", "Balen", "", "BE", "56", "", "VLG", "VAN", "13", "51.16837", "5.17027", "Europe/Brussels"),
("2802837", "Aywaille", "", "BE", "56", "", "WAL", "WLG", "62", "50.47411", "5.67684", "Europe/Brussels"),
("2802849", "Awans", "", "BE", "56", "", "WAL", "WLG", "62", "50.66774", "5.46329", "Europe/Brussels"),
("2802871", "Avelgem", "", "BE", "56", "", "VLG", "VWV", "34", "50.77618", "3.44502", "Europe/Brussels"),
("2802990", "Aubange", "", "BE", "56", "", "WAL", "WLX", "81", "49.56652", "5.80492", "Europe/Brussels"),
("2803010", "Ath", "Ат", "BE", "56", "", "WAL", "WHT", "51", "50.62937", "3.77801", "Europe/Brussels"),
("2803018", "Assesse", "", "BE", "56", "", "WAL", "WNA", "92", "50.36934", "5.02204", "Europe/Brussels"),
("2803026", "Assenede", "", "BE", "56", "", "VLG", "VOV", "43", "51.22598", "3.75085", "Europe/Brussels"),
("2803033", "Asse", "Ассо", "BE", "56", "", "VLG", "VBR", "23", "50.91011", "4.19836", "Europe/Brussels"),
("2803053", "As", "", "BE", "56", "", "VLG", "VLI", "71", "51.00755", "5.58453", "Europe/Brussels"),
("2803073", "Arlon", "Арлон", "BE", "56", "", "WAL", "WLX", "81", "49.68333", "5.81667", "Europe/Brussels"),
("2803083", "Arendonk", "", "BE", "56", "", "VLG", "VAN", "13", "51.32267", "5.08289", "Europe/Brussels"),
("2803091", "Ardooie", "", "BE", "56", "", "VLG", "VWV", "37", "50.9757", "3.19736", "Europe/Brussels"),
("2803130", "Anzegem", "", "BE", "56", "", "VLG", "VWV", "34", "50.837", "3.47786", "Europe/Brussels"),
("2803138", "Antwerpen", "Антверпен", "BE", "56", "", "VLG", "VAN", "11", "51.21989", "4.40346", "Europe/Brussels"),
("2803144", "Antoing", "", "BE", "56", "", "WAL", "WHT", "57", "50.56765", "3.4492", "Europe/Brussels"),
("2803160", "Ans", "Анс", "BE", "56", "", "WAL", "WLG", "62", "50.6623", "5.52029", "Europe/Brussels"),
("2803174", "Anhée", "", "BE", "56", "", "WAL", "WNA", "91", "50.31039", "4.87827", "Europe/Brussels"),
("2803199", "Anderlues", "", "BE", "56", "", "WAL", "WHT", "56", "50.40704", "4.27136", "Europe/Brussels"),
("2803204", "Andenne", "Анден", "BE", "56", "", "WAL", "WNA", "92", "50.48941", "5.09513", "Europe/Brussels"),
("2803242", "Amblève", "", "BE", "56", "", "WAL", "WLG", "63", "50.35357", "6.17002", "Europe/Brussels"),
("2803246", "Amay", "", "BE", "56", "", "WAL", "WLG", "61", "50.54829", "5.30974", "Europe/Brussels"),
("2803285", "Alken", "", "BE", "56", "", "VLG", "VLI", "73", "50.87553", "5.30558", "Europe/Brussels"),
("2803323", "Aiseau", "", "BE", "56", "", "WAL", "WHT", "52", "50.41158", "4.58671", "Europe/Brussels"),
("2803420", "Aartselaar", "", "BE", "56", "", "VLG", "VAN", "11", "51.13412", "4.38678", "Europe/Brussels"),
("2803429", "Aarschot", "Ааршот", "BE", "56", "", "VLG", "VBR", "24", "50.98715", "4.83695", "Europe/Brussels"),
("2803443", "Aalter", "Алтер", "BE", "56", "", "VLG", "VOV", "44", "51.09017", "3.44693", "Europe/Brussels"),
("2803448", "Aalst", "", "BE", "56", "", "VLG", "VOV", "41", "50.93604", "4.0355", "Europe/Brussels"),
("2353197", "Zorgo", "", "BF", "854", "", "11", "20", "", "12.24922", "-0.61527", "Africa/Ouagadougou"),
("2353257", "Ziniaré", "", "BF", "854", "", "11", "68", "", "12.58186", "-1.2971", "Africa/Ouagadougou"),
("2353688", "Yako", "Яко", "BF", "854", "", "10", "34", "", "12.9591", "-2.26075", "Africa/Ouagadougou"),
("2354176", "Tougan", "", "BF", "854", "", "01", "73", "", "13.0725", "-3.0694", "Africa/Ouagadougou"),
("2354265", "Toma", "", "BF", "854", "", "01", "66", "", "12.75844", "-2.89879", "Africa/Ouagadougou"),
("2354349", "Titao", "", "BF", "854", "", "10", "62", "", "13.76667", "-2.06667", "Africa/Ouagadougou"),
("2354675", "Tenkodogo", "", "BF", "854", "", "04", "49", "", "11.78", "-0.36972", "Africa/Ouagadougou"),
("2355404", "Salanso", "", "BF", "854", "", "01", "46", "", "12.17423", "-4.08477", "Africa/Ouagadougou"),
("2356228", "Réo", "Рео", "BF", "854", "", "06", "36", "", "12.31963", "-2.47094", "Africa/Ouagadougou"),
("2356454", "Pô", "", "BF", "854", "", "07", "65", "", "11.16972", "-1.145", "Africa/Ouagadougou"),
("2356459", "Pitmoaga", "", "BF", "854", "", "06", "19", "", "12.23972", "-1.87667", "Africa/Ouagadougou"),
("2356738", "Pama", "", "BF", "854", "BF", "08", "57", "", "11.24972", "0.7075", "Africa/Ouagadougou"),
("2357012", "Ouargaye", "", "BF", "854", "", "04", "59", "", "11.50202", "0.05886", "Africa/Ouagadougou"),
("2357043", "Ouahigouya", "", "BF", "854", "", "10", "76", "", "13.58278", "-2.42158", "Africa/Ouagadougou"),
("2357048", "Ouagadougou", "Уагадугу", "BF", "854", "", "03", "53", "", "12.36566", "-1.53388", "Africa/Ouagadougou"),
("2357163", "Nouna", "", "BF", "854", "", "01", "58", "", "12.72939", "-3.86305", "Africa/Ouagadougou"),
("2358100", "Manga", "", "BF", "854", "", "07", "44", "", "11.66361", "-1.07306", "Africa/Ouagadougou"),
("2358382", "Léo", "Лев", "BF", "854", "", "06", "72", "", "11.10033", "-2.10654", "Africa/Ouagadougou"),
("2358738", "Koupéla", "", "BF", "854", "", "04", "28", "", "12.17864", "-0.35103", "Africa/Ouagadougou"),
("2358946", "Koudougou", "Кудугу", "BF", "854", "", "06", "19", "", "12.25263", "-2.36272", "Africa/Ouagadougou"),
("2359142", "Kongoussi", "", "BF", "854", "", "05", "15", "", "13.32583", "-1.53472", "Africa/Ouagadougou"),
("2359227", "Kombissiri", "", "BF", "854", "", "07", "47", "", "12.06095", "-1.33355", "Africa/Ouagadougou"),
("2359317", "Kokologo", "", "BF", "854", "", "06", "19", "", "12.18972", "-1.88556", "Africa/Ouagadougou"),
("2359608", "Kaya", "Кая", "BF", "854", "", "05", "70", "", "13.09167", "-1.08444", "Africa/Ouagadougou"),
("2360073", "Houndé", "", "BF", "854", "", "09", "74", "", "11.5", "-3.51667", "Africa/Ouagadougou"),
("2360238", "Gourcy", "", "BF", "854", "", "10", "78", "", "13.20776", "-2.35893", "Africa/Ouagadougou"),
("2360286", "Goulouré", "", "BF", "854", "", "06", "19", "", "12.2276", "-1.92922", "Africa/Ouagadougou"),
("2360372", "Gorom-Gorom", "", "BF", "854", "", "12", "33", "", "14.4429", "-0.23468", "Africa/Ouagadougou"),
("2360615", "Garango", "", "BF", "854", "", "04", "49", "", "11.8", "-0.55056", "Africa/Ouagadougou"),
("2360886", "Fada N'gourma", "", "BF", "854", "", "08", "50", "", "12.06157", "0.35843", "Africa/Ouagadougou"),
("2361082", "Dori", "Дори", "BF", "854", "", "12", "71", "", "14.0354", "-0.0345", "Africa/Ouagadougou"),
("2361177", "Djibo", "Джибо", "BF", "854", "", "12", "40", "", "14.0994", "-1.62554", "Africa/Ouagadougou"),
("2361342", "Diébougou", "", "BF", "854", "", "13", "48", "", "10.96209", "-3.24967", "Africa/Ouagadougou"),
("2361373", "Diapaga", "Диапага", "BF", "854", "", "08", "42", "", "12.07305", "1.78838", "Africa/Ouagadougou"),
("2361477", "Dédougou", "", "BF", "854", "", "01", "63", "", "12.46338", "-3.46075", "Africa/Ouagadougou"),
("2361586", "Dano", "", "BF", "854", "", "13", "52", "", "11.1464", "-3.05784", "Africa/Ouagadougou"),
("2361845", "Boussé", "", "BF", "854", "", "11", "60", "", "12.6576", "-1.89288", "Africa/Ouagadougou"),
("2361946", "Boulsa", "", "BF", "854", "", "05", "64", "", "12.66664", "-0.57469", "Africa/Ouagadougou"),
("2362150", "Boromo", "", "BF", "854", "", "01", "45", "", "11.74542", "-2.93006", "Africa/Ouagadougou"),
("2362323", "Bogandé", "", "BF", "854", "", "08", "21", "", "12.9704", "-0.14953", "Africa/Ouagadougou"),
("2362344", "Bobo-Dioulasso", "Бобо-Диуласо", "BF", "854", "", "09", "51", "", "11.17715", "-4.2979", "Africa/Ouagadougou"),
("2362669", "Batié", "", "BF", "854", "", "13", "67", "", "9.88333", "-2.91667", "Africa/Ouagadougou"),
("2362909", "Banfora", "Банфору", "BF", "854", "", "02", "55", "", "10.63333", "-4.76667", "Africa/Ouagadougou"),
("2577162", "Gaoua", "", "BF", "854", "", "13", "69", "", "10.29917", "-3.25083", "Africa/Ouagadougou"),
("2577164", "Orodara", "", "BF", "854", "", "09", "54", "", "10.94917", "-4.93417", "Africa/Ouagadougou"),
("725213", "Beloslav", "", "BG", "100", "", "61", "VAR04", "", "43.18333", "27.7", "Europe/Sofia"),
("725271", "Zlatograd", "", "BG", "100", "", "57", "SML11", "", "41.3795", "25.09605", "Europe/Sofia"),
("725283", "Zlatitsa", "", "BG", "100", "", "58", "SFO47", "", "42.71667", "24.13333", "Europe/Sofia"),
("725578", "Yambol", "", "BG", "100", "", "65", "JAM26", "", "42.48333", "26.5", "Europe/Sofia"),
("725586", "Yakoruda", "", "BG", "100", "", "38", "BLG53", "", "42.02528", "23.68417", "Europe/Sofia"),
("725623", "Varshets", "", "BG", "100", "", "47", "MON12", "", "43.19528", "23.28611", "Europe/Sofia"),
("725683", "Valchedram", "", "BG", "100", "", "47", "MON11", "", "43.69639", "23.44472", "Europe/Sofia"),
("725712", "Vratsa", "Враца", "BG", "100", "", "64", "VRC10", "", "43.21", "23.5625", "Europe/Sofia"),
("725905", "Vidin", "Видин", "BG", "100", "", "63", "VID09", "", "43.99", "22.8725", "Europe/Sofia"),
("725935", "Vetovo", "", "BG", "100", "", "53", "RSE05", "", "43.7", "26.26667", "Europe/Sofia"),
("725988", "Velingrad", "Велинград", "BG", "100", "", "48", "PAZ08", "", "42.02754", "23.99155", "Europe/Sofia"),
("725993", "Veliko Tŭrnovo", "", "BG", "100", "", "62", "VTR04", "", "43.08124", "25.62904", "Europe/Sofia"),
("726050", "Varna", "Варна", "BG", "100", "", "61", "VAR06", "", "43.21667", "27.91667", "Europe/Sofia"),
("726130", "Tvarditsa", "", "BG", "100", "", "56", "SLV24", "", "42.7", "25.9", "Europe/Sofia"),
("726141", "Tutrakan", "", "BG", "100", "", "55", "SLS34", "", "44.05", "26.61667", "Europe/Sofia"),
("726174", "Targovishte", "", "BG", "100", "", "60", "TGV35", "", "43.2512", "26.57215", "Europe/Sofia"),
("726287", "Tryavna", "", "BG", "100", "", "41", "GAB35", "", "42.86667", "25.5", "Europe/Sofia"),
("726320", "Troyan", "", "BG", "100", "", "46", "LOV34", "", "42.89427", "24.71589", "Europe/Sofia"),
("726384", "Topolovgrad", "", "BG", "100", "", "43", "HKV32", "", "42.08333", "26.33333", "Europe/Sofia"),
("726418", "Dobrich", "Добрич", "BG", "100", "", "40", "DOB28", "", "43.56667", "27.83333", "Europe/Sofia"),
("726464", "Teteven", "", "BG", "100", "", "46", "LOV33", "", "42.91667", "24.26667", "Europe/Sofia"),
("726474", "Tervel", "", "BG", "100", "", "40", "DOB27", "", "43.75", "27.4", "Europe/Sofia"),
("726524", "Svoge", "", "BG", "100", "", "58", "SFO43", "", "42.96667", "23.35", "Europe/Sofia"),
("726534", "Svishtov", "", "BG", "100", "", "62", "VTR28", "", "43.61959", "25.35044", "Europe/Sofia"),
("726546", "Svilengrad", "Свиленград", "BG", "100", "", "43", "HKV28", "", "41.76667", "26.2", "Europe/Sofia"),
("726657", "Saedinenie", "", "BG", "100", "", "51", "PDV33", "", "42.26667", "24.55", "Europe/Sofia"),
("726727", "Strazhitsa", "", "BG", "100", "BG", "62", "VTR31", "", "43.23333", "25.96667", "Europe/Sofia"),
("726748", "Straldzha", "", "BG", "100", "", "65", "JAM22", "", "42.6", "26.68333", "Europe/Sofia"),
("726848", "Stara Zagora", "Стара-Загора", "BG", "100", "", "59", "SZR31", "", "42.43278", "25.64194", "Europe/Sofia"),
("726872", "Dupnitsa", "", "BG", "100", "", "45", "KNL48", "", "42.26667", "23.11667", "Europe/Sofia"),
("726890", "Stamboliyski", "", "BG", "100", "", "51", "", "", "42.13333", "24.53333", "Europe/Sofia"),
("727011", "Sofia", "София", "BG", "100", "", "42", "SOF46", "", "42.69751", "23.32415", "Europe/Sofia"),
("727030", "Smolyan", "", "BG", "100", "", "57", "SML31", "", "41.58528", "24.69194", "Europe/Sofia"),
("727069", "Slivnitsa", "", "BG", "100", "", "58", "SFO45", "", "42.85182", "23.03792", "Europe/Sofia"),
("727079", "Sliven", "Сливен", "BG", "100", "", "56", "SLV20", "", "42.68583", "26.32917", "Europe/Sofia"),
("727212", "Simitli", "", "BG", "100", "", "38", "BLG44", "", "41.88333", "23.11667", "Europe/Sofia"),
("727217", "Simeonovgrad", "", "BG", "100", "", "43", "HKV29", "", "42.03333", "25.83333", "Europe/Sofia"),
("727221", "Silistra", "Силистра", "BG", "100", "", "55", "SLS31", "", "44.11667", "27.26667", "Europe/Sofia"),
("727233", "Shumen", "", "BG", "100", "", "54", "SHU30", "", "43.27064", "26.92286", "Europe/Sofia"),
("727337", "Sevlievo", "", "BG", "100", "", "41", "GAB29", "", "43.02583", "25.11361", "Europe/Sofia"),
("727354", "Septemvri", "", "BG", "100", "", "48", "PAZ29", "", "42.21667", "24.1", "Europe/Sofia"),
("727447", "Sandanski", "", "BG", "100", "", "38", "BLG40", "", "41.56667", "23.28333", "Europe/Sofia"),
("727462", "Samokov", "", "BG", "100", "", "58", "SFO39", "", "42.337", "23.5528", "Europe/Sofia"),
("727523", "Ruse", "Русе", "BG", "100", "", "53", "RSE27", "", "43.85639", "25.97083", "Europe/Sofia"),
("727689", "Razlog", "", "BG", "100", "", "38", "BLG37", "", "41.8863", "23.46714", "Europe/Sofia"),
("727696", "Razgrad", "Разград", "BG", "100", "", "52", "RAZ26", "", "43.53333", "26.51667", "Europe/Sofia"),
("727791", "Rakovski", "", "BG", "100", "", "51", "PDV25", "", "42.3", "24.96667", "Europe/Sofia"),
("727801", "Rakitovo", "", "BG", "100", "", "48", "PAZ24", "", "41.98333", "24.08333", "Europe/Sofia"),
("727832", "Radomir", "", "BG", "100", "", "49", "PER36", "", "42.54444", "22.95778", "Europe/Sofia"),
("727838", "Radnevo", "", "BG", "100", "", "59", "SZR27", "", "42.3", "25.93333", "Europe/Sofia"),
("727921", "Provadia", "", "BG", "100", "", "61", "VAR24", "", "43.18333", "27.43333", "Europe/Sofia"),
("727987", "Veliki Preslav", "", "BG", "100", "", "54", "SHU23", "", "43.16667", "26.81667", "Europe/Sofia"),
("728075", "Popovo", "", "BG", "100", "", "60", "TGV24", "", "43.35", "26.23333", "Europe/Sofia"),
("728108", "Pomorie", "", "BG", "100", "", "39", "BGS17", "", "42.55882", "27.64393", "Europe/Sofia"),
("728124", "Polski Trambesh", "", "BG", "100", "", "62", "VTR26", "", "43.38361", "25.64972", "Europe/Sofia"),
("728193", "Plovdiv", "Пловдив", "BG", "100", "", "51", "PDV22", "", "42.15", "24.75", "Europe/Sofia"),
("728203", "Pleven", "Плевен", "BG", "100", "", "50", "PVN24", "", "43.41667", "24.61667", "Europe/Sofia"),
("728251", "Pirdop", "", "BG", "100", "", "58", "SFO55", "", "42.7", "24.18333", "Europe/Sofia"),
("728288", "Petrich", "Петрич", "BG", "100", "", "38", "BLG33", "", "41.39846", "23.20702", "Europe/Sofia"),
("728317", "Peshtera", "", "BG", "100", "", "48", "PAZ21", "", "42.03333", "24.3", "Europe/Sofia"),
("728321", "Perushtitsa", "", "BG", "100", "", "51", "PDV40", "", "42.05", "24.55", "Europe/Sofia"),
("728330", "Pernik", "Перник", "BG", "100", "", "49", "PER32", "", "42.6", "23.03333", "Europe/Sofia"),
("728378", "Pazardzhik", "Пазарджик", "BG", "100", "", "48", "PAZ19", "", "42.2", "24.33333", "Europe/Sofia"),
("728385", "Pavlikeni", "", "BG", "100", "", "62", "VTR22", "", "43.24278", "25.32194", "Europe/Sofia"),
("728448", "Panagyurishte", "", "BG", "100", "", "48", "PAZ20", "", "42.5", "24.18333", "Europe/Sofia"),
("728565", "Oryahovo", "", "BG", "100", "", "64", "VRC31", "", "43.73333", "23.96667", "Europe/Sofia"),
("728634", "Omurtag", "", "BG", "100", "", "60", "TGV22", "", "43.1", "26.41667", "Europe/Sofia"),
("728734", "Novi Pazar", "", "BG", "100", "", "54", "SHU22", "", "43.35", "27.2", "Europe/Sofia"),
("728742", "Nova Zagora", "", "BG", "100", "", "56", "SLV16", "", "42.48333", "26.01667", "Europe/Sofia"),
("728825", "Nesebar", "", "BG", "100", "", "39", "BGS15", "", "42.65921", "27.73602", "Europe/Sofia"),
("728851", "Nedelino", "", "BG", "100", "", "57", "SML18", "", "41.45602", "25.08008", "Europe/Sofia"),
("729114", "Montana", "Монтана", "BG", "100", "", "47", "MON29", "", "43.4125", "23.225", "Europe/Sofia"),
("729125", "Tsarevo", "", "BG", "100", "BG", "39", "BGS13", "", "42.16955", "27.84541", "Europe/Sofia"),
("729134", "Mezdra", "", "BG", "100", "", "64", "VRC27", "", "43.15", "23.7", "Europe/Sofia"),
("729439", "Madan", "", "BG", "100", "", "57", "SML16", "", "41.49869", "24.93973", "Europe/Sofia"),
("729466", "Lyubimets", "", "BG", "100", "", "43", "HKV17", "", "41.83333", "26.08333", "Europe/Sofia"),
("729489", "Lyaskovets", "", "BG", "100", "", "62", "VTR20", "", "43.11111", "25.72833", "Europe/Sofia"),
("729507", "Lukovit", "", "BG", "100", "", "46", "LOV19", "", "43.2", "24.16667", "Europe/Sofia"),
("729559", "Lovech", "Ловеч", "BG", "100", "", "46", "LOV18", "", "43.13333", "24.71667", "Europe/Sofia"),
("729581", "Lom", "", "BG", "100", "", "47", "MON24", "", "43.81389", "23.23611", "Europe/Sofia"),
("729636", "Levski", "", "BG", "100", "", "50", "PVN16", "", "43.36667", "25.13333", "Europe/Sofia"),
("729730", "Kyustendil", "", "BG", "100", "", "45", "KNL29", "", "42.28389", "22.69111", "Europe/Sofia"),
("729794", "Kardzhali", "Кырджали", "BG", "100", "", "44", "KRZ16", "", "41.65", "25.36667", "Europe/Sofia"),
("729839", "Kubrat", "", "BG", "100", "", "52", "RAZ16", "", "43.8", "26.5", "Europe/Sofia"),
("729896", "Krumovgrad", "", "BG", "100", "", "44", "KRZ15", "", "41.47127", "25.65485", "Europe/Sofia"),
("729936", "Krichim", "", "BG", "100", "", "51", "PDV39", "", "42.05", "24.46667", "Europe/Sofia"),
("730013", "Kozloduy", "", "BG", "100", "", "64", "VRC20", "", "43.78333", "23.73333", "Europe/Sofia"),
("730073", "Kotel", "", "BG", "100", "", "56", "SLV11", "", "42.88333", "26.45", "Europe/Sofia"),
("730084", "Kostinbrod", "", "BG", "100", "", "58", "SFO26", "", "42.81667", "23.21667", "Europe/Sofia"),
("730287", "Knezha", "", "BG", "100", "", "50", "PVN39", "", "43.5", "24.08333", "Europe/Sofia"),
("730419", "Hisarya", "", "BG", "100", "", "51", "PDV37", "", "42.5", "24.7", "Europe/Sofia"),
("730435", "Haskovo", "Хасково", "BG", "100", "", "43", "HKV34", "", "41.93415", "25.55557", "Europe/Sofia"),
("730442", "Harmanli", "", "BG", "100", "", "43", "HKV33", "", "41.93333", "25.9", "Europe/Sofia"),
("730496", "Kazanlak", "Казанлык", "BG", "100", "", "59", "SZR12", "", "42.61667", "25.4", "Europe/Sofia"),
("730518", "Kavarna", "", "BG", "100", "", "40", "DOB17", "", "43.43333", "28.33333", "Europe/Sofia"),
("730559", "Karnobat", "", "BG", "100", "", "39", "BGS09", "", "42.65", "26.98333", "Europe/Sofia"),
("730565", "Karlovo", "Карлово", "BG", "100", "", "51", "PDV13", "", "42.63333", "24.8", "Europe/Sofia"),
("730866", "Isperih", "", "BG", "100", "", "52", "RAZ14", "", "43.71667", "26.83333", "Europe/Sofia"),
("730919", "Ihtiman", "", "BG", "100", "", "58", "SFO20", "", "42.43333", "23.81667", "Europe/Sofia"),
("730987", "Gŭlŭbovo", "", "BG", "100", "BG", "59", "", "", "42.13333", "25.85", "Europe/Sofia"),
("731016", "Sredets", "", "BG", "100", "", "39", "BGS06", "", "42.34747", "27.17898", "Europe/Sofia"),
("731108", "Gotse Delchev", "Гоце-Делчев", "BG", "100", "", "38", "BLG11", "", "41.56667", "23.73333", "Europe/Sofia"),
("731233", "Gorna Oryahovitsa", "Горна Оряховица", "BG", "100", "", "62", "VTR06", "", "43.12778", "25.70167", "Europe/Sofia"),
("731384", "Godech", "", "BG", "100", "", "58", "SFO09", "", "43.01682", "23.04852", "Europe/Sofia"),
("731453", "Dolni Chiflik", "", "BG", "100", "BG", "61", "VAR13", "", "42.98333", "27.71667", "Europe/Sofia"),
("731464", "General-Toshevo", "", "BG", "100", "", "40", "", "", "43.7", "28.03333", "Europe/Sofia"),
("731549", "Gabrovo", "Габрово", "BG", "100", "BG", "41", "GAB05", "", "42.87472", "25.33417", "Europe/Sofia"),
("731626", "Etropole", "", "BG", "100", "", "58", "SFO18", "", "42.83333", "24", "Europe/Sofia"),
("731670", "Elhovo", "", "BG", "100", "", "65", "JAM07", "", "42.16667", "26.56667", "Europe/Sofia"),
("731675", "Elin Pelin", "", "BG", "100", "", "58", "SFO17", "SFO17-05", "42.66667", "23.6", "Europe/Sofia"),
("731696", "Elena", "", "BG", "100", "", "62", "HKV34", "HKV34-12", "42.93333", "25.88333", "Europe/Sofia"),
("731818", "Dulovo", "", "BG", "100", "", "55", "SLS10", "", "43.81667", "27.15", "Europe/Sofia"),
("731822", "Dalgopol", "", "BG", "100", "", "61", "VAR16", "", "43.05", "27.35", "Europe/Sofia"),
("731882", "Dryanovo", "", "BG", "100", "", "41", "GAB12", "", "42.97897", "25.4785", "Europe/Sofia"),
("732099", "Dolni Dabnik", "", "BG", "100", "", "50", "PVN11", "", "43.4", "24.43333", "Europe/Sofia"),
("732263", "Dimitrovgrad", "Димитровград", "BG", "100", "", "43", "HKV09", "", "42.05", "25.6", "Europe/Sofia"),
("732280", "Devnya", "", "BG", "100", "", "61", "VAR14", "", "43.22222", "27.56944", "Europe/Sofia"),
("732285", "Devin", "", "BG", "100", "", "57", "SML09", "", "41.74327", "24.40003", "Europe/Sofia"),
("732452", "Chirpan", "", "BG", "100", "", "59", "SZR36", "", "42.2", "25.33333", "Europe/Sofia"),
("732491", "Cherven Bryag", "", "BG", "100", "", "50", "PVN37", "", "43.26667", "24.1", "Europe/Sofia"),
("732627", "Chepelare", "", "BG", "100", "", "57", "SML38", "", "41.73333", "24.68333", "Europe/Sofia"),
("732704", "Byala Slatina", "", "BG", "100", "", "64", "VRC08", "", "43.46667", "23.93333", "Europe/Sofia"),
("732770", "Burgas", "Бургас", "BG", "100", "", "39", "BGS04", "", "42.50606", "27.46781", "Europe/Sofia"),
("733014", "Botevgrad", "", "BG", "100", "", "58", "SFO07", "", "42.9", "23.78333", "Europe/Sofia"),
("733151", "Bobovdol", "", "BG", "100", "", "45", "KNL04", "", "42.36972", "23.01722", "Europe/Sofia"),
("733191", "Blagoevgrad", "Благоевград", "BG", "100", "", "38", "BLG03", "", "42.01667", "23.1", "Europe/Sofia"),
("733264", "Berkovitsa", "", "BG", "100", "", "47", "MON02", "", "43.23611", "23.12583", "Europe/Sofia"),
("733309", "Belogradchik", "", "BG", "100", "", "63", "VID01", "", "43.62722", "22.68361", "Europe/Sofia"),
("733359", "Belene", "", "BG", "100", "", "50", "PVN03", "", "43.65", "25.11667", "Europe/Sofia"),
("733462", "Bansko", "", "BG", "100", "", "38", "BLG01", "", "41.8383", "23.48851", "Europe/Sofia"),
("733515", "Balchik", "", "BG", "100", "BG", "40", "DOB03", "", "43.41667", "28.16667", "Europe/Sofia"),
("733579", "Aytos", "", "BG", "100", "", "39", "BGS01", "", "42.7", "27.25", "Europe/Sofia"),
("733618", "Asenovgrad", "", "BG", "100", "", "51", "PDV01", "", "42.01667", "24.86667", "Europe/Sofia"),
("733716", "Aksakovo", "", "BG", "100", "BG", "61", "VAR02", "", "43.25", "27.81667", "Europe/Sofia"),
("6355004", "Zlatni Pyasatsi", "", "BG", "100", "", "61", "VAR06", "", "43.285", "28.0418", "Europe/Sofia"),
("422232", "Makamba", "Макамба", "BI", "108", "", "17", "", "", "-4.1348", "29.804", "Africa/Bujumbura"),
("423328", "Bururi", "Бурури", "BI", "108", "", "10", "", "", "-3.94877", "29.62438", "Africa/Bujumbura"),
("423549", "Rumonge", "", "BI", "108", "", "26", "9158023", "", "-3.9736", "29.4386", "Africa/Bujumbura"),
("423794", "Mwaro", "", "BI", "108", "", "23", "", "", "-3.51128", "29.70334", "Africa/Bujumbura"),
("425336", "Isale", "", "BI", "108", "", "25", "", "", "-3.3489", "29.4839", "Africa/Bujumbura"),
("425378", "Bujumbura", "Бужумбура", "BI", "108", "", "24", "", "", "-3.3822", "29.3644", "Africa/Bujumbura"),
("425551", "Muramvya", "", "BI", "108", "", "22", "", "", "-3.2682", "29.6079", "Africa/Bujumbura"),
("426272", "Gitega", "Гитеге", "BI", "108", "", "13", "", "", "-3.4264", "29.9308", "Africa/Bujumbura"),
("426700", "Ruyigi", "Руйиги", "BI", "108", "", "21", "", "", "-3.47639", "30.24861", "Africa/Bujumbura"),
("427701", "Cankuzo", "", "BI", "108", "", "11", "", "", "-3.2186", "30.5528", "Africa/Bujumbura"),
("428219", "Karuzi", "", "BI", "108", "", "14", "", "", "-3.10139", "30.16278", "Africa/Bujumbura"),
("428515", "Bubanza", "", "BI", "108", "", "09", "", "", "-3.0804", "29.391", "Africa/Bujumbura"),
("430021", "Cibitoke", "", "BI", "108", "", "12", "", "", "-2.8869", "29.1248", "Africa/Bujumbura"),
("430569", "Ngozi", "Нгози", "BI", "108", "", "19", "", "", "-2.9075", "29.8306", "Africa/Bujumbura"),
("430952", "Kayanza", "", "BI", "108", "", "15", "", "", "-2.9221", "29.6293", "Africa/Bujumbura"),
("431748", "Muyinga", "Муйинга", "BI", "108", "", "18", "", "", "-2.8451", "30.3414", "Africa/Bujumbura"),
("432456", "Kirundo", "", "BI", "108", "", "16", "", "", "-2.5845", "30.0959", "Africa/Bujumbura"),
("433635", "Rutana", "Рутана", "BI", "108", "", "20", "", "", "-3.9279", "29.992", "Africa/Bujumbura"),
("2391377", "Tchaourou", "", "BJ", "204", "", "10", "", "", "8.88649", "2.59753", "Africa/Porto-Novo"),
("2391455", "Tanguiéta", "", "BJ", "204", "", "08", "", "", "10.62118", "1.26651", "Africa/Porto-Novo"),
("2391893", "Savé", "", "BJ", "204", "", "11", "", "", "8.03424", "2.4866", "Africa/Porto-Novo"),
("2391895", "Savalou", "", "BJ", "204", "", "11", "", "", "7.92807", "1.97558", "Africa/Porto-Novo"),
("2392009", "Sakété", "", "BJ", "204", "", "17", "", "", "6.73618", "2.65866", "Africa/Porto-Novo"),
("2392087", "Porto-Novo", "Порто-Ново", "BJ", "204", "", "16", "", "", "6.49646", "2.60359", "Africa/Porto-Novo"),
("2392108", "Pobé", "", "BJ", "204", "", "17", "", "", "6.98008", "2.6649", "Africa/Porto-Novo"),
("2392204", "Parakou", "Параку", "BJ", "204", "", "10", "", "", "9.33716", "2.63031", "Africa/Porto-Novo"),
("2392308", "Ouidah", "Виды", "BJ", "204", "", "09", "", "", "6.36307", "2.08506", "Africa/Porto-Novo"),
("2392505", "Nikki", "Никки", "BJ", "204", "", "10", "", "", "9.94009", "3.21075", "Africa/Porto-Novo"),
("2392601", "Natitingou", "Натитингу", "BJ", "204", "", "08", "", "", "10.30416", "1.37962", "Africa/Porto-Novo"),
("2392837", "Malanville", "Маланвилем", "BJ", "204", "", "08", "", "", "11.86819", "3.38327", "Africa/Porto-Novo"),
("2392897", "Lokossa", "", "BJ", "204", "", "15", "", "", "6.63869", "1.71674", "Africa/Porto-Novo"),
("2393551", "Kétou", "", "BJ", "204", "", "17", "", "", "7.36332", "2.59978", "Africa/Porto-Novo"),
("2393693", "Kandi", "Канди", "BJ", "204", "", "07", "", "", "11.13417", "2.93861", "Africa/Porto-Novo"),
("2393887", "Hévié", "", "BJ", "204", "", "09", "", "", "6.41667", "2.25", "Africa/Porto-Novo"),
("2393917", "Guilmaro", "", "BJ", "204", "", "08", "", "", "10.56583", "1.72444", "Africa/Porto-Novo"),
("2393947", "Grand-Popo", "", "BJ", "204", "", "15", "", "", "6.28036", "1.82251", "Africa/Porto-Novo"),
("2394545", "Dogbo", "", "BJ", "204", "", "12", "", "", "6.81667", "1.78333", "Africa/Porto-Novo"),
("2394560", "Djougou", "", "BJ", "204", "", "13", "", "", "9.70853", "1.66598", "Africa/Porto-Novo"),
("2394711", "Dassa-Zoumé", "", "BJ", "204", "", "11", "", "", "7.75", "2.18333", "Africa/Porto-Novo"),
("2394814", "Cové", "", "BJ", "204", "", "18", "", "", "7.22097", "2.34017", "Africa/Porto-Novo"),
("2394819", "Cotonou", "Котону", "BJ", "204", "", "14", "", "", "6.36536", "2.41833", "Africa/Porto-Novo"),
("2394824", "Comé", "", "BJ", "204", "", "15", "", "", "6.40764", "1.88198", "Africa/Porto-Novo"),
("2395049", "Bohicon", "", "BJ", "204", "", "18", "", "", "7.17826", "2.0667", "Africa/Porto-Novo"),
("2395127", "Bétérou", "", "BJ", "204", "", "10", "", "", "9.19916", "2.25855", "Africa/Porto-Novo"),
("2395182", "Bembèrèkè", "", "BJ", "204", "", "10", "", "", "10.22827", "2.66335", "Africa/Porto-Novo"),
("2395261", "Bassila", "", "BJ", "204", "", "13", "", "", "9.00814", "1.6654", "Africa/Porto-Novo"),
("2395317", "Banikoara", "", "BJ", "204", "", "07", "", "", "11.29845", "2.43856", "Africa/Porto-Novo"),
("2395568", "Aplahoué", "", "BJ", "204", "", "12", "", "", "6.93333", "1.68333", "Africa/Porto-Novo"),
("2395635", "Allada", "", "BJ", "204", "", "09", "", "", "6.66547", "2.15138", "Africa/Porto-Novo"),
("2395914", "Abomey-Calavi", "Абомей-Калави", "BJ", "204", "", "09", "", "", "6.44852", "2.35566", "Africa/Porto-Novo"),
("2395915", "Abomey", "Абомей", "BJ", "204", "", "18", "", "", "7.18286", "1.99119", "Africa/Porto-Novo"),
("3444105", "San Matías", "", "BO", "68", "", "08", "0712", "10400576", "-16.36667", "-58.4", "America/La_Paz"),
("3444176", "Roboré", "", "BO", "68", "", "08", "0705", "", "-18.33473", "-59.76142", "America/La_Paz"),
("3444201", "Puerto Quijarro", "", "BO", "68", "", "08", "", "", "-17.78333", "-57.76667", "America/La_Paz"),
("3901178", "Yacuiba", "Якуиба", "BO", "68", "", "09", "0603", "", "-22.01643", "-63.67753", "America/La_Paz"),
("3901301", "Warnes", "", "BO", "68", "", "08", "", "", "-17.5163", "-63.16778", "America/La_Paz"),
("3901501", "Villazón", "Вильясон", "BO", "68", "", "07", "", "", "-22.08659", "-65.59422", "America/La_Paz"),
("3901504", "Villa Yapacaní", "", "BO", "68", "", "08", "", "", "-17.4", "-63.83333", "America/La_Paz"),
("3901547", "Villamontes", "Вилья-Монтес", "BO", "68", "", "09", "", "", "-21.26235", "-63.46903", "America/La_Paz"),
("3901874", "Vallegrande", "", "BO", "68", "", "08", "", "", "-18.48923", "-64.10609", "America/La_Paz"),
("3901903", "Uyuni", "", "BO", "68", "", "07", "", "", "-20.45967", "-66.82503", "America/La_Paz"),
("3902202", "Tupiza", "", "BO", "68", "", "07", "", "", "-21.44345", "-65.71875", "America/La_Paz"),
("3902377", "Trinidad", "Тринидад", "BO", "68", "", "03", "", "", "-14.83333", "-64.9", "America/La_Paz"),
("3903320", "Tarija", "Тариха", "BO", "68", "", "09", "", "", "-21.53549", "-64.72956", "America/La_Paz"),
("3903342", "Tarata", "", "BO", "68", "", "02", "", "", "-17.60898", "-66.02135", "America/La_Paz"),
("3903987", "Sucre", "Сукре", "BO", "68", "", "01", "", "", "-19.03332", "-65.26274", "America/La_Paz"),
("3904666", "Santiago del Torno", "", "BO", "68", "", "08", "", "", "-17.98674", "-63.38118", "America/La_Paz"),
("3904729", "Santa Rosa del Sara", "", "BO", "68", "", "08", "", "", "-17.10916", "-63.59514", "America/La_Paz"),
("3904906", "Santa Cruz de la Sierra", "Санта-Крус-де-ла-Сиерра", "BO", "68", "", "08", "", "", "-17.78629", "-63.18117", "America/La_Paz"),
("3905159", "San Pedro", "", "BO", "68", "BO", "04", "", "", "-16.23717", "-68.85063", "America/La_Paz"),
("3905453", "San Julian", "", "BO", "68", "", "08", "", "", "-17.78333", "-62.86667", "America/La_Paz"),
("3905658", "San Ignacio de Velasco", "", "BO", "68", "", "08", "", "", "-16.36667", "-60.95", "America/La_Paz"),
("3905792", "San Borja", "", "BO", "68", "", "03", "", "", "-14.81667", "-66.85", "America/La_Paz"),
("3906209", "Rurrenabaque", "", "BO", "68", "", "03", "", "", "-14.44125", "-67.52781", "America/La_Paz"),
("3906466", "Riberalta", "", "BO", "68", "", "03", "0802", "10173550", "-11.00654", "-66.06312", "America/La_Paz"),
("3906478", "Reyes", "", "BO", "68", "", "03", "3915596", "", "-14.2952", "-67.33624", "America/La_Paz"),
("3907080", "Punata", "", "BO", "68", "", "02", "", "", "-17.54234", "-65.83472", "America/La_Paz"),
("3907584", "Potosí", "Потоси", "BO", "68", "", "07", "", "", "-19.58361", "-65.75306", "America/La_Paz"),
("3907646", "Portachuelo", "", "BO", "68", "", "08", "", "", "-17.35168", "-63.39282", "America/La_Paz"),
("3908339", "Patacamaya", "", "BO", "68", "", "04", "", "", "-17.2358", "-67.92169", "America/La_Paz"),
("3909010", "Pailón", "", "BO", "68", "", "08", "", "", "-17.65", "-62.75", "America/La_Paz"),
("3909234", "Oruro", "Оруро", "BO", "68", "", "05", "", "", "-17.98333", "-67.15", "America/La_Paz"),
("3910027", "Montero", "Монтеро", "BO", "68", "", "08", "", "", "-17.33866", "-63.2505", "America/La_Paz"),
("3910094", "Monteagudo", "", "BO", "68", "", "01", "", "", "-19.79989", "-63.95461", "America/La_Paz"),
("3910291", "Mizque", "", "BO", "68", "", "02", "", "", "-17.94101", "-65.34016", "America/La_Paz"),
("3910343", "Mineros", "", "BO", "68", "", "08", "", "", "-17.11876", "-63.231", "America/La_Paz"),
("3911409", "Llallagua", "", "BO", "68", "", "07", "", "", "-18.42426", "-66.58388", "America/La_Paz"),
("3911925", "La Paz", "Ла-Пас", "BO", "68", "", "04", "", "", "-16.5", "-68.15", "America/La_Paz"),
("3912418", "La Bélgica", "", "BO", "68", "", "08", "", "", "-17.55", "-63.21667", "America/La_Paz"),
("3914839", "Huanuni", "", "BO", "68", "", "05", "", "", "-18.289", "-66.83583", "America/La_Paz"),
("3915350", "Guayaramerín", "", "BO", "68", "", "03", "", "", "-10.83676", "-65.36136", "America/La_Paz"),
("3918937", "Cotoca", "", "BO", "68", "", "08", "", "", "-17.81667", "-63.05", "America/La_Paz"),
("3919352", "Concepción", "", "BO", "68", "", "08", "", "", "-16.43333", "-60.9", "America/La_Paz"),
("3919884", "Colchani", "", "BO", "68", "", "07", "", "", "-20.3", "-66.93333", "America/La_Paz"),
("3919968", "Cochabamba", "Кочабамба", "BO", "68", "", "02", "", "", "-17.3895", "-66.1568", "America/La_Paz"),
("3919998", "Cobija", "Кобиха", "BO", "68", "", "06", "", "", "-11.02671", "-68.76918", "America/La_Paz"),
("3920016", "Cliza", "", "BO", "68", "", "02", "", "", "-17.58777", "-65.93253", "America/La_Paz"),
("3920736", "Chimoré", "", "BO", "68", "", "02", "", "", "-16.99417", "-65.1533", "America/La_Paz"),
("3921355", "Challapata", "", "BO", "68", "", "05", "", "", "-18.90208", "-66.77048", "America/La_Paz"),
("3922125", "Capinota", "", "BO", "68", "", "02", "", "", "-17.71113", "-66.26082", "America/La_Paz"),
("3922414", "Camiri", "Камири", "BO", "68", "", "08", "", "", "-20.03849", "-63.51833", "America/La_Paz"),
("3923644", "Ascensión", "", "BO", "68", "", "08", "", "", "-15.7", "-63.08333", "America/La_Paz"),
("3924341", "Aiquile", "", "BO", "68", "", "02", "", "", "-18.20408", "-65.18068", "America/La_Paz"),
("3924610", "Achacachi", "", "BO", "68", "", "04", "", "", "-16.05", "-68.68333", "America/La_Paz"),
("3384983", "Vitorino Freire", "", "BR", "76", "", "13", "2107407", "", "-4.04238", "-45.23777", "America/Fortaleza"),
("3384986", "Vitória do Mearim", "", "BR", "76", "", "13", "2112902", "", "-3.46222", "-44.87056", "America/Fortaleza"),
("3384987", "Vitória de Santo Antão", "Витория-де-Санту-Антан", "BR", "76", "", "30", "2616407", "", "-8.11806", "-35.29139", "America/Recife"),
("3385022", "Viseu", "", "BR", "76", "", "16", "1508308", "", "-1.19667", "-46.14", "America/Belem"),
("3385077", "Conde", "", "BR", "76", "", "17", "2504603", "", "-7.25972", "-34.9075", "America/Fortaleza"),
("3385088", "Vigia", "", "BR", "76", "", "16", "1508209", "", "-0.85833", "-48.14167", "America/Belem"),
("3385106", "Viçosa do Ceará", "", "BR", "76", "", "06", "2314102", "", "-3.56222", "-41.09222", "America/Fortaleza"),
("3385109", "Viçosa", "", "BR", "76", "", "02", "2709400", "", "-9.37139", "-36.24083", "America/Maceio"),
("3385118", "Vicência", "", "BR", "76", "", "30", "2616308", "", "-7.65694", "-35.32667", "America/Recife"),
("3385122", "Viana", "Виана", "BR", "76", "", "13", "2112803", "", "-3.22028", "-45.00361", "America/Fortaleza"),
("3385467", "Várzea Alegre", "", "BR", "76", "", "06", "2305605", "", "-5.35", "-40.38333", "America/Fortaleza"),
("3385504", "Varjota", "", "BR", "76", "", "06", "2313955", "", "-4.19444", "-40.47667", "America/Fortaleza"),
("3385538", "Vargem Grande", "", "BR", "76", "", "13", "2112704", "", "-3.54306", "-43.91583", "America/Fortaleza"),
("3385592", "Valença do Piauí", "", "BR", "76", "", "20", "2211308", "", "-6.4075", "-41.74556", "America/Fortaleza"),
("3385645", "Urucurituba", "", "BR", "76", "", "04", "1304401", "", "-3.12845", "-58.15856", "America/Manaus"),
("3385658", "Uruçuí", "", "BR", "76", "", "20", "2211209", "", "-7.22944", "-44.55611", "America/Fortaleza"),
("3385670", "Urucará", "", "BR", "76", "", "04", "1304302", "", "-2.53639", "-57.76", "America/Manaus"),
("3385674", "Uruburetama", "", "BR", "76", "", "06", "2313807", "", "-3.625", "-39.50833", "America/Fortaleza"),
("3385726", "Urbano Santos", "", "BR", "76", "", "13", "2112605", "", "-3.20778", "-43.40361", "America/Fortaleza"),
("3385736", "Upanema", "", "BR", "76", "", "22", "2414605", "", "-5.64194", "-37.25778", "America/Fortaleza"),
("3385742", "União dos Palmares", "", "BR", "76", "", "02", "2709301", "", "-9.16278", "-36.03194", "America/Maceio"),
("3385745", "União", "", "BR", "76", "", "20", "2211100", "", "-4.58583", "-42.86417", "America/Fortaleza"),
("3385758", "Umirim", "", "BR", "76", "", "06", "2313757", "", "-3.67722", "-39.35028", "America/Fortaleza"),
("3385826", "Umarizal", "", "BR", "76", "", "22", "2414506", "", "-5.99056", "-37.81444", "America/Fortaleza"),
("3385850", "Uiraúna", "", "BR", "76", "", "17", "2516904", "", "-6.51833", "-38.41222", "America/Fortaleza"),
("3385873", "Ubajara", "", "BR", "76", "", "06", "2313609", "", "-3.85444", "-40.92111", "America/Fortaleza"),
("3385883", "Uauá", "", "BR", "76", "", "05", "2932002", "", "-9.84139", "-39.48167", "America/Bahia"),
("3385899", "Tutóia", "", "BR", "76", "", "13", "2112506", "", "-2.76194", "-42.27444", "America/Fortaleza"),
("3385908", "Turiaçu", "", "BR", "76", "", "13", "2112407", "", "-1.66333", "-45.37167", "America/Fortaleza"),
("3385920", "Tupanatinga", "", "BR", "76", "", "30", "2615805", "", "-8.75333", "-37.33972", "America/Recife"),
("3385922", "Tuntum", "", "BR", "76", "", "13", "2112308", "", "-5.25806", "-44.64889", "America/Fortaleza"),
("3385935", "Tucuruí", "", "BR", "76", "", "16", "1508100", "", "-3.76585", "-49.67923", "America/Belem"),
("3385980", "Tucumã", "", "BR", "76", "", "16", "1502509", "", "-0.18333", "-50.05", "America/Belem"),
("3386042", "Trindade", "", "BR", "76", "", "30", "2615607", "", "-7.76194", "-40.26778", "America/Recife"),
("3386177", "Trairi", "", "BR", "76", "", "06", "2313500", "", "-3.27778", "-39.26889", "America/Fortaleza"),
("3386198", "Traipu", "", "BR", "76", "", "02", "2709202", "", "-9.97056", "-37.00333", "America/Maceio"),
("3386213", "Touros", "", "BR", "76", "", "22", "2414407", "", "-5.19889", "-35.46083", "America/Fortaleza"),
("3386264", "Toritama", "Торитама", "BR", "76", "", "30", "2615409", "", "-8.00667", "-36.05667", "America/Recife"),
("3386279", "Tomé Açu", "", "BR", "76", "", "16", "1508001", "", "-2.41889", "-48.15222", "America/Belem"),
("3386361", "Timon", "Тимон", "BR", "76", "", "13", "2112209", "", "-5.09417", "-42.83667", "America/Fortaleza"),
("3386372", "Timbiras", "", "BR", "76", "", "13", "2112100", "", "-4.25528", "-43.94056", "America/Fortaleza"),
("3386396", "Timbaúba", "", "BR", "76", "", "30", "2615300", "", "-7.50528", "-35.31833", "America/Recife"),
("3386449", "Tianguá", "", "BR", "76", "", "06", "2313401", "", "-3.73222", "-40.99167", "America/Fortaleza"),
("3386467", "Terra Santa", "", "BR", "76", "", "16", "1507979", "", "-2.10417", "-56.48694", "America/Santarem"),
("3386496", "Teresina", "Терезина", "BR", "76", "", "20", "2211001", "", "-5.08917", "-42.80194", "America/Fortaleza"),
("3386533", "Teixeira", "", "BR", "76", "", "17", "2516706", "", "-7.22278", "-37.25417", "America/Fortaleza"),
("3386567", "São João dos Inhamuns", "", "BR", "76", "", "06", "2313302", "", "-6", "-40.28333", "America/Fortaleza"),
("3386622", "Taquaritinga do Norte", "", "BR", "76", "", "30", "2615003", "", "-7.90306", "-36.04417", "America/Recife"),
("3386628", "Taquarana", "", "BR", "76", "", "02", "2709103", "", "-9.645", "-36.49722", "America/Maceio"),
("3386693", "Taperoá", "", "BR", "76", "", "17", "2516508", "", "-7.2075", "-36.82667", "America/Fortaleza"),
("3386842", "Tangará", "", "BR", "76", "", "22", "2414001", "", "-6.19944", "-35.80167", "America/Fortaleza"),
("3386874", "Tamboril", "", "BR", "76", "", "06", "2313203", "", "-4.83222", "-40.32056", "America/Fortaleza"),
("3386931", "Tamandaré", "", "BR", "76", "BR", "30", "2614857", "", "-8.75632", "-35.09995", "America/Recife"),
("3387082", "Tabira", "", "BR", "76", "", "30", "2614600", "", "-7.59083", "-37.53944", "America/Recife"),
("3387115", "Surubim", "", "BR", "76", "", "30", "2614501", "", "-7.83306", "-35.75472", "America/Recife"),
("3387130", "Sumé", "", "BR", "76", "", "17", "2516300", "", "-7.67167", "-36.88", "America/Fortaleza"),
("3387202", "Sousa", "", "BR", "76", "", "17", "2516201", "", "-6.75917", "-38.22806", "America/Fortaleza"),
("3387204", "Soure", "", "BR", "76", "", "16", "1507904", "", "-0.71667", "-48.52333", "America/Belem"),
("3387258", "Soledade", "", "BR", "76", "", "17", "2516102", "", "-7.05722", "-36.36278", "America/Fortaleza"),
("3387266", "Solânea", "", "BR", "76", "", "17", "2501500", "", "-6.755", "-35.54", "America/Fortaleza"),
("3387296", "Sobral", "Собрал", "BR", "76", "", "06", "2312908", "", "-3.68611", "-40.34972", "America/Fortaleza"),
("3387604", "Sirinhaém", "", "BR", "76", "BR", "30", "2614204", "", "-8.59083", "-35.11611", "America/Recife"),
("3387620", "Simplício Mendes", "", "BR", "76", "", "20", "2210805", "", "-7.85389", "-41.91028", "America/Fortaleza"),
("3387663", "Sertânia", "", "BR", "76", "", "30", "2614105", "", "-8.07361", "-37.26444", "America/Recife"),
("3387786", "Serra Talhada", "", "BR", "76", "", "30", "2613909", "", "-7.99194", "-38.29833", "America/Recife"),
("3387880", "Serra Branca", "", "BR", "76", "", "17", "2517209", "", "-6.53333", "-38.26667", "America/Fortaleza"),
("3387926", "Senador Pompeu", "", "BR", "76", "", "06", "2312700", "", "-5.58806", "-39.37167", "America/Fortaleza"),
("3387928", "Senador José Porfírio", "", "BR", "76", "", "16", "1507805", "", "-2.59083", "-51.95417", "America/Belem"),
("3387987", "Satuba", "", "BR", "76", "", "02", "2708907", "", "-9.56333", "-35.82444", "America/Maceio"),
("3388092", "São Tomé", "", "BR", "76", "", "22", "2412906", "", "-5.9725", "-36.07528", "America/Fortaleza"),
("3388112", "São Sebastião", "", "BR", "76", "", "02", "2708808", "", "-9.93361", "-36.55417", "America/Maceio"),
("3388145", "São Raimundo Nonato", "", "BR", "76", "", "20", "2210607", "", "-9.01528", "-42.69944", "America/Fortaleza"),
("3388147", "São Raimundo das Mangabeiras", "", "BR", "76", "", "13", "2111607", "", "-7.02194", "-45.48111", "America/Fortaleza"),
("3388173", "São Pedro do Piauí", "", "BR", "76", "", "20", "2210508", "", "-5.92944", "-42.71861", "America/Fortaleza"),
("3388238", "São Paulo do Potengi", "", "BR", "76", "", "22", "2412609", "", "-5.895", "-35.76278", "America/Fortaleza"),
("3388266", "São Miguel do Tapuio", "", "BR", "76", "", "20", "2210409", "", "-5.50361", "-41.32333", "America/Fortaleza"),
("3388269", "São Miguel dos Campos", "Сан-Мигель-дус-Кампус", "BR", "76", "", "02", "2708600", "", "-9.78111", "-36.09361", "America/Maceio"),
("3388270", "São Miguel do Guamá", "", "BR", "76", "", "16", "1507607", "", "-1.62667", "-47.48333", "America/Belem"),
("3388304", "São Miguel", "", "BR", "76", "", "22", "2407500", "", "-5.46667", "-35.36667", "America/Fortaleza"),
("3388318", "São Mateus do Maranhão", "", "BR", "76", "", "13", "2111508", "", "-4.04167", "-44.475", "America/Fortaleza"),
("3388341", "São Luís do Quitunde", "", "BR", "76", "", "02", "2708501", "", "-9.31833", "-35.56111", "America/Maceio"),
("3388368", "São Luís", "Сан-Луис", "BR", "76", "", "13", "2111300", "", "-2.52972", "-44.30278", "America/Fortaleza"),
("3388376", "São Lourenço da Mata", "Сан-Лоренсу-да-Мата", "BR", "76", "", "30", "2613701", "", "-8.00222", "-35.01833", "America/Recife"),
("3388435", "São José do Egito", "", "BR", "76", "", "30", "2613602", "", "-7.47889", "-37.27444", "America/Recife"),
("3388437", "São José do Campestre", "", "BR", "76", "", "22", "2412302", "", "-6.31556", "-35.71389", "America/Fortaleza"),
("3388440", "São José do Belmonte", "", "BR", "76", "", "30", "2613503", "", "-7.86139", "-38.75972", "America/Recife"),
("3388441", "São José de Ribamar", "", "BR", "76", "", "13", "2111201", "", "-2.56194", "-44.05417", "America/Fortaleza"),
("3388442", "São José de Piranhas", "", "BR", "76", "", "17", "2514503", "", "-7.12056", "-38.50194", "America/Fortaleza"),
("3388443", "São José de Mipibu", "", "BR", "76", "", "22", "2412203", "", "-6.07472", "-35.23778", "America/Fortaleza"),
("3388447", "São José da Tapera", "", "BR", "76", "", "02", "2708402", "", "-9.55833", "-37.38111", "America/Maceio"),
("3388454", "São José da Laje", "", "BR", "76", "", "02", "2708303", "", "-9.00972", "-36.05833", "America/Maceio"),
("3388456", "São José da Coroa Grande", "", "BR", "76", "", "30", "2613404", "", "-8.89778", "-35.14778", "America/Recife"),
("3388567", "São Joaquim do Monte", "", "BR", "76", "", "30", "2613305", "", "-8.4325", "-35.80444", "America/Recife"),
("3388615", "São João dos Patos", "", "BR", "76", "", "13", "2111102", "", "-6.495", "-43.70222", "America/Fortaleza"),
("3388618", "São João do Piauí", "", "BR", "76", "", "20", "2210003", "", "-8.35806", "-42.24667", "America/Fortaleza"),
("3388626", "São João de Pirabas", "", "BR", "76", "", "16", "1507474", "", "-0.77472", "-47.17722", "America/Belem"),
("3388660", "São João", "", "BR", "76", "", "30", "2613206", "", "-8.87556", "-36.36667", "America/Recife"),
("3388713", "São Gonçalo do Amarante", "", "BR", "76", "", "22", "2412005", "", "-5.79333", "-35.32944", "America/Fortaleza"),
("3388714", "São Gonçalo do Amarante", "", "BR", "76", "", "06", "2312403", "", "-3.60722", "-38.96833", "America/Fortaleza"),
("3388760", "São Geraldo do Araguaia", "", "BR", "76", "", "16", "1507458", "", "-6.40056", "-48.555", "America/Araguaina"),
("3388847", "São Félix do Xingu", "", "BR", "76", "", "16", "1507300", "", "-6.64472", "-51.995", "America/Belem"),
("3388868", "São Domingos do Maranhão", "", "BR", "76", "", "13", "2110708", "", "-5.57583", "-44.38528", "America/Fortaleza"),
("3388926", "São Caetano de Odivelas", "", "BR", "76", "", "16", "1507102", "", "-0.75", "-48.02", "America/Belem"),
("3388949", "São Bernardo", "", "BR", "76", "", "13", "2110609", "", "-3.36139", "-42.41778", "America/Fortaleza"),
("3388991", "São Bento", "", "BR", "76", "", "17", "2504306", "", "-6.28333", "-37.75", "America/Fortaleza"),
("3389006", "São Bento", "Сан-Бенту", "BR", "76", "", "13", "2110500", "", "-2.69583", "-44.82139", "America/Fortaleza"),
("3389012", "São Benedito do Rio Preto", "", "BR", "76", "", "13", "2110401", "", "-3.33361", "-43.52833", "America/Fortaleza"),
("3389062", "Santo Antônio do Tauá", "", "BR", "76", "", "16", "1507003", "", "-1.15194", "-48.12944", "America/Belem"),
("3389134", "Santo Antônio", "", "BR", "76", "", "22", "2411502", "", "-6.31056", "-35.47889", "America/Fortaleza"),
("3389321", "Santa Rita", "", "BR", "76", "", "17", "2513703", "", "-7.11389", "-34.97806", "America/Fortaleza"),
("3389339", "Santa Rita", "", "BR", "76", "", "13", "2112704", "", "-3.86358", "-43.85999", "America/Fortaleza"),
("3389353", "Santarém", "Сантарен", "BR", "76", "", "16", "1506807", "", "-2.44306", "-54.70833", "America/Santarem"),
("3389358", "Santa Quitéria do Maranhão", "", "BR", "76", "", "13", "2110104", "", "-3.51556", "-42.54667", "America/Fortaleza"),
("3389361", "Santa Quitéria", "", "BR", "76", "", "06", "2312205", "", "-4.33194", "-40.15667", "America/Fortaleza"),
("3389380", "Santana do Mundaú", "", "BR", "76", "", "02", "2708105", "", "-9.16806", "-36.22222", "America/Maceio"),
("3389381", "Santana do Matos", "", "BR", "76", "", "22", "2411403", "", "-5.9575", "-36.65556", "America/Fortaleza"),
("3389384", "Santana do Ipanema", "Сантана-ду-Ипанема", "BR", "76", "", "02", "2708006", "", "-9.37833", "-37.24528", "America/Maceio"),
("3389387", "Santana do Acaraú", "", "BR", "76", "", "06", "2312007", "", "-3.46056", "-40.21222", "America/Fortaleza"),
("3389459", "Santa Maria do Pará", "", "BR", "76", "", "16", "1506609", "", "-1.35028", "-47.57556", "America/Belem"),
("3389462", "Santa Maria da Boa Vista", "", "BR", "76", "", "30", "2612604", "", "-8.80778", "-39.82556", "America/Bahia"),
("3389557", "Santa Luzia", "", "BR", "76", "", "13", "2109502", "", "-7.64265", "-47.21738", "America/Fortaleza"),
("3389560", "Santa Luzia", "", "BR", "76", "", "17", "2513406", "", "-6.87222", "-36.91861", "America/Fortaleza"),
("3389609", "Santa Inês", "Санта-Инес", "BR", "76", "", "13", "2109908", "", "-3.66667", "-45.38", "America/Fortaleza"),
("3389622", "Santa Helena", "", "BR", "76", "", "13", "2109809", "", "-2.23111", "-45.3", "America/Fortaleza"),
("3389652", "Santa Cruz do Capibaribe", "", "BR", "76", "", "30", "2612505", "", "-7.9575", "-36.20472", "America/Recife"),
("3389673", "Santa Cruz", "", "BR", "76", "", "22", "2411205", "", "-6.22944", "-36.02278", "America/Fortaleza"),
("3389822", "Salinópolis", "", "BR", "76", "", "16", "1506203", "", "-0.61361", "-47.35611", "America/Belem"),
("3389860", "Salgueiro", "Салгейру", "BR", "76", "", "30", "2612208", "", "-8.07417", "-39.11917", "America/Recife"),
("3390160", "Russas", "", "BR", "76", "", "06", "2311801", "", "-4.94028", "-37.97583", "America/Fortaleza"),
("3390280", "Rio Tinto", "", "BR", "76", "", "17", "2512903", "", "-6.80306", "-35.08056", "America/Fortaleza"),
("3390288", "Rio Largo", "", "BR", "76", "", "02", "2707701", "", "-9.47833", "-35.85333", "America/Maceio"),
("3390295", "Rio Formoso", "", "BR", "76", "", "30", "2611903", "", "-8.66877", "-35.16277", "America/Recife"),
("3390326", "Ribeirão", "", "BR", "76", "BR", "30", "2611804", "", "-8.51444", "-35.37778", "America/Recife"),
("3390581", "Riachão", "", "BR", "76", "", "13", "2109502", "", "-7.36194", "-46.61722", "America/Fortaleza"),
("3390659", "Reriutaba", "", "BR", "76", "", "06", "2311702", "", "-4.14167", "-40.58222", "America/Fortaleza"),
("3390674", "Remígio", "", "BR", "76", "", "17", "2501104", "", "-6.94646", "-35.78039", "America/Fortaleza"),
("3390700", "Regeneração", "", "BR", "76", "", "20", "2208809", "", "-6.23122", "-42.68691", "America/Fortaleza"),
("3390732", "Redenção", "", "BR", "76", "", "06", "2311603", "", "-4.22583", "-38.73056", "America/Fortaleza"),
("3390760", "Recife", "Ресифи", "BR", "76", "", "30", "2611606", "", "-8.05389", "-34.88111", "America/Recife"),
("3390814", "Raposa", "", "BR", "76", "", "13", "2108009", "", "-6.51667", "-44.18333", "America/Fortaleza"),
("3390896", "Quixeré", "", "BR", "76", "", "06", "2311504", "", "-5.07417", "-37.98861", "America/Fortaleza"),
("3390901", "Quixeramobim", "", "BR", "76", "", "06", "2311405", "", "-5.19917", "-39.29278", "America/Fortaleza"),
("3390907", "Quixadá", "", "BR", "76", "", "06", "2311306", "", "-4.97139", "-39.01528", "America/Fortaleza"),
("3390965", "Quipapá", "", "BR", "76", "", "30", "2611507", "", "-8.82778", "-36.01167", "America/Recife"),
("3391090", "Quebrangulo", "", "BR", "76", "", "02", "2707602", "", "-9.31889", "-36.47111", "America/Maceio"),
("3391172", "Princesa Isabel", "", "BR", "76", "", "17", "2512309", "", "-7.73667", "-37.99333", "America/Fortaleza"),
("3391220", "Presidente Dutra", "", "BR", "76", "", "13", "2109106", "", "-5.29", "-44.49", "America/Fortaleza"),
("3391287", "Prainha", "", "BR", "76", "", "16", "1506005", "", "-1.8", "-53.48", "America/Santarem"),
("3391360", "Santana", "Сантана", "BR", "76", "", "03", "1600600", "", "-0.05833", "-51.18167", "America/Belem"),
("3391371", "Porto Franco", "", "BR", "76", "", "13", "2109007", "", "-6.33833", "-47.39917", "America/Araguaina"),
("3391387", "Porto de Moz", "", "BR", "76", "", "16", "1505908", "", "-1.74833", "-52.23833", "America/Santarem"),
("3391395", "Porto da Folha", "", "BR", "76", "", "28", "2805604", "", "-9.91722", "-37.27833", "America/Maceio"),
("3391397", "Porto Calvo", "", "BR", "76", "", "02", "2707305", "", "-9.045", "-35.39833", "America/Maceio"),
("3391408", "Porto", "", "BR", "76", "", "20", "2208502", "", "-3.89333", "-42.71", "America/Fortaleza"),
("3391412", "Portel", "", "BR", "76", "", "16", "1505809", "", "-1.93556", "-50.82111", "America/Belem"),
("3391556", "Pombos", "", "BR", "76", "", "30", "2611309", "", "-8.14139", "-35.39583", "America/Recife"),
("3391571", "Pombal", "", "BR", "76", "", "17", "2512101", "", "-6.77028", "-37.80167", "America/Fortaleza"),
("3391744", "Poço Branco", "", "BR", "76", "", "22", "2410108", "", "-5.62278", "-35.66278", "America/Fortaleza"),
("3391762", "Pocinhos", "", "BR", "76", "", "17", "2512002", "", "-7.07667", "-36.06111", "America/Fortaleza"),
("3391774", "Poção de Pedras", "", "BR", "76", "", "13", "2105203", "", "-4.66667", "-44.85", "America/Fortaleza"),
("3391889", "Pitimbu", "", "BR", "76", "", "17", "2511905", "", "-7.47056", "-34.80861", "America/Fortaleza"),
("3391895", "Pirpirituba", "", "BR", "76", "", "17", "2511806", "", "-6.78", "-35.49861", "America/Fortaleza"),
("3391908", "Piripiri", "", "BR", "76", "", "20", "2208403", "", "-4.27333", "-41.77694", "America/Fortaleza"),
("3391940", "Pirapemas", "", "BR", "76", "", "13", "2108801", "", "-3.72667", "-44.22333", "America/Fortaleza"),
("3391991", "Piracuruca", "", "BR", "76", "", "20", "2208304", "", "-3.92806", "-41.70917", "America/Fortaleza"),
("3392018", "Pio XII", "", "BR", "76", "", "13", "2108702", "", "-3.8325", "-45.1525", "America/Fortaleza"),
("3392054", "Pinheiro", "Пиньейру", "BR", "76", "", "13", "2108603", "", "-2.52139", "-45.0825", "America/Fortaleza"),
("3392088", "Pindaré Mirim", "", "BR", "76", "", "13", "2108504", "", "-3.60833", "-45.34333", "America/Fortaleza"),
("3392126", "Pilar", "Пилар", "BR", "76", "", "02", "2706901", "", "-9.59722", "-35.95667", "America/Maceio"),
("3392127", "Pilar", "", "BR", "76", "", "17", "2511509", "", "-7.26722", "-35.26", "America/Fortaleza"),
("3392145", "Picuí", "", "BR", "76", "", "17", "2511400", "", "-6.51056", "-36.34694", "America/Fortaleza"),
("3392167", "Picos", "Пикус", "BR", "76", "", "20", "2208007", "", "-7.07694", "-41.46694", "America/Fortaleza"),
("3392225", "Piancó", "", "BR", "76", "", "17", "2511301", "", "-7.19806", "-37.92917", "America/Fortaleza"),
("3392242", "Petrolina", "Петролина", "BR", "76", "", "30", "2611101", "", "-9.39861", "-40.50083", "America/Recife"),
("3392243", "Jatobá", "Ятоба", "BR", "76", "", "30", "2608057", "", "-9.18306", "-38.26889", "America/Recife"),
("3392251", "Pesqueira", "", "BR", "76", "", "30", "2610905", "", "-8.35778", "-36.69639", "America/Recife"),
("3392345", "Pentecoste", "", "BR", "76", "", "06", "2310704", "", "-3.79278", "-39.27028", "America/Fortaleza"),
("3392361", "Pendências", "", "BR", "76", "", "22", "2409902", "", "-5.26", "-36.72222", "America/Fortaleza"),
("3392368", "Penalva", "", "BR", "76", "", "13", "2108306", "", "-3.29417", "-45.17361", "America/Fortaleza"),
("3392425", "Pedro Velho", "", "BR", "76", "", "22", "2409803", "", "-6.43917", "-35.22139", "America/Fortaleza"),
("3392431", "Pedro II", "", "BR", "76", "", "20", "2207900", "", "-4.42472", "-41.45861", "America/Fortaleza"),
("3392478", "Pedras de Fogo", "", "BR", "76", "", "17", "2511202", "", "-7.40194", "-35.11639", "America/Recife"),
("3392629", "Pedra Branca", "Педра-Бранка", "BR", "76", "", "06", "2310506", "", "-5.45417", "-39.71722", "America/Fortaleza"),
("3392657", "Pedra", "", "BR", "76", "", "30", "2610806", "", "-8.49694", "-36.94083", "America/Recife"),
("3392731", "Paulo Ramos", "", "BR", "76", "", "13", "2107407", "", "-4.21667", "-45.18333", "America/Fortaleza"),
("3392734", "Paulo Afonso", "", "BR", "76", "", "05", "2924009", "", "-9.40611", "-38.21472", "America/Bahia"),
("3392740", "Paulista", "", "BR", "76", "", "30", "2610707", "", "-7.94083", "-34.87306", "America/Recife"),
("3392862", "Patu", "", "BR", "76", "", "22", "2409308", "", "-6.11", "-37.63667", "America/Fortaleza"),
("3392887", "Patos", "Патус", "BR", "76", "", "17", "2510808", "", "-7.02444", "-37.28", "America/Fortaleza"),
("3392907", "Pastos Bons", "", "BR", "76", "", "13", "2108009", "", "-6.60167", "-44.07667", "America/Fortaleza"),
("3392916", "Passira", "", "BR", "76", "", "30", "2610509", "", "-7.995", "-35.58056", "America/Recife"),
("3392942", "Passagem Franca", "", "BR", "76", "", "13", "2107902", "", "-6.17972", "-43.78361", "America/Fortaleza"),
("3392996", "Parnarama", "", "BR", "76", "", "13", "2107803", "", "-5.68167", "-43.09333", "America/Fortaleza"),
("3392997", "Parnamirim", "", "BR", "76", "", "30", "2610400", "", "-8.09056", "-39.57833", "America/Recife"),
("3392998", "Parnamirim", "Парнамирин", "BR", "76", "", "22", "2403251", "", "-5.91556", "-35.26278", "America/Fortaleza"),
("3393001", "Parnaíba", "Парнаиба", "BR", "76", "", "20", "2207702", "", "-2.90472", "-41.77667", "America/Fortaleza"),
("3393008", "Parintins", "Паринтинса", "BR", "76", "", "04", "1303403", "", "-2.62833", "-56.73583", "America/Manaus"),
("3393017", "Parelhas", "", "BR", "76", "", "22", "2408904", "", "-6.68778", "-36.6575", "America/Fortaleza"),
("3393065", "Parambu", "", "BR", "76", "", "06", "2310308", "", "-6.21111", "-40.69444", "America/Fortaleza"),
("3393091", "Paraipaba", "", "BR", "76", "", "06", "2310258", "", "-3.43944", "-39.14833", "America/Fortaleza"),
("3393095", "Paraibano", "", "BR", "76", "", "13", "2107704", "", "-6.43306", "-43.98361", "America/Fortaleza"),
("3393106", "Paragominas", "", "BR", "76", "", "16", "1505502", "", "-2.96667", "-47.48333", "America/Belem"),
("3393115", "Paracuru", "", "BR", "76", "", "06", "2310209", "", "-3.41", "-39.03056", "America/Fortaleza"),
("3393174", "Pão de Açúcar", "", "BR", "76", "", "02", "2706406", "", "-9.74833", "-37.43667", "America/Maceio"),
("3393264", "Palmares", "", "BR", "76", "", "30", "2610004", "", "-8.68333", "-35.59167", "America/Recife"),
("3393400", "Pacatuba", "", "BR", "76", "", "06", "2309706", "", "-3.98417", "-38.62028", "America/Fortaleza"),
("3393409", "Pacajus", "", "BR", "76", "", "06", "2309607", "", "-4.1725", "-38.46056", "America/Fortaleza"),
("3393452", "Ouricuri", "", "BR", "76", "", "30", "2609907", "", "-7.8825", "-40.08167", "America/Recife"),
("3393455", "Ourém", "", "BR", "76", "", "16", "1505403", "", "-1.55194", "-47.11444", "America/Belem"),
("3393465", "Orós", "", "BR", "76", "", "06", "2309508", "", "-6.24444", "-38.91361", "America/Fortaleza"),
("3393470", "Orobó", "", "BR", "76", "", "30", "2609709", "", "-7.745", "-35.60222", "America/Recife"),
("3393471", "Oriximiná", "", "BR", "76", "", "16", "1505304", "", "-1.76556", "-55.86611", "America/Santarem"),
("3393536", "Olinda", "Олинда", "BR", "76", "", "30", "2609600", "", "-8.00889", "-34.85528", "America/Recife"),
("3393762", "Oeiras do Pará", "", "BR", "76", "", "16", "1505205", "", "-2.00306", "-49.85444", "America/Belem"),
("3393764", "Oeiras", "", "BR", "76", "", "20", "2207009", "", "-7.02528", "-42.13111", "America/Fortaleza"),
("3393766", "Ocara", "", "BR", "76", "", "06", "2309458", "", "-4.49083", "-38.59667", "America/Fortaleza"),
("3393768", "Ábidos", "", "BR", "76", "", "16", "1505106", "", "-1.9175", "-55.51806", "America/Santarem"),
("3393783", "Novo Oriente", "", "BR", "76", "", "06", "2309409", "", "-5.53444", "-40.77417", "America/Fortaleza"),
("3393792", "Novo Lino", "", "BR", "76", "", "02", "2705606", "", "-8.915", "-35.64667", "America/Maceio"),
("3393832", "Nova Russas", "", "BR", "76", "", "06", "2309300", "", "-4.70667", "-40.56306", "America/Fortaleza"),
("3393838", "Nova Olinda do Norte", "", "BR", "76", "", "04", "1303106", "", "-3.89174", "-59.09542", "America/Manaus"),
("3393867", "Nova Floresta", "", "BR", "76", "", "17", "2510105", "", "-6.45528", "-36.20333", "America/Fortaleza"),
("3393876", "Nova Cruz", "", "BR", "76", "", "22", "2408300", "", "-6.47806", "-35.43389", "America/Fortaleza"),
("3393922", "Nísia Floresta", "", "BR", "76", "", "22", "2408201", "", "-6.09111", "-35.20861", "America/Fortaleza"),
("3393929", "Nhamundá", "", "BR", "76", "", "04", "1303007", "", "-2.18611", "-56.71306", "America/Santarem"),
("3393972", "Nazaré da Mata", "Назар-да-Мата", "BR", "76", "", "30", "2609501", "", "-7.74167", "-35.22778", "America/Recife"),
("3394023", "Natal", "Натал", "BR", "76", "", "22", "2408102", "", "-5.795", "-35.20944", "America/Fortaleza"),
("3394116", "Murici", "", "BR", "76", "", "02", "2705507", "", "-9.30667", "-35.94333", "America/Maceio"),
("3394326", "Muaná", "", "BR", "76", "", "16", "1504901", "", "-1.52833", "-49.21667", "America/Belem"),
("3394453", "Moreno", "", "BR", "76", "", "30", "2609402", "", "-8.11861", "-35.09222", "America/Recife"),
("3394500", "Morada Nova", "", "BR", "76", "", "06", "2308708", "", "-5.10667", "-38.3725", "America/Fortaleza"),
("3394549", "Monteiro", "", "BR", "76", "", "17", "2509701", "", "-7.88944", "-37.12", "America/Fortaleza"),
("3394594", "Monte Alegre", "", "BR", "76", "", "22", "2402709", "", "-5.88972", "-36.30139", "America/Fortaleza"),
("3394605", "Monte Alegre", "Монти-Алегри", "BR", "76", "", "16", "1504802", "", "-2.00082", "-54.08102", "America/Santarem"),
("3394612", "Montanhas", "", "BR", "76", "", "22", "2407708", "", "-6.48583", "-35.2875", "America/Fortaleza"),
("3394640", "Monção", "", "BR", "76", "", "13", "2106904", "", "-3.49167", "-45.25111", "America/Fortaleza"),
("3394649", "Mombaça", "", "BR", "76", "", "06", "2308500", "", "-5.74306", "-39.6275", "America/Fortaleza"),
("3394661", "Moju", "", "BR", "76", "", "16", "1504703", "", "-1.88389", "-48.76889", "America/Belem"),
("3394682", "Mossoró", "Мосоро", "BR", "76", "", "22", "2408003", "", "-5.1875", "-37.34417", "America/Fortaleza"),
("3394745", "Mocajuba", "", "BR", "76", "", "16", "1504604", "", "-2.58417", "-49.50722", "America/Belem"),
("3394755", "Missão Velha", "", "BR", "76", "", "06", "2308401", "", "-7.24972", "-39.14306", "America/Fortaleza"),
("3394813", "Mirador", "", "BR", "76", "", "13", "2106706", "", "-6.37083", "-44.36306", "America/Fortaleza"),
("3394884", "Milagres", "", "BR", "76", "", "06", "2308302", "", "-7.31333", "-38.94556", "America/Fortaleza"),
("3394892", "Miguel Alves", "", "BR", "76", "", "20", "2206209", "", "-4.16556", "-42.89528", "America/Fortaleza"),
("3394908", "Messias", "", "BR", "76", "", "02", "2705200", "", "-9.38333", "-35.84167", "America/Maceio"),
("3395042", "Mazagão", "", "BR", "76", "", "03", "1600402", "", "-0.115", "-51.28944", "America/Belem"),
("3395062", "Maués", "", "BR", "76", "", "04", "1302900", "", "-3.38361", "-57.71861", "America/Manaus"),
("3395077", "Matriz de Camaragibe", "", "BR", "76", "", "02", "2705101", "", "-9.15167", "-35.53333", "America/Maceio"),
("3395122", "Matinha", "", "BR", "76", "", "13", "2106508", "", "-3.10056", "-45.03361", "America/Fortaleza"),
("3395336", "Maribondo", "", "BR", "76", "", "02", "2704807", "", "-9.57722", "-36.30528", "America/Maceio"),
("3395380", "Mari", "", "BR", "76", "", "17", "2509107", "", "-7.06", "-35.31944", "America/Fortaleza"),
("3395395", "Marechal Deodoro", "", "BR", "76", "", "02", "2704708", "", "-9.71028", "-35.895", "America/Maceio"),
("3395404", "Marco", "", "BR", "76", "", "06", "2307809", "", "-3.12389", "-40.14667", "America/Fortaleza"),
("3395440", "Marapanim", "", "BR", "76", "", "16", "1504406", "", "-0.7175", "-47.69972", "America/Belem"),
("3395456", "Maraial", "", "BR", "76", "", "30", "2609204", "", "-8.7825", "-35.80889", "America/Recife"),
("3395458", "Maragogi", "", "BR", "76", "", "02", "2704500", "", "-9.01222", "-35.2225", "America/Maceio"),
("3395473", "Maracanaú", "", "BR", "76", "", "06", "2307650", "", "-3.87667", "-38.62556", "America/Fortaleza"),
("3395483", "Maracanã", "", "BR", "76", "", "16", "1504307", "", "-0.76614", "-47.45371", "America/Belem"),
("3395497", "Maracaçumé", "", "BR", "76", "", "13", "2106326", "", "-2.04278", "-45.95917", "America/Fortaleza"),
("3395503", "Marabá", "Мараба", "BR", "76", "", "16", "1504208", "", "-5.38146", "-49.13232", "America/Belem"),
("3395717", "Mamanguape", "", "BR", "76", "", "17", "2508901", "", "-6.83861", "-35.12611", "America/Fortaleza"),
("3395880", "Major Isidoro", "", "BR", "76", "", "02", "2704401", "", "-9.53222", "-36.985", "America/Maceio"),
("3395981", "Maceió", "Масейо", "BR", "76", "", "02", "2704302", "", "-9.66583", "-35.73528", "America/Maceio"),
("3395998", "Macau", "", "BR", "76", "", "22", "2407203", "", "-5.115", "-36.63444", "America/Fortaleza"),
("3396009", "Macaparana", "", "BR", "76", "", "30", "2609006", "", "-7.55472", "-35.45306", "America/Recife"),
("3396016", "Macapá", "Макапа", "BR", "76", "", "03", "1600303", "", "0.03889", "-51.06639", "America/Belem"),
("3396048", "Macaíba", "", "BR", "76", "", "22", "2407104", "", "-5.85833", "-35.35389", "America/Fortaleza"),
("3396101", "Luzilândia", "", "BR", "76", "", "20", "2205805", "", "-3.45778", "-42.37028", "America/Fortaleza"),
("3396121", "Luís Correia", "", "BR", "76", "", "20", "2205706", "", "-2.87917", "-41.66694", "America/Fortaleza"),
("3396266", "Limoeiro do Norte", "", "BR", "76", "", "06", "2307601", "", "-5.14556", "-38.09806", "America/Fortaleza"),
("3396277", "Limoeiro", "", "BR", "76", "", "30", "2608909", "", "-7.87472", "-35.45028", "America/Recife"),
("3396364", "Lavras da Mangabeira", "", "BR", "76", "", "06", "2307502", "", "-6.75333", "-38.96444", "America/Fortaleza"),
("3396496", "Lajedo", "Лажеду", "BR", "76", "", "30", "2608800", "", "-8.66361", "-36.32", "America/Recife"),
("3396601", "Lago da Pedra", "Лаго-да-Педра", "BR", "76", "", "13", "2113009", "", "-4.28674", "-45.23824", "America/Fortaleza"),
("3396620", "Lagoa Seca", "", "BR", "76", "", "17", "2508307", "", "-7.17083", "-35.85361", "America/Fortaleza"),
("3396662", "Lagoa Nova", "", "BR", "76", "", "22", "2406502", "", "-6.1", "-36.48333", "America/Fortaleza"),
("3396769", "Lagoa do Itaenga", "", "BR", "76", "", "30", "2608503", "", "-7.93611", "-35.29028", "America/Recife"),
("3396877", "Lagoa da Canoa", "", "BR", "76", "", "02", "2704104", "", "-9.82972", "-36.73778", "America/Maceio"),
("3396979", "Juruti", "", "BR", "76", "", "16", "1503903", "", "-2.15222", "-56.09222", "America/Santarem"),
("3397008", "Juripiranga", "", "BR", "76", "", "17", "2507903", "", "-7.37333", "-35.23806", "America/Fortaleza"),
("3397063", "Junqueiro", "", "BR", "76", "", "02", "2704005", "", "-9.92528", "-36.47583", "America/Maceio"),
("3397108", "Jucurutu", "", "BR", "76", "", "22", "2406106", "", "-6.03389", "-37.02028", "America/Fortaleza"),
("3397119", "Jucás", "", "BR", "76", "", "06", "2307403", "", "-6.52528", "-39.5275", "America/Fortaleza"),
("3397147", "Juazeiro do Norte", "Жуазейру-ду-Норти", "BR", "76", "", "06", "2307304", "", "-7.21306", "-39.31528", "America/Fortaleza"),
("3397175", "Juàzeirinho", "", "BR", "76", "", "17", "2500775", "", "-6.81667", "-38.05", "America/Fortaleza"),
("3397230", "José de Freitas", "", "BR", "76", "", "20", "2205508", "", "-4.75639", "-42.57556", "America/Fortaleza"),
("3397262", "Joaquim Nabuco", "", "BR", "76", "", "30", "2608206", "", "-8.62444", "-35.53333", "America/Recife"),
("3397277", "João Pessoa", "Жуан-Песоа", "BR", "76", "", "17", "2507507", "", "-7.115", "-34.86306", "America/Fortaleza"),
("3397315", "João Câmara", "", "BR", "76", "", "22", "2405801", "", "-5.5375", "-35.81972", "America/Fortaleza"),
("3397319", "João Alfredo", "", "BR", "76", "", "30", "2608107", "", "-7.85583", "-35.58833", "America/Recife"),
("3397337", "Girau do Ponciano", "", "BR", "76", "", "02", "2702900", "", "-9.88417", "-36.82889", "America/Maceio"),
("3397560", "Jardim do Seridó", "", "BR", "76", "", "22", "2405702", "", "-6.58444", "-36.77444", "America/Fortaleza"),
("3397562", "Jardim de Piranhas", "", "BR", "76", "", "22", "2405603", "", "-6.37861", "-37.35194", "America/Fortaleza"),
("3397590", "Jardim", "", "BR", "76", "", "06", "2310209", "", "-3.46444", "-39.05667", "America/Fortaleza"),
("3397660", "Jaicós", "", "BR", "76", "", "20", "2205201", "", "-7.35917", "-41.13778", "America/Fortaleza"),
("3397665", "Jaguaruana", "", "BR", "76", "", "06", "2307007", "", "-4.83389", "-37.78111", "America/Fortaleza"),
("3397675", "Jaguaribe", "Жагуариби", "BR", "76", "", "06", "2306900", "", "-5.89056", "-38.62194", "America/Fortaleza"),
("3397800", "Jacaraú", "", "BR", "76", "", "17", "2507309", "", "-6.61222", "-35.29278", "America/Fortaleza"),
("3397838", "Jaboatão", "", "BR", "76", "", "30", "2607901", "", "-8.18028", "-35.00139", "America/Recife"),
("3397851", "Itupiranga", "", "BR", "76", "", "16", "1503705", "", "-5.13472", "-49.32667", "America/Belem"),
("3397865", "Itaueira", "", "BR", "76", "", "20", "2205102", "", "-7.60333", "-43.02556", "America/Fortaleza"),
("3397886", "Itaquitinga", "", "BR", "76", "", "30", "2607802", "", "-7.66778", "-35.10167", "America/Recife"),
("3397893", "Itacoatiara", "", "BR", "76", "BR", "04", "1301902", "", "-3.14306", "-58.44417", "America/Manaus"),
("3397898", "Itaporanga", "", "BR", "76", "", "17", "2507002", "", "-7.30444", "-38.15028", "America/Fortaleza"),
("3397904", "Itapissuma", "", "BR", "76", "", "30", "2607752", "", "-7.77639", "-34.89222", "America/Recife"),
("3397909", "Itapipoca", "Итапипока", "BR", "76", "", "06", "2306405", "", "-3.49444", "-39.57861", "America/Fortaleza"),
("3397936", "Itapecuru Mirim", "", "BR", "76", "", "13", "2105401", "", "-3.3925", "-44.35861", "America/Fortaleza"),
("3397941", "Itapagé", "", "BR", "76", "", "06", "2306306", "", "-3.68667", "-39.58611", "America/Fortaleza"),
("3397963", "Itamaracá", "", "BR", "76", "", "30", "2607604", "", "-7.74778", "-34.82556", "America/Noronha"),
("3397967", "Itaituba", "", "BR", "76", "", "16", "1503606", "", "-4.27611", "-55.98361", "America/Santarem"),
("3397969", "Itaitinga", "", "BR", "76", "", "06", "2306256", "", "-3.96944", "-38.52806", "America/Fortaleza"),
("3397983", "Itaíba", "", "BR", "76", "", "30", "2607505", "", "-8.9475", "-37.42278", "America/Recife"),
("3398003", "Itabaiana", "", "BR", "76", "", "17", "2506905", "", "-7.32861", "-35.3325", "America/Fortaleza"),
("3398014", "Irituia", "", "BR", "76", "", "16", "1503507", "", "-1.77111", "-47.43806", "America/Belem"),
("3398028", "Irauçuba", "", "BR", "76", "", "06", "2306108", "", "-3.74611", "-39.78333", "America/Fortaleza"),
("3398076", "Ipueiras", "", "BR", "76", "", "06", "", "", "-7.03333", "-40.45", "America/Fortaleza"),
("3398105", "Ipubi", "", "BR", "76", "", "30", "2607307", "", "-7.65194", "-40.14889", "America/Recife"),
("3398112", "Ipu", "", "BR", "76", "", "06", "2305803", "", "-4.32222", "-40.71083", "America/Fortaleza"),
("3398115", "Ipojuca", "Ипожука", "BR", "76", "", "30", "2607208", "", "-8.39889", "-35.06389", "America/Recife"),
("3398178", "Inhuma", "", "BR", "76", "", "20", "2204709", "", "-6.66833", "-41.70778", "America/Fortaleza"),
("3398192", "Inhapi", "", "BR", "76", "", "02", "2703304", "", "-9.22139", "-37.74861", "America/Maceio"),
("3398224", "Ingá", "", "BR", "76", "", "17", "2506806", "", "-7.28083", "-35.60444", "America/Fortaleza"),
("3398255", "Independência", "", "BR", "76", "", "06", "2305605", "", "-5.39639", "-40.30861", "America/Fortaleza"),
("3398269", "Imperatriz", "Императрис", "BR", "76", "", "13", "2105302", "", "-5.52639", "-47.49167", "America/Fortaleza"),
("3398331", "Iguatu", "", "BR", "76", "", "06", "2305506", "", "-6.35944", "-39.29861", "America/Fortaleza"),
("3398343", "Igarapé Miri", "", "BR", "76", "", "16", "1503309", "", "-1.975", "-48.95972", "America/Belem"),
("3398350", "Igarapé Açu", "", "BR", "76", "", "16", "1503200", "", "-1.12889", "-47.62", "America/Belem"),
("3398352", "Igarassu", "", "BR", "76", "", "30", "2606804", "", "-7.83417", "-34.90639", "America/Recife"),
("3398355", "Igaci", "", "BR", "76", "", "02", "2703106", "", "-9.53694", "-36.63361", "America/Maceio"),
("3398379", "Icó", "", "BR", "76", "", "06", "2305407", "", "-6.40111", "-38.86222", "America/Fortaleza"),
("3398401", "Ibimirim", "", "BR", "76", "", "30", "2606606", "", "-8.54056", "-37.69028", "America/Recife"),
("3398408", "Ibiapina", "", "BR", "76", "", "06", "2305308", "", "-3.92333", "-40.88944", "America/Fortaleza"),
("3398412", "Ibateguara", "", "BR", "76", "", "02", "2703007", "", "-8.9725", "-35.93944", "America/Maceio"),
("3398428", "Humberto de Campos", "", "BR", "76", "", "13", "2105005", "", "-2.59833", "-43.46111", "America/Fortaleza"),
("3398450", "Horizonte", "", "BR", "76", "", "06", "2305233", "", "-4.1", "-38.48333", "America/Fortaleza"),
("3398457", "Hidrolândia", "", "BR", "76", "", "06", "2305209", "", "-4.40806", "-40.43778", "America/Fortaleza"),
("3398480", "Gurupá", "", "BR", "76", "", "16", "1503101", "", "-1.405", "-51.64", "America/Belem"),
("3398485", "Gurinhém", "", "BR", "76", "", "17", "2506400", "", "-7.12389", "-35.42444", "America/Fortaleza"),
("3398569", "Guaraciaba do Norte", "", "BR", "76", "", "06", "2305001", "", "-4.16694", "-40.7475", "America/Fortaleza"),
("3398570", "Guarabira", "", "BR", "76", "", "17", "2506301", "", "-6.85472", "-35.49", "America/Fortaleza"),
("3398612", "Guajará", "", "BR", "76", "", "04", "1300680", "", "-2.96667", "-57.66667", "America/Manaus"),
("3398614", "Guaiúba", "", "BR", "76", "", "06", "2304954", "", "-4.03972", "-38.63722", "America/Fortaleza"),
("3398622", "Guabiraba", "", "BR", "76", "", "30", "2601300", "", "-8.41667", "-35.66667", "America/Recife"),
("3398691", "Gravatá", "", "BR", "76", "", "30", "2606408", "", "-8.20111", "-35.56472", "America/Recife"),
("3398706", "Granja", "", "BR", "76", "", "06", "2304707", "", "-3.12028", "-40.82611", "America/Fortaleza"),
("3398856", "Grajaú", "", "BR", "76", "", "13", "2104800", "", "-5.81944", "-46.13861", "America/Fortaleza"),
("3398871", "Governador Dix Sept Rosado", "", "BR", "76", "", "22", "2404309", "", "-5.45889", "-37.52083", "America/Fortaleza"),
("3398902", "Goianinha", "", "BR", "76", "", "22", "2404200", "", "-6.26472", "-35.2125", "America/Fortaleza"),
("3398904", "Goiana", "Гояна", "BR", "76", "", "30", "2606200", "", "-7.56056", "-35.0025", "America/Recife"),
("3398920", "Glória do Goitá", "", "BR", "76", "", "30", "2606101", "", "-8.00167", "-35.29278", "America/Recife"),
("3399058", "Garanhuns", "Гараньюнс", "BR", "76", "", "30", "2606002", "", "-8.88202", "-36.50216", "America/Recife"),
("3399132", "Gameleira", "", "BR", "76", "", "30", "2605905", "", "-8.58444", "-35.38667", "America/Recife"),
("3399377", "Fortuna", "", "BR", "76", "", "13", "2104206", "", "-5.73333", "-44.15833", "America/Fortaleza"),
("3399415", "Fortaleza", "Форталеза", "BR", "76", "BR", "06", "2304400", "", "-3.71722", "-38.54306", "America/Fortaleza"),
("3399445", "Forquilha", "", "BR", "76", "", "06", "2304350", "", "-3.79833", "-40.26056", "America/Fortaleza"),
("3399506", "Floriano", "Флориан", "BR", "76", "", "20", "2203909", "", "-6.76694", "-43.0225", "America/Fortaleza"),
("3399518", "Floresta", "", "BR", "76", "", "30", "2605707", "", "-8.60111", "-38.56861", "America/Recife"),
("3399539", "Flores", "", "BR", "76", "", "30", "2605608", "", "-7.86806", "-37.97472", "America/Recife"),
("3399571", "Flexeiras", "", "BR", "76", "", "02", "2702801", "", "-9.1975", "-35.78083", "America/Maceio"),
("3399679", "Feira Nova", "", "BR", "76", "", "30", "2605400", "", "-7.95083", "-35.38917", "America/Recife"),
("3400497", "Farias Brito", "", "BR", "76", "", "06", "2304301", "", "-6.93056", "-39.56556", "America/Fortaleza"),
("3400515", "Fagundes", "", "BR", "76", "", "17", "2506103", "", "-7.355", "-35.775", "America/Fortaleza"),
("3400541", "Exu", "", "BR", "76", "", "30", "2605301", "", "-7.51194", "-39.72417", "America/Recife"),
("3400558", "Eusébio", "Эусебио", "BR", "76", "", "06", "2304285", "", "-3.89", "-38.45056", "America/Fortaleza"),
("3400567", "Extremoz", "Эстремос", "BR", "76", "", "22", "2403608", "", "-5.70556", "-35.30722", "America/Fortaleza"),
("3400617", "Estreito", "", "BR", "76", "", "13", "2107803", "", "-5.78333", "-43.25", "America/Fortaleza"),
("3400739", "Esperantinópolis", "", "BR", "76", "", "13", "2104008", "", "-4.86667", "-44.70833", "America/Fortaleza"),
("3400740", "Esperantina", "", "BR", "76", "", "20", "2203701", "", "-3.90167", "-42.23361", "America/Fortaleza"),
("3400752", "Esperança", "", "BR", "76", "", "17", "2506004", "", "-7.03306", "-35.85722", "America/Fortaleza"),
("3400804", "Escada", "", "BR", "76", "", "30", "2605202", "", "-8.35917", "-35.22361", "America/Recife"),
("3400920", "Elesbão Veloso", "", "BR", "76", "", "20", "2203503", "", "-6.20194", "-42.14028", "America/Fortaleza"),
("3400969", "Dom Pedro", "", "BR", "76", "", "13", "2106003", "", "-5.03749", "-44.43857", "America/Fortaleza"),
("3401060", "Desterro", "", "BR", "76", "", "17", "2505402", "", "-7.29056", "-37.09389", "America/Fortaleza"),
("3401106", "Demerval Lobão", "", "BR", "76", "", "20", "2203305", "", "-5.35833", "-42.67639", "America/Fortaleza"),
("3401109", "Delmiro Gouveia", "", "BR", "76", "", "02", "2702405", "", "-9.38861", "-37.99917", "America/Maceio"),
("3401138", "Custódia", "", "BR", "76", "", "30", "2605103", "", "-8.0875", "-37.64306", "America/Recife"),
("3401148", "Cururupu", "", "BR", "76", "", "13", "2103703", "", "-1.82833", "-44.86833", "America/Fortaleza"),
("3401188", "Curuçá", "", "BR", "76", "", "16", "1502905", "", "-0.72889", "-47.84806", "America/Belem"),
("3401283", "Currais Novos", "Куррайс-Новус", "BR", "76", "", "22", "2403103", "", "-6.26083", "-36.51778", "America/Fortaleza"),
("3401331", "Curaçá", "", "BR", "76", "", "05", "2909901", "", "-8.99028", "-39.90944", "America/Bahia"),
("3401340", "Cupira", "", "BR", "76", "", "30", "2605004", "", "-8.61667", "-35.95", "America/Recife"),
("3401404", "Cumaru", "", "BR", "76", "", "30", "2604908", "", "-8.00611", "-35.69722", "America/Recife"),
("3401419", "Cuité", "", "BR", "76", "", "17", "2505105", "", "-6.48361", "-36.15361", "America/Fortaleza"),
("3401457", "Cruz do Espírito Santo", "", "BR", "76", "", "17", "2504900", "", "-7.14", "-35.08639", "America/Fortaleza"),
("3401487", "Cruz", "", "BR", "76", "", "06", "2304251", "", "-2.9211", "-40.17589", "America/Fortaleza"),
("3401545", "Crato", "Крату", "BR", "76", "", "06", "2304202", "", "-7.23417", "-39.40944", "America/Fortaleza"),
("3401548", "Crateús", "", "BR", "76", "", "06", "2304103", "", "-5.17833", "-40.6775", "America/Fortaleza"),
("3401703", "Coroatá", "", "BR", "76", "", "13", "2103604", "", "-4.13", "-44.12417", "America/Fortaleza"),
("3401725", "Coremas", "", "BR", "76", "", "17", "2504801", "", "-7.01444", "-37.94583", "America/Fortaleza"),
("3401729", "Coreaú", "", "BR", "76", "", "06", "2304004", "", "-3.53333", "-40.65667", "America/Fortaleza"),
("3401830", "Condado", "", "BR", "76", "", "30", "2604601", "", "-7.58583", "-35.10583", "America/Recife"),
("3401845", "Conceição do Araguaia", "", "BR", "76", "", "16", "1502707", "", "-8.26441", "-49.26982", "America/Belem"),
("3401944", "Colônia Leopoldina", "", "BR", "76", "", "02", "", "", "-8.90889", "-35.725", "America/Recife"),
("3401963", "Colinas", "Колинас", "BR", "76", "", "13", "2103505", "", "-6.02583", "-44.24917", "America/Fortaleza"),
("3401992", "Coelho Neto", "", "BR", "76", "", "13", "2103406", "", "-4.25667", "-43.01278", "America/Fortaleza"),
("3402000", "Codó", "", "BR", "76", "", "13", "2103307", "", "-4.45528", "-43.88556", "America/Fortaleza"),
("3402050", "Cocal", "", "BR", "76", "", "20", "2202703", "", "-3.47194", "-41.5575", "America/Fortaleza"),
("3402164", "Chorozinho", "", "BR", "76", "", "06", "2303956", "", "-4.30028", "-38.49778", "America/Fortaleza"),
("3402229", "Chapadinha", "", "BR", "76", "", "13", "2103208", "", "-3.74167", "-43.36028", "America/Fortaleza"),
("3402271", "Chã Grande", "", "BR", "76", "", "30", "2604502", "", "-8.23833", "-35.46167", "America/Recife"),
("3402340", "Cedro", "", "BR", "76", "", "06", "2303808", "", "-6.60667", "-39.06222", "America/Fortaleza"),
("3402360", "Ceará Mirim", "", "BR", "76", "", "22", "2402600", "", "-5.63444", "-35.42556", "America/Fortaleza"),
("3402383", "Caxias", "", "BR", "76", "BR", "13", "2103000", "", "-4.85889", "-43.35611", "America/Fortaleza"),
("3402429", "Caucaia", "", "BR", "76", "", "06", "2303709", "", "-3.73611", "-38.65306", "America/Fortaleza"),
("3402465", "Catolé do Rocha", "", "BR", "76", "", "17", "2504306", "", "-6.34389", "-37.74667", "America/Fortaleza"),
("3402528", "Catende", "", "BR", "76", "", "30", "2604205", "", "-8.66667", "-35.71667", "America/Recife"),
("3402548", "Castelo do Piauí", "", "BR", "76", "", "20", "2202604", "", "-5.32222", "-41.5525", "America/Fortaleza"),
("3402591", "Castanhal", "", "BR", "76", "", "16", "1502400", "", "-1.29389", "-47.92639", "America/Belem"),
("3402613", "Cascavel", "", "BR", "76", "", "06", "2303501", "", "-4.13306", "-38.24194", "America/Fortaleza"),
("3402648", "Carutapera", "", "BR", "76", "", "13", "2102903", "", "-1.195", "-46.02", "America/Fortaleza"),
("3402655", "Caruaru", "Каруару", "BR", "76", "", "30", "2604106", "", "-8.28333", "-35.97611", "America/Recife"),
("3402721", "Carpina", "Карпина", "BR", "76", "", "30", "2604007", "", "-7.85083", "-35.25472", "America/Recife"),
("3402724", "Carolina", "Каролина", "BR", "76", "", "13", "2102804", "", "-7.33561", "-47.46218", "America/Fortaleza"),
("3402848", "Carnaíba", "", "BR", "76", "", "30", "2606606", "", "-8.7", "-37.66667", "America/Recife"),
("3402882", "Caririaçu", "", "BR", "76", "", "06", "2303204", "", "-7.04222", "-39.28361", "America/Fortaleza"),
("3402893", "Cariré", "", "BR", "76", "", "06", "2303105", "", "-3.95056", "-40.47333", "America/Fortaleza"),
("3402920", "Careiro da Várzea", "", "BR", "76", "", "04", "1301159", "", "-3.19695", "-59.82674", "America/Manaus"),
("3402944", "Caraúbas", "", "BR", "76", "", "22", "2402303", "", "-5.7925", "-37.55667", "America/Fortaleza"),
("3403127", "Capitão Poço", "", "BR", "76", "", "16", "1502301", "", "-1.74639", "-47.05944", "America/Belem"),
("3403200", "Capela", "", "BR", "76", "", "02", "2701704", "", "-9.4075", "-36.07361", "America/Maceio"),
("3403208", "Capanema", "", "BR", "76", "", "16", "1502202", "", "-1.19583", "-47.18083", "America/Belem"),
("3403251", "Canto do Buriti", "", "BR", "76", "", "20", "2202307", "", "-8.11", "-42.94444", "America/Fortaleza"),
("3403309", "Cantanhede", "", "BR", "76", "", "13", "2102705", "", "-3.63333", "-44.37667", "America/Fortaleza"),
("3403344", "Canindé de São Francisco", "", "BR", "76", "", "28", "2801207", "", "-9.66", "-37.78944", "America/Maceio"),
("3403353", "Canindé", "", "BR", "76", "", "06", "2302800", "", "-4.35889", "-39.31167", "America/Fortaleza"),
("3403360", "Canhotinho", "", "BR", "76", "", "30", "2603702", "", "-8.88222", "-36.19111", "America/Recife"),
("3403362", "Canguaretama", "Кангуаретама", "BR", "76", "", "22", "2402204", "", "-6.38", "-35.12889", "America/Fortaleza"),
("3403395", "Cândido Mendes", "", "BR", "76", "", "13", "2102606", "", "-1.44667", "-45.71667", "America/Fortaleza"),
("3403534", "Campos Sales", "", "BR", "76", "", "06", "2302701", "", "-7.07444", "-40.37611", "America/Fortaleza"),
("3403566", "Campo Maior", "", "BR", "76", "", "20", "2202208", "", "-4.82778", "-42.16861", "America/Fortaleza"),
("3403611", "Campo Alegre", "", "BR", "76", "", "02", "2701407", "", "-9.78194", "-36.35083", "America/Maceio"),
("3403642", "Campina Grande", "Кампина-Гранде", "BR", "76", "", "17", "2504009", "", "-7.23056", "-35.88111", "America/Fortaleza"),
("3403685", "Camocim de São Félix", "", "BR", "76", "", "30", "2603504", "", "-8.35861", "-35.76194", "America/Recife"),
("3403687", "Camocim", "", "BR", "76", "", "06", "2302602", "", "-2.90222", "-40.84111", "America/Fortaleza"),
("3403697", "Cametá", "", "BR", "76", "", "16", "1502103", "", "-2.24444", "-49.49583", "America/Belem"),
("3403941", "Cajueiro", "", "BR", "76", "", "02", "2704203", "", "-9.71667", "-36.45", "America/Maceio"),
("3404020", "Cajazeiras", "Кажазейрас", "BR", "76", "", "17", "2503704", "", "-6.89028", "-38.55528", "America/Fortaleza"),
("3404117", "Caicó", "Кайко", "BR", "76", "", "22", "2402006", "", "-6.45833", "-37.09778", "America/Fortaleza"),
("3404231", "Caetés", "", "BR", "76", "", "30", "2603207", "", "-8.77306", "-36.6225", "America/Recife"),
("3404306", "Cacimba de Dentro", "", "BR", "76", "", "17", "2503506", "", "-6.64167", "-35.79", "America/Fortaleza"),
("3404355", "Cachoeirinha", "", "BR", "76", "", "30", "2603108", "", "-8.48639", "-36.23306", "America/Recife"),
("3404513", "Cabrobó", "", "BR", "76", "", "30", "2603009", "", "-8.51417", "-39.31", "America/Recife"),
("3404545", "Cabo", "", "BR", "76", "", "30", "2602902", "", "-8.28333", "-35.03333", "America/Recife"),
("3404558", "Cabedelo", "", "BR", "76", "", "17", "2503209", "", "-6.98111", "-34.83389", "America/Fortaleza"),
("3404656", "Caaporã", "", "BR", "76", "", "17", "2503001", "", "-7.51556", "-34.90833", "America/Fortaleza"),
("3404713", "Buriti dos Lopes", "", "BR", "76", "", "20", "2202000", "", "-3.175", "-41.86694", "America/Fortaleza"),
("3404722", "Buriti Bravo", "", "BR", "76", "", "13", "2102309", "", "-5.83722", "-43.83361", "America/Fortaleza"),
("3404760", "Bujaru", "", "BR", "76", "", "16", "1501907", "", "-1.515", "-48.04472", "America/Belem"),
("3404766", "Buíque", "Буики", "BR", "76", "", "30", "2602803", "", "-8.62306", "-37.15583", "America/Recife"),
("3404817", "Breves", "", "BR", "76", "", "16", "1501808", "", "-1.68222", "-50.48028", "America/Belem"),
("3404833", "Brejo Santo", "", "BR", "76", "", "06", "2302503", "", "-7.49333", "-38.98722", "America/Fortaleza"),
("3404862", "Brejo da Madre de Deus", "", "BR", "76", "", "30", "2602605", "", "-8.14583", "-36.37111", "America/Recife"),
("3404889", "Brejo", "", "BR", "76", "", "13", "2102101", "", "-3.68444", "-42.75028", "America/Fortaleza"),
("3404924", "Brejinho", "", "BR", "76", "", "22", "2401800", "", "-6.19083", "-35.35667", "America/Fortaleza"),
("3405006", "Bragança", "", "BR", "76", "", "16", "1501709", "", "-1.05361", "-46.76556", "America/Belem"),
("3405051", "Borba", "", "BR", "76", "", "04", "1300805", "", "-4.39143", "-59.58864", "America/Manaus"),
("3405061", "Boqueirão", "", "BR", "76", "", "17", "2502508", "", "-7.48237", "-36.13422", "America/Fortaleza"),
("3405172", "Bonito", "", "BR", "76", "", "30", "2602308", "", "-8.47028", "-35.72861", "America/Recife"),
("3405304", "Bom Jesus", "", "BR", "76", "", "20", "2201903", "", "-9.07444", "-44.35861", "America/Fortaleza"),
("3405339", "Bom Jardim", "", "BR", "76", "", "30", "2602209", "", "-7.79583", "-35.58722", "America/Recife"),
("3405341", "Bom Jardim", "", "BR", "76", "", "13", "2104073", "", "-7.01667", "-46.48333", "America/Fortaleza"),
("3405380", "Bom Conselho", "", "BR", "76", "", "30", "2602100", "", "-9.16972", "-36.67972", "America/Recife"),
("3405616", "Boa Viagem", "", "BR", "76", "", "06", "2302404", "", "-5.1275", "-39.73222", "America/Fortaleza"),
("3405738", "Bezerros", "Безеррус", "BR", "76", "", "30", "2601904", "", "-8.23333", "-35.79694", "America/Recife"),
("3405778", "Bequimão", "", "BR", "76", "", "13", "2101905", "", "-2.44889", "-44.7825", "America/Fortaleza"),
("3405792", "Benevides", "", "BR", "76", "", "16", "1501501", "", "-1.36139", "-48.24472", "America/Belem"),
("3405796", "Beneditinos", "", "BR", "76", "", "20", "2201606", "", "-5.45", "-42.36667", "America/Fortaleza"),
("3405812", "Belo Jardim", "", "BR", "76", "", "30", "2601706", "", "-8.33556", "-36.42417", "America/Recife"),
("3405851", "Belém do Brejo do Cruz", "", "BR", "76", "", "17", "2502003", "", "-6.18861", "-37.53583", "America/Fortaleza"),
("3405852", "Belém de São Francisco", "", "BR", "76", "", "30", "2601607", "", "-8.75389", "-38.96583", "America/Recife"),
("3405863", "Belém", "Белем", "BR", "76", "", "17", "2501906", "", "-6.69167", "-35.53333", "America/Fortaleza"),
("3405870", "Belém", "Белен", "BR", "76", "", "16", "1501402", "", "-1.45583", "-48.50444", "America/Belem"),
("3405908", "Bela Cruz", "", "BR", "76", "", "06", "2302305", "", "-3.05056", "-40.16778", "America/Fortaleza"),
("3405924", "Beberibe", "Беберибе", "BR", "76", "", "06", "2302206", "", "-4.17972", "-38.13056", "America/Fortaleza"),
("3405940", "Bayeux", "", "BR", "76", "", "17", "2501807", "", "-7.125", "-34.93222", "America/Fortaleza"),
("3405954", "Baturité", "", "BR", "76", "", "06", "2302107", "", "-4.32861", "-38.88472", "America/Fortaleza"),
("3405993", "Batalha", "", "BR", "76", "", "02", "2700706", "", "-9.67778", "-37.12472", "America/Maceio"),
("3406001", "Batalha", "", "BR", "76", "", "20", "2201507", "", "-4.025", "-42.075", "America/Fortaleza"),
("3406041", "Barroquinha", "", "BR", "76", "", "06", "2302057", "", "-3.01889", "-41.13611", "America/Fortaleza"),
("3406088", "Barro", "", "BR", "76", "", "06", "2307502", "", "-6.71667", "-38.86667", "America/Fortaleza"),
("3406160", "Barreiros", "", "BR", "76", "", "30", "2601409", "", "-8.81833", "-35.18639", "America/Recife"),
("3406196", "Barreirinhas", "", "BR", "76", "", "13", "2101707", "", "-2.75556", "-42.82591", "America/Fortaleza"),
("3406202", "Barreirinha", "", "BR", "76", "", "04", "1300508", "", "-2.79333", "-57.07", "America/Manaus"),
("3406263", "Barras", "Баррас", "BR", "76", "", "20", "2201200", "", "-4.24444", "-42.29444", "America/Fortaleza"),
("3406318", "Barra do Corda", "", "BR", "76", "", "13", "2101608", "", "-5.50308", "-45.23693", "America/Fortaleza"),
("3406333", "Barra de Santo Antônio", "", "BR", "76", "", "02", "2700508", "", "-9.40472", "-35.50722", "America/Maceio"),
("3406429", "Barcarena", "", "BR", "76", "", "16", "1501303", "", "-1.50583", "-48.62583", "America/Belem"),
("3406442", "Barbalha", "", "BR", "76", "", "06", "2301901", "", "-7.31111", "-39.30417", "America/Fortaleza"),
("3406457", "Baraúna", "", "BR", "76", "", "22", "2401453", "", "-5.08", "-37.61667", "America/Fortaleza"),
("3406503", "Bananeiras", "", "BR", "76", "", "17", "2501500", "", "-6.75", "-35.63333", "America/Fortaleza"),
("3406545", "Balsas", "Альтбальсас", "BR", "76", "", "13", "2101400", "", "-7.5325", "-46.03556", "America/Fortaleza"),
("3406844", "Baião", "", "BR", "76", "", "16", "1501204", "", "-2.79056", "-49.67167", "America/Belem"),
("3406910", "Bacabal", "Бакабал", "BR", "76", "", "13", "2101202", "", "-4.29167", "-44.79167", "America/Fortaleza"),
("3406948", "Autazes", "", "BR", "76", "", "04", "1300300", "", "-3.57972", "-59.13056", "America/Manaus"),
("3406954", "Aurora", "", "BR", "76", "", "06", "2301703", "", "-6.9425", "-38.9675", "America/Fortaleza"),
("3406961", "Augusto Corrêa", "", "BR", "76", "", "16", "1500909", "", "-1.02167", "-46.635", "America/Belem"),
("3406996", "Atalaia", "", "BR", "76", "", "02", "2700409", "", "-9.50194", "-36.02278", "America/Maceio"),
("3407010", "Assaré", "", "BR", "76", "", "06", "2301604", "", "-6.87444", "-39.875", "America/Fortaleza"),
("3407091", "Aroeiras", "", "BR", "76", "", "17", "2501302", "", "-7.54528", "-35.7075", "America/Fortaleza"),
("3407151", "Arês", "", "BR", "76", "", "22", "2401206", "", "-6.19444", "-35.16028", "America/Fortaleza"),
("3407194", "Areia Branca", "", "BR", "76", "", "22", "2401107", "", "-4.95611", "-37.13694", "America/Fortaleza"),
("3407210", "Areia", "", "BR", "76", "", "17", "2501104", "", "-6.96333", "-35.69167", "America/Fortaleza"),
("3407216", "Arcoverde", "Арковерди", "BR", "76", "", "30", "2601201", "", "-8.41889", "-37.05389", "America/Recife"),
("3407239", "Araruna", "", "BR", "76", "", "17", "2501005", "", "-6.55833", "-35.74167", "America/Fortaleza"),
("3407243", "Araripina", "Арарипина", "BR", "76", "", "30", "2601102", "", "-7.57611", "-40.49833", "America/Recife"),
("3407248", "Araripe", "", "BR", "76", "", "06", "2301307", "", "-7.2125", "-40.04611", "America/Fortaleza"),
("3407258", "Arari", "", "BR", "76", "", "13", "2101004", "", "-3.45361", "-44.78", "America/Fortaleza"),
("3407297", "Arara", "", "BR", "76", "", "17", "2500908", "", "-6.82833", "-35.75833", "America/Fortaleza"),
("3407327", "Arapiraca", "", "BR", "76", "", "02", "2700300", "", "-9.7525", "-36.66111", "America/Maceio"),
("3407351", "Araioses", "", "BR", "76", "", "13", "2100907", "", "-2.89", "-41.90306", "America/Fortaleza"),
("3407357", "Araguaína", "Арагуаина", "BR", "76", "BR", "31", "1702109", "", "-7.19111", "-48.20722", "America/Araguaina"),
("3407366", "Araçoiaba", "", "BR", "76", "", "30", "2601052", "", "-7.79028", "-35.09083", "America/Recife"),
("3407367", "Aracoiaba", "", "BR", "76", "", "06", "2301208", "", "-4.37111", "-38.81417", "America/Fortaleza"),
("3407378", "Aracati", "Аракати", "BR", "76", "", "06", "2301109", "", "-4.56167", "-37.76972", "America/Fortaleza"),
("3407407", "Aquiraz", "", "BR", "76", "", "06", "2301000", "", "-3.90139", "-38.39111", "America/Fortaleza"),
("3407440", "Apodi", "", "BR", "76", "", "22", "2401008", "", "-5.66417", "-37.79889", "America/Fortaleza"),
("3407544", "Angicos", "", "BR", "76", "", "22", "2400802", "", "-5.66556", "-36.60111", "America/Fortaleza"),
("3407669", "Ananindeua", "Ананиндеуа", "BR", "76", "", "16", "1500800", "", "-1.36556", "-48.37222", "America/Belem"),
("3407682", "Anajatuba", "", "BR", "76", "", "13", "2100709", "", "-3.26444", "-44.61972", "America/Fortaleza"),
("3407693", "Anadia", "", "BR", "76", "", "02", "2700201", "", "-9.68444", "-36.30417", "America/Maceio"),
("3407703", "Amontada", "", "BR", "76", "", "06", "2300754", "", "-3.36167", "-39.83167", "America/Fortaleza"),
("3407755", "Amarante do Maranhão", "", "BR", "76", "", "13", "2100600", "", "-5.56667", "-46.74222", "America/Fortaleza"),
("3407756", "Amarante", "", "BR", "76", "", "20", "2200509", "", "-6.24316", "-42.84544", "America/Fortaleza"),
("3407758", "Amaraji", "", "BR", "76", "", "30", "2600906", "", "-8.38306", "-35.4525", "America/Recife"),
("3407797", "Altos", "", "BR", "76", "", "20", "2200400", "", "-5.03806", "-42.46", "America/Fortaleza"),
("3407871", "Altinho", "", "BR", "76", "", "30", "2600807", "", "-8.48972", "-36.05944", "America/Recife"),
("3407882", "Altamira", "Альтамира", "BR", "76", "", "16", "1500602", "", "-3.20333", "-52.20639", "America/Santarem"),
("3407903", "Almeirim", "Алмейрин", "BR", "76", "", "16", "1500503", "", "-1.52333", "-52.58167", "America/Santarem"),
("3407940", "Alhandra", "", "BR", "76", "", "17", "2500601", "", "-7.43861", "-34.91444", "America/Fortaleza"),
("3407977", "Alexandria", "", "BR", "76", "", "22", "2400505", "", "-6.4125", "-38.01583", "America/Fortaleza"),
("3407980", "Alenquer", "", "BR", "76", "", "16", "1500404", "", "-1.94167", "-54.73833", "America/Santarem"),
("3408073", "Alcântara", "", "BR", "76", "", "13", "2100204", "", "-2.4041", "-44.41669", "America/Fortaleza"),
("3408094", "Alagoinha", "", "BR", "76", "", "17", "2500502", "", "-6.95", "-35.545", "America/Fortaleza"),
("3408097", "Alagoa Nova", "", "BR", "76", "", "17", "2500403", "", "-7.07083", "-35.75833", "America/Fortaleza"),
("3408100", "Alagoa Grande", "", "BR", "76", "", "17", "2515807", "", "-7.15833", "-35.63", "America/Fortaleza"),
("3408166", "Águas Belas", "", "BR", "76", "", "30", "2600500", "", "-9.11139", "-37.12306", "America/Recife"),
("3408175", "Água Preta", "", "BR", "76", "", "30", "2600401", "", "-8.7075", "-35.53056", "America/Recife"),
("3408210", "Água Branca", "", "BR", "76", "", "02", "2700102", "", "-9.26083", "-37.93611", "America/Maceio"),
("3408221", "Água Branca", "", "BR", "76", "", "20", "2200202", "", "-5.89222", "-42.63611", "America/Fortaleza"),
("3408251", "Agrestina", "", "BR", "76", "", "30", "2600302", "", "-8.45806", "-35.94472", "America/Recife"),
("3408269", "Afuá", "", "BR", "76", "", "16", "1500305", "", "-0.15667", "-50.38667", "America/Belem"),
("3408272", "Afonso Bezerra", "", "BR", "76", "", "22", "2400307", "", "-5.49833", "-36.50556", "America/Fortaleza"),
("3408274", "Afogados da Ingazeira", "", "BR", "76", "", "30", "2600104", "", "-7.75083", "-37.63917", "America/Recife"),
("3408337", "Açu", "", "BR", "76", "", "22", "2400208", "", "-5.57667", "-36.90861", "America/Fortaleza"),
("3408343", "Acopiara", "", "BR", "76", "", "06", "2300309", "", "-6.09528", "-39.4525", "America/Fortaleza"),
("3408368", "Acaraú", "Акарау", "BR", "76", "", "06", "2300200", "", "-2.88556", "-40.12", "America/Fortaleza"),
("3408386", "Acará", "", "BR", "76", "", "16", "1500206", "", "-1.96083", "-48.19667", "America/Belem"),
("3408404", "Abreu e Lima", "", "BR", "76", "", "30", "2600054", "", "-7.91167", "-34.90278", "America/Recife"),
("3408424", "Abaetetuba", "", "BR", "76", "", "16", "1500107", "", "-1.71806", "-48.8825", "America/Belem"),
("3444823", "Xique Xique", "", "BR", "76", "", "05", "2933604", "", "-10.82294", "-42.72815", "America/Bahia"),
("3444843", "Chavantes", "", "BR", "76", "", "27", "3557204", "", "-23.03889", "-49.70944", "America/Sao_Paulo"),
("3444848", "Xanxerê", "", "BR", "76", "", "26", "4219507", "", "-26.87694", "-52.40417", "America/Sao_Paulo"),
("3444864", "Votuporanga", "", "BR", "76", "", "27", "3557105", "", "-20.42278", "-49.97278", "America/Sao_Paulo"),
("3444866", "Votorantim", "", "BR", "76", "", "27", "3557006", "", "-23.54667", "-47.43778", "America/Sao_Paulo"),
("3444876", "Volta Redonda", "Волта-Редонда", "BR", "76", "", "21", "3306305", "", "-22.52306", "-44.10417", "America/Sao_Paulo"),
("3444914", "Vitória da Conquista", "Витория-да-Конкиста", "BR", "76", "", "05", "2933307", "", "-14.86611", "-40.83944", "America/Bahia"),
("3444924", "Vitória", "Витория", "BR", "76", "", "08", "3205309", "", "-20.31944", "-40.33778", "America/Sao_Paulo"),
("3444969", "Visconde do Rio Branco", "", "BR", "76", "", "15", "3172004", "", "-21.01028", "-42.84056", "America/Sao_Paulo"),
("3444997", "Viradouro", "", "BR", "76", "", "27", "3556800", "", "-20.87306", "-48.29694", "America/Sao_Paulo"),
("3445014", "Vinhedo", "", "BR", "76", "", "27", "3556701", "", "-23.02972", "-46.97528", "America/Sao_Paulo"),
("3445026", "Vila Velha", "Вила-Велья", "BR", "76", "", "08", "3205200", "", "-20.32972", "-40.2925", "America/Sao_Paulo"),
("3445126", "Videira", "Видейра", "BR", "76", "", "26", "4219309", "", "-27.00833", "-51.15167", "America/Sao_Paulo"),
("3445133", "Viçosa", "Висоза", "BR", "76", "", "15", "3171303", "", "-20.75389", "-42.88194", "America/Sao_Paulo"),
("3445148", "Vianópolis", "", "BR", "76", "", "29", "5222005", "", "-16.74194", "-48.51639", "America/Sao_Paulo"),
("3445153", "Viana", "Виана", "BR", "76", "", "08", "3205101", "", "-20.39028", "-40.49611", "America/Sao_Paulo"),
("3445156", "Viamão", "Виаман", "BR", "76", "", "23", "4323002", "", "-30.08111", "-51.02333", "America/Sao_Paulo"),
("3445162", "Vespasiano", "", "BR", "76", "", "15", "3171204", "", "-19.69194", "-43.92333", "America/Sao_Paulo"),
("3445299", "Veranópolis", "", "BR", "76", "", "23", "4322806", "", "-28.93611", "-51.54944", "America/Sao_Paulo"),
("3445307", "Vera Cruz", "", "BR", "76", "", "05", "2901304", "", "-12.63333", "-41.03333", "America/Bahia"),
("3445348", "Wenceslau Braz", "", "BR", "76", "", "18", "4128500", "", "-23.87389", "-49.80278", "America/Sao_Paulo"),
("3445350", "Venâncio Aires", "", "BR", "76", "", "23", "4322608", "", "-29.60639", "-52.19194", "America/Sao_Paulo"),
("3445418", "Vazante", "", "BR", "76", "", "15", "3171006", "", "-17.98694", "-46.90778", "America/Sao_Paulo"),
("3445433", "Vassouras", "", "BR", "76", "", "21", "3306206", "", "-22.40389", "-43.6625", "America/Sao_Paulo"),
("3445442", "Varzelândia", "", "BR", "76", "", "15", "3170909", "", "-15.70139", "-44.0275", "America/Sao_Paulo"),
("3445446", "Várzea Paulista", "", "BR", "76", "", "27", "3556503", "", "-23.21139", "-46.82833", "America/Sao_Paulo"),
("3445451", "Várzea Grande", "", "BR", "76", "", "14", "5108402", "", "-15.64667", "-56.1325", "America/Cuiaba"),
("3445459", "Várzea da Palma", "", "BR", "76", "", "15", "3170800", "", "-17.5976", "-44.73367", "America/Sao_Paulo"),
("3445487", "Varginha", "Варжинья", "BR", "76", "", "15", "3170701", "", "-21.55139", "-45.43028", "America/Sao_Paulo"),
("3445500", "Vargem Grande do Sul", "Варжен-Гранди-ду-Сул", "BR", "76", "", "27", "3556404", "", "-21.83222", "-46.89361", "America/Sao_Paulo"),
("3445575", "Valparaíso", "", "BR", "76", "", "27", "3556305", "", "-21.22778", "-50.86833", "America/Sao_Paulo"),
("3445578", "Valinhos", "", "BR", "76", "", "27", "3556206", "", "-22.97056", "-46.99583", "America/Sao_Paulo"),
("3445594", "Valente", "", "BR", "76", "", "05", "2933000", "", "-11.41222", "-39.46194", "America/Bahia"),
("3445596", "Valença", "Валенса", "BR", "76", "", "21", "3306107", "", "-22.24556", "-43.70028", "America/Sao_Paulo"),
("3445597", "Valença", "", "BR", "76", "", "05", "2932903", "", "-13.37028", "-39.07306", "America/Bahia"),
("3445630", "Vacaria", "Вакария", "BR", "76", "", "23", "4322509", "", "-28.51222", "-50.93389", "America/Sao_Paulo"),
("3445667", "Urussanga", "", "BR", "76", "", "26", "4219002", "", "-28.51778", "-49.32083", "America/Sao_Paulo"),
("3445675", "Urupês", "", "BR", "76", "", "27", "3556008", "", "-21.20167", "-49.29", "America/Sao_Paulo"),
("3445679", "Uruguaiana", "Уругуаяна", "BR", "76", "", "23", "4322400", "", "-29.75472", "-57.08833", "America/Sao_Paulo"),
("3445690", "Uruçuca", "", "BR", "76", "", "05", "2932705", "", "-14.59306", "-39.28444", "America/Bahia"),
("3445712", "Uruana", "", "BR", "76", "", "29", "5221700", "", "-15.5036", "-49.68266", "America/Sao_Paulo"),
("3445713", "Uruaçu", "Уруасу", "BR", "76", "", "29", "5221601", "", "-14.52472", "-49.14083", "America/Sao_Paulo"),
("3445746", "União da Vitória", "Униан-да-Витория", "BR", "76", "", "18", "4128203", "", "-26.23", "-51.08639", "America/Sao_Paulo"),
("3445764", "Unaí", "Унай", "BR", "76", "", "15", "3170404", "", "-16.3575", "-46.90611", "America/Sao_Paulo"),
("3445781", "Una", "", "BR", "76", "", "05", "2932507", "", "-15.29333", "-39.07528", "America/Bahia"),
("3445782", "Umuarama", "", "BR", "76", "", "18", "4128104", "", "-23.76639", "-53.325", "America/Sao_Paulo"),
("3445818", "Umbaúba", "", "BR", "76", "", "28", "2807600", "", "-11.38333", "-37.65778", "America/Maceio"),
("3445831", "Uberlândia", "Уберландия", "BR", "76", "", "15", "3170206", "", "-18.91861", "-48.27722", "America/Sao_Paulo"),
("3445839", "Uberaba", "Убераба", "BR", "76", "", "15", "3170107", "", "-19.74833", "-47.93194", "America/Sao_Paulo"),
("3445847", "Ubatuba", "Убатуба", "BR", "76", "", "27", "3555406", "", "-23.43389", "-45.07111", "America/Sao_Paulo"),
("3445849", "Ubatã", "", "BR", "76", "", "05", "2932309", "", "-14.20906", "-39.52641", "America/Bahia"),
("3445853", "Ubaitaba", "", "BR", "76", "", "05", "2932200", "", "-14.3125", "-39.32333", "America/Bahia"),
("3445854", "Ubaíra", "", "BR", "76", "", "05", "2932101", "", "-13.26806", "-39.66278", "America/Bahia"),
("3445859", "Ubá", "Уба", "BR", "76", "", "15", "3169901", "", "-21.12", "-42.94278", "America/Sao_Paulo"),
("3445912", "Turmalina", "", "BR", "76", "", "15", "3169703", "", "-17.28556", "-42.73", "America/Sao_Paulo"),
("3445922", "Tupi Paulista", "", "BR", "76", "", "27", "3555109", "", "-21.38111", "-51.57056", "America/Sao_Paulo"),
("3445939", "Tupanciretã", "", "BR", "76", "", "23", "4322202", "", "-29.08056", "-53.83583", "America/Sao_Paulo"),
("3445941", "Tupaciguara", "Тупасигуара", "BR", "76", "", "15", "3169604", "", "-18.59222", "-48.705", "America/Sao_Paulo"),
("3445942", "Tupã", "Тупа", "BR", "76", "", "27", "3555000", "", "-21.93472", "-50.51361", "America/Sao_Paulo"),
("3445983", "Tucano", "", "BR", "76", "", "05", "2931905", "", "-10.95817", "-38.79084", "America/Bahia"),
("3445993", "Tubarão", "Тубаран", "BR", "76", "", "26", "4218707", "", "-28.46667", "-49.00694", "America/Sao_Paulo"),
("3446019", "Triunfo", "", "BR", "76", "", "23", "4322004", "", "-29.94333", "-51.71806", "America/Sao_Paulo"),
("3446038", "Trindade", "Триндади", "BR", "76", "", "29", "5221403", "", "-16.64944", "-49.48889", "America/Sao_Paulo"),
("3446065", "Três Rios", "", "BR", "76", "", "21", "3306008", "", "-22.11667", "-43.20917", "America/Sao_Paulo"),
("3446077", "Três Pontas", "Трес-Понтас", "BR", "76", "", "15", "3169406", "", "-21.36667", "-45.5125", "America/Sao_Paulo"),
("3446087", "Três Passos", "", "BR", "76", "", "23", "4321907", "", "-27.45556", "-53.93194", "America/Sao_Paulo"),
("3446098", "Três Lagoas", "Трес-Лагоас", "BR", "76", "", "11", "5008305", "", "-20.78765", "-51.70338", "America/Campo_Grande"),
("3446130", "Três de Maio", "", "BR", "76", "", "23", "4321808", "", "-27.77333", "-54.24", "America/Sao_Paulo"),
("3446137", "Três Coroas", "", "BR", "76", "", "23", "4321709", "", "-29.51694", "-50.77778", "America/Sao_Paulo"),
("3446138", "Três Corações", "", "BR", "76", "", "15", "3169307", "", "-21.69694", "-45.25333", "America/Sao_Paulo"),
("3446171", "Três Barras", "", "BR", "76", "", "26", "4218301", "", "-26.10639", "-50.32222", "America/Sao_Paulo"),
("3446194", "Tremembé", "", "BR", "76", "", "27", "3554805", "", "-22.95833", "-45.54944", "America/Sao_Paulo"),
("3446232", "Tramandaí", "", "BR", "76", "", "23", "4321600", "", "-29.98472", "-50.13361", "America/Sao_Paulo"),
("3446295", "Torres", "Торрес", "BR", "76", "", "23", "4321501", "", "-29.33528", "-49.72694", "America/Sao_Paulo"),
("3446370", "Toledo", "Толедо", "BR", "76", "", "18", "4127700", "", "-24.71361", "-53.74306", "America/Sao_Paulo"),
("3446392", "Tocantins", "", "BR", "76", "", "15", "3169000", "", "-21.175", "-43.01778", "America/Sao_Paulo"),
("3446400", "Tobias Barreto", "", "BR", "76", "", "28", "2807402", "", "-11.18389", "-37.99833", "America/Maceio"),
("3446445", "Timóteo", "Тимофей", "BR", "76", "", "15", "3168705", "", "-19.58106", "-42.64953", "America/Sao_Paulo"),
("3446465", "Timbó", "", "BR", "76", "", "26", "4218202", "", "-26.82333", "-49.27167", "America/Sao_Paulo"),
("3446500", "Tijucas", "Тижукас", "BR", "76", "", "26", "4218004", "", "-27.24139", "-48.63361", "America/Sao_Paulo"),
("3446539", "Tietê", "", "BR", "76", "", "27", "3554508", "", "-23.10194", "-47.71472", "America/Sao_Paulo"),
("3446550", "Tibagi", "", "BR", "76", "", "18", "4127502", "", "-24.50944", "-50.41361", "America/Sao_Paulo"),
("3446556", "Teutônia", "", "BR", "76", "", "23", "4321451", "", "-29.44806", "-51.80639", "America/Sao_Paulo"),
("3446579", "Terra Roxa", "", "BR", "76", "", "18", "4127809", "", "-23.85571", "-50.0314", "America/Sao_Paulo"),
("3446581", "Terra Rica", "", "BR", "76", "", "18", "4127304", "", "-22.70944", "-52.61694", "America/Sao_Paulo"),
("3446587", "Terra Nova", "", "BR", "76", "", "05", "2927200", "", "-12.36667", "-40.66667", "America/Bahia"),
("3446598", "Terra Boa", "", "BR", "76", "", "18", "4127205", "", "-23.76806", "-52.44417", "America/Sao_Paulo"),
("3446606", "Teresópolis", "Терезополис", "BR", "76", "", "21", "3305802", "", "-22.4167", "-42.97822", "America/Sao_Paulo"),
("3446619", "Terenos", "", "BR", "76", "", "11", "5008008", "", "-20.44222", "-54.86028", "America/Campo_Grande"),
("3446621", "Teófilo Otoni", "Теофилу-Отони", "BR", "76", "", "15", "3168606", "", "-17.8575", "-41.50528", "America/Sao_Paulo"),
("3446625", "Teodoro Sampaio", "", "BR", "76", "", "27", "3554300", "", "-22.5325", "-52.1675", "America/Sao_Paulo"),
("3446652", "Telêmaco Borba", "", "BR", "76", "", "18", "4127106", "", "-24.32389", "-50.61556", "America/Sao_Paulo"),
("3446682", "Taubaté", "Таубате", "BR", "76", "", "27", "3554102", "", "-23.02639", "-45.55528", "America/Sao_Paulo"),
("3446692", "Tatuí", "", "BR", "76", "", "27", "3554003", "", "-23.35556", "-47.85694", "America/Sao_Paulo"),
("3446718", "Tarumã", "", "BR", "76", "", "27", "3553955", "", "-22.74667", "-50.57722", "America/Sao_Paulo"),
("3446752", "Taquarituba", "", "BR", "76", "", "27", "3553807", "", "-23.53306", "-49.24444", "America/Sao_Paulo"),
("3446753", "Taquaritinga", "", "BR", "76", "", "27", "3553708", "", "-21.40611", "-48.50472", "America/Sao_Paulo"),
("3446783", "Taquari", "Такуари", "BR", "76", "", "23", "4321303", "", "-29.79972", "-51.86444", "America/Sao_Paulo"),
("3446847", "Taquara", "", "BR", "76", "", "23", "4321204", "", "-29.65056", "-50.78056", "America/Sao_Paulo"),
("3446866", "Tapiramutá", "", "BR", "76", "", "05", "2931301", "", "-11.84722", "-40.79139", "America/Bahia"),
("3446880", "Tapes", "", "BR", "76", "", "23", "4321105", "", "-30.67333", "-51.39583", "America/Sao_Paulo"),
("3446881", "Taperoá", "", "BR", "76", "", "05", "2931202", "", "-13.53806", "-39.09861", "America/Bahia"),
("3446922", "Tapejara", "", "BR", "76", "", "23", "4320909", "", "-28.06806", "-52.01389", "America/Sao_Paulo"),
("3446923", "Tapejara", "", "BR", "76", "", "18", "4126801", "", "-23.73306", "-52.87333", "America/Sao_Paulo"),
("3446971", "Tanhaçu", "", "BR", "76", "", "05", "2931004", "", "-14.02139", "-41.24806", "America/Bahia"),
("3446974", "Tanguá", "", "BR", "76", "", "21", "3305752", "", "-22.73028", "-42.71417", "America/Sao_Paulo"),
("3446979", "Tanabi", "", "BR", "76", "", "27", "3553401", "", "-20.62639", "-49.64917", "America/Sao_Paulo"),
("3447005", "Tambaú", "", "BR", "76", "", "27", "3553302", "", "-21.705", "-47.27444", "America/Sao_Paulo"),
("3447059", "Taiobeiras", "Тайобейрас", "BR", "76", "", "15", "3168002", "", "-15.80778", "-42.23306", "America/Sao_Paulo"),
("3447075", "Taguatinga", "", "BR", "76", "BR", "31", "1720903", "", "-12.40389", "-46.43611", "America/Araguaina"),
("3447186", "Taboão da Serra", "", "BR", "76", "", "27", "3552809", "", "-23.62611", "-46.79167", "America/Sao_Paulo"),
("3447200", "Tabatinga", "", "BR", "76", "", "27", "3552700", "", "-21.71667", "-48.6875", "America/Sao_Paulo"),
("3447212", "Suzano", "Сузано", "BR", "76", "", "27", "3552502", "", "-23.5425", "-46.31083", "America/Sao_Paulo"),
("3447259", "Sumaré", "Сумаре", "BR", "76", "", "27", "3552403", "", "-22.82194", "-47.26694", "America/Sao_Paulo"),
("3447399", "Sorocaba", "Сорокаба", "BR", "76", "", "27", "3552205", "", "-23.50167", "-47.45806", "America/Sao_Paulo"),
("3447409", "Sombrio", "", "BR", "76", "", "26", "4217709", "", "-29.11389", "-49.61667", "America/Sao_Paulo"),
("3447423", "Soledade", "", "BR", "76", "", "23", "4320800", "", "-28.81833", "-52.51028", "America/Sao_Paulo"),
("3447437", "Socorro", "Сокорро", "BR", "76", "", "27", "3552106", "", "-22.59139", "-46.52889", "America/Sao_Paulo"),
("3447473", "Sobradinho", "", "BR", "76", "", "05", "2929107", "", "-12.83333", "-39.1", "America/Bahia"),
("3447537", "Siqueira Campos", "", "BR", "76", "", "18", "4126603", "", "-23.68889", "-49.83389", "America/Sao_Paulo"),
("3447562", "Simão Dias", "", "BR", "76", "", "28", "2807105", "", "-10.73833", "-37.81111", "America/Maceio"),
("3447589", "Silvânia", "", "BR", "76", "", "29", "5220603", "", "-16.65889", "-48.60806", "America/Sao_Paulo"),
("3447591", "Silva Jardim", "", "BR", "76", "", "21", "3305604", "", "-22.65083", "-42.39167", "America/Sao_Paulo"),
("3447597", "Sidrolândia", "", "BR", "76", "", "11", "5007901", "", "-20.93194", "-54.96139", "America/Campo_Grande"),
("3447598", "Siderópolis", "", "BR", "76", "", "26", "4217600", "", "-28.59778", "-49.42444", "America/Sao_Paulo"),
("3447602", "Severínia", "", "BR", "76", "", "27", "3551900", "", "-20.80944", "-48.80278", "America/Sao_Paulo"),
("3447624", "Sete Lagoas", "Сети-Лагоас", "BR", "76", "", "15", "3167202", "", "-19.46583", "-44.24667", "America/Sao_Paulo"),
("3447651", "Sertãozinho", "", "BR", "76", "", "27", "3551702", "", "-21.13778", "-47.99028", "America/Sao_Paulo"),
("3447658", "Sertanópolis", "", "BR", "76", "", "18", "4126504", "", "-23.05861", "-51.03639", "America/Sao_Paulo"),
("3447672", "Serro", "", "BR", "76", "", "15", "3167103", "", "-18.60472", "-43.37944", "America/Sao_Paulo"),
("3447690", "Serrinha", "", "BR", "76", "", "05", "2930501", "", "-11.66417", "-39.0075", "America/Bahia"),
("3447718", "Serra Negra", "", "BR", "76", "", "27", "3551603", "", "-22.61222", "-46.70056", "America/Sao_Paulo"),
("3447720", "Serrana", "", "BR", "76", "", "27", "3551504", "", "-21.21139", "-47.59556", "America/Sao_Paulo"),
("3447779", "Serra", "Серра", "BR", "76", "", "08", "3205002", "", "-20.12861", "-40.30778", "America/Sao_Paulo"),
("3447785", "Seropédica", "", "BR", "76", "", "21", "3305554", "", "-22.74389", "-43.7075", "America/Sao_Paulo"),
("3447839", "Senhor do Bonfim", "", "BR", "76", "", "05", "2930105", "", "-10.46139", "-40.18944", "America/Bahia"),
("3447848", "Sengés", "", "BR", "76", "", "18", "4126306", "", "-24.11335", "-49.46315", "America/Sao_Paulo"),
("3447854", "Senador Canedo", "", "BR", "76", "", "29", "5220454", "", "-16.70806", "-49.09306", "America/Sao_Paulo"),
("3447928", "Seabra", "", "BR", "76", "", "05", "2929909", "", "-12.41713", "-41.77049", "America/Bahia"),
("3447929", "Schroeder", "", "BR", "76", "", "26", "4217402", "", "-26.4125", "-49.07306", "America/Sao_Paulo"),
("3447961", "Saubara", "", "BR", "76", "", "05", "2929750", "", "-12.7375", "-38.76861", "America/Bahia"),
("3447969", "Sarzedo", "", "BR", "76", "", "15", "3165537", "", "-20.03528", "-44.14472", "America/Sao_Paulo"),
("3447997", "Sarandi", "Саранди", "BR", "76", "", "23", "4320107", "", "-27.94389", "-52.92306", "America/Sao_Paulo"),
("3447998", "Sarandi", "", "BR", "76", "", "18", "4126256", "", "-23.44361", "-51.87389", "America/Sao_Paulo"),
("3448011", "Saquarema", "", "BR", "76", "", "21", "3305505", "", "-22.92", "-42.51028", "America/Sao_Paulo"),
("3448031", "Sapucaia", "Сапукая", "BR", "76", "", "23", "4320008", "", "-29.83333", "-51.15", "America/Sao_Paulo"),
("3448033", "Sapucaia", "", "BR", "76", "", "21", "3305406", "", "-21.995", "-42.91444", "America/Sao_Paulo"),
("3448063", "Sapiranga", "", "BR", "76", "", "23", "4319901", "", "-29.63806", "-51.00694", "America/Sao_Paulo"),
("3448136", "São Vicente", "Сан-Висенти", "BR", "76", "", "27", "3551009", "", "-23.96306", "-46.39194", "America/Sao_Paulo"),
("3448197", "São Simão", "", "BR", "76", "", "27", "3550902", "", "-21.47917", "-47.55083", "America/Sao_Paulo"),
("3448207", "São Sepé", "", "BR", "76", "", "23", "4319604", "", "-30.16056", "-53.56528", "America/Sao_Paulo"),
("3448219", "São Sebastião do Passé", "", "BR", "76", "", "05", "2929503", "", "-12.5125", "-38.49528", "America/Bahia"),
("3448221", "São Sebastião do Paraíso", "Сан-Себастьян-ду-Параисо", "BR", "76", "", "15", "3164704", "", "-20.91694", "-46.99139", "America/Sao_Paulo"),
("3448227", "São Sebastião do Caí", "", "BR", "76", "", "23", "4319505", "", "-29.58667", "-51.37556", "America/Sao_Paulo"),
("3448257", "São Sebastião", "", "BR", "76", "", "27", "3550704", "", "-23.76", "-45.40972", "America/Sao_Paulo"),
("3448300", "São Roque", "", "BR", "76", "", "27", "3550605", "", "-23.52917", "-47.13528", "America/Sao_Paulo"),
("3448332", "São Pedro do Sul", "", "BR", "76", "", "23", "4319406", "", "-29.62056", "-54.17889", "America/Sao_Paulo"),
("3448351", "São Pedro da Aldeia", "", "BR", "76", "", "21", "3305208", "", "-22.83917", "-42.10278", "America/Sao_Paulo"),
("3448403", "São Pedro", "", "BR", "76", "", "27", "3550407", "", "-22.54861", "-47.91389", "America/Sao_Paulo"),
("3448439", "São Paulo", "Сан-Паулу", "BR", "76", "", "27", "3550308", "", "-23.5475", "-46.63611", "America/Sao_Paulo"),
("3448453", "São Miguel do Iguaçu", "", "BR", "76", "", "18", "4125704", "", "-25.34806", "-54.23778", "America/Sao_Paulo"),
("3448455", "São Miguel do Araguaia", "", "BR", "76", "", "29", "5220207", "", "-13.275", "-50.16278", "America/Sao_Paulo"),
("3448502", "São Mateus do Sul", "Сан-Матеус-ду-Сул", "BR", "76", "", "18", "4125605", "", "-25.87417", "-50.38278", "America/Sao_Paulo"),
("3448519", "São Mateus", "Сан-Матеус", "BR", "76", "", "08", "3204906", "", "-18.72011", "-39.85891", "America/Sao_Paulo"),
("3448533", "São Marcos", "", "BR", "76", "", "23", "4319000", "", "-28.97111", "-51.06806", "America/Sao_Paulo"),
("3448545", "São Manuel", "Сан-Мануэль", "BR", "76", "", "27", "3550100", "", "-22.73111", "-48.57056", "America/Sao_Paulo"),
("3448552", "São Luiz Gonzaga", "", "BR", "76", "", "23", "4318903", "", "-28.40833", "-54.96083", "America/Sao_Paulo"),
("3448558", "São Luís de Montes Belos", "", "BR", "76", "", "29", "5220108", "", "-16.525", "-50.37222", "America/Sao_Paulo"),
("3448596", "São Lourenço do Sul", "Сан-Лоренсу-ду-Сул", "BR", "76", "", "23", "4318804", "", "-31.36528", "-51.97833", "America/Sao_Paulo"),
("3448597", "São Lourenço do Oeste", "", "BR", "76", "", "26", "4216909", "", "-26.35917", "-52.85111", "America/Sao_Paulo"),
("3448599", "São Lourenço da Serra", "", "BR", "76", "", "27", "3549953", "", "-23.8525", "-46.9425", "America/Sao_Paulo"),
("3448616", "São Lourenço", "Сан-Лоренсу", "BR", "76", "", "15", "3163706", "", "-22.11639", "-45.05444", "America/Sao_Paulo"),
("3448622", "São Leopoldo", "Сан-Леополду", "BR", "76", "", "23", "4318705", "", "-29.76028", "-51.14722", "America/Sao_Paulo"),
("3448632", "São José dos Pinhais", "Сан-Жозе-дус-Пиньяйс", "BR", "76", "", "18", "4125506", "", "-25.5302", "-49.20836", "America/Sao_Paulo"),
("3448636", "São José dos Campos", "Сан-Жозе-дус-Кампус", "BR", "76", "", "27", "3549904", "", "-23.17944", "-45.88694", "America/Sao_Paulo"),
("3448639", "São José do Rio Preto", "Сан-Жозе-ду-Риу-Прету", "BR", "76", "", "27", "3549805", "", "-20.81972", "-49.37944", "America/Sao_Paulo"),
("3448640", "São José do Rio Pardo", "", "BR", "76", "", "27", "3549706", "", "-21.59556", "-46.88861", "America/Sao_Paulo"),
("3448669", "São José do Calçado", "", "BR", "76", "", "08", "3204807", "", "-21.02528", "-41.65444", "America/Sao_Paulo"),
("3448742", "São José", "", "BR", "76", "", "26", "4202800", "", "-28.21171", "-49.1632", "America/Sao_Paulo"),
("3448824", "São Joaquim de Bicas", "", "BR", "76", "", "15", "3162922", "", "-20.04917", "-44.27389", "America/Sao_Paulo"),
("3448825", "São Joaquim da Barra", "", "BR", "76", "", "27", "3549409", "", "-20.58139", "-47.85472", "America/Sao_Paulo"),
("3448828", "São Joaquim", "", "BR", "76", "", "26", "4216503", "", "-28.29389", "-49.93167", "America/Sao_Paulo"),
("3448846", "São João Nepomuceno", "Сан-Жуан-Непомусено", "BR", "76", "", "15", "3162906", "", "-21.54", "-43.01056", "America/Sao_Paulo"),
("3448850", "São João Evangelista", "", "BR", "76", "", "15", "3162807", "", "-18.54778", "-42.76333", "America/Sao_Paulo"),
("3448861", "São João do Paraíso", "", "BR", "76", "", "15", "3162708", "", "-15.31361", "-42.01444", "America/Sao_Paulo"),
("3448877", "São João de Meriti", "Сан-Жуан-ди-Мерити", "BR", "76", "", "21", "3305109", "", "-22.80389", "-43.37222", "America/Sao_Paulo"),
("3448879", "São João del Rei", "Сан-Жуан-дел-Рей", "BR", "76", "", "15", "3162500", "", "-21.13556", "-44.26167", "America/Sao_Paulo"),
("3448892", "São João da Ponte", "", "BR", "76", "", "15", "3162401", "", "-15.92917", "-44.00778", "America/Sao_Paulo"),
("3448902", "São João da Boa Vista", "", "BR", "76", "", "27", "3549102", "", "-21.96917", "-46.79806", "America/Sao_Paulo"),
("3448903", "São João da Barra", "Сан-Жуан-да-Барра", "BR", "76", "", "21", "3305000", "", "-21.64028", "-41.05111", "America/Sao_Paulo"),
("3448906", "São João Batista", "", "BR", "76", "", "26", "4216305", "", "-27.27611", "-48.84944", "America/Sao_Paulo"),
("3449045", "São Jerônimo", "", "BR", "76", "", "23", "4318408", "", "-29.95917", "-51.72222", "America/Sao_Paulo"),
("3449053", "São Gotardo", "", "BR", "76", "", "15", "3162104", "", "-19.31111", "-46.04889", "America/Sao_Paulo"),
("3449055", "São Gonçalo dos Campos", "", "BR", "76", "", "05", "2929305", "", "-12.43333", "-38.96667", "America/Bahia"),
("3449056", "São Gonçalo do Sapucaí", "", "BR", "76", "", "15", "3162005", "", "-21.89222", "-45.59528", "America/Sao_Paulo"),
("3449099", "São Gabriel", "", "BR", "76", "", "23", "4318309", "", "-30.33639", "-54.32", "America/Sao_Paulo"),
("3449112", "São Francisco do Sul", "Сан-Франсиску-ду-Сул", "BR", "76", "", "26", "4216206", "", "-26.24333", "-48.63806", "America/Sao_Paulo"),
("3449116", "São Francisco do Conde", "Сан-Франсиску-ду-Конде", "BR", "76", "", "05", "2929206", "", "-12.6275", "-38.68", "America/Bahia"),
("3449121", "São Francisco de Paula", "", "BR", "76", "", "23", "4318200", "", "-29.44806", "-50.58361", "America/Sao_Paulo"),
("3449124", "São Francisco de Assis", "", "BR", "76", "", "23", "4318101", "", "-29.55028", "-55.13111", "America/Sao_Paulo"),
("3449176", "São Francisco", "", "BR", "76", "", "15", "3161106", "", "-15.94861", "-44.86444", "America/Sao_Paulo"),
("3449195", "São Fidélis", "", "BR", "76", "", "21", "3304805", "", "-21.64611", "-41.74694", "America/Sao_Paulo"),
("3449216", "São Felipe", "", "BR", "76", "", "05", "2906899", "", "-14.8386", "-41.39174", "America/Bahia"),
("3449219", "São Domingos do Prata", "", "BR", "76", "", "15", "3161007", "", "-19.865", "-42.96833", "America/Sao_Paulo"),
("3449304", "São Desidério", "", "BR", "76", "", "05", "2928901", "", "-12.36333", "-44.97333", "America/Bahia"),
("3449310", "São Cristóvão", "Сан-Кристован", "BR", "76", "", "28", "2806701", "", "-11.01472", "-37.20639", "America/Maceio"),
("3449319", "São Carlos", "Сан-Карлос", "BR", "76", "", "27", "3548906", "", "-22.0175", "-47.89083", "America/Sao_Paulo"),
("3449324", "São Caetano do Sul", "Сан-Каэтано-ду-Сул", "BR", "76", "", "27", "3548807", "", "-23.62306", "-46.55111", "America/Sao_Paulo"),
("3449340", "São Borja", "Сан-Борха", "BR", "76", "", "23", "4318002", "", "-28.66056", "-56.00444", "America/Sao_Paulo"),
("3449344", "São Bernardo do Campo", "Сан-Бернардо-ду-Кампу", "BR", "76", "", "27", "3548708", "", "-23.69389", "-46.565", "America/Sao_Paulo"),
("3449350", "São Bento do Sul", "Сан-Бенту-ду-Сул", "BR", "76", "", "26", "4215802", "", "-26.25028", "-49.37861", "America/Sao_Paulo"),
("3449427", "Santos Dumont", "", "BR", "76", "", "15", "3160702", "", "-21.45667", "-43.5525", "America/Sao_Paulo"),
("3449433", "Santos", "Сантос", "BR", "76", "", "27", "3548500", "", "-23.96083", "-46.33361", "America/Sao_Paulo"),
("3449467", "Santo Estêvão", "", "BR", "76", "", "05", "2928802", "", "-12.43028", "-39.25139", "America/Bahia"),
("3449476", "Santo Augusto", "", "BR", "76", "", "23", "4317806", "", "-27.85083", "-53.77722", "America/Sao_Paulo"),
("3449479", "Santo Antônio do Sudoeste", "", "BR", "76", "", "18", "4124400", "", "-26.07361", "-53.72528", "America/Sao_Paulo"),
("3449500", "Santo Antônio do Monte", "", "BR", "76", "", "15", "3160405", "", "-20.08722", "-45.29361", "America/Sao_Paulo"),
("3449502", "Santo Antônio do Leverger", "", "BR", "76", "", "14", "5107800", "", "-15.86556", "-56.07667", "America/Cuiaba"),
("3449516", "Santo Antônio do Amparo", "", "BR", "76", "", "15", "3159902", "", "-20.94639", "-44.91889", "America/Sao_Paulo"),
("3449518", "Santo Antônio de Posse", "", "BR", "76", "", "27", "3548005", "", "-22.60611", "-46.91944", "America/Sao_Paulo"),
("3449519", "Santo Antônio de Pádua", "", "BR", "76", "", "21", "3304706", "", "-21.53944", "-42.18028", "America/Sao_Paulo"),
("3449521", "Santo Antônio de Jesus", "", "BR", "76", "", "05", "2928703", "", "-12.96889", "-39.26139", "America/Bahia"),
("3449529", "Santo Antônio da Platina", "Санту-Антониу-да-Платина", "BR", "76", "", "18", "4124103", "", "-23.295", "-50.07722", "America/Sao_Paulo"),
("3449696", "Santo Ângelo", "Санту-Анджело", "BR", "76", "", "23", "4317509", "", "-28.29917", "-54.26306", "America/Sao_Paulo"),
("3449701", "Santo André", "Санту-Андре", "BR", "76", "", "27", "3547809", "", "-23.66389", "-46.53833", "America/Sao_Paulo"),
("3449707", "Santo Anastácio", "", "BR", "76", "", "27", "3543238", "", "-21.83833", "-51.61028", "America/Sao_Paulo"),
("3449710", "Santo Amaro das Brotas", "", "BR", "76", "", "28", "2806602", "", "-10.78889", "-37.05444", "America/Maceio"),
("3449711", "Santo Amaro da Imperatriz", "", "BR", "76", "", "26", "4215703", "", "-27.68806", "-48.77861", "America/Sao_Paulo"),
("3449720", "Santo Amaro", "", "BR", "76", "", "05", "2928604", "", "-12.54667", "-38.71194", "America/Bahia"),
("3449741", "Santiago", "Сантьяго", "BR", "76", "", "23", "4317400", "", "-29.19167", "-54.86722", "America/Sao_Paulo"),
("3449747", "Santa Vitória do Palmar", "", "BR", "76", "", "23", "4317301", "", "-33.51889", "-53.36806", "America/Sao_Paulo"),
("3449749", "Santa Vitória", "", "BR", "76", "", "15", "3159803", "", "-18.83861", "-50.12139", "America/Sao_Paulo"),
("3449782", "Santa Teresa", "", "BR", "76", "", "08", "3204609", "", "-19.93556", "-40.60028", "America/Sao_Paulo"),
("3449793", "Santa Rosa de Viterbo", "", "BR", "76", "", "27", "3547601", "", "-21.47278", "-47.36306", "America/Sao_Paulo"),
("3449822", "Santa Rosa", "", "BR", "76", "", "23", "4317202", "", "-27.87083", "-54.48139", "America/Sao_Paulo"),
("3449847", "Santa Rita do Sapucaí", "Санта-Рита-ду-Сапукайя", "BR", "76", "", "15", "3159605", "", "-22.25222", "-45.70333", "America/Sao_Paulo"),
("3449851", "Santa Rita do Passa Quatro", "", "BR", "76", "", "27", "3547502", "", "-21.71028", "-47.47806", "America/Sao_Paulo"),
("3449933", "Santana do Paraíso", "Сантана-ду-Параисо", "BR", "76", "", "15", "3158953", "", "-19.36361", "-42.56861", "America/Sao_Paulo"),
("3449936", "Santana do Livramento", "Сантана-ду-Ливраменту", "BR", "76", "", "23", "4317103", "", "-30.89083", "-55.53278", "America/Sao_Paulo"),
("3449948", "Santana de Parnaíba", "", "BR", "76", "", "27", "3547304", "", "-23.44417", "-46.91778", "America/Sao_Paulo"),
("3450031", "Santana", "", "BR", "76", "", "05", "2920304", "", "-14.46667", "-41.8", "America/Bahia"),
("3450057", "Santa Maria do Suaçuí", "", "BR", "76", "", "15", "3158201", "", "-18.19028", "-42.41417", "America/Sao_Paulo"),
("3450063", "Santa Maria da Vitória", "Санта-Мария-да-Витория", "BR", "76", "", "05", "2928109", "", "-13.38814", "-44.19868", "America/Bahia"),
("3450083", "Santa Maria", "Санта-Мария", "BR", "76", "", "23", "4316907", "", "-29.68417", "-53.80694", "America/Sao_Paulo"),
("3450144", "Santa Luzia", "Санта-Лусия", "BR", "76", "", "15", "3157807", "", "-19.76972", "-43.85139", "America/Sao_Paulo"),
("3450157", "Santaluz", "", "BR", "76", "", "05", "2928000", "", "-11.25583", "-39.37472", "America/Bahia"),
("3450188", "Santa Isabel", "", "BR", "76", "", "27", "3546801", "", "-23.31556", "-46.22139", "America/Sao_Paulo"),
("3450202", "Santa Inês", "", "BR", "76", "", "05", "2927903", "", "-13.29222", "-39.81889", "America/Bahia"),
("3450206", "Santa Helena de Goiás", "Санта-Элена-ди-Гояс", "BR", "76", "", "29", "5219308", "", "-17.81361", "-50.59694", "America/Sao_Paulo"),
("3450225", "Santa Gertrudes", "", "BR", "76", "", "27", "3546702", "", "-22.45667", "-47.53028", "America/Sao_Paulo"),
("3450232", "Santa Fé do Sul", "", "BR", "76", "", "27", "3546603", "", "-20.21111", "-50.92583", "America/Sao_Paulo"),
("3450269", "Santa Cruz do Sul", "Санта-Крус-ду-Сул", "BR", "76", "", "23", "4316808", "", "-29.7175", "-52.42583", "America/Sao_Paulo"),
("3450272", "Santa Cruz do Rio Pardo", "", "BR", "76", "", "27", "3546405", "", "-22.89889", "-49.6325", "America/Sao_Paulo"),
("3450283", "Santa Cruz das Palmeiras", "", "BR", "76", "", "27", "3546306", "", "-21.82694", "-47.24861", "America/Sao_Paulo"),
("3450288", "Santa Cruz Cabrália", "", "BR", "76", "", "05", "2927705", "", "-16.27806", "-39.02472", "America/Bahia"),
("3450376", "Santa Cecília", "", "BR", "76", "", "26", "4215505", "", "-26.96083", "-50.42694", "America/Sao_Paulo"),
("3450400", "Santa Branca", "", "BR", "76", "", "27", "3546009", "", "-23.39667", "-45.88389", "America/Sao_Paulo"),
("3450404", "Santa Bárbara d'Oeste", "", "BR", "76", "BR", "27", "3545803", "", "-22.75361", "-47.41361", "America/Sao_Paulo"),
("3450464", "Santa Adélia", "", "BR", "76", "", "27", "3545605", "", "-21.24278", "-48.80417", "America/Sao_Paulo"),
("3450496", "Sananduva", "", "BR", "76", "", "23", "4316600", "", "-27.94972", "-51.80667", "America/Sao_Paulo"),
("3450554", "Salvador", "Салвадор", "BR", "76", "", "05", "2927408", "", "-12.97111", "-38.51083", "America/Bahia"),
("3450563", "Salto de Pirapora", "", "BR", "76", "", "27", "3545308", "", "-23.64889", "-47.57333", "America/Sao_Paulo"),
("3450594", "Salto", "Сальто", "BR", "76", "", "27", "3545209", "", "-23.20083", "-47.28694", "America/Sao_Paulo"),
("3450671", "Salinas", "", "BR", "76", "", "15", "3157005", "", "-16.17028", "-42.29028", "America/Sao_Paulo"),
("3450710", "Salgado", "", "BR", "76", "", "28", "2806206", "", "-11.03194", "-37.475", "America/Maceio"),
("3450759", "Sacramento", "", "BR", "76", "", "15", "3156908", "", "-19.86528", "-47.44", "America/Sao_Paulo"),
("3450806", "Sabinópolis", "", "BR", "76", "", "15", "3156809", "", "-18.66611", "-43.08389", "America/Sao_Paulo"),
("3450832", "Ruy Barbosa", "", "BR", "76", "", "05", "2927200", "", "-12.28389", "-40.49389", "America/Bahia"),
("3450843", "Rubiataba", "", "BR", "76", "", "29", "5218904", "", "-15.16444", "-49.80333", "America/Sao_Paulo"),
("3450872", "Rosário Oeste", "", "BR", "76", "", "14", "5107701", "", "-14.83611", "-56.4275", "America/Cuiaba"),
("3450873", "Rosário do Sul", "Росарио-ду-Сул", "BR", "76", "", "23", "4316402", "", "-30.25833", "-54.91417", "America/Sao_Paulo"),
("3450909", "Rondonópolis", "", "BR", "76", "", "14", "5107602", "", "-16.47083", "-54.63556", "America/Cuiaba"),
("3450963", "Rolante", "", "BR", "76", "", "23", "4316006", "", "-29.65056", "-50.57583", "America/Sao_Paulo"),
("3450964", "Rolândia", "", "BR", "76", "", "18", "4122404", "", "-23.30972", "-51.36917", "America/Sao_Paulo"),
("3451051", "Rio Verde de Mato Grosso", "", "BR", "76", "", "11", "5007406", "", "-18.91806", "-54.84417", "America/Campo_Grande"),
("3451071", "Rio Real", "", "BR", "76", "", "05", "2927002", "", "-11.48472", "-37.93278", "America/Bahia"),
("3451094", "Rio Pomba", "", "BR", "76", "", "15", "3155801", "", "-21.27472", "-43.17917", "America/Sao_Paulo"),
("3451095", "Rio Piracicaba", "", "BR", "76", "", "15", "3155702", "", "-19.92917", "-43.17417", "America/Sao_Paulo"),
("3451100", "Rio Pardo de Minas", "", "BR", "76", "", "15", "3155603", "", "-15.60972", "-42.53972", "America/Sao_Paulo"),
("3451102", "Rio Pardo", "Рио-Пардо", "BR", "76", "", "23", "4315701", "", "-29.98972", "-52.37806", "America/Sao_Paulo"),
("3451107", "Rio Novo do Sul", "", "BR", "76", "", "08", "3204401", "", "-20.8625", "-40.93639", "America/Sao_Paulo"),
("3451114", "Rio Novo", "", "BR", "76", "", "15", "3155405", "", "-21.47703", "-43.12589", "America/Sao_Paulo"),
("3451121", "Rio Negro", "", "BR", "76", "", "18", "4122305", "", "-26.10583", "-49.7975", "America/Sao_Paulo"),
("3451124", "Rio Negrinho", "", "BR", "76", "", "26", "4215000", "", "-26.25444", "-49.51833", "America/Sao_Paulo"),
("3451131", "Riolândia", "", "BR", "76", "", "27", "3544202", "", "-19.98083", "-49.68194", "America/Sao_Paulo"),
("3451134", "Rio Grande da Serra", "", "BR", "76", "", "27", "3544103", "", "-23.74417", "-46.39833", "America/Sao_Paulo"),
("3451138", "Rio Grande", "Рио-Гранде", "BR", "76", "", "23", "4315602", "", "-32.035", "-52.09861", "America/Sao_Paulo"),
("3451152", "Rio do Sul", "Риу-ду-Сул", "BR", "76", "", "26", "4214805", "", "-27.21417", "-49.64306", "America/Sao_Paulo"),
("3451190", "Rio de Janeiro", "Рио-де-Жанейро", "BR", "76", "", "21", "3304557", "", "-22.90278", "-43.2075", "America/Sao_Paulo"),
("3451202", "Rio das Pedras", "", "BR", "76", "", "27", "3544004", "", "-22.84333", "-47.60611", "America/Sao_Paulo"),
("3451205", "Rio das Ostras", "", "BR", "76", "", "21", "3304524", "", "-22.52694", "-41.945", "America/Sao_Paulo"),
("3451232", "Rio Claro", "", "BR", "76", "", "21", "3304409", "", "-22.72306", "-44.13556", "America/Sao_Paulo"),
("3451234", "Rio Claro", "", "BR", "76", "", "27", "3543907", "", "-22.41139", "-47.56139", "America/Sao_Paulo"),
("3451236", "Rio Casca", "", "BR", "76", "", "15", "3154903", "", "-20.22611", "-42.65083", "America/Sao_Paulo"),
("3451241", "Rio Brilhante", "", "BR", "76", "", "11", "5007208", "", "-21.80194", "-54.54639", "America/Campo_Grande"),
("3451242", "Rio Branco do Sul", "Риу-Бранку-ду-Сул", "BR", "76", "", "18", "4122206", "", "-25.19", "-49.31417", "America/Sao_Paulo"),
("3451261", "Rio Bonito", "", "BR", "76", "", "21", "3304300", "", "-22.70861", "-42.60972", "America/Sao_Paulo"),
("3451305", "Ribeirópolis", "", "BR", "76", "", "28", "2806008", "", "-10.53944", "-37.41667", "America/Maceio"),
("3451328", "Ribeirão Preto", "Рибейран-Прету", "BR", "76", "", "27", "3543402", "", "-21.1775", "-47.81028", "America/Sao_Paulo"),
("3451329", "Ribeirão Pires", "", "BR", "76", "", "27", "3543303", "", "-23.71056", "-46.41333", "America/Sao_Paulo"),
("3451353", "Ribeirão das Neves", "", "BR", "76", "", "15", "3154606", "", "-19.76694", "-44.08667", "America/Sao_Paulo"),
("3451357", "Ribeirão da Ilha", "", "BR", "76", "BR", "26", "4205407", "", "-27.69934", "-48.53219", "America/Sao_Paulo"),
("3451362", "Ribeirão Branco", "", "BR", "76", "", "27", "3543006", "", "-24.22083", "-48.76556", "America/Sao_Paulo"),
("3451363", "Ribeirão Bonito", "", "BR", "76", "", "27", "3542909", "", "-22.06667", "-48.17611", "America/Sao_Paulo"),
("3451383", "Ribeira do Pombal", "", "BR", "76", "", "05", "2926608", "", "-10.83444", "-38.53583", "America/Bahia"),
("3451399", "Ribas do Rio Pardo", "", "BR", "76", "", "11", "5007109", "", "-20.44306", "-53.75917", "America/Campo_Grande"),
("3451403", "Rialma", "", "BR", "76", "", "29", "5218607", "", "-15.315", "-49.58444", "America/Sao_Paulo"),
("3451448", "Riacho de Santana", "", "BR", "76", "", "05", "2926400", "", "-13.60917", "-42.93889", "America/Bahia"),
("3451474", "Riachão do Jacuípe", "", "BR", "76", "", "05", "2926301", "", "-11.80694", "-39.38556", "America/Bahia"),
("3451478", "Riachão das Neves", "", "BR", "76", "", "05", "2926202", "", "-11.74611", "-44.91", "America/Bahia"),
("3451650", "Resplendor", "", "BR", "76", "", "15", "3154309", "", "-19.32556", "-41.25528", "America/Sao_Paulo"),
("3451663", "Reserva", "", "BR", "76", "", "18", "4121703", "", "-24.65028", "-50.85056", "America/Sao_Paulo"),
("3451668", "Resende", "Резенди", "BR", "76", "", "21", "3304201", "", "-22.46889", "-44.44667", "America/Sao_Paulo"),
("3451704", "Registro", "", "BR", "76", "", "27", "3542602", "", "-24.4875", "-47.84361", "America/Sao_Paulo"),
("3451709", "Regente Feijó", "", "BR", "76", "", "27", "3542404", "", "-22.22139", "-51.30278", "America/Sao_Paulo"),
("3451750", "Recreio", "", "BR", "76", "", "15", "3154101", "", "-21.525", "-42.46917", "America/Sao_Paulo"),
("3451783", "Realeza", "", "BR", "76", "", "18", "4121406", "", "-25.76889", "-53.5325", "America/Sao_Paulo"),
("3451812", "Raposos", "", "BR", "76", "", "15", "3153905", "", "-19.96722", "-43.80417", "America/Sao_Paulo"),
("3451856", "Rancharia", "", "BR", "76", "", "27", "3542206", "", "-22.22917", "-50.89306", "America/Sao_Paulo"),
("3451931", "Quirinópolis", "", "BR", "76", "", "29", "5218508", "", "-18.44833", "-50.45167", "America/Sao_Paulo"),
("3452073", "Queimados", "", "BR", "76", "", "21", "3304144", "", "-22.71611", "-43.55528", "America/Sao_Paulo"),
("3452085", "Queimadas", "", "BR", "76", "", "05", "2925808", "", "-10.97833", "-39.62639", "America/Bahia"),
("3452141", "Quatro Barras", "", "BR", "76", "", "18", "4120804", "", "-25.36556", "-49.07694", "America/Sao_Paulo"),
("3452148", "Quatis", "", "BR", "76", "", "21", "3304128", "", "-22.40722", "-44.25806", "America/Sao_Paulo"),
("3452167", "Quatá", "", "BR", "76", "", "27", "3541703", "", "-22.2475", "-50.69833", "America/Sao_Paulo"),
("3452179", "Quaraí", "Куараи", "BR", "76", "", "23", "4315305", "", "-30.3875", "-56.45139", "America/Sao_Paulo"),
("3452216", "Prudentópolis", "", "BR", "76", "", "18", "4120606", "", "-25.21306", "-50.97778", "America/Sao_Paulo"),
("3452233", "Propriá", "", "BR", "76", "", "28", "2805703", "", "-10.21111", "-36.84028", "America/Maceio"),
("3452237", "Promissão", "", "BR", "76", "", "27", "3541604", "", "-21.53667", "-49.85806", "America/Sao_Paulo"),
("3452320", "Presidente Venceslau", "", "BR", "76", "", "27", "3541505", "", "-21.87611", "-51.84389", "America/Sao_Paulo"),
("3452324", "Presidente Prudente", "Президенти-Пруденти", "BR", "76", "", "27", "3541406", "", "-22.12556", "-51.38889", "America/Sao_Paulo"),
("3452327", "Presidente Olegário", "", "BR", "76", "", "15", "3153400", "", "-18.41778", "-46.41806", "America/Sao_Paulo"),
("3452331", "Presidente Epitácio", "", "BR", "76", "", "27", "3541307", "", "-21.76333", "-52.11556", "America/Sao_Paulo"),
("3452335", "Presidente Bernardes", "", "BR", "76", "", "27", "3541208", "", "-22.00611", "-51.55306", "America/Sao_Paulo"),
("3452440", "Prata", "", "BR", "76", "", "15", "3152808", "", "-19.30722", "-48.92417", "America/Sao_Paulo"),
("3452465", "Praia Grande", "Прайя-Гранди", "BR", "76", "", "27", "3541000", "", "-24.00583", "-46.40278", "America/Sao_Paulo"),
("3452478", "Pradópolis", "", "BR", "76", "", "27", "3540903", "", "-21.35944", "-48.06556", "America/Sao_Paulo"),
("3452483", "Prado", "", "BR", "76", "", "05", "2925501", "", "-17.34111", "-39.22083", "America/Bahia"),
("3452490", "Poxoréo", "", "BR", "76", "", "14", "5107008", "", "-15.83722", "-54.38917", "America/Cuiaba"),
("3452525", "Pouso Alegre", "Позу-Алегри", "BR", "76", "", "15", "3152501", "", "-22.23", "-45.93639", "America/Sao_Paulo"),
("3452599", "Posse", "", "BR", "76", "", "29", "5218300", "", "-14.09306", "-46.36944", "America/Sao_Paulo"),
("3452623", "Porto União", "", "BR", "76", "", "26", "4213609", "", "-26.23806", "-51.07833", "America/Sao_Paulo"),
("3452640", "Porto Seguro", "Порту-Сегуру", "BR", "76", "", "05", "2925303", "", "-16.44972", "-39.06472", "America/Bahia"),
("3452671", "Porto Real do Colégio", "", "BR", "76", "", "02", "2707503", "", "-10.18583", "-36.84", "America/Maceio"),
("3452672", "Porto Real", "", "BR", "76", "", "21", "3304110", "", "-22.41972", "-44.29028", "America/Sao_Paulo"),
("3452712", "Porto Murtinho", "", "BR", "76", "", "11", "5006903", "", "-21.69889", "-57.8825", "America/Campo_Grande"),
("3452775", "Porto Ferreira", "Порту-Феррейра", "BR", "76", "", "27", "3540705", "", "-21.85389", "-47.47917", "America/Sao_Paulo"),
("3452779", "Porto Feliz", "Порту-Фелис", "BR", "76", "", "27", "3540606", "", "-23.21472", "-47.52389", "America/Sao_Paulo"),
("3452900", "Porto Belo", "", "BR", "76", "", "26", "4213500", "", "-27.15778", "-48.55306", "America/Sao_Paulo"),
("3452909", "Pôrto Barra do Ivinheima", "", "BR", "76", "", "11", "5005707", "", "-22.96667", "-53.66667", "America/Campo_Grande"),
("3452925", "Porto Alegre", "Порту-Алегри", "BR", "76", "", "23", "4314902", "", "-30.03306", "-51.23", "America/Sao_Paulo"),
("3452956", "Porteirinha", "", "BR", "76", "", "15", "3152204", "", "-15.74333", "-43.02833", "America/Sao_Paulo"),
("3452982", "Portão", "", "BR", "76", "", "23", "4314803", "", "-29.70167", "-51.24194", "America/Sao_Paulo"),
("3452992", "Porecatu", "", "BR", "76", "", "18", "4120002", "", "-22.75583", "-51.37917", "America/Sao_Paulo"),
("3453010", "Porciúncula", "", "BR", "76", "", "21", "3304102", "", "-20.96278", "-42.04083", "America/Sao_Paulo"),
("3453014", "Porangatu", "Порангату", "BR", "76", "", "29", "5218003", "", "-13.44083", "-49.14861", "America/Sao_Paulo"),
("3453025", "Ponto Novo", "", "BR", "76", "", "05", "2925253", "", "-10.86278", "-40.13361", "America/Bahia"),
("3453060", "Pontes e Lacerda", "", "BR", "76", "", "14", "5106752", "", "-15.22611", "-59.33528", "America/Cuiaba"),
("3453078", "Ponte Nova", "", "BR", "76", "", "15", "3152105", "", "-20.41639", "-42.90861", "America/Sao_Paulo"),
("3453150", "Ponta Porã", "Понта-Поран", "BR", "76", "", "11", "5006606", "", "-22.53611", "-55.72556", "America/Campo_Grande"),
("3453158", "Pontalina", "", "BR", "76", "", "29", "5217708", "", "-17.525", "-49.44722", "America/Sao_Paulo"),
("3453171", "Pontal", "", "BR", "76", "", "27", "3540200", "", "-21.0225", "-48.03722", "America/Sao_Paulo"),
("3453186", "Ponta Grossa", "Понта-Гроса", "BR", "76", "", "18", "4119905", "", "-25.095", "-50.16194", "America/Sao_Paulo"),
("3453240", "Pompéu", "", "BR", "76", "", "15", "3152006", "", "-19.22444", "-44.93528", "America/Sao_Paulo"),
("3453242", "Pompéia", "", "BR", "76", "", "27", "3540002", "", "-22.10861", "-50.17167", "America/Sao_Paulo"),
("3453245", "Pomerode", "", "BR", "76", "", "26", "4213203", "", "-26.74056", "-49.17694", "America/Sao_Paulo"),
("3453300", "Poço Verde", "", "BR", "76", "", "28", "2805505", "", "-10.70833", "-38.18333", "America/Bahia"),
("3453303", "Poços de Caldas", "Посус-ди-Калдас", "BR", "76", "", "15", "3151800", "", "-21.78778", "-46.56139", "America/Sao_Paulo"),
("3453315", "Poconé", "", "BR", "76", "", "14", "5106505", "", "-16.25667", "-56.62278", "America/Cuiaba"),
("3453337", "Poções", "", "BR", "76", "", "05", "2925105", "", "-14.52972", "-40.36528", "America/Bahia"),
("3453406", "Poá", "", "BR", "76", "", "27", "3539806", "", "-23.52806", "-46.34472", "America/Sao_Paulo"),
("3453420", "Planaltina", "", "BR", "76", "", "29", "5217609", "", "-15.45278", "-47.61417", "America/Sao_Paulo"),
("3453435", "Piúma", "", "BR", "76", "", "08", "3204203", "", "-20.83778", "-40.72194", "America/Sao_Paulo"),
("3453439", "Piuí", "", "BR", "76", "", "15", "3151503", "", "-20.46528", "-45.95806", "America/Sao_Paulo"),
("3453457", "Pitangui", "", "BR", "76", "", "15", "3151404", "", "-19.68278", "-44.89028", "America/Sao_Paulo"),
("3453467", "Pitangueiras", "", "BR", "76", "", "27", "3539509", "", "-21.00944", "-48.22167", "America/Sao_Paulo"),
("3453478", "Pitanga", "", "BR", "76", "", "18", "4119608", "", "-24.75722", "-51.76139", "America/Sao_Paulo"),
("3453494", "Piritiba", "", "BR", "76", "", "05", "2924801", "", "-11.73028", "-40.55528", "America/Bahia"),
("3453503", "Pires do Rio", "Пирес-ду-Риу", "BR", "76", "", "29", "5217401", "", "-17.29972", "-48.27944", "America/Sao_Paulo"),
("3453512", "Pirenópolis", "", "BR", "76", "", "29", "5217302", "", "-15.85072", "-48.96087", "America/Sao_Paulo"),
("3453535", "Piraquara", "", "BR", "76", "", "18", "4119509", "", "-25.44227", "-49.06795", "America/Sao_Paulo"),
("3453542", "Pirapozinho", "", "BR", "76", "", "27", "3539202", "", "-22.27528", "-51.5", "America/Sao_Paulo"),
("3453544", "Pirapora do Bom Jesus", "", "BR", "76", "", "27", "3539103", "", "-23.39694", "-47.00222", "America/Sao_Paulo"),
("3453546", "Pirapora", "", "BR", "76", "", "15", "3151206", "", "-17.345", "-44.94194", "America/Sao_Paulo"),
("3453586", "Piranhas", "", "BR", "76", "", "29", "5217203", "", "-16.42694", "-51.82222", "America/Sao_Paulo"),
("3453605", "Pirajuí", "", "BR", "76", "", "27", "3538907", "", "-21.99861", "-49.45722", "America/Sao_Paulo"),
("3453610", "Piraju", "", "BR", "76", "", "27", "3538808", "", "-23.19361", "-49.38389", "America/Sao_Paulo"),
("3453622", "Piraí do Sul", "", "BR", "76", "", "18", "4119400", "", "-24.52611", "-49.94861", "America/Sao_Paulo"),
("3453635", "Piraí", "", "BR", "76", "", "21", "3304003", "", "-22.62917", "-43.89806", "America/Sao_Paulo"),
("3453639", "Pirassununga", "Пирасунунга", "BR", "76", "", "27", "3539301", "", "-21.99611", "-47.42583", "America/Sao_Paulo"),
("3453643", "Piracicaba", "Пирасикаба", "BR", "76", "", "27", "3538709", "", "-22.72528", "-47.64917", "America/Sao_Paulo"),
("3453659", "Piracanjuba", "", "BR", "76", "", "29", "5217104", "", "-17.30278", "-49.01667", "America/Sao_Paulo"),
("3453661", "Piracaia", "", "BR", "76", "", "27", "3538600", "", "-23.05389", "-46.35806", "America/Sao_Paulo"),
("3453682", "Piquete", "", "BR", "76", "", "27", "3538501", "", "-22.61361", "-45.17611", "America/Sao_Paulo"),
("3453741", "Pinheiro Machado", "", "BR", "76", "", "23", "4314506", "", "-31.57833", "-53.38111", "America/Sao_Paulo"),
("3453767", "Pinheiral", "", "BR", "76", "", "21", "3303955", "", "-22.51278", "-44.00056", "America/Sao_Paulo"),
("3453777", "Pinhão", "", "BR", "76", "", "18", "4119301", "", "-25.69556", "-51.65972", "America/Sao_Paulo"),
("3453807", "Espírito Santo do Pinhal", "", "BR", "76", "", "27", "3548104", "", "-22.11583", "-46.68278", "America/Sao_Paulo"),
("3453821", "Pindorama", "", "BR", "76", "", "27", "3538105", "", "-21.18583", "-48.90722", "America/Sao_Paulo"),
("3453827", "Pindobaçu", "", "BR", "76", "", "05", "2924603", "", "-10.74167", "-40.36083", "America/Bahia"),
("3453837", "Pindamonhangaba", "Пиндамоньянгаба", "BR", "76", "", "27", "3538006", "", "-22.92389", "-45.46167", "America/Sao_Paulo"),
("3453896", "Pilar do Sul", "", "BR", "76", "", "27", "3537909", "", "-23.81306", "-47.71639", "America/Sao_Paulo"),
("3453926", "Piedade", "", "BR", "76", "", "27", "3537800", "", "-23.71194", "-47.42778", "America/Sao_Paulo"),
("3454005", "Piaçabuçu", "", "BR", "76", "", "02", "2706802", "", "-10.40556", "-36.43444", "America/Maceio"),
("3454031", "Petrópolis", "Петрополис", "BR", "76", "", "21", "3303906", "", "-22.505", "-43.17861", "America/Sao_Paulo"),
("3454032", "Petrolina de Goiás", "", "BR", "76", "", "29", "5216809", "", "-16.095", "-49.33806", "America/Sao_Paulo"),
("3454061", "Peruíbe", "Перуиби", "BR", "76", "", "27", "3537602", "", "-24.32", "-46.99833", "America/Sao_Paulo"),
("3454131", "Pereira Barreto", "", "BR", "76", "", "27", "3537404", "", "-20.63833", "-51.10917", "America/Sao_Paulo"),
("3454139", "Perdões", "", "BR", "76", "", "15", "3149903", "", "-21.09083", "-45.09139", "America/Sao_Paulo"),
("3454213", "Penha", "Пенья", "BR", "76", "", "26", "4212502", "", "-26.76944", "-48.64583", "America/Sao_Paulo"),
("3454231", "Penedo", "", "BR", "76", "", "02", "2706703", "", "-10.29028", "-36.58639", "America/Maceio"),
("3454235", "Penápolis", "Пенаполис", "BR", "76", "", "27", "3537305", "", "-21.41972", "-50.0775", "America/Sao_Paulo"),
("3454244", "Pelotas", "Пелотас", "BR", "76", "", "23", "4314407", "", "-31.77194", "-52.3425", "America/Sao_Paulo"),
("3454358", "Pedro Leopoldo", "", "BR", "76", "", "15", "3149309", "", "-19.61806", "-44.04306", "America/Sao_Paulo"),
("3454407", "Pedreira", "Педрейра", "BR", "76", "", "27", "3537107", "", "-22.74194", "-46.90139", "America/Sao_Paulo"),
("3454408", "Pedregulho", "", "BR", "76", "", "27", "3537008", "", "-20.25694", "-47.47667", "America/Sao_Paulo"),
("3454578", "Pedra Azul", "", "BR", "76", "", "15", "3148707", "", "-16.00528", "-41.29722", "America/Sao_Paulo"),
("3454620", "Pederneiras", "", "BR", "76", "", "27", "3536703", "", "-22.35167", "-48.775", "America/Sao_Paulo"),
("3454628", "Peçanha", "", "BR", "76", "", "15", "3148608", "", "-18.54861", "-42.55694", "America/Sao_Paulo"),
("3454632", "Peabiru", "", "BR", "76", "", "18", "4118808", "", "-23.91278", "-52.34306", "America/Sao_Paulo"),
("3454690", "Paulínia", "Паулиния", "BR", "76", "", "27", "3536505", "", "-22.76111", "-47.15417", "America/Sao_Paulo"),
("3454743", "Pau Brasil", "", "BR", "76", "", "05", "2923902", "", "-15.46417", "-39.65111", "America/Bahia"),
("3454763", "Patrocínio", "Патросиниу", "BR", "76", "", "15", "3148103", "", "-18.94389", "-46.9925", "America/Sao_Paulo"),
("3454783", "Patos de Minas", "Патус-ди-Минас", "BR", "76", "", "15", "3148004", "", "-18.57889", "-46.51806", "America/Sao_Paulo"),
("3454818", "Pato Branco", "Пату-Бранку", "BR", "76", "", "18", "4118501", "", "-26.22861", "-52.67056", "America/Sao_Paulo"),
("3454827", "Paty do Alferes", "Пати-ду-Алферис", "BR", "76", "", "21", "3303856", "", "-22.42861", "-43.41861", "America/Sao_Paulo"),
("3454847", "Passos", "Пассос", "BR", "76", "", "15", "3147907", "", "-20.71889", "-46.60972", "America/Sao_Paulo"),
("3454857", "Passo Fundo", "Пасу-Фунду", "BR", "76", "", "23", "4314100", "", "-28.26278", "-52.40667", "America/Sao_Paulo"),
("3454901", "Passa Quatro", "", "BR", "76", "", "15", "3147600", "", "-22.39028", "-44.96667", "America/Sao_Paulo"),
("3454954", "Parobé", "", "BR", "76", "", "23", "4314050", "", "-29.62861", "-50.83472", "America/Sao_Paulo"),
("3454967", "Pariquera Açu", "", "BR", "76", "", "27", "3536208", "", "-24.715", "-47.88111", "America/Sao_Paulo"),
("3454968", "Paripiranga", "", "BR", "76", "", "05", "2923803", "", "-10.6875", "-37.86167", "America/Bahia"),
("3455020", "Paraúna", "", "BR", "76", "", "29", "5216403", "", "-16.94778", "-50.44861", "America/Sao_Paulo"),
("3455029", "Paratinga", "", "BR", "76", "", "05", "2923704", "", "-12.69056", "-43.18417", "America/Bahia"),
("3455036", "Paraty", "", "BR", "76", "", "21", "3303807", "", "-23.21778", "-44.71306", "America/Sao_Paulo"),
("3455049", "Paranhos", "", "BR", "76", "", "11", "5006358", "", "-23.89278", "-55.43111", "America/Campo_Grande"),
("3455051", "Paranavaí", "", "BR", "76", "", "18", "4118402", "", "-23.07306", "-52.46528", "America/Sao_Paulo"),
("3455061", "Paranapanema", "", "BR", "76", "", "27", "3535804", "", "-23.3863", "-48.72441", "America/Sao_Paulo"),
("3455065", "Paranaíba", "Паранаиба", "BR", "76", "", "11", "5006309", "", "-19.67722", "-51.19083", "America/Campo_Grande"),
("3455070", "Paranaguá", "Паранагуа", "BR", "76", "", "18", "4118204", "", "-25.51626", "-48.52537", "America/Sao_Paulo"),
("3455082", "Paramirim", "", "BR", "76", "", "05", "2923605", "", "-13.4425", "-42.23889", "America/Bahia"),
("3455089", "Paraisópolis", "", "BR", "76", "", "15", "3147303", "", "-22.55417", "-45.78", "America/Sao_Paulo"),
("3455141", "Paraíba do Sul", "Параиба-ду-Сул", "BR", "76", "", "21", "3303708", "", "-22.15847", "-43.29321", "America/Sao_Paulo"),
("3455152", "Paraguaçu Paulista", "", "BR", "76", "", "27", "3535507", "", "-22.41278", "-50.57583", "America/Sao_Paulo"),
("3455155", "Paraguaçu", "", "BR", "76", "", "15", "3147204", "", "-21.54722", "-45.7375", "America/Sao_Paulo"),
("3455161", "Pará de Minas", "Пара-ди-Минас", "BR", "76", "", "15", "3147105", "", "-19.86028", "-44.60833", "America/Sao_Paulo"),
("3455168", "Paracatu", "Паракату", "BR", "76", "", "15", "3147006", "", "-17.22222", "-46.87472", "America/Sao_Paulo"),
("3455170", "Paracambi", "", "BR", "76", "", "21", "3303609", "", "-22.60829", "-43.7084", "America/Sao_Paulo"),
("3455195", "Papagaios", "", "BR", "76", "", "15", "3146909", "", "-19.44917", "-44.74778", "America/Sao_Paulo"),
("3455251", "Panorama", "", "BR", "76", "", "27", "3535408", "", "-21.35639", "-51.85972", "America/Sao_Paulo"),
("3455277", "Pancas", "", "BR", "76", "", "08", "3204005", "", "-19.225", "-40.85139", "America/Sao_Paulo"),
("3455281", "Panambi", "", "BR", "76", "", "23", "4313904", "", "-28.2925", "-53.50167", "America/Sao_Paulo"),
("3455298", "Palotina", "", "BR", "76", "", "18", "4117909", "", "-24.28389", "-53.84", "America/Sao_Paulo"),
("3455342", "Palmital", "", "BR", "76", "", "27", "3535309", "", "-22.78889", "-50.2175", "America/Sao_Paulo"),
("3455362", "Palmeiras de Goiás", "", "BR", "76", "", "29", "5215702", "", "-16.805", "-49.92583", "America/Sao_Paulo"),
("3455416", "Palmeira das Missões", "", "BR", "76", "", "23", "4313706", "", "-27.89944", "-53.31361", "America/Sao_Paulo"),
("3455425", "Palmeira", "", "BR", "76", "", "18", "4117701", "", "-25.42944", "-50.00639", "America/Sao_Paulo"),
("3455447", "Palmas de Monte Alto", "", "BR", "76", "", "05", "2923407", "", "-14.26722", "-43.16194", "America/Bahia"),
("3455459", "Palmas", "Пальмас", "BR", "76", "", "18", "4117602", "", "-26.48417", "-51.99056", "America/Sao_Paulo"),
("3455461", "Palmares do Sul", "", "BR", "76", "", "23", "4313656", "", "-30.25778", "-50.50972", "America/Sao_Paulo"),
("3455478", "Palhoça", "Пальоса", "BR", "76", "", "26", "4211900", "", "-27.64528", "-48.66778", "America/Sao_Paulo"),
("3455553", "Paiçandu", "", "BR", "76", "", "18", "4117503", "", "-23.4575", "-52.04861", "America/Sao_Paulo"),
("3455568", "Padre Paraíso", "", "BR", "76", "", "15", "3146305", "", "-17.07417", "-41.48444", "America/Sao_Paulo"),
("3455580", "Padre Bernardo", "", "BR", "76", "", "29", "5215603", "", "-15.16595", "-48.28281", "America/Sao_Paulo"),
("3455643", "Pacaembu", "", "BR", "76", "", "27", "3534906", "", "-21.56222", "-51.26056", "America/Sao_Paulo"),
("3455671", "Ouro Preto", "Ору-Прету", "BR", "76", "", "15", "3146107", "", "-20.39484", "-43.50517", "America/Sao_Paulo"),
("3455689", "Ouro Branco", "", "BR", "76", "", "15", "3145901", "", "-20.52334", "-43.69486", "America/Sao_Paulo"),
("3455729", "Ourinhos", "Ориньюс", "BR", "76", "", "27", "3534708", "", "-22.97889", "-49.87056", "America/Sao_Paulo"),
("3455750", "Otacílio Costa", "", "BR", "76", "", "26", "4211751", "", "-27.48306", "-50.12194", "America/Sao_Paulo"),
("3455756", "Osvaldo Cruz", "", "BR", "76", "", "27", "3534609", "", "-21.79667", "-50.87861", "America/Sao_Paulo"),
("3455769", "Osório", "Осорио", "BR", "76", "", "23", "4313508", "", "-29.88667", "-50.26972", "America/Sao_Paulo"),
("3455775", "Osasco", "Осаску", "BR", "76", "", "27", "3534401", "", "-23.5325", "-46.79167", "America/Sao_Paulo"),
("3455777", "Ortigueira", "", "BR", "76", "", "18", "4117305", "", "-24.20833", "-50.94944", "America/Sao_Paulo"),
("3455784", "Orleans", "", "BR", "76", "", "26", "4211702", "", "-28.35889", "-49.29139", "America/Sao_Paulo"),
("3455785", "Orlândia", "", "BR", "76", "", "27", "3534302", "", "-20.72028", "-47.88667", "America/Sao_Paulo"),
("3455786", "Orizona", "", "BR", "76", "", "29", "5215306", "", "-17.03139", "-48.29583", "America/Sao_Paulo"),
("3455903", "Oliveira dos Brejinhos", "", "BR", "76", "", "05", "2923209", "", "-12.31694", "-42.89611", "America/Bahia"),
("3455908", "Oliveira", "Оливейра", "BR", "76", "", "15", "3145604", "", "-20.69639", "-44.82722", "America/Sao_Paulo"),
("3455913", "Olindina", "", "BR", "76", "", "05", "2923100", "", "-11.36667", "-38.33333", "America/Bahia"),
("3455923", "Olímpia", "Олимпия", "BR", "76", "", "27", "3533908", "", "-20.73722", "-48.91472", "America/Sao_Paulo"),
("3456037", "Nuporanga", "", "BR", "76", "", "27", "3533601", "", "-20.73095", "-47.75177", "America/Sao_Paulo"),
("3456060", "Novo Horizonte", "", "BR", "76", "", "27", "3533502", "", "-21.46806", "-49.22083", "America/Sao_Paulo"),
("3456068", "Novo Hamburgo", "Нову-Амбургу", "BR", "76", "", "23", "4313409", "", "-29.67833", "-51.13056", "America/Sao_Paulo"),
("3456070", "Novo Cruzeiro", "", "BR", "76", "", "15", "3145307", "", "-17.46806", "-41.87528", "America/Sao_Paulo"),
("3456102", "Nova Viçosa", "", "BR", "76", "", "05", "2923001", "", "-17.89194", "-39.37194", "America/Bahia"),
("3456110", "Nova Venécia", "", "BR", "76", "", "08", "3203908", "", "-18.71056", "-40.40056", "America/Sao_Paulo"),
("3456115", "Nova Soure", "", "BR", "76", "", "05", "2922904", "", "-11.23333", "-38.48333", "America/Bahia"),
("3456125", "Nova Prata", "", "BR", "76", "", "23", "4313300", "", "-28.78389", "-51.61", "America/Sao_Paulo"),
("3456127", "Nova Petrópolis", "", "BR", "76", "", "23", "4313201", "", "-29.37639", "-51.11444", "America/Sao_Paulo"),
("3456137", "Nova Olímpia", "", "BR", "76", "", "14", "5106232", "", "-14.79722", "-57.28806", "America/Cuiaba"),
("3456138", "Nova Odessa", "", "BR", "76", "", "27", "3533403", "", "-22.7775", "-47.29583", "America/Sao_Paulo"),
("3456146", "Nova Londrina", "", "BR", "76", "", "18", "4117107", "", "-22.76583", "-52.985", "America/Sao_Paulo"),
("3456147", "Nova Lima", "Нова-Лима", "BR", "76", "", "15", "3144805", "", "-19.98556", "-43.84667", "America/Sao_Paulo"),
("3456160", "Nova Iguaçu", "Нова-Игуасу", "BR", "76", "", "21", "3303500", "", "-22.75917", "-43.45111", "America/Sao_Paulo"),
("3456164", "Nova Granada", "", "BR", "76", "", "27", "3533007", "", "-20.53389", "-49.31417", "America/Sao_Paulo"),
("3456166", "Nova Friburgo", "Нова-Фрибургу", "BR", "76", "", "21", "3303401", "", "-22.28194", "-42.53111", "America/Sao_Paulo"),
("3456176", "Nova Era", "", "BR", "76", "", "15", "3144706", "", "-19.75", "-43.0375", "America/Sao_Paulo"),
("3456196", "Nova Aurora", "", "BR", "76", "", "18", "4118402", "", "-22.86667", "-52.56667", "America/Sao_Paulo"),
("3456223", "Nossa Senhora do Socorro", "", "BR", "76", "", "28", "2804805", "", "-10.855", "-37.12611", "America/Maceio"),
("3456234", "Nossa Senhora das Dores", "", "BR", "76", "", "28", "2804607", "", "-10.49167", "-37.19333", "America/Maceio"),
("3456240", "Nossa Senhora da Glória", "", "BR", "76", "", "28", "2804508", "", "-10.21833", "-37.42028", "America/Maceio"),
("3456248", "Nortelândia", "", "BR", "76", "", "14", "5106000", "", "-14.45472", "-56.80278", "America/Cuiaba"),
("3456277", "Nobres", "", "BR", "76", "", "14", "5105903", "", "-14.72028", "-56.3275", "America/Cuiaba"),
("3456283", "Niterói", "Нитерой", "BR", "76", "", "21", "3303302", "", "-22.88333", "-43.10361", "America/Sao_Paulo"),
("3456285", "Niquelândia", "Никеландия", "BR", "76", "", "29", "5214606", "", "-14.47389", "-48.45972", "America/Sao_Paulo"),
("3456290", "Nilópolis", "", "BR", "76", "", "21", "3303203", "", "-22.8075", "-43.41389", "America/Sao_Paulo"),
("3456309", "Nhandeara", "", "BR", "76", "", "27", "3532603", "", "-20.6897", "-50.0407", "America/Sao_Paulo"),
("3456322", "Nerópolis", "Нерополис", "BR", "76", "", "29", "5214507", "", "-16.40639", "-49.21861", "America/Sao_Paulo"),
("3456324", "Nepomuceno", "", "BR", "76", "", "15", "3144607", "", "-21.23342", "-45.23488", "America/Sao_Paulo"),
("3456325", "Neópolis", "", "BR", "76", "", "28", "2804409", "", "-10.32", "-36.57944", "America/Maceio"),
("3456366", "Nazaré", "Назар", "BR", "76", "", "05", "2922508", "", "-13.035", "-39.01444", "America/Bahia"),
("3456368", "Naviraí", "Навираи", "BR", "76", "", "11", "5005707", "", "-23.065", "-54.19056", "America/Campo_Grande"),
("3456370", "Navegantes", "Навегантис", "BR", "76", "", "26", "4211306", "", "-26.89889", "-48.65417", "America/Sao_Paulo"),
("3456377", "Natividade", "", "BR", "76", "", "21", "3303104", "", "-21.04222", "-41.97333", "America/Sao_Paulo"),
("3456397", "Não Me Toque", "", "BR", "76", "", "23", "4312658", "", "-28.45917", "-52.82083", "America/Sao_Paulo"),
("3456398", "Nanuque", "", "BR", "76", "", "15", "3144300", "", "-17.83917", "-40.35389", "America/Sao_Paulo"),
("3456412", "Muzambinho", "", "BR", "76", "", "15", "3144102", "", "-21.37583", "-46.52556", "America/Sao_Paulo"),
("3456445", "Mutum", "", "BR", "76", "", "15", "3144003", "", "-19.8", "-41.43833", "America/Sao_Paulo"),
("3456450", "Mutuípe", "", "BR", "76", "", "05", "2922409", "", "-13.22861", "-39.50472", "America/Bahia"),
("3456483", "Muritiba", "", "BR", "76", "", "05", "2908309", "", "-12.91667", "-39.25", "America/Bahia"),
("3456500", "Muriaé", "Муриаэ", "BR", "76", "", "15", "3143906", "", "-21.13056", "-42.36639", "America/Sao_Paulo"),
("3456530", "Muniz Freire", "", "BR", "76", "", "08", "3203700", "", "-20.46417", "-41.41306", "America/Sao_Paulo"),
("3456559", "Mundo Novo", "", "BR", "76", "", "05", "2922102", "", "-11.85889", "-40.4725", "America/Bahia"),
("3456591", "Mucurici", "", "BR", "76", "", "08", "3203601", "", "-18.09333", "-40.51583", "America/Sao_Paulo"),
("3456593", "Mucuri", "Мукури", "BR", "76", "", "05", "2922003", "", "-18.08639", "-39.55083", "America/Bahia"),
("3456642", "Mozarlândia", "", "BR", "76", "", "29", "5214002", "", "-14.74472", "-50.57056", "America/Sao_Paulo"),
("3456696", "Morro do Chapéu", "", "BR", "76", "", "05", "2921708", "", "-11.54852", "-41.15804", "America/Bahia"),
("3456707", "Morro da Fumaça", "", "BR", "76", "", "26", "4211207", "", "-28.65083", "-49.21", "America/Sao_Paulo"),
("3456724", "Morro Agudo", "", "BR", "76", "", "27", "3531902", "", "-20.73139", "-48.05778", "America/Sao_Paulo"),
("3456735", "Morrinhos", "", "BR", "76", "", "29", "5213806", "", "-17.73111", "-49.09944", "America/Sao_Paulo"),
("3456763", "Moreira Sales", "", "BR", "76", "", "18", "4116109", "", "-24.06222", "-53.00694", "America/Sao_Paulo"),
("3456806", "Monte Sião", "", "BR", "76", "", "15", "3143401", "", "-22.4325", "-46.5725", "America/Sao_Paulo"),
("3456814", "Montes Claros", "Монтис-Кларус", "BR", "76", "", "15", "3143302", "", "-16.735", "-43.86167", "America/Sao_Paulo"),
("3456816", "Monte Santo de Minas", "", "BR", "76", "", "15", "3143203", "", "-21.18972", "-46.98028", "America/Sao_Paulo"),
("3456820", "Monte Santo", "", "BR", "76", "", "05", "2921500", "", "-10.43778", "-39.33278", "America/Bahia"),
("3456826", "Montenegro", "Черногория", "BR", "76", "", "23", "4312401", "", "-29.68861", "-51.46111", "America/Sao_Paulo"),
("3456827", "Monte Mor", "", "BR", "76", "", "27", "3531803", "", "-22.94667", "-47.31583", "America/Sao_Paulo"),
("3456848", "Monte Carmelo", "", "BR", "76", "", "15", "3143104", "", "-18.72472", "-47.49861", "America/Sao_Paulo"),
("3456863", "Monte Azul Paulista", "", "BR", "76", "", "27", "3531506", "", "-20.90722", "-48.64139", "America/Sao_Paulo"),
("3456864", "Monte Azul", "", "BR", "76", "", "15", "3142908", "", "-15.155", "-42.87472", "America/Sao_Paulo"),
("3456866", "Monte Aprazível", "", "BR", "76", "", "27", "3531407", "", "-20.7725", "-49.71417", "America/Sao_Paulo"),
("3456873", "Monte Alto", "", "BR", "76", "", "27", "3531308", "", "-21.26111", "-48.49639", "America/Sao_Paulo"),
("3456879", "Monte Alegre de Sergipe", "", "BR", "76", "", "28", "2804201", "", "-10.02722", "-37.56222", "America/Maceio"),
("3456880", "Monte Alegre de Minas", "", "BR", "76", "", "15", "3142809", "", "-18.87056", "-48.88083", "America/Sao_Paulo"),
("3456905", "Montanha", "", "BR", "76", "", "08", "3203502", "", "-18.12694", "-40.36333", "America/Sao_Paulo"),
("3456944", "Mongaguá", "", "BR", "76", "", "27", "3531100", "", "-24.09306", "-46.62083", "America/Sao_Paulo"),
("3456998", "Mogi Mirim", "Можи-Мирин", "BR", "76", "", "27", "3530805", "", "-22.43194", "-46.95778", "America/Sao_Paulo"),
("3457000", "Mogi Guaçu", "Можи-Гуасу", "BR", "76", "", "27", "3530706", "", "-22.3677", "-46.94552", "America/Sao_Paulo"),
("3457001", "Mogi das Cruzes", "", "BR", "76", "", "27", "3530607", "", "-23.52278", "-46.18833", "America/Sao_Paulo"),
("3457025", "Mococa", "", "BR", "76", "", "27", "3530508", "", "-21.46778", "-47.00472", "America/Sao_Paulo"),
("3457098", "Mirante do Paranapanema", "", "BR", "76", "", "27", "3530201", "", "-22.29194", "-51.90639", "America/Sao_Paulo"),
("3457107", "Mirandopólis", "Мирандополис", "BR", "76", "", "27", "3530102", "", "-21.13361", "-51.10167", "America/Sao_Paulo"),
("3457113", "Miranda", "", "BR", "76", "", "11", "5005608", "", "-20.24056", "-56.37833", "America/Campo_Grande"),
("3457119", "Miraí", "", "BR", "76", "", "15", "3142205", "", "-21.19528", "-42.61417", "America/Sao_Paulo"),
("3457133", "Miracema", "Мирасема", "BR", "76", "", "21", "3303005", "", "-21.41222", "-42.19667", "America/Sao_Paulo"),
("3457135", "Miracatu", "", "BR", "76", "", "27", "3529906", "", "-24.28139", "-47.45972", "America/Sao_Paulo"),
("3457136", "Mirabela", "", "BR", "76", "", "15", "3142007", "", "-16.26278", "-44.16444", "America/Sao_Paulo"),
("3457147", "Mineiros", "", "BR", "76", "", "29", "5213103", "", "-17.56944", "-52.55111", "America/Sao_Paulo"),
("3457152", "Minas Novas", "", "BR", "76", "", "15", "3141801", "", "-17.21861", "-42.59028", "America/Sao_Paulo"),
("3457161", "Mimoso do Sul", "", "BR", "76", "", "08", "3203403", "", "-21.06417", "-41.36639", "America/Sao_Paulo"),
("3457191", "Miguel Pereira", "", "BR", "76", "", "21", "3302908", "", "-22.45389", "-43.46889", "America/Sao_Paulo"),
("3457192", "Miguelópolis", "", "BR", "76", "", "27", "3529708", "", "-20.17944", "-48.03194", "America/Sao_Paulo"),
("3457202", "Miguel Calmon", "", "BR", "76", "", "05", "2921203", "", "-11.42889", "-40.595", "America/Bahia"),
("3457247", "Mendes", "", "BR", "76", "", "21", "3302809", "", "-22.52667", "-43.73278", "America/Sao_Paulo"),
("3457358", "Medina", "", "BR", "76", "", "15", "3141405", "", "-16.2225", "-41.47694", "America/Sao_Paulo"),
("3457359", "Medianeira", "Медианейра", "BR", "76", "", "18", "4115804", "", "-25.29528", "-54.09389", "America/Sao_Paulo"),
("3457360", "Medeiros Neto", "", "BR", "76", "", "05", "2921104", "", "-17.37389", "-40.22056", "America/Bahia"),
("3457381", "Mauá", "", "BR", "76", "", "27", "3529401", "", "-23.66778", "-46.46139", "America/Sao_Paulo"),
("3457393", "Matozinhos", "", "BR", "76", "", "15", "3141108", "", "-19.55778", "-44.08139", "America/Sao_Paulo"),
("3457398", "Mato Verde", "", "BR", "76", "", "15", "3141009", "", "-15.39722", "-42.86639", "America/Sao_Paulo"),
("3457454", "Matipó", "", "BR", "76", "", "15", "3140902", "", "-20.28389", "-42.34111", "America/Sao_Paulo"),
("3457479", "Matias Barbosa", "", "BR", "76", "", "15", "3140803", "", "-21.86917", "-43.31944", "America/Sao_Paulo"),
("3457484", "Mateus Leme", "", "BR", "76", "", "15", "3140704", "", "-19.98639", "-44.42778", "America/Sao_Paulo"),
("3457487", "Matelândia", "", "BR", "76", "", "18", "4115606", "", "-25.24083", "-53.99639", "America/Sao_Paulo"),
("3457509", "Matão", "", "BR", "76", "", "27", "3529302", "", "-21.60333", "-48.36583", "America/Sao_Paulo"),
("3457528", "Mata de São João", "Мата-де-Сан-Жуан", "BR", "76", "", "05", "2921005", "", "-12.53028", "-38.29917", "America/Bahia"),
("3457566", "Mascote", "", "BR", "76", "", "05", "2920908", "", "-15.56306", "-39.3025", "America/Bahia"),
("3457582", "Maruim", "", "BR", "76", "", "28", "2804003", "", "-10.7375", "-37.08167", "America/Maceio"),
("3457595", "Martinópolis", "", "BR", "76", "", "27", "3529203", "", "-22.14583", "-51.17083", "America/Sao_Paulo"),
("3457598", "Martinho Campos", "", "BR", "76", "", "15", "3140506", "", "-19.33167", "-45.23694", "America/Sao_Paulo"),
("3457671", "Maringá", "Маринга", "BR", "76", "", "18", "4115200", "", "-23.42528", "-51.93861", "America/Sao_Paulo"),
("3457692", "Marília", "Марилья", "BR", "76", "", "27", "3529005", "", "-22.21389", "-49.94583", "America/Sao_Paulo"),
("3457708", "Maricá", "", "BR", "76", "", "21", "3302700", "", "-22.91944", "-42.81861", "America/Sao_Paulo"),
("3457736", "Mariana", "Мариана", "BR", "76", "", "15", "3140001", "", "-20.37778", "-43.41611", "America/Sao_Paulo"),
("3457741", "Marialva", "", "BR", "76", "", "18", "4114807", "", "-23.485", "-51.79167", "America/Sao_Paulo"),
("3457770", "Marechal Floriano", "", "BR", "76", "", "08", "3203346", "", "-20.41278", "-40.68306", "America/Sao_Paulo"),
("3457772", "Marechal Cândido Rondon", "", "BR", "76", "", "18", "4114609", "", "-24.55611", "-54.05667", "America/Sao_Paulo"),
("3457776", "Mar de Espanha", "", "BR", "76", "", "15", "3139805", "", "-21.86722", "-43.00972", "America/Sao_Paulo"),
("3457817", "Marau", "", "BR", "76", "", "23", "4311809", "", "-28.44917", "-52.2", "America/Sao_Paulo"),
("3457819", "Marataizes", "", "BR", "76", "", "08", "3203320", "", "-21.04333", "-40.82444", "America/Sao_Paulo"),
("3457850", "Maragogipe", "", "BR", "76", "", "05", "2920601", "", "-12.77778", "-38.91944", "America/Bahia"),
("3457854", "Maracás", "", "BR", "76", "", "05", "2920502", "", "-13.44111", "-40.43083", "America/Bahia"),
("3457859", "Maracaju", "", "BR", "76", "", "11", "5005400", "", "-21.61444", "-55.16833", "America/Campo_Grande"),
("3457862", "Maracaí", "", "BR", "76", "", "27", "3528809", "", "-22.61056", "-50.66722", "America/Sao_Paulo"),
("3457928", "Mantenópolis", "", "BR", "76", "", "08", "3203304", "", "-18.8625", "-41.12278", "America/Sao_Paulo"),
("3457950", "Manhumirim", "", "BR", "76", "", "15", "3139508", "", "-20.35778", "-41.95806", "America/Sao_Paulo"),
("3457952", "Manhuaçu", "Маньюасу", "BR", "76", "", "15", "3139409", "", "-20.25806", "-42.03361", "America/Sao_Paulo"),
("3457991", "Mangaratiba", "", "BR", "76", "", "21", "3302601", "", "-22.95972", "-44.04056", "America/Sao_Paulo"),
("3458020", "Manga", "", "BR", "76", "", "15", "3139300", "", "-14.75583", "-43.93222", "America/Sao_Paulo"),
("3458049", "Mandaguari", "", "BR", "76", "", "18", "4114203", "", "-23.5475", "-51.67083", "America/Sao_Paulo"),
("3458051", "Mandaguaçu", "", "BR", "76", "", "18", "4114104", "", "-23.34722", "-52.09528", "America/Sao_Paulo"),
("3458093", "Malhador", "", "BR", "76", "", "28", "2803906", "", "-10.65778", "-37.30472", "America/Maceio"),
("3458121", "Malacacheta", "", "BR", "76", "", "15", "3139201", "", "-17.84222", "-42.07667", "America/Sao_Paulo"),
("3458131", "Mairiporã", "Майрипоран", "BR", "76", "", "27", "3528502", "", "-23.31861", "-46.58667", "America/Sao_Paulo"),
("3458132", "Mairinque", "Майринки", "BR", "76", "", "27", "3528403", "", "-23.54583", "-47.18333", "America/Sao_Paulo"),
("3458134", "Mairi", "", "BR", "76", "", "05", "2920106", "", "-11.71139", "-40.14889", "America/Bahia"),
("3458147", "Mafra", "Мафре", "BR", "76", "", "26", "4210100", "", "-26.11139", "-49.80528", "America/Sao_Paulo"),
("3458161", "Madre de Deus", "", "BR", "76", "", "05", "2919926", "", "-12.74083", "-38.62083", "America/Bahia"),
("3458211", "Machado", "", "BR", "76", "", "15", "3139003", "", "-21.67472", "-45.91972", "America/Sao_Paulo"),
("3458237", "Macaúbas", "", "BR", "76", "", "05", "2919801", "", "-13.01944", "-42.69861", "America/Bahia"),
("3458245", "Macatuba", "", "BR", "76", "", "27", "3528007", "", "-22.50222", "-48.71139", "America/Sao_Paulo"),
("3458266", "Macaé", "Макаэ", "BR", "76", "", "21", "3302403", "", "-22.37083", "-41.78694", "America/Sao_Paulo"),
("3458329", "Luziânia", "", "BR", "76", "", "29", "5212501", "", "-16.2525", "-47.95028", "America/Sao_Paulo"),
("3458333", "Luz", "", "BR", "76", "", "15", "3138807", "", "-19.80139", "-45.68556", "America/Sao_Paulo"),
("3458390", "Lucélia", "", "BR", "76", "", "27", "3527405", "", "-21.72028", "-51.01889", "America/Sao_Paulo"),
("3458397", "Lucas", "Лукас", "BR", "76", "", "14", "5101605", "", "-16.33333", "-55.93333", "America/Cuiaba"),
("3458406", "Louveira", "", "BR", "76", "", "27", "3527306", "", "-23.08639", "-46.95056", "America/Sao_Paulo"),
("3458425", "Lorena", "", "BR", "76", "", "27", "3527207", "", "-22.73083", "-45.12472", "America/Sao_Paulo"),
("3458449", "Londrina", "Лондрина", "BR", "76", "", "18", "4113700", "", "-23.31028", "-51.16278", "America/Sao_Paulo"),
("3458479", "Loanda", "", "BR", "76", "", "18", "4113502", "", "-22.92306", "-53.13722", "America/Sao_Paulo"),
("3458481", "Livramento do Brumado", "", "BR", "76", "", "05", "2919504", "", "-13.65145", "-41.84564", "America/Bahia"),
("3458494", "Lins", "Линс", "BR", "76", "", "27", "3527108", "", "-21.67861", "-49.7425", "America/Sao_Paulo"),
("3458498", "Linhares", "", "BR", "76", "", "08", "3203205", "", "-19.39111", "-40.07222", "America/Sao_Paulo"),
("3458575", "Limeira", "Лимейра", "BR", "76", "", "27", "3526902", "", "-22.56472", "-47.40167", "America/Sao_Paulo"),
("3458591", "Lima Duarte", "", "BR", "76", "", "15", "3138609", "", "-21.8425", "-43.79306", "America/Sao_Paulo"),
("3458632", "Leopoldina", "", "BR", "76", "", "15", "3138401", "", "-21.53194", "-42.64306", "America/Sao_Paulo"),
("3458645", "Lençóis Paulista", "", "BR", "76", "", "27", "3526803", "", "-22.59861", "-48.80028", "America/Sao_Paulo"),
("3458662", "Leme", "Лем", "BR", "76", "", "27", "3526704", "", "-22.18556", "-47.39028", "America/Sao_Paulo"),
("3458696", "Lavras", "Лаврас", "BR", "76", "", "15", "3138203", "", "-21.24528", "-44.99972", "America/Sao_Paulo"),
("3458721", "Lauro Muller", "", "BR", "76", "", "26", "4209607", "", "-28.39278", "-49.39667", "America/Sao_Paulo"),
("3458746", "Laranjeiras do Sul", "", "BR", "76", "", "18", "4113304", "", "-25.40778", "-52.41611", "America/Sao_Paulo"),
("3458778", "Laranjeiras", "", "BR", "76", "", "28", "2803609", "", "-10.80639", "-37.17", "America/Maceio"),
("3458786", "Laranjal Paulista", "", "BR", "76", "", "27", "3526407", "", "-23.04972", "-47.83667", "America/Sao_Paulo"),
("3458817", "Lapão", "", "BR", "76", "", "05", "2919157", "", "-11.38333", "-41.83194", "America/Bahia"),
("3458826", "Lapa", "", "BR", "76", "", "18", "4113205", "", "-25.76972", "-49.71583", "America/Sao_Paulo"),
("3458881", "Lambari", "", "BR", "76", "", "15", "3137809", "", "-21.97556", "-45.35028", "America/Sao_Paulo"),
("3458902", "Lajinha", "", "BR", "76", "", "15", "3137700", "", "-20.15139", "-41.62278", "America/Sao_Paulo"),
("3458930", "Lages", "Лажис", "BR", "76", "", "26", "4209300", "", "-27.81611", "-50.32611", "America/Sao_Paulo"),
("3459035", "Lajeado", "", "BR", "76", "", "23", "4311403", "", "-29.46694", "-51.96139", "America/Sao_Paulo"),
("3459094", "Laguna", "Лагуна", "BR", "76", "", "26", "4209409", "", "-28.4825", "-48.78083", "America/Sao_Paulo"),
("3459126", "Lagoa Vermelha", "", "BR", "76", "", "23", "4311304", "", "-28.20861", "-51.52583", "America/Sao_Paulo"),
("3459138", "Lagoa Santa", "", "BR", "76", "", "15", "3137601", "", "-19.63006", "-43.9009", "America/Sao_Paulo"),
("3459181", "Lagoa Formosa", "", "BR", "76", "", "15", "3137502", "", "-18.77861", "-46.4075", "America/Sao_Paulo"),
("3459251", "Lagoa da Prata", "", "BR", "76", "", "15", "3137205", "", "-20.0225", "-45.54361", "America/Sao_Paulo"),
("3459303", "Lagoa", "", "BR", "76", "", "26", "4205407", "", "-27.60491", "-48.46713", "America/Sao_Paulo"),
("3459342", "Lagarto", "", "BR", "76", "", "28", "2803500", "", "-10.91722", "-37.65", "America/Maceio"),
("3459352", "Ladário", "", "BR", "76", "", "11", "5005202", "", "-19.00472", "-57.60167", "America/Campo_Grande"),
("3459435", "Juquitiba", "", "BR", "76", "", "27", "3526209", "", "-23.93167", "-47.06833", "America/Sao_Paulo"),
("3459440", "Juquiá", "", "BR", "76", "", "27", "3526100", "", "-24.32083", "-47.63472", "America/Sao_Paulo"),
("3459452", "Junqueirópolis", "", "BR", "76", "", "27", "3526001", "", "-21.51472", "-51.43361", "America/Sao_Paulo"),
("3459462", "Jundiaí", "Жундиаи", "BR", "76", "", "27", "3525904", "", "-23.18639", "-46.88417", "America/Sao_Paulo"),
("3459495", "Júlio de Castilhos", "", "BR", "76", "", "23", "4311205", "", "-29.22694", "-53.68167", "America/Sao_Paulo"),
("3459505", "Juiz de Fora", "Жуис-ди-Фора", "BR", "76", "", "15", "3136702", "", "-21.76417", "-43.35028", "America/Sao_Paulo"),
("3459550", "Juatuba", "", "BR", "76", "", "15", "3136652", "", "-19.95194", "-44.34278", "America/Sao_Paulo"),
("3459667", "José Bonifácio", "", "BR", "76", "", "27", "3525706", "", "-21.05278", "-49.68833", "America/Sao_Paulo"),
("3459712", "Joinville", "Жоинвили", "BR", "76", "", "26", "4209102", "", "-26.30444", "-48.84556", "America/Sao_Paulo"),
("3459785", "João Pinheiro", "", "BR", "76", "", "15", "3136306", "", "-17.7425", "-46.1725", "America/Sao_Paulo"),
("3459795", "João Neiva", "", "BR", "76", "", "08", "3203130", "", "-19.7575", "-40.38556", "America/Sao_Paulo"),
("3459796", "João Monlevade", "Жуан-Монлевади", "BR", "76", "", "15", "3136207", "", "-19.81", "-43.17361", "America/Sao_Paulo"),
("3459855", "Joanópolis", "", "BR", "76", "", "27", "3525508", "", "-22.93028", "-46.27556", "America/Sao_Paulo"),
("3459867", "Joaíma", "", "BR", "76", "", "15", "3136009", "", "-16.65417", "-41.03056", "America/Sao_Paulo"),
("3459869", "Joaçaba", "Жоасаба", "BR", "76", "", "26", "4209003", "", "-27.17806", "-51.50472", "America/Sao_Paulo"),
("3459876", "Jitaúna", "", "BR", "76", "", "05", "2918308", "", "-14.01274", "-39.89833", "America/Bahia"),
("3459901", "Jetibá", "", "BR", "76", "", "08", "3204559", "", "-20.02069", "-40.68145", "America/Sao_Paulo"),
("3459909", "Jerônimo Monteiro", "", "BR", "76", "", "08", "3203106", "", "-20.78944", "-41.395", "America/Sao_Paulo"),
("3459922", "Jeremoabo", "", "BR", "76", "", "05", "2918100", "", "-10.075", "-38.48083", "America/Bahia"),
("3459925", "Jequitinhonha", "", "BR", "76", "", "15", "3135803", "", "-16.43389", "-41.00333", "America/Sao_Paulo"),
("3459943", "Jequié", "Жекие", "BR", "76", "", "05", "2918001", "", "-13.85875", "-40.08512", "America/Bahia"),
("3460005", "Jaú", "Жау", "BR", "76", "", "27", "3525300", "", "-22.29639", "-48.55778", "America/Sao_Paulo"),
("3460048", "Jataizinho", "", "BR", "76", "", "18", "4112702", "", "-23.25417", "-50.98", "America/Sao_Paulo"),
("3460064", "Jataí", "", "BR", "76", "", "29", "5211909", "", "-17.87939", "-51.72166", "America/Sao_Paulo"),
("3460068", "Jarinu", "", "BR", "76", "", "27", "3525201", "", "-23.10139", "-46.72833", "America/Sao_Paulo"),
("3460071", "Jardinópolis", "", "BR", "76", "", "27", "3525102", "", "-21.01778", "-47.76389", "America/Sao_Paulo"),
("3460087", "Jardim", "", "BR", "76", "", "11", "5005004", "", "-21.48028", "-56.13806", "America/Campo_Grande"),
("3460102", "Jaraguá do Sul", "Жарагуа-ду-Сул", "BR", "76", "", "26", "4208906", "", "-26.48611", "-49.06667", "America/Sao_Paulo"),
("3460107", "Jaraguá", "", "BR", "76", "", "29", "5211800", "", "-15.75694", "-49.33444", "America/Sao_Paulo"),
("3460132", "Japeri", "", "BR", "76", "", "21", "3302270", "", "-22.64306", "-43.65333", "America/Sao_Paulo"),
("3460136", "Japaratuba", "", "BR", "76", "", "28", "2803302", "", "-10.59333", "-36.94028", "America/Maceio"),
("3460148", "Januária", "", "BR", "76", "", "15", "3135209", "", "-15.48866", "-44.35988", "America/Sao_Paulo"),
("3460170", "Jandira", "", "BR", "76", "", "27", "3525003", "", "-23.5275", "-46.9025", "America/Sao_Paulo"),
("3460172", "Jandaia do Sul", "", "BR", "76", "", "18", "4112108", "", "-23.60306", "-51.64333", "America/Sao_Paulo"),
("3460174", "Janaúba", "", "BR", "76", "", "15", "3135100", "", "-15.8025", "-43.30889", "America/Sao_Paulo"),
("3460186", "Jales", "", "BR", "76", "", "27", "3524808", "", "-20.26889", "-50.54583", "America/Sao_Paulo"),
("3460197", "Jaguaruna", "", "BR", "76", "", "26", "4208807", "", "-28.62145", "-49.02529", "America/Sao_Paulo"),
("3460200", "Jaguariúna", "", "BR", "76", "", "27", "3524709", "", "-22.70556", "-46.98583", "America/Sao_Paulo"),
("3460214", "Jaguariaíva", "", "BR", "76", "", "18", "4112009", "", "-24.24423", "-49.70932", "America/Sao_Paulo"),
("3460225", "Jaguarari", "", "BR", "76", "", "05", "2917706", "", "-10.26389", "-40.19583", "America/Bahia"),
("3460232", "Jaguarão", "", "BR", "76", "", "23", "4311007", "", "-32.56611", "-53.37583", "America/Sao_Paulo"),
("3460242", "Jaguaquara", "", "BR", "76", "", "05", "2917607", "", "-13.53056", "-39.97083", "America/Bahia"),
("3460267", "Jacutinga", "", "BR", "76", "", "15", "3134905", "", "-22.28556", "-46.61222", "America/Sao_Paulo"),
("3460281", "Jacupiranga", "", "BR", "76", "", "27", "3524600", "", "-24.6925", "-48.00222", "America/Sao_Paulo"),
("3460344", "Jacobina", "", "BR", "76", "", "05", "2917508", "", "-11.18143", "-40.51372", "America/Bahia"),
("3460355", "Jaciara", "", "BR", "76", "", "14", "5104807", "", "-15.96528", "-54.96833", "America/Cuiaba"),
("3460362", "Jacarezinho", "Жакарезинью", "BR", "76", "", "18", "4111803", "", "-23.16056", "-49.96944", "America/Sao_Paulo"),
("3460370", "Jacareí", "Жакареи", "BR", "76", "", "27", "3524402", "", "-23.30528", "-45.96583", "America/Sao_Paulo"),
("3460441", "Jaboticabal", "Жаботикабал", "BR", "76", "", "27", "3524303", "", "-21.25472", "-48.32222", "America/Sao_Paulo"),
("3460484", "Ivoti", "", "BR", "76", "", "23", "4310801", "", "-29.59111", "-51.16056", "America/Sao_Paulo"),
("3460505", "Iúna", "", "BR", "76", "", "08", "3203007", "", "-20.34583", "-41.53583", "America/Sao_Paulo"),
("3460511", "Ituverava", "", "BR", "76", "", "27", "3524105", "", "-20.33944", "-47.78056", "America/Sao_Paulo"),
("3460513", "Iturama", "Итурама", "BR", "76", "", "15", "3134400", "", "-19.72806", "-50.19556", "America/Sao_Paulo"),
("3460516", "Itupeva", "", "BR", "76", "", "27", "3524006", "", "-23.15306", "-47.05778", "America/Sao_Paulo"),
("3460522", "Itumbiara", "Итумбиара", "BR", "76", "", "29", "5211503", "", "-18.41917", "-49.21528", "America/Sao_Paulo"),
("3460523", "Ituiutaba", "Итиютаба", "BR", "76", "", "15", "3134202", "", "-18.97428", "-49.46212", "America/Sao_Paulo"),
("3460530", "Ituberá", "", "BR", "76", "", "05", "2917300", "", "-13.73222", "-39.14917", "America/Bahia"),
("3460535", "Itu", "Иту", "BR", "76", "", "27", "3523909", "", "-23.26417", "-47.29917", "America/Sao_Paulo"),
("3460542", "Itororó", "", "BR", "76", "", "05", "2917102", "", "-15.11694", "-40.07028", "America/Bahia"),
("3460549", "Itiruçu", "", "BR", "76", "", "05", "2916906", "", "-13.53167", "-40.15028", "America/Bahia"),
("3460553", "Itirapina", "", "BR", "76", "", "27", "3523602", "", "-22.25278", "-47.82278", "America/Sao_Paulo"),
("3460584", "Itaúna", "", "BR", "76", "", "15", "3133808", "", "-20.07528", "-44.57639", "America/Sao_Paulo"),
("3460588", "Itaú de Minas", "", "BR", "76", "", "15", "3133758", "", "-20.73944", "-46.75222", "America/Sao_Paulo"),
("3460594", "Itatinga", "", "BR", "76", "", "27", "3523503", "", "-23.10167", "-48.61583", "America/Sao_Paulo"),
("3460598", "Itatiba", "", "BR", "76", "", "27", "3523404", "", "-23.00583", "-46.83889", "America/Sao_Paulo"),
("3460602", "Itatiaia", "", "BR", "76", "", "21", "3302254", "", "-22.49611", "-44.56333", "America/Sao_Paulo"),
("3460620", "Itararé", "Итараре", "BR", "76", "", "27", "3523206", "", "-24.1125", "-49.33167", "America/Sao_Paulo"),
("3460622", "Itarantim", "", "BR", "76", "", "05", "2916807", "", "-15.65972", "-40.06556", "America/Bahia"),
("3460629", "Itaqui", "Итака", "BR", "76", "", "23", "4310603", "", "-29.12528", "-56.55306", "America/Sao_Paulo"),
("3460644", "Itaquaquecetuba", "", "BR", "76", "", "27", "3523107", "", "-23.48611", "-46.34833", "America/Sao_Paulo"),
("3460648", "Itapuranga", "", "BR", "76", "", "29", "5211206", "", "-15.56222", "-49.94861", "America/Sao_Paulo"),
("3460651", "Itapuí", "", "BR", "76", "", "27", "3522901", "", "-22.23333", "-48.71917", "America/Sao_Paulo"),
("3460666", "Itaporanga", "", "BR", "76", "", "27", "3522802", "", "-23.70778", "-49.48972", "America/Sao_Paulo"),
("3460671", "Itápolis", "", "BR", "76", "", "27", "3522703", "", "-21.59556", "-48.81278", "America/Sao_Paulo"),
("3460697", "Itapirapuã", "", "BR", "76", "", "29", "5211008", "", "-15.82333", "-50.61333", "America/Sao_Paulo"),
("3460699", "Itapira", "", "BR", "76", "", "27", "3522604", "", "-22.43611", "-46.82167", "America/Sao_Paulo"),
("3460718", "Itapevi", "", "BR", "76", "", "27", "3522505", "", "-23.54889", "-46.93417", "America/Sao_Paulo"),
("3460723", "Itapeva", "", "BR", "76", "", "27", "3522406", "", "-23.98222", "-48.87556", "America/Sao_Paulo"),
("3460728", "Itapetininga", "Итапетининга", "BR", "76", "", "27", "3522307", "", "-23.59167", "-48.05306", "America/Sao_Paulo"),
("3460730", "Itapetinga", "", "BR", "76", "", "05", "2916401", "", "-15.24889", "-40.24778", "America/Bahia"),
("3460733", "Itaperuna", "", "BR", "76", "", "21", "3302205", "", "-21.205", "-41.88778", "America/Sao_Paulo"),
("3460734", "Itaperuçu", "", "BR", "76", "", "18", "4111258", "", "-25.22", "-49.34778", "America/Sao_Paulo"),
("3460738", "Itapemirim", "", "BR", "76", "", "08", "3202801", "", "-21.01111", "-40.83389", "America/Sao_Paulo"),
("3460740", "Itapema", "Итапема", "BR", "76", "", "26", "4208302", "", "-27.09028", "-48.61139", "America/Sao_Paulo"),
("3460748", "Itapecerica da Serra", "Итапесерика-да-Серра", "BR", "76", "", "27", "3522208", "", "-23.71694", "-46.84917", "America/Sao_Paulo"),
("3460752", "Itapecerica", "", "BR", "76", "", "15", "3133501", "", "-20.4725", "-45.12556", "America/Sao_Paulo"),
("3460764", "Itaparica", "", "BR", "76", "", "05", "2916104", "", "-12.88833", "-38.67861", "America/Bahia"),
("3460773", "Itapaci", "", "BR", "76", "", "29", "5210901", "", "-14.95083", "-49.54944", "America/Sao_Paulo"),
("3460774", "Itaocara", "", "BR", "76", "", "21", "3302106", "", "-21.66917", "-42.07611", "America/Sao_Paulo"),
("3460785", "Itanhém", "", "BR", "76", "", "05", "2916005", "", "-17.16639", "-40.33", "America/Bahia"),
("3460788", "Itanhandu", "", "BR", "76", "", "15", "3133105", "", "-22.29583", "-44.93472", "America/Sao_Paulo"),
("3460791", "Itanhaém", "", "BR", "76", "", "27", "3522109", "", "-24.18306", "-46.78889", "America/Sao_Paulo"),
("3460813", "Itambé", "", "BR", "76", "", "05", "2915809", "", "-15.245", "-40.62444", "America/Bahia"),
("3460817", "Itambacuri", "", "BR", "76", "", "15", "3132701", "", "-18.03111", "-41.685", "America/Sao_Paulo"),
("3460825", "Itamarandiba", "", "BR", "76", "", "15", "3132503", "", "-17.85722", "-42.85889", "America/Sao_Paulo"),
("3460826", "Itamaraju", "", "BR", "76", "", "05", "2915601", "", "-17.03917", "-39.53111", "America/Bahia"),
("3460831", "Itajuípe", "", "BR", "76", "", "05", "2915502", "", "-14.67806", "-39.375", "America/Bahia"),
("3460834", "Itajubá", "Итажуба", "BR", "76", "", "15", "3132404", "", "-22.42556", "-45.45278", "America/Sao_Paulo"),
("3460836", "Itajobi", "", "BR", "76", "", "27", "3521903", "", "-21.31806", "-49.05444", "America/Sao_Paulo"),
("3460837", "Itagibá", "", "BR", "76", "", "05", "2915205", "", "-14.28361", "-39.84278", "America/Bahia"),
("3460845", "Itajaí", "Итажаи", "BR", "76", "", "26", "4208203", "", "-26.90778", "-48.66194", "America/Sao_Paulo"),
("3460887", "Itaí", "", "BR", "76", "", "27", "3521804", "", "-23.41778", "-49.09056", "America/Sao_Paulo"),
("3460899", "Itaguaí", "Итагуаи", "BR", "76", "", "21", "3302007", "", "-22.85222", "-43.77528", "America/Sao_Paulo"),
("3460901", "Itaguaçu", "", "BR", "76", "", "08", "3202702", "", "-19.80194", "-40.85556", "America/Sao_Paulo"),
("3460907", "Itagi", "", "BR", "76", "", "05", "2915106", "", "-14.16278", "-40.00611", "America/Bahia"),
("3460940", "Itacaré", "", "BR", "76", "", "05", "2914901", "", "-14.2789", "-38.99584", "America/Bahia"),
("3460942", "Itacarambi", "", "BR", "76", "", "15", "3132107", "", "-15.10222", "-44.09194", "America/Sao_Paulo"),
("3460949", "Itabuna", "Итабуна", "BR", "76", "", "05", "2914802", "", "-14.78556", "-39.28028", "America/Bahia"),
("3460950", "Itaboraí", "", "BR", "76", "", "21", "3301900", "", "-22.74444", "-42.85944", "America/Sao_Paulo"),
("3460954", "Itabirito", "", "BR", "76", "", "15", "3131901", "", "-20.25333", "-43.80139", "America/Sao_Paulo"),
("3460960", "Itabira", "Итабира", "BR", "76", "", "15", "3131703", "", "-19.61917", "-43.22694", "America/Sao_Paulo"),
("3460963", "Itaberaí", "Итабераи", "BR", "76", "", "29", "5210406", "", "-16.02028", "-49.81028", "America/Sao_Paulo"),
("3460966", "Itaberaba", "", "BR", "76", "", "05", "2914703", "", "-12.5275", "-40.30694", "America/Bahia"),
("3460967", "Itaberá", "", "BR", "76", "", "27", "3521705", "", "-23.86194", "-49.13722", "America/Sao_Paulo"),
("3460971", "Itabaianinha", "", "BR", "76", "", "28", "2803005", "", "-11.27389", "-37.79", "America/Maceio"),
("3460974", "Itabaiana", "", "BR", "76", "", "28", "2802908", "", "-10.685", "-37.42528", "America/Maceio"),
("3461013", "Irecê", "", "BR", "76", "", "05", "2914604", "", "-11.30417", "-41.85583", "America/Bahia"),
("3461017", "Irati", "", "BR", "76", "", "18", "4110706", "", "-25.46722", "-50.65111", "America/Sao_Paulo"),
("3461022", "Irará", "", "BR", "76", "", "05", "2914505", "", "-12.05", "-38.76667", "America/Bahia"),
("3461023", "Iraquara", "", "BR", "76", "", "05", "2914406", "", "-12.24861", "-41.61944", "America/Bahia"),
("3461055", "Iracemápolis", "", "BR", "76", "", "27", "3521408", "", "-22.58056", "-47.51861", "America/Sao_Paulo"),
("3461080", "Ipuã", "", "BR", "76", "", "27", "3521309", "", "-20.43806", "-48.01222", "America/Sao_Paulo"),
("3461089", "Iporã", "", "BR", "76", "", "18", "4110607", "", "-24.00306", "-53.70417", "America/Sao_Paulo"),
("3461090", "Iporá", "Ипора", "BR", "76", "", "29", "5210208", "", "-16.44194", "-51.11778", "America/Sao_Paulo"),
("3461124", "Ipirá", "", "BR", "76", "", "05", "2914000", "", "-12.15833", "-39.73722", "America/Bahia"),
("3461129", "Ipiaú", "Ипиау", "BR", "76", "", "05", "2913903", "", "-14.13449", "-39.73948", "America/Bahia"),
("3461134", "Iperó", "", "BR", "76", "", "27", "3521002", "", "-23.35028", "-47.68861", "America/Sao_Paulo"),
("3461143", "Ipauçu", "", "BR", "76", "", "27", "3520905", "", "-23.05667", "-49.62639", "America/Sao_Paulo"),
("3461144", "Ipatinga", "Ипатинга", "BR", "76", "", "15", "3131307", "", "-19.46833", "-42.53667", "America/Sao_Paulo"),
("3461151", "Ipameri", "", "BR", "76", "", "29", "5210109", "", "-17.72194", "-48.15972", "America/Sao_Paulo"),
("3461153", "Ipaba", "", "BR", "76", "", "15", "3131158", "", "-19.41361", "-42.41944", "America/Sao_Paulo"),
("3461194", "Inhumas", "", "BR", "76", "", "29", "5210000", "", "-16.35778", "-49.49611", "America/Sao_Paulo"),
("3461214", "Inhapim", "", "BR", "76", "", "15", "3130903", "", "-19.54917", "-42.12", "America/Sao_Paulo"),
("3461224", "Inhambupe", "", "BR", "76", "", "05", "2913705", "", "-11.78444", "-38.35306", "America/Bahia"),
("3461311", "Indaiatuba", "Индаятуба", "BR", "76", "", "27", "3520509", "", "-23.08842", "-47.2119", "America/Sao_Paulo"),
("3461316", "Indaial", "", "BR", "76", "", "26", "4207502", "", "-26.89778", "-49.23167", "America/Sao_Paulo"),
("3461368", "Imbituva", "", "BR", "76", "", "18", "4110102", "", "-25.23", "-50.60444", "America/Sao_Paulo"),
("3461370", "Imbituba", "", "BR", "76", "", "26", "4207304", "", "-28.24", "-48.67028", "America/Sao_Paulo"),
("3461408", "Ilhéus", "Ильеус", "BR", "76", "", "05", "2913606", "", "-14.79364", "-39.03949", "America/Bahia"),
("3461411", "Ilha Solteira", "Илья-Солтейра", "BR", "76", "", "27", "3520442", "", "-20.43278", "-51.3425", "America/Sao_Paulo"),
("3461425", "Ilhabela", "", "BR", "76", "", "27", "3520400", "", "-23.77806", "-45.35806", "America/Sao_Paulo"),
("3461444", "Ijuí", "Ижуи", "BR", "76", "", "23", "4310207", "", "-28.38778", "-53.91472", "America/Sao_Paulo"),
("3461455", "Iguatemi", "", "BR", "76", "", "11", "5004304", "", "-23.68028", "-54.56111", "America/Campo_Grande"),
("3461465", "Iguape", "Игуапи", "BR", "76", "", "27", "3520301", "", "-24.70806", "-47.55528", "America/Sao_Paulo"),
("3461469", "Iguaí", "", "BR", "76", "", "05", "2913507", "", "-14.75639", "-40.08917", "America/Bahia"),
("3461477", "Iguaba Grande", "", "BR", "76", "", "21", "3301876", "", "-22.83917", "-42.22889", "America/Sao_Paulo"),
("3461481", "Igrejinha", "Игрежинья", "BR", "76", "", "23", "4310108", "", "-29.57444", "-50.79028", "America/Sao_Paulo"),
("3461498", "Igarapé", "", "BR", "76", "", "15", "3130101", "", "-20.07028", "-44.30167", "America/Sao_Paulo"),
("3461499", "Igarapava", "", "BR", "76", "", "27", "3520103", "", "-20.03833", "-47.74694", "America/Sao_Paulo"),
("3461501", "Igaraçu do Tietê", "", "BR", "76", "", "27", "3520004", "", "-22.50917", "-48.55778", "America/Sao_Paulo"),
("3461510", "Iconha", "", "BR", "76", "", "08", "3202603", "", "-20.79306", "-40.81111", "America/Sao_Paulo"),
("3461519", "Içara", "Исара", "BR", "76", "", "26", "4207007", "", "-28.71333", "-49.3", "America/Sao_Paulo"),
("3461525", "Ibotirama", "", "BR", "76", "", "05", "2913200", "", "-12.18528", "-43.22056", "America/Bahia"),
("3461528", "Ibiúna", "", "BR", "76", "", "27", "3519709", "", "-23.65639", "-47.2225", "America/Sao_Paulo"),
("3461550", "Ibitinga", "", "BR", "76", "", "27", "3519600", "", "-21.75778", "-48.82889", "America/Sao_Paulo"),
("3461559", "Ibirubá", "", "BR", "76", "", "23", "4310009", "", "-28.6275", "-53.08972", "America/Sao_Paulo"),
("3461563", "Ibirité", "Ибирите", "BR", "76", "", "15", "3129806", "", "-20.02194", "-44.05889", "America/Sao_Paulo"),
("3461565", "Ibirataia", "", "BR", "76", "", "05", "2912905", "", "-14.06694", "-39.64056", "America/Bahia"),
("3461572", "Ibirapitanga", "", "BR", "76", "", "05", "2912707", "", "-14.16417", "-39.37361", "America/Bahia"),
("3461576", "Ibirama", "", "BR", "76", "", "26", "4206900", "", "-27.05694", "-49.51778", "America/Sao_Paulo"),
("3461579", "Ibiraçu", "", "BR", "76", "", "08", "3202504", "", "-19.83194", "-40.36972", "America/Sao_Paulo"),
("3461588", "Ibiporã", "", "BR", "76", "", "18", "4109807", "", "-23.26917", "-51.04806", "America/Sao_Paulo"),
("3461592", "Ibipeba", "", "BR", "76", "", "05", "2912400", "", "-11.64083", "-42.01111", "America/Bahia"),
("3461602", "Ibicuí", "", "BR", "76", "", "05", "2912301", "", "-14.84167", "-39.98667", "America/Bahia"),
("3461606", "Ibicaraí", "", "BR", "76", "", "05", "2912103", "", "-14.865", "-39.5875", "America/Bahia"),
("3461620", "Ibiá", "", "BR", "76", "", "15", "3129509", "", "-19.47833", "-46.53889", "America/Sao_Paulo"),
("3461624", "Ibatiba", "", "BR", "76", "", "08", "3202454", "", "-20.23389", "-41.51056", "America/Sao_Paulo"),
("3461625", "Ibaté", "", "BR", "76", "", "27", "3519303", "", "-21.95472", "-47.99667", "America/Sao_Paulo"),
("3461628", "Ibaiti", "", "BR", "76", "", "18", "4109708", "", "-23.84861", "-50.18778", "America/Sao_Paulo"),
("3461638", "Iaçu", "", "BR", "76", "", "05", "2911907", "", "-12.76722", "-40.21167", "America/Bahia"),
("3461641", "Iaciara", "", "BR", "76", "", "29", "5209903", "", "-14.09583", "-46.63167", "America/Sao_Paulo"),
("3461655", "Hortolândia", "Ортоландия", "BR", "76", "", "27", "3519071", "", "-22.85833", "-47.22", "America/Sao_Paulo"),
("3461659", "Horizontina", "", "BR", "76", "", "23", "4309605", "", "-27.62583", "-54.30778", "America/Sao_Paulo"),
("3461677", "Hidrolândia", "", "BR", "76", "", "29", "5209705", "", "-16.96222", "-49.22806", "America/Sao_Paulo"),
("3461680", "Herval", "", "BR", "76", "", "23", "4307104", "", "-32.02361", "-53.39556", "America/Sao_Paulo"),
("3461724", "Gurupi", "Гурупи", "BR", "76", "", "31", "1709500", "", "-11.72917", "-49.06861", "America/Araguaina"),
("3461733", "Guiratinga", "", "BR", "76", "", "14", "5104203", "", "-16.34534", "-53.76177", "America/Cuiaba"),
("3461750", "Guia Lopes da Laguna", "", "BR", "76", "", "11", "5004106", "", "-21.45778", "-56.11417", "America/Campo_Grande"),
("3461763", "Guaxupé", "", "BR", "76", "", "15", "3128709", "", "-21.30528", "-46.71278", "America/Sao_Paulo"),
("3461786", "Guarulhos", "", "BR", "76", "", "27", "3518800", "", "-23.46278", "-46.53333", "America/Sao_Paulo"),
("3461789", "Guarujá", "Гуаружа", "BR", "76", "", "27", "3518701", "", "-23.99306", "-46.25639", "America/Sao_Paulo"),
("3461824", "Guariba", "", "BR", "76", "", "27", "3518602", "", "-21.36", "-48.22833", "America/Sao_Paulo"),
("3461857", "Guaratuba", "", "BR", "76", "", "18", "4109609", "", "-25.88278", "-48.57472", "America/Sao_Paulo"),
("3461859", "Guaratinguetá", "Гуаратингета", "BR", "76", "", "27", "3518404", "", "-22.81639", "-45.1925", "America/Sao_Paulo"),
("3461860", "Guaratinga", "", "BR", "76", "", "05", "2914653", "", "-16.58564", "-39.78189", "America/Bahia"),
("3461871", "Guararema", "", "BR", "76", "", "27", "3518305", "", "-23.415", "-46.035", "America/Sao_Paulo"),
("3461874", "Guararapes", "", "BR", "76", "", "27", "3518206", "", "-21.26083", "-50.64278", "America/Sao_Paulo"),
("3461879", "Guarapuava", "Гуарапуава", "BR", "76", "", "18", "4109401", "", "-25.39048", "-51.46541", "America/Sao_Paulo"),
("3461888", "Guarapari", "Гуарапари", "BR", "76", "", "08", "3202405", "", "-20.65367", "-40.50204", "America/Sao_Paulo"),
("3461892", "Guaraniaçu", "", "BR", "76", "", "18", "4109302", "", "-25.10083", "-52.87806", "America/Sao_Paulo"),
("3461910", "Guaranésia", "", "BR", "76", "", "15", "3128303", "", "-21.29917", "-46.8025", "America/Sao_Paulo"),
("3461914", "Guaramirim", "", "BR", "76", "", "26", "4206504", "", "-26.47306", "-49.00278", "America/Sao_Paulo"),
("3461935", "Guará", "", "BR", "76", "", "27", "3517703", "", "-20.42833", "-47.82417", "America/Sao_Paulo"),
("3461941", "Guaporé", "", "BR", "76", "", "23", "4309407", "", "-28.84556", "-51.89028", "America/Sao_Paulo"),
("3461943", "Guapó", "", "BR", "76", "", "29", "5209200", "", "-16.83056", "-49.53194", "America/Sao_Paulo"),
("3461949", "Guapimirim", "Гуапимирин", "BR", "76", "", "21", "3301850", "", "-22.53722", "-42.98194", "America/Sao_Paulo"),
("3461954", "Guapiaçu", "", "BR", "76", "", "27", "3517505", "", "-20.795", "-49.22028", "America/Sao_Paulo"),
("3461958", "Guanhães", "", "BR", "76", "", "15", "3128006", "", "-18.775", "-42.9325", "America/Sao_Paulo"),
("3461973", "Guanambi", "", "BR", "76", "", "05", "2911709", "", "-14.22333", "-42.78139", "America/Bahia"),
("3461995", "Guaíra", "Гуайра", "BR", "76", "", "27", "3517406", "", "-20.31833", "-48.31056", "America/Sao_Paulo"),
("3462022", "Guaçuí", "", "BR", "76", "", "08", "3202306", "", "-20.77556", "-41.67944", "America/Sao_Paulo"),
("3462089", "Gravataí", "Граватаи", "BR", "76", "", "23", "4309209", "", "-29.94218", "-50.99278", "America/Sao_Paulo"),
("3462315", "Governador Valadares", "Говернадор-Валадарес", "BR", "76", "", "15", "3127701", "", "-18.85111", "-41.94944", "America/Sao_Paulo"),
("3462371", "Goiatuba", "Гоятуба", "BR", "76", "", "29", "5209101", "", "-18.0125", "-49.35472", "America/Sao_Paulo"),
("3462374", "Goiás", "", "BR", "76", "", "29", "5208905", "", "-15.93444", "-50.14028", "America/Sao_Paulo"),
("3462376", "Goianira", "Гоянира", "BR", "76", "", "29", "5208806", "", "-16.49611", "-49.42639", "America/Sao_Paulo"),
("3462377", "Goiânia", "Гояния", "BR", "76", "", "29", "5208707", "", "-16.67861", "-49.25389", "America/Sao_Paulo"),
("3462378", "Goianésia", "", "BR", "76", "", "29", "5208608", "", "-15.3175", "-49.1175", "America/Sao_Paulo"),
("3462383", "Goianápolis", "", "BR", "76", "", "29", "5208400", "", "-16.51056", "-49.02389", "America/Sao_Paulo"),
("3462419", "Giruá", "", "BR", "76", "", "23", "4309001", "", "-28.02833", "-54.34972", "America/Sao_Paulo"),
("3462487", "General Salgado", "", "BR", "76", "", "27", "3516903", "", "-20.64833", "-50.36056", "America/Sao_Paulo"),
("3462535", "Gaspar", "", "BR", "76", "", "26", "4205902", "", "-26.93139", "-48.95889", "America/Sao_Paulo"),
("3462557", "Garibaldi", "", "BR", "76", "", "23", "4308607", "", "-29.25611", "-51.53361", "America/Sao_Paulo"),
("3462580", "Garça", "", "BR", "76", "", "27", "3516705", "", "-22.21056", "-49.65611", "America/Sao_Paulo"),
("3462601", "Gandu", "", "BR", "76", "", "05", "2911204", "", "-13.74389", "-39.48667", "America/Bahia"),
("3462882", "Fundão", "", "BR", "76", "", "08", "3202207", "", "-19.93408", "-40.40473", "America/Sao_Paulo"),
("3462916", "Frutal", "Фрутал", "BR", "76", "", "15", "3127107", "", "-20.02472", "-48.94056", "America/Sao_Paulo"),
("3462944", "Frei Paulo", "", "BR", "76", "", "28", "2802304", "", "-10.54944", "-37.53444", "America/Maceio"),
("3462956", "Frederico Westphalen", "", "BR", "76", "", "23", "4308508", "", "-27.35917", "-53.39444", "America/Sao_Paulo"),
("3462964", "Franco da Rocha", "", "BR", "76", "", "27", "3516408", "", "-23.32167", "-46.72694", "America/Sao_Paulo"),
("3462975", "Francisco Sá", "", "BR", "76", "", "15", "3126703", "", "-16.47583", "-43.48833", "America/Sao_Paulo"),
("3462980", "Francisco Morato", "", "BR", "76", "", "27", "3516309", "", "-23.28167", "-46.74528", "America/Sao_Paulo"),
("3462996", "Francisco Beltrão", "Белтран-Франциско", "BR", "76", "", "18", "4108403", "", "-26.08111", "-53.055", "America/Sao_Paulo"),
("3463011", "Franca", "Франко", "BR", "76", "", "27", "3516200", "", "-20.53861", "-47.40083", "America/Sao_Paulo"),
("3463030", "Foz do Iguaçu", "Фос-ду-Игуасу", "BR", "76", "", "18", "4108304", "", "-25.54778", "-54.58806", "America/Sao_Paulo"),
("3463066", "Forquilhinha", "Форкильинья", "BR", "76", "", "26", "4205456", "", "-28.7475", "-49.47222", "America/Sao_Paulo"),
("3463124", "Formosa do Rio Preto", "", "BR", "76", "", "05", "2911105", "", "-11.04833", "-45.19306", "America/Bahia"),
("3463140", "Formosa", "", "BR", "76", "", "29", "5208004", "", "-15.53722", "-47.33444", "America/Sao_Paulo"),
("3463174", "Formiga", "Формига", "BR", "76", "", "15", "3126109", "", "-20.46444", "-45.42639", "America/Sao_Paulo"),
("3463228", "Paulista Flórida", "", "BR", "76", "", "27", "3516002", "", "-21.6", "-51.2", "America/Sao_Paulo"),
("3463237", "Florianópolis", "Флорианополис", "BR", "76", "", "26", "4205407", "", "-27.59667", "-48.54917", "America/Sao_Paulo"),
("3463246", "Florestópolis", "", "BR", "76", "", "18", "4108007", "", "-22.86333", "-51.38722", "America/Sao_Paulo"),
("3463271", "Flores da Cunha", "", "BR", "76", "", "23", "4308201", "", "-29.02889", "-51.18167", "America/Sao_Paulo"),
("3463326", "Firminópolis", "", "BR", "76", "", "29", "5207808", "", "-16.58194", "-50.305", "America/Sao_Paulo"),
("3463422", "Ferraz de Vasconcelos", "", "BR", "76", "", "27", "3515707", "", "-23.54083", "-46.36861", "America/Sao_Paulo"),
("3463432", "Fernandópolis", "", "BR", "76", "", "27", "3515509", "", "-20.28389", "-50.24639", "America/Sao_Paulo"),
("3463478", "Feira de Santana", "Фейра-де-Сантана", "BR", "76", "", "05", "2910800", "", "-12.26667", "-38.96667", "America/Bahia"),
("3463573", "Faxinal", "", "BR", "76", "", "18", "4107603", "", "-24.00028", "-51.31944", "America/Sao_Paulo"),
("3463604", "Fartura", "", "BR", "76", "", "27", "3515400", "", "-23.38833", "-49.51", "America/Sao_Paulo"),
("3463605", "Farroupilha", "", "BR", "76", "", "23", "4307906", "", "-29.225", "-51.34778", "America/Sao_Paulo"),
("3463668", "Extrema", "", "BR", "76", "", "15", "3125101", "", "-22.85472", "-46.31833", "America/Sao_Paulo"),
("3463698", "Euclides da Cunha", "Евклид-да-Кунья", "BR", "76", "", "05", "2910701", "", "-10.5075", "-39.01583", "America/Bahia"),
("3463762", "Estrela", "", "BR", "76", "", "23", "4322509", "", "-28.06111", "-50.93833", "America/Sao_Paulo"),
("3463859", "Esteio", "", "BR", "76", "", "23", "4307708", "", "-29.86139", "-51.17917", "America/Sao_Paulo"),
("3463865", "Estância Velha", "", "BR", "76", "", "23", "4307609", "", "-29.64833", "-51.17389", "America/Sao_Paulo"),
("3463900", "Estância", "", "BR", "76", "", "28", "2802106", "", "-11.26833", "-37.43833", "America/Maceio"),
("3463916", "Espumoso", "", "BR", "76", "", "23", "4307500", "", "-28.72472", "-52.84972", "America/Sao_Paulo"),
("3463920", "Esplanada", "", "BR", "76", "", "05", "2910602", "", "-11.79611", "-37.945", "America/Bahia"),
("3463939", "Espinosa", "", "BR", "76", "", "15", "3124302", "", "-14.92611", "-42.81917", "America/Sao_Paulo"),
("3463993", "Espera Feliz", "", "BR", "76", "", "15", "3124203", "", "-20.65028", "-41.90722", "America/Sao_Paulo"),
("3464008", "Esmeraldas", "Эсмеральдас", "BR", "76", "", "15", "3124104", "", "-19.7625", "-44.31389", "America/Sao_Paulo"),
("3464073", "Erechim", "Эрешин", "BR", "76", "", "23", "4307005", "", "-27.63461", "-52.2754", "America/Sao_Paulo"),
("3464100", "Entre Rios", "", "BR", "76", "", "05", "2910503", "", "-11.94194", "-38.08444", "America/Bahia"),
("3464219", "Engenheiro Beltrão", "", "BR", "76", "", "18", "4107504", "", "-23.79722", "-52.26917", "America/Sao_Paulo"),
("3464255", "Encruzilhada do Sul", "", "BR", "76", "", "23", "4306908", "", "-30.54389", "-52.52194", "America/Sao_Paulo"),
("3464274", "Encantado", "", "BR", "76", "", "23", "4306809", "", "-29.23611", "-51.86972", "America/Sao_Paulo"),
("3464304", "Embu Guaçu", "", "BR", "76", "", "27", "3515103", "", "-23.83222", "-46.81139", "America/Sao_Paulo"),
("3464305", "Embu", "Эмба", "BR", "76", "", "27", "3515004", "", "-23.64889", "-46.85222", "America/Sao_Paulo"),
("3464329", "Elói Mendes", "", "BR", "76", "", "15", "3123601", "", "-21.61", "-45.56528", "America/Sao_Paulo"),
("3464335", "Elias Fausto", "", "BR", "76", "", "27", "3514908", "", "-23.04278", "-47.37389", "America/Sao_Paulo"),
("3464343", "Eldorado", "", "BR", "76", "", "11", "5003751", "", "-23.78694", "-54.28361", "America/Campo_Grande"),
("3464363", "Edéia", "", "BR", "76", "", "29", "5207402", "", "-17.33833", "-49.93139", "America/Sao_Paulo"),
("3464364", "Ecoporanga", "", "BR", "76", "", "08", "3202108", "", "-18.37333", "-40.83056", "America/Sao_Paulo"),
("3464374", "Duque de Caxias", "Дуки-ди-Кашиас", "BR", "76", "", "21", "3301702", "", "-22.78556", "-43.31167", "America/Sao_Paulo"),
("3464422", "Duartina", "", "BR", "76", "", "27", "3514502", "", "-22.41444", "-49.40389", "America/Sao_Paulo"),
("3464460", "Dourados", "Дорадус", "BR", "76", "", "11", "5003702", "", "-22.22111", "-54.80556", "America/Campo_Grande"),
("3464511", "Dores do Indaiá", "", "BR", "76", "", "15", "3123205", "", "-19.46333", "-45.60167", "America/Sao_Paulo"),
("3464547", "Dom Pedrito", "", "BR", "76", "", "23", "4306601", "", "-30.98278", "-54.67306", "America/Sao_Paulo"),
("3464556", "Domingos Martins", "", "BR", "76", "", "08", "3201902", "", "-20.36333", "-40.65917", "America/Sao_Paulo"),
("3464579", "Dois Vizinhos", "", "BR", "76", "", "18", "4107207", "", "-25.73361", "-53.05722", "America/Sao_Paulo"),
("3464618", "Dois Córregos", "", "BR", "76", "", "27", "3514106", "", "-22.36611", "-48.38028", "America/Sao_Paulo"),
("3464688", "Divinópolis", "Дивинополис", "BR", "76", "", "15", "3122306", "", "-20.14355", "-44.89065", "America/Sao_Paulo"),
("3464693", "Divino das Laranjeiras", "", "BR", "76", "", "15", "3122108", "", "-18.77778", "-41.47972", "America/Sao_Paulo"),
("3464724", "Diamantino", "", "BR", "76", "", "14", "5103502", "", "-14.40861", "-56.44611", "America/Cuiaba"),
("3464728", "Diamantina", "Диамантина", "BR", "76", "", "15", "3121605", "", "-18.24692", "-43.60345", "America/Sao_Paulo"),
("3464739", "Diadema", "Диадема", "BR", "76", "", "27", "3513801", "", "-23.68611", "-46.62278", "America/Sao_Paulo"),
("3464809", "Descalvado", "", "BR", "76", "", "27", "3513702", "", "-21.90389", "-47.61944", "America/Sao_Paulo"),
("3464891", "Curvelo", "Курвелу", "BR", "76", "", "15", "3120904", "", "-18.75639", "-44.43083", "America/Sao_Paulo"),
("3464974", "Curitibanos", "Куритибанус", "BR", "76", "", "26", "4204806", "", "-27.28278", "-50.58444", "America/Sao_Paulo"),
("3464975", "Curitiba", "Куритиба", "BR", "76", "", "18", "4106902", "", "-25.42778", "-49.27306", "America/Sao_Paulo"),
("3465010", "Cunha", "", "BR", "76", "", "27", "3513603", "", "-23.07444", "-44.95972", "America/Sao_Paulo"),
("3465038", "Cuiabá", "Куяба", "BR", "76", "", "14", "5103403", "", "-15.59611", "-56.09667", "America/Cuiaba"),
("3465059", "Cubatão", "", "BR", "76", "", "27", "3513504", "", "-23.895", "-46.42528", "America/Sao_Paulo"),
("3465071", "Cruzília", "", "BR", "76", "", "15", "3120805", "", "-21.83861", "-44.80833", "America/Sao_Paulo"),
("3465083", "Cruzeiro do Oeste", "", "BR", "76", "", "18", "4106605", "", "-23.785", "-53.07333", "America/Sao_Paulo"),
("3465090", "Cruzeiro", "", "BR", "76", "", "27", "3513405", "", "-22.57316", "-44.97108", "America/Sao_Paulo"),
("3465105", "Cruz das Almas", "", "BR", "76", "", "05", "2909802", "", "-12.67", "-39.10194", "America/Bahia"),
("3465108", "Cruz Alta", "Крус-Алта", "BR", "76", "", "23", "4306106", "", "-28.63861", "-53.60639", "America/Sao_Paulo"),
("3465145", "Crixás", "", "BR", "76", "", "29", "5206404", "", "-14.54889", "-49.96917", "America/Sao_Paulo"),
("3465154", "Cristinápolis", "", "BR", "76", "", "28", "2801702", "", "-11.47556", "-37.75528", "America/Maceio"),
("3465164", "Cristalina", "Кристалина", "BR", "76", "", "29", "5206206", "", "-16.76769", "-47.6153", "America/Sao_Paulo"),
("3465196", "Criciúma", "Крисиума", "BR", "76", "", "26", "4204608", "", "-28.6775", "-49.36972", "America/Sao_Paulo"),
("3465209", "Cravinhos", "", "BR", "76", "", "27", "3513108", "", "-21.34028", "-47.72944", "America/Sao_Paulo"),
("3465228", "Coxim", "Кошин", "BR", "76", "", "11", "5003306", "", "-18.50667", "-54.76", "America/Campo_Grande"),
("3465284", "Cotia", "", "BR", "76", "", "27", "3513009", "", "-23.60389", "-46.91917", "America/Sao_Paulo"),
("3465303", "Costa Rica", "", "BR", "76", "", "11", "5004304", "", "-23.41667", "-54.65", "America/Campo_Grande"),
("3465320", "Cosmópolis", "", "BR", "76", "", "27", "3512803", "", "-22.64583", "-47.19611", "America/Sao_Paulo"),
("3465329", "Coruripe", "", "BR", "76", "", "02", "2702306", "", "-10.12556", "-36.17556", "America/Maceio"),
("3465330", "Corupá", "", "BR", "76", "BR", "26", "4204509", "", "-26.42528", "-49.24306", "America/Sao_Paulo"),
("3465342", "Corumbá", "Корумба", "BR", "76", "", "11", "5003207", "", "-19.00917", "-57.65333", "America/Campo_Grande"),
("3465373", "Correntina", "", "BR", "76", "", "05", "2909307", "", "-13.34333", "-44.63667", "America/Bahia"),
("3465409", "Correia Pinto", "", "BR", "76", "", "26", "4204558", "", "-27.58472", "-50.36111", "America/Sao_Paulo"),
("3465459", "Coronel Vivida", "", "BR", "76", "", "18", "4106506", "", "-25.97972", "-52.56778", "America/Sao_Paulo"),
("3465476", "Coronel Fabriciano", "Коронел-Фабрисиану", "BR", "76", "", "15", "3119401", "", "-19.51861", "-42.62889", "America/Sao_Paulo"),
("3465487", "Coromandel", "", "BR", "76", "", "15", "3119302", "", "-18.47333", "-47.20028", "America/Sao_Paulo"),
("3465508", "Cornélio Procópio", "", "BR", "76", "", "18", "4106407", "", "-23.18111", "-50.64667", "America/Sao_Paulo"),
("3465512", "Corinto", "Коринто", "BR", "76", "", "15", "3119104", "", "-18.38083", "-44.45639", "America/Sao_Paulo"),
("3465524", "Cordeirópolis", "", "BR", "76", "", "27", "3512407", "", "-22.48194", "-47.45667", "America/Sao_Paulo"),
("3465527", "Cordeiro", "", "BR", "76", "", "21", "3301504", "", "-22.02861", "-42.36083", "America/Sao_Paulo"),
("3465536", "Corbélia", "", "BR", "76", "", "18", "4106308", "", "-24.79889", "-53.30667", "America/Sao_Paulo"),
("3465541", "Coração de Maria", "", "BR", "76", "", "05", "2908903", "", "-12.23333", "-38.75", "America/Bahia"),
("3465542", "Coração de Jesus", "", "BR", "76", "", "15", "3118809", "", "-16.68528", "-44.365", "America/Sao_Paulo"),
("3465624", "Contagem", "Контажен", "BR", "76", "", "15", "3118601", "", "-19.93167", "-44.05361", "America/Sao_Paulo"),
("3465639", "Conselheiro Pena", "", "BR", "76", "", "15", "3118403", "", "-19.17222", "-41.47222", "America/Sao_Paulo"),
("3465644", "Conselheiro Lafaiete", "Консельейру-Лафаети", "BR", "76", "", "15", "3118304", "", "-20.66028", "-43.78611", "America/Sao_Paulo"),
("3465671", "Congonhas", "Конгоньяс", "BR", "76", "", "15", "3118007", "", "-20.50525", "-43.8588", "America/Sao_Paulo"),
("3465713", "Conde", "", "BR", "76", "", "05", "2908606", "", "-11.81361", "-37.61056", "America/Bahia"),
("3465721", "Concórdia", "Конкордия", "BR", "76", "", "26", "4204301", "", "-27.23417", "-52.02778", "America/Sao_Paulo"),
("3465729", "Conchas", "", "BR", "76", "", "27", "3512308", "", "-23.01528", "-48.01056", "America/Sao_Paulo"),
("3465731", "Conchal", "", "BR", "76", "", "27", "3512209", "", "-22.33028", "-47.1725", "America/Sao_Paulo"),
("3465737", "Conceição do Rio Verde", "", "BR", "76", "", "15", "3117702", "", "-21.88083", "-45.08528", "America/Sao_Paulo"),
("3465745", "Conceição do Mato Dentro", "", "BR", "76", "", "15", "3117504", "", "-19.03722", "-43.425", "America/Sao_Paulo"),
("3465748", "Conceição do Coité", "", "BR", "76", "", "05", "2908408", "", "-11.56389", "-39.28278", "America/Bahia"),
("3465752", "Conceição do Almeida", "", "BR", "76", "", "05", "2908309", "", "-12.77944", "-39.17", "America/Bahia"),
("3465758", "Conceição do Jacuípe", "", "BR", "76", "", "05", "2908507", "", "-12.31667", "-38.76667", "America/Bahia"),
("3465764", "Conceição das Alagoas", "", "BR", "76", "", "15", "3117306", "", "-19.91472", "-48.38833", "America/Sao_Paulo"),
("3465767", "Conceição da Feira", "", "BR", "76", "", "05", "2908200", "", "-12.50583", "-38.99861", "America/Bahia"),
("3465769", "Conceição da Barra", "", "BR", "76", "", "08", "3201605", "", "-18.59333", "-39.73222", "America/Sao_Paulo"),
("3465881", "Colorado", "", "BR", "76", "", "18", "4105904", "", "-22.8375", "-51.97306", "America/Sao_Paulo"),
("3465927", "Colombo", "Коломбо", "BR", "76", "", "18", "4105805", "", "-25.29167", "-49.22417", "America/Sao_Paulo"),
("3465944", "Colatina", "Колатина", "BR", "76", "", "08", "3201506", "", "-19.53944", "-40.63056", "America/Sao_Paulo"),
("3466005", "Cocal", "", "BR", "76", "", "26", "4204251", "", "-28.60321", "-49.32767", "America/Sao_Paulo"),
("3466041", "Coaraci", "", "BR", "76", "", "05", "2908002", "", "-14.64083", "-39.55111", "America/Bahia"),
("3466046", "Clevelândia", "", "BR", "76", "", "18", "4105706", "", "-26.39583", "-52.47083", "America/Sao_Paulo"),
("3466062", "Cláudio", "", "BR", "76", "", "15", "3116605", "", "-20.44333", "-44.76583", "America/Sao_Paulo"),
("3466134", "Cipó", "", "BR", "76", "", "05", "2907905", "", "-11.09972", "-38.51361", "America/Bahia"),
("3466165", "Cidreira", "", "BR", "76", "", "23", "4305454", "", "-30.18111", "-50.20556", "America/Sao_Paulo"),
("3466171", "Cícero Dantas", "", "BR", "76", "", "05", "2907806", "", "-10.6", "-38.38333", "America/Bahia"),
("3466174", "Cianorte", "Сианорте", "BR", "76", "", "18", "4105508", "", "-23.66333", "-52.605", "America/Sao_Paulo"),
("3466187", "Chuí", "", "BR", "76", "BR", "23", "4305439", "", "-33.69111", "-53.45667", "America/Sao_Paulo"),
("3466196", "Chopinzinho", "", "BR", "76", "", "18", "4105409", "", "-25.85583", "-52.52333", "America/Sao_Paulo"),
("3466261", "Charqueadas", "", "BR", "76", "", "23", "4305355", "", "-29.95472", "-51.62528", "America/Sao_Paulo"),
("3466267", "Charqueada", "", "BR", "76", "", "27", "3511706", "", "-22.50972", "-47.77806", "America/Sao_Paulo"),
("3466296", "Chapecó", "Шапеко", "BR", "76", "", "26", "4204202", "", "-27.09639", "-52.61833", "America/Sao_Paulo"),
("3466307", "Chapada dos Guimarães", "", "BR", "76", "", "14", "5103007", "", "-15.46056", "-55.74972", "America/Cuiaba"),
("3466395", "Cerro Largo", "", "BR", "76", "", "23", "4305207", "", "-28.14861", "-54.73806", "America/Sao_Paulo"),
("3466429", "Cerquilho", "", "BR", "76", "", "27", "3511508", "", "-23.165", "-47.74361", "America/Sao_Paulo"),
("3466430", "Cerqueira César", "", "BR", "76", "", "27", "3511409", "", "-23.03556", "-49.16611", "America/Sao_Paulo"),
("3466436", "Ceres", "", "BR", "76", "", "29", "5205406", "", "-15.30833", "-49.59833", "America/Sao_Paulo"),
("3466462", "Centralina", "", "BR", "76", "", "15", "3115805", "", "-18.58389", "-49.19944", "America/Sao_Paulo"),
("3466470", "Centenário do Sul", "", "BR", "76", "", "18", "4105102", "", "-22.82111", "-51.59528", "America/Sao_Paulo"),
("3466481", "Celso Ramos", "", "BR", "76", "", "26", "4204152", "", "-27.63444", "-51.33639", "America/Sao_Paulo"),
("3466537", "Caxias do Sul", "Кашиас-ду-Сул", "BR", "76", "", "23", "4305108", "", "-29.16806", "-51.17944", "America/Sao_Paulo"),
("3466547", "Caxambu", "", "BR", "76", "", "15", "3115508", "", "-21.97722", "-44.9325", "America/Sao_Paulo"),
("3466641", "Catu", "", "BR", "76", "", "05", "2907509", "", "-12.35306", "-38.37889", "America/Bahia"),
("3466692", "Catanduva", "Катандува", "BR", "76", "", "27", "3511102", "", "-21.13778", "-48.97278", "America/Sao_Paulo"),
("3466696", "Catalão", "", "BR", "76", "", "29", "5205109", "", "-18.16583", "-47.94639", "America/Sao_Paulo"),
("3466698", "Cataguases", "Катагуазис", "BR", "76", "", "15", "3115300", "", "-21.38917", "-42.69667", "America/Sao_Paulo"),
("3466703", "Castro Alves", "", "BR", "76", "", "05", "2907301", "", "-12.76556", "-39.42833", "America/Bahia"),
("3466704", "Castro", "", "BR", "76", "", "18", "4104907", "", "-24.78927", "-50.01225", "America/Sao_Paulo"),
("3466708", "Castilho", "", "BR", "76", "", "27", "3511003", "", "-20.87222", "-51.4875", "America/Sao_Paulo"),
("3466723", "Castelo", "Каштелу", "BR", "76", "", "08", "3201407", "", "-20.60361", "-41.18472", "America/Sao_Paulo"),
("3466750", "Cassilândia", "", "BR", "76", "", "11", "5002902", "", "-19.11333", "-51.73417", "America/Campo_Grande"),
("3466752", "Cássia", "", "BR", "76", "", "15", "3115102", "", "-20.58306", "-46.92194", "America/Sao_Paulo"),
("3466763", "Casimiro de Abreu", "", "BR", "76", "", "21", "3301306", "", "-22.48056", "-42.20417", "America/Sao_Paulo"),
("3466779", "Cascavel", "Каскавел", "BR", "76", "", "18", "4104808", "", "-24.95583", "-53.45528", "America/Sao_Paulo"),
("3466824", "Casa Branca", "", "BR", "76", "", "27", "3510807", "", "-21.77389", "-47.08639", "America/Sao_Paulo"),
("3466900", "Carmo do Rio Verde", "", "BR", "76", "", "29", "5205000", "", "-15.35361", "-49.7075", "America/Sao_Paulo"),
("3466901", "Carmo do Rio Claro", "", "BR", "76", "", "15", "3114402", "", "-20.97194", "-46.11889", "America/Sao_Paulo"),
("3466902", "Carmo do Paranaíba", "", "BR", "76", "", "15", "3114303", "", "-19.00083", "-46.31611", "America/Sao_Paulo"),
("3466903", "Carmo do Cajuru", "", "BR", "76", "", "15", "3114204", "", "-20.18417", "-44.77111", "America/Sao_Paulo"),
("3466913", "Carmo", "", "BR", "76", "", "21", "3301207", "", "-21.93361", "-42.60861", "America/Sao_Paulo"),
("3466931", "Carlos Chagas", "", "BR", "76", "", "15", "3113701", "", "-17.70306", "-40.76639", "America/Sao_Paulo"),
("3466933", "Carlos Barbosa", "", "BR", "76", "", "23", "4304804", "", "-29.2975", "-51.50361", "America/Sao_Paulo"),
("3466941", "Carira", "", "BR", "76", "", "28", "2801405", "", "-10.36083", "-37.70111", "America/Maceio"),
("3466950", "Carinhanha", "", "BR", "76", "", "05", "2907103", "", "-14.30472", "-43.765", "America/Bahia"),
("3466970", "Cardoso", "", "BR", "76", "", "27", "3510708", "", "-20.08194", "-49.91417", "America/Sao_Paulo"),
("3466978", "Carazinho", "Каразинью", "BR", "76", "", "23", "4304705", "", "-28.28389", "-52.78639", "America/Sao_Paulo"),
("3466988", "Caratinga", "Каратинга", "BR", "76", "", "15", "3113404", "", "-19.78972", "-42.13917", "America/Sao_Paulo"),
("3466993", "Caarapó", "", "BR", "76", "", "11", "5002407", "", "-22.63417", "-54.82222", "America/Campo_Grande"),
("3466998", "Carapicuíba", "", "BR", "76", "", "27", "3510609", "", "-23.52272", "-46.835", "America/Sao_Paulo"),
("3467012", "Carangola", "Карангола", "BR", "76", "", "15", "3113305", "", "-20.73306", "-42.02944", "America/Sao_Paulo"),
("3467026", "Carandaí", "", "BR", "76", "", "15", "3113206", "", "-20.95361", "-43.80639", "America/Sao_Paulo"),
("3467042", "Carambeí", "", "BR", "76", "", "18", "4104659", "", "-24.9526", "-50.1159", "America/Sao_Paulo"),
("3467078", "Caraí", "", "BR", "76", "", "15", "3113008", "", "-17.18889", "-41.69472", "America/Sao_Paulo"),
("3467081", "Caraguatatuba", "Карагуататуба", "BR", "76", "", "27", "3510500", "", "-23.62028", "-45.41306", "America/Sao_Paulo"),
("3467197", "Capivari", "Капивари", "BR", "76", "", "27", "3510401", "", "-22.995", "-47.50778", "America/Sao_Paulo"),
("3467261", "Capinzal", "", "BR", "76", "", "26", "4203907", "", "-27.34361", "-51.61194", "America/Sao_Paulo"),
("3467263", "Capinópolis", "", "BR", "76", "", "15", "3112604", "", "-18.68194", "-49.56972", "America/Sao_Paulo"),
("3467272", "Capim Grosso", "", "BR", "76", "", "05", "2906873", "", "-11.38111", "-40.01278", "America/Bahia"),
("3467305", "Capelinha", "Капелинья", "BR", "76", "", "15", "3112307", "", "-17.69139", "-42.51583", "America/Sao_Paulo"),
("3467314", "Capela do Alto", "", "BR", "76", "", "27", "3510302", "", "-23.47056", "-47.73472", "America/Sao_Paulo"),
("3467319", "Capela", "", "BR", "76", "", "28", "2801306", "", "-10.50333", "-37.05278", "America/Maceio"),
("3467362", "Capão da Canoa", "", "BR", "76", "", "23", "4304630", "", "-29.74556", "-50.00972", "America/Sao_Paulo"),
("3467371", "Capâo Bonito", "", "BR", "76", "", "27", "3510203", "", "-24.00583", "-48.34944", "America/Sao_Paulo"),
("3467445", "Cantagalo", "", "BR", "76", "", "21", "3301108", "", "-21.98111", "-42.36806", "America/Sao_Paulo"),
("3467452", "Canoinhas", "", "BR", "76", "", "26", "4203808", "", "-26.17722", "-50.39", "America/Sao_Paulo"),
("3467467", "Canoas", "Каноас", "BR", "76", "", "23", "4304606", "", "-29.91778", "-51.18361", "America/Sao_Paulo"),
("3467512", "Canguçu", "", "BR", "76", "", "23", "4304507", "", "-31.395", "-52.67556", "America/Sao_Paulo"),
("3467530", "Canela", "Канела", "BR", "76", "", "23", "4304408", "", "-29.35622", "-50.81357", "America/Sao_Paulo"),
("3467542", "Cândido Mota", "", "BR", "76", "", "27", "3510005", "", "-22.74639", "-50.38694", "America/Sao_Paulo"),
("3467545", "Cândido de Abreu", "", "BR", "76", "", "18", "4104402", "", "-24.56694", "-51.33333", "America/Sao_Paulo"),
("3467550", "Candelária", "", "BR", "76", "", "23", "4304200", "", "-29.66917", "-52.78889", "America/Sao_Paulo"),
("3467577", "Canavieiras", "", "BR", "76", "", "05", "2906303", "", "-15.675", "-38.94722", "America/Bahia"),
("3467604", "Canarana", "", "BR", "76", "", "05", "2906204", "", "-11.68472", "-41.76889", "America/Bahia"),
("3467609", "Cananéia", "", "BR", "76", "", "27", "3509908", "", "-25.01472", "-47.92667", "America/Sao_Paulo"),
("3467673", "Campo Verde", "", "BR", "76", "", "11", "5004908", "", "-20.41667", "-54.06667", "America/Campo_Grande"),
("3467677", "Campos Novos", "Кампус-Новус", "BR", "76", "", "26", "4203600", "", "-27.40167", "-51.225", "America/Sao_Paulo"),
("3467680", "Campos Gerais", "Кампус-Жерайс", "BR", "76", "", "15", "3111606", "", "-21.235", "-45.75861", "America/Sao_Paulo"),
("3467684", "Campos do Jordão", "Кампус-ду-Жордау", "BR", "76", "", "27", "3509700", "", "-22.73944", "-45.59139", "America/Sao_Paulo"),
("3467687", "Campos Belos", "", "BR", "76", "", "29", "5204904", "", "-13.03667", "-46.77167", "America/Sao_Paulo"),
("3467688", "Campos Altos", "", "BR", "76", "", "15", "3111507", "", "-19.69611", "-46.17139", "America/Sao_Paulo"),
("3467693", "Campos dos Goytacazes", "Кампос", "BR", "76", "", "21", "3301009", "", "-21.75227", "-41.33044", "America/Sao_Paulo"),
("3467717", "Campo Mourão", "", "BR", "76", "", "18", "4104303", "", "-24.04309", "-52.37929", "America/Sao_Paulo"),
("3467736", "Campo Largo", "", "BR", "76", "", "18", "4104204", "", "-25.45955", "-49.53014", "America/Sao_Paulo"),
("3467747", "Campo Grande", "Кампу-Гранди", "BR", "76", "", "11", "5002704", "", "-20.44278", "-54.64639", "America/Campo_Grande"),
("3467760", "Campo Formoso", "", "BR", "76", "", "05", "2906006", "", "-10.5075", "-40.32139", "America/Bahia"),
("3467780", "Campo do Brito", "", "BR", "76", "", "28", "2801009", "", "-10.73333", "-37.49333", "America/Maceio"),
("3467796", "Campo Belo", "Кампу-Белу", "BR", "76", "", "15", "3111200", "", "-20.89722", "-45.27722", "America/Sao_Paulo"),
("3467860", "Campina Verde", "", "BR", "76", "", "15", "3111101", "", "-19.53791", "-49.48813", "America/Sao_Paulo"),
("3467865", "Campinas", "Кампинас", "BR", "76", "", "27", "3509502", "", "-22.90556", "-47.06083", "America/Sao_Paulo"),
("3467877", "Campina Grande do Sul", "Кампина-Гранде-ду-Сул", "BR", "76", "", "18", "4104006", "", "-25.30556", "-49.05528", "America/Sao_Paulo"),
("3467908", "Campestre", "", "BR", "76", "", "15", "3111002", "", "-21.71111", "-46.24639", "America/Sao_Paulo"),
("3467928", "Campanha", "", "BR", "76", "", "15", "3110905", "", "-21.83611", "-45.40056", "America/Sao_Paulo"),
("3467952", "Cambuquira", "", "BR", "76", "", "15", "3110707", "", "-21.85222", "-45.29583", "America/Sao_Paulo"),
("3467956", "Cambuí", "", "BR", "76", "", "15", "3110608", "", "-22.61222", "-46.0575", "America/Sao_Paulo"),
("3467962", "Cambuci", "", "BR", "76", "", "21", "3300902", "", "-21.57528", "-41.91111", "America/Sao_Paulo"),
("3467978", "Cambé", "", "BR", "76", "", "18", "4103701", "", "-23.27583", "-51.27833", "America/Sao_Paulo"),
("3467985", "Cambará", "", "BR", "76", "", "18", "4103602", "", "-23.04639", "-50.07361", "America/Sao_Paulo"),
("3468014", "Camaquã", "", "BR", "76", "", "23", "4303509", "", "-30.85111", "-51.81222", "America/Sao_Paulo"),
("3468020", "Camapuã", "", "BR", "76", "", "11", "5002605", "", "-19.53139", "-54.04389", "America/Campo_Grande"),
("3468023", "Camanducaia", "", "BR", "76", "", "15", "3110509", "", "-22.75528", "-46.14472", "America/Sao_Paulo"),
("3468025", "Camamu", "", "BR", "76", "", "05", "2905800", "", "-13.94472", "-39.10389", "America/Bahia"),
("3468031", "Camaçari", "", "BR", "76", "", "05", "2905701", "", "-12.6975", "-38.32417", "America/Bahia"),
("3468100", "Caldas Novas", "", "BR", "76", "", "29", "5204508", "", "-17.74431", "-48.62789", "America/Sao_Paulo"),
("3468121", "Cajuru", "", "BR", "76", "", "27", "3509403", "", "-21.27528", "-47.30417", "America/Sao_Paulo"),
("3468157", "Cajati", "", "BR", "76", "", "27", "3509254", "", "-24.73611", "-48.12278", "America/Sao_Paulo"),
("3468158", "Cajamar", "", "BR", "76", "", "27", "3509205", "", "-23.35611", "-46.87694", "America/Sao_Paulo"),
("3468215", "Caieiras", "", "BR", "76", "", "27", "3509007", "", "-23.36417", "-46.74056", "America/Sao_Paulo"),
("3468234", "Caiapônia", "", "BR", "76", "", "29", "5204409", "", "-16.95667", "-51.81028", "America/Sao_Paulo"),
("3468296", "Cafelândia", "", "BR", "76", "", "27", "3508801", "", "-21.8025", "-49.61", "America/Sao_Paulo"),
("3468314", "Cafarnaum", "", "BR", "76", "", "05", "2905305", "", "-11.69361", "-41.46833", "America/Bahia"),
("3468317", "Caetité", "Каэтите", "BR", "76", "", "05", "2905206", "", "-14.06944", "-42.475", "America/Bahia"),
("3468327", "Caeté", "Каэте", "BR", "76", "", "15", "3110004", "", "-19.88", "-43.66972", "America/Sao_Paulo"),
("3468349", "Caculé", "", "BR", "76", "", "05", "2905008", "", "-14.50333", "-42.22222", "America/Bahia"),
("3468352", "Caçu", "", "BR", "76", "", "29", "5204300", "", "-18.55667", "-51.13083", "America/Sao_Paulo"),
("3468353", "Caconde", "", "BR", "76", "", "27", "3508702", "", "-21.52944", "-46.64389", "America/Sao_Paulo"),
("3468376", "Cachoeiro de Itapemirim", "Кашуэйру-ди-Итапемирин", "BR", "76", "", "08", "3201209", "", "-20.84889", "-41.11278", "America/Sao_Paulo"),
("3468403", "Cachoeirinha", "", "BR", "76", "", "23", "4303103", "", "-29.95111", "-51.09389", "America/Sao_Paulo"),
("3468425", "Cachoeiras de Macacu", "", "BR", "76", "", "21", "3300803", "", "-22.4625", "-42.65306", "America/Sao_Paulo"),
("3468436", "Cachoeira do Sul", "Кашуэйра-ду-Сул", "BR", "76", "", "23", "4303004", "", "-30.03917", "-52.89389", "America/Sao_Paulo"),
("3468535", "Cachoeira", "", "BR", "76", "", "05", "2904902", "", "-12.60139", "-38.96576", "America/Bahia"),
("3468553", "Cacequi", "", "BR", "76", "", "23", "4302907", "", "-29.88361", "-54.825", "America/Sao_Paulo"),
("3468560", "Caçapava do Sul", "", "BR", "76", "", "23", "4302808", "", "-30.51436", "-53.48496", "America/Sao_Paulo"),
("3468562", "Caçapava", "", "BR", "76", "", "27", "3508504", "", "-23.10083", "-45.70694", "America/Sao_Paulo"),
("3468570", "Caçador", "Касадор", "BR", "76", "", "26", "4203006", "", "-26.77528", "-51.015", "America/Sao_Paulo"),
("3468592", "Cabreúva", "Кабреува", "BR", "76", "", "27", "3508405", "", "-23.3075", "-47.13278", "America/Sao_Paulo"),
("3468615", "Cabo Frio", "Кабу-Фриу", "BR", "76", "", "21", "3300704", "", "-22.88717", "-42.02622", "America/Sao_Paulo"),
("3468704", "Butiá", "", "BR", "76", "", "23", "4302709", "", "-30.11972", "-51.96222", "America/Sao_Paulo"),
("3468720", "Buritizeiro", "", "BR", "76", "", "15", "3109402", "", "-17.35111", "-44.96222", "America/Sao_Paulo"),
("3468732", "Buritis", "", "BR", "76", "", "15", "3109303", "", "-15.61778", "-46.42333", "America/Sao_Paulo"),
("3468745", "Buriti Alegre", "", "BR", "76", "", "29", "5203906", "", "-18.14", "-49.04028", "America/Sao_Paulo"),
("3468789", "Buritama", "", "BR", "76", "", "27", "3508108", "", "-21.06611", "-50.14722", "America/Sao_Paulo"),
("3468802", "Buri", "", "BR", "76", "", "27", "3508009", "", "-23.7975", "-48.59278", "America/Sao_Paulo"),
("3468823", "Boquim", "", "BR", "76", "", "28", "2800670", "", "-11.14694", "-37.62056", "America/Maceio"),
("3468858", "Buerarema", "", "BR", "76", "", "05", "2904704", "", "-14.95944", "-39.29972", "America/Bahia"),
("3468869", "Bueno Brandão", "", "BR", "76", "", "15", "3109105", "", "-22.44083", "-46.35083", "America/Sao_Paulo"),
("3468879", "Brusque", "", "BR", "76", "", "26", "4202909", "", "-27.09795", "-48.91281", "America/Sao_Paulo"),
("3468893", "Brumado", "Брумаду", "BR", "76", "", "05", "2904605", "", "-14.20361", "-41.66528", "America/Bahia"),
("3468894", "Brumadinho", "", "BR", "76", "", "15", "3109006", "", "-20.14333", "-44.19972", "America/Sao_Paulo"),
("3468899", "Brotas", "", "BR", "76", "", "27", "3507902", "", "-22.28417", "-48.12667", "America/Sao_Paulo"),
("3468902", "Brodósqui", "", "BR", "76", "", "27", "3507803", "", "-20.99139", "-47.65861", "America/Sao_Paulo"),
("3469057", "Brasília de Minas", "", "BR", "76", "", "15", "3108602", "", "-16.20639", "-44.43333", "America/Sao_Paulo"),
("3469058", "Brasília", "Бразилия", "BR", "76", "", "07", "5300108", "", "-15.77972", "-47.92972", "America/Sao_Paulo"),
("3469092", "Bragança Paulista", "Браганса-Паулиста", "BR", "76", "", "27", "3507605", "", "-22.9527", "-46.54418", "America/Sao_Paulo"),
("3469115", "Braço do Norte", "", "BR", "76", "", "26", "4202800", "", "-28.275", "-49.16556", "America/Sao_Paulo"),
("3469136", "Botucatu", "Ботукату", "BR", "76", "", "27", "3507506", "", "-22.88583", "-48.445", "America/Sao_Paulo"),
("3469140", "Botelhos", "", "BR", "76", "", "15", "3108404", "", "-21.63333", "-46.395", "America/Sao_Paulo"),
("3469169", "Borda da Mata", "", "BR", "76", "", "15", "3108305", "", "-22.27417", "-46.16528", "America/Sao_Paulo"),
("3469173", "Borborema", "", "BR", "76", "", "27", "3507407", "", "-21.61972", "-49.07361", "America/Sao_Paulo"),
("3469190", "Boquira", "", "BR", "76", "", "05", "2904100", "", "-12.82306", "-42.73056", "America/Bahia"),
("3469294", "Bonito", "", "BR", "76", "", "11", "5002209", "", "-21.12111", "-56.48194", "America/Campo_Grande"),
("3469374", "Bom Sucesso", "", "BR", "76", "", "15", "3108008", "", "-21.03306", "-44.75806", "America/Sao_Paulo"),
("3469421", "Bom Jesus dos Perdões", "", "BR", "76", "", "27", "3507100", "", "-23.135", "-46.46528", "America/Sao_Paulo"),
("3469425", "Bom Jesus do Itabapoana", "Бон-Жезус-ду-Итабапоана", "BR", "76", "", "21", "3300605", "", "-21.13389", "-41.67972", "America/Sao_Paulo"),
("3469426", "Bom Jesus do Galho", "", "BR", "76", "", "15", "3107802", "", "-19.82889", "-42.31611", "America/Sao_Paulo"),
("3469437", "Bom Jesus da Lapa", "Бон-Жезус-да-Лапа", "BR", "76", "", "05", "2903904", "", "-13.255", "-43.41806", "America/Bahia"),
("3469516", "Bom Despacho", "", "BR", "76", "", "15", "3107406", "", "-19.73639", "-45.25222", "America/Sao_Paulo"),
("3469540", "Boituva", "", "BR", "76", "", "27", "3507001", "", "-23.28333", "-47.67222", "America/Sao_Paulo"),
("3469601", "Bocaiúva", "", "BR", "76", "", "15", "3107307", "", "-17.10778", "-43.815", "America/Sao_Paulo"),
("3469910", "Boa Esperança do Sul", "", "BR", "76", "", "27", "3506706", "", "-21.9925", "-48.39083", "America/Sao_Paulo"),
("3469932", "Boa Esperança", "Боа-Эсперанса", "BR", "76", "", "15", "3107109", "", "-21.09", "-45.56583", "America/Sao_Paulo"),
("3469942", "Boa Esperança", "", "BR", "76", "", "08", "3201001", "", "-18.54", "-40.29583", "America/Sao_Paulo"),
("3469968", "Blumenau", "Блуменау", "BR", "76", "", "26", "4202404", "", "-26.91944", "-49.06611", "America/Sao_Paulo"),
("3469984", "Biritiba Mirim", "", "BR", "76", "", "27", "3506607", "", "-23.5725", "-46.03861", "America/Sao_Paulo"),
("3469989", "Birigui", "", "BR", "76", "", "27", "3506508", "", "-21.28861", "-50.34", "America/Sao_Paulo"),
("3470003", "Biguaçu", "", "BR", "76", "", "26", "4202305", "", "-27.49417", "-48.65556", "America/Sao_Paulo"),
("3470025", "Bicas", "", "BR", "76", "", "15", "3106903", "", "-21.72528", "-43.05944", "America/Sao_Paulo"),
("3470044", "Betim", "Бетин", "BR", "76", "", "15", "3106705", "", "-19.96778", "-44.19833", "America/Sao_Paulo"),
("3470052", "Bertioga", "", "BR", "76", "", "27", "3506359", "", "-23.85444", "-46.13861", "America/Sao_Paulo"),
("3470059", "Bernardino de Campos", "", "BR", "76", "", "27", "3506300", "", "-23.01306", "-49.47417", "America/Sao_Paulo"),
("3470073", "Bento Gonçalves", "", "BR", "76", "", "23", "4302105", "", "-29.17139", "-51.51917", "America/Sao_Paulo"),
("3470117", "Belo Oriente", "", "BR", "76", "", "15", "3106309", "", "-19.22", "-42.48361", "America/Sao_Paulo"),
("3470127", "Belo Horizonte", "Белу-Оризонти", "BR", "76", "", "15", "3106200", "", "-19.92083", "-43.93778", "America/Sao_Paulo"),
("3470137", "Belmonte", "", "BR", "76", "", "05", "2903409", "", "-15.86104", "-38.88143", "America/Bahia"),
("3470142", "Belford Roxo", "Белфорд-Рошу", "BR", "76", "", "21", "3300456", "", "-22.76417", "-43.39944", "America/Sao_Paulo"),
("3470162", "Bela Vista do Paraíso", "", "BR", "76", "", "18", "4102802", "", "-22.99667", "-51.19056", "America/Sao_Paulo"),
("3470164", "Bela Vista de Goiás", "", "BR", "76", "", "29", "5203302", "", "-16.97278", "-48.95333", "America/Sao_Paulo"),
("3470177", "Bela Vista", "", "BR", "76", "", "11", "5002100", "", "-22.10889", "-56.52111", "America/Campo_Grande"),
("3470264", "Bebedouro", "", "BR", "76", "", "27", "3506102", "", "-20.94944", "-48.47917", "America/Sao_Paulo"),
("3470279", "Bauru", "Бауру", "BR", "76", "", "27", "3506003", "", "-22.31472", "-49.06056", "America/Sao_Paulo"),
("3470324", "Batatais", "Бататайс", "BR", "76", "", "27", "3505906", "", "-20.89111", "-47.585", "America/Sao_Paulo"),
("3470338", "Bataiporã", "", "BR", "76", "", "11", "5002001", "", "-22.29528", "-53.27111", "America/Campo_Grande"),
("3470341", "Bastos", "", "BR", "76", "", "27", "3505807", "", "-21.92194", "-50.73389", "America/Sao_Paulo"),
("3470353", "Barueri", "Баруэри", "BR", "76", "", "27", "3505708", "", "-23.51056", "-46.87611", "America/Sao_Paulo"),
("3470369", "Barroso", "", "BR", "76", "", "15", "3105905", "", "-21.18694", "-43.97583", "America/Sao_Paulo"),
("3470409", "Barro Alto", "", "BR", "76", "", "29", "5203203", "", "-14.97083", "-48.91583", "America/Sao_Paulo"),
("3470410", "Barro Alto", "", "BR", "76", "", "05", "2903235", "", "-11.76083", "-41.91167", "America/Bahia"),
("3470428", "Barrinha", "", "BR", "76", "", "27", "3505609", "", "-21.19361", "-48.16389", "America/Sao_Paulo"),
("3470451", "Barretos", "Барретус", "BR", "76", "", "27", "3505500", "", "-20.55722", "-48.56778", "America/Sao_Paulo"),
("3470470", "Barreiro do Jaíba", "", "BR", "76", "", "15", "3171030", "", "-15.61532", "-43.59187", "America/Sao_Paulo"),
("3470583", "Barreiras", "Баррейрас", "BR", "76", "", "05", "2903201", "", "-12.15278", "-44.99", "America/Bahia"),
("3470597", "Barra Velha", "", "BR", "76", "", "26", "4202107", "", "-26.63222", "-48.68472", "America/Sao_Paulo"),
("3470636", "Barra Mansa", "Барра-Манса", "BR", "76", "", "21", "3300407", "", "-22.54417", "-44.17139", "America/Sao_Paulo"),
("3470674", "Barra dos Coqueiros", "", "BR", "76", "", "28", "2800605", "", "-10.90889", "-37.03861", "America/Maceio"),
("3470691", "Barra do Piraí", "", "BR", "76", "", "21", "3300308", "", "-22.47", "-43.82556", "America/Sao_Paulo"),
("3470709", "Barra do Garças", "Барра-ду-Гарсас", "BR", "76", "", "14", "5101803", "", "-15.89", "-52.25667", "America/Cuiaba"),
("3470718", "Barra do Bugres", "", "BR", "76", "", "14", "5101704", "", "-15.0725", "-57.18111", "America/Cuiaba"),
("3470730", "Barra de São Francisco", "Барра-де-Сан-Франциско", "BR", "76", "", "08", "3200904", "", "-18.755", "-40.89083", "America/Sao_Paulo"),
("3470744", "Barra da Estiva", "", "BR", "76", "", "05", "2902807", "", "-13.62611", "-41.32694", "America/Bahia"),
("3470776", "Barra Bonita", "", "BR", "76", "", "27", "3505302", "", "-22.49472", "-48.55806", "America/Sao_Paulo"),
("3470821", "Barra", "Барра", "BR", "76", "", "05", "2902708", "", "-11.08944", "-43.14167", "America/Bahia"),
("3470825", "Bariri", "", "BR", "76", "", "27", "3505203", "", "-22.07444", "-48.74028", "America/Sao_Paulo"),
("3470858", "Barbacena", "", "BR", "76", "", "15", "3105608", "", "-21.22583", "-43.77361", "America/Sao_Paulo"),
("3470878", "Barão de Cocais", "", "BR", "76", "", "15", "3105400", "", "-19.94583", "-43.48722", "America/Sao_Paulo"),
("3470912", "Bandeirantes", "", "BR", "76", "", "18", "4102406", "", "-23.11", "-50.3675", "America/Sao_Paulo"),
("3471005", "Bambuí", "", "BR", "76", "", "15", "3105103", "", "-20.00639", "-45.97694", "America/Sao_Paulo"),
("3471039", "Balneário Camboriú", "Балнеариу-Камбориу", "BR", "76", "", "26", "4202008", "", "-26.99056", "-48.63472", "America/Sao_Paulo"),
("3471061", "Baixo Guandu", "", "BR", "76", "", "08", "3200805", "", "-19.51889", "-41.01583", "America/Sao_Paulo"),
("3471094", "Baixa Grande", "", "BR", "76", "", "05", "2902609", "", "-11.95972", "-40.16806", "America/Bahia"),
("3471196", "Bagé", "Баг", "BR", "76", "", "23", "4301602", "", "-31.33139", "-54.10694", "America/Sao_Paulo"),
("3471208", "Baependi", "", "BR", "76", "", "15", "3104908", "", "-21.95889", "-44.89", "America/Sao_Paulo"),
("3471210", "Bady Bassitt", "", "BR", "76", "", "27", "3504602", "", "-20.91806", "-49.44528", "America/Sao_Paulo"),
("3471291", "Avaré", "", "BR", "76", "", "27", "3504503", "", "-23.09861", "-48.92583", "America/Sao_Paulo"),
("3471309", "Auriflama", "", "BR", "76", "", "27", "3504206", "", "-20.68556", "-50.55472", "America/Sao_Paulo"),
("3471335", "Atibaia", "Атибая", "BR", "76", "", "27", "3504107", "", "-23.11694", "-46.55028", "America/Sao_Paulo"),
("3471368", "Astorga", "", "BR", "76", "", "18", "4102109", "", "-23.2325", "-51.66556", "America/Sao_Paulo"),
("3471369", "Astolfo Dutra", "", "BR", "76", "", "15", "3104601", "", "-21.31528", "-42.86222", "America/Sao_Paulo"),
("3471374", "Assis", "Ассис", "BR", "76", "", "27", "3504008", "", "-22.66167", "-50.41222", "America/Sao_Paulo"),
("3471377", "Assaí", "", "BR", "76", "", "18", "4101903", "", "-23.37333", "-50.84139", "America/Sao_Paulo"),
("3471393", "Arujá", "", "BR", "76", "", "27", "3503901", "", "-23.39611", "-46.32083", "America/Sao_Paulo"),
("3471395", "Artur Nogueira", "", "BR", "76", "", "27", "3503802", "", "-22.57306", "-47.1725", "America/Sao_Paulo"),
("3471422", "Arroio Grande", "", "BR", "76", "", "23", "4301305", "", "-32.2375", "-53.08694", "America/Sao_Paulo"),
("3471425", "Arroio dos Ratos", "", "BR", "76", "", "23", "4301107", "", "-30.07722", "-51.72917", "America/Sao_Paulo"),
("3471428", "Arroio do Meio", "", "BR", "76", "", "23", "4301008", "", "-29.40111", "-51.945", "America/Sao_Paulo"),
("3471451", "Arraial do Cabo", "", "BR", "76", "", "21", "3300258", "", "-22.96611", "-42.02778", "America/Sao_Paulo"),
("3471487", "Armação de Búzios", "", "BR", "76", "", "21", "3300233", "", "-22.74694", "-41.88167", "America/Sao_Paulo"),
("3471522", "Arinos", "", "BR", "76", "", "15", "3104502", "", "-15.91694", "-46.10556", "America/Sao_Paulo"),
("3471551", "Arenápolis", "", "BR", "76", "", "14", "5101308", "", "-14.45028", "-56.84611", "America/Cuiaba"),
("3471609", "Areia Branca", "", "BR", "76", "", "28", "2800506", "", "-10.75778", "-37.31528", "America/Maceio"),
("3471665", "Areal", "", "BR", "76", "", "21", "3300225", "", "-22.23056", "-43.10556", "America/Sao_Paulo"),
("3471674", "Areado", "", "BR", "76", "", "15", "3104304", "", "-21.35861", "-46.14556", "America/Sao_Paulo"),
("3471683", "Arcos", "Аркос", "BR", "76", "", "15", "3104205", "", "-20.28194", "-45.53944", "America/Sao_Paulo"),
("3471691", "Araxá", "Араша", "BR", "76", "", "15", "3104007", "", "-19.59333", "-46.94056", "America/Sao_Paulo"),
("3471697", "Araucária", "Араукария", "BR", "76", "", "18", "4101804", "", "-25.59306", "-49.41028", "America/Sao_Paulo"),
("3471715", "Araruama", "Араруама", "BR", "76", "", "21", "3300209", "", "-22.87278", "-42.34306", "America/Sao_Paulo"),
("3471758", "Araras", "", "BR", "76", "", "27", "3503307", "", "-22.35694", "-47.38417", "America/Sao_Paulo"),
("3471766", "Araraquara", "Араракуара", "BR", "76", "", "27", "3503208", "", "-21.79444", "-48.17556", "America/Sao_Paulo"),
("3471772", "Araranguá", "Арарангуа", "BR", "76", "", "26", "4201406", "", "-28.93575", "-49.49538", "America/Sao_Paulo"),
("3471798", "Arapongas", "Арапонгас", "BR", "76", "", "18", "4101507", "", "-23.41944", "-51.42444", "America/Sao_Paulo"),
("3471830", "Araguari", "Арагуари", "BR", "76", "", "15", "3103504", "", "-18.64722", "-48.18722", "America/Sao_Paulo"),
("3471840", "Aragarças", "", "BR", "76", "", "29", "5201702", "", "-15.8975", "-52.25083", "America/Sao_Paulo"),
("3471846", "Araçuaí", "Арасуаи", "BR", "76", "", "15", "3103405", "", "-16.84972", "-42.07028", "America/Sao_Paulo"),
("3471848", "Aracruz", "Аракрус", "BR", "76", "", "08", "3200607", "", "-19.82028", "-40.27333", "America/Sao_Paulo"),
("3471849", "Araçoiaba da Serra", "", "BR", "76", "", "27", "3502903", "", "-23.50528", "-47.61417", "America/Sao_Paulo"),
("3471854", "Araci", "", "BR", "76", "", "05", "2902104", "", "-11.33333", "-38.96667", "America/Bahia"),
("3471859", "Araçatuba", "Арасатуба", "BR", "76", "", "27", "3502804", "", "-21.20889", "-50.43278", "America/Sao_Paulo"),
("3471872", "Aracaju", "Аракажу", "BR", "76", "", "28", "2800308", "", "-10.91111", "-37.07167", "America/Maceio"),
("3471896", "Aquidauana", "", "BR", "76", "", "11", "5001102", "", "-20.47111", "-55.78722", "America/Campo_Grande"),
("3471902", "Aquidabã", "", "BR", "76", "", "28", "2800209", "", "-10.28139", "-37.01861", "America/Maceio"),
("3471910", "Apucarana", "", "BR", "76", "", "18", "4101408", "", "-23.55083", "-51.46083", "America/Sao_Paulo"),
("3471927", "Apiaí", "", "BR", "76", "", "27", "3502705", "", "-24.50944", "-48.8425", "America/Sao_Paulo"),
("3471940", "Aparecida do Taboado", "", "BR", "76", "", "11", "5001003", "", "-20.08667", "-51.09361", "America/Campo_Grande"),
("3471949", "Aparecida", "Апаресида", "BR", "76", "", "27", "3502507", "", "-22.84694", "-45.22972", "America/Sao_Paulo"),
("3472048", "Antonina", "", "BR", "76", "", "18", "4101200", "", "-25.42861", "-48.71194", "America/Sao_Paulo"),
("3472138", "Anicuns", "", "BR", "76", "", "29", "5201306", "", "-16.46111", "-49.96167", "America/Sao_Paulo"),
("3472174", "Anguera", "", "BR", "76", "", "05", "2901502", "", "-12.15111", "-39.24639", "America/Bahia"),
("3472177", "Angra dos Reis", "Ангра-дус-Рейс", "BR", "76", "", "21", "3300100", "", "-23.00667", "-44.31806", "America/Sao_Paulo"),
("3472234", "Angatuba", "", "BR", "76", "", "27", "3502200", "", "-23.48972", "-48.41278", "America/Sao_Paulo"),
("3472245", "Andrelândia", "", "BR", "76", "", "15", "3102803", "", "-21.73972", "-44.30917", "America/Sao_Paulo"),
("3472248", "Andradina", "", "BR", "76", "", "27", "3502101", "", "-20.89611", "-51.37944", "America/Sao_Paulo"),
("3472254", "Andradas", "Андрадас", "BR", "76", "", "15", "3102605", "", "-22.06806", "-46.56917", "America/Sao_Paulo"),
("3472284", "Anastácio", "", "BR", "76", "", "11", "5000708", "", "-20.48361", "-55.80694", "America/Campo_Grande"),
("3472287", "Anápolis", "Анаполис", "BR", "76", "", "29", "5201108", "", "-16.32667", "-48.95278", "America/Sao_Paulo"),
("3472304", "Ampére", "", "BR", "76", "", "18", "4101002", "", "-25.915", "-53.47278", "America/Sao_Paulo"),
("3472311", "Amparo", "", "BR", "76", "", "27", "3501905", "", "-22.70111", "-46.76444", "America/Sao_Paulo"),
("3472338", "Américo Brasiliense", "", "BR", "76", "", "27", "3501707", "", "-21.72444", "-48.10167", "America/Sao_Paulo"),
("3472343", "Americana", "Американа", "BR", "76", "", "27", "3501608", "", "-22.73917", "-47.33139", "America/Sao_Paulo"),
("3472344", "América Dourada", "", "BR", "76", "", "05", "2901155", "", "-11.45528", "-41.43611", "America/Bahia"),
("3472370", "Amargosa", "", "BR", "76", "", "05", "2901007", "", "-13.03028", "-39.60472", "America/Bahia"),
("3472404", "Alvorada", "", "BR", "76", "", "31", "1700707", "", "-12.48", "-49.12472", "America/Araguaina"),
("3472406", "Alvinópolis", "", "BR", "76", "", "15", "3102308", "", "-20.10667", "-43.04889", "America/Sao_Paulo"),
("3472417", "Álvares Machado", "", "BR", "76", "", "27", "3501301", "", "-22.07944", "-51.47194", "America/Sao_Paulo"),
("3472437", "Alto Piquiri", "", "BR", "76", "", "18", "4100707", "", "-24.02806", "-53.44056", "America/Sao_Paulo"),
("3472440", "Alto Paraná", "", "BR", "76", "", "18", "4100608", "", "-23.12889", "-52.31889", "America/Sao_Paulo"),
("3472444", "Altãnia", "", "BR", "76", "", "18", "4100509", "", "-23.87444", "-53.90167", "America/Sao_Paulo"),
("3472473", "Alto Araguaia", "", "BR", "76", "", "14", "5100300", "", "-17.31472", "-53.21528", "America/Cuiaba"),
("3472485", "Altinópolis", "", "BR", "76", "", "27", "3501004", "", "-21.02556", "-47.37389", "America/Sao_Paulo"),
("3472487", "Alterosa", "", "BR", "76", "", "15", "3102001", "", "-21.24917", "-46.14306", "America/Sao_Paulo"),
("3472507", "Alpinópolis", "", "BR", "76", "", "15", "3101904", "", "-20.86361", "-46.38806", "America/Sao_Paulo"),
("3472518", "Almirante Tamandaré", "", "BR", "76", "", "18", "4100400", "", "-25.32472", "-49.31", "America/Sao_Paulo"),
("3472520", "Almenara", "Альменара", "BR", "76", "", "15", "3101706", "", "-16.18361", "-40.69444", "America/Sao_Paulo"),
("3472596", "Alfredo Chaves", "", "BR", "76", "", "08", "3200300", "", "-20.635", "-40.74972", "America/Sao_Paulo"),
("3472603", "Alfenas", "", "BR", "76", "", "15", "3101607", "", "-21.42917", "-45.94722", "America/Sao_Paulo"),
("3472609", "Além Paraíba", "", "BR", "76", "", "15", "3101508", "", "-21.88778", "-42.70444", "America/Sao_Paulo"),
("3472638", "Alegrete", "Алегрети", "BR", "76", "", "23", "4300406", "", "-29.78306", "-55.79194", "America/Sao_Paulo"),
("3472666", "Alegre", "", "BR", "76", "", "08", "3200201", "", "-20.76361", "-41.53306", "America/Sao_Paulo"),
("3472766", "Alagoinhas", "Алагоиньяс", "BR", "76", "", "05", "2900702", "", "-12.13556", "-38.41917", "America/Bahia"),
("3472808", "Aimorés", "", "BR", "76", "", "15", "3101102", "", "-19.49583", "-41.06389", "America/Sao_Paulo"),
("3472825", "Agudos", "", "BR", "76", "", "27", "3500709", "", "-22.46917", "-48.9875", "America/Sao_Paulo"),
("3472848", "Águas Vermelhas", "", "BR", "76", "", "15", "3101003", "", "-15.74722", "-41.46", "America/Sao_Paulo"),
("3472864", "Águas Formosas", "", "BR", "76", "", "15", "3100906", "", "-17.08222", "-40.93583", "America/Sao_Paulo"),
("3472869", "Águas de Lindóia", "", "BR", "76", "", "27", "3500501", "", "-22.47639", "-46.63278", "America/Sao_Paulo"),
("3472969", "Aguaí", "", "BR", "76", "", "27", "3500303", "", "-22.05944", "-46.97861", "America/Sao_Paulo"),
("3473129", "Afonso Cláudio", "", "BR", "76", "", "08", "3200102", "", "-20.07417", "-41.12389", "America/Sao_Paulo"),
("3473157", "Adamantina", "", "BR", "76", "", "27", "3500105", "", "-21.68528", "-51.0725", "America/Sao_Paulo"),
("3473183", "Açucena", "", "BR", "76", "", "15", "3100500", "", "-19.07306", "-42.54639", "America/Sao_Paulo"),
("3473218", "Acajutiba", "", "BR", "76", "", "05", "2900306", "", "-11.66222", "-38.01722", "America/Bahia"),
("3473267", "Abaeté", "Абаэте", "BR", "76", "", "15", "3100203", "", "-19.16", "-45.44583", "America/Sao_Paulo"),
("3473268", "Abadiânia", "", "BR", "76", "", "29", "5200100", "", "-16.20417", "-48.70694", "America/Sao_Paulo"),
("3473964", "Guaíba", "", "BR", "76", "", "23", "4309308", "", "-30.11389", "-51.325", "America/Sao_Paulo"),
("3474574", "Palmas", "Палмас", "BR", "76", "", "31", "1721000", "", "-10.16745", "-48.32766", "America/Araguaina"),
("3478424", "Pontal do Paraná", "", "BR", "76", "", "18", "4119954", "", "-25.67361", "-48.51111", "America/Sao_Paulo"),
("3661944", "Tefé", "", "BR", "76", "", "04", "1304203", "", "-3.36841", "-64.72054", "America/Manaus"),
("3661980", "Tarauacá", "", "BR", "76", "", "01", "1200609", "", "-8.16139", "-70.76556", "America/Rio_Branco"),
("3662075", "Tabatinga", "", "BR", "76", "", "04", "1304062", "", "-4.23116", "-69.93858", "America/Manaus"),
("3662155", "Sena Madureira", "", "BR", "76", "", "01", "1200500", "", "-9.06341", "-68.67245", "America/Rio_Branco"),
("3662252", "São Paulo de Olivença", "", "BR", "76", "", "04", "1303908", "", "-3.37833", "-68.8725", "America/Manaus"),
("3662342", "São Gabriel da Cachoeira", "", "BR", "76", "", "04", "1303809", "", "-0.1181", "-67.08527", "America/Manaus"),
("3662395", "Santo Antônio do Içá", "", "BR", "76", "", "04", "1303700", "", "-3.10222", "-67.93972", "America/Manaus"),
("3662574", "Rio Branco", "Риу-Бранку", "BR", "76", "", "01", "1200401", "", "-9.97472", "-67.81", "America/Rio_Branco"),
("3662762", "Porto Velho", "Порту-Велью", "BR", "76", "", "24", "1100205", "", "-8.76194", "-63.90389", "America/Porto_Velho"),
("3662927", "Pauini", "", "BR", "76", "", "04", "1303502", "", "-7.71361", "-66.97639", "America/Manaus"),
("3663142", "Novo Aripuanã", "", "BR", "76", "", "04", "1303304", "", "-5.12056", "-60.37972", "America/Manaus"),
("3663503", "Manicoré", "", "BR", "76", "", "04", "1302702", "", "-5.80917", "-61.30028", "America/Manaus"),
("3663516", "Mâncio Lima", "", "BR", "76", "", "01", "1200336", "", "-7.61417", "-72.89583", "America/Rio_Branco"),
("3663517", "Manaus", "Манаус", "BR", "76", "", "04", "1302603", "", "-3.10194", "-60.025", "America/Manaus"),
("3663524", "Manaquiri", "", "BR", "76", "", "04", "1302553", "", "-3.31667", "-60.35", "America/Manaus"),
("3663529", "Manacapuru", "Манакапуру", "BR", "76", "", "04", "1302504", "", "-3.29972", "-60.62056", "America/Manaus"),
("3663693", "Jutaí", "", "BR", "76", "", "04", "1302306", "", "-5.18333", "-68.9", "America/Manaus"),
("3664078", "Humaitá", "", "BR", "76", "", "04", "1301704", "", "-7.51651", "-63.03105", "America/Manaus"),
("3664207", "Fonte Boa", "", "BR", "76", "", "04", "1301605", "", "-2.51389", "-66.09167", "America/Manaus"),
("3664243", "Feijó", "", "BR", "76", "", "01", "1200302", "", "-8.1654", "-70.35486", "America/Rio_Branco"),
("3664301", "Envira", "", "BR", "76", "", "04", "1301407", "", "-7.3", "-70.21667", "America/Eirunepe"),
("3664321", "Eirunepé", "", "BR", "76", "", "04", "1301407", "", "-6.66028", "-69.87361", "America/Eirunepe"),
("3664464", "Cruzeiro do Sul", "", "BR", "76", "BR", "01", "1200203", "", "-7.62759", "-72.67756", "America/Rio_Branco"),
("3664525", "Codajás", "", "BR", "76", "", "04", "1301308", "", "-3.83667", "-62.05694", "America/Manaus"),
("3664539", "Coari", "Коари", "BR", "76", "", "04", "1301209", "", "-4.085", "-63.14139", "America/Manaus"),
("3664659", "Carauari", "", "BR", "76", "", "04", "1301001", "", "-4.88278", "-66.89583", "America/Manaus"),
("3664716", "Canutama", "", "BR", "76", "", "04", "1300904", "", "-6.53389", "-64.38306", "America/Manaus"),
("3664956", "Boca do Acre", "", "BR", "76", "", "04", "1300706", "", "-8.75222", "-67.39778", "America/Manaus"),
("3664980", "Boa Vista", "Боа-Виста", "BR", "76", "", "25", "1400100", "", "2.81972", "-60.67333", "America/Boa_Vista"),
("3665016", "Benjamin Constant", "", "BR", "76", "", "04", "1300607", "", "-4.37555", "-70.03179", "America/Eirunepe"),
("3665098", "Barcelos", "", "BR", "76", "", "04", "1300409", "", "-0.97357", "-62.9269", "America/Manaus"),
("3665199", "Ariquemes", "", "BR", "76", "", "24", "1100023", "", "-9.91333", "-63.04083", "America/Porto_Velho"),
("3665202", "Aripuanã", "Арипуанан", "BR", "76", "", "14", "5103254", "", "-9.16667", "-60.63333", "America/Cuiaba"),
("3665315", "Anori", "", "BR", "76", "", "04", "1300102", "", "-3.77278", "-61.64417", "America/Manaus"),
("3665380", "Alvarães", "", "BR", "76", "", "04", "1300029", "", "-3.22083", "-64.80417", "America/Manaus"),
("3736808", "Iranduba", "", "BR", "76", "", "04", "1301852", "", "-3.28472", "-60.18611", "America/Manaus"),
("3924674", "Xapuri", "", "BR", "76", "", "01", "1200708", "", "-10.65167", "-68.50444", "America/Rio_Branco"),
("3924679", "Vilhena", "Вилена", "BR", "76", "", "24", "1100304", "", "-12.74056", "-60.14583", "America/Porto_Velho"),
("3924752", "Senador Guiomard", "", "BR", "76", "", "01", "1200450", "", "-10.1497", "-67.73741", "America/Rio_Branco"),
("3924872", "Presidente Médici", "", "BR", "76", "", "24", "1100254", "", "-11.17528", "-61.90139", "America/Porto_Velho"),
("3924877", "Pôsto Fiscal Rolim de Moura", "", "BR", "76", "", "24", "1100015", "", "-13.08271", "-62.27726", "America/Porto_Velho"),
("3924895", "Plácido de Castro", "", "BR", "76", "", "01", "1200385", "", "-10.33528", "-67.18556", "America/Rio_Branco"),
("3924908", "Pimenta Bueno", "", "BR", "76", "", "24", "1100189", "", "-11.6725", "-61.19361", "America/Porto_Velho"),
("3924948", "Ouro Preto do Oeste", "Ору-Прету-ду-Уэсти", "BR", "76", "", "24", "1100155", "", "-10.74806", "-62.21583", "America/Porto_Velho"),
("3925033", "Ji Paraná", "", "BR", "76", "", "24", "1100122", "", "-10.88528", "-61.95167", "America/Porto_Velho"),
("3925040", "Jaru", "Жара", "BR", "76", "", "24", "1100114", "", "-10.43889", "-62.46639", "America/Porto_Velho"),
("3925075", "Guajará Mirim", "", "BR", "76", "", "24", "1100106", "", "-10.78278", "-65.33944", "America/Porto_Velho"),
("3925212", "Cacoal", "Какоал", "BR", "76", "", "24", "1100049", "", "-11.43861", "-61.44722", "America/Porto_Velho"),
("3925227", "Brasiléia", "", "BR", "76", "", "01", "1200104", "", "-11.01611", "-68.74806", "America/Rio_Branco"),
("6316406", "Aparecida de Goiânia", "Апаресида-ди-Гояния", "BR", "76", "", "29", "5201405", "", "-16.82333", "-49.24389", "America/Sao_Paulo"),
("6316729", "Campinas", "", "BR", "76", "", "26", "4216602", "", "-27.59444", "-48.60694", "America/Sao_Paulo"),
("6317344", "Jaboatão dos Guararapes", "Жабоатан-дус-Гуарарапис", "BR", "76", "", "30", "2607901", "", "-8.11278", "-35.01472", "America/Recife"),
("6317464", "Lauro de Freitas", "", "BR", "76", "", "05", "2919207", "", "-12.89444", "-38.32722", "America/Bahia"),
("6317953", "Pinhais", "", "BR", "76", "", "18", "4119152", "", "-25.44472", "-49.1925", "America/Sao_Paulo"),
("6318165", "Rio Preto da Eva", "", "BR", "76", "", "04", "1303569", "", "-2.69795", "-59.70172", "America/Manaus"),
("6318694", "Simões Filho", "", "BR", "76", "", "05", "2930709", "", "-12.78444", "-38.40389", "America/Bahia"),
("6318696", "Sinop", "", "BR", "76", "", "14", "5107909", "", "-11.86417", "-55.5025", "America/Cuiaba"),
("6693804", "Cambebba", "", "BR", "76", "", "06", "2303709", "", "-3.62092", "-38.82913", "America/Fortaleza"),
("7874475", "Itacorubi", "", "BR", "76", "", "26", "4205407", "", "-27.58315", "-48.49503", "America/Sao_Paulo"),
("7874477", "Santa Monica", "", "BR", "76", "", "26", "4205407", "", "-27.59137", "-48.50756", "America/Sao_Paulo"),
("7874479", "Trindade", "", "BR", "76", "", "26", "4205407", "", "-27.58612", "-48.52335", "America/Sao_Paulo"),
("7874481", "Saco dos Limoes", "", "BR", "76", "", "26", "4205407", "", "-27.60864", "-48.53605", "America/Sao_Paulo"),
("7874483", "Costeira do Pirajubae", "", "BR", "76", "", "26", "4205407", "", "-27.63586", "-48.5212", "America/Sao_Paulo"),
("7874492", "Freguesia do Ribeirao da Ilha", "", "BR", "76", "", "26", "4205407", "", "-27.71773", "-48.56266", "America/Sao_Paulo"),
("8739860", "Gavea", "", "BR", "76", "", "26", "4215109", "", "-26.90967", "-49.36547", "America/Sao_Paulo"),
("11184422", "Planaltina", "", "BR", "76", "", "07", "5300108", "", "-15.61791", "-47.64874", "America/Sao_Paulo"),
("932987", "Tshabong", "", "BW", "72", "BW", "04", "", "", "-26.05", "22.45", "Africa/Gaborone"),
("933000", "Tonota", "", "BW", "72", "", "01", "", "", "-21.44236", "27.46153", "Africa/Gaborone"),
("933018", "Thamaga", "", "BW", "72", "", "06", "", "", "-24.67014", "25.53975", "Africa/Gaborone"),
("933077", "Shakawe", "", "BW", "72", "", "11", "", "", "-18.36536", "21.84219", "Africa/Gaborone"),
("933088", "Serowe", "Серова", "BW", "72", "", "01", "", "", "-22.38754", "26.71077", "Africa/Gaborone"),
("933099", "Selebi-Phikwe", "", "BW", "72", "", "01", "", "", "-21.97895", "27.84296", "Africa/Gaborone"),
("933141", "Ramotswa", "", "BW", "72", "", "09", "", "", "-24.87158", "25.86989", "Africa/Gaborone"),
("933151", "Rakops", "", "BW", "72", "", "01", "", "", "-21.02257", "24.36052", "Africa/Gaborone"),
("933182", "Palapye", "Палапье", "BW", "72", "", "01", "", "", "-22.54605", "27.12507", "Africa/Gaborone"),
("933184", "Otse", "", "BW", "72", "", "09", "", "", "-25.01667", "25.73333", "Africa/Gaborone"),
("933186", "Orapa", "", "BW", "72", "", "01", "", "", "-21.3115", "25.37642", "Africa/Gaborone"),
("933271", "Mosopa", "", "BW", "72", "", "10", "", "", "-24.7718", "25.42156", "Africa/Gaborone"),
("933305", "Molepolole", "Молепололе", "BW", "72", "", "06", "", "", "-24.40659", "25.49508", "Africa/Gaborone"),
("933331", "Mogoditshane", "", "BW", "72", "", "06", "", "", "-24.62694", "25.86556", "Africa/Gaborone"),
("933340", "Mochudi", "Мочуди", "BW", "72", "BW", "05", "", "", "-24.41667", "26.15", "Africa/Gaborone"),
("933366", "Maun", "Маун", "BW", "72", "", "11", "", "", "-19.98333", "23.41667", "Africa/Gaborone"),
("933471", "Mahalapye", "", "BW", "72", "", "01", "", "", "-23.10407", "26.81421", "Africa/Gaborone"),
("933521", "Lobatse", "Лобаце", "BW", "72", "", "09", "", "", "-25.22435", "25.67728", "Africa/Gaborone"),
("933534", "Letlhakeng", "", "BW", "72", "", "06", "", "", "-24.09442", "25.02977", "Africa/Gaborone"),
("933535", "Letlhakane", "", "BW", "72", "", "01", "", "", "-21.41494", "25.59263", "Africa/Gaborone"),
("933596", "Kopong", "", "BW", "72", "", "09", "", "", "-24.48333", "25.88333", "Africa/Gaborone"),
("933677", "Kasane", "", "BW", "72", "", "11", "", "", "-17.81667", "25.15", "Africa/Gaborone"),
("933685", "Kanye", "Канье", "BW", "72", "", "10", "", "", "-24.96675", "25.33273", "Africa/Gaborone"),
("933719", "Janeng", "", "BW", "72", "", "09", "", "", "-25.41667", "25.55", "Africa/Gaborone"),
("933759", "Ghanzi", "", "BW", "72", "BW", "03", "", "", "-21.69785", "21.64581", "Africa/Gaborone"),
("933773", "Gaborone", "Габороне", "BW", "72", "", "09", "", "", "-24.65451", "25.90859", "Africa/Gaborone"),
("933777", "Gabane", "", "BW", "72", "", "06", "", "", "-24.66667", "25.78222", "Africa/Gaborone"),
("933778", "Francistown", "Франсистаун", "BW", "72", "", "08", "", "", "-21.16995", "27.50787", "Africa/Gaborone"),
("1106206", "Metsemotlhaba", "", "BW", "72", "", "06", "", "", "-24.55139", "25.80306", "Africa/Gaborone"),
("611866", "Skidal’", "", "BY", "112", "", "03", "", "", "53.5904", "24.2478", "Europe/Minsk"),
("618800", "Horad Zhodzina", "Жодино", "BY", "112", "", "05", "", "", "54.0985", "28.3331", "Europe/Minsk"),
("618806", "Zhlobin", "Жлобин", "BY", "112", "", "02", "", "", "52.8926", "30.024", "Europe/Minsk"),
("618815", "Zhytkavichy", "", "BY", "112", "", "02", "", "", "52.2168", "27.8561", "Europe/Minsk"),
("618913", "Zhabinka", "", "BY", "112", "", "01", "", "", "52.1984", "24.0115", "Europe/Minsk"),
("618932", "Zel’va", "", "BY", "112", "", "03", "", "", "53.1504", "24.8153", "Europe/Minsk"),
("619066", "Zaslawye", "", "BY", "112", "", "05", "", "", "54.0114", "27.2695", "Europe/Minsk"),
("619979", "Voranava", "", "BY", "112", "", "03", "", "", "54.1492", "25.3112", "Europe/Minsk"),
("620127", "Vitebsk", "Витебск", "BY", "112", "", "07", "", "", "55.1904", "30.2049", "Europe/Minsk"),
("620146", "Vishnyeva", "", "BY", "112", "", "03", "", "", "54.7102", "26.5228", "Europe/Minsk"),
("620181", "Vilyeyka", "Вилейка", "BY", "112", "", "05", "", "", "54.4914", "26.9111", "Europe/Minsk"),
("620214", "Vyetka", "", "BY", "112", "", "02", "", "", "52.5591", "31.1794", "Europe/Minsk"),
("620255", "Vyerkhnyadzvinsk", "", "BY", "112", "", "07", "", "", "55.7777", "27.9389", "Europe/Minsk"),
("620391", "Vawkavysk", "Волковыск", "BY", "112", "", "03", "", "", "53.1561", "24.4513", "Europe/Minsk"),
("620445", "Valozhyn", "", "BY", "112", "", "05", "", "", "54.0892", "26.5266", "Europe/Minsk"),
("620483", "Uzda", "", "BY", "112", "", "05", "", "", "53.4627", "27.2137", "Europe/Minsk"),
("620540", "Ushachy", "", "BY", "112", "", "07", "620539", "", "55.179", "28.6158", "Europe/Minsk"),
("620833", "Talachyn", "", "BY", "112", "", "07", "", "", "54.4087", "29.6955", "Europe/Minsk"),
("621048", "Svislach", "", "BY", "112", "", "03", "", "", "53.0368", "24.0957", "Europe/Minsk"),
("621074", "Svyetlahorsk", "Светлогорск", "BY", "112", "", "02", "", "", "52.6329", "29.7389", "Europe/Minsk"),
("621266", "Stowbtsy", "Столбцы", "BY", "112", "", "05", "", "", "53.4785", "26.7434", "Europe/Minsk"),
("621277", "Stolin", "", "BY", "112", "", "01", "", "", "51.89115", "26.84597", "Europe/Minsk"),
("621396", "Staryya Darohi", "", "BY", "112", "", "05", "", "", "53.0402", "28.267", "Europe/Minsk"),
("621462", "Starobin", "", "BY", "112", "", "05", "", "", "52.7267", "27.4606", "Europe/Minsk"),
("621713", "Smarhon’", "Сморгонь", "BY", "112", "", "03", "", "", "54.4798", "26.3957", "Europe/Minsk"),
("621729", "Horad Smalyavichy", "", "BY", "112", "", "05", "", "", "54.0249", "28.0894", "Europe/Minsk"),
("621732", "Smilavichy", "", "BY", "112", "", "05", "", "", "53.7496", "28.0115", "Europe/Minsk"),
("621741", "Slutsk", "Слуцк", "BY", "112", "", "05", "", "", "53.0274", "27.5597", "Europe/Minsk"),
("621754", "Slonim", "Слоним", "BY", "112", "", "03", "", "", "53.0869", "25.3163", "Europe/Minsk"),
("621838", "Slawharad", "", "BY", "112", "", "06", "", "", "53.4429", "31.0014", "Europe/Minsk"),
("622034", "Shklow", "", "BY", "112", "", "06", "", "", "54.2131", "30.2877", "Europe/Minsk"),
("622113", "Shchuchin", "Щучин", "BY", "112", "", "03", "", "", "53.6014", "24.7465", "Europe/Minsk"),
("622179", "Sharkawshchyna", "", "BY", "112", "", "07", "", "", "55.3689", "27.4686", "Europe/Minsk"),
("622258", "Syanno", "", "BY", "112", "", "07", "", "", "54.8108", "29.7086", "Europe/Minsk"),
("622428", "Salihorsk", "Солигорск", "BY", "112", "", "05", "", "", "52.7876", "27.5415", "Europe/Minsk"),
("622690", "Rasony", "", "BY", "112", "", "07", "", "", "55.9058", "28.8135", "Europe/Minsk"),
("622700", "Ros’", "", "BY", "112", "", "03", "", "", "53.2858", "24.4128", "Europe/Minsk"),
("622739", "Rahachow", "Рогачев", "BY", "112", "", "02", "", "", "53.0934", "30.0495", "Europe/Minsk"),
("622794", "Rechytsa", "Речица", "BY", "112", "", "02", "", "", "52.3617", "30.3916", "Europe/Minsk"),
("622849", "Rakaw", "", "BY", "112", "", "05", "", "", "53.9674", "27.0562", "Europe/Minsk"),
("622877", "Radashkovichy", "", "BY", "112", "", "05", "", "", "54.1554", "27.2412", "Europe/Minsk"),
("622997", "Pruzhany", "Пружаны", "BY", "112", "", "01", "", "", "52.556", "24.4573", "Europe/Minsk"),
("623317", "Polatsk", "Полоцк", "BY", "112", "", "07", "", "", "55.4879", "28.7856", "Europe/Minsk"),
("623512", "Plyeshchanitsy", "", "BY", "112", "", "05", "", "", "54.4235", "27.8301", "Europe/Minsk"),
("623549", "Pinsk", "Пинск", "BY", "112", "", "01", "", "", "52.1229", "26.0951", "Europe/Minsk"),
("623581", "Pyetrykaw", "", "BY", "112", "", "02", "", "", "52.1289", "28.4921", "Europe/Minsk"),
("623760", "Pastavy", "Поставы", "BY", "112", "", "07", "", "", "55.11676", "26.83263", "Europe/Minsk"),
("623941", "Astravyets", "", "BY", "112", "BY", "03", "", "", "54.61378", "25.95537", "Europe/Minsk"),
("624034", "Asipovichy", "Осиповичи", "BY", "112", "", "06", "", "", "53.3011", "28.6386", "Europe/Minsk"),
("624079", "Orsha", "Орша", "BY", "112", "", "07", "", "", "54.5081", "30.4172", "Europe/Minsk"),
("624400", "Novoye Medvezhino", "Медвежино", "BY", "112", "", "04", "", "", "53.88333", "27.45", "Europe/Minsk"),
("624494", "Novolukoml’", "", "BY", "112", "", "00", "", "", "54.66192", "29.15016", "Europe/Minsk"),
("624700", "Nyasvizh", "", "BY", "112", "", "05", "", "", "53.2189", "26.6779", "Europe/Minsk"),
("624784", "Navapolatsk", "Новополоцк", "BY", "112", "", "07", "", "", "55.5318", "28.5987", "Europe/Minsk"),
("624785", "Navahrudak", "Новогрудок", "BY", "112", "", "03", "", "", "53.5942", "25.8191", "Europe/Minsk"),
("624861", "Myadzyel", "", "BY", "112", "", "05", "", "", "54.8789", "26.9371", "Europe/Minsk"),
("624889", "Mstsislaw", "", "BY", "112", "", "06", "", "", "54.0185", "31.7217", "Europe/Minsk"),
("625130", "Myory", "", "BY", "112", "", "07", "", "", "55.6222", "27.6281", "Europe/Minsk"),
("625144", "Minsk", "Минск", "BY", "112", "", "04", "", "", "53.9", "27.56667", "Europe/Minsk"),
("625228", "Mikashevichy", "", "BY", "112", "", "01", "", "", "52.2173", "27.476", "Europe/Minsk"),
("625324", "Mazyr", "Мозырь", "BY", "112", "", "02", "", "", "52.0495", "29.2456", "Europe/Minsk"),
("625367", "Masty", "Мосты", "BY", "112", "", "03", "", "", "53.4122", "24.5387", "Europe/Minsk"),
("625409", "Mar’’ina Horka", "Марьина Горка", "BY", "112", "", "05", "", "", "53.509", "28.147", "Europe/Minsk"),
("625539", "Malaryta", "", "BY", "112", "", "01", "", "", "51.7905", "24.074", "Europe/Minsk"),
("625625", "Maladzyechna", "Молодечно", "BY", "112", "", "05", "", "", "54.3167", "26.854", "Europe/Minsk"),
("625665", "Mahilyow", "Могилёв", "BY", "112", "", "06", "", "", "53.9168", "30.3449", "Europe/Minsk"),
("625671", "Machulishchy", "", "BY", "112", "", "05", "", "", "53.7788", "27.5948", "Europe/Minsk"),
("625721", "Lyuban’", "", "BY", "112", "", "05", "", "", "52.7985", "28.0048", "Europe/Minsk"),
("625743", "Lyepyel’", "Лепель", "BY", "112", "", "07", "", "", "54.8814", "28.699", "Europe/Minsk"),
("625772", "Lyakhavichy", "", "BY", "112", "", "01", "", "", "53.0388", "26.2656", "Europe/Minsk"),
("625818", "Luninyets", "Лунинец", "BY", "112", "", "01", "", "", "52.2472", "26.8047", "Europe/Minsk"),
("625907", "Loyew", "", "BY", "112", "", "02", "", "", "51.9458", "30.7953", "Europe/Minsk"),
("625931", "Loshnitsa", "", "BY", "112", "", "05", "", "", "54.2796", "28.7649", "Europe/Minsk"),
("625972", "Lahoysk", "", "BY", "112", "", "05", "", "", "54.2064", "27.8512", "Europe/Minsk"),
("626064", "Lyozna", "", "BY", "112", "", "07", "626065", "", "55.0247", "30.797", "Europe/Minsk"),
("626081", "Lida", "Лида", "BY", "112", "", "03", "", "", "53.88333", "25.29972", "Europe/Minsk"),
("626450", "Krychaw", "Кричев", "BY", "112", "", "06", "", "", "53.7125", "31.717", "Europe/Minsk"),
("626471", "Krupki", "", "BY", "112", "", "05", "", "", "54.3178", "29.1374", "Europe/Minsk"),
("626491", "Kruhlaye", "", "BY", "112", "", "06", "", "", "54.2497", "29.7968", "Europe/Minsk"),
("626621", "Krasnasyel’ski", "", "BY", "112", "", "03", "", "", "53.2645", "24.4301", "Europe/Minsk"),
("626625", "Krasnapollye", "", "BY", "112", "", "06", "", "", "53.3353", "31.3999", "Europe/Minsk"),
("626806", "Kastsyukowka", "", "BY", "112", "", "02", "", "", "52.5387", "30.9173", "Europe/Minsk"),
("626808", "Kastsyukovichy", "", "BY", "112", "", "06", "", "", "53.3525", "32.0514", "Europe/Minsk"),
("626939", "Karelichy", "", "BY", "112", "", "03", "", "", "53.5648", "26.1406", "Europe/Minsk"),
("626956", "Kapyl’", "", "BY", "112", "", "05", "", "", "53.1516", "27.0913", "Europe/Minsk"),
("627083", "Kalodzishchy", "Колодищи", "BY", "112", "", "05", "", "", "53.944", "27.7823", "Europe/Minsk"),
("627145", "Kobryn", "Кобрин", "BY", "112", "", "01", "", "", "52.2138", "24.3564", "Europe/Minsk"),
("627202", "Klimavichy", "", "BY", "112", "", "06", "", "", "53.6079", "31.9586", "Europe/Minsk"),
("627205", "Klichaw", "", "BY", "112", "", "06", "", "", "53.4923", "29.3356", "Europe/Minsk"),
("627214", "Klyetsk", "", "BY", "112", "", "05", "", "", "53.0635", "26.6321", "Europe/Minsk"),
("627272", "Kirawsk", "", "BY", "112", "", "06", "", "", "53.2693", "29.4752", "Europe/Minsk"),
("627362", "Khoyniki", "", "BY", "112", "", "02", "", "", "51.8911", "29.9552", "Europe/Minsk"),
("627711", "Kamyanyets", "", "BY", "112", "", "01", "", "", "52.40013", "23.81", "Europe/Minsk"),
("627751", "Kalinkavichy", "Калинковичи", "BY", "112", "", "02", "", "", "52.1323", "29.3257", "Europe/Minsk"),
("627793", "Iwye", "", "BY", "112", "", "03", "", "", "53.9299", "25.7727", "Europe/Minsk"),
("627800", "Ivatsevichy", "Ивацевичи", "BY", "112", "", "01", "", "", "52.709", "25.3401", "Europe/Minsk"),
("627811", "Ivanava", "", "BY", "112", "", "01", "", "", "52.1451", "25.5365", "Europe/Minsk"),
("627904", "Hrodna", "Гродно", "BY", "112", "", "03", "", "", "53.6884", "23.8258", "Europe/Minsk"),
("627905", "Horki", "Горки", "BY", "112", "", "06", "", "", "54.2862", "30.9863", "Europe/Minsk"),
("627907", "Gomel", "Гомель", "BY", "112", "", "02", "", "", "52.4345", "30.9754", "Europe/Minsk"),
("627908", "Hlybokaye", "Глубокое", "BY", "112", "", "07", "", "", "55.1384", "27.6905", "Europe/Minsk"),
("628155", "Haradok", "", "BY", "112", "", "07", "", "", "55.4624", "29.9845", "Europe/Minsk"),
("628387", "Hlusk", "", "BY", "112", "", "06", "", "", "52.903", "28.6845", "Europe/Minsk"),
("628511", "Hatava", "", "BY", "112", "", "05", "", "", "53.7829", "27.6407", "Europe/Minsk"),
("628634", "Dzyarzhynsk", "Дзержинск", "BY", "112", "", "05", "", "", "53.6832", "27.138", "Europe/Minsk"),
("628658", "Dzyatlava", "", "BY", "112", "", "03", "", "", "53.4631", "25.4068", "Europe/Minsk"),
("628758", "Dubrowna", "", "BY", "112", "", "07", "", "", "54.5716", "30.691", "Europe/Minsk"),
("628884", "Drahichyn", "", "BY", "112", "", "01", "", "", "52.1874", "25.1597", "Europe/Minsk"),
("629002", "Dokshytsy", "", "BY", "112", "", "07", "", "", "54.8918", "27.7667", "Europe/Minsk"),
("629018", "Dobrush", "Добруш", "BY", "112", "", "02", "", "", "52.4089", "31.3237", "Europe/Minsk"),
("629159", "Davyd-Haradok", "", "BY", "112", "", "01", "", "", "52.0566", "27.2161", "Europe/Minsk"),
("629273", "Chervyen’", "", "BY", "112", "", "05", "", "", "53.7059", "28.4313", "Europe/Minsk"),
("629347", "Cherykaw", "", "BY", "112", "", "06", "", "", "53.5689", "31.3831", "Europe/Minsk"),
("629390", "Chachersk", "", "BY", "112", "", "02", "", "", "52.9164", "30.9179", "Europe/Minsk"),
("629395", "Chavusy", "", "BY", "112", "", "06", "", "", "53.8098", "30.9717", "Europe/Minsk"),
("629400", "Chashniki", "", "BY", "112", "", "07", "", "", "54.8584", "29.1608", "Europe/Minsk"),
("629447", "Bykhaw", "Быхов", "BY", "112", "", "06", "", "", "53.521", "30.2454", "Europe/Minsk"),
("629454", "Byaroza", "Берёза", "BY", "112", "", "01", "", "", "52.5314", "24.9786", "Europe/Minsk"),
("629634", "Brest", "Брест", "BY", "112", "", "01", "", "", "52.09755", "23.68775", "Europe/Minsk"),
("629640", "Braslaw", "", "BY", "112", "", "07", "", "", "55.6413", "27.0418", "Europe/Minsk"),
("629986", "Vyalikaya Byerastavitsa", "", "BY", "112", "", "03", "", "", "53.196", "24.0166", "Europe/Minsk"),
("630166", "Berëzovka", "", "BY", "112", "", "00", "", "", "53.72143", "25.49927", "Europe/Minsk"),
("630197", "Byerazino", "", "BY", "112", "", "05", "", "", "53.8391", "28.9879", "Europe/Minsk"),
("630245", "Byalynichy", "", "BY", "112", "", "06", "", "", "53.9994", "29.7141", "Europe/Minsk"),
("630279", "Byelaazyorsk", "", "BY", "112", "", "01", "", "", "52.4731", "25.1784", "Europe/Minsk"),
("630376", "Horad Barysaw", "Город Борисов", "BY", "112", "", "05", "", "", "54.2279", "28.505", "Europe/Minsk"),
("630429", "Baranovichi", "Барановичи", "BY", "112", "", "01", "", "", "53.1327", "26.0139", "Europe/Minsk"),
("630431", "Baran’", "", "BY", "112", "", "07", "", "", "54.4784", "30.3159", "Europe/Minsk"),
("630468", "Babruysk", "Бобруйск", "BY", "112", "", "06", "", "", "53.1384", "29.2214", "Europe/Minsk"),
("630515", "Ashmyany", "", "BY", "112", "", "03", "", "", "54.421", "25.936", "Europe/Minsk"),
("6846555", "Fanipol", "", "BY", "112", "", "", "", "", "53.74998", "27.33338", "Europe/Minsk"),
("8020004", "Druzhny", "", "BY", "112", "", "05", "", "", "53.6238", "27.8977", "Europe/Minsk"),
("8020218", "Malinovka", "Малиновка", "BY", "112", "", "04", "", "", "53.8579", "27.4374", "Europe/Minsk"),
("8247399", "Chyst’", "", "BY", "112", "", "05", "", "", "54.2698", "27.1067", "Europe/Minsk"),
("8247407", "Lyasny", "", "BY", "112", "", "05", "", "", "54.0072", "27.6963", "Europe/Minsk"),
("3581164", "San Pedro", "", "BZ", "84", "", "01", "", "", "17.91598", "-87.9659", "America/Belize"),
("3581194", "San Ignacio", "", "BZ", "84", "", "02", "", "", "17.1588", "-89.0696", "America/Belize"),
("3581398", "Punta Gorda", "", "BZ", "84", "", "06", "", "", "16.09835", "-88.8097", "America/Belize"),
("3581514", "Orange Walk", "", "BZ", "84", "", "04", "", "", "18.08124", "-88.56328", "America/Belize"),
("3582228", "Dangriga", "", "BZ", "84", "", "05", "9252696", "", "16.9697", "-88.23313", "America/Belize"),
("3582305", "Corozal", "", "BZ", "84", "", "03", "", "", "18.39375", "-88.38849", "America/Belize"),
("3582662", "Benque Viejo del Carmen", "", "BZ", "84", "", "02", "", "", "17.075", "-89.13917", "America/Belize"),
("3582672", "Belmopan", "Бельмопан", "BZ", "84", "", "02", "", "", "17.25", "-88.76667", "America/Belize"),
("3582677", "Belize City", "Белиз", "BZ", "84", "", "01", "", "", "17.49952", "-88.19756", "America/Belize"),
("5881791", "Abbotsford", "Абботсфорд", "CA", "124", "", "02", "5957659", "", "49.05798", "-122.25257", "America/Vancouver"),
("5882142", "Acton Vale", "", "CA", "124", "", "10", "16", "48028", "45.65007", "-72.56582", "America/Toronto"),
("5882799", "Airdrie", "", "CA", "124", "", "01", "", "", "51.30011", "-114.03528", "America/Edmonton"),
("5882873", "Ajax", "Эйджакс", "CA", "124", "", "08", "", "", "43.85012", "-79.03288", "America/Toronto"),
("5884083", "Alma", "Алма", "CA", "124", "", "10", "02", "93042", "48.55009", "-71.6491", "America/Toronto"),
("5884467", "Amherst", "", "CA", "124", "", "07", "", "", "45.83345", "-64.19874", "America/Halifax"),
("5884473", "Amherstburg", "", "CA", "124", "", "08", "", "", "42.11679", "-83.04985", "America/Toronto"),
("5884588", "Amos", "", "CA", "124", "", "10", "08", "88055", "48.56688", "-78.11624", "America/Toronto"),
("5885280", "Angus", "", "CA", "124", "", "08", "", "", "44.31681", "-79.88295", "America/Toronto"),
("5885383", "Anmore", "", "CA", "124", "", "02", "5915", "", "49.31637", "-122.85263", "America/Vancouver"),
("5886182", "Antigonish", "", "CA", "124", "", "07", "", "", "45.61685", "-61.99858", "America/Halifax"),
("5887214", "Arnprior", "", "CA", "124", "", "08", "", "", "45.43341", "-76.34939", "America/Toronto"),
("5887470", "Asbestos", "", "CA", "124", "", "10", "05", "40043", "45.76678", "-71.9324", "America/Toronto"),
("5888716", "Aylmer", "", "CA", "124", "", "08", "", "", "42.76679", "-80.98302", "America/Toronto"),
("5889745", "Baie-Comeau", "", "CA", "124", "", "10", "09", "96020", "49.21679", "-68.14894", "America/Toronto"),
("5892532", "Banff", "", "CA", "124", "", "01", "", "", "51.17622", "-115.56982", "America/Edmonton"),
("5894171", "Barrie", "Барри", "CA", "124", "", "08", "", "", "44.40011", "-79.66634", "America/Toronto"),
("5895424", "Bay Roberts", "", "CA", "124", "", "05", "", "", "47.59989", "-53.26478", "America/St_Johns"),
("5895650", "Beaconsfield", "", "CA", "124", "", "10", "06", "66107", "45.43341", "-73.86586", "America/Toronto"),
("5896495", "Beauharnois", "", "CA", "124", "", "10", "16", "70022", "45.31341", "-73.8725", "America/Toronto"),
("5896522", "Beaumont", "", "CA", "124", "", "01", "", "", "53.35013", "-113.41871", "America/Edmonton"),
("5897209", "Bécancour", "", "CA", "124", "", "10", "17", "38010", "46.33336", "-72.43241", "America/Toronto"),
("5897884", "Belleville", "Бельвиль", "CA", "124", "", "08", "5971841", "", "44.16682", "-77.38277", "America/Toronto"),
("5898070", "Bells Corners", "", "CA", "124", "", "08", "", "", "45.31588", "-75.83012", "America/Toronto"),
("5898138", "Beloeil", "", "CA", "124", "", "10", "16", "57040", "45.56839", "-73.20568", "America/Toronto"),
("5903510", "Blainville", "", "CA", "124", "", "10", "15", "", "45.66678", "-73.88249", "America/Toronto"),
("5904501", "Bluewater", "", "CA", "124", "", "08", "", "", "43.46679", "-81.59977", "America/Toronto"),
("5905132", "Boisbriand", "", "CA", "124", "", "10", "15", "73005", "45.61678", "-73.83249", "America/Toronto"),
("5905152", "Bois-des-Filion", "", "CA", "124", "", "10", "13", "65005", "45.66678", "-73.74918", "America/Toronto"),
("5905616", "Bonnyville", "", "CA", "124", "", "01", "", "", "54.26684", "-110.73505", "America/Edmonton"),
("5906267", "Boucherville", "Бушервиль", "CA", "124", "", "10", "16", "58033", "45.59104", "-73.43605", "America/Toronto"),
("5907092", "Bracebridge", "", "CA", "124", "", "08", "", "", "45.03341", "-79.31633", "America/Toronto"),
("5907364", "Brampton", "Брамптон", "CA", "124", "", "08", "", "", "43.68341", "-79.76633", "America/Toronto"),
("5907896", "Brandon", "Брэндон", "CA", "124", "", "03", "", "", "49.84692", "-99.95306", "America/Winnipeg"),
("5907983", "Brant", "", "CA", "124", "", "08", "", "", "43.1334", "-80.34967", "America/Toronto"),
("5907990", "Brantford", "Брантфорд", "CA", "124", "", "08", "", "", "43.1334", "-80.26636", "America/Toronto"),
("5908723", "Bridgewater", "", "CA", "124", "", "07", "", "", "44.37856", "-64.51882", "America/Halifax"),
("5909294", "Brockville", "Броквилл", "CA", "124", "", "08", "", "", "44.59132", "-75.68705", "America/Toronto"),
("5909403", "Bromont", "", "CA", "124", "", "10", "16", "46078", "45.31678", "-72.64912", "America/Toronto"),
("5909514", "Brooks", "", "CA", "124", "", "01", "", "", "50.58341", "-111.88509", "America/Edmonton"),
("5909629", "Brossard", "", "CA", "124", "", "10", "16", "58007", "45.45008", "-73.46583", "America/Toronto"),
("5909969", "Brownsburg-Chatham", "", "CA", "124", "", "10", "15", "76043", "45.68342", "-74.4159", "America/Toronto"),
("5911592", "Burlington", "Берлингтон", "CA", "124", "", "08", "", "", "43.38621", "-79.83713", "America/Toronto"),
("5911606", "Burnaby", "Бернаби", "CA", "124", "", "02", "", "", "49.26636", "-122.95263", "America/Vancouver"),
("5913490", "Calgary", "Калгари", "CA", "124", "", "01", "", "", "51.05011", "-114.08529", "America/Edmonton"),
("5913695", "Cambridge", "Кеймбридж", "CA", "124", "", "08", "", "", "43.3601", "-80.31269", "America/Toronto"),
("5913934", "Camlachie", "", "CA", "124", "", "08", "", "", "43.03596", "-82.1616", "America/Toronto"),
("5914132", "Campbell River", "Кэмпбелл-Ривер", "CA", "124", "", "02", "", "", "50.01634", "-125.24459", "America/Vancouver"),
("5914653", "Camrose", "", "CA", "124", "", "01", "", "", "53.01684", "-112.83525", "America/Edmonton"),
("5914826", "Candiac", "", "CA", "124", "", "10", "16", "67020", "45.38338", "-73.51587", "America/Toronto"),
("5914894", "Canmore", "", "CA", "124", "", "01", "", "", "51.08335", "-115.35206", "America/Edmonton"),
("5916722", "Carbonear", "", "CA", "124", "", "05", "", "", "47.73319", "-53.21478", "America/St_Johns"),
("5917117", "Carignan", "", "CA", "124", "", "10", "16", "", "45.45008", "-73.29916", "America/Toronto"),
("5917158", "Carleton Place", "", "CA", "124", "", "08", "", "", "45.13341", "-76.14938", "America/Toronto"),
("5918118", "Castlegar", "", "CA", "124", "", "02", "", "", "49.29984", "-117.66894", "America/Vancouver"),
("5919566", "Chambly", "Шамбли", "CA", "124", "", "10", "16", "", "45.45008", "-73.28246", "America/Toronto"),
("5920089", "Charlemagne", "", "CA", "124", "", "10", "14", "", "45.71678", "-73.48247", "America/Toronto"),
("5920288", "Charlottetown", "Шарлоттаун", "CA", "124", "", "09", "1102", "", "46.23899", "-63.13414", "America/Halifax"),
("5920433", "Châteauguay", "", "CA", "124", "", "10", "16", "", "45.38338", "-73.74919", "America/Toronto"),
("5921147", "Chibougamau", "", "CA", "124", "", "10", "10", "", "49.91684", "-74.36586", "America/Toronto"),
("5921356", "Chilliwack", "", "CA", "124", "", "02", "5909", "", "49.16638", "-121.95257", "America/Vancouver"),
("5923101", "Clarence-Rockland", "", "CA", "124", "", "08", "", "", "45.5501", "-75.29101", "America/Toronto"),
("5924417", "Coaldale", "", "CA", "124", "", "01", "", "", "49.7167", "-112.61854", "America/Edmonton"),
("5924500", "Coaticook", "", "CA", "124", "", "10", "05", "44037", "45.13339", "-71.79907", "America/Toronto"),
("5924579", "Cobourg", "", "CA", "124", "", "08", "", "", "43.95977", "-78.16515", "America/Toronto"),
("5924618", "Cochrane", "", "CA", "124", "", "01", "", "", "51.18341", "-114.46871", "America/Edmonton"),
("5925024", "Cold Lake", "", "CA", "124", "", "01", "", "", "54.46525", "-110.18154", "America/Edmonton"),
("5925975", "Collingwood", "", "CA", "124", "", "08", "", "", "44.4834", "-80.21638", "America/Toronto"),
("5926268", "Colwood", "", "CA", "124", "", "02", "", "", "48.43293", "-123.48591", "America/Vancouver"),
("5926511", "Conception Bay South", "", "CA", "124", "", "05", "", "", "47.49989", "-52.99806", "America/St_Johns"),
("5926526", "Concord", "", "CA", "124", "", "08", "", "", "43.80011", "-79.48291", "America/Toronto"),
("5927689", "Coquitlam", "", "CA", "124", "", "02", "", "", "49.28297", "-122.75262", "America/Vancouver"),
("5927969", "Corner Brook", "Корнер-Брук", "CA", "124", "", "05", "", "", "48.95001", "-57.95202", "America/St_Johns"),
("5928065", "Cornwall", "", "CA", "124", "", "08", "", "", "45.01809", "-74.72815", "America/Toronto"),
("5928488", "Côte-Saint-Luc", "", "CA", "124", "", "10", "06", "66058", "45.46536", "-73.66585", "America/Toronto"),
("5930890", "Courtenay", "Куртенэ", "CA", "124", "", "02", "", "", "49.68657", "-124.9936", "America/Vancouver"),
("5931074", "Cowansville", "", "CA", "124", "", "10", "16", "46080", "45.20008", "-72.74913", "America/Toronto"),
("5931800", "Cranbrook", "Кранбрук", "CA", "124", "", "02", "", "", "49.49991", "-115.76879", "America/Edmonton"),
("5935277", "Dartmouth", "", "CA", "124", "", "07", "", "", "44.67134", "-63.57719", "America/Halifax"),
("5935341", "Dauphin", "", "CA", "124", "", "03", "", "", "51.14941", "-100.05023", "America/Winnipeg"),
("5935804", "Dawson Creek", "", "CA", "124", "", "02", "5955", "", "55.75984", "-120.2403", "America/Dawson_Creek"),
("5937612", "Delson", "", "CA", "124", "", "10", "16", "67025", "45.36678", "-73.54917", "America/Toronto"),
("5937615", "Delta", "Дельта", "CA", "124", "", "02", "", "", "49.14399", "-122.9068", "America/Vancouver"),
("5938513", "Deux-Montagnes", "", "CA", "124", "", "10", "15", "72010", "45.53455", "-73.90168", "America/Toronto"),
("5938801", "Devon", "", "CA", "124", "", "01", "", "", "53.36683", "-113.73533", "America/Edmonton"),
("5939219", "Dieppe", "Дьеп", "CA", "124", "", "04", "", "", "46.07844", "-64.68735", "America/Moncton"),
("5940934", "Dolbeau-Mistassini", "", "CA", "124", "", "10", "02", "92022", "48.8786", "-72.23142", "America/Toronto"),
("5940956", "Dollard-Des Ormeaux", "", "CA", "124", "", "10", "", "", "45.49452", "-73.82419", "America/Toronto"),
("5941761", "Dorchester", "", "CA", "124", "", "08", "", "", "42.98339", "-81.06643", "America/Toronto"),
("5941925", "Dorval", "Дорваль", "CA", "124", "", "10", "06", "66087", "45.4473", "-73.75335", "America/Toronto"),
("5942547", "Drayton Valley", "", "CA", "124", "", "01", "", "", "53.21682", "-114.98544", "America/Edmonton"),
("5942845", "Drummondville", "Драммондвилл", "CA", "124", "", "10", "17", "49058", "45.88336", "-72.48241", "America/Toronto"),
("5942913", "Dryden", "", "CA", "124", "", "08", "", "", "49.78334", "-92.75032", "America/Winnipeg"),
("5943865", "Duncan", "Дункан", "CA", "124", "", "02", "", "", "48.78293", "-123.70266", "America/Vancouver"),
("5946768", "Edmonton", "Эдмонтон", "CA", "124", "", "01", "", "", "53.55014", "-113.46871", "America/Edmonton"),
("5946820", "Edson", "", "CA", "124", "", "01", "", "", "53.58345", "-116.43559", "America/Edmonton"),
("5947866", "Elliot Lake", "", "CA", "124", "", "08", "", "", "46.38336", "-82.63315", "America/Toronto"),
("5949568", "Estevan", "", "CA", "124", "", "11", "", "", "49.13337", "-102.98422", "America/Regina"),
("5950267", "Etobicoke", "Этобико", "CA", "124", "", "08", "", "", "43.65421", "-79.56711", "America/Toronto"),
("5951644", "Farnham", "", "CA", "124", "", "10", "16", "46112", "45.28338", "-72.98244", "America/Toronto"),
("5952370", "Fernie", "", "CA", "124", "", "02", "", "", "49.49996", "-115.06871", "America/Edmonton"),
("5954718", "Flin Flon", "", "CA", "124", "", "03", "", "", "54.76703", "-101.87433", "America/Winnipeg"),
("5955815", "Fort Erie", "", "CA", "124", "", "08", "", "", "42.90012", "-78.93286", "America/Toronto"),
("5955826", "Fort Frances", "", "CA", "124", "", "08", "", "", "48.59988", "-93.4003", "America/Winnipeg"),
("5955895", "Fort McMurray", "", "CA", "124", "", "01", "", "", "56.72676", "-111.38103", "America/Edmonton"),
("5955948", "Fort Saskatchewan", "", "CA", "124", "", "01", "", "", "53.71684", "-113.2187", "America/Edmonton"),
("5955960", "Fort St. John", "Форт-Сент-Джон", "CA", "124", "", "02", "", "", "56.24988", "-120.85292", "America/Dawson_Creek"),
("5957776", "Fredericton", "Фредериктон", "CA", "124", "", "04", "", "", "45.94541", "-66.66558", "America/Moncton"),
("5959326", "Gananoque", "", "CA", "124", "", "08", "", "", "44.33342", "-76.16607", "America/Toronto"),
("5959878", "Gaspé", "", "CA", "124", "", "10", "11", "03005", "48.83341", "-64.48194", "America/Toronto"),
("5959974", "Gatineau", "Гатино", "CA", "124", "", "10", "07", "81017", "45.47723", "-75.70164", "America/Toronto"),
("5960971", "Gibsons", "", "CA", "124", "", "02", "5929", "", "49.39539", "-123.50555", "America/Vancouver"),
("5961564", "Glace Bay", "", "CA", "124", "", "07", "", "", "46.19695", "-59.95698", "America/Glace_Bay"),
("5962442", "Goderich", "", "CA", "124", "", "08", "5978829", "", "43.74171", "-81.71339", "America/Toronto"),
("5964215", "Granby", "Гранби", "CA", "124", "", "10", "16", "47017", "45.40008", "-72.73243", "America/Toronto"),
("5964347", "Grande Prairie", "Гранд-Прери", "CA", "124", "", "01", "", "", "55.16667", "-118.80271", "America/Edmonton"),
("5964378", "Grand Falls-Windsor", "", "CA", "124", "", "05", "", "", "48.93324", "-55.66492", "America/St_Johns"),
("5964700", "Greater Sudbury", "Большой Садбери", "CA", "124", "", "08", "", "", "46.49", "-80.99001", "America/Toronto"),
("5965546", "Gravenhurst", "", "CA", "124", "", "08", "", "", "44.91681", "-79.36633", "America/Toronto"),
("5965812", "Greater Napanee", "", "CA", "124", "", "08", "", "", "44.25012", "-76.94944", "America/Toronto"),
("5966689", "Greenwood", "", "CA", "124", "", "07", "", "", "44.97413", "-64.93169", "America/Halifax"),
("5967629", "Guelph", "Гелф", "CA", "124", "", "08", "6177913", "", "43.54594", "-80.25599", "America/Toronto"),
("5969782", "Hamilton", "Гамильтон", "CA", "124", "", "08", "", "", "43.25011", "-79.84963", "America/Toronto"),
("5970014", "Hampstead", "", "CA", "124", "", "10", "06", "66058", "45.48064", "-73.66307", "America/Toronto"),
("5970063", "Hanceville", "", "CA", "124", "", "02", "", "", "51.91922", "-123.04458", "America/Vancouver"),
("5970301", "Hanover", "", "CA", "124", "", "08", "", "", "44.15009", "-81.03303", "America/Toronto"),
("5970458", "Happy Valley-Goose Bay", "", "CA", "124", "", "05", "", "", "53.3038", "-60.32576", "America/Goose_Bay"),
("5972360", "Hawkesbury", "", "CA", "124", "", "08", "", "", "45.60009", "-74.61595", "America/Toronto"),
("5975038", "High River", "", "CA", "124", "", "01", "", "", "50.58341", "-113.86867", "America/Edmonton"),
("5975503", "Hinton", "", "CA", "124", "", "01", "", "", "53.40009", "-117.58567", "America/Edmonton"),
("5978126", "Hudson", "", "CA", "124", "", "10", "16", "71100", "45.45008", "-74.14922", "America/Toronto"),
("5978765", "Huntsville", "Хантсвилл", "CA", "124", "", "08", "", "", "45.33341", "-79.21632", "America/Toronto"),
("5978831", "Huron East", "", "CA", "124", "", "08", "", "", "43.61679", "-81.29975", "America/Toronto"),
("5983175", "Ingersoll", "", "CA", "124", "", "08", "", "", "43.03339", "-80.88302", "America/Toronto"),
("5983433", "Innisfil", "", "CA", "124", "", "08", "", "", "44.30011", "-79.64964", "America/Toronto"),
("5983720", "Iqaluit", "", "CA", "124", "", "14", "", "", "63.74697", "-68.51727", "America/Iqaluit"),
("5987650", "Joliette", "", "CA", "124", "", "10", "14", "61020", "46.0164", "-73.4236", "America/Toronto"),
("5989045", "Kamloops", "Камлупс", "CA", "124", "", "02", "", "", "50.66648", "-120.3192", "America/Vancouver"),
("5989403", "Kapuskasing", "", "CA", "124", "", "08", "5924616", "", "49.41694", "-82.43308", "America/Toronto"),
("5990579", "Kelowna", "Келоуна", "CA", "124", "", "02", "", "", "49.88307", "-119.48568", "America/Vancouver"),
("5991148", "Kentville", "", "CA", "124", "", "07", "1207", "", "45.0771", "-64.49605", "America/Halifax"),
("5991370", "Keswick", "", "CA", "124", "", "08", "", "", "44.25011", "-79.46632", "America/Toronto"),
("5992059", "Kimberley", "", "CA", "124", "", "02", "5901", "", "49.67071", "-115.9776", "America/Edmonton"),
("5992144", "Kincardine", "", "CA", "124", "", "08", "", "", "44.18339", "-81.63307", "America/Toronto"),
("5992500", "Kingston", "Кингстон", "CA", "124", "", "08", "", "", "44.22976", "-76.48098", "America/Toronto"),
("5992830", "Kirkland", "", "CA", "124", "", "10", "06", "66102", "45.45008", "-73.86586", "America/Toronto"),
("5992836", "Kirkland Lake", "", "CA", "124", "", "08", "", "", "48.14461", "-80.03767", "America/Toronto"),
("5992996", "Kitchener", "Китченер", "CA", "124", "", "08", "", "", "43.42537", "-80.5112", "America/Toronto"),
("5993072", "Kitimat", "", "CA", "124", "", "02", "", "", "54.05244", "-128.65342", "America/Vancouver"),
("5994839", "Labrador City", "", "CA", "124", "", "05", "", "", "52.94626", "-66.91137", "America/Goose_Bay"),
("6002133", "Lac-Brome", "", "CA", "124", "", "10", "16", "46075", "45.21678", "-72.51581", "America/Toronto"),
("6024829", "Lachute", "", "CA", "124", "", "10", "15", "76020", "45.65008", "-74.33253", "America/Toronto"),
("6035615", "Lacombe", "", "CA", "124", "", "01", "", "", "52.46681", "-113.7353", "America/Edmonton"),
("6047817", "Ladysmith", "", "CA", "124", "", "02", "5919", "", "48.99016", "-123.81699", "America/Vancouver"),
("6049024", "Lambton Shores", "", "CA", "124", "", "08", "", "", "43.16678", "-81.93309", "America/Toronto"),
("6049388", "Langford", "", "CA", "124", "", "02", "", "", "48.44963", "-123.50261", "America/Vancouver"),
("6049429", "Langley", "", "CA", "124", "", "02", "", "", "49.10107", "-122.65883", "America/Vancouver"),
("6049430", "Langley", "", "CA", "124", "", "02", "", "", "49.08297", "-122.58589", "America/Vancouver"),
("6049863", "La Prairie", "", "CA", "124", "", "10", "16", "67015", "45.41678", "-73.49917", "America/Toronto"),
("6050194", "La Sarre", "", "CA", "124", "", "10", "08", "87090", "48.80019", "-79.19964", "America/Toronto"),
("6050263", "L'Assomption", "", "CA", "124", "", "10", "14", "60028", "45.82318", "-73.4294", "America/Toronto"),
("6050416", "La Tuque", "", "CA", "124", "", "10", "04", "90012", "47.43337", "-72.7824", "America/Toronto"),
("6050610", "Laval", "Лаваль", "CA", "124", "", "10", "13", "65005", "45.56995", "-73.692", "America/Toronto"),
("6050650", "Lavaltrie", "", "CA", "124", "", "10", "14", "", "45.88338", "-73.28245", "America/Toronto"),
("6051562", "Leduc", "", "CA", "124", "", "01", "", "", "53.26682", "-113.55201", "America/Edmonton"),
("6052788", "Les Coteaux", "", "CA", "124", "", "10", "16", "71033", "45.28338", "-74.23254", "America/Toronto"),
("6053154", "Lethbridge", "Летбридж", "CA", "124", "", "01", "", "", "49.69999", "-112.81856", "America/Edmonton"),
("6053877", "L'Île-Perrot", "", "CA", "124", "", "10", "16", "71060", "45.38338", "-73.9492", "America/Toronto"),
("6058024", "Lloydminster", "Ллойдминстер", "CA", "124", "", "11", "", "", "53.28346", "-110.00157", "America/Edmonton"),
("6058560", "London", "Лондон", "CA", "124", "", "08", "", "", "42.98339", "-81.23304", "America/Toronto"),
("6059891", "Longueuil", "Лонгёй", "CA", "124", "", "10", "16", "58227", "45.53121", "-73.51806", "America/Toronto"),
("6060407", "Lorraine", "", "CA", "124", "", "10", "14", "64008", "45.68338", "-73.78249", "America/Toronto"),
("6060839", "Louiseville", "", "CA", "124", "", "10", "04", "51015", "46.25594", "-72.94145", "America/Toronto"),
("6062163", "Lutes Mountain", "", "CA", "124", "", "04", "", "", "46.13544", "-64.90504", "America/Moncton"),
("6064180", "Magog", "Мейгог", "CA", "124", "", "10", "05", "45072", "45.26678", "-72.14909", "America/Toronto"),
("6065686", "Maple Ridge", "Мэпл-Ридж", "CA", "124", "", "02", "", "", "49.21939", "-122.60193", "America/Vancouver"),
("6066350", "Marieville", "", "CA", "124", "", "10", "16", "55048", "45.43338", "-73.16585", "America/Toronto"),
("6066513", "Markham", "Маркем", "CA", "124", "", "08", "", "", "43.86682", "-79.2663", "America/Toronto"),
("6067494", "Mascouche", "", "CA", "124", "", "10", "14", "64015", "45.74965", "-73.59956", "America/Toronto"),
("6071618", "Medicine Hat", "Медисин-Хат", "CA", "124", "", "01", "", "", "50.03928", "-110.67661", "America/Edmonton"),
("6071876", "Melfort", "", "CA", "124", "", "11", "", "", "52.86673", "-104.61768", "America/Regina"),
("6072206", "Mercier", "", "CA", "124", "", "10", "16", "67045", "45.31678", "-73.74919", "America/Toronto"),
("6072350", "Merritt", "", "CA", "124", "", "02", "", "", "50.11225", "-120.7942", "America/Vancouver"),
("6073363", "Midland", "", "CA", "124", "", "08", "", "", "44.7501", "-79.88296", "America/Toronto"),
("6074377", "Milton", "Милтон", "CA", "124", "", "08", "5969719", "", "43.51681", "-79.88294", "America/Toronto"),
("6075061", "Mirabel", "Мирабель", "CA", "124", "", "10", "15", "74005", "45.65008", "-74.08251", "America/Toronto"),
("6075081", "Miramichi", "Мирамиши", "CA", "124", "", "04", "1309", "", "47.02895", "-65.50186", "America/Moncton"),
("6075357", "Mississauga", "Миссиссога", "CA", "124", "", "08", "", "", "43.5789", "-79.6583", "America/Toronto"),
("6076211", "Moncton", "Монктон", "CA", "124", "", "04", "1307", "", "46.09454", "-64.7965", "America/Moncton"),
("6077128", "Mont-Laurier", "", "CA", "124", "", "10", "15", "79088", "46.55011", "-75.4993", "America/Toronto"),
("6077243", "Montréal", "Монреаль", "CA", "124", "", "10", "06", "", "45.50884", "-73.58781", "America/Toronto"),
("6077265", "Montréal-Ouest", "", "CA", "124", "", "10", "", "", "45.45286", "-73.64918", "America/Toronto"),
("6077315", "Mont-Royal", "", "CA", "124", "", "10", "06", "66072", "45.51675", "-73.64918", "America/Toronto"),
("6077340", "Mont-Saint-Hilaire", "", "CA", "124", "", "10", "16", "57035", "45.56515", "-73.1868", "America/Toronto"),
("6077445", "Mont-Tremblant", "", "CA", "124", "", "10", "15", "", "46.21274", "-74.58438", "America/Toronto"),
("6078112", "Moose Jaw", "Мус-Джо", "CA", "124", "", "11", "", "", "50.40005", "-105.53445", "America/Regina"),
("6078447", "Morden", "", "CA", "124", "", "03", "", "", "49.1919", "-98.10136", "America/Winnipeg"),
("6078636", "Morinville", "", "CA", "124", "", "01", "", "", "53.80014", "-113.65203", "America/Edmonton"),
("6082231", "Mount Pearl", "", "CA", "124", "", "05", "", "", "47.51659", "-52.78135", "America/St_Johns"),
("6085772", "Nanaimo", "Нанаймо", "CA", "124", "", "02", "", "", "49.16638", "-123.94003", "America/Vancouver"),
("6086871", "Nelson", "", "CA", "124", "", "02", "", "", "49.49985", "-117.28553", "America/Vancouver"),
("6087579", "New Glasgow", "", "CA", "124", "", "07", "", "", "45.58344", "-62.64863", "America/Halifax"),
("6087701", "Newmarket", "Ньюмаркет", "CA", "124", "", "08", "", "", "44.05011", "-79.46631", "America/Toronto"),
("6087844", "New Westminster", "Нью-Уэстминстер", "CA", "124", "", "02", "", "", "49.20678", "-122.91092", "America/Vancouver"),
("6087892", "Niagara Falls", "Ниагара-Фолс", "CA", "124", "", "08", "", "", "43.10012", "-79.06627", "America/Toronto"),
("6088132", "Nicolet", "", "CA", "124", "", "10", "17", "50072", "46.21676", "-72.61582", "America/Toronto"),
("6089125", "Norfolk County", "", "CA", "124", "", "08", "", "", "42.8334", "-80.38297", "America/Toronto"),
("6089404", "North Battleford", "", "CA", "124", "", "11", "", "", "52.77972", "-108.2967", "America/Regina"),
("6089426", "North Bay", "Норт-Бей", "CA", "124", "", "08", "6088501", "", "46.3168", "-79.46633", "America/Toronto"),
("6089661", "North Cowichan", "", "CA", "124", "", "02", "", "", "48.84133", "-123.68596", "America/Vancouver"),
("6090405", "North Perth", "", "CA", "124", "", "08", "", "", "43.7251", "-80.96723", "America/Toronto"),
("6090579", "North Saanich", "", "CA", "124", "", "02", "", "", "48.66634", "-123.41933", "America/Vancouver"),
("6090785", "North Vancouver", "", "CA", "124", "", "02", "5909", "", "49.31636", "-123.06934", "America/Vancouver"),
("6091104", "North York", "Норт-Йорк", "CA", "124", "", "08", "", "", "43.76681", "-79.4163", "America/Toronto"),
("6091369", "Notre-Dame-de-l'Île-Perrot", "", "CA", "124", "", "10", "16", "71065", "45.36678", "-73.9325", "America/Toronto"),
("6091422", "Notre-Dame-des-Prairies", "", "CA", "124", "", "10", "14", "61030", "46.05007", "-73.43245", "America/Toronto"),
("6091919", "Oak Bay", "", "CA", "124", "", "02", "", "", "48.44964", "-123.3026", "America/Vancouver"),
("6092122", "Oakville", "Оквилл", "CA", "124", "", "08", "", "", "43.45011", "-79.68292", "America/Toronto"),
("6093010", "Okotoks", "", "CA", "124", "", "01", "", "", "50.72885", "-113.98281", "America/Edmonton"),
("6093347", "Olds", "", "CA", "124", "", "01", "", "", "51.78341", "-114.10199", "America/Edmonton"),
("6094201", "Orangeville", "", "CA", "124", "", "08", "", "", "43.9168", "-80.09967", "America/Toronto"),
("6094325", "Orillia", "Ориллия", "CA", "124", "", "08", "", "", "44.60868", "-79.42068", "America/Toronto"),
("6094407", "Oromocto", "", "CA", "124", "", "04", "", "", "45.83512", "-66.47917", "America/Moncton"),
("6094578", "Oshawa", "Ошава", "CA", "124", "", "08", "", "", "43.90012", "-78.84957", "America/Toronto"),
("6094817", "Ottawa", "Оттава", "CA", "124", "", "08", "", "", "45.41117", "-75.69812", "America/Toronto"),
("6094884", "Otterburn Park", "", "CA", "124", "", "10", "16", "57030", "45.53338", "-73.21585", "America/Toronto"),
("6095645", "Owen Sound", "Оуэн-Саунд", "CA", "124", "", "08", "", "", "44.56717", "-80.94349", "America/Toronto"),
("6098642", "Parksville", "", "CA", "124", "", "02", "5921", "", "49.31947", "-124.31575", "America/Vancouver"),
("6098747", "Parry Sound", "", "CA", "124", "", "08", "6098746", "", "45.34732", "-80.03527", "America/Toronto"),
("6100069", "Peace River", "", "CA", "124", "", "01", "", "", "56.23715", "-117.29176", "America/Edmonton"),
("6100832", "Pembroke", "", "CA", "124", "", "08", "", "", "45.81681", "-77.11616", "America/Toronto"),
("6101141", "Penticton", "", "CA", "124", "", "02", "", "", "49.48062", "-119.58584", "America/Vancouver"),
("6101546", "Perth", "", "CA", "124", "", "08", "", "", "44.90011", "-76.24939", "America/Toronto"),
("6101606", "Petawawa", "", "CA", "124", "", "08", "", "", "45.89452", "-77.28007", "America/Toronto"),
("6101645", "Peterborough", "Питерборо", "CA", "124", "", "08", "", "", "44.30012", "-78.31623", "America/Toronto"),
("6103581", "Petrolia", "", "CA", "124", "", "08", "", "", "42.86678", "-82.14981", "America/Toronto"),
("6104111", "Pickering", "Пикеринг", "CA", "124", "", "08", "", "", "43.90012", "-79.13289", "America/Toronto"),
("6104876", "Pincourt", "", "CA", "124", "", "10", "16", "71070", "45.38338", "-73.9825", "America/Toronto"),
("6105815", "Pitt Meadows", "Питт-Медоус", "CA", "124", "", "02", "", "", "49.22119", "-122.68965", "America/Vancouver"),
("6107272", "Pointe-Calumet", "", "CA", "124", "", "10", "15", "72020", "45.50008", "-73.9659", "America/Toronto"),
("6107325", "Pointe-Claire", "", "CA", "124", "", "10", "06", "", "45.44868", "-73.81669", "America/Toronto"),
("6109273", "Ponoka", "", "CA", "124", "", "01", "", "", "52.6768", "-113.58147", "America/Edmonton"),
("6110611", "Pont Rouge", "", "CA", "124", "", "10", "02", "92015", "48.88332", "-72.08247", "America/Toronto"),
("6111529", "Portage la Prairie", "", "CA", "124", "", "03", "", "", "49.97282", "-98.29263", "America/Winnipeg"),
("6111632", "Port Alberni", "", "CA", "124", "", "02", "", "", "49.24133", "-124.8028", "America/Vancouver"),
("6111696", "Port-Cartier", "", "CA", "124", "", "10", "09", "97022", "50.03339", "-66.86545", "America/Toronto"),
("6111704", "Port Colborne", "", "CA", "124", "", "08", "", "", "42.90012", "-79.23288", "America/Toronto"),
("6111962", "Port Moody", "", "CA", "124", "", "02", "", "", "49.28297", "-122.85263", "America/Vancouver"),
("6112608", "Powell River", "", "CA", "124", "", "02", "5927", "", "49.83278", "-124.52368", "America/Vancouver"),
("6113198", "Prévost", "", "CA", "124", "", "10", "15", "75040", "45.86678", "-74.08251", "America/Toronto"),
("6113335", "Prince Albert", "Принс-Альберт", "CA", "124", "", "11", "", "", "53.20008", "-105.76772", "America/Regina"),
("6113355", "Prince Edward", "", "CA", "124", "", "08", "", "", "44.00012", "-77.24946", "America/Toronto"),
("6113365", "Prince George", "Принс-Джордж", "CA", "124", "", "02", "", "", "53.9166", "-122.75301", "America/Vancouver"),
("6113406", "Prince Rupert", "", "CA", "124", "", "02", "5947", "", "54.31507", "-130.32098", "America/Vancouver"),
("6113466", "Princeville", "", "CA", "124", "", "07", "", "", "45.76684", "-61.29853", "America/Halifax"),
("6115187", "Quesnel", "", "CA", "124", "", "02", "", "", "52.97842", "-122.4931", "America/Vancouver"),
("6115355", "Quinte West", "", "CA", "124", "", "08", "", "", "44.18342", "-77.56618", "America/Toronto"),
("6117611", "Rawdon", "", "CA", "124", "", "10", "14", "", "46.05007", "-73.71587", "America/Toronto"),
("6117731", "Rayside-Balfour", "", "CA", "124", "", "08", "", "", "46.60873", "-81.20763", "America/Toronto"),
("6118158", "Red Deer", "Ред-Дир", "CA", "124", "", "01", "", "", "52.26682", "-113.802", "America/Edmonton"),
("6119109", "Regina", "Реджайна", "CA", "124", "", "11", "", "", "50.45008", "-104.6178", "America/Regina"),
("6119448", "Renfrew", "", "CA", "124", "", "08", "", "", "45.46681", "-76.68272", "America/Toronto"),
("6119518", "Repentigny", "Репантиньи", "CA", "124", "", "10", "14", "", "45.74222", "-73.45008", "America/Toronto"),
("6121621", "Revelstoke", "", "CA", "124", "", "02", "5939", "", "50.99712", "-118.1953", "America/Vancouver"),
("6122037", "Richelieu", "", "CA", "124", "", "10", "16", "", "45.44336", "-73.24602", "America/Toronto"),
("6122085", "Richmond", "Ричмонд", "CA", "124", "", "02", "", "", "49.17003", "-123.13683", "America/Vancouver"),
("6122091", "Richmond Hill", "", "CA", "124", "", "08", "6185560", "", "43.87111", "-79.43725", "America/Toronto"),
("6125653", "Roberval", "", "CA", "124", "", "10", "02", "91025", "48.5168", "-72.23244", "America/Toronto"),
("6126305", "Rock Forest", "", "CA", "124", "", "10", "05", "43027", "45.35699", "-71.99676", "America/Toronto"),
("6126749", "Rocky Mountain House", "", "CA", "124", "", "01", "", "", "52.36683", "-114.9188", "America/Edmonton"),
("6127681", "Rosemère", "", "CA", "124", "", "10", "15", "", "45.63338", "-73.79919", "America/Toronto"),
("6128577", "Rouyn-Noranda", "Руэн-Норанда", "CA", "124", "", "10", "08", "86042", "48.23656", "-79.02311", "America/Toronto"),
("6137063", "Sackville", "", "CA", "124", "", "04", "", "", "45.91875", "-64.38455", "America/Moncton"),
("6137270", "Saguenay", "Сагеней", "CA", "124", "", "10", "02", "94068", "48.41675", "-71.06573", "America/Toronto"),
("6137489", "Saint-Basile-le-Grand", "", "CA", "124", "", "10", "16", "57020", "45.53338", "-73.28246", "America/Toronto"),
("6137540", "Saint-Bruno-de-Montarville", "", "CA", "124", "", "10", "", "", "45.53341", "-73.34916", "America/Toronto"),
("6137633", "Saint-Constant", "", "CA", "124", "", "10", "16", "67035", "45.36678", "-73.56588", "America/Toronto"),
("6137696", "Sainte-Adèle", "", "CA", "124", "", "10", "15", "", "45.95008", "-74.13251", "America/Toronto"),
("6137702", "Sainte-Agathe-des-Monts", "", "CA", "124", "", "10", "15", "", "46.05009", "-74.28252", "America/Toronto"),
("6137733", "Sainte-Anne-de-Bellevue", "", "CA", "124", "", "10", "", "", "45.40618", "-73.9456", "America/Toronto"),
("6137749", "Sainte-Anne-des-Monts", "", "CA", "124", "", "10", "11", "04037", "49.12402", "-66.49243", "America/Toronto"),
("6137753", "Sainte-Anne-des-Plaines", "", "CA", "124", "", "10", "15", "73035", "45.76468", "-73.81156", "America/Toronto"),
("6137780", "Sainte-Catherine", "", "CA", "124", "", "10", "16", "67030", "45.40008", "-73.58248", "America/Toronto"),
("6137781", "Sainte-Catherine", "", "CA", "124", "", "10", "04", "37067", "46.31836", "-72.56632", "America/Toronto"),
("6137941", "Sainte-Julie", "", "CA", "124", "", "10", "16", "59010", "45.58338", "-73.33246", "America/Toronto"),
("6138032", "Sainte-Marthe-sur-le-Lac", "", "CA", "124", "", "10", "15", "72015", "45.53338", "-73.9325", "America/Toronto"),
("6138121", "Sainte-Thérèse", "", "CA", "124", "", "10", "15", "73010", "45.63922", "-73.82757", "America/Toronto"),
("6138175", "Saint-Eustache", "", "CA", "124", "", "10", "15", "72005", "45.565", "-73.90554", "America/Toronto"),
("6138201", "Saint-Félicien", "", "CA", "124", "", "10", "02", "91042", "48.65007", "-72.44906", "America/Toronto"),
("6138210", "Saint-Félix-de-Valois", "", "CA", "124", "", "10", "14", "62007", "46.16977", "-73.42525", "America/Toronto"),
("6138352", "Saint-Hippolyte", "", "CA", "124", "", "10", "15", "75045", "45.93338", "-74.0159", "America/Toronto"),
("6138374", "Saint-Hyacinthe", "Санкт-Гиацинт", "CA", "124", "", "10", "16", "54048", "45.63076", "-72.95699", "America/Toronto"),
("6138495", "Saint-Jean-sur-Richelieu", "Сен-Жан-сюр-Ришелье", "CA", "124", "", "10", "16", "56083", "45.30713", "-73.26259", "America/Toronto"),
("6138501", "Saint-Jérôme", "Сен-Жером", "CA", "124", "", "10", "15", "75017", "45.78036", "-74.00365", "America/Toronto"),
("6138517", "Saint John", "Сент-Джон", "CA", "124", "", "04", "1301", "", "45.27271", "-66.06766", "America/Moncton"),
("6138573", "Saint-Joseph-du-Lac", "", "CA", "124", "", "10", "15", "72025", "45.53338", "-73.9992", "America/Toronto"),
("6138610", "Saint-Laurent", "Сен-Лоран", "CA", "124", "", "10", "06", "66072", "45.50008", "-73.66585", "America/Toronto"),
("6138617", "Saint-Lazare", "", "CA", "124", "", "10", "16", "71105", "45.40008", "-74.13256", "America/Toronto"),
("6138625", "Saint-Léonard", "", "CA", "124", "", "10", "06", "", "45.58773", "-73.59501", "America/Toronto"),
("6138643", "Saint-Lin-Laurentides", "", "CA", "124", "", "10", "14", "63048", "45.85008", "-73.76588", "America/Toronto"),
("6138916", "Saint-Pie", "", "CA", "124", "", "10", "16", "54008", "45.50277", "-72.9089", "America/Toronto"),
("6138980", "Saint-Raymond", "", "CA", "124", "", "10", "", "", "45.46698", "-73.60948", "America/Toronto"),
("6139045", "Saint-Sauveur", "", "CA", "124", "", "10", "15", "77043", "45.88686", "-74.17943", "America/Toronto"),
("6139216", "Saint-Zotique", "", "CA", "124", "", "10", "16", "71025", "45.25009", "-74.24924", "America/Toronto"),
("6139289", "Salaberry-de-Valleyfield", "Салаберри-де-Валлифилд", "CA", "124", "", "10", "16", "70052", "45.25008", "-74.13253", "America/Toronto"),
("6139416", "Salmon Arm", "Сэлмон-Арм", "CA", "124", "", "02", "", "", "50.6998", "-119.30237", "America/Vancouver"),
("6141190", "Sarnia", "Сарния", "CA", "124", "", "08", "6049019", "", "42.97866", "-82.40407", "America/Toronto"),
("6141256", "Saskatoon", "Саскатун", "CA", "124", "", "11", "", "", "52.13238", "-106.66892", "America/Regina"),
("6141439", "Sault Ste. Marie", "", "CA", "124", "", "08", "5883638", "", "46.51677", "-84.33325", "America/Toronto"),
("6143367", "Sechelt", "", "CA", "124", "", "02", "5929", "", "49.47512", "-123.75903", "America/Vancouver"),
("6144054", "Selkirk", "", "CA", "124", "", "03", "", "", "50.1436", "-96.88452", "America/Winnipeg"),
("6144312", "Sept-Îles", "Сет-Иль", "CA", "124", "", "10", "09", "97007", "50.20011", "-66.38208", "America/Toronto"),
("6145489", "Shawinigan", "Шавиниган", "CA", "124", "", "10", "04", "", "46.56675", "-72.74913", "America/Toronto"),
("6146143", "Sherbrooke", "Шербрук", "CA", "124", "", "10", "05", "43027", "45.40008", "-71.89908", "America/Toronto"),
("6146279", "Sherwood Park", "", "CA", "124", "", "01", "", "", "53.51684", "-113.3187", "America/Edmonton"),
("6149374", "Slave Lake", "", "CA", "124", "", "01", "", "", "55.28344", "-114.76896", "America/Edmonton"),
("6149996", "Smithers", "", "CA", "124", "", "02", "", "", "54.78036", "-127.17428", "America/Vancouver"),
("6150174", "Smiths Falls", "", "CA", "124", "", "08", "6049130", "", "44.90452", "-76.02333", "America/Toronto"),
("6151264", "Sooke", "", "CA", "124", "", "02", "", "", "48.37463", "-123.72762", "America/Vancouver"),
("6151352", "Sorel-Tracy", "Сорель-Трейси", "CA", "124", "", "10", "16", "53052", "46.03336", "-73.11585", "America/Toronto"),
("6152244", "South Huron", "", "CA", "124", "", "08", "", "", "43.31679", "-81.51647", "America/Toronto"),
("6154383", "Spruce Grove", "", "CA", "124", "", "01", "", "", "53.53344", "-113.91874", "America/Edmonton"),
("6155033", "St. Albert", "", "CA", "124", "", "01", "", "", "53.63344", "-113.63533", "America/Edmonton"),
("6155721", "St. Catharines", "Сент-Катаринс", "CA", "124", "", "08", "6087883", "", "43.17126", "-79.24267", "America/Toronto"),
("6156102", "Steinbach", "", "CA", "124", "", "03", "", "", "49.52579", "-96.68451", "America/Winnipeg"),
("6156244", "Stephenville", "", "CA", "124", "", "05", "", "", "48.55001", "-58.5818", "America/St_Johns"),
("6156307", "Stettler", "", "CA", "124", "", "01", "", "", "52.31683", "-112.71861", "America/Edmonton"),
("6157536", "Stony Plain", "", "CA", "124", "", "01", "", "", "53.53343", "-114.00205", "America/Edmonton"),
("6157977", "Stratford", "Стратфорд", "CA", "124", "", "08", "", "", "43.36679", "-80.94972", "America/Toronto"),
("6158023", "Strathmore", "", "CA", "124", "", "01", "", "", "51.05011", "-113.38523", "America/Edmonton"),
("6158357", "St. Thomas", "", "CA", "124", "", "08", "", "", "42.77361", "-81.18038", "America/Toronto"),
("6159232", "Summerland", "", "CA", "124", "", "02", "", "", "49.59977", "-119.66911", "America/Vancouver"),
("6159244", "Summerside", "", "CA", "124", "", "09", "1103", "", "46.39593", "-63.78762", "America/Halifax"),
("6159905", "Surrey", "Суррей", "CA", "124", "", "02", "", "", "49.10635", "-122.82509", "America/Vancouver"),
("6160603", "Swift Current", "", "CA", "124", "", "11", "", "", "50.28337", "-107.80135", "America/Swift_Current"),
("6160806", "Sylvan Lake", "", "CA", "124", "", "01", "", "", "52.31681", "-114.0853", "America/Edmonton"),
("6160919", "Taber", "", "CA", "124", "", "01", "", "", "49.78703", "-112.14603", "America/Edmonton"),
("6162659", "Temiskaming Shores", "", "CA", "124", "", "08", "", "", "47.49376", "-79.71529", "America/Toronto"),
("6162949", "Terrace", "", "CA", "124", "", "02", "", "", "54.51634", "-128.60345", "America/Vancouver"),
("6163012", "Terrebonne", "Тербон", "CA", "124", "", "10", "14", "64008", "45.70004", "-73.64732", "America/Toronto"),
("6164499", "The Pas", "", "CA", "124", "", "03", "", "", "53.82509", "-101.25413", "America/Winnipeg"),
("6165406", "Thompson", "", "CA", "124", "", "03", "", "", "55.7435", "-97.85579", "America/Winnipeg"),
("6165719", "Thorold", "", "CA", "124", "", "08", "", "", "43.11682", "-79.19958", "America/Toronto"),
("6166142", "Thunder Bay", "Тандер-Бей", "CA", "124", "", "08", "6166139", "", "48.38202", "-89.25018", "America/Thunder_Bay"),
("6166739", "Timmins", "", "CA", "124", "", "08", "", "", "48.46686", "-81.33312", "America/Toronto"),
("6167865", "Toronto", "Торонто", "CA", "124", "", "08", "", "", "43.70011", "-79.4163", "America/Toronto"),
("6168326", "Trail", "", "CA", "124", "", "02", "", "", "49.09983", "-117.70223", "America/Vancouver"),
("6169141", "Trois-Rivières", "Труа-Ривьер", "CA", "124", "", "10", "04", "37067", "46.34515", "-72.5477", "America/Toronto"),
("6169587", "Truro", "Труро", "CA", "124", "", "07", "", "", "45.36685", "-63.26538", "America/Halifax"),
("6172932", "Uxbridge", "", "CA", "124", "", "08", "", "", "44.10012", "-79.11628", "America/Toronto"),
("6173012", "Val-des-Monts", "", "CA", "124", "", "10", "07", "82015", "45.6501", "-75.66604", "America/Toronto"),
("6173017", "Val-d'Or", "Валь-д'Ор", "CA", "124", "", "10", "08", "89008", "48.0974", "-77.79737", "America/Toronto"),
("6173331", "Vancouver", "Ванкувер", "CA", "124", "", "02", "", "", "49.24966", "-123.11934", "America/Vancouver"),
("6173508", "Varennes", "", "CA", "124", "", "10", "16", "", "45.68338", "-73.43246", "America/Toronto"),
("6173570", "Vaudreuil-Dorion", "", "CA", "124", "", "10", "16", "71083", "45.40008", "-74.03251", "America/Toronto"),
("6173577", "Vaughan", "Вон", "CA", "124", "", "08", "", "", "43.8361", "-79.49827", "America/Toronto"),
("6173635", "Vegreville", "", "CA", "124", "", "01", "", "", "53.50015", "-112.05182", "America/Edmonton"),
("6173864", "Vernon", "Вернон", "CA", "124", "", "02", "5937", "", "50.26729", "-119.27337", "America/Vancouver"),
("6174041", "Victoria", "Виктория", "CA", "124", "", "02", "", "", "48.43294", "-123.3693", "America/Vancouver"),
("6174151", "Victoriaville", "Викториавилл", "CA", "124", "", "10", "17", "39062", "46.05007", "-71.96579", "America/Toronto"),
("6175059", "Wainwright", "", "CA", "124", "", "01", "", "", "52.83482", "-110.85342", "America/Edmonton"),
("6176421", "Wasaga Beach", "", "CA", "124", "", "08", "", "", "44.5168", "-80.01637", "America/Toronto"),
("6176823", "Waterloo", "Ватерлоо", "CA", "124", "", "08", "", "", "43.4668", "-80.51639", "America/Toronto"),
("6177869", "Welland", "", "CA", "124", "", "08", "", "", "42.98342", "-79.24958", "America/Toronto"),
("6178582", "West End", "", "CA", "124", "", "02", "", "", "49.28333", "-123.13333", "America/Vancouver"),
("6179138", "Westlock", "", "CA", "124", "", "01", "", "", "54.15016", "-113.86876", "America/Edmonton"),
("6179226", "Westmount", "Уэстмаунт", "CA", "124", "", "10", "", "", "45.48341", "-73.59918", "America/Toronto"),
("6179602", "Wetaskiwin", "", "CA", "124", "", "01", "", "", "52.96683", "-113.36869", "America/Edmonton"),
("6179652", "Weyburn", "", "CA", "124", "", "11", "", "", "49.66675", "-103.85109", "America/Regina"),
("6180144", "Whistler", "", "CA", "124", "", "02", "", "", "50.1164", "-122.96946", "America/Vancouver"),
("6180285", "Whitecourt", "", "CA", "124", "", "01", "", "", "54.15015", "-115.68548", "America/Edmonton"),
("6180550", "Whitehorse", "Уайтхорс", "CA", "124", "", "12", "", "", "60.71611", "-135.05375", "America/Whitehorse"),
("6180961", "White Rock", "", "CA", "124", "", "02", "5915", "", "49.01636", "-122.8026", "America/Vancouver"),
("6182212", "Williams Lake", "", "CA", "124", "", "02", "5941", "", "52.14153", "-122.14451", "America/Vancouver"),
("6182959", "Windsor", "", "CA", "124", "", "10", "05", "42088", "45.56678", "-71.99909", "America/Toronto"),
("6182962", "Windsor", "Уинсор", "CA", "124", "", "08", "", "", "42.30008", "-83.01654", "America/Toronto"),
("6183204", "Winkler", "", "CA", "124", "", "03", "", "", "49.1817", "-97.94104", "America/Winnipeg"),
("6183235", "Winnipeg", "Виннипег", "CA", "124", "", "03", "", "", "49.8844", "-97.14704", "America/Winnipeg"),
("6184365", "Woodstock", "Вудсток", "CA", "124", "", "08", "6095780", "", "43.13339", "-80.7497", "America/Toronto"),
("6185217", "Yarmouth", "", "CA", "124", "", "07", "", "", "43.83345", "-66.11557", "America/Halifax"),
("6185377", "Yellowknife", "Йеллоунайф", "CA", "124", "", "13", "", "", "62.45411", "-114.37248", "America/Yellowknife"),
("6185607", "Yorkton", "", "CA", "124", "", "11", "", "", "51.2167", "-102.46766", "America/Regina"),
("6295855", "Beauceville", "", "CA", "124", "", "10", "12", "27028", "46.21785", "-70.77873", "America/Toronto"),
("6324729", "Halifax", "Галифакс", "CA", "124", "", "07", "", "", "44.64533", "-63.57239", "America/Halifax"),
("6324733", "St. John's", "Сент-Джонс", "CA", "124", "", "05", "", "", "47.56494", "-52.70931", "America/St_Johns"),
("6325494", "Québec", "Квебек", "CA", "124", "", "10", "", "", "46.81228", "-71.21454", "America/Toronto"),
("6325521", "Lévis", "Леви", "CA", "124", "", "10", "12", "25213", "46.80326", "-71.17793", "America/Blanc-Sablon"),
("6325529", "Montmagny", "", "CA", "124", "", "10", "12", "", "46.98043", "-70.55493", "America/Toronto"),
("6354895", "Rimouski", "Римуски", "CA", "124", "", "10", "01", "10043", "48.44879", "-68.52396", "America/Toronto"),
("6354897", "Rivière-du-Loup", "Ривьер-дю-Лу", "CA", "124", "", "10", "01", "", "47.82699", "-69.54243", "America/Toronto"),
("6354908", "Sydney", "", "CA", "124", "", "07", "Cape Breton County (undefined)", "", "46.1351", "-60.1831", "America/Glace_Bay"),
("6534203", "L'Ancienne-Lorette", "", "CA", "124", "", "10", "", "", "46.79392", "-71.35191", "America/Toronto"),
("6545023", "Edmundston", "Эдмундстон", "CA", "124", "", "04", "", "", "47.3737", "-68.32512", "America/Moncton"),
("6620953", "Saint-Georges", "", "CA", "124", "", "10", "12", "29073", "46.11353", "-70.66526", "America/Toronto"),
("6639619", "Sainte Catherine de la Jacques Cartier", "", "CA", "124", "", "10", "03", "22005", "46.85244", "-71.62056", "America/Toronto"),
("6690232", "Baie-Saint-Paul", "", "CA", "124", "", "10", "03", "", "47.44109", "-70.49858", "America/Toronto"),
("6696258", "Campbellton", "", "CA", "124", "", "04", "11", "", "48.00751", "-66.67272", "America/Moncton"),
("6696259", "Bathurst", "", "CA", "124", "", "04", "", "", "47.61814", "-65.65112", "America/Moncton"),
("6696260", "Matane", "", "CA", "124", "", "10", "01", "", "48.82857", "-67.52197", "America/Toronto"),
("6942553", "Paris", "", "CA", "124", "", "08", "", "", "43.2", "-80.38333", "America/Toronto"),
("6943488", "Amqui", "", "CA", "124", "", "10", "01", "07047", "48.46382", "-67.43134", "America/Toronto"),
("6943811", "Chandler", "", "CA", "124", "", "10", "11", "02028", "48.34935", "-64.67926", "America/Toronto"),
("6943827", "Thetford-Mines", "", "CA", "124", "", "10", "12", "31084", "46.09371", "-71.30539", "America/Toronto"),
("6944113", "Mont-Joli", "", "CA", "124", "", "10", "01", "", "48.58388", "-68.19214", "America/Toronto"),
("6945986", "La Malbaie", "", "CA", "124", "", "10", "03", "", "47.654", "-70.15268", "America/Toronto"),
("6945989", "Sainte-Marie", "", "CA", "124", "", "10", "12", "", "46.43401", "-71.01168", "America/Toronto"),
("6945991", "Plessisville", "", "CA", "124", "", "10", "04", "", "46.21856", "-71.76201", "America/Toronto"),
("6948711", "Scarborough", "", "CA", "124", "", "08", "", "", "43.77223", "-79.25666", "America/Toronto"),
("7280414", "Cole Harbour", "", "CA", "124", "", "07", "", "", "44.67244", "-63.47506", "America/Halifax"),
("7281931", "Okanagan", "", "CA", "124", "", "02", "", "", "50.36386", "-119.34997", "America/Vancouver"),
("7281936", "West Kelowna", "", "CA", "124", "", "02", "", "", "49.8625", "-119.58333", "America/Vancouver"),
("7303783", "Sydney Mines", "", "CA", "124", "", "07", "", "", "46.23669", "-60.21767", "America/Glace_Bay"),
("7303786", "Jonquière", "Жонкьер", "CA", "124", "", "10", "02", "94068", "48.41648", "-71.24884", "America/Toronto"),
("7535681", "Saint-Augustin-de-Desmaures", "", "CA", "124", "", "10", "03", "", "46.74064", "-71.45131", "America/Toronto"),
("7535690", "Donnacona", "", "CA", "124", "", "10", "03", "34025", "46.68042", "-71.7239", "America/Toronto"),
("7602078", "Ladner", "", "CA", "124", "", "02", "", "", "49.08938", "-123.08241", "America/Vancouver"),
("7669012", "Walnut Grove", "", "CA", "124", "", "02", "", "", "49.16473", "-122.64042", "America/Vancouver"),
("7669018", "Aldergrove", "", "CA", "124", "", "02", "", "", "49.05801", "-122.47087", "America/Vancouver"),
("7870925", "East York", "", "CA", "124", "", "08", "", "", "43.69053", "-79.32794", "America/Toronto"),
("8285452", "Ancaster", "Анкастер", "CA", "124", "", "08", "", "", "43.21806", "-79.98716", "America/Toronto"),
("8354533", "Shannon", "", "CA", "124", "", "10", "03", "22020", "46.88026", "-71.51464", "America/Toronto"),
("8354586", "Saint-Henri", "", "CA", "124", "", "10", "12", "", "46.69314", "-71.06927", "America/Toronto"),
("8379100", "Pont-Rouge", "", "CA", "124", "", "10", "03", "34017", "46.75468", "-71.69566", "America/Toronto"),
("8379101", "Princeville", "", "CA", "124", "", "10", "17", "32033", "46.17163", "-71.87462", "America/Toronto"),
("8533869", "West Vancouver", "", "CA", "124", "", "02", "", "", "49.36672", "-123.16652", "America/Vancouver"),
("8558534", "Willowdale", "", "CA", "124", "", "08", "", "", "43.76672", "-79.39909", "America/Toronto"),
("10287505", "Lower Sackville", "", "CA", "124", "", "07", "", "", "44.77599", "-63.67865", "America/Halifax"),
("10627796", "le Plateau", "", "CA", "124", "", "10", "07", "81017", "45.43514", "-75.7803", "America/Toronto"),
("11203927", "Wild Rose", "", "CA", "124", "", "01", "", "", "53.4708", "-113.38119", "America/Edmonton"),
("11203928", "Silver Berry", "", "CA", "124", "", "01", "", "", "53.45787", "-113.3817", "America/Edmonton"),
("7304591", "West Island", "", "CC", "166", "", "", "", "", "-12.15681", "96.82251", "Indian/Cocos"),
("235826", "Zemio", "", "CF", "140", "", "05", "9143464", "", "5.03144", "25.13614", "Africa/Bangui"),
("236524", "Rafaï", "", "CF", "140", "", "08", "9143468", "", "4.95", "23.91667", "Africa/Bangui"),
("236901", "Ouadda", "", "CF", "140", "", "03", "9143466", "", "8.07771", "22.40075", "Africa/Bangui"),
("236950", "Obo", "", "CF", "140", "", "05", "9143463", "", "5.39586", "26.49211", "Africa/Bangui"),
("237379", "Ndélé", "", "CF", "140", "", "01", "9143460", "", "8.41091", "20.64728", "Africa/Bangui"),
("237478", "Mobaye", "", "CF", "140", "", "02", "7731891", "", "4.31902", "21.17861", "Africa/Bangui"),
("238373", "Kembé", "", "CF", "140", "", "02", "7731890", "", "4.62275", "21.88645", "Africa/Bangui"),
("238566", "Ippy", "", "CF", "140", "", "11", "7732067", "", "6.26793", "21.22468", "Africa/Bangui"),
("239899", "Bria", "Бриа", "CF", "140", "", "03", "9143465", "", "6.54233", "21.98633", "Africa/Bangui"),
("240210", "Birao", "", "CF", "140", "", "14", "9143458", "", "10.28488", "22.78818", "Africa/Bangui"),
("240498", "Bangassou", "Бангасу", "CF", "140", "", "08", "7732064", "", "4.74132", "22.81838", "Africa/Bangui"),
("240604", "Bambari", "Бамбари", "CF", "140", "", "11", "7732062", "", "5.76795", "20.67565", "Africa/Bangui"),
("240999", "Alindao", "", "CF", "140", "", "02", "9143474", "", "5.02667", "21.20876", "Africa/Bangui"),
("2383119", "Sibut", "Сибут", "CF", "140", "", "06", "7732483", "", "5.71801", "19.07389", "Africa/Bangui"),
("2383523", "Paoua", "", "CF", "140", "", "13", "9143494", "", "7.24269", "16.44059", "Africa/Bangui"),
("2383827", "Nola", "", "CF", "140", "", "16", "7731904", "", "3.52494", "16.04583", "Africa/Bangui"),
("2384377", "Mongoumba", "", "CF", "140", "", "07", "7731898", "", "3.64153", "18.59364", "Africa/Bangui"),
("2384770", "Mbaïki", "", "CF", "140", "", "07", "7732068", "", "3.86781", "17.98923", "Africa/Bangui"),
("2385535", "Kouango", "", "CF", "140", "", "11", "7731893", "", "4.99337", "19.96186", "Africa/Bangui"),
("2386012", "Kaga Bandoro", "", "CF", "140", "", "15", "9143469", "", "6.98961", "19.18744", "Africa/Bangui"),
("2386042", "Kabo", "", "CF", "140", "", "12", "9143478", "", "7.69937", "18.62903", "Africa/Bangui"),
("2386756", "Gamboula", "", "CF", "140", "", "04", "7732916", "", "4.11775", "15.13926", "Africa/Bangui"),
("2387435", "Damara", "Дамара", "CF", "140", "", "17", "7731895", "", "4.96075", "18.7035", "Africa/Bangui"),
("2387495", "Carnot", "", "CF", "140", "", "04", "2387494", "", "4.94273", "15.87735", "Africa/Bangui"),
("2387546", "Bozoum", "Бозуме", "CF", "140", "", "13", "8299286", "", "6.31933", "16.37992", "Africa/Bangui"),
("2387890", "Bouca", "", "CF", "140", "", "12", "9143477", "", "6.50734", "18.2767", "Africa/Bangui"),
("2387926", "Bouar", "Буаре", "CF", "140", "", "09", "7732085", "", "5.93404", "15.59599", "Africa/Bangui"),
("2388036", "Bossangoa", "Босангоа", "CF", "140", "", "12", "7732115", "", "6.49263", "17.45518", "Africa/Bangui"),
("2388614", "Boda", "", "CF", "140", "", "07", "9143467", "", "4.31887", "17.46953", "Africa/Bangui"),
("2388720", "Boali", "", "CF", "140", "", "17", "8299285", "", "4.80048", "18.12747", "Africa/Bangui"),
("2388873", "Bimbo", "", "CF", "140", "", "17", "7731896", "", "4.25671", "18.41583", "Africa/Bangui"),
("2389086", "Berbérati", "Берберати", "CF", "140", "", "04", "7732685", "", "4.26116", "15.79216", "Africa/Bangui"),
("2389691", "Batangafo", "", "CF", "140", "", "12", "9143472", "", "7.30082", "18.2833", "Africa/Bangui"),
("2389804", "Baoro", "", "CF", "140", "", "09", "7732103", "", "5.66667", "15.96667", "Africa/Bangui"),
("2389853", "Bangui", "Банги", "CF", "140", "", "18", "7731897", "", "4.36122", "18.55496", "Africa/Bangui"),
("2657896", "Zürich", "Цюрих", "CH", "756", "", "ZH", "112", "261", "47.36667", "8.55", "Europe/Zurich"),
("2657908", "Zug", "Цуг", "CH", "756", "", "ZG", "900", "1711", "47.17242", "8.51745", "Europe/Zurich"),
("2657910", "Zuchwil", "", "CH", "756", "", "SO", "1106", "2534", "47.20173", "7.56649", "Europe/Zurich"),
("2657912", "Zollikon", "", "CH", "756", "", "ZH", "107", "161", "47.34019", "8.57407", "Europe/Zurich"),
("2657913", "Zollikofen", "", "CH", "756", "", "BE", "246", "361", "46.99905", "7.45809", "Europe/Zurich"),
("2657915", "Zofingen", "", "CH", "756", "", "AG", "1910", "4289", "47.28779", "7.94586", "Europe/Zurich"),
("2657928", "Zermatt", "", "CH", "756", "", "VS", "2313", "6300", "46.01998", "7.74863", "Europe/Zurich"),
("2657941", "Yverdon-les-Bains", "Ивердон-ле-Бен", "CH", "756", "", "VD", "2224", "5938", "46.77852", "6.64115", "Europe/Zurich"),
("2657947", "Würenlos", "", "CH", "756", "", "AG", "1902", "4048", "47.44208", "8.36439", "Europe/Zurich"),
("2657954", "Worb", "", "CH", "756", "", "BE", "246", "627", "46.92984", "7.56306", "Europe/Zurich"),
("2657955", "Wollerau", "", "CH", "756", "", "SZ", "503", "1321", "47.19478", "8.71903", "Europe/Zurich"),
("2657963", "Wohlen", "", "CH", "756", "", "AG", "1903", "4082", "47.35236", "8.27877", "Europe/Zurich"),
("2657964", "Wohlen", "", "CH", "756", "", "BE", "246", "360", "46.97118", "7.35685", "Europe/Zurich"),
("2657968", "Wittenbach", "", "CH", "756", "", "SG", "1721", "3204", "47.46108", "9.38601", "Europe/Zurich"),
("2657969", "Zürich (Kreis 7) / Witikon", "", "CH", "756", "", "ZH", "112", "261", "47.35751", "8.59105", "Europe/Zurich"),
("2657970", "Winterthur", "Винтертур", "CH", "756", "", "ZH", "110", "230", "47.50564", "8.72413", "Europe/Zurich"),
("2657976", "Windisch", "", "CH", "756", "", "AG", "1904", "4123", "47.47899", "8.21842", "Europe/Zurich"),
("2657996", "Wil", "Виль", "CH", "756", "", "SG", "1728", "3427", "47.46152", "9.04552", "Europe/Zurich"),
("2658007", "Zürich (Kreis 3) / Alt-Wiedikon", "", "CH", "756", "CH", "ZH", "112", "261", "47.36201", "8.51497", "Europe/Zurich"),
("2658010", "Wetzikon", "", "CH", "756", "", "ZH", "105", "121", "47.3264", "8.79779", "Europe/Zurich"),
("2658011", "Wettingen", "Веттинген", "CH", "756", "", "AG", "1902", "4045", "47.47049", "8.31636", "Europe/Zurich"),
("2658036", "Weinfelden", "", "CH", "756", "", "TG", "2015", "4946", "47.56667", "9.1", "Europe/Zurich"),
("2658042", "Wattwil", "", "CH", "756", "", "SG", "1727", "3379", "47.29955", "9.08657", "Europe/Zurich"),
("2658060", "Wallisellen", "", "CH", "756", "", "ZH", "103", "69", "47.41499", "8.59672", "Europe/Zurich"),
("2658076", "Wahlern", "", "CH", "756", "", "BE", "246", "855", "46.82806", "7.35318", "Europe/Zurich"),
("2658082", "Wädenswil", "", "CH", "756", "", "ZH", "106", "142", "47.22683", "8.6687", "Europe/Zurich"),
("2658112", "Visp", "", "CH", "756", "", "VS", "2313", "6297", "46.2937", "7.88149", "Europe/Zurich"),
("2658119", "Villmergen", "", "CH", "756", "", "AG", "1903", "4080", "47.34917", "8.24583", "Europe/Zurich"),
("2658128", "Villars-sur-Glâne", "", "CH", "756", "", "FR", "1004", "2228", "46.79054", "7.11717", "Europe/Zurich"),
("2658135", "Viganello", "", "CH", "756", "", "TI", "2105", "5192", "46.01342", "8.96879", "Europe/Zurich"),
("2658143", "Veyrier", "", "CH", "756", "", "GE", "2500", "6645", "46.16699", "6.18436", "Europe/Zurich"),
("2658145", "Vevey", "Веве", "CH", "756", "", "VD", "2230", "5890", "46.46299", "6.84345", "Europe/Zurich"),
("2658151", "Versoix", "", "CH", "756", "", "GE", "2500", "6644", "46.28382", "6.16214", "Europe/Zurich"),
("2658154", "Vernier", "", "CH", "756", "", "GE", "2500", "6643", "46.21702", "6.08497", "Europe/Zurich"),
("2658172", "Veltheim (Kreis 5)", "", "CH", "756", "", "ZH", "110", "230", "47.51419", "8.717", "Europe/Zurich"),
("2658209", "Uzwil", "", "CH", "756", "", "SG", "1728", "3408", "47.43653", "9.13422", "Europe/Zurich"),
("2658210", "Uznach", "", "CH", "756", "", "SG", "1726", "3339", "47.22421", "8.98263", "Europe/Zurich"),
("2658216", "Uster", "Устер", "CH", "756", "", "ZH", "109", "198", "47.34713", "8.72091", "Europe/Zurich"),
("2658217", "Urtenen", "", "CH", "756", "", "BE", "246", "551", "47.02667", "7.50081", "Europe/Zurich"),
("2658237", "Untersiggenthal", "", "CH", "756", "", "AG", "1902", "4044", "47.50213", "8.25554", "Europe/Zurich"),
("2658240", "Unterseen", "", "CH", "756", "", "BE", "250", "593", "46.6853", "7.84722", "Europe/Zurich"),
("2658264", "Unterägeri", "", "CH", "756", "", "ZG", "900", "1709", "47.13645", "8.5853", "Europe/Zurich"),
("2658277", "Uetendorf", "", "CH", "756", "", "BE", "247", "944", "46.77392", "7.57251", "Europe/Zurich"),
("2658312", "Trimbach", "", "CH", "756", "", "SO", "1105", "2500", "47.36561", "7.8868", "Europe/Zurich"),
("2658344", "Töss (Kreis 4)", "", "CH", "756", "CH", "ZH", "110", "230", "47.4789", "8.70215", "Europe/Zurich"),
("2658377", "Thun", "Тун", "CH", "756", "", "BE", "247", "942", "46.75118", "7.62166", "Europe/Zurich"),
("2658386", "Therwil", "", "CH", "756", "", "BL", "1301", "2775", "47.50117", "7.55286", "Europe/Zurich"),
("2658388", "Thalwil", "", "CH", "756", "", "ZH", "106", "141", "47.29175", "8.56351", "Europe/Zurich"),
("2658397", "Teufen", "", "CH", "756", "", "AR", "1502", "3024", "47.3908", "9.38644", "Europe/Zurich"),
("2658440", "Sursee", "", "CH", "756", "", "LU", "314", "1095", "47.17088", "8.11113", "Europe/Zurich"),
("2658449", "Sumiswald", "", "CH", "756", "", "BE", "245", "957", "47.02747", "7.74526", "Europe/Zurich"),
("2658457", "Suhr", "", "CH", "756", "", "AG", "1901", "4012", "47.37172", "8.07967", "Europe/Zurich"),
("2658483", "Steinhausen", "", "CH", "756", "", "ZG", "900", "1702", "47.1951", "8.48581", "Europe/Zurich"),
("2658494", "Steffisburg", "", "CH", "756", "", "BE", "247", "939", "46.77807", "7.63249", "Europe/Zurich"),
("2658504", "Stans", "", "CH", "756", "", "NW", "700", "1509", "46.95805", "8.36609", "Europe/Zurich"),
("2658518", "Stäfa", "", "CH", "756", "", "ZH", "107", "158", "47.24254", "8.72342", "Europe/Zurich"),
("2658524", "Spreitenbach", "", "CH", "756", "", "AG", "1902", "4040", "47.42016", "8.36301", "Europe/Zurich"),
("2658536", "Spiez", "", "CH", "756", "", "BE", "249", "768", "46.68473", "7.69111", "Europe/Zurich"),
("2658564", "Solothurn", "", "CH", "756", "", "SO", "1109", "2601", "47.20791", "7.53714", "Europe/Zurich"),
("2658572", "Sissach", "", "CH", "756", "", "BL", "1304", "2861", "47.46408", "7.80888", "Europe/Zurich"),
("2658575", "Sirnach", "", "CH", "756", "", "TG", "2014", "4761", "47.46222", "8.99763", "Europe/Zurich"),
("2658576", "Sitten", "Сьон", "CH", "756", "", "VS", "2312", "6266", "46.22739", "7.35559", "Europe/Zurich"),
("2658606", "Sierre", "", "CH", "756", "", "VS", "2311", "6248", "46.29192", "7.53559", "Europe/Zurich"),
("2658608", "Siebnen", "", "CH", "756", "", "SZ", "505", "1346", "47.17449", "8.89781", "Europe/Zurich"),
("2658656", "Zürich (Kreis 11) / Seebach", "", "CH", "756", "", "ZH", "112", "261", "47.42181", "8.54779", "Europe/Zurich"),
("2658665", "Schwyz", "", "CH", "756", "", "SZ", "506", "1372", "47.02076", "8.65414", "Europe/Zurich"),
("2658696", "Schübelbach", "", "CH", "756", "", "SZ", "505", "1346", "47.17326", "8.92811", "Europe/Zurich"),
("2658724", "Schlieren", "", "CH", "756", "", "ZH", "111", "247", "47.39668", "8.44763", "Europe/Zurich"),
("2658761", "Schaffhausen", "Шаффхаузен", "CH", "756", "", "SH", "1403", "2939", "47.69732", "8.63493", "Europe/Zurich"),
("2658775", "Savièse", "", "CH", "756", "", "VS", "2312", "6265", "46.25115", "7.34558", "Europe/Zurich"),
("2658786", "Sarnen", "", "CH", "756", "", "OW", "600", "1407", "46.89611", "8.24531", "Europe/Zurich"),
("2658793", "Sargans", "", "CH", "756", "", "SG", "1725", "3296", "47.04896", "9.44103", "Europe/Zurich"),
("2658816", "Sankt Margrethen", "", "CH", "756", "", "SG", "1723", "3236", "47.45253", "9.63741", "Europe/Zurich"),
("2658822", "Sankt Gallen", "Санкт-Галлен", "CH", "756", "", "SG", "1721", "3203", "47.42391", "9.37477", "Europe/Zurich"),
("2658871", "Saint-Imier", "", "CH", "756", "", "BE", "241", "443", "47.15284", "6.99692", "Europe/Zurich"),
("2658904", "Saanen", "", "CH", "756", "", "BE", "248", "843", "46.48945", "7.26003", "Europe/Zurich"),
("2658909", "Rüti", "", "CH", "756", "", "ZH", "105", "117", "47.25603", "8.85552", "Europe/Zurich"),
("2658914", "Ruswil", "", "CH", "756", "", "LU", "314", "1098", "47.08425", "8.12645", "Europe/Zurich"),
("2658927", "Rümlang", "", "CH", "756", "", "ZH", "104", "97", "47.45041", "8.52993", "Europe/Zurich"),
("2658950", "Rotkreuz", "", "CH", "756", "", "ZG", "900", "1707", "47.14059", "8.42934", "Europe/Zurich"),
("2658952", "Rothrist", "", "CH", "756", "", "AG", "1910", "4282", "47.30508", "7.89196", "Europe/Zurich"),
("2658969", "Rorschach", "", "CH", "756", "", "SG", "1722", "3215", "47.478", "9.4903", "Europe/Zurich"),
("2658985", "Romanshorn", "", "CH", "756", "", "TG", "2011", "4436", "47.56586", "9.37869", "Europe/Zurich"),
("2659050", "Richterswil", "", "CH", "756", "", "ZH", "106", "138", "47.20622", "8.69686", "Europe/Zurich"),
("2659060", "Rheinfelden", "", "CH", "756", "", "AG", "1909", "4258", "47.55437", "7.79403", "Europe/Zurich"),
("2659070", "Renens", "Ренан", "CH", "756", "", "VD", "2229", "5591", "46.53989", "6.5881", "Europe/Zurich"),
("2659076", "Reinach", "", "CH", "756", "", "AG", "1905", "4141", "47.25944", "8.18845", "Europe/Zurich"),
("2659083", "Regensdorf", "", "CH", "756", "", "ZH", "104", "96", "47.4341", "8.46874", "Europe/Zurich"),
("2659099", "Rapperswil", "Рапперсвиль", "CH", "756", "", "SG", "1726", "3340", "47.22557", "8.82228", "Europe/Zurich"),
("2659127", "Pully", "", "CH", "756", "", "VD", "2226", "5590", "46.51027", "6.66183", "Europe/Zurich"),
("2659136", "Prilly", "", "CH", "756", "", "VD", "2229", "5591", "46.53698", "6.60456", "Europe/Zurich"),
("2659142", "Pregassona", "", "CH", "756", "", "TI", "2105", "5192", "46.02021", "8.97429", "Europe/Zurich"),
("2659147", "Pratteln", "", "CH", "756", "", "BL", "1303", "2831", "47.52071", "7.69356", "Europe/Zurich"),
("2659171", "Porrentruy", "", "CH", "756", "", "JU", "2603", "6800", "47.41533", "7.07522", "Europe/Zurich"),
("2659190", "Plan-les-Ouates", "", "CH", "756", "", "GE", "2500", "6633", "46.16789", "6.11664", "Europe/Zurich"),
("2659219", "Pfäffikon", "", "CH", "756", "", "ZH", "108", "177", "47.36453", "8.79202", "Europe/Zurich"),
("2659220", "Pfäffikon", "", "CH", "756", "", "SZ", "503", "1322", "47.20109", "8.77816", "Europe/Zurich"),
("2659227", "Peseux", "", "CH", "756", "", "NE", "2401", "6412", "46.98704", "6.88903", "Europe/Zurich"),
("2659243", "Payerne", "", "CH", "756", "", "VD", "2222", "5822", "46.82201", "6.93608", "Europe/Zurich"),
("2659289", "Orbe", "", "CH", "756", "", "VD", "2224", "5757", "46.72504", "6.53069", "Europe/Zurich"),
("2659296", "Onex", "", "CH", "756", "", "GE", "2500", "6631", "46.18396", "6.10237", "Europe/Zurich"),
("2659297", "Olten", "Ольтен", "CH", "756", "", "SO", "1108", "2581", "47.34999", "7.90329", "Europe/Zurich"),
("2659298", "Ollon", "", "CH", "756", "", "VD", "2221", "5409", "46.29524", "6.99314", "Europe/Zurich"),
("2659303", "Oftringen", "", "CH", "756", "", "AG", "1910", "4280", "47.31382", "7.92533", "Europe/Zurich"),
("2659310", "Zürich (Kreis 11) / Oerlikon", "", "CH", "756", "", "ZH", "112", "261", "47.40823", "8.54258", "Europe/Zurich"),
("2659321", "Oberwil", "", "CH", "756", "", "BL", "1301", "2771", "47.51407", "7.55786", "Europe/Zurich"),
("2659331", "Oberuzwil", "", "CH", "756", "", "SG", "1728", "3407", "47.43076", "9.12724", "Europe/Zurich"),
("2659332", "Urdorf", "", "CH", "756", "", "ZH", "111", "250", "47.38507", "8.42581", "Europe/Zurich"),
("2659344", "Obersiggenthal", "", "CH", "756", "", "AG", "1902", "4038", "47.4875", "8.29652", "Europe/Zurich"),
("2659357", "Oberriet", "", "CH", "756", "", "SG", "1723", "3254", "47.32088", "9.56808", "Europe/Zurich"),
("2659391", "Oberentfelden", "", "CH", "756", "", "AG", "1901", "4010", "47.35639", "8.04594", "Europe/Zurich"),
("2659392", "Oberengstringen", "", "CH", "756", "", "ZH", "111", "245", "47.40841", "8.46515", "Europe/Zurich"),
("2659422", "Nyon", "Ньон", "CH", "756", "", "VD", "2228", "5724", "46.38318", "6.23955", "Europe/Zurich"),
("2659474", "Nidau", "", "CH", "756", "", "BE", "242", "743", "47.12545", "7.24033", "Europe/Zurich"),
("2659485", "Neuhausen", "", "CH", "756", "", "SH", "1403", "2937", "47.68579", "8.61474", "Europe/Zurich"),
("2659489", "Neuenkirch", "", "CH", "756", "", "LU", "314", "1093", "47.09989", "8.20416", "Europe/Zurich"),
("2659490", "Neuenhof", "", "CH", "756", "", "AG", "1902", "4034", "47.4526", "8.32577", "Europe/Zurich"),
("2659496", "Neuchâtel", "Невшатель", "CH", "756", "", "NE", "2404", "6458", "46.99179", "6.931", "Europe/Zurich"),
("2659510", "Naters", "", "CH", "756", "", "VS", "2301", "6007", "46.32536", "7.98912", "Europe/Zurich"),
("2659522", "Muttenz", "Муттенц", "CH", "756", "", "BL", "1301", "2770", "47.52271", "7.64511", "Europe/Zurich"),
("2659529", "Murten/Morat", "", "CH", "756", "", "FR", "1005", "2275", "46.92827", "7.11715", "Europe/Zurich"),
("2659531", "Muri", "", "CH", "756", "", "AG", "1908", "4236", "47.27428", "8.33854", "Europe/Zurich"),
("2659532", "Muri", "", "CH", "756", "", "BE", "246", "356", "46.93122", "7.48658", "Europe/Zurich"),
("2659546", "Münsingen", "", "CH", "756", "", "BE", "246", "616", "46.87298", "7.561", "Europe/Zurich"),
("2659551", "Münchenstein", "", "CH", "756", "", "BL", "1301", "2769", "47.51848", "7.60966", "Europe/Zurich"),
("2659552", "Münchenbuchsee", "", "CH", "756", "", "BE", "246", "546", "47.02175", "7.45036", "Europe/Zurich"),
("2659568", "Moutier", "", "CH", "756", "", "BE", "241", "700", "47.27818", "7.36951", "Europe/Zurich"),
("2659587", "Morges", "", "CH", "756", "", "VD", "2227", "5642", "46.51127", "6.49854", "Europe/Zurich"),
("2659601", "Montreux", "Монтрё", "CH", "756", "", "VD", "2230", "5886", "46.43301", "6.91143", "Europe/Zurich"),
("2659613", "Monthey", "Монте", "CH", "756", "", "VS", "2308", "6153", "46.25451", "6.95406", "Europe/Zurich"),
("2659645", "Möhlin", "", "CH", "756", "", "AG", "1909", "4254", "47.55915", "7.84329", "Europe/Zurich"),
("2659658", "Minusio", "", "CH", "756", "", "TI", "2104", "5118", "46.17769", "8.81473", "Europe/Zurich"),
("2659667", "Meyrin", "Мерен", "CH", "756", "", "GE", "2500", "6630", "46.23424", "6.08025", "Europe/Zurich"),
("2659687", "Menziken", "", "CH", "756", "", "AG", "1905", "4141", "47.24249", "8.19047", "Europe/Zurich"),
("2659689", "Mendrisio", "", "CH", "756", "", "TI", "2106", "5254", "45.87019", "8.9816", "Europe/Zurich"),
("2659708", "Meggen", "", "CH", "756", "", "LU", "312", "1063", "47.04691", "8.37467", "Europe/Zurich"),
("2659739", "Massagno", "", "CH", "756", "", "TI", "2105", "5192", "46.01257", "8.94354", "Europe/Zurich"),
("2659748", "Martigny-Ville", "", "CH", "756", "", "VS", "2307", "6136", "46.10276", "7.07245", "Europe/Zurich"),
("2659758", "Marly", "", "CH", "756", "", "FR", "1004", "2206", "46.77611", "7.16459", "Europe/Zurich"),
("2659772", "Männedorf", "", "CH", "756", "", "ZH", "107", "155", "47.25686", "8.69893", "Europe/Zurich"),
("2659776", "Malters", "", "CH", "756", "", "LU", "312", "1062", "47.03628", "8.18193", "Europe/Zurich"),
("2659808", "Lyss", "", "CH", "756", "", "BE", "243", "306", "47.0741", "7.30655", "Europe/Zurich"),
("2659811", "Luzern", "Люцерн", "CH", "756", "", "LU", "311", "1061", "47.05048", "8.30635", "Europe/Zurich"),
("2659819", "Lutry", "", "CH", "756", "", "VD", "2226", "5606", "46.50241", "6.68647", "Europe/Zurich"),
("2659836", "Lugano", "Лугано", "CH", "756", "", "TI", "2105", "5192", "46.01008", "8.96004", "Europe/Zurich"),
("2659853", "Losone", "", "CH", "756", "", "TI", "2104", "5115", "46.16866", "8.75928", "Europe/Zurich"),
("2659869", "Locarno", "", "CH", "756", "", "TI", "2104", "5113", "46.17086", "8.79953", "Europe/Zurich"),
("2659873", "Littau", "", "CH", "756", "", "LU", "311", "1061", "47.05", "8.26274", "Europe/Zurich"),
("2659891", "Liestal", "", "CH", "756", "", "BL", "1303", "2829", "47.48455", "7.73446", "Europe/Zurich"),
("2659952", "Lenzburg", "", "CH", "756", "", "AG", "1907", "4201", "47.38853", "8.17503", "Europe/Zurich"),
("2659957", "Lengnau", "", "CH", "756", "", "BE", "242", "387", "47.18155", "7.36814", "Europe/Zurich"),
("2659959", "Le Mont-sur-Lausanne", "", "CH", "756", "", "VD", "2225", "5587", "46.55815", "6.63145", "Europe/Zurich"),
("2659960", "Le Locle", "", "CH", "756", "", "NE", "2403", "6436", "47.05953", "6.75228", "Europe/Zurich"),
("2659977", "Le Châtelard", "Шатлар", "CH", "756", "", "VD", "2230", "5886", "46.44527", "6.89908", "Europe/Zurich"),
("2659994", "Lausanne", "Лозанна", "CH", "756", "", "VD", "2225", "5586", "46.516", "6.63282", "Europe/Zurich"),
("2660001", "Laufen", "", "CH", "756", "", "BL", "1302", "2787", "47.42193", "7.49946", "Europe/Zurich"),
("2660008", "La Tour-de-Peilz", "", "CH", "756", "", "VD", "2230", "5889", "46.45312", "6.85856", "Europe/Zurich"),
("2660032", "Langnau", "", "CH", "756", "", "BE", "245", "902", "46.93936", "7.78738", "Europe/Zurich"),
("2660034", "Langenthal", "", "CH", "756", "", "BE", "244", "329", "47.21526", "7.79607", "Europe/Zurich"),
("2660075", "Lachen", "", "CH", "756", "", "SZ", "505", "1341", "47.19927", "8.85432", "Europe/Zurich"),
("2660076", "La Chaux-de-Fonds", "Ла-Шо-де-Фон", "CH", "756", "", "NE", "2402", "6421", "47.09993", "6.82586", "Europe/Zurich"),
("2660086", "Küttigen", "", "CH", "756", "", "AG", "1901", "4008", "47.41566", "8.04767", "Europe/Zurich"),
("2660088", "Küssnacht", "", "CH", "756", "", "SZ", "504", "1331", "47.08557", "8.44206", "Europe/Zurich"),
("2660089", "Küsnacht", "", "CH", "756", "", "ZH", "107", "154", "47.31805", "8.58401", "Europe/Zurich"),
("2660104", "Kriens", "Кринс", "CH", "756", "", "LU", "312", "1059", "47.03537", "8.27631", "Europe/Zurich"),
("2660108", "Kreuzlingen", "Кройцлинген", "CH", "756", "", "TG", "2013", "4671", "47.65051", "9.17504", "Europe/Zurich"),
("2660119", "Köniz", "Кёниц", "CH", "756", "", "BE", "246", "355", "46.92436", "7.41457", "Europe/Zurich"),
("2660127", "Kloten", "Клотен", "CH", "756", "", "ZH", "103", "62", "47.45152", "8.58491", "Europe/Zurich"),
("2660155", "Kirchberg", "", "CH", "756", "", "SG", "1727", "3392", "47.41159", "9.0402", "Europe/Zurich"),
("2660156", "Kirchberg", "", "CH", "756", "", "BE", "245", "412", "47.08538", "7.58288", "Europe/Zurich"),
("2660161", "Kilchberg", "", "CH", "756", "", "ZH", "106", "135", "47.32438", "8.54548", "Europe/Zurich"),
("2660171", "Kerns", "", "CH", "756", "", "OW", "600", "1404", "46.90134", "8.27528", "Europe/Zurich"),
("2660221", "Jona", "", "CH", "756", "", "SG", "1726", "3340", "47.22983", "8.83884", "Europe/Zurich"),
("2660253", "Interlaken", "", "CH", "756", "", "BE", "250", "593", "46.68387", "7.86638", "Europe/Zurich"),
("2660261", "Ingenbohl", "", "CH", "756", "", "SZ", "506", "1364", "46.9988", "8.61529", "Europe/Zurich"),
("2660277", "Igis", "", "CH", "756", "", "GR", "1826", "3955", "46.94531", "9.57218", "Europe/Zurich"),
("2660292", "Hünenberg", "", "CH", "756", "", "ZG", "900", "1703", "47.17536", "8.42497", "Europe/Zurich"),
("2660298", "Horw", "", "CH", "756", "", "LU", "312", "1059", "47.01692", "8.30956", "Europe/Zurich"),
("2660305", "Horgen", "Хорген", "CH", "756", "", "ZH", "106", "133", "47.25983", "8.59778", "Europe/Zurich"),
("2660306", "Zürich (Kreis 10) / Höngg", "", "CH", "756", "", "ZH", "112", "261", "47.40313", "8.4971", "Europe/Zurich"),
("2660332", "Hochdorf", "", "CH", "756", "", "LU", "313", "1031", "47.16841", "8.29179", "Europe/Zurich"),
("2660338", "Hinwil", "", "CH", "756", "", "ZH", "105", "117", "47.29426", "8.84393", "Europe/Zurich"),
("2660355", "Herzogenbuchsee", "", "CH", "756", "", "BE", "244", "979", "47.18795", "7.7062", "Europe/Zurich"),
("2660359", "Herrliberg", "", "CH", "756", "", "ZH", "107", "152", "47.29064", "8.61464", "Europe/Zurich"),
("2660365", "Herisau", "Херизау", "CH", "756", "", "AR", "1501", "3001", "47.38615", "9.27916", "Europe/Zurich"),
("2660367", "Hergiswil", "", "CH", "756", "", "NW", "700", "1507", "46.98429", "8.30944", "Europe/Zurich"),
("2660390", "Heimberg", "", "CH", "756", "", "BE", "247", "928", "46.79482", "7.60433", "Europe/Zurich"),
("2660461", "Gstaad", "", "CH", "756", "", "BE", "248", "843", "46.47215", "7.28685", "Europe/Zurich"),
("2660512", "Grenchen", "Гренхен", "CH", "756", "", "SO", "1107", "2546", "47.1921", "7.39586", "Europe/Zurich"),
("2660515", "Greifensee", "", "CH", "756", "", "ZH", "109", "194", "47.36717", "8.68115", "Europe/Zurich"),
("2660523", "Gränichen", "", "CH", "756", "", "AG", "1901", "4006", "47.3593", "8.10243", "Europe/Zurich"),
("2660532", "Le Grand-Saconnex", "", "CH", "756", "", "GE", "2500", "6634", "46.23188", "6.12091", "Europe/Zurich"),
("2660543", "Grabs", "", "CH", "756", "", "SG", "1724", "3273", "47.18248", "9.44395", "Europe/Zurich"),
("2660549", "Gossau", "Госсау", "CH", "756", "", "SG", "1721", "3443", "47.41551", "9.25482", "Europe/Zurich"),
("2660573", "Goldau", "", "CH", "756", "", "SZ", "506", "1362", "47.04761", "8.54616", "Europe/Zurich"),
("2660575", "Goldach", "", "CH", "756", "", "SG", "1722", "3213", "47.47401", "9.46711", "Europe/Zurich"),
("2660594", "Glarus", "", "CH", "756", "", "GL", "800", "1632", "47.04057", "9.06804", "Europe/Zurich"),
("2660600", "Gland", "", "CH", "756", "", "VD", "2228", "5721", "46.42082", "6.2701", "Europe/Zurich"),
("2660603", "Giubiasco", "", "CH", "756", "", "TI", "2101", "5005", "46.17246", "9.00793", "Europe/Zurich"),
("2660646", "Genève", "Женева", "CH", "756", "", "GE", "2500", "6621", "46.20222", "6.14569", "Europe/Zurich"),
("2660656", "Gelterkinden", "", "CH", "756", "", "BL", "1304", "2846", "47.46497", "7.85174", "Europe/Zurich"),
("2660700", "Fully", "", "CH", "756", "", "VS", "2307", "6133", "46.13851", "7.11468", "Europe/Zurich"),
("2660707", "Frutigen", "", "CH", "756", "", "BE", "249", "563", "46.58723", "7.64945", "Europe/Zurich"),
("2660718", "Fribourg", "Фрибур", "CH", "756", "", "FR", "1004", "2196", "46.80237", "7.15128", "Europe/Zurich"),
("2660719", "Frenkendorf", "", "CH", "756", "", "BL", "1303", "2824", "47.50686", "7.71648", "Europe/Zurich"),
("2660721", "Freienbach", "", "CH", "756", "", "SZ", "503", "1322", "47.20534", "8.75842", "Europe/Zurich"),
("2660727", "Frauenfeld", "Фрауэнфельд", "CH", "756", "", "TG", "2012", "4566", "47.55776", "8.89893", "Europe/Zurich"),
("2660762", "Flawil", "", "CH", "756", "", "SG", "1728", "3402", "47.41301", "9.18324", "Europe/Zurich"),
("2660851", "Estavayer-le-Lac", "", "CH", "756", "", "FR", "1001", "2015", "46.84876", "6.8465", "Europe/Zurich"),
("2660860", "Eschenbach", "", "CH", "756", "", "SG", "1726", "3342", "47.23981", "8.92156", "Europe/Zurich"),
("2660884", "Epalinges", "", "CH", "756", "", "VD", "2225", "5584", "46.54896", "6.66831", "Europe/Zurich"),
("2660911", "Emmen", "Эммен", "CH", "756", "", "LU", "313", "1024", "47.08615", "8.30046", "Europe/Zurich"),
("2660913", "Embrach", "", "CH", "756", "", "ZH", "103", "56", "47.50561", "8.59406", "Europe/Zurich"),
("2660925", "Einsiedeln", "", "CH", "756", "", "SZ", "501", "1301", "47.12849", "8.74735", "Europe/Zurich"),
("2660944", "Effretikon", "", "CH", "756", "", "ZH", "108", "174", "47.42575", "8.69094", "Europe/Zurich"),
("2660947", "Ecublens", "", "CH", "756", "", "FR", "1002", "2072", "46.60735", "6.80895", "Europe/Zurich"),
("2660953", "Ebikon", "", "CH", "756", "", "LU", "312", "1054", "47.07937", "8.34041", "Europe/Zurich"),
("2660970", "Düdingen", "", "CH", "756", "", "FR", "1006", "2293", "46.84915", "7.18848", "Europe/Zurich"),
("2660971", "Dübendorf", "", "CH", "756", "", "ZH", "109", "191", "47.39724", "8.61872", "Europe/Zurich"),
("2660989", "Dornach", "", "CH", "756", "", "SO", "1104", "2473", "47.48038", "7.61644", "Europe/Zurich"),
("2661001", "Domat", "", "CH", "756", "", "GR", "1824", "3722", "46.83483", "9.45075", "Europe/Zurich"),
("2661014", "Dietlikon / Dietlikon (Dorf)", "", "CH", "756", "", "ZH", "103", "54", "47.41827", "8.6188", "Europe/Zurich"),
("2661015", "Dietikon", "", "CH", "756", "", "ZH", "111", "243", "47.40165", "8.40015", "Europe/Zurich"),
("2661021", "Diepoldsau", "", "CH", "756", "", "SG", "1723", "3234", "47.386", "9.65558", "Europe/Zurich"),
("2661030", "Derendingen", "", "CH", "756", "", "SO", "1106", "2517", "47.1985", "7.58844", "Europe/Zurich"),
("2661035", "Delémont", "", "CH", "756", "", "JU", "2601", "6711", "47.36493", "7.34453", "Europe/Zurich"),
("2661039", "Davos", "", "CH", "756", "", "GR", "1830", "3851", "46.80429", "9.83723", "Europe/Zurich"),
("2661072", "Crissier", "", "CH", "756", "", "VD", "2229", "5583", "46.54586", "6.57567", "Europe/Zurich"),
("2661129", "Conthey", "", "CH", "756", "", "VS", "2302", "6023", "46.2237", "7.30283", "Europe/Zurich"),
("2661144", "Colombier", "", "CH", "756", "", "VD", "2227", "5634", "46.55709", "6.47284", "Europe/Zurich"),
("2661148", "Collombey", "", "CH", "756", "", "VS", "2308", "6152", "46.27385", "6.94789", "Europe/Zurich"),
("2661169", "Chur", "Кур", "CH", "756", "", "GR", "1829", "3901", "46.84986", "9.53287", "Europe/Zurich"),
("2661176", "Chiasso", "", "CH", "756", "", "TI", "2106", "5250", "45.83203", "9.03119", "Europe/Zurich"),
("2661191", "Chêne-Bourg", "", "CH", "756", "", "GE", "2500", "6613", "46.19534", "6.19406", "Europe/Zurich"),
("2661197", "Chavannes", "", "CH", "756", "", "VD", "2229", "5627", "46.53005", "6.57068", "Europe/Zurich"),
("2661202", "Châtel-Saint-Denis", "", "CH", "756", "", "FR", "1007", "2325", "46.52691", "6.90083", "Europe/Zurich"),
("2661228", "Cham", "", "CH", "756", "", "ZG", "900", "1702", "47.18213", "8.46358", "Europe/Zurich"),
("2661265", "Carouge", "Каруж", "CH", "756", "", "GE", "2500", "6608", "46.18096", "6.13921", "Europe/Zurich"),
("2661305", "Bussigny", "", "CH", "756", "", "VD", "2229", "5583", "46.5511", "6.55597", "Europe/Zurich"),
("2661321", "Burgdorf", "", "CH", "756", "", "BE", "245", "404", "47.05901", "7.62786", "Europe/Zurich"),
("2661328", "Buochs", "", "CH", "756", "", "NW", "700", "1502", "46.97398", "8.42279", "Europe/Zurich"),
("2661337", "Bulle", "", "CH", "756", "", "FR", "1003", "2125", "46.61797", "7.0569", "Europe/Zurich"),
("2661338", "Bülach", "", "CH", "756", "", "ZH", "103", "53", "47.52197", "8.54049", "Europe/Zurich"),
("2661348", "Buchs", "", "CH", "756", "", "AG", "1901", "4003", "47.39358", "8.08233", "Europe/Zurich"),
("2661349", "Buchs", "", "CH", "756", "CH,", "SG", "1724", "3271", "47.16743", "9.47794", "Europe/Zurich"),
("2661350", "Buchrain", "", "CH", "756", "", "LU", "312", "1052", "47.09625", "8.34729", "Europe/Zurich"),
("2661374", "Brugg", "", "CH", "756", "", "AG", "1904", "4095", "47.48096", "8.20869", "Europe/Zurich"),
("2661407", "Bremgarten", "", "CH", "756", "", "AG", "1903", "4063", "47.35109", "8.34214", "Europe/Zurich"),
("2661432", "Bottmingen", "", "CH", "756", "", "BL", "1301", "2767", "47.52343", "7.57211", "Europe/Zurich"),
("2661456", "Bolligen", "", "CH", "756", "", "BE", "246", "352", "46.9751", "7.49697", "Europe/Zurich"),
("2661468", "Blonay", "", "CH", "756", "", "VD", "2230", "5881", "46.46778", "6.89615", "Europe/Zurich"),
("2661490", "Birsfelden", "", "CH", "756", "", "BL", "1301", "2766", "47.5529", "7.62322", "Europe/Zurich"),
("2661499", "Binningen", "", "CH", "756", "", "BL", "1301", "2765", "47.54021", "7.56932", "Europe/Zurich"),
("2661513", "Biel/Bienne", "Биль", "CH", "756", "", "BE", "242", "371", "47.13713", "7.24608", "Europe/Zurich"),
("2661519", "Biberist", "", "CH", "756", "", "SO", "1106", "2513", "47.18009", "7.56246", "Europe/Zurich"),
("2661524", "Biasca", "", "CH", "756", "", "TI", "2107", "5281", "46.35972", "8.96965", "Europe/Zurich"),
("2661527", "Bex", "", "CH", "756", "", "VD", "2221", "5402", "46.24965", "7.0098", "Europe/Zurich"),
("2661547", "Bernex", "", "CH", "756", "", "GE", "2500", "6607", "46.1765", "6.07544", "Europe/Zurich"),
("2661552", "Bern", "Берн", "CH", "756", "", "BE", "246", "351", "46.94809", "7.44744", "Europe/Zurich"),
("2661563", "Belp", "", "CH", "756", "", "BE", "246", "861", "46.89129", "7.49825", "Europe/Zurich"),
("2661567", "Bellinzona", "Беллинцона", "CH", "756", "", "TI", "2101", "5002", "46.19278", "9.01703", "Europe/Zurich"),
("2661599", "Bassersdorf", "", "CH", "756", "", "ZH", "103", "52", "47.44342", "8.62851", "Europe/Zurich"),
("2661600", "Basse-Nendaz", "", "CH", "756", "", "VS", "2302", "6024", "46.18993", "7.31209", "Europe/Zurich"),
("2661604", "Basel", "Базель", "CH", "756", "", "BS", "1200", "2701", "47.55839", "7.57327", "Europe/Zurich"),
("2661626", "Balsthal", "", "CH", "756", "", "SO", "1102", "2422", "47.31613", "7.69318", "Europe/Zurich"),
("2661641", "Bagnes", "", "CH", "756", "", "VS", "2303", "6031", "46.08333", "7.21667", "Europe/Zurich"),
("2661644", "Bad Ragaz", "", "CH", "756", "", "SG", "1725", "3291", "47.00601", "9.50266", "Europe/Zurich"),
("2661646", "Baden", "Баден", "CH", "756", "", "AG", "1902", "4021", "47.47333", "8.30592", "Europe/Zurich"),
("2661653", "Baar", "Бар", "CH", "756", "", "ZG", "900", "1701", "47.19625", "8.52954", "Europe/Zurich"),
("2661666", "Zürich (Kreis 4) / Aussersihl", "", "CH", "756", "", "ZH", "112", "261", "47.37752", "8.52127", "Europe/Zurich"),
("2661689", "Au", "", "CH", "756", "", "SG", "1723", "3233", "47.43093", "9.63448", "Europe/Zurich"),
("2661698", "Ascona", "", "CH", "756", "", "TI", "2104", "5091", "46.15451", "8.77327", "Europe/Zurich"),
("2661708", "Arth", "", "CH", "756", "", "SZ", "506", "1362", "47.06337", "8.52349", "Europe/Zurich"),
("2661719", "Arlesheim", "", "CH", "756", "", "BL", "1301", "2763", "47.49412", "7.61979", "Europe/Zurich"),
("2661731", "Arbon", "", "CH", "756", "", "TG", "2011", "4401", "47.51667", "9.43333", "Europe/Zurich"),
("2661740", "Appenzell", "", "CH", "756", "", "AI", "1600", "3101", "47.33103", "9.40996", "Europe/Zurich"),
("2661756", "Amriswil", "", "CH", "756", "", "TG", "2011", "4461", "47.54699", "9.29586", "Europe/Zurich"),
("2661766", "Altstätten", "", "CH", "756", "", "SG", "1723", "3251", "47.37766", "9.54746", "Europe/Zurich"),
("2661776", "Altendorf", "", "CH", "756", "", "SZ", "505", "1341", "47.18994", "8.83823", "Europe/Zurich"),
("2661780", "Altdorf", "", "CH", "756", "", "UR", "400", "1201", "46.88042", "8.64441", "Europe/Zurich"),
("2661789", "Alpnach", "", "CH", "756", "", "OW", "600", "1401", "46.94227", "8.2718", "Europe/Zurich"),
("2661810", "Allschwil", "Альшвиль", "CH", "756", "", "BL", "1301", "2762", "47.55074", "7.53599", "Europe/Zurich"),
("2661834", "Aigle", "", "CH", "756", "", "VD", "2221", "5401", "46.3181", "6.96457", "Europe/Zurich"),
("2661842", "Affoltern am Albis", "", "CH", "756", "", "ZH", "101", "2", "47.27743", "8.45128", "Europe/Zurich"),
("2661852", "Aesch", "", "CH", "756", "", "BL", "1301", "2761", "47.47104", "7.5973", "Europe/Zurich"),
("2661861", "Adliswil", "", "CH", "756", "", "ZH", "106", "131", "47.30997", "8.52462", "Europe/Zurich"),
("2661862", "Adligenswil", "", "CH", "756", "", "LU", "312", "1051", "47.06521", "8.36124", "Europe/Zurich"),
("2661879", "Aarburg", "", "CH", "756", "", "AG", "1910", "4271", "47.32067", "7.89986", "Europe/Zurich"),
("2661881", "Aarau", "Арау", "CH", "756", "", "AG", "1901", "4001", "47.39254", "8.04422", "Europe/Zurich"),
("2661882", "Aadorf", "", "CH", "756", "", "TG", "2014", "4551", "47.49204", "8.90099", "Europe/Zurich"),
("3206590", "Riehen", "Риен", "CH", "756", "", "BS", "1200", "2703", "47.57884", "7.64683", "Europe/Zurich"),
("3209498", "Chêne-Bougeries", "", "CH", "756", "", "GE", "2500", "6612", "46.19843", "6.18642", "Europe/Zurich"),
("3209505", "Thônex", "", "CH", "756", "", "GE", "2500", "6640", "46.18815", "6.19904", "Europe/Zurich"),
("6285791", "Ecublens", "", "CH", "756", "", "VD", "2229", "5635", "46.52899", "6.56261", "Europe/Zurich"),
("6291374", "Wallisellen / Wallisellen-Ost", "", "CH", "756", "", "ZH", "103", "69", "47.41446", "8.59727", "Europe/Zurich"),
("6292757", "Horgen / Horgen (Dorfkern)", "", "CH", "756", "", "ZH", "106", "133", "47.25604", "8.60159", "Europe/Zurich"),
("6293080", "Thalwil / Dorfkern", "", "CH", "756", "", "ZH", "106", "141", "47.29047", "8.56633", "Europe/Zurich"),
("6293977", "Pfäffikon / Pfäffikon (Dorfkern)", "", "CH", "756", "", "ZH", "108", "177", "47.36943", "8.78309", "Europe/Zurich"),
("6294547", "Uster / Kirch-Uster", "", "CH", "756", "", "ZH", "109", "198", "47.34579", "8.71839", "Europe/Zurich"),
("6294550", "Uster / Ober-Uster", "", "CH", "756", "", "ZH", "109", "198", "47.34874", "8.73319", "Europe/Zurich"),
("6295092", "Oberwinterthur (Kreis 2) / Talacker", "", "CH", "756", "", "ZH", "110", "230", "47.50596", "8.7515", "Europe/Zurich"),
("6295102", "Oberwinterthur (Kreis 2) / Guggenbühl", "", "CH", "756", "", "ZH", "110", "230", "47.51339", "8.75998", "Europe/Zurich"),
("6295183", "Mattenbach (Kreis 7) / Deutweg", "", "CH", "756", "", "ZH", "110", "230", "47.49419", "8.73948", "Europe/Zurich"),
("6295475", "Zürich (Kreis 10) / Wipkingen", "", "CH", "756", "", "ZH", "112", "261", "47.39503", "8.52529", "Europe/Zurich"),
("6295484", "Zürich (Kreis 11) / Affoltern", "", "CH", "756", "", "ZH", "112", "261", "47.41814", "8.5122", "Europe/Zurich"),
("6295490", "Zürich (Kreis 12) / Saatlen", "", "CH", "756", "", "ZH", "112", "261", "47.41127", "8.5648", "Europe/Zurich"),
("6295491", "Zürich (Kreis 12) / Schwamendingen-Mitte", "", "CH", "756", "", "ZH", "112", "261", "47.4063", "8.57242", "Europe/Zurich"),
("6295492", "Zürich (Kreis 12) / Hirzenbach", "", "CH", "756", "", "ZH", "112", "261", "47.40187", "8.58633", "Europe/Zurich"),
("6295495", "Zürich (Kreis 2) / Wollishofen", "", "CH", "756", "", "ZH", "112", "261", "47.3401", "8.53134", "Europe/Zurich"),
("6295496", "Zürich (Kreis 2) / Enge", "", "CH", "756", "", "ZH", "112", "261", "47.3605", "8.53127", "Europe/Zurich"),
("6295497", "Zürich (Kreis 3) / Friesenberg", "", "CH", "756", "", "ZH", "112", "261", "47.36372", "8.50417", "Europe/Zurich"),
("6295498", "Zürich (Kreis 3) / Sihlfeld", "", "CH", "756", "", "ZH", "112", "261", "47.37382", "8.51164", "Europe/Zurich"),
("6295500", "Zürich (Kreis 4) / Langstrasse", "", "CH", "756", "", "ZH", "112", "261", "47.37767", "8.52854", "Europe/Zurich"),
("6295501", "Zürich (Kreis 4) / Hard", "", "CH", "756", "", "ZH", "112", "261", "47.38311", "8.50942", "Europe/Zurich"),
("6295502", "Zürich (Kreis 5) / Gewerbeschule", "", "CH", "756", "", "ZH", "112", "261", "47.38481", "8.53011", "Europe/Zurich"),
("6295504", "Zürich (Kreis 6) / Unterstrass", "", "CH", "756", "", "ZH", "112", "261", "47.3953", "8.53721", "Europe/Zurich"),
("6295505", "Zürich (Kreis 6) / Oberstrass", "", "CH", "756", "", "ZH", "112", "261", "47.38917", "8.5504", "Europe/Zurich"),
("6295506", "Zürich (Kreis 7) / Fluntern", "", "CH", "756", "", "ZH", "112", "261", "47.38013", "8.56133", "Europe/Zurich"),
("6295507", "Zürich (Kreis 7) / Hottingen", "", "CH", "756", "", "ZH", "112", "261", "47.37011", "8.56306", "Europe/Zurich"),
("6295508", "Zürich (Kreis 7) / Hirslanden", "", "CH", "756", "", "ZH", "112", "261", "47.3624", "8.56755", "Europe/Zurich"),
("6295510", "Zürich (Kreis 8) / Mühlebach", "", "CH", "756", "", "ZH", "112", "261", "47.35727", "8.55744", "Europe/Zurich"),
("6295512", "Zürich (Kreis 9) / Albisrieden", "", "CH", "756", "", "ZH", "112", "261", "47.37398", "8.49007", "Europe/Zurich"),
("6295513", "Zürich (Kreis 9) / Altstetten", "", "CH", "756", "", "ZH", "112", "261", "47.38946", "8.48533", "Europe/Zurich"),
("6295517", "Hegnau", "", "CH", "756", "", "ZH", "109", "199", "47.39227", "8.66988", "Europe/Zurich"),
("6295520", "Stadt Winterthur (Kreis 1)", "", "CH", "756", "", "ZH", "110", "230", "47.49494", "8.71954", "Europe/Zurich"),
("6295521", "Zürich (Kreis 5)", "", "CH", "756", "", "ZH", "112", "261", "47.38767", "8.52152", "Europe/Zurich"),
("6295523", "Zürich (Kreis 12)", "", "CH", "756", "", "ZH", "112", "261", "47.40372", "8.57608", "Europe/Zurich"),
("6295524", "Wülflingen (Kreis 6)", "", "CH", "756", "", "ZH", "110", "230", "47.51036", "8.68333", "Europe/Zurich"),
("6295531", "Seen (Kreis 3)", "", "CH", "756", "", "ZH", "110", "230", "47.47646", "8.76996", "Europe/Zurich"),
("6295532", "Zürich (Kreis 3)", "", "CH", "756", "", "ZH", "112", "261", "47.35785", "8.50296", "Europe/Zurich"),
("6295533", "Zürich (Kreis 11)", "", "CH", "756", "", "ZH", "112", "261", "47.42326", "8.52166", "Europe/Zurich"),
("6295534", "Zürich (Kreis 9)", "", "CH", "756", "", "ZH", "112", "261", "47.38245", "8.47993", "Europe/Zurich"),
("6295536", "Oberwinterthur (Kreis 2)", "", "CH", "756", "", "ZH", "110", "230", "47.51692", "8.76863", "Europe/Zurich"),
("6295539", "Zürich (Kreis 10)", "", "CH", "756", "", "ZH", "112", "261", "47.40773", "8.5005", "Europe/Zurich"),
("6295540", "Zürich (Kreis 2)", "", "CH", "756", "", "ZH", "112", "261", "47.33756", "8.5211", "Europe/Zurich"),
("6295542", "Zürich (Kreis 8)", "", "CH", "756", "", "ZH", "112", "261", "47.3548", "8.56097", "Europe/Zurich"),
("6295546", "Zürich (Kreis 1)", "", "CH", "756", "", "ZH", "112", "261", "47.37055", "8.54177", "Europe/Zurich"),
("6295547", "Mattenbach (Kreis 7)", "", "CH", "756", "", "ZH", "110", "230", "47.48705", "8.74681", "Europe/Zurich"),
("6295548", "Zürich (Kreis 7)", "", "CH", "756", "", "ZH", "112", "261", "47.37328", "8.58038", "Europe/Zurich"),
("6295550", "Zürich (Kreis 6)", "", "CH", "756", "", "ZH", "112", "261", "47.39223", "8.54381", "Europe/Zurich"),
("6620245", "Thal", "", "CH", "756", "", "SG", "1722", "3237", "47.46677", "9.56643", "Europe/Zurich"),
("6640317", "Langnau am Albis", "", "CH", "756", "", "ZH", "106", "136", "47.28885", "8.5411", "Europe/Zurich"),
("6691640", "Lancy", "Ланси", "CH", "756", "", "GE", "2500", "6628", "46.18981", "6.11441", "Europe/Zurich"),
("7779000", "Les Avanchets", "", "CH", "756", "", "GE", "2500", "6643", "46.22168", "6.10814", "Europe/Zurich"),
("8521688", "Blécherette", "", "CH", "756", "", "VD", "2225", "5586", "46.53932", "6.62227", "Europe/Zurich"),
("2279172", "Zuénoula", "", "CI", "385", "", "96", "11153167", "", "7.43027", "-6.05054", "Africa/Abidjan"),
("2279755", "Yamoussoukro", "Ямусукро", "CI", "385", "", "81", "", "", "6.82055", "-5.27674", "Africa/Abidjan"),
("2280045", "Vavoua", "Вавуа", "CI", "385", "", "96", "11153166", "", "7.38194", "-6.47778", "Africa/Abidjan"),
("2280316", "Toumodi", "", "CI", "385", "", "81", "", "", "6.55799", "-5.01769", "Africa/Abidjan"),
("2280333", "Toulépleu Gueré", "", "CI", "385", "", "78", "", "", "6.57395", "-8.42592", "Africa/Abidjan"),
("2280376", "Touba", "", "CI", "385", "", "97", "2597334", "", "8.28333", "-7.68333", "Africa/Abidjan"),
("2280589", "Tengréla", "", "CI", "385", "", "87", "", "", "10.48115", "-6.40694", "Africa/Abidjan"),
("2280761", "Tiassalé", "", "CI", "385", "", "82", "", "", "5.89839", "-4.82293", "Africa/Abidjan"),
("2280995", "Tanda", "", "CI", "385", "", "92", "", "", "7.80335", "-3.16832", "Africa/Abidjan"),
("2281120", "Tabou", "", "CI", "385", "", "76", "", "", "4.42295", "-7.3528", "Africa/Abidjan"),
("2281606", "Sinfra", "", "CI", "385", "", "92", "", "", "6.62103", "-5.91144", "Africa/Abidjan"),
("2281951", "Sassandra", "Сассандра", "CI", "385", "", "76", "", "", "4.95384", "-6.08531", "Africa/Abidjan"),
("2282006", "San-Pédro", "", "CI", "385", "", "76", "", "", "4.74851", "-6.6363", "Africa/Abidjan"),
("2282178", "Sakassou", "", "CI", "385", "", "90", "", "", "7.45462", "-5.29263", "Africa/Abidjan"),
("2282827", "Oumé", "", "CI", "385", "", "95", "11153083", "", "6.38309", "-5.41759", "Africa/Abidjan"),
("2283016", "Odienné", "Одиенне", "CI", "385", "", "77", "", "", "9.50511", "-7.56433", "Africa/Abidjan"),
("2284589", "Mankono", "", "CI", "385", "", "97", "11153172", "", "8.05861", "-6.18972", "Africa/Abidjan"),
("2284647", "Man", "", "CI", "385", "", "78", "", "", "7.41251", "-7.55383", "Africa/Abidjan"),
("2285449", "Lakota", "Лакота", "CI", "385", "", "95", "11153153", "", "5.84752", "-5.682", "Africa/Abidjan"),
("2286304", "Korhogo", "Корого", "CI", "385", "", "87", "", "", "9.45803", "-5.62961", "Africa/Abidjan"),
("2287298", "Katiola", "", "CI", "385", "", "90", "11153171", "2287296", "8.13728", "-5.10095", "Africa/Abidjan"),
("2287790", "Issia", "", "CI", "385", "", "96", "11153166", "", "6.49224", "-6.58558", "Africa/Abidjan"),
("2287958", "Guiglo", "", "CI", "385", "", "78", "", "", "6.54368", "-7.4935", "Africa/Abidjan"),
("2287970", "Guibéroua", "", "CI", "385", "", "95", "", "", "6.23869", "-6.17147", "Africa/Abidjan"),
("2288105", "Grand-Lahou", "", "CI", "385", "", "82", "", "", "5.25068", "-5.00333", "Africa/Abidjan"),
("2288115", "Grand-Bassam", "Гран-Бассам", "CI", "385", "", "94", "11153079", "", "5.2118", "-3.73884", "Africa/Abidjan"),
("2288118", "Affery", "", "CI", "385", "", "82", "", "", "6.32035", "-3.95235", "Africa/Abidjan"),
("2288829", "Gagnoa", "", "CI", "385", "", "95", "", "", "6.13193", "-5.9506", "Africa/Abidjan"),
("2289049", "Ferkessédougou", "Феркеседугу", "CI", "385", "", "87", "", "", "9.5928", "-5.19449", "Africa/Abidjan"),
("2289549", "Duekoué", "", "CI", "385", "", "78", "", "", "6.74202", "-7.34918", "Africa/Abidjan"),
("2289887", "Divo", "", "CI", "385", "", "95", "", "", "5.83739", "-5.35723", "Africa/Abidjan"),
("2289983", "Dimbokro", "", "CI", "385", "", "81", "", "", "6.64678", "-4.70519", "Africa/Abidjan"),
("2290412", "Daoukro", "Даукро", "CI", "385", "", "81", "11153155", "", "7.0591", "-3.9631", "Africa/Abidjan"),
("2290462", "Danané", "Данане", "CI", "385", "", "78", "", "", "7.25957", "-8.15498", "Africa/Abidjan"),
("2290486", "Daloa", "Далоа", "CI", "385", "", "96", "", "", "6.87735", "-6.45022", "Africa/Abidjan"),
("2290582", "Dabou", "Даб", "CI", "385", "", "82", "", "", "5.32556", "-4.37685", "Africa/Abidjan"),
("2290609", "Dabakala", "", "CI", "385", "", "90", "", "", "8.36321", "-4.42863", "Africa/Abidjan"),
("2290836", "Boundiali", "Бундиали", "CI", "385", "", "87", "11153168", "", "9.52167", "-6.48694", "Africa/Abidjan"),
("2290849", "Bouna", "Буна", "CI", "385", "", "92", "", "", "9.26927", "-2.9951", "Africa/Abidjan"),
("2290956", "Bouaké", "Буаке", "CI", "385", "", "90", "", "", "7.69385", "-5.03031", "Africa/Abidjan"),
("2290964", "Bouaflé", "", "CI", "385", "", "96", "11153167", "", "6.99041", "-5.7442", "Africa/Abidjan"),
("2290985", "Botro", "", "CI", "385", "", "90", "", "", "7.85249", "-5.31063", "Africa/Abidjan"),
("2291087", "Bonoua", "", "CI", "385", "", "89", "", "", "5.27247", "-3.59625", "Africa/Abidjan"),
("2291113", "Bongouanou", "", "CI", "385", "", "81", "", "", "6.65175", "-4.20406", "Africa/Abidjan"),
("2291136", "Bondoukou", "Бондуку", "CI", "385", "", "92", "", "", "8.0402", "-2.80003", "Africa/Abidjan"),
("2291383", "Bocanda", "", "CI", "385", "", "81", "", "", "7.06264", "-4.49948", "Africa/Abidjan"),
("2291580", "Bingerville", "", "CI", "385", "", "93", "", "", "5.35581", "-3.88537", "Africa/Abidjan"),
("2291666", "Biankouma", "", "CI", "385", "", "78", "", "", "7.73909", "-7.61377", "Africa/Abidjan"),
("2291779", "Béoumi", "", "CI", "385", "", "90", "", "", "7.67395", "-5.58085", "Africa/Abidjan"),
("2292179", "Bangolo", "", "CI", "385", "", "78", "11153164", "2292178", "7.01232", "-7.48639", "Africa/Abidjan"),
("2292542", "Ayamé", "", "CI", "385", "", "94", "", "", "5.6052", "-3.15709", "Africa/Abidjan"),
("2292755", "Arrah", "", "CI", "385", "", "81", "11153156", "", "6.67342", "-3.96938", "Africa/Abidjan"),
("2292852", "Anyama", "Аньяме", "CI", "385", "", "93", "", "", "5.49462", "-4.05183", "Africa/Abidjan"),
("2293107", "Akoupé", "", "CI", "385", "", "82", "11153162", "", "6.38423", "-3.88759", "Africa/Abidjan"),
("2293260", "Agnibilékrou", "", "CI", "385", "", "94", "11153078", "", "7.13113", "-3.20415", "Africa/Abidjan"),
("2293268", "Agboville", "Агбовиле", "CI", "385", "", "82", "11153160", "", "5.92801", "-4.21319", "Africa/Abidjan"),
("2293342", "Adzopé", "Адзопе", "CI", "385", "", "82", "", "", "6.10694", "-3.86194", "Africa/Abidjan"),
("2293428", "Adiaké", "", "CI", "385", "", "94", "", "", "5.28634", "-3.30403", "Africa/Abidjan"),
("2293507", "Aboisso", "Абуассо", "CI", "385", "", "94", "", "", "5.46779", "-3.20711", "Africa/Abidjan"),
("2293521", "Abobo", "", "CI", "385", "", "93", "", "", "5.41613", "-4.0159", "Africa/Abidjan"),
("2293538", "Abidjan", "Абиджан", "CI", "385", "", "93", "", "", "5.30966", "-4.01266", "Africa/Abidjan"),
("2293549", "Abengourou", "Абенгуру", "CI", "385", "", "94", "11153078", "", "6.72972", "-3.49639", "Africa/Abidjan"),
("2596934", "Séguéla", "Сегеле", "CI", "385", "", "97", "", "", "7.96111", "-6.67306", "Africa/Abidjan"),
("2598243", "Soubré", "", "CI", "385", "", "76", "", "", "5.78556", "-6.60833", "Africa/Abidjan"),
("2220849", "Yoko", "", "CM", "120", "", "11", "", "", "5.53333", "12.31667", "Africa/Douala"),
("2220853", "Yokadouma", "", "CM", "120", "", "04", "", "", "3.51667", "15.05", "Africa/Douala"),
("2220957", "Yaoundé", "Яунде", "CM", "120", "", "11", "", "", "3.86667", "11.51667", "Africa/Douala"),
("2221030", "Yagoua", "", "CM", "120", "", "12", "", "", "10.34107", "15.23288", "Africa/Douala"),
("2221046", "Yabassi", "", "CM", "120", "", "05", "", "", "4.45697", "9.96822", "Africa/Douala"),
("2221053", "Wum", "", "CM", "120", "", "07", "", "", "6.38333", "10.06667", "Africa/Douala"),
("2221394", "Tonga", "", "CM", "120", "", "08", "", "", "4.96667", "10.7", "Africa/Douala"),
("2221504", "Tiko", "", "CM", "120", "", "09", "", "", "4.075", "9.36005", "Africa/Douala"),
("2221530", "Tibati", "", "CM", "120", "", "10", "", "", "6.46504", "12.62843", "Africa/Douala"),
("2221607", "Tcholliré", "", "CM", "120", "", "13", "", "", "8.4022", "14.1698", "Africa/Douala"),
("2222230", "Sangmélima", "Сангмелима", "CM", "120", "", "14", "", "", "2.93333", "11.98333", "Africa/Douala"),
("2222366", "Saa", "", "CM", "120", "", "11", "", "", "4.36667", "11.45", "Africa/Douala"),
("2222439", "Rey Bouba", "", "CM", "120", "", "13", "", "", "8.6724", "14.1786", "Africa/Douala"),
("2222539", "Poli", "", "CM", "120", "", "13", "", "", "8.4756", "13.24097", "Africa/Douala"),
("2222568", "Pitoa", "", "CM", "120", "", "13", "", "", "9.3839", "13.50231", "Africa/Douala"),
("2222623", "Penja", "", "CM", "120", "", "05", "", "", "4.63911", "9.67987", "Africa/Douala"),
("2223216", "Okola", "", "CM", "120", "", "11", "", "", "4.01667", "11.38333", "Africa/Douala"),
("2223293", "Obala", "", "CM", "120", "", "11", "", "", "4.16667", "11.53333", "Africa/Douala"),
("2223421", "Ntui", "", "CM", "120", "", "11", "", "", "4.45", "11.63333", "Africa/Douala"),
("2223734", "Nkoteng", "", "CM", "120", "", "11", "", "", "4.51667", "12.03333", "Africa/Douala"),
("2223763", "Nkongsamba", "Нконгсамба", "CM", "120", "", "05", "", "", "4.9547", "9.9404", "Africa/Douala"),
("2224212", "Njinikom", "", "CM", "120", "", "07", "", "", "6.23333", "10.28333", "Africa/Douala"),
("2224413", "Nguti", "", "CM", "120", "", "09", "", "", "5.3299", "9.4185", "Africa/Douala"),
("2224827", "Ngaoundéré", "", "CM", "120", "", "10", "", "", "7.32765", "13.58472", "Africa/Douala"),
("2224863", "Ngambé", "", "CM", "120", "", "05", "2222269", "", "4.23343", "10.61532", "Africa/Douala"),
("2225263", "Ndikiniméki", "", "CM", "120", "", "11", "", "", "4.76667", "10.83333", "Africa/Douala"),
("2225325", "Ndelele", "", "CM", "120", "", "04", "", "", "4.04065", "14.92501", "Africa/Douala"),
("2225457", "Nanga Eboko", "", "CM", "120", "", "11", "", "", "4.68333", "12.36667", "Africa/Douala"),
("2225726", "Muyuka", "", "CM", "120", "", "09", "", "", "4.2898", "9.4103", "Africa/Douala"),
("2225728", "Mutengene", "", "CM", "120", "", "09", "", "", "4.0913", "9.3144", "Africa/Douala"),
("2225745", "Mundemba", "", "CM", "120", "", "09", "", "", "4.9479", "8.8724", "Africa/Douala"),
("2225991", "Mora", "Море", "CM", "120", "", "12", "", "", "11.04611", "14.14011", "Africa/Douala"),
("2226275", "Mokolo", "", "CM", "120", "", "12", "", "", "10.74244", "13.80227", "Africa/Douala"),
("2226441", "Mme-Bafumen", "", "CM", "120", "", "07", "", "", "6.33333", "10.23333", "Africa/Douala"),
("2226641", "Mindif", "", "CM", "120", "", "12", "", "", "10.39757", "14.43626", "Africa/Douala"),
("2227230", "Melong", "", "CM", "120", "", "05", "", "", "5.12181", "9.96143", "Africa/Douala"),
("2227402", "Meïganga", "Мейганге", "CM", "120", "", "10", "", "", "6.51667", "14.3", "Africa/Douala"),
("2227613", "Mbouda", "", "CM", "120", "", "08", "", "", "5.62611", "10.25421", "Africa/Douala"),
("2227853", "Mbengwi", "", "CM", "120", "", "07", "", "", "6.01667", "10", "Africa/Douala"),
("2228005", "Mbanga", "", "CM", "120", "", "05", "", "", "4.5016", "9.5671", "Africa/Douala"),
("2228028", "Mbandjok", "", "CM", "120", "", "11", "", "", "4.45", "11.9", "Africa/Douala"),
("2228079", "Mbalmayo", "Мбальмайо", "CM", "120", "", "11", "", "", "3.51667", "11.5", "Africa/Douala"),
("2228373", "Maroua", "Маруа", "CM", "120", "", "12", "", "", "10.59095", "14.31593", "Africa/Douala"),
("2228499", "Manjo", "", "CM", "120", "", "05", "", "", "4.8428", "9.8217", "Africa/Douala"),
("2228675", "Mamfe", "", "CM", "120", "", "09", "", "", "5.75132", "9.3137", "Africa/Douala"),
("2228881", "Makary", "", "CM", "120", "", "12", "", "", "12.57535", "14.45483", "Africa/Douala"),
("2229152", "Loum", "Лум", "CM", "120", "", "05", "", "", "4.7182", "9.7351", "Africa/Douala"),
("2229267", "Lolodorf", "", "CM", "120", "", "14", "", "", "3.23333", "10.73333", "Africa/Douala"),
("2229411", "Limbe", "Лимбе", "CM", "120", "", "09", "", "", "4.02356", "9.20607", "Africa/Douala"),
("2229681", "Lagdo", "", "CM", "120", "", "13", "", "", "9.05828", "13.66605", "Africa/Douala"),
("2229748", "Kumbo", "", "CM", "120", "", "07", "", "", "6.2", "10.66667", "Africa/Douala"),
("2229752", "Kumba", "Кумбой", "CM", "120", "", "09", "", "", "4.6363", "9.4469", "Africa/Douala"),
("2229761", "Kribi", "Криби", "CM", "120", "", "14", "", "", "2.93725", "9.90765", "Africa/Douala"),
("2229798", "Kousséri", "", "CM", "120", "", "12", "", "", "12.07689", "15.03063", "Africa/Douala"),
("2230028", "Kontcha", "", "CM", "120", "", "10", "", "", "7.96667", "12.23333", "Africa/Douala"),
("2230285", "Bankim", "", "CM", "120", "", "10", "", "", "6.08303", "11.4905", "Africa/Douala"),
("2230599", "Kaélé", "", "CM", "120", "", "12", "", "", "10.10917", "14.45083", "Africa/Douala"),
("2230641", "Jakiri", "", "CM", "120", "", "07", "", "", "6.1", "10.65", "Africa/Douala"),
("2230876", "Guider", "", "CM", "120", "", "13", "", "", "9.9333", "13.94671", "Africa/Douala"),
("2231319", "Garoua Boulaï", "", "CM", "120", "", "04", "", "", "5.88333", "14.55", "Africa/Douala"),
("2231320", "Garoua", "Гаруа", "CM", "120", "", "13", "", "", "9.30143", "13.39771", "Africa/Douala"),
("2231482", "Fundong", "", "CM", "120", "", "07", "", "", "6.25", "10.26667", "Africa/Douala"),
("2231504", "Foumbot", "", "CM", "120", "", "08", "", "", "5.50803", "10.6325", "Africa/Douala"),
("2231506", "Foumban", "", "CM", "120", "", "08", "", "", "5.72662", "10.89865", "Africa/Douala"),
("2231564", "Fontem", "", "CM", "120", "", "09", "", "", "5.4685", "9.8818", "Africa/Douala"),
("2231881", "Eséka", "", "CM", "120", "", "11", "", "", "3.65", "10.76667", "Africa/Douala"),
("2232239", "Edéa", "Эдеа", "CM", "120", "", "05", "", "", "3.8", "10.13333", "Africa/Douala"),
("2232283", "Ébolowa", "", "CM", "120", "", "14", "", "", "2.9", "11.15", "Africa/Douala"),
("2232444", "Dschang", "", "CM", "120", "", "08", "", "", "5.44397", "10.05332", "Africa/Douala"),
("2232497", "Doumé", "", "CM", "120", "", "04", "", "", "4.23333", "13.45", "Africa/Douala"),
("2232593", "Douala", "Дуала", "CM", "120", "", "05", "", "", "4.04827", "9.70428", "Africa/Douala"),
("2232997", "Dizangué", "", "CM", "120", "", "05", "", "", "3.76667", "9.98333", "Africa/Douala"),
("2233056", "Dimako", "", "CM", "120", "", "04", "", "", "4.38333", "13.56667", "Africa/Douala"),
("2233410", "Buea", "", "CM", "120", "", "09", "", "", "4.1527", "9.241", "Africa/Douala"),
("2233704", "Bonabéri", "", "CM", "120", "", "05", "", "", "4.0779", "9.6759", "Africa/Douala"),
("2233805", "Bogo", "", "CM", "120", "", "12", "", "", "10.7336", "14.60928", "Africa/Douala"),
("2234339", "Bétaré Oya", "", "CM", "120", "", "04", "", "", "5.6", "14.08333", "Africa/Douala"),
("2234359", "Bertoua", "Бертуа", "CM", "120", "", "04", "", "", "4.57728", "13.68459", "Africa/Douala"),
("2234455", "Belo", "", "CM", "120", "", "07", "", "", "6.13333", "10.25", "Africa/Douala"),
("2234520", "Bélel", "", "CM", "120", "", "10", "", "", "7.05", "14.43333", "Africa/Douala"),
("2234536", "Bélabo", "Белабо", "CM", "120", "", "04", "", "", "4.93333", "13.3", "Africa/Douala"),
("2234545", "Bekondo", "", "CM", "120", "", "09", "", "", "4.6819", "9.3214", "Africa/Douala"),
("2234635", "Bazou", "", "CM", "120", "", "08", "", "", "5.06001", "10.46751", "Africa/Douala"),
("2234663", "Batouri", "", "CM", "120", "", "04", "", "", "4.43333", "14.36667", "Africa/Douala"),
("2234684", "Batibo", "", "CM", "120", "", "07", "", "", "5.8358", "9.8553", "Africa/Douala"),
("2234794", "Banyo", "", "CM", "120", "", "10", "", "", "6.75", "11.81667", "Africa/Douala"),
("2234803", "Bansoa", "", "CM", "120", "", "08", "", "", "5.44836", "10.31355", "Africa/Douala"),
("2234842", "Ngou", "", "CM", "120", "", "08", "", "", "5.19685", "10.38595", "Africa/Douala"),
("2234865", "Bangangté", "", "CM", "120", "", "08", "", "", "5.14079", "10.52535", "Africa/Douala"),
("2234904", "Bandjoun", "", "CM", "120", "", "08", "", "", "5.37568", "10.41326", "Africa/Douala"),
("2234936", "Bana", "", "CM", "120", "", "08", "", "", "5.14655", "10.27545", "Africa/Douala"),
("2234941", "Bamusso", "", "CM", "120", "", "09", "", "", "4.4591", "8.9027", "Africa/Douala"),
("2234968", "Bamendjou", "", "CM", "120", "", "08", "", "", "5.38988", "10.33014", "Africa/Douala"),
("2234974", "Bamenda", "Баменды", "CM", "120", "", "07", "", "", "5.9597", "10.14597", "Africa/Douala"),
("2235029", "Bali", "Бали", "CM", "120", "", "07", "", "", "5.88737", "10.01176", "Africa/Douala"),
("2235189", "Bafoussam", "Бафуссама", "CM", "120", "", "08", "", "", "5.47775", "10.41759", "Africa/Douala"),
("2235194", "Bafia", "", "CM", "120", "", "11", "", "", "4.75", "11.23333", "Africa/Douala"),
("2235196", "Bafang", "", "CM", "120", "", "08", "", "", "5.15705", "10.1771", "Africa/Douala"),
("2235293", "Babanki", "", "CM", "120", "", "07", "", "", "6.11667", "10.25", "Africa/Douala"),
("2235660", "Ambam", "", "CM", "120", "", "14", "", "", "2.38333", "11.28333", "Africa/Douala"),
("2235776", "Akonolinga", "", "CM", "120", "", "11", "", "", "3.76667", "12.25", "Africa/Douala"),
("2235814", "Akom II", "", "CM", "120", "", "14", "", "", "2.78333", "10.56667", "Africa/Douala"),
("2236053", "Abong Mbang", "", "CM", "120", "", "04", "", "", "3.98333", "13.18333", "Africa/Douala"),
("2594800", "Idenao", "", "CM", "120", "", "09", "", "", "4.2475", "9.00472", "Africa/Douala"),
("2595172", "Ndom", "", "CM", "120", "", "05", "", "", "4.4978", "9.5628", "Africa/Douala"),
("1279524", "Zangguy", "", "CN", "156", "CN", "13", "", "", "37.28333", "78.76667", "Asia/Shanghai"),
("1279715", "Rikaze", "Шигадзе", "CN", "156", "", "14", "", "", "29.25", "88.88333", "Asia/Urumqi"),
("1279945", "Jiuquan", "Сучжоу", "CN", "156", "", "15", "", "", "39.74318", "98.51736", "Asia/Shanghai"),
("1280037", "Shache", "", "CN", "156", "", "13", "", "", "38.41667", "77.24056", "Asia/Shanghai"),
("1280281", "Qamdo", "", "CN", "156", "", "14", "", "", "31.1304", "97.17982", "Asia/Urumqi"),
("1280517", "Nagqu", "Нагчу", "CN", "156", "", "14", "", "", "31.47678", "92.05729", "Asia/Urumqi"),
("1280737", "Lhasa", "Лхаса", "CN", "156", "", "14", "", "", "29.65", "91.1", "Asia/Urumqi"),
("1280757", "Laojunmiao", "", "CN", "156", "", "15", "", "", "39.83333", "97.73333", "Asia/Shanghai"),
("1280849", "Kashgar", "Кашгар", "CN", "156", "", "13", "", "", "39.47066", "75.98951", "Asia/Shanghai"),
("1280957", "Jiayuguan", "Цзяюйгуань", "CN", "156", "", "15", "", "", "39.81121", "98.28618", "Asia/Shanghai"),
("1281019", "Hotan", "Хотан", "CN", "156", "", "13", "", "", "37.1075", "79.93548", "Asia/Shanghai"),
("1281119", "Jiangzi", "", "CN", "156", "", "14", "", "", "28.92026", "89.59956", "Asia/Urumqi"),
("1281368", "Dêqên", "Дечен", "CN", "156", "", "14", "", "", "29.96178", "90.71875", "Asia/Urumqi"),
("1281593", "Burang", "", "CN", "156", "", "14", "", "", "30.29559", "81.17511", "Asia/Shanghai"),
("1529102", "Ürümqi", "Урумчи", "CN", "156", "", "13", "", "", "43.80096", "87.60046", "Asia/Urumqi"),
("1529114", "Turpan", "Турфан", "CN", "156", "", "13", "", "", "42.94769", "89.17886", "Asia/Urumqi"),
("1529195", "Shihezi", "Шихэцзы", "CN", "156", "", "13", "", "", "44.3023", "86.03694", "Asia/Urumqi"),
("1529363", "Kuqa", "Куча", "CN", "156", "", "13", "", "", "41.72778", "82.93639", "Asia/Urumqi"),
("1529376", "Korla", "Корла", "CN", "156", "", "13", "", "", "41.76055", "86.15231", "Asia/Urumqi"),
("1529452", "Hoxtolgay", "", "CN", "156", "", "13", "", "", "46.51872", "86.00214", "Asia/Urumqi"),
("1529484", "Hami", "Хами", "CN", "156", "", "13", "", "", "42.83393", "93.50601", "Asia/Urumqi"),
("1529569", "Changji", "Чанцзи", "CN", "156", "", "13", "1529568", "", "44.00782", "87.30461", "Asia/Urumqi"),
("1529626", "Baijiantan", "", "CN", "156", "", "13", "", "", "45.68928", "85.12441", "Asia/Urumqi"),
("1529630", "Aykol", "", "CN", "156", "", "13", "", "", "40.95759", "80.13574", "Asia/Shanghai"),
("1529641", "Aral", "Аральское", "CN", "156", "", "13", "", "", "40.54184", "81.26566", "Asia/Shanghai"),
("1529651", "Altay", "Алтайская", "CN", "156", "", "13", "", "", "47.84864", "88.13361", "Asia/Urumqi"),
("1529660", "Aksu", "Аксу", "CN", "156", "", "13", "", "", "41.18418", "80.27921", "Asia/Shanghai"),
("1537890", "Sishilichengzi", "", "CN", "156", "CN", "13", "", "", "41.96194", "86.47667", "Asia/Urumqi"),
("1783621", "Zunyi", "Цзуньи", "CN", "156", "", "18", "", "", "27.68667", "106.90722", "Asia/Shanghai"),
("1783633", "Zoucheng", "", "CN", "156", "", "25", "", "", "35.40056", "116.96556", "Asia/Shanghai"),
("1783683", "Yanjiang", "Цзыян", "CN", "156", "", "32", "", "", "30.12108", "104.64811", "Asia/Shanghai"),
("1783745", "Zigong", "Цзыгун", "CN", "156", "", "32", "", "", "29.34162", "104.77689", "Asia/Shanghai"),
("1783763", "Zhuzhou", "Чжучжоу", "CN", "156", "", "11", "1783761", "", "27.83333", "113.15", "Asia/Shanghai"),
("1783873", "Zhumadian", "Чжумадянь", "CN", "156", "", "09", "", "", "32.97944", "114.02944", "Asia/Shanghai"),
("1783920", "Zhujiajiao", "", "CN", "156", "", "23", "", "", "31.10757", "121.05696", "Asia/Shanghai"),
("1783934", "Shangqiu", "Шанцю", "CN", "156", "", "09", "", "", "34.45", "115.65", "Asia/Shanghai"),
("1783940", "Zhuji", "", "CN", "156", "", "02", "", "", "29.71877", "120.24233", "Asia/Shanghai"),
("1783988", "Mizhou", "", "CN", "156", "", "25", "", "", "35.99472", "119.3975", "Asia/Shanghai"),
("1784055", "Zhuanghe", "", "CN", "156", "", "19", "", "", "39.70083", "122.99111", "Asia/Shanghai"),
("1784074", "Zhouzhuang", "Чжоучжуан", "CN", "156", "", "04", "", "", "31.11788", "120.84427", "Asia/Shanghai"),
("1784130", "Zhoukou", "Чжоуко", "CN", "156", "", "09", "", "", "33.63333", "114.63333", "Asia/Shanghai"),
("1784178", "Zhoucun", "", "CN", "156", "", "25", "", "", "36.81667", "117.81667", "Asia/Shanghai"),
("1784185", "Yuxi", "Юйси", "CN", "156", "", "29", "", "", "24.355", "102.54222", "Asia/Shanghai"),
("1784253", "Zhongxing", "", "CN", "156", "", "04", "", "", "33.70389", "118.67917", "Asia/Shanghai"),
("1784310", "Zhongshu", "Чжуншу", "CN", "156", "", "29", "", "", "24.51667", "103.76667", "Asia/Shanghai"),
("1784553", "Zhicheng", "", "CN", "156", "", "02", "", "", "31.0054", "119.90488", "Asia/Shanghai"),
("1784554", "Zhicheng", "", "CN", "156", "", "12", "", "", "30.29556", "111.50472", "Asia/Shanghai"),
("1784580", "Zhenzhou", "", "CN", "156", "", "04", "", "", "32.28034", "119.16999", "Asia/Shanghai"),
("1784642", "Zhenjiang", "", "CN", "156", "", "04", "", "", "32.21086", "119.45508", "Asia/Shanghai"),
("1784647", "Zhaobaoshan", "", "CN", "156", "", "02", "", "", "29.9695", "121.68753", "Asia/Shanghai"),
("1784658", "Zhengzhou", "Чжэнчжоу", "CN", "156", "", "09", "", "", "34.75778", "113.64861", "Asia/Shanghai"),
("1784820", "Xinghua", "Синхуа", "CN", "156", "", "04", "", "", "32.93917", "119.83417", "Asia/Shanghai"),
("1784841", "Zhaotong", "Чжаотун", "CN", "156", "", "29", "", "", "27.31667", "103.71667", "Asia/Shanghai"),
("1784853", "Zhaoqing", "Чжаоцин", "CN", "156", "", "30", "", "", "23.05116", "112.45972", "Asia/Shanghai"),
("1784929", "Zhaogezhuang", "", "CN", "156", "", "10", "", "", "39.76538", "118.41191", "Asia/Shanghai"),
("1784953", "Luofeng", "", "CN", "156", "", "25", "", "", "37.36497", "120.40997", "Asia/Shanghai"),
("1784990", "Zhanjiang", "Чжаньцзян", "CN", "156", "", "30", "", "", "21.28145", "110.34271", "Asia/Urumqi"),
("1785018", "Zhangzhou", "Чжанчжоу", "CN", "156", "", "07", "", "", "24.51333", "117.65556", "Asia/Shanghai"),
("1785036", "Zhangye", "", "CN", "156", "", "15", "", "", "38.93417", "100.45167", "Asia/Shanghai"),
("1785066", "Zhangwan", "", "CN", "156", "CN", "07", "", "", "26.71139", "119.59194", "Asia/Shanghai"),
("1785286", "Zibo", "Цзыбо", "CN", "156", "", "25", "", "", "36.79056", "118.06333", "Asia/Shanghai"),
("1785294", "Anyang", "Аньянг", "CN", "156", "", "09", "1817942", "", "36.096", "114.38278", "Asia/Shanghai"),
("1785453", "Zaozhuang", "Цзаочжуан", "CN", "156", "", "25", "", "", "34.86472", "117.55417", "Asia/Shanghai"),
("1785462", "Zaoyang", "", "CN", "156", "", "12", "", "", "32.12722", "112.75417", "Asia/Shanghai"),
("1785489", "Zaojiacheng", "", "CN", "156", "", "28", "", "", "39.27706", "117.43574", "Asia/Shanghai"),
("1785545", "Yuyao", "Юяо", "CN", "156", "", "02", "1799395", "1785543", "30.05", "121.14944", "Asia/Shanghai"),
("1785566", "Yingchuan", "", "CN", "156", "", "09", "", "", "34.16278", "113.46389", "Asia/Shanghai"),
("1785572", "Yuxia", "", "CN", "156", "", "26", "", "", "34.06153", "108.62905", "Asia/Shanghai"),
("1785623", "Kunshan", "Куньшань", "CN", "156", "", "04", "", "", "31.37762", "120.95431", "Asia/Shanghai"),
("1785655", "Yunyang", "", "CN", "156", "", "09", "", "", "33.44743", "112.71422", "Asia/Shanghai"),
("1785698", "Yunmeng Chengguanzhen", "", "CN", "156", "", "12", "", "", "31.06251", "113.76545", "Asia/Shanghai"),
("1785710", "Jinghong", "", "CN", "156", "", "29", "", "", "21.99102", "100.73409", "Asia/Shanghai"),
("1785716", "Pizhou", "", "CN", "156", "", "04", "", "", "34.31139", "117.95028", "Asia/Shanghai"),
("1785725", "Yunfu", "Юньфу", "CN", "156", "", "30", "", "", "22.92833", "112.03954", "Asia/Shanghai"),
("1785738", "Yuncheng", "Юньчэн", "CN", "156", "", "24", "", "", "35.02306", "110.99278", "Asia/Shanghai"),
("1785777", "Yulinshi", "Юйлинь", "CN", "156", "", "26", "", "", "38.29181", "109.73753", "Asia/Shanghai"),
("1785781", "Yulin", "", "CN", "156", "", "16", "", "", "22.63333", "110.15", "Asia/Shanghai"),
("1785964", "Yudong", "Юйдун", "CN", "156", "", "33", "", "", "29.385", "106.51944", "Asia/Shanghai"),
("1785974", "Yuci", "", "CN", "156", "", "24", "", "", "37.68028", "112.73194", "Asia/Shanghai"),
("1785980", "Yucheng", "Юйчэн", "CN", "156", "", "25", "", "", "34.92889", "116.46528", "Asia/Shanghai"),
("1786060", "Yuanping", "", "CN", "156", "", "24", "", "", "38.71528", "112.7575", "Asia/Shanghai"),
("1786067", "Qianjiang", "Юаньлинь", "CN", "156", "", "12", "", "", "30.421", "112.8919", "Asia/Shanghai"),
("1786112", "Heyuan", "Хэюань", "CN", "156", "", "30", "", "", "23.73333", "114.68333", "Asia/Shanghai"),
("1786293", "Yongning", "", "CN", "156", "CN", "07", "", "", "24.68", "118.69", "Asia/Shanghai"),
("1786357", "Yongfeng", "", "CN", "156", "", "11", "", "", "27.42829", "112.18338", "Asia/Shanghai"),
("1786378", "Yongchuan", "", "CN", "156", "", "33", "", "", "29.35376", "105.89392", "Asia/Shanghai"),
("1786455", "Yishui", "", "CN", "156", "", "25", "", "", "35.78472", "118.62806", "Asia/Shanghai"),
("1786546", "Zhongxiang", "", "CN", "156", "", "12", "", "", "31.16611", "112.58306", "Asia/Shanghai"),
("1786587", "Yingshang Chengguanzhen", "", "CN", "156", "", "01", "", "", "32.62945", "116.27013", "Asia/Shanghai"),
("1786640", "Chengzhong", "", "CN", "156", "", "12", "", "", "30.94454", "113.55284", "Asia/Shanghai"),
("1786657", "Yinchuan", "Иньчуань", "CN", "156", "", "21", "", "", "38.46806", "106.27306", "Asia/Shanghai"),
("1786676", "Yima", "Йимы", "CN", "156", "", "09", "", "", "34.73806", "111.88389", "Asia/Shanghai"),
("1786720", "Yigou", "", "CN", "156", "", "09", "", "", "35.81139", "114.31667", "Asia/Shanghai"),
("1786731", "Qingzhou", "Цинчжоу", "CN", "156", "", "25", "", "", "36.69667", "118.47972", "Asia/Shanghai"),
("1786746", "Yichun", "Ичунь", "CN", "156", "", "03", "", "", "27.83333", "114.4", "Asia/Shanghai"),
("1786759", "Yicheng", "", "CN", "156", "", "12", "", "", "31.70472", "112.25611", "Asia/Shanghai"),
("1786760", "Yicheng", "", "CN", "156", "", "04", "", "", "31.36059", "119.82016", "Asia/Shanghai"),
("1786764", "Yichang", "Ичан", "CN", "156", "", "12", "1786761", "", "30.71444", "111.28472", "Asia/Shanghai"),
("1786770", "Yibin", "Ибинь", "CN", "156", "", "32", "", "", "28.76667", "104.62383", "Asia/Shanghai"),
("1786855", "Yatou", "Жунчэн", "CN", "156", "", "25", "", "", "37.1566", "122.43762", "Asia/Shanghai"),
("1786867", "Yashan", "", "CN", "156", "", "16", "", "", "22.1975", "109.94194", "Asia/Shanghai"),
("1787031", "Yanzhou", "", "CN", "156", "", "25", "", "", "35.55278", "116.82861", "Asia/Shanghai"),
("1787093", "Yantai", "Яньтай", "CN", "156", "", "25", "", "", "37.47649", "121.44081", "Asia/Shanghai"),
("1787144", "Yanliang", "", "CN", "156", "", "26", "", "", "34.65918", "109.22921", "Asia/Shanghai"),
("1787227", "Yangzhou", "Янчжоу", "CN", "156", "", "04", "", "", "32.39722", "119.43583", "Asia/Shanghai"),
("1787323", "Yangshuo", "Яншо", "CN", "156", "", "16", "", "", "24.78081", "110.48967", "Asia/Shanghai"),
("1787331", "Zhangjiagang", "", "CN", "156", "", "04", "", "", "31.865", "120.53889", "Asia/Shanghai"),
("1787351", "Yangquan", "", "CN", "156", "", "24", "", "", "37.8575", "113.56333", "Asia/Shanghai"),
("1787437", "Yangliuqing", "", "CN", "156", "", "28", "", "", "39.1375", "116.99972", "Asia/Shanghai"),
("1787601", "Yanggu", "Янг", "CN", "156", "", "25", "", "", "36.11056", "115.77528", "Asia/Shanghai"),
("1787646", "Yangcun", "", "CN", "156", "", "28", "", "", "39.36389", "117.06028", "Asia/Shanghai"),
("1787746", "Yancheng", "Яньчэн", "CN", "156", "", "04", "", "", "33.3575", "120.1573", "Asia/Shanghai"),
("1787824", "Tongshan", "Сюйчжоу", "CN", "156", "", "04", "", "", "34.18045", "117.15707", "Asia/Shanghai"),
("1787837", "Xucheng", "", "CN", "156", "", "30", "", "", "20.32917", "110.16712", "Asia/Urumqi"),
("1787858", "Shangrao", "Шанжао", "CN", "156", "", "03", "", "", "28.45179", "117.94287", "Asia/Shanghai"),
("1787901", "Xunchang", "", "CN", "156", "", "32", "", "", "28.45433", "104.71498", "Asia/Shanghai"),
("1788046", "Jiangguanchi", "", "CN", "156", "", "09", "", "", "34.12821", "113.80681", "Asia/Shanghai"),
("1788081", "Xuanzhou", "", "CN", "156", "", "01", "", "", "30.9525", "118.75528", "Asia/Shanghai"),
("1788206", "Xixiang", "", "CN", "156", "", "09", "", "", "35.16278", "112.865", "Asia/Shanghai"),
("1788245", "Xiuying", "", "CN", "156", "CN", "31", "", "", "20.00073", "110.29359", "Asia/Shanghai"),
("1788268", "Xiulin", "", "CN", "156", "", "12", "", "", "29.71667", "112.4", "Asia/Shanghai"),
("1788291", "Xitangtuo", "", "CN", "156", "", "28", "", "", "39.3224", "117.48821", "Asia/Shanghai"),
("1788402", "Xiongzhou", "", "CN", "156", "", "30", "", "", "25.11667", "114.3", "Asia/Shanghai"),
("1788406", "Guixi", "", "CN", "156", "", "03", "", "", "28.28857", "117.21329", "Asia/Shanghai"),
("1788450", "Xinzhou", "Синьчжоу", "CN", "156", "", "24", "", "", "38.40917", "112.73333", "Asia/Shanghai"),
("1788452", "Xinzhou", "", "CN", "156", "", "12", "", "", "30.86667", "114.8", "Asia/Shanghai"),
("1788462", "Xinzhi", "", "CN", "156", "", "24", "", "", "36.49889", "111.70472", "Asia/Shanghai"),
("1788508", "Xinyu", "", "CN", "156", "", "03", "9072903", "", "27.80429", "114.93335", "Asia/Shanghai"),
("1788522", "Hancheng", "", "CN", "156", "", "09", "", "", "32.51861", "112.35222", "Asia/Shanghai"),
("1788534", "Xinyang", "Цзинань", "CN", "156", "", "09", "", "", "32.12278", "114.06556", "Asia/Shanghai"),
("1788572", "Nangandao", "Синьсян", "CN", "156", "", "09", "", "", "35.19033", "113.80151", "Asia/Shanghai"),
("1788618", "Xintai", "", "CN", "156", "", "25", "", "", "35.90056", "117.75194", "Asia/Shanghai"),
("1788638", "Xinshi", "", "CN", "156", "", "12", "", "", "31.04704", "113.14098", "Asia/Shanghai"),
("1788694", "Xinpu", "", "CN", "156", "", "04", "", "", "34.59972", "119.15944", "Asia/Shanghai"),
("1788816", "Xinji", "", "CN", "156", "", "10", "", "", "37.90278", "115.20361", "Asia/Shanghai"),
("1788852", "Xining", "Синин", "CN", "156", "", "06", "", "", "36.62554", "101.75739", "Asia/Shanghai"),
("1788869", "Shangmei", "", "CN", "156", "", "11", "", "", "27.74278", "111.29556", "Asia/Shanghai"),
("1788927", "Xingtai", "Синтай", "CN", "156", "", "10", "", "", "37.06306", "114.49417", "Asia/Shanghai"),
("1789065", "Ankang", "Анкан", "CN", "156", "", "26", "", "", "32.68", "109.01722", "Asia/Shanghai"),
("1789118", "Xindian", "", "CN", "156", "", "25", "", "", "36.7975", "118.29444", "Asia/Shanghai"),
("1789134", "Xindian", "", "CN", "156", "", "07", "", "", "24.61006", "118.24068", "Asia/Shanghai"),
("1789137", "Xindi", "", "CN", "156", "", "12", "", "", "29.81667", "113.46667", "Asia/Shanghai"),
("1789176", "Feicheng", "", "CN", "156", "", "25", "", "", "36.24861", "116.76583", "Asia/Shanghai"),
("1789273", "Sanshui", "", "CN", "156", "", "30", "", "", "23.15486", "112.89161", "Asia/Shanghai"),
("1789289", "Ximei", "", "CN", "156", "", "07", "", "", "24.98773", "118.3858", "Asia/Shanghai"),
("1789427", "Wacheng", "", "CN", "156", "", "09", "", "", "33.78333", "114.51667", "Asia/Shanghai"),
("1789462", "Xihe", "", "CN", "156", "", "12", "", "", "31.68635", "113.46585", "Asia/Shanghai"),
("1789597", "Xiditou", "", "CN", "156", "", "28", "", "", "39.25375", "117.34814", "Asia/Shanghai"),
("1789647", "Xichang", "Сичан", "CN", "156", "", "32", "", "", "27.89642", "102.26341", "Asia/Shanghai"),
("1789659", "Xibing", "", "CN", "156", "CN", "07", "", "", "26.98139", "119.72472", "Asia/Shanghai"),
("1789693", "Xiazhuang", "", "CN", "156", "", "25", "", "", "34.91611", "118.63889", "Asia/Shanghai"),
("1789703", "Xiazhen", "", "CN", "156", "", "25", "", "", "34.80222", "117.11167", "Asia/Shanghai"),
("1789799", "Xiashi", "", "CN", "156", "", "02", "", "", "30.53629", "120.68638", "Asia/Shanghai"),
("1789897", "Zijinglu", "", "CN", "156", "", "09", "", "", "34.76", "112.97139", "Asia/Shanghai"),
("1789945", "Xiaoweizhai", "", "CN", "156", "", "18", "", "", "26.19028", "107.5125", "Asia/Shanghai"),
("1789998", "Xiaoshan", "Сяошань", "CN", "156", "", "02", "", "", "30.16746", "120.25883", "Asia/Shanghai"),
("1790100", "Xiaolingwei", "", "CN", "156", "", "04", "", "", "32.03244", "118.854", "Asia/Shanghai"),
("1790254", "Xiaogan", "", "CN", "156", "", "12", "1790253", "", "30.92689", "113.92221", "Asia/Shanghai"),
("1790272", "Xiaodian", "", "CN", "156", "", "28", "", "", "39.25412", "117.22747", "Asia/Shanghai"),
("1790353", "Xianyang", "Саньян", "CN", "156", "", "26", "", "", "34.33778", "108.70261", "Asia/Shanghai"),
("1790371", "Xiantao", "", "CN", "156", "", "12", "", "", "30.3708", "113.44294", "Asia/Shanghai"),
("1790379", "Xianshuigu", "", "CN", "156", "", "28", "", "", "38.985", "117.38278", "Asia/Shanghai"),
("1790392", "Xiannü", "", "CN", "156", "", "04", "", "", "32.42806", "119.56048", "Asia/Shanghai"),
("1790396", "Xianning", "Сяньнин", "CN", "156", "", "12", "1790395", "", "29.84347", "114.32201", "Asia/Shanghai"),
("1790413", "Xianju", "", "CN", "156", "", "02", "", "", "28.8547", "120.73168", "Asia/Shanghai"),
("1790437", "Zhuhai", "Чжухай", "CN", "156", "", "30", "", "", "22.27694", "113.56778", "Asia/Shanghai"),
("1790451", "Wenxing", "", "CN", "156", "", "11", "", "", "28.68208", "112.87864", "Asia/Shanghai"),
("1790471", "Xiangxiang", "", "CN", "156", "", "11", "", "", "27.73333", "112.53333", "Asia/Shanghai"),
("1790492", "Xiangtan", "Сянтань", "CN", "156", "", "11", "", "", "27.85", "112.9", "Asia/Shanghai"),
("1790587", "Xiangyang", "Сянфань", "CN", "156", "", "12", "1790585", "", "32.0422", "112.14479", "Asia/Shanghai"),
("1790601", "Xiangcheng Chengguanzhen", "", "CN", "156", "", "09", "", "", "33.84703", "113.4778", "Asia/Shanghai"),
("1790630", "Xi’an", "Сиань", "CN", "156", "", "26", "", "", "34.25833", "108.92861", "Asia/Shanghai"),
("1790645", "Xiamen", "Сямэнь", "CN", "156", "", "07", "", "", "24.47979", "118.08187", "Asia/Shanghai"),
("1790707", "Xiahu", "", "CN", "156", "CN", "07", "", "", "26.61056", "119.94833", "Asia/Shanghai"),
("1790807", "Xiabaishi", "", "CN", "156", "CN", "07", "", "", "26.81528", "119.67917", "Asia/Shanghai"),
("1790840", "Wuzhou", "", "CN", "156", "", "16", "", "", "23.48333", "111.31667", "Asia/Shanghai"),
("1790885", "Wuyang", "", "CN", "156", "", "01", "", "", "31.9925", "116.24722", "Asia/Shanghai"),
("1790894", "Wuxue", "", "CN", "156", "", "12", "", "", "29.85058", "115.5525", "Asia/Shanghai"),
("1790923", "Wuxi", "Уси", "CN", "156", "", "04", "", "", "31.56887", "120.28857", "Asia/Shanghai"),
("1791056", "Dongyang", "", "CN", "156", "", "02", "", "", "29.26778", "120.22528", "Asia/Shanghai"),
("1791121", "Changde", "Чандэ", "CN", "156", "", "11", "", "", "29.04638", "111.6783", "Asia/Shanghai"),
("1791236", "Wuhu", "Уху", "CN", "156", "", "01", "", "", "31.33728", "118.37351", "Asia/Shanghai"),
("1791247", "Wuhan", "Ухань", "CN", "156", "", "12", "", "", "30.58333", "114.26667", "Asia/Shanghai"),
("1791249", "Wuhai", "", "CN", "156", "", "20", "", "", "39.68442", "106.81583", "Asia/Shanghai"),
("1791325", "Wuda", "", "CN", "156", "", "20", "", "", "39.49944", "106.71167", "Asia/Shanghai"),
("1791347", "Wucheng", "", "CN", "156", "", "01", "", "", "29.60077", "118.17495", "Asia/Shanghai"),
("1791388", "Wenzhou", "Вэньчжоу", "CN", "156", "", "02", "", "", "27.99942", "120.66682", "Asia/Shanghai"),
("1791422", "Wenshui", "", "CN", "156", "", "18", "", "", "28.45056", "106.52667", "Asia/Shanghai"),
("1791428", "Wenshang", "", "CN", "156", "", "25", "", "", "35.7275", "116.49611", "Asia/Shanghai"),
("1791464", "Wenling", "", "CN", "156", "", "02", "", "", "28.37524", "121.38416", "Asia/Shanghai"),
("1791536", "Tianfu", "", "CN", "156", "", "25", "", "", "37.19723", "122.05228", "Asia/Shanghai"),
("1791636", "Weinan", "Вэйнань", "CN", "156", "", "26", "", "", "34.50355", "109.50891", "Asia/Shanghai"),
("1791673", "Weihai", "Вэйхай", "CN", "156", "", "25", "", "", "37.50914", "122.11356", "Asia/Shanghai"),
("1791681", "Weifang", "Вэйфан", "CN", "156", "", "25", "", "", "36.71", "119.10194", "Asia/Shanghai"),
("1791748", "Wanxian", "", "CN", "156", "", "33", "", "", "30.81544", "108.37089", "Asia/Shanghai"),
("1791779", "Wanning", "", "CN", "156", "", "31", "Wanning Shi (undefined)", "", "18.79931", "110.3841", "Asia/Shanghai"),
("1792087", "Yinzhu", "", "CN", "156", "", "25", "", "", "35.87861", "119.97528", "Asia/Shanghai"),
("1792260", "Wafangdian", "", "CN", "156", "", "19", "", "", "39.61833", "122.00806", "Asia/Shanghai"),
("1792286", "Tuzhai", "", "CN", "156", "", "07", "", "", "24.98301", "118.83194", "Asia/Shanghai"),
("1792359", "Huangshan", "Туньси", "CN", "156", "", "01", "", "", "29.71139", "118.3125", "Asia/Shanghai"),
("1792516", "Loushanguan", "", "CN", "156", "", "18", "", "", "28.1368", "106.822", "Asia/Shanghai"),
("1792520", "Tongzhou", "Тунчжоу", "CN", "156", "", "22", "", "", "39.90395", "116.66183", "Asia/Shanghai"),
("1792585", "Fuding", "", "CN", "156", "", "07", "", "", "27.32734", "120.21399", "Asia/Shanghai"),
("1792592", "Tongren", "", "CN", "156", "", "18", "1792591", "", "27.71722", "109.18528", "Asia/Shanghai"),
("1792621", "Wusong", "", "CN", "156", "", "01", "", "", "30.95", "117.78333", "Asia/Shanghai"),
("1792692", "Tongchuan", "", "CN", "156", "", "32", "", "", "31.09407", "105.08731", "Asia/Shanghai"),
("1792749", "Tingjiang", "", "CN", "156", "", "07", "", "", "26.07401", "119.50574", "Asia/Shanghai"),
("1792892", "Tianshui", "", "CN", "156", "", "15", "", "", "34.57952", "105.74238", "Asia/Shanghai"),
("1792916", "Tianpeng", "", "CN", "156", "", "32", "", "", "30.98664", "103.93933", "Asia/Shanghai"),
("1792947", "Tianjin", "Тяньцзинь", "CN", "156", "", "28", "", "", "39.14222", "117.17667", "Asia/Shanghai"),
("1793036", "Chengtangcun", "Тэнчжоу", "CN", "156", "", "25", "", "", "35.08357", "117.19071", "Asia/Shanghai"),
("1793089", "Taozhuang", "", "CN", "156", "", "25", "", "", "34.85", "117.33333", "Asia/Shanghai"),
("1793230", "Tantou", "", "CN", "156", "", "07", "", "", "26.03033", "119.59739", "Asia/Shanghai"),
("1793286", "Tangzhai", "", "CN", "156", "", "01", "", "", "34.43278", "116.59111", "Asia/Shanghai"),
("1793346", "Tangshan", "Таншань", "CN", "156", "", "10", "", "", "39.63333", "118.18333", "Asia/Shanghai"),
("1793364", "Tangping", "", "CN", "156", "", "30", "", "", "22.03177", "111.93537", "Asia/Shanghai"),
("1793385", "Tangjiazhuang", "", "CN", "156", "", "10", "", "", "39.74326", "118.45099", "Asia/Shanghai"),
("1793419", "Binhe", "", "CN", "156", "", "09", "", "", "32.68833", "112.8275", "Asia/Shanghai"),
("1793424", "Tanggu", "Танго", "CN", "156", "", "28", "", "", "39.02111", "117.64694", "Asia/Shanghai"),
("1793505", "Taizhou", "Тайчжоу", "CN", "156", "", "04", "", "", "32.49069", "119.90812", "Asia/Shanghai"),
("1793511", "Taiyuan", "Тайюань", "CN", "156", "", "24", "", "", "37.86944", "112.56028", "Asia/Shanghai"),
("1793533", "Taixing", "", "CN", "156", "", "04", "", "", "32.16667", "120.01361", "Asia/Shanghai"),
("1793700", "Taishan", "Тайшань", "CN", "156", "", "30", "", "", "22.25135", "112.7799", "Asia/Shanghai"),
("1793724", "Tai’an", "Тайань", "CN", "156", "", "25", "", "", "36.18528", "117.12", "Asia/Shanghai"),
("1793743", "Suzhou", "Сучжоу", "CN", "156", "", "01", "", "", "33.63611", "116.97889", "Asia/Shanghai"),
("1793774", "Suozhen", "", "CN", "156", "", "25", "", "", "36.95389", "118.10472", "Asia/Shanghai"),
("1793879", "Suizhou", "", "CN", "156", "", "12", "", "", "31.71111", "113.36306", "Asia/Shanghai"),
("1793889", "Suixi", "", "CN", "156", "", "01", "", "", "33.89067", "116.77473", "Asia/Shanghai"),
("1793899", "Suicheng", "", "CN", "156", "", "04", "", "", "33.8963", "117.93307", "Asia/Shanghai"),
("1793900", "Suining", "Суйнин", "CN", "156", "", "32", "", "", "30.50802", "105.57332", "Asia/Shanghai"),
("1794035", "Songjiang", "", "CN", "156", "", "23", "", "", "31.03595", "121.2146", "Asia/Shanghai"),
("1794140", "Sishui", "", "CN", "156", "", "25", "", "", "35.64889", "117.27583", "Asia/Shanghai"),
("1794198", "Simenqian", "", "CN", "156", "", "11", "", "", "27.48722", "110.88611", "Asia/Shanghai"),
("1794479", "Laixi", "", "CN", "156", "", "25", "", "", "36.85917", "120.52694", "Asia/Shanghai"),
("1794685", "Shuangjiang", "", "CN", "156", "", "11", "", "", "26.15467", "109.7138", "Asia/Shanghai"),
("1794794", "Shouguang", "Шоугуан", "CN", "156", "", "25", "", "", "36.88", "118.7375", "Asia/Shanghai"),
("1794806", "Shizuishan", "", "CN", "156", "", "21", "", "", "39.23333", "106.76944", "Asia/Shanghai"),
("1794825", "Shizilu", "", "CN", "156", "", "25", "", "", "35.17111", "118.82889", "Asia/Shanghai"),
("1794903", "Shiyan", "Шиянь", "CN", "156", "", "12", "1794892", "", "32.6475", "110.77806", "Asia/Shanghai"),
("1794904", "Shiyan", "Шиян", "CN", "156", "", "12", "", "", "32.56667", "110.78333", "Asia/Shanghai"),
("1794920", "Shijiang", "", "CN", "156", "CN", "11", "", "", "27.08194", "110.79333", "Asia/Shanghai"),
("1794947", "Shiwan", "", "CN", "156", "", "30", "", "", "23.00107", "113.077", "Asia/Shanghai"),
("1794971", "Shitanjing", "", "CN", "156", "", "21", "", "", "39.23417", "106.34389", "Asia/Shanghai"),
("1795055", "Shiqiao", "", "CN", "156", "", "30", "", "", "22.9464", "113.35769", "Asia/Shanghai"),
("1795058", "Shiqian", "", "CN", "156", "CN", "18", "", "", "27.5225", "108.22806", "Asia/Shanghai"),
("1795060", "Shiqi", "", "CN", "156", "", "30", "", "", "22.51682", "113.38521", "Asia/Shanghai"),
("1795166", "Shima", "Шима", "CN", "156", "", "07", "", "", "24.44647", "117.81216", "Asia/Shanghai"),
("1795184", "Shilong", "", "CN", "156", "", "30", "", "", "23.11444", "113.84722", "Asia/Shanghai"),
("1795196", "Tongchuanshi", "", "CN", "156", "", "26", "", "", "35.07474", "109.08495", "Asia/Shanghai"),
("1795270", "Shijiazhuang", "Шицзячжуан", "CN", "156", "", "10", "", "", "38.04139", "114.47861", "Asia/Shanghai"),
("1795565", "Shenzhen", "Шэньчжэнь", "CN", "156", "", "30", "1795563", "", "22.54554", "114.0683", "Asia/Shanghai"),
("1795579", "Yanta", "", "CN", "156", "", "25", "", "", "36.24111", "115.66722", "Asia/Shanghai"),
("1795632", "Shenjiamen", "", "CN", "156", "", "02", "", "", "29.95763", "122.29802", "Asia/Shanghai"),
("1795816", "Shashi", "Шаши", "CN", "156", "", "12", "", "", "30.30722", "112.24472", "Asia/Shanghai"),
("1795842", "Shaping", "", "CN", "156", "", "30", "", "", "22.77019", "112.95776", "Asia/Shanghai"),
("1795855", "Shaoxing", "Шаосин", "CN", "156", "", "02", "", "", "30.00237", "120.57864", "Asia/Shanghai"),
("1795857", "Shaowu", "", "CN", "156", "", "07", "", "", "27.34089", "117.4831", "Asia/Shanghai"),
("1795874", "Shaoguan", "Шаогуань", "CN", "156", "", "30", "", "", "24.8", "113.58333", "Asia/Shanghai"),
("1795909", "Shanyang", "", "CN", "156", "", "07", "", "", "26.67019", "119.20509", "Asia/Shanghai"),
("1795919", "Shancheng", "", "CN", "156", "", "25", "", "", "34.79528", "116.08167", "Asia/Shanghai"),
("1795928", "Shanwei", "Шаньвэй", "CN", "156", "", "30", "", "", "22.78199", "115.3475", "Asia/Shanghai"),
("1795940", "Shantou", "Шаньтоу", "CN", "156", "", "30", "", "", "23.36814", "116.71479", "Asia/Shanghai"),
("1795941", "Shanting", "", "CN", "156", "", "25", "", "", "35.07528", "117.45778", "Asia/Shanghai"),
("1796236", "Shanghai", "Шанхай", "CN", "156", "", "23", "", "", "31.22222", "121.45806", "Asia/Shanghai"),
("1796379", "Shajiang", "", "CN", "156", "CN", "07", "", "", "26.7825", "119.96694", "Asia/Shanghai"),
("1796421", "Shahecheng", "", "CN", "156", "", "10", "", "", "36.93833", "114.50583", "Asia/Shanghai"),
("1796556", "Sanya", "Санья", "CN", "156", "", "31", "", "", "18.24306", "109.505", "Asia/Shanghai"),
("1796663", "Sanming", "Саньмин", "CN", "156", "", "07", "", "", "26.24861", "117.61861", "Asia/Shanghai"),
("1797038", "Runing", "", "CN", "156", "", "09", "", "", "33.00111", "114.35417", "Asia/Shanghai"),
("1797120", "Fuqing", "Фуцинь", "CN", "156", "", "07", "", "", "25.725", "119.37944", "Asia/Shanghai"),
("1797121", "Jieyang", "Цзеян", "CN", "156", "", "30", "", "", "23.5418", "116.36581", "Asia/Shanghai"),
("1797132", "Rizhao", "", "CN", "156", "", "25", "", "", "35.4275", "119.45528", "Asia/Shanghai"),
("1797181", "Renqiu", "", "CN", "156", "", "10", "", "", "38.69889", "116.09361", "Asia/Shanghai"),
("1797264", "Quzhou", "Цюйчжоу", "CN", "156", "", "02", "", "", "28.95944", "118.86861", "Asia/Shanghai"),
("1797318", "Qujing", "", "CN", "156", "", "29", "", "", "25.48333", "103.78333", "Asia/Shanghai"),
("1797333", "Qufu", "Цюйфу", "CN", "156", "", "25", "", "", "35.59667", "116.99111", "Asia/Shanghai"),
("1797353", "Quanzhou", "Цюаньчжоу", "CN", "156", "", "07", "", "", "24.91389", "118.58583", "Asia/Shanghai"),
("1797417", "Wuxi", "", "CN", "156", "", "11", "", "", "26.5844", "111.859", "Asia/Shanghai"),
("1797438", "Zhuangyuan", "", "CN", "156", "", "25", "", "", "37.30553", "120.82747", "Asia/Shanghai"),
("1797535", "Qiongshan", "", "CN", "156", "", "31", "", "", "20.00583", "110.35417", "Asia/Shanghai"),
("1797543", "Qionghu", "", "CN", "156", "", "11", "", "", "28.84061", "112.37399", "Asia/Shanghai"),
("1797551", "Qinzhou", "", "CN", "156", "", "16", "", "", "21.97296", "108.62612", "Asia/Shanghai"),
("1797575", "Qinnan", "", "CN", "156", "", "04", "", "", "33.25306", "119.91333", "Asia/Shanghai"),
("1797595", "Qinhuangdao", "Циньхуандао", "CN", "156", "", "10", "1797593", "", "39.93167", "119.58833", "Asia/Shanghai"),
("1797658", "Jinjiang", "", "CN", "156", "", "07", "", "", "24.81978", "118.57415", "Asia/Shanghai"),
("1797793", "Qingquan", "Цинцюань", "CN", "156", "", "12", "", "", "30.45113", "115.25593", "Asia/Shanghai"),
("1797873", "Huai'an", "", "CN", "156", "", "04", "", "", "33.58861", "119.01917", "Asia/Shanghai"),
("1797905", "Qingguang", "", "CN", "156", "", "28", "", "", "39.19883", "117.03314", "Asia/Shanghai"),
("1797929", "Qingdao", "Циндао", "CN", "156", "", "25", "", "", "36.06605", "120.36939", "Asia/Shanghai"),
("1797945", "Qingyuan", "", "CN", "156", "", "30", "", "", "23.7", "113.03333", "Asia/Shanghai"),
("1798078", "Qidu", "", "CN", "156", "CN", "07", "", "", "26.76528", "119.54722", "Asia/Shanghai"),
("1798082", "Hongqiao", "Хунцяо", "CN", "156", "", "11", "", "", "26.76837", "112.10814", "Asia/Shanghai"),
("1798371", "Qiancheng", "", "CN", "156", "", "11", "", "", "27.18501", "109.76543", "Asia/Shanghai"),
("1798422", "Puyang Chengguanzhen", "", "CN", "156", "", "09", "", "", "35.70506", "115.01409", "Asia/Shanghai"),
("1798425", "Puyang", "", "CN", "156", "", "02", "", "", "29.45679", "119.88872", "Asia/Shanghai"),
("1798449", "Putian", "Путянь", "CN", "156", "", "07", "", "", "25.43944", "119.01028", "Asia/Shanghai"),
("1798473", "Puqi", "", "CN", "156", "", "12", "", "", "29.71667", "113.88333", "Asia/Shanghai"),
("1798480", "Pumiao", "", "CN", "156", "", "16", "", "", "22.75867", "108.48111", "Asia/Shanghai"),
("1798490", "Pulandian", "", "CN", "156", "", "19", "", "", "39.39528", "121.96694", "Asia/Shanghai"),
("1798548", "Poyang", "Поянху", "CN", "156", "", "03", "", "", "28.99242", "116.66754", "Asia/Shanghai"),
("1798632", "Pingyin", "", "CN", "156", "", "25", "", "", "36.28306", "116.44528", "Asia/Shanghai"),
("1798634", "Pingyi", "", "CN", "156", "", "25", "", "", "35.50056", "117.63083", "Asia/Shanghai"),
("1798636", "Gutao", "Пинъяо", "CN", "156", "", "24", "", "", "37.2025", "112.17806", "Asia/Shanghai"),
("1798654", "Pingxiang", "", "CN", "156", "", "03", "1798652", "", "27.61672", "113.85353", "Asia/Shanghai"),
("1798713", "Pingshan", "", "CN", "156", "", "30", "", "", "22.99376", "114.71311", "Asia/Shanghai"),
("1798733", "Pingnan", "", "CN", "156", "", "16", "", "", "23.54218", "110.38946", "Asia/Shanghai"),
("1798760", "Pingliang", "Пинлян", "CN", "156", "", "15", "", "", "35.53917", "106.68611", "Asia/Shanghai"),
("1798821", "Pingdu", "Пинду", "CN", "156", "", "25", "", "", "36.78444", "119.94639", "Asia/Shanghai"),
("1798827", "Pingdingshan", "Пиндиншань", "CN", "156", "", "09", "", "", "33.73847", "113.30119", "Asia/Shanghai"),
("1798946", "Pengcheng", "", "CN", "156", "", "10", "", "", "36.43111", "114.17", "Asia/Shanghai"),
("1798998", "Dadukou", "Паньчжихуа", "CN", "156", "", "32", "", "", "26.5479", "101.70539", "Asia/Shanghai"),
("1799348", "Ningyang", "", "CN", "156", "", "25", "", "", "35.76417", "116.79139", "Asia/Shanghai"),
("1799352", "Yutan", "", "CN", "156", "", "11", "", "", "28.25831", "112.56048", "Asia/Shanghai"),
("1799383", "Ninghai", "", "CN", "156", "", "25", "", "", "37.38422", "121.60859", "Asia/Shanghai"),
("1799384", "Ninghai", "", "CN", "156", "", "02", "", "", "29.28917", "121.42472", "Asia/Shanghai"),
("1799393", "Ningchegu", "", "CN", "156", "CN", "28", "", "", "39.15889", "117.6625", "Asia/Shanghai"),
("1799397", "Ningbo", "Нинбо", "CN", "156", "", "02", "", "", "29.87819", "121.54945", "Asia/Shanghai"),
("1799491", "Neijiang", "", "CN", "156", "", "32", "", "", "29.58354", "105.06216", "Asia/Shanghai"),
("1799552", "Nanzhou", "", "CN", "156", "", "11", "", "", "29.35955", "112.40243", "Asia/Shanghai"),
("1799574", "Nanzhang Chengguanzhen", "", "CN", "156", "", "12", "", "", "31.78394", "111.82752", "Asia/Shanghai"),
("1799629", "Nanyang", "Наньян", "CN", "156", "", "09", "", "", "32.99472", "112.53278", "Asia/Shanghai"),
("1799722", "Nantong", "Наньтун", "CN", "156", "", "04", "", "", "32.03028", "120.87472", "Asia/Shanghai"),
("1799832", "Pucheng", "", "CN", "156", "", "07", "", "", "27.92333", "118.53333", "Asia/Shanghai"),
("1799846", "Nanping", "Наньпин", "CN", "156", "", "07", "", "", "26.645", "118.17361", "Asia/Shanghai"),
("1799869", "Nanning", "Наньнин", "CN", "156", "", "16", "", "", "22.81667", "108.31667", "Asia/Shanghai"),
("1799897", "Nanma", "", "CN", "156", "", "25", "", "", "36.18478", "118.15486", "Asia/Shanghai"),
("1799908", "Nanlong", "", "CN", "156", "", "32", "", "", "31.35333", "106.06309", "Asia/Shanghai"),
("1799962", "Nanjing", "Нанкин", "CN", "156", "", "04", "", "", "32.06167", "118.77778", "Asia/Shanghai"),
("1800065", "Nangong", "", "CN", "156", "", "10", "", "", "37.35806", "115.37444", "Asia/Shanghai"),
("1800088", "Nanfeng", "", "CN", "156", "", "30", "", "", "23.72695", "111.79723", "Asia/Shanghai"),
("1800101", "Nandu", "", "CN", "156", "", "16", "", "", "22.8525", "110.82333", "Asia/Shanghai"),
("1800107", "Nanding", "", "CN", "156", "", "25", "", "", "36.74833", "118.05583", "Asia/Shanghai"),
("1800146", "Nanchong", "Наньчун", "CN", "156", "", "32", "", "", "30.79508", "106.08473", "Asia/Shanghai"),
("1800163", "Nanchang", "Наньчан", "CN", "156", "", "03", "", "", "28.68396", "115.85306", "Asia/Shanghai"),
("1800430", "Miyang", "", "CN", "156", "", "29", "", "", "24.40417", "103.44278", "Asia/Shanghai"),
("1800498", "Mingshui", "", "CN", "156", "", "25", "", "", "36.71667", "117.5", "Asia/Shanghai"),
("1800519", "Mingguang", "", "CN", "156", "", "01", "", "", "32.78017", "117.96378", "Asia/Shanghai"),
("1800521", "Minggang", "", "CN", "156", "", "09", "", "", "32.45861", "114.04861", "Asia/Shanghai"),
("1800627", "Mianyang", "Мяньян", "CN", "156", "", "32", "", "", "31.46784", "104.68168", "Asia/Shanghai"),
("1800657", "Mentougou", "", "CN", "156", "", "22", "", "", "39.93819", "116.09307", "Asia/Shanghai"),
("1800675", "Mengyin", "", "CN", "156", "", "25", "", "", "35.70694", "117.92639", "Asia/Shanghai"),
("1800764", "Mengcheng Chengguanzhen", "", "CN", "156", "", "01", "", "", "33.26611", "116.56605", "Asia/Shanghai"),
("1800779", "Meizhou", "Мэйчжоу", "CN", "156", "", "30", "1800794", "", "24.28859", "116.11768", "Asia/Shanghai"),
("1800829", "Wuchuan", "", "CN", "156", "", "30", "", "", "21.45713", "110.76591", "Asia/Urumqi"),
("1801401", "Majie", "", "CN", "156", "", "29", "", "", "25.0319", "102.638", "Asia/Shanghai"),
("1801455", "Zhijiang", "", "CN", "156", "", "12", "", "", "30.42139", "111.75333", "Asia/Shanghai"),
("1801582", "Macheng", "", "CN", "156", "", "12", "", "", "31.18013", "115.02213", "Asia/Shanghai"),
("1801615", "Maba", "", "CN", "156", "", "30", "", "", "24.68413", "113.59839", "Asia/Shanghai"),
("1801722", "Lüshun", "Порт-Артур", "CN", "156", "", "19", "", "", "38.8", "121.26667", "Asia/Shanghai"),
("1801757", "Luqiao", "", "CN", "156", "", "02", "", "", "28.58023", "121.37491", "Asia/Shanghai"),
("1801792", "Luoyang", "Лоян", "CN", "156", "", "09", "1801785", "", "34.68361", "112.45361", "Asia/Shanghai"),
("1801797", "Luoyang", "Лоян", "CN", "156", "", "07", "", "", "24.95938", "118.683", "Asia/Shanghai"),
("1801799", "Luoyang", "Лоян", "CN", "156", "", "30", "", "", "23.16244", "114.27342", "Asia/Shanghai"),
("1801850", "Luorong", "", "CN", "156", "", "16", "", "", "24.40583", "109.60861", "Asia/Shanghai"),
("1801934", "Luohe", "", "CN", "156", "", "09", "", "", "33.56394", "114.04272", "Asia/Shanghai"),
("1801983", "Luocheng", "", "CN", "156", "", "32", "", "", "29.38481", "104.02862", "Asia/Shanghai"),
("1802068", "Lucheng", "", "CN", "156", "", "01", "", "", "31.23357", "117.28057", "Asia/Shanghai"),
("1802171", "Kangding", "Кандин", "CN", "156", "", "32", "1810269", "1804839", "30.00222", "101.9569", "Asia/Shanghai"),
("1802177", "Lubu", "", "CN", "156", "", "30", "", "", "23.17233", "112.28298", "Asia/Shanghai"),
("1802204", "Luancheng", "", "CN", "156", "", "10", "", "", "37.87917", "114.65167", "Asia/Shanghai"),
("1802238", "Loudi", "Лоуди", "CN", "156", "", "11", "", "", "27.73444", "111.99444", "Asia/Shanghai"),
("1802476", "Longquan", "Лунцюань", "CN", "156", "", "29", "", "", "24.67193", "102.1613", "Asia/Shanghai"),
("1802526", "Longmen", "", "CN", "156", "CN", "07", "", "", "24.95972", "118.08889", "Asia/Shanghai"),
("1802550", "Longgang", "", "CN", "156", "", "25", "", "", "37.65181", "120.33063", "Asia/Shanghai"),
("1802788", "Licheng", "", "CN", "156", "", "04", "", "", "31.42813", "119.48353", "Asia/Shanghai"),
("1802875", "Guankou", "Лиуянг", "CN", "156", "", "11", "", "", "28.15861", "113.62709", "Asia/Shanghai"),
("1802940", "Puning", "", "CN", "156", "", "30", "1805830", "1798477", "23.31072", "116.16869", "Asia/Shanghai"),
("1803010", "Liukuaizhuang", "", "CN", "156", "", "28", "", "", "39.24789", "117.33941", "Asia/Shanghai"),
("1803159", "Liuduzhai", "", "CN", "156", "", "11", "", "", "27.36611", "110.935", "Asia/Shanghai"),
("1803245", "Lishui", "Лишуй", "CN", "156", "", "02", "", "", "28.46042", "119.91029", "Asia/Shanghai"),
("1803266", "Lintong", "", "CN", "156", "", "26", "", "", "34.37803", "109.20892", "Asia/Shanghai"),
("1803318", "Linyi", "Линьи", "CN", "156", "", "25", "", "", "35.06306", "118.34278", "Asia/Shanghai"),
("1803331", "Linxia Chengguanzhen", "Линься", "CN", "156", "", "15", "", "", "35.60028", "103.20639", "Asia/Shanghai"),
("1803334", "Linxi", "", "CN", "156", "", "10", "", "", "39.71183", "118.44954", "Asia/Shanghai"),
("1803352", "Linshui", "", "CN", "156", "", "10", "", "", "36.42472", "114.20472", "Asia/Shanghai"),
("1803364", "Linqu", "", "CN", "156", "", "25", "", "", "36.51556", "118.53972", "Asia/Shanghai"),
("1803365", "Linqiong", "", "CN", "156", "", "32", "", "", "30.41587", "103.46089", "Asia/Shanghai"),
("1803367", "Qingnian", "", "CN", "156", "", "25", "", "", "36.84032", "115.71183", "Asia/Shanghai"),
("1803374", "Linping", "", "CN", "156", "", "02", "", "", "30.4225", "120.29722", "Asia/Shanghai"),
("1803422", "Linhai", "", "CN", "156", "", "02", "", "", "28.84815", "121.12807", "Asia/Shanghai"),
("1803551", "Lingcheng", "", "CN", "156", "", "16", "", "", "22.70722", "110.34917", "Asia/Shanghai"),
("1803560", "Lincheng", "Линьчэн", "CN", "156", "", "31", "", "", "19.90778", "109.68583", "Asia/Shanghai"),
("1803567", "Linfen", "Линьфынь", "CN", "156", "", "24", "", "", "36.08889", "111.51889", "Asia/Shanghai"),
("1803616", "Xishan", "Лилин", "CN", "156", "", "11", "", "", "27.66667", "113.5", "Asia/Shanghai"),
("1803782", "Lichuan", "Личуань", "CN", "156", "", "12", "", "", "30.3", "108.85", "Asia/Shanghai"),
("1803791", "Licheng", "", "CN", "156", "", "30", "", "", "23.29549", "113.82465", "Asia/Shanghai"),
("1803834", "Liaocheng", "Ляочэн", "CN", "156", "", "25", "", "", "36.45596", "115.97766", "Asia/Shanghai"),
("1803841", "Lianzhou", "", "CN", "156", "", "30", "", "", "24.78186", "112.3712", "Asia/Shanghai"),
("1803842", "Lianzhou", "", "CN", "156", "", "16", "", "", "21.66621", "109.20116", "Asia/Shanghai"),
("1803886", "Lianran", "", "CN", "156", "", "29", "", "", "24.92271", "102.48496", "Asia/Shanghai"),
("1803936", "Wuwei", "", "CN", "156", "", "15", "", "", "37.92672", "102.63202", "Asia/Shanghai"),
("1803948", "Liangxiang", "", "CN", "156", "", "22", "", "", "39.73598", "116.13295", "Asia/Shanghai"),
("1804120", "Lianjiang", "", "CN", "156", "", "30", "", "", "21.64673", "110.28172", "Asia/Urumqi"),
("1804153", "Leshan", "Лэшань", "CN", "156", "", "32", "", "", "29.56227", "103.76386", "Asia/Shanghai"),
("1804162", "Lengshuitan", "", "CN", "156", "", "11", "", "", "26.4111", "111.59559", "Asia/Shanghai"),
("1804169", "Lengshuijiang", "", "CN", "156", "", "11", "", "", "27.68806", "111.42944", "Asia/Shanghai"),
("1804208", "Leiyang", "", "CN", "156", "", "11", "", "", "26.40238", "112.85908", "Asia/Shanghai"),
("1804252", "Lecheng", "", "CN", "156", "", "30", "", "", "25.128", "113.35041", "Asia/Shanghai"),
("1804386", "Laohekou", "", "CN", "156", "", "12", "", "", "32.38583", "111.66778", "Asia/Shanghai"),
("1804430", "Lanzhou", "Ланьчжоу", "CN", "156", "", "15", "", "", "36.05701", "103.83987", "Asia/Shanghai"),
("1804442", "Lanxi", "", "CN", "156", "", "02", "", "", "29.21588", "119.47156", "Asia/Shanghai"),
("1804451", "Lianyuan", "", "CN", "156", "", "11", "", "", "27.68833", "111.66417", "Asia/Shanghai"),
("1804540", "Langfang", "Ланфан", "CN", "156", "", "10", "", "", "39.50972", "116.69472", "Asia/Shanghai"),
("1804578", "Weichanglu", "", "CN", "156", "", "25", "", "", "37.18073", "119.94217", "Asia/Shanghai"),
("1804586", "Laiyang", "", "CN", "156", "", "25", "", "", "36.97583", "120.71361", "Asia/Shanghai"),
("1804591", "Laiwu", "", "CN", "156", "", "25", "", "", "36.19278", "117.65694", "Asia/Shanghai"),
("1804609", "Laibin", "", "CN", "156", "", "16", "", "", "23.7", "109.26667", "Asia/Shanghai"),
("1804645", "Kunyang", "", "CN", "156", "", "02", "", "", "27.66583", "120.56583", "Asia/Shanghai"),
("1804651", "Kunming", "Куньмин", "CN", "156", "", "29", "", "", "25.03889", "102.71833", "Asia/Shanghai"),
("1804850", "Kaiyuan", "Кайюань", "CN", "156", "", "29", "", "", "23.69767", "103.30372", "Asia/Shanghai"),
("1804874", "Kaihua", "", "CN", "156", "", "29", "", "", "23.3695", "104.27721", "Asia/Shanghai"),
("1804879", "Kaifeng", "Кайфэн", "CN", "156", "", "09", "", "", "34.7986", "114.30742", "Asia/Shanghai"),
("1804892", "Juye", "", "CN", "156", "", "25", "", "", "35.39472", "116.08833", "Asia/Shanghai"),
("1804979", "Juegang", "", "CN", "156", "", "04", "", "", "32.31737", "121.18552", "Asia/Shanghai"),
("1805179", "Jiujiang", "Цзюцзян", "CN", "156", "", "03", "", "", "29.70475", "116.00206", "Asia/Shanghai"),
("1805267", "Jishui", "", "CN", "156", "", "09", "", "", "33.73333", "115.4", "Asia/Shanghai"),
("1805270", "Qianzhou", "", "CN", "156", "", "11", "", "", "28.31925", "109.73346", "Asia/Shanghai"),
("1805298", "Jinzhou", "Цзиньчжоу", "CN", "156", "", "19", "", "", "39.1", "121.71667", "Asia/Shanghai"),
("1805334", "Jinxiang", "", "CN", "156", "", "02", "", "", "27.43265", "120.60625", "Asia/Shanghai"),
("1805379", "Jinshi", "", "CN", "156", "", "11", "", "", "29.60487", "111.87012", "Asia/Shanghai"),
("1805408", "Jinsha", "Цзиньша", "CN", "156", "", "04", "", "", "32.08982", "121.07355", "Asia/Shanghai"),
("1805482", "Jinjing", "", "CN", "156", "CN", "07", "", "", "24.575", "118.59722", "Asia/Shanghai"),
("1805505", "Jinjiang", "", "CN", "156", "", "31", "", "", "19.72878", "110.00851", "Asia/Shanghai"),
("1805515", "Jinji", "", "CN", "156", "", "16", "", "", "23.22806", "110.82611", "Asia/Shanghai"),
("1805518", "Jining", "Цзинин", "CN", "156", "", "25", "", "", "35.405", "116.58139", "Asia/Shanghai"),
("1805528", "Jinhua", "Цзиньхуа", "CN", "156", "", "02", "", "", "29.10678", "119.64421", "Asia/Shanghai"),
("1805540", "Jingzhou", "Цзинчжоу", "CN", "156", "", "12", "", "", "30.35028", "112.19028", "Asia/Shanghai"),
("1805563", "Tianchang", "", "CN", "156", "", "10", "", "", "37.99806", "114.01556", "Asia/Shanghai"),
("1805611", "Jingmen", "Цзинмэнь", "CN", "156", "", "12", "", "", "31.03361", "112.20472", "Asia/Shanghai"),
("1805618", "Jingling", "", "CN", "156", "", "12", "", "", "30.65", "113.1", "Asia/Shanghai"),
("1805680", "Jingdezhen", "Цзиндэчжэнь", "CN", "156", "", "03", "", "", "29.2947", "117.20789", "Asia/Shanghai"),
("1805733", "Jinchang", "Цзиньчан", "CN", "156", "", "15", "1805747", "", "38.50062", "102.19379", "Asia/Shanghai"),
("1805741", "Jincheng", "Цзиньчэн", "CN", "156", "", "24", "", "", "35.50222", "112.83278", "Asia/Shanghai"),
("1805753", "Jinan", "Цзинань", "CN", "156", "", "25", "", "", "36.66833", "116.99722", "Asia/Shanghai"),
("1805757", "Jimo", "", "CN", "156", "", "25", "", "", "36.38972", "120.46222", "Asia/Shanghai"),
("1805798", "Jijiang", "", "CN", "156", "", "33", "", "", "29.28993", "106.25001", "Asia/Shanghai"),
("1805833", "Jiexiu", "", "CN", "156", "", "24", "", "", "37.02444", "111.9125", "Asia/Shanghai"),
("1805844", "Jieshou", "", "CN", "156", "", "01", "1810843", "", "33.26338", "115.36108", "Asia/Shanghai"),
("1805857", "Jieshi", "", "CN", "156", "", "30", "", "", "22.81027", "115.83058", "Asia/Shanghai"),
("1805884", "Jiehu", "", "CN", "156", "", "25", "", "", "35.54278", "118.455", "Asia/Shanghai"),
("1805935", "Jiazi", "", "CN", "156", "", "30", "", "", "22.87932", "116.07318", "Asia/Shanghai"),
("1805953", "Jiaxing", "Цзясин", "CN", "156", "", "02", "", "", "30.7522", "120.75", "Asia/Shanghai"),
("1805987", "Jiaozuo", "Цзяоцзо", "CN", "156", "", "09", "", "", "35.23972", "113.23306", "Asia/Shanghai"),
("1806096", "Jiaozhou", "", "CN", "156", "", "25", "", "", "36.28389", "120.00333", "Asia/Shanghai"),
("1806097", "Ningde", "", "CN", "156", "", "07", "", "", "26.66167", "119.52278", "Asia/Shanghai"),
("1806167", "Jian’ou", "", "CN", "156", "", "07", "", "", "27.04694", "118.32528", "Asia/Shanghai"),
("1806180", "Jianjiang", "", "CN", "156", "CN", "07", "", "", "26.54972", "119.755", "Asia/Shanghai"),
("1806218", "Jiangyan", "", "CN", "156", "", "04", "", "", "32.50611", "120.14278", "Asia/Shanghai"),
("1806248", "Jianguang", "", "CN", "156", "", "03", "", "", "28.19377", "115.7836", "Asia/Shanghai"),
("1806299", "Jiangmen", "Цзянмэнь", "CN", "156", "", "30", "", "", "22.58333", "113.08333", "Asia/Shanghai"),
("1806327", "Jiangkou", "", "CN", "156", "", "07", "", "", "25.48694", "119.19834", "Asia/Shanghai"),
("1806408", "Yangjiang", "Янцзян", "CN", "156", "", "30", "", "", "21.85563", "111.96272", "Asia/Shanghai"),
("1806445", "Ji’an", "Цзиань", "CN", "156", "", "03", "", "", "27.11716", "114.97927", "Asia/Shanghai"),
("1806466", "Guangyuan", "", "CN", "156", "", "32", "", "", "32.44201", "105.823", "Asia/Shanghai"),
("1806535", "Huzhou", "", "CN", "156", "", "02", "", "", "30.8703", "120.0933", "Asia/Shanghai"),
("1806591", "Hutang", "", "CN", "156", "", "04", "", "", "31.53429", "119.49", "Asia/Shanghai"),
("1806627", "Huotong", "", "CN", "156", "CN", "07", "", "", "26.84972", "119.41806", "Asia/Shanghai"),
("1806651", "Huoqiu Chengguanzhen", "", "CN", "156", "", "01", "", "", "32.35473", "116.2939", "Asia/Shanghai"),
("1806696", "Humen", "Хумэнь", "CN", "156", "", "30", "", "", "22.81899", "113.67306", "Asia/Shanghai"),
("1806776", "Huizhou", "Хуэйчжоу", "CN", "156", "", "30", "", "", "23.11147", "114.41523", "Asia/Shanghai"),
("1806840", "Huilong", "Квидонга", "CN", "156", "", "04", "", "", "31.81111", "121.655", "Asia/Shanghai"),
("1806881", "Huicheng", "", "CN", "156", "", "30", "", "", "23.03845", "116.28988", "Asia/Shanghai"),
("1806882", "Xinhui", "", "CN", "156", "", "30", "", "", "22.456", "113.0482", "Asia/Shanghai"),
("1806960", "Huazhou", "", "CN", "156", "", "30", "", "", "21.63333", "110.58333", "Asia/Urumqi"),
("1806988", "Huayin", "", "CN", "156", "", "26", "", "", "34.56528", "110.06639", "Asia/Shanghai"),
("1807082", "Huantuo", "", "CN", "156", "", "28", "", "", "39.22634", "117.3239", "Asia/Shanghai"),
("1807112", "Huangzhou", "Хуанчжоу", "CN", "156", "", "12", "", "", "30.45", "114.8", "Asia/Shanghai"),
("1807143", "Huangyan", "", "CN", "156", "", "02", "", "", "28.6501", "121.26591", "Asia/Shanghai"),
("1807234", "Huangshi", "Хуанши", "CN", "156", "", "12", "", "", "30.24706", "115.04814", "Asia/Shanghai"),
("1807301", "Dasha", "Даша", "CN", "156", "", "30", "", "", "23.11037", "113.4418", "Asia/Shanghai"),
("1807308", "Huangpi", "", "CN", "156", "", "12", "", "", "30.88453", "114.37789", "Asia/Shanghai"),
("1807339", "Huangmei", "", "CN", "156", "", "12", "", "", "30.19235", "116.02496", "Asia/Shanghai"),
("1807508", "Huanggang", "Хуанган", "CN", "156", "", "30", "", "", "23.67704", "116.99961", "Asia/Shanghai"),
("1807544", "Daxing", "Дасин", "CN", "156", "", "22", "", "", "39.74025", "116.32693", "Asia/Shanghai"),
("1807553", "Dingcheng", "", "CN", "156", "", "09", "", "", "32.12722", "115.03944", "Asia/Shanghai"),
("1807645", "Huaiyuan Chengguanzhen", "", "CN", "156", "", "01", "", "", "32.95893", "117.16566", "Asia/Shanghai"),
("1807681", "Huainan", "", "CN", "156", "", "01", "", "", "32.62639", "116.99694", "Asia/Shanghai"),
("1807687", "Huaicheng", "", "CN", "156", "", "30", "", "", "23.91952", "112.17629", "Asia/Shanghai"),
("1807689", "Huaihua", "Хуайхуа", "CN", "156", "", "11", "1807688", "", "27.56337", "110.00404", "Asia/Shanghai"),
("1807695", "Huaidian", "", "CN", "156", "", "09", "", "", "33.43333", "115.03333", "Asia/Shanghai"),
("1807700", "Huaibei", "Хуайбэй", "CN", "156", "", "01", "", "", "33.97444", "116.79167", "Asia/Shanghai"),
("1808106", "Hongjiang", "", "CN", "156", "", "11", "", "", "27.11", "109.99556", "Asia/Shanghai"),
("1808198", "Heze", "Хэцзэ", "CN", "156", "", "25", "", "", "35.23929", "115.47358", "Asia/Shanghai"),
("1808212", "Hechuan", "", "CN", "156", "", "33", "", "", "29.99228", "106.26461", "Asia/Shanghai"),
("1808316", "Yiyang", "Иян", "CN", "156", "", "11", "", "", "28.58917", "112.32833", "Asia/Shanghai"),
("1808336", "Hepo", "Хэпо", "CN", "156", "", "30", "", "", "23.43077", "115.82991", "Asia/Shanghai"),
("1808370", "Hengyang", "Хэнъян", "CN", "156", "", "11", "1808369", "", "26.88946", "112.61888", "Asia/Shanghai"),
("1808392", "Hengshui", "Хэншуй", "CN", "156", "", "10", "", "", "37.73222", "115.70111", "Asia/Shanghai"),
("1808722", "Hefei", "Хэфэй", "CN", "156", "", "01", "", "", "31.86389", "117.28083", "Asia/Shanghai"),
("1808744", "Hede", "Хеде", "CN", "156", "", "04", "", "", "33.7722", "120.26176", "Asia/Shanghai"),
("1808747", "Hecun", "", "CN", "156", "", "10", "", "", "36.53333", "114.11111", "Asia/Shanghai"),
("1808770", "Hebi", "", "CN", "156", "", "09", "", "", "35.89917", "114.1925", "Asia/Shanghai"),
("1808857", "Hanzhong", "Ханьчжун", "CN", "156", "", "26", "", "", "33.07507", "107.02214", "Asia/Shanghai"),
("1808872", "Chengyang", "Фуаня", "CN", "156", "", "07", "", "", "27.08917", "119.64528", "Asia/Shanghai"),
("1808879", "Hanting", "", "CN", "156", "", "25", "", "", "36.77083", "119.21083", "Asia/Shanghai"),
("1808899", "Hanjiashu", "", "CN", "156", "CN", "28", "", "", "39.1875", "117.07306", "Asia/Shanghai"),
("1808926", "Hangzhou", "Ханчжоу", "CN", "156", "", "02", "", "", "30.29365", "120.16142", "Asia/Shanghai"),
("1808931", "Hangu", "Ханга", "CN", "156", "", "28", "", "", "39.24889", "117.78917", "Asia/Shanghai"),
("1808963", "Handan", "Ханьдань", "CN", "156", "", "10", "", "", "36.60056", "114.46778", "Asia/Shanghai"),
("1808977", "Hanchuan", "", "CN", "156", "", "12", "", "", "30.65", "113.76667", "Asia/Shanghai"),
("1808981", "Hancheng", "", "CN", "156", "", "26", "", "", "35.46028", "110.42917", "Asia/Shanghai"),
("1809003", "Haizhou", "", "CN", "156", "", "04", "", "", "34.58167", "119.12889", "Asia/Shanghai"),
("1809061", "Jiaojiang", "", "CN", "156", "", "02", "", "", "28.68028", "121.44278", "Asia/Shanghai"),
("1809062", "Haimen", "", "CN", "156", "", "30", "", "", "23.19346", "116.61219", "Asia/Shanghai"),
("1809077", "Haikou", "", "CN", "156", "", "29", "", "", "24.77985", "102.57548", "Asia/Shanghai"),
("1809078", "Haikou", "Хайкоу", "CN", "156", "", "31", "", "", "20.04583", "110.34167", "Asia/Shanghai"),
("1809159", "Guye", "", "CN", "156", "", "10", "", "", "39.73054", "118.44085", "Asia/Shanghai"),
("1809263", "Guozhen", "", "CN", "156", "", "26", "", "", "34.36591", "107.35904", "Asia/Shanghai"),
("1809412", "Guli", "Гули", "CN", "156", "", "02", "", "", "28.88162", "120.03308", "Asia/Shanghai"),
("1809461", "Guiyang", "Гуйян", "CN", "156", "", "18", "1809458", "", "26.58333", "106.71667", "Asia/Shanghai"),
("1809483", "Guiren", "", "CN", "156", "", "04", "", "", "33.66972", "118.18889", "Asia/Shanghai"),
("1809486", "Guiping", "", "CN", "156", "", "16", "", "", "23.39336", "110.07437", "Asia/Shanghai"),
("1809498", "Guilin", "Гуйлинь", "CN", "156", "", "16", "", "", "25.28194", "110.28639", "Asia/Shanghai"),
("1809532", "Guigang", "", "CN", "156", "", "16", "", "", "23.09639", "109.60917", "Asia/Shanghai"),
("1809548", "Gufeng", "", "CN", "156", "", "07", "", "", "26.90833", "118.98194", "Asia/Shanghai"),
("1809610", "Gucheng Chengguanzhen", "", "CN", "156", "", "12", "", "", "32.26604", "111.63476", "Asia/Shanghai"),
("1809747", "Guantou", "", "CN", "156", "", "07", "", "", "26.13515", "119.55718", "Asia/Shanghai"),
("1809858", "Guangzhou", "Гуанчжоу", "CN", "156", "", "30", "", "", "23.11667", "113.25", "Asia/Shanghai"),
("1809879", "Guangshui", "", "CN", "156", "", "12", "", "", "31.6199", "113.9978", "Asia/Shanghai"),
("1810240", "Gejiu", "", "CN", "156", "", "29", "", "", "23.36085", "103.15372", "Asia/Shanghai"),
("1810295", "Gaozhou", "", "CN", "156", "", "30", "", "", "21.93924", "110.84607", "Asia/Urumqi"),
("1810309", "Gaoyou", "", "CN", "156", "", "04", "", "", "32.78933", "119.44182", "Asia/Shanghai"),
("1810437", "Gaoping", "", "CN", "156", "", "32", "", "", "30.77576", "106.10294", "Asia/Shanghai"),
("1810458", "Gaomi", "", "CN", "156", "", "25", "", "", "36.38333", "119.75278", "Asia/Shanghai"),
("1810553", "Gaogou", "", "CN", "156", "", "04", "", "", "34.0175", "119.18861", "Asia/Shanghai"),
("1810677", "Ganshui", "", "CN", "156", "", "33", "", "", "28.74222", "106.71111", "Asia/Shanghai"),
("1810821", "Fuzhou", "Фучжоу", "CN", "156", "", "07", "", "", "26.06139", "119.30611", "Asia/Shanghai"),
("1810845", "Fuyang", "Фуян", "CN", "156", "", "01", "", "", "32.9", "115.81667", "Asia/Shanghai"),
("1810846", "Fuyang", "Фуянь", "CN", "156", "", "02", "", "", "30.05333", "119.95194", "Asia/Shanghai"),
("1810920", "Qingyang", "", "CN", "156", "", "25", "", "", "37.49583", "121.25806", "Asia/Shanghai"),
("1810979", "Fuling", "Фулин", "CN", "156", "", "33", "", "", "29.706", "107.39575", "Asia/Shanghai"),
("1811103", "Foshan", "Фошань", "CN", "156", "", "30", "", "", "23.02677", "113.13148", "Asia/Shanghai"),
("1811114", "Fenyi", "", "CN", "156", "", "03", "", "", "27.81117", "114.66805", "Asia/Shanghai"),
("1811169", "Fengzhou", "", "CN", "156", "", "07", "", "", "24.95762", "118.53365", "Asia/Shanghai"),
("1811200", "Fengxian", "", "CN", "156", "", "04", "", "", "34.70388", "116.58717", "Asia/Shanghai"),
("1811224", "Fengtai", "", "CN", "156", "CN", "28", "", "", "39.55806", "117.74917", "Asia/Shanghai"),
("1811260", "Fengrun", "", "CN", "156", "", "10", "", "", "39.83333", "118.11667", "Asia/Shanghai"),
("1811305", "Fengkou", "", "CN", "156", "", "12", "", "", "30.08268", "113.33346", "Asia/Shanghai"),
("1811440", "Feicheng", "", "CN", "156", "", "25", "", "", "35.26056", "117.9675", "Asia/Shanghai"),
("1811496", "Fanzhuang", "", "CN", "156", "", "28", "", "", "39.19361", "117.335", "Asia/Shanghai"),
("1811542", "Fangshan", "", "CN", "156", "", "22", "", "", "39.68699", "115.99658", "Asia/Shanghai"),
("1811619", "Ezhou", "", "CN", "156", "", "12", "", "", "30.4", "114.83333", "Asia/Shanghai"),
("1811720", "Enshi", "Эньши", "CN", "156", "", "12", "1811624", "", "30.3", "109.48333", "Asia/Shanghai"),
("1811729", "Encheng", "Эньпин", "CN", "156", "", "30", "", "", "22.18659", "112.30424", "Asia/Shanghai"),
("1811764", "Duyun", "Дуюн", "CN", "156", "", "18", "1798280", "1811763", "26.26667", "107.51667", "Asia/Shanghai"),
("1811829", "Duobao", "", "CN", "156", "", "12", "", "", "30.67", "112.68952", "Asia/Shanghai"),
("1811929", "Ducheng", "", "CN", "156", "", "30", "", "", "23.24212", "111.5284", "Asia/Shanghai"),
("1812057", "Xinyi", "", "CN", "156", "", "30", "", "", "22.37303", "110.94746", "Asia/Urumqi"),
("1812091", "Dongyuan", "", "CN", "156", "", "07", "", "", "24.91738", "118.75236", "Asia/Shanghai"),
("1812101", "Shengli", "Дуньин", "CN", "156", "", "25", "", "", "37.46271", "118.49165", "Asia/Shanghai"),
("1812168", "Dongxi", "", "CN", "156", "CN", "33", "", "", "28.76139", "106.66111", "Asia/Shanghai"),
("1812228", "Dongtai", "", "CN", "156", "", "04", "", "", "32.85231", "120.30947", "Asia/Shanghai"),
("1812256", "Dongsheng", "", "CN", "156", "", "20", "", "", "39.81609", "109.97763", "Asia/Shanghai"),
("1812427", "Dongkan", "", "CN", "156", "", "04", "", "", "33.99972", "119.83083", "Asia/Shanghai"),
("1812521", "Donghai", "", "CN", "156", "", "30", "", "", "22.94593", "115.64204", "Asia/Shanghai"),
("1812545", "Dongguan", "Дунгуань", "CN", "156", "", "30", "", "", "23.01797", "113.74866", "Asia/Shanghai"),
("1812597", "Dongdu", "", "CN", "156", "", "25", "", "", "35.85", "117.7", "Asia/Shanghai"),
("1812600", "Dongditou", "", "CN", "156", "", "28", "", "", "39.26641", "117.37273", "Asia/Shanghai"),
("1812613", "Dongdai", "", "CN", "156", "", "07", "", "", "26.24366", "119.61566", "Asia/Shanghai"),
("1812621", "Dongcun", "", "CN", "156", "", "25", "", "", "36.77667", "121.15972", "Asia/Shanghai"),
("1812728", "Dingzhou", "", "CN", "156", "", "10", "", "", "38.51306", "114.99556", "Asia/Shanghai"),
("1812754", "Dingtao", "", "CN", "156", "", "25", "", "", "35.07436", "115.56582", "Asia/Shanghai"),
("1812805", "Dinghai", "", "CN", "156", "", "07", "", "", "26.28022", "119.78964", "Asia/Shanghai"),
("1812955", "Dezhou", "Дэчжоу", "CN", "156", "", "25", "", "", "37.45127", "116.31046", "Asia/Shanghai"),
("1812961", "Deyang", "Дэян", "CN", "156", "", "32", "", "", "31.13019", "104.38198", "Asia/Shanghai"),
("1812981", "Deqing", "", "CN", "156", "", "02", "", "", "30.54485", "119.9599", "Asia/Shanghai"),
("1812988", "Dengzhou", "Пэнлай", "CN", "156", "", "25", "", "", "37.80822", "120.75908", "Asia/Shanghai"),
("1812990", "Huazhou", "", "CN", "156", "", "09", "", "", "32.68222", "112.08194", "Asia/Shanghai"),
("1813016", "Songyang", "", "CN", "156", "", "09", "", "", "34.45528", "113.02806", "Asia/Shanghai"),
("1813046", "Dazuo", "", "CN", "156", "", "07", "", "", "24.88616", "118.96433", "Asia/Shanghai"),
("1813088", "Dazhong", "", "CN", "156", "", "04", "", "", "33.19973", "120.4578", "Asia/Shanghai"),
("1813171", "Zhangjiajie", "Чжанцзяцзе", "CN", "156", "", "11", "", "", "29.12944", "110.47833", "Asia/Shanghai"),
("1813206", "Daye", "", "CN", "156", "", "12", "", "", "30.08333", "114.95", "Asia/Shanghai"),
("1813253", "Lijiang", "Лицзян", "CN", "156", "", "29", "", "", "26.86879", "100.22072", "Asia/Shanghai"),
("1813325", "Dazhou", "", "CN", "156", "", "32", "1813324", "1813320", "31.21592", "107.50092", "Asia/Shanghai"),
("1813344", "Dawukou", "", "CN", "156", "", "21", "", "", "39.04194", "106.39583", "Asia/Shanghai"),
("1813383", "Dawangtai", "", "CN", "156", "", "28", "", "", "39.27504", "117.48502", "Asia/Shanghai"),
("1813451", "Datong", "Датун", "CN", "156", "", "01", "", "", "32.62082", "117.06319", "Asia/Shanghai"),
("1813658", "Fenghua", "", "CN", "156", "", "02", "", "", "29.65628", "121.4064", "Asia/Shanghai"),
("1813775", "Daokou", "", "CN", "156", "", "09", "", "", "35.56389", "114.50583", "Asia/Shanghai"),
("1813812", "Danshui", "Даньшуем", "CN", "156", "", "30", "", "", "22.7984", "114.46716", "Asia/Shanghai"),
("1813828", "Danjiangkou", "Даньцзянкоу", "CN", "156", "", "12", "", "", "32.54278", "111.50861", "Asia/Shanghai"),
("1813851", "Gushu", "", "CN", "156", "", "01", "", "", "31.56055", "118.48147", "Asia/Shanghai"),
("1813892", "Xincheng", "", "CN", "156", "", "09", "", "", "33.63333", "115.18333", "Asia/Shanghai"),
("1814082", "Daliang", "Далян", "CN", "156", "", "30", "", "", "22.84067", "113.2503", "Asia/Shanghai"),
("1814087", "Dalian", "Далянь", "CN", "156", "", "19", "1814068", "", "38.91222", "121.60222", "Asia/Shanghai"),
("1814093", "Dali", "Дали", "CN", "156", "", "29", "", "", "25.58474", "100.21229", "Asia/Shanghai"),
("1814123", "Dakoutun", "", "CN", "156", "CN", "28", "", "", "39.58333", "117.22889", "Asia/Shanghai"),
("1814577", "Dabizhuang", "", "CN", "156", "", "28", "", "", "39.19306", "117.25583", "Asia/Shanghai"),
("1814757", "Chuzhou", "Чучжоу", "CN", "156", "", "01", "", "", "32.32194", "118.29778", "Asia/Shanghai"),
("1814786", "Yangchun", "", "CN", "156", "", "30", "", "", "22.16667", "111.78333", "Asia/Shanghai"),
("1814870", "Yiwu", "", "CN", "156", "", "02", "", "", "29.31506", "120.07676", "Asia/Shanghai"),
("1814906", "Chongqing", "Чунцин", "CN", "156", "", "33", "", "", "29.56278", "106.55278", "Asia/Shanghai"),
("1814919", "Chonglong", "", "CN", "156", "", "32", "", "", "29.78062", "104.85224", "Asia/Shanghai"),
("1814934", "Chizhou", "", "CN", "156", "", "01", "", "", "30.66134", "117.47783", "Asia/Shanghai"),
("1814999", "Chitu", "", "CN", "156", "CN", "28", "", "", "39.20333", "117.40278", "Asia/Shanghai"),
("1815059", "Chenzhou", "Чэньчжоу", "CN", "156", "", "11", "1815056", "", "25.8", "113.03333", "Asia/Shanghai"),
("1815184", "Chengyang", "", "CN", "156", "", "25", "", "", "35.57944", "118.83278", "Asia/Shanghai"),
("1815251", "Jiangyin", "", "CN", "156", "", "04", "", "", "31.91102", "120.26302", "Asia/Shanghai"),
("1815286", "Chengdu", "Чэнду", "CN", "156", "", "32", "", "", "30.66667", "104.06667", "Asia/Shanghai"),
("1815302", "Chenghua", "", "CN", "156", "", "30", "", "", "23.46132", "116.77007", "Asia/Shanghai"),
("1815395", "Chaozhou", "Чаочжоу", "CN", "156", "", "30", "", "", "23.65396", "116.62262", "Asia/Shanghai"),
("1815427", "Chaohu", "", "CN", "156", "", "01", "", "", "31.6", "117.86667", "Asia/Shanghai"),
("1815456", "Changzhou", "Чанчжоу", "CN", "156", "", "04", "", "", "31.77359", "119.95401", "Asia/Shanghai"),
("1815463", "Changzhi", "Чанчжи", "CN", "156", "", "24", "", "", "35.20889", "111.73861", "Asia/Shanghai"),
("1815577", "Changsha", "Чанша", "CN", "156", "", "11", "1815551", "", "28.19874", "112.97087", "Asia/Shanghai"),
("1815585", "Changqing", "Чанцин", "CN", "156", "", "25", "", "", "36.5575", "116.72722", "Asia/Shanghai"),
("1815656", "Changli", "Чанли", "CN", "156", "", "10", "", "", "39.70417", "119.15056", "Asia/Shanghai"),
("1815667", "Changleng", "", "CN", "156", "", "03", "", "", "28.7", "115.81667", "Asia/Shanghai"),
("1816026", "Caohe", "", "CN", "156", "", "12", "", "", "30.2297", "115.43346", "Asia/Shanghai"),
("1816028", "Weining", "Вэйнин", "CN", "156", "", "18", "", "", "26.85", "104.23333", "Asia/Shanghai"),
("1816080", "Cangzhou", "Цанчжоу", "CN", "156", "", "10", "", "", "38.31667", "116.86667", "Asia/Shanghai"),
("1816176", "Caidian", "", "CN", "156", "", "12", "", "", "30.58333", "114.03333", "Asia/Shanghai"),
("1816221", "Buhe", "Бухэ", "CN", "156", "", "12", "", "", "30.28757", "112.22979", "Asia/Shanghai"),
("1816234", "Bozhou", "Бочжоу", "CN", "156", "", "01", "11287254", "", "33.87722", "115.77028", "Asia/Shanghai"),
("1816256", "Botou", "Бота", "CN", "156", "", "10", "", "", "38.06667", "116.5666", "Asia/Shanghai"),
("1816265", "Boshan", "", "CN", "156", "", "25", "", "", "36.48333", "117.83333", "Asia/Shanghai"),
("1816269", "Baise City", "Бозе", "CN", "156", "", "16", "", "", "23.89972", "106.61333", "Asia/Shanghai"),
("1816336", "Binzhou", "", "CN", "156", "", "25", "", "", "37.36667", "118.01667", "Asia/Shanghai"),
("1816338", "Luxu", "", "CN", "156", "", "16", "", "", "23.22378", "108.80217", "Asia/Shanghai"),
("1816373", "Bijie", "Бицзе", "CN", "156", "", "18", "1816372", "", "27.30193", "105.28627", "Asia/Shanghai"),
("1816401", "Biaokou", "", "CN", "156", "", "28", "", "", "39.32527", "117.55378", "Asia/Shanghai"),
("1816406", "Bianzhuang", "", "CN", "156", "", "25", "", "", "34.84861", "118.04472", "Asia/Shanghai"),
("1816440", "Bengbu", "Бэнбу", "CN", "156", "", "01", "", "", "32.94083", "117.36083", "Asia/Shanghai"),
("1816670", "Beijing", "Пекин", "CN", "156", "", "22", "", "", "39.9075", "116.39723", "Asia/Shanghai"),
("1816693", "Beihuaidian", "", "CN", "156", "", "28", "", "", "39.25854", "117.56378", "Asia/Shanghai"),
("1816705", "Beihai", "Бэйхай", "CN", "156", "", "16", "", "", "21.48333", "109.1", "Asia/Shanghai"),
("1816751", "Beidao", "", "CN", "156", "", "15", "", "", "34.56861", "105.89333", "Asia/Shanghai"),
("1816753", "Beidaihehaibin", "Бейдайхэ", "CN", "156", "CN", "10", "", "", "39.82222", "119.51806", "Asia/Shanghai"),
("1816781", "Beicang", "", "CN", "156", "", "28", "", "", "39.2357", "117.12262", "Asia/Shanghai"),
("1816790", "Beibei", "Бэй", "CN", "156", "", "33", "", "", "29.82739", "106.43645", "Asia/Shanghai"),
("1816890", "Baoying", "", "CN", "156", "", "04", "", "", "33.22917", "119.30917", "Asia/Shanghai"),
("1816924", "Langzhong", "", "CN", "156", "", "32", "", "", "31.55037", "105.99381", "Asia/Shanghai"),
("1816971", "Baoding", "Баодин", "CN", "156", "", "10", "", "", "38.85111", "115.49028", "Asia/Shanghai"),
("1817090", "Bangjun", "", "CN", "156", "CN", "28", "", "", "39.99111", "117.26278", "Asia/Shanghai"),
("1817240", "Baiyin", "", "CN", "156", "", "15", "", "", "36.54696", "104.17023", "Asia/Shanghai"),
("1817701", "Baihe", "", "CN", "156", "", "16", "", "", "22.1343", "107.232", "Asia/Shanghai"),
("1817720", "Shangyu", "", "CN", "156", "CN", "02", "", "", "30.01556", "120.87111", "Asia/Shanghai"),
("1817858", "Babu", "Бабу", "CN", "156", "", "16", "", "", "24.41667", "111.51667", "Asia/Shanghai"),
("1817952", "Anxiang", "", "CN", "156", "", "11", "", "", "29.4", "112.15", "Asia/Shanghai"),
("1817968", "Anshun", "Аньшунь", "CN", "156", "", "18", "", "", "26.25", "105.93333", "Asia/Shanghai"),
("1817990", "Anqiu", "", "CN", "156", "", "25", "", "", "36.43417", "119.1925", "Asia/Shanghai"),
("1817993", "Anqing", "Аньцин", "CN", "156", "", "01", "", "", "30.51365", "117.04723", "Asia/Shanghai"),
("1818004", "Mabai", "", "CN", "156", "", "29", "", "", "23.01279", "104.45081", "Asia/Shanghai"),
("1818016", "Anlu", "", "CN", "156", "", "12", "", "", "31.2575", "113.67833", "Asia/Shanghai"),
("1818051", "Anjiang", "", "CN", "156", "", "11", "", "", "27.31944", "110.10306", "Asia/Shanghai"),
("1818116", "Anbu", "", "CN", "156", "", "30", "", "", "23.44895", "116.68092", "Asia/Shanghai"),
("1885823", "Jiangyou", "", "CN", "156", "", "32", "", "", "31.76667", "104.71667", "Asia/Shanghai"),
("1886760", "Suzhou", "Сучжоу", "CN", "156", "", "04", "", "", "31.30408", "120.59538", "Asia/Shanghai"),
("1886762", "Zhoushan", "Чжоушань", "CN", "156", "", "02", "", "", "29.98869", "122.20488", "Asia/Shanghai"),
("1898359", "Mudu", "Муду", "CN", "156", "", "04", "", "", "31.25597", "120.51857", "Asia/Shanghai"),
("1898494", "Songling", "Сунлин", "CN", "156", "", "04", "", "", "31.1933", "120.71758", "Asia/Shanghai"),
("1915223", "Zhongshan", "", "CN", "156", "", "30", "", "", "21.31992", "110.5723", "Asia/Urumqi"),
("1919014", "Lianghu", "", "CN", "156", "", "02", "", "", "29.99152", "120.89845", "Asia/Shanghai"),
("1920772", "Zhoucheng", "", "CN", "156", "", "25", "", "", "35.91222", "116.31167", "Asia/Shanghai"),
("1921372", "Dalianwan", "", "CN", "156", "", "19", "", "", "39.02861", "121.695", "Asia/Shanghai"),
("1927639", "Yueyang", "Юэян", "CN", "156", "", "11", "", "", "29.37455", "113.09481", "Asia/Shanghai"),
("1929434", "Bojia", "", "CN", "156", "", "11", "", "", "26.46722", "111.96806", "Asia/Shanghai"),
("1941693", "Xinzhuang", "", "CN", "156", "", "28", "", "", "39.0249", "117.34377", "Asia/Shanghai"),
("1941783", "Rong’an", "", "CN", "156", "", "07", "", "", "26.12472", "119.12139", "Asia/Shanghai"),
("1941784", "Shangjie", "", "CN", "156", "", "07", "", "", "26.08679", "119.18494", "Asia/Shanghai"),
("1941833", "Houyu", "", "CN", "156", "", "07", "", "", "26.05958", "119.53502", "Asia/Shanghai"),
("2033128", "Zhenlai", "", "CN", "156", "", "05", "", "", "45.84955", "123.2973", "Asia/Shanghai"),
("2033135", "Zhengjiatun", "", "CN", "156", "", "05", "", "", "43.50639", "123.50639", "Asia/Shanghai"),
("2033147", "Zhaozhou", "Чжаочжоу", "CN", "156", "", "08", "", "", "45.68333", "125.31667", "Asia/Shanghai"),
("2033149", "Zhaoyuan", "", "CN", "156", "", "08", "", "", "45.5", "125.13333", "Asia/Shanghai"),
("2033168", "Zhaodong", "", "CN", "156", "", "08", "", "", "46.06771", "125.98263", "Asia/Shanghai"),
("2033196", "Zhangjiakou", "Чжанцзякоу", "CN", "156", "", "10", "", "", "40.81", "114.87944", "Asia/Shanghai"),
("2033225", "Zhalantun", "Чжаланьтунь", "CN", "156", "", "20", "", "", "48.00945", "122.73651", "Asia/Shanghai"),
("2033242", "Yushu", "Юйшу", "CN", "156", "", "05", "", "", "44.8", "126.53333", "Asia/Shanghai"),
("2033301", "Youhao", "", "CN", "156", "", "08", "", "", "47.85306", "128.83565", "Asia/Shanghai"),
("2033370", "Yingkou", "Инкоу", "CN", "156", "", "19", "2033369", "", "40.66482", "122.22833", "Asia/Shanghai"),
("2033403", "Yilan", "", "CN", "156", "", "08", "", "", "46.31618", "129.55455", "Asia/Shanghai"),
("2033413", "Yichun", "Ичунь", "CN", "156", "", "08", "", "", "47.72143", "128.87529", "Asia/Shanghai"),
("2033423", "Yebaishou", "", "CN", "156", "", "19", "", "", "41.3975", "119.64083", "Asia/Shanghai"),
("2033449", "Yantongshan", "", "CN", "156", "", "05", "", "", "43.29194", "126.00944", "Asia/Shanghai"),
("2033467", "Yanji", "Яньцзи", "CN", "156", "", "05", "", "", "42.9075", "129.50778", "Asia/Shanghai"),
("2033536", "Yakeshi", "Якэши", "CN", "156", "", "20", "", "", "49.28333", "120.73333", "Asia/Shanghai"),
("2033574", "Zhangjiakou Shi Xuanhua Qu", "", "CN", "156", "", "10", "", "", "40.61028", "115.04472", "Asia/Shanghai"),
("2033602", "Xiuyan", "", "CN", "156", "", "19", "", "", "40.29278", "123.27444", "Asia/Shanghai"),
("2033667", "Xinqing", "", "CN", "156", "", "08", "", "", "48.28701", "129.52337", "Asia/Shanghai"),
("2033675", "Xinmin", "Синьминь", "CN", "156", "", "19", "", "", "41.99083", "122.82528", "Asia/Shanghai"),
("2033739", "Xinglongshan", "", "CN", "156", "", "05", "", "", "43.95611", "125.46611", "Asia/Shanghai"),
("2033766", "Xingcheng", "Синчэн", "CN", "156", "", "19", "", "", "40.61667", "120.71667", "Asia/Shanghai"),
("2033824", "Xilin Hot", "", "CN", "156", "", "20", "", "", "43.96667", "116.03333", "Asia/Shanghai"),
("2033866", "Xifeng", "", "CN", "156", "", "19", "", "", "42.73722", "124.72222", "Asia/Shanghai"),
("2033934", "Xiaoshi", "", "CN", "156", "", "19", "", "", "41.29711", "124.12092", "Asia/Shanghai"),
("2034141", "Wuchang", "Учан", "CN", "156", "", "08", "", "", "44.91428", "127.15001", "Asia/Shanghai"),
("2034221", "Wangqing", "Ванцине", "CN", "156", "", "05", "", "", "43.32179", "129.76342", "Asia/Shanghai"),
("2034226", "Hepingjie", "", "CN", "156", "", "05", "", "", "42.05972", "126.91583", "Asia/Shanghai"),
("2034228", "Wangkui", "", "CN", "156", "", "08", "", "", "46.83283", "126.47768", "Asia/Shanghai"),
("2034312", "Ulanhot", "", "CN", "156", "", "20", "", "", "46.08333", "122.08333", "Asia/Shanghai"),
("2034340", "Tumen", "Тюменский", "CN", "156", "", "05", "", "", "42.96611", "129.8425", "Asia/Shanghai"),
("2034400", "Tongliao", "", "CN", "156", "", "20", "", "", "43.6125", "122.26528", "Asia/Shanghai"),
("2034439", "Tieling", "Телин", "CN", "156", "", "19", "2034437", "", "42.29306", "123.84139", "Asia/Shanghai"),
("2034440", "Tieli", "", "CN", "156", "", "08", "", "", "46.98043", "128.04497", "Asia/Shanghai"),
("2034497", "Guangming", "Таонань", "CN", "156", "", "05", "", "", "45.33333", "122.78333", "Asia/Shanghai"),
("2034599", "Tailai", "", "CN", "156", "", "08", "", "", "46.38909", "123.41371", "Asia/Shanghai"),
("2034600", "Taikang", "", "CN", "156", "", "08", "", "", "46.86135", "124.442", "Asia/Shanghai"),
("2034615", "Tahe", "", "CN", "156", "", "08", "", "", "52.33333", "124.73333", "Asia/Shanghai"),
("2034638", "Sujiatun", "Суцзятунь", "CN", "156", "", "19", "", "", "41.65917", "123.33917", "Asia/Shanghai"),
("2034651", "Suileng", "", "CN", "156", "", "08", "", "", "47.24805", "127.09535", "Asia/Shanghai"),
("2034655", "Suihua", "", "CN", "156", "", "08", "", "", "46.63954", "126.99508", "Asia/Shanghai"),
("2034657", "Suifenhe", "", "CN", "156", "", "08", "", "", "44.39982", "131.14775", "Asia/Shanghai"),
("2034691", "Songjianghe", "", "CN", "156", "", "05", "", "", "42.1859", "127.47895", "Asia/Shanghai"),
("2034714", "Siping", "", "CN", "156", "", "05", "", "", "43.16143", "124.37785", "Asia/Shanghai"),
("2034754", "Shunyi", "Шуньи", "CN", "156", "", "22", "", "", "40.12175", "116.64783", "Asia/Shanghai"),
("2034761", "Shulan", "Шулань", "CN", "156", "", "05", "", "", "44.41667", "126.95", "Asia/Shanghai"),
("2034786", "Shuangyashan", "", "CN", "156", "CN", "08", "", "", "46.63611", "131.15389", "Asia/Shanghai"),
("2034791", "Shuangyang", "", "CN", "156", "", "05", "", "", "43.52417", "125.67361", "Asia/Shanghai"),
("2034834", "Shuangcheng", "", "CN", "156", "", "08", "", "", "45.35", "126.28333", "Asia/Shanghai"),
("2034918", "Shiguai", "", "CN", "156", "", "20", "", "", "40.70583", "110.28556", "Asia/Shanghai"),
("2034937", "Shenyang", "Шэньян", "CN", "156", "", "19", "2034935", "", "41.79222", "123.43278", "Asia/Shanghai"),
("2034995", "Shanhetun", "", "CN", "156", "", "08", "", "", "44.7", "127.2", "Asia/Shanghai"),
("2034996", "Shanhaiguan", "", "CN", "156", "", "10", "", "", "40.0025", "119.74889", "Asia/Shanghai"),
("2035002", "Shangzhi", "", "CN", "156", "", "08", "", "", "45.21406", "127.97426", "Asia/Shanghai"),
("2035182", "Sanchazi", "", "CN", "156", "", "05", "", "", "42.08167", "126.60028", "Asia/Shanghai"),
("2035196", "Salaqi", "", "CN", "156", "", "20", "", "", "40.54139", "110.51083", "Asia/Shanghai"),
("2035225", "Fendou", "", "CN", "156", "", "08", "", "", "46.64142", "124.86283", "Asia/Shanghai"),
("2035261", "Taihe", "", "CN", "156", "", "08", "", "", "45.76195", "130.85131", "Asia/Shanghai"),
("2035265", "Qiqihar", "Цицикар", "CN", "156", "", "08", "", "", "47.34088", "123.96045", "Asia/Shanghai"),
("2035325", "Qinggang", "", "CN", "156", "", "08", "", "", "46.68469", "126.10595", "Asia/Shanghai"),
("2035399", "Songyuan", "", "CN", "156", "", "05", "6587798", "6587792", "45.12902", "124.82769", "Asia/Shanghai"),
("2035453", "Pingzhuang", "", "CN", "156", "", "20", "", "", "42.03722", "119.28889", "Asia/Shanghai"),
("2035511", "Panshi", "Паньши", "CN", "156", "", "05", "", "", "42.94222", "126.05611", "Asia/Shanghai"),
("2035513", "Panshan", "", "CN", "156", "", "19", "", "", "41.18806", "122.04944", "Asia/Shanghai"),
("2035593", "Nianzishan", "", "CN", "156", "", "08", "", "", "47.51667", "122.88333", "Asia/Shanghai"),
("2035601", "Nenjiang", "", "CN", "156", "", "08", "", "", "49.17414", "125.21774", "Asia/Shanghai"),
("2035610", "Nehe", "Нэхэ", "CN", "156", "", "08", "", "", "48.48333", "124.83333", "Asia/Shanghai"),
("2035635", "Nantai", "", "CN", "156", "", "19", "", "", "40.9241", "122.80437", "Asia/Shanghai"),
("2035644", "Nanpiao", "", "CN", "156", "", "19", "", "", "41.09822", "120.74792", "Asia/Shanghai"),
("2035669", "Lianhe", "", "CN", "156", "", "08", "", "", "47.13333", "129.27426", "Asia/Shanghai"),
("2035707", "Mujiayingzi", "", "CN", "156", "", "20", "", "", "42.11667", "118.78333", "Asia/Shanghai"),
("2035715", "Mudanjiang", "Муданьцзян", "CN", "156", "", "08", "", "", "44.58333", "129.6", "Asia/Shanghai"),
("2035746", "Mishan", "Мишань", "CN", "156", "", "08", "", "", "45.55", "131.88333", "Asia/Shanghai"),
("2035754", "Mingyue", "", "CN", "156", "", "05", "", "", "43.10694", "128.92167", "Asia/Shanghai"),
("2035758", "Mingshui", "", "CN", "156", "", "08", "", "", "47.1815", "125.90027", "Asia/Shanghai"),
("2035801", "Meihekou", "", "CN", "156", "", "05", "", "", "42.52722", "125.67528", "Asia/Shanghai"),
("2035836", "Manzhouli", "Маньчжурия", "CN", "156", "", "20", "", "", "49.6", "117.43333", "Asia/Shanghai"),
("2035966", "Longjing", "", "CN", "156", "", "05", "", "", "42.77139", "129.42333", "Asia/Shanghai"),
("2035970", "Longjiang", "Лонцзян", "CN", "156", "", "08", "", "", "47.33072", "123.17816", "Asia/Shanghai"),
("2035980", "Longfeng", "", "CN", "156", "", "08", "", "", "46.53168", "125.1038", "Asia/Shanghai"),
("2036033", "Liuhe", "Люхэ", "CN", "156", "", "05", "", "", "42.24007", "125.71717", "Asia/Shanghai"),
("2036055", "Lishu", "Лишать", "CN", "156", "", "05", "", "", "43.30472", "124.32778", "Asia/Shanghai"),
("2036066", "Linkou", "", "CN", "156", "", "08", "", "", "45.28606", "130.26151", "Asia/Shanghai"),
("2036069", "Linjiang", "Линьцзяне", "CN", "156", "", "05", "", "", "41.80694", "126.90778", "Asia/Shanghai"),
("2036075", "Lingyuan", "", "CN", "156", "", "19", "", "", "41.24", "119.40111", "Asia/Shanghai"),
("2036081", "Lingdong", "", "CN", "156", "", "08", "", "", "46.56694", "131.14528", "Asia/Shanghai"),
("2036106", "Liaozhong", "", "CN", "156", "", "19", "", "", "41.50611", "122.72417", "Asia/Shanghai"),
("2036109", "Liaoyuan", "", "CN", "156", "", "05", "", "", "42.90361", "125.13583", "Asia/Shanghai"),
("2036113", "Liaoyang", "Ляоян", "CN", "156", "", "19", "", "", "41.27194", "123.17306", "Asia/Shanghai"),
("2036226", "Lanxi", "", "CN", "156", "", "08", "", "", "46.25785", "126.28269", "Asia/Shanghai"),
("2036237", "Langxiang", "", "CN", "156", "", "08", "", "", "46.94985", "128.86849", "Asia/Shanghai"),
("2036241", "Langtou", "", "CN", "156", "", "19", "", "", "40.02611", "124.32861", "Asia/Shanghai"),
("2036283", "Kuandian", "", "CN", "156", "", "19", "", "", "40.72861", "124.78472", "Asia/Shanghai"),
("2036337", "Kaiyuan", "Кайюань", "CN", "156", "", "19", "", "", "42.53306", "124.04028", "Asia/Shanghai"),
("2036338", "Kaitong", "", "CN", "156", "", "05", "", "", "44.81351", "123.15", "Asia/Shanghai"),
("2036389", "Jixi", "Цзиси", "CN", "156", "", "08", "", "", "45.30109", "130.95718", "Asia/Shanghai"),
("2036401", "Jiutai", "", "CN", "156", "", "05", "", "", "44.1525", "125.83278", "Asia/Shanghai"),
("2036403", "Jiupu", "", "CN", "156", "", "19", "2038630", "", "41.06667", "122.95", "Asia/Shanghai"),
("2036418", "Jishu", "", "CN", "156", "", "05", "", "", "44.31667", "126.8", "Asia/Shanghai"),
("2036427", "Jinzhou", "Цзиньчжоу", "CN", "156", "", "19", "", "", "41.10778", "121.14167", "Asia/Shanghai"),
("2036434", "Lianshan", "", "CN", "156", "", "19", "", "", "40.76432", "120.85327", "Asia/Shanghai"),
("2036458", "Jining", "Цзинин", "CN", "156", "", "20", "", "", "41.0275", "113.10583", "Asia/Shanghai"),
("2036502", "Jilin", "Цзилинь", "CN", "156", "", "05", "", "", "43.85083", "126.56028", "Asia/Shanghai"),
("2036519", "Jidong", "", "CN", "156", "", "08", "", "", "45.21667", "131.08333", "Asia/Shanghai"),
("2036536", "Minzhu", "Цзяохэ", "CN", "156", "", "05", "", "", "43.72145", "127.33401", "Asia/Shanghai"),
("2036581", "Jiamusi", "Цзямусы", "CN", "156", "", "08", "", "", "46.79927", "130.31633", "Asia/Shanghai"),
("2036595", "Jalai Nur", "Чжалайнор", "CN", "156", "", "20", "", "", "49.45", "117.7", "Asia/Shanghai"),
("2036597", "Jagdaqi", "", "CN", "156", "", "20", "", "", "50.41667", "124.11667", "Asia/Shanghai"),
("2036619", "Hushitai", "", "CN", "156", "", "19", "", "", "41.93222", "123.51139", "Asia/Shanghai"),
("2036653", "Hunchun", "Хуньчунь", "CN", "156", "", "05", "", "", "42.8675", "130.35806", "Asia/Shanghai"),
("2036670", "Hulan Ergi", "", "CN", "156", "", "08", "", "", "47.20417", "123.63333", "Asia/Shanghai"),
("2036671", "Hulan", "Хулан", "CN", "156", "", "08", "", "", "45.98333", "126.6", "Asia/Shanghai"),
("2036685", "Huinan", "", "CN", "156", "", "05", "", "", "42.6225", "126.26139", "Asia/Shanghai"),
("2036713", "Huanren", "", "CN", "156", "", "19", "", "", "41.26472", "125.36667", "Asia/Shanghai"),
("2036734", "Huangnihe", "", "CN", "156", "", "05", "", "", "43.55833", "128.02389", "Asia/Shanghai"),
("2036753", "Huanan", "", "CN", "156", "", "08", "", "", "46.2207", "130.525", "Asia/Shanghai"),
("2036776", "Huadian", "", "CN", "156", "", "05", "", "", "42.96333", "126.74778", "Asia/Shanghai"),
("2036876", "Honggang", "", "CN", "156", "", "08", "", "", "46.40124", "124.88322", "Asia/Shanghai"),
("2036892", "Hohhot", "Хух-Хото", "CN", "156", "", "20", "", "", "40.81056", "111.65222", "Asia/Shanghai"),
("2036920", "Fendou", "", "CN", "156", "", "08", "", "", "45.21235", "130.90254", "Asia/Shanghai"),
("2036933", "Helong", "Хэлуне", "CN", "156", "", "05", "", "", "42.53974", "128.99722", "Asia/Shanghai"),
("2036959", "Heishan", "", "CN", "156", "", "19", "", "", "41.68917", "122.11278", "Asia/Shanghai"),
("2036973", "Heihe", "Хэйхэ", "CN", "156", "", "08", "", "", "50.24413", "127.49016", "Asia/Shanghai"),
("2036986", "Hegang", "Хэган", "CN", "156", "", "08", "", "", "47.35118", "130.30012", "Asia/Shanghai"),
("2037013", "Harbin", "Харбин", "CN", "156", "", "08", "", "", "45.75", "126.65", "Asia/Shanghai"),
("2037069", "Hailun", "", "CN", "156", "", "08", "", "", "47.4565", "126.95368", "Asia/Shanghai"),
("2037075", "Hailin", "Хайлин", "CN", "156", "", "08", "", "", "44.57149", "129.38539", "Asia/Shanghai"),
("2037078", "Hailar", "Хайлар", "CN", "156", "", "20", "", "", "49.2", "119.7", "Asia/Shanghai"),
("2037086", "Haicheng", "", "CN", "156", "", "19", "", "", "40.85158", "122.74754", "Asia/Shanghai"),
("2037222", "Gongzhuling", "Гунчжулина", "CN", "156", "", "05", "", "", "43.50075", "124.81979", "Asia/Shanghai"),
("2037240", "Gongchangling", "", "CN", "156", "", "19", "", "", "41.11667", "123.45", "Asia/Shanghai"),
("2037252", "Genhe", "", "CN", "156", "", "20", "", "", "50.78333", "121.51667", "Asia/Shanghai"),
("2037311", "Gannan", "", "CN", "156", "", "08", "", "", "47.91472", "123.50306", "Asia/Shanghai"),
("2037330", "Fuyuan", "Фуюань", "CN", "156", "", "08", "", "", "48.36306", "134.28917", "Asia/Shanghai"),
("2037334", "Fuyu", "", "CN", "156", "", "08", "", "", "47.79756", "124.45731", "Asia/Shanghai"),
("2037335", "Fuyu", "", "CN", "156", "", "05", "", "", "45.18333", "124.81667", "Asia/Shanghai"),
("2037345", "Fuxin", "Фусинь", "CN", "156", "", "19", "", "", "42.05889", "121.745", "Asia/Shanghai"),
("2037346", "Fuxin", "Фусинь", "CN", "156", "", "19", "", "", "42.01556", "121.65889", "Asia/Shanghai"),
("2037355", "Fushun", "Фушунь", "CN", "156", "", "19", "", "", "41.85583", "123.92333", "Asia/Shanghai"),
("2037370", "Fuli", "Фули", "CN", "156", "", "08", "", "", "46.72167", "131.13944", "Asia/Shanghai"),
("2037375", "Fujin", "Фуцзинь", "CN", "156", "", "08", "", "", "47.26", "132.03222", "Asia/Shanghai"),
("2037391", "Beichengqu", "", "CN", "156", "", "20", "", "", "40.43944", "113.15361", "Asia/Shanghai"),
("2037393", "Fengxiang", "Фенгсианг", "CN", "156", "", "08", "", "", "47.57549", "130.82306", "Asia/Shanghai"),
("2037411", "Fengcheng", "", "CN", "156", "", "19", "", "", "40.45361", "124.07167", "Asia/Shanghai"),
("2037485", "Erenhot", "", "CN", "156", "", "20", "", "", "43.6475", "111.97667", "Asia/Shanghai"),
("2037494", "Erdaojiang", "", "CN", "156", "", "05", "", "", "41.77639", "126.03194", "Asia/Shanghai"),
("2037534", "Dunhua", "Дуньхуа", "CN", "156", "", "05", "", "", "43.3725", "128.2425", "Asia/Shanghai"),
("2037611", "Dongning", "", "CN", "156", "", "08", "", "", "44.06219", "131.12075", "Asia/Shanghai"),
("2037620", "Dongling", "Донлин", "CN", "156", "", "19", "", "", "41.81444", "123.57583", "Asia/Shanghai"),
("2037658", "Dongfeng", "", "CN", "156", "", "05", "", "", "42.64031", "125.51176", "Asia/Shanghai"),
("2037685", "Dongxing", "", "CN", "156", "", "08", "", "", "45.36088", "130.78679", "Asia/Shanghai"),
("2037712", "Dehui", "", "CN", "156", "", "05", "", "", "44.53333", "125.7", "Asia/Shanghai"),
("2037799", "Datong", "Датун", "CN", "156", "", "24", "", "", "40.09361", "113.29139", "Asia/Shanghai"),
("2037820", "Dashitou", "", "CN", "156", "", "05", "", "", "43.30667", "128.51139", "Asia/Shanghai"),
("2037823", "Dashiqiao", "", "CN", "156", "", "19", "", "", "40.63732", "122.50251", "Asia/Shanghai"),
("2037860", "Daqing", "Дацин", "CN", "156", "", "08", "", "", "46.58333", "125", "Asia/Shanghai"),
("2037886", "Dandong", "Даньдун", "CN", "156", "", "19", "", "", "40.12917", "124.39472", "Asia/Shanghai"),
("2037913", "Linghai", "", "CN", "156", "", "19", "", "", "41.16528", "121.36667", "Asia/Shanghai"),
("2037930", "Dalai", "", "CN", "156", "", "05", "", "", "45.5", "124.3", "Asia/Shanghai"),
("2038067", "Chifeng", "Чифэн", "CN", "156", "", "20", "", "", "42.26833", "118.96361", "Asia/Shanghai"),
("2038080", "Chengzihe", "", "CN", "156", "", "08", "", "", "45.33333", "131.06667", "Asia/Shanghai"),
("2038087", "Chengde", "Чэндэ", "CN", "156", "", "10", "2038085", "2038084", "40.9519", "117.95883", "Asia/Shanghai"),
("2038118", "Chaoyang", "Чаоян", "CN", "156", "", "05", "", "", "42.66223", "126.0263", "Asia/Shanghai"),
("2038120", "Chaoyang", "Чаоян", "CN", "156", "", "19", "", "", "41.57028", "120.45861", "Asia/Shanghai"),
("2038139", "Changtu", "Чанту", "CN", "156", "", "19", "", "", "42.77884", "124.09545", "Asia/Shanghai"),
("2038154", "Changping", "Чанпин", "CN", "156", "", "22", "", "", "40.21612", "116.23471", "Asia/Shanghai"),
("2038158", "Changling", "", "CN", "156", "", "05", "", "", "44.26532", "124.00045", "Asia/Shanghai"),
("2038180", "Changchun", "Чанчунь", "CN", "156", "", "05", "2038176", "", "43.88", "125.32278", "Asia/Shanghai"),
("2038198", "Chaihe", "", "CN", "156", "", "08", "", "", "44.7598", "129.67826", "Asia/Shanghai"),
("2038274", "Boli", "Боли", "CN", "156", "", "08", "", "", "45.75279", "130.57211", "Asia/Shanghai"),
("2038283", "Binzhou", "", "CN", "156", "", "08", "", "", "45.75281", "127.47986", "Asia/Shanghai"),
("2038300", "Benxi", "Бэньси", "CN", "156", "", "19", "", "", "41.28861", "123.765", "Asia/Shanghai"),
("2038342", "Beipiao", "", "CN", "156", "", "19", "", "", "41.79194", "120.77917", "Asia/Shanghai"),
("2038365", "Bei’an", "", "CN", "156", "", "08", "", "", "48.26667", "126.6", "Asia/Shanghai"),
("2038421", "Bayan", "Баян", "CN", "156", "", "08", "", "", "46.07556", "127.3984", "Asia/Shanghai"),
("2038432", "Baotou", "Баотоу", "CN", "156", "CN", "20", "", "", "40.65222", "109.82222", "Asia/Shanghai"),
("2038438", "Baoshan", "Баошань", "CN", "156", "", "08", "", "", "46.55861", "131.42444", "Asia/Shanghai"),
("2038446", "Baoqing", "Баоцин", "CN", "156", "", "08", "", "", "46.33167", "132.21111", "Asia/Shanghai"),
("2038482", "Bamiantong", "", "CN", "156", "", "08", "", "", "44.91738", "130.52", "Asia/Shanghai"),
("2038529", "Baishishan", "", "CN", "156", "", "05", "", "", "43.58333", "127.56667", "Asia/Shanghai"),
("2038541", "Baiquan", "", "CN", "156", "", "08", "", "", "47.60605", "126.08481", "Asia/Shanghai"),
("2038569", "Baicheng", "Байчен", "CN", "156", "", "05", "", "", "45.60746", "122.82076", "Asia/Shanghai"),
("2038584", "Baishan", "Байшань", "CN", "156", "", "05", "", "", "41.93853", "126.41965", "Asia/Shanghai"),
("2038632", "Anshan", "Аньшань", "CN", "156", "", "19", "2038630", "", "41.12361", "122.99", "Asia/Shanghai"),
("2038650", "Anda", "Анда", "CN", "156", "", "08", "", "", "46.40202", "125.31454", "Asia/Shanghai"),
("2038665", "Oroqen Zizhiqi", "Алихэ", "CN", "156", "", "20", "", "", "50.56667", "123.71667", "Asia/Shanghai"),
("2038679", "Acheng", "Ахенг", "CN", "156", "", "08", "", "", "45.54545", "126.97703", "Asia/Shanghai"),
("2047837", "Songling", "", "CN", "156", "", "10", "", "", "40.29303", "118.26908", "Asia/Shanghai"),
("6825277", "Shilin", "Шилин", "CN", "156", "", "29", "", "", "24.81878", "103.33237", "Asia/Shanghai"),
("7283386", "Changshu City", "", "CN", "156", "", "04", "", "", "31.64615", "120.74221", "Asia/Shanghai"),
("7290013", "Shixing", "", "CN", "156", "", "30", "", "", "24.94824", "114.06572", "Asia/Shanghai"),
("7303248", "Jiashan", "", "CN", "156", "", "02", "", "", "30.84918", "120.92583", "Asia/Shanghai"),
("7304020", "Fenghuang", "Фенхуань", "CN", "156", "", "11", "", "", "27.93557", "109.59961", "Asia/Shanghai"),
("7602670", "Zhu Cheng City", "", "CN", "156", "", "25", "", "", "35.99502", "119.40259", "Asia/Shanghai"),
("7910932", "Shangri-La", "Шангри-Ла", "CN", "156", "", "29", "1281365", "", "27.82511", "99.70779", "Asia/Shanghai"),
("8347664", "Ordos", "Ордос", "CN", "156", "", "20", "", "", "39.6086", "109.78157", "Asia/Shanghai"),
("8505006", "Wenshan City", "", "CN", "156", "", "29", "1791424", "", "23.36306", "104.25047", "Asia/Shanghai"),
("8533133", "Liupanshui", "", "CN", "156", "", "18", "", "", "26.59444", "104.83333", "Asia/Shanghai"),
("3533556", "Zaza del Medio", "", "CU", "192", "", "14", "", "", "21.99712", "-79.36678", "America/Havana"),
("3533753", "Yara", "", "CU", "192", "", "09", "", "", "20.27465", "-76.95132", "America/Havana"),
("3533826", "Yaguajay", "", "CU", "192", "", "14", "", "", "22.32691", "-79.23567", "America/Havana"),
("3534094", "Viñales", "Виньялес", "CU", "192", "", "01", "2108", "", "22.61892", "-83.70694", "America/Havana"),
("3534363", "Vertientes", "", "CU", "192", "", "05", "", "", "21.25817", "-78.14979", "America/Havana"),
("3534432", "Venezuela", "", "CU", "192", "", "07", "", "", "21.73748", "-78.79336", "America/Havana"),
("3534632", "Varadero", "Варадеро", "CU", "192", "CU", "03", "", "", "23.15678", "-81.24441", "America/Havana"),
("3534749", "San Germán", "", "CU", "192", "", "12", "", "", "20.60009", "-76.13364", "America/Havana"),
("3534761", "Unión de Reyes", "", "CU", "192", "", "03", "", "", "22.79505", "-81.53617", "America/Havana"),
("3534915", "Trinidad", "Тринидад", "CU", "192", "", "14", "", "", "21.80224", "-79.98467", "America/Havana"),
("3535143", "Topes de Collantes", "", "CU", "192", "", "14", "2806", "", "21.91524", "-80.01929", "America/Havana"),
("3535775", "Soroa", "", "CU", "192", "", "AR", "", "", "22.8", "-83.01667", "America/Havana"),
("3536259", "Sibanicú", "", "CU", "192", "", "05", "", "", "21.23631", "-77.52561", "America/Havana"),
("3536640", "Santo Domingo", "", "CU", "192", "", "16", "", "", "22.58677", "-80.24261", "America/Havana"),
("3536724", "Santiago de las Vegas", "Сантьяго-де-лас-Вегас", "CU", "192", "", "02", "2313", "", "22.97", "-82.38694", "America/Havana"),
("3536729", "Santiago de Cuba", "Сантьяго-де-Куба", "CU", "192", "", "15", "3406", "", "20.02083", "-75.82667", "America/Havana"),
("3537840", "Santa Cruz del Sur", "", "CU", "192", "", "05", "", "", "20.71633", "-77.99816", "America/Havana"),
("3537845", "Santa Cruz del Norte", "", "CU", "192", "", "MA", "", "", "23.15424", "-81.92556", "America/Havana"),
("3537906", "Santa Clara", "Санта Клара", "CU", "192", "", "16", "", "", "22.40694", "-79.96472", "America/Havana"),
("3538758", "San Nicolás de Bari", "", "CU", "192", "", "MA", "2407", "", "22.78444", "-81.91333", "America/Havana"),
("3538803", "San Miguel del Padrón", "", "CU", "192", "", "02", "", "", "23.06639", "-82.29472", "America/Havana"),
("3539092", "San Luis", "", "CU", "192", "", "01", "", "", "22.27898", "-83.75956", "America/Havana"),
("3539093", "San Luis", "", "CU", "192", "", "15", "", "", "20.18809", "-75.85031", "America/Havana"),
("3539560", "San José de las Lajas", "", "CU", "192", "", "MA", "", "", "22.96139", "-82.15111", "America/Havana"),
("3540667", "Sancti Spíritus", "Санкти-Спиритус", "CU", "192", "", "14", "", "", "21.92972", "-79.4425", "America/Havana"),
("3540680", "San Cristobal", "", "CU", "192", "", "AR", "", "", "22.71658", "-83.05647", "America/Havana"),
("3540885", "San Antonio de los Baños", "", "CU", "192", "", "AR", "", "", "22.89018", "-82.50099", "America/Havana"),
("3541440", "Sagua la Grande", "", "CU", "192", "", "16", "", "", "22.80667", "-80.07556", "America/Havana"),
("3541446", "Sagua de Tánamo", "", "CU", "192", "", "12", "", "", "20.58269", "-75.24116", "America/Havana"),
("3541999", "Rodas", "Родас", "CU", "192", "", "08", "", "", "22.34184", "-80.55596", "America/Havana"),
("3542137", "Río Guayabal de Yateras", "", "CU", "192", "", "10", "", "", "20.36667", "-75.01667", "America/Havana"),
("3542167", "Río Cauto", "", "CU", "192", "", "09", "", "", "20.55971", "-76.91673", "America/Havana"),
("3542455", "Remedios", "Ремедиос", "CU", "192", "", "16", "", "", "22.49502", "-79.54548", "America/Havana"),
("3542502", "Regla", "", "CU", "192", "CU", "02", "", "", "23.125", "-82.33194", "America/Havana"),
("3542744", "Ranchuelo", "", "CU", "192", "", "16", "2612", "", "22.37266", "-80.15046", "America/Havana"),
("3542965", "Quivicán", "", "CU", "192", "", "MA", "", "", "22.82313", "-82.35558", "America/Havana"),
("3543077", "Quemado de Güines", "", "CU", "192", "", "16", "", "", "22.78816", "-80.25226", "America/Havana"),
("3543299", "Puerto Padre", "Пуэрто-Падре", "CU", "192", "", "13", "", "", "21.19517", "-76.60358", "America/Havana"),
("3543498", "Primero de Enero", "", "CU", "192", "", "07", "", "", "21.94501", "-78.4313", "America/Havana"),
("3543961", "Placetas", "", "CU", "192", "", "16", "", "", "22.31184", "-79.6544", "America/Havana"),
("3544091", "Pinar del Río", "Пинар-дель-Рио", "CU", "192", "", "01", "2108", "", "22.41667", "-83.69667", "America/Havana"),
("3544393", "Perico", "", "CU", "192", "", "03", "", "", "22.76987", "-81.0183", "America/Havana"),
("3544607", "Pedro Betancourt", "", "CU", "192", "", "03", "", "", "22.72709", "-81.28963", "America/Havana"),
("3545040", "Palmira", "", "CU", "192", "", "08", "", "", "22.24126", "-80.3911", "America/Havana"),
("3545064", "Palma Soriano", "", "CU", "192", "", "15", "", "", "20.2113", "-75.99362", "America/Havana"),
("3545841", "Nuevitas", "", "CU", "192", "", "05", "", "", "21.54585", "-77.26504", "America/Havana"),
("3545867", "Nueva Gerona", "Нуэва-Херона", "CU", "192", "", "04", "", "", "21.88667", "-82.80556", "America/Havana"),
("3545981", "Niquero", "", "CU", "192", "", "09", "", "", "20.04698", "-77.58089", "America/Havana"),
("3546434", "Morón", "Морон", "CU", "192", "", "07", "", "", "22.10774", "-78.62667", "America/Havana"),
("3546791", "Moa", "Моа", "CU", "192", "", "12", "", "", "20.65776", "-74.95075", "America/Havana"),
("3546882", "Minas de Matahambre", "", "CU", "192", "", "01", "", "", "22.58691", "-83.94551", "America/Havana"),
("3546894", "Minas", "Минас", "CU", "192", "", "05", "", "", "21.48802", "-77.61033", "America/Havana"),
("3547260", "Media Luna", "", "CU", "192", "", "09", "", "", "20.14298", "-77.43532", "America/Havana"),
("3547398", "Matanzas", "Матанзас", "CU", "192", "", "03", "", "", "23.04111", "-81.5775", "America/Havana"),
("3547519", "Martí", "", "CU", "192", "", "03", "", "", "22.94714", "-80.91902", "America/Havana"),
("3547600", "Mariel", "", "CU", "192", "", "AR", "", "", "22.98931", "-82.75376", "America/Havana"),
("3547867", "Manzanillo", "Мансанильо", "CU", "192", "", "09", "", "", "20.34173", "-77.12126", "America/Havana"),
("3547930", "Mantua", "", "CU", "192", "", "01", "", "", "22.29058", "-84.28599", "America/Havana"),
("3547976", "Manicaragua", "", "CU", "192", "", "16", "", "", "22.15021", "-79.97867", "America/Havana"),
("3548099", "Manatí", "", "CU", "192", "", "13", "", "", "21.3107", "-76.93403", "America/Havana"),
("3548441", "Maisí", "", "CU", "192", "", "10", "", "", "20.24673", "-74.15181", "America/Havana"),
("3548529", "Madruga", "", "CU", "192", "", "MA", "", "", "22.91", "-81.85639", "America/Havana"),
("3548993", "Los Palacios", "", "CU", "192", "", "01", "", "", "22.58882", "-83.24671", "America/Havana"),
("3549463", "Los Arabos", "", "CU", "192", "", "03", "", "", "22.72969", "-80.72081", "America/Havana"),
("3550598", "Las Tunas", "Лас-Тунас", "CU", "192", "", "13", "", "", "20.96167", "-76.95111", "America/Havana"),
("3551184", "La Sierpe", "", "CU", "192", "", "14", "", "", "21.77241", "-79.26832", "America/Havana"),
("3551608", "La Salud", "Ла Салюд", "CU", "192", "", "MA", "", "", "22.87199", "-82.42328", "America/Havana"),
("3553478", "Havana", "Гавана", "CU", "192", "", "02", "", "", "23.13302", "-82.38304", "America/Havana"),
("3555907", "Jovellanos", "", "CU", "192", "", "03", "", "", "22.80375", "-81.19127", "America/Havana"),
("3556077", "Jobabo", "", "CU", "192", "", "12", "", "", "20.96917", "-76.29944", "America/Havana"),
("3556078", "Jobabo", "", "CU", "192", "", "13", "", "", "20.90748", "-77.28194", "America/Havana"),
("3556168", "Jiguaní", "", "CU", "192", "", "09", "", "", "20.36785", "-76.42741", "America/Havana"),
("3556268", "Jesús Menéndez", "", "CU", "192", "", "13", "", "", "21.16139", "-76.47919", "America/Havana"),
("3556334", "Jatibonico", "", "CU", "192", "", "14", "", "", "21.94333", "-79.16906", "America/Havana"),
("3556351", "Jaruco", "", "CU", "192", "", "MA", "", "", "23.04419", "-82.00919", "America/Havana"),
("3556406", "Jamaica", "", "CU", "192", "", "MA", "", "", "22.97559", "-82.16852", "America/Havana"),
("3556437", "Jagüey Grande", "", "CU", "192", "", "03", "", "", "22.52694", "-81.12861", "America/Havana"),
("3556969", "Holguín", "Ольгин", "CU", "192", "", "12", "3206", "", "20.88722", "-76.26306", "America/Havana"),
("3557332", "Guisa", "", "CU", "192", "", "09", "", "", "20.25494", "-76.5393", "America/Havana"),
("3557347", "Güira de Melena", "", "CU", "192", "", "AR", "", "", "22.79613", "-82.50667", "America/Havana"),
("3557378", "Güines", "Гуинес", "CU", "192", "", "MA", "", "", "22.83727", "-82.02641", "America/Havana"),
("3557432", "Guayos", "", "CU", "192", "", "14", "", "", "22.04956", "-79.46106", "America/Havana"),
("3557689", "Guantánamo", "Гуантанамо", "CU", "192", "", "10", "3509", "", "20.14444", "-75.20917", "America/Havana"),
("3557758", "Guane", "", "CU", "192", "", "01", "", "", "22.20179", "-84.08484", "America/Havana"),
("3557801", "Guanajay", "", "CU", "192", "", "AR", "", "", "22.92639", "-82.6875", "America/Havana"),
("3557846", "Guanabacoa", "", "CU", "192", "", "02", "", "", "23.1236", "-82.30082", "America/Havana"),
("3557923", "Guáimaro", "", "CU", "192", "", "05", "", "", "21.05222", "-77.3499", "America/Havana"),
("3558315", "Gibara", "", "CU", "192", "", "12", "", "", "21.10988", "-76.13145", "America/Havana"),
("3558744", "Fomento", "", "CU", "192", "", "14", "", "", "22.10475", "-79.72141", "America/Havana"),
("3558771", "Florida", "Флорида", "CU", "192", "", "05", "", "", "21.52536", "-78.22579", "America/Havana"),
("3558792", "Florencia", "", "CU", "192", "", "07", "", "", "22.1461", "-78.97328", "America/Havana"),
("3559235", "Esperanza", "", "CU", "192", "", "16", "", "", "22.4468", "-80.09711", "America/Havana"),
("3559318", "Esmeralda", "Эсмеральда", "CU", "192", "", "05", "", "", "21.85139", "-78.11725", "America/Havana"),
("3559416", "Encrucijada", "", "CU", "192", "", "16", "", "", "22.61802", "-79.86603", "America/Havana"),
("3562827", "Cumanayagua", "", "CU", "192", "", "08", "2707", "", "22.15247", "-80.20354", "America/Havana"),
("3562895", "Cueto", "", "CU", "192", "", "12", "", "", "20.64855", "-75.92967", "America/Havana"),
("3563145", "Cruces", "Крусес", "CU", "192", "", "08", "", "", "22.34203", "-80.27021", "America/Havana"),
("3563317", "Corralillo", "", "CU", "192", "", "16", "", "", "22.98212", "-80.58556", "America/Havana"),
("3563504", "Contramaestre", "", "CU", "192", "", "15", "", "", "20.29879", "-76.24511", "America/Havana"),
("3563559", "Consolación del Sur", "", "CU", "192", "", "01", "", "", "22.50419", "-83.51442", "America/Havana"),
("3563609", "Condado", "Кондадо", "CU", "192", "", "14", "", "", "21.8767", "-79.84014", "America/Havana"),
("3563843", "Colón", "", "CU", "192", "", "03", "", "", "22.72064", "-80.90492", "America/Havana"),
("3563856", "Colombia", "", "CU", "192", "", "13", "", "", "20.98812", "-77.42598", "America/Havana"),
("3564084", "Ciro Redondo", "", "CU", "192", "", "07", "", "", "22.01921", "-78.70365", "America/Havana"),
("3564114", "Cifuentes", "", "CU", "192", "", "16", "", "", "22.6493", "-80.04935", "America/Havana"),
("3564124", "Cienfuegos", "Сьенфуэгос", "CU", "192", "", "08", "2707", "", "22.14957", "-80.44662", "America/Havana"),
("3564178", "Ciego de Ávila", "", "CU", "192", "", "07", "", "", "21.84", "-78.76194", "America/Havana"),
("3564394", "Chambas", "", "CU", "192", "", "07", "", "", "22.19534", "-78.9123", "America/Havana"),
("3564436", "Cerro", "", "CU", "192", "", "02", "", "", "23.10861", "-82.37778", "America/Havana"),
("3564885", "Cauto Cristo", "", "CU", "192", "", "09", "", "", "20.55709", "-76.4727", "America/Havana"),
("3565432", "Cárdenas", "Карденас", "CU", "192", "", "03", "", "", "23.03661", "-81.20596", "America/Havana"),
("3565768", "Candelaria", "", "CU", "192", "", "AR", "", "", "22.74057", "-82.95912", "America/Havana"),
("3565951", "Campechuela", "", "CU", "192", "", "09", "", "", "20.23329", "-77.2799", "America/Havana"),
("3566054", "Camajuaní", "", "CU", "192", "", "16", "", "", "22.48333", "-79.75", "America/Havana"),
("3566067", "Camagüey", "Камагуэй", "CU", "192", "", "05", "", "", "21.38083", "-77.91694", "America/Havana"),
("3566134", "Calimete", "", "CU", "192", "", "03", "", "", "22.5342", "-80.91105", "America/Havana"),
("3566235", "Calabazar de Sagua", "", "CU", "192", "", "16", "", "", "22.64515", "-79.8951", "America/Havana"),
("3566356", "Caibarién", "", "CU", "192", "", "16", "", "", "22.51996", "-79.46599", "America/Havana"),
("3566429", "Cacocum", "", "CU", "192", "", "12", "", "", "20.73775", "-76.32574", "America/Havana"),
("3566573", "Cabañas", "", "CU", "192", "", "AR", "", "", "22.97944", "-82.92214", "America/Havana"),
("3566603", "Cabaiguán", "", "CU", "192", "", "14", "", "", "22.07874", "-79.49726", "America/Havana"),
("3567082", "Bolondrón", "", "CU", "192", "", "03", "", "", "22.76307", "-81.4478", "America/Havana"),
("3567546", "Bejucal", "", "CU", "192", "", "MA", "", "", "22.92861", "-82.38861", "America/Havana"),
("3567597", "Bayamo", "Баямо", "CU", "192", "", "09", "", "", "20.37417", "-76.64361", "America/Havana"),
("3567612", "Bauta", "", "CU", "192", "", "AR", "", "", "22.98226", "-82.54719", "America/Havana"),
("3567655", "Batabanó", "", "CU", "192", "", "MA", "", "", "22.71794", "-82.28965", "America/Havana"),
("3567669", "Bartolomé Masó", "", "CU", "192", "", "09", "", "", "20.16635", "-76.94291", "America/Havana"),
("3567823", "Baraguá", "", "CU", "192", "", "07", "", "", "21.68216", "-78.62567", "America/Havana"),
("3567834", "Baracoa", "", "CU", "192", "", "10", "", "", "20.34711", "-74.49624", "America/Havana"),
("3567869", "Banes", "", "CU", "192", "", "12", "", "", "20.96116", "-75.722", "America/Havana"),
("3567995", "Bahía Honda", "", "CU", "192", "", "AR", "", "", "22.90332", "-83.15994", "America/Havana"),
("3568312", "Artemisa", "Артемиса", "CU", "192", "", "AR", "", "", "22.81667", "-82.75944", "America/Havana"),
("3568342", "Arroyo Naranjo", "", "CU", "192", "", "02", "", "", "23.03677", "-82.36937", "America/Havana"),
("3569024", "Amancio", "", "CU", "192", "", "13", "", "", "20.81914", "-77.57958", "America/Havana"),
("3569136", "Alquízar", "", "CU", "192", "", "AR", "", "", "22.80517", "-82.58392", "America/Havana"),
("3569370", "Alamar", "Аламар", "CU", "192", "", "02", "", "", "23.15794", "-82.27837", "America/Havana"),
("3569379", "Alacranes", "", "CU", "192", "", "03", "", "", "22.76719", "-81.56803", "America/Havana"),
("3569546", "Aguada de Pasajeros", "", "CU", "192", "", "08", "2701", "", "22.3852", "-80.84792", "America/Havana"),
("3569741", "Abreus", "", "CU", "192", "", "08", "", "", "22.27797", "-80.56931", "America/Havana"),
("3746181", "Habana del Este", "", "CU", "192", "", "02", "", "", "23.15917", "-82.33056", "America/Havana"),
("3746183", "Centro Habana", "", "CU", "192", "", "02", "", "", "23.13833", "-82.36417", "America/Havana"),
("3746184", "La Habana Vieja", "", "CU", "192", "", "02", "", "", "23.13028", "-82.35306", "America/Havana"),
("3746938", "Báguanos", "", "CU", "192", "", "12", "", "", "20.75167", "-76.02694", "America/Havana"),
("3754915", "Jimaguayú", "", "CU", "192", "", "05", "", "", "21.24224", "-77.82625", "America/Havana"),
("6956646", "Arroyo Naranjo", "", "CU", "192", "", "02", "", "", "23.0144", "-82.3031", "America/Havana"),
("6956647", "Boyeros", "", "CU", "192", "", "02", "", "", "23.0072", "-82.4017", "America/Havana"),
("6956648", "Diez de Octubre", "", "CU", "192", "", "02", "", "", "23.0881", "-82.3597", "America/Havana"),
("3374117", "Vila Nova Sintra", "", "CV", "132", "", "02", "", "", "14.86667", "-24.71667", "Atlantic/Cape_Verde"),
("3374120", "Vila do Maio", "", "CV", "132", "", "04", "", "", "15.13823", "-23.21158", "Atlantic/Cape_Verde"),
("3374121", "Vila da Ribeira Brava", "", "CV", "132", "", "22", "", "", "16.61667", "-24.3", "Atlantic/Cape_Verde"),
("3374165", "Tarrafal de São Nicolau", "", "CV", "132", "", "27", "", "", "16.56667", "-24.36667", "Atlantic/Cape_Verde"),
("3374166", "Tarrafal", "", "CV", "132", "", "20", "", "", "15.27881", "-23.75192", "Atlantic/Cape_Verde"),
("3374210", "São Filipe", "", "CV", "132", "", "18", "", "", "14.8961", "-24.49556", "Atlantic/Cape_Verde"),
("3374211", "São Domingos", "", "CV", "132", "", "17", "", "", "15.02438", "-23.5625", "Atlantic/Cape_Verde"),
("3374218", "Santa Maria", "", "CV", "132", "", "08", "", "", "16.6", "-22.9", "Atlantic/Cape_Verde"),
("3374221", "Santa Cruz", "", "CV", "132", "", "16", "", "", "15.13333", "-23.56667", "Atlantic/Cape_Verde"),
("3374235", "Vila de Sal Rei", "", "CV", "132", "", "01", "", "", "16.18333", "-22.91667", "Atlantic/Cape_Verde"),
("3374275", "Ribeira Grande", "", "CV", "132", "", "07", "", "", "17.18561", "-25.07243", "Atlantic/Cape_Verde"),
("3374333", "Praia", "Прая", "CV", "132", "", "14", "", "", "14.93152", "-23.51254", "Atlantic/Cape_Verde"),
("3374336", "Porto Novo", "", "CV", "132", "", "21", "", "", "17.01969", "-25.06471", "Atlantic/Cape_Verde"),
("3374338", "Porto dos Mosteiros", "", "CV", "132", "", "13", "", "", "15.03333", "-24.33333", "Atlantic/Cape_Verde"),
("3374351", "Pombas", "", "CV", "132", "", "05", "", "", "17.15026", "-25.02007", "Atlantic/Cape_Verde"),
("3374360", "Picos", "", "CV", "132", "", "26", "", "", "15.0836", "-23.63236", "Atlantic/Cape_Verde"),
("3374462", "Mindelo", "Минделу", "CV", "132", "", "11", "", "", "16.89014", "-24.98042", "Atlantic/Cape_Verde"),
("3374707", "Cova Figueira", "", "CV", "132", "", "24", "", "", "14.89054", "-24.29343", "Atlantic/Cape_Verde"),
("3374725", "Cidade Velha", "", "CV", "132", "", "23", "", "", "14.91667", "-23.61667", "Atlantic/Cape_Verde"),
("3374794", "Calheta", "", "CV", "132", "", "19", "", "", "15.18613", "-23.59228", "Atlantic/Cape_Verde"),
("3374888", "Assomada", "", "CV", "132", "", "15", "", "", "15.1", "-23.68333", "Atlantic/Cape_Verde"),
("8441167", "João Teves", "", "CV", "132", "", "25", "", "", "15.06457", "-23.58969", "Atlantic/Cape_Verde"),
("8441169", "Pedra Badejo", "", "CV", "132", "", "16", "", "", "15.13493", "-23.53215", "Atlantic/Cape_Verde"),
("8521418", "Espargos", "", "CV", "132", "", "08", "", "", "16.75524", "-22.9446", "Atlantic/Cape_Verde"),
("18918", "Protaras", "Протарас", "CY", "196", "", "01", "", "", "35.0125", "34.05833", "Asia/Nicosia"),
("145952", "Ýpsonas", "", "CY", "196", "", "05", "", "", "34.68797", "32.96191", "Asia/Nicosia"),
("145964", "Géri", "", "CY", "196", "", "04", "", "", "35.1056", "33.41977", "Asia/Nicosia"),
("145981", "Tséri", "", "CY", "196", "", "04", "", "", "35.07307", "33.32344", "Asia/Nicosia"),
("146105", "Rizokárpaso", "", "CY", "196", "", "01", "", "", "35.59719", "34.37916", "Asia/Nicosia"),
("146189", "Pérgamos", "", "CY", "196", "", "03", "", "", "35.04167", "33.70833", "Asia/Nicosia"),
("146209", "Paralímni", "", "CY", "196", "", "01", "", "", "35.03945", "33.98181", "Asia/Nicosia"),
("146214", "Paphos", "Пафос", "CY", "196", "", "06", "", "", "34.77679", "32.42451", "Asia/Nicosia"),
("146268", "Nicosia", "Никосия", "CY", "196", "", "04", "", "", "35.17531", "33.3642", "Asia/Nicosia"),
("146286", "Mórfou", "", "CY", "196", "", "04", "", "", "35.19869", "32.99338", "Asia/Nicosia"),
("146371", "Livádia", "", "CY", "196", "", "03", "", "", "34.95118", "33.62658", "Asia/Nicosia"),
("146384", "Limassol", "Лимасол", "CY", "196", "", "05", "", "", "34.68406", "33.03794", "Asia/Nicosia"),
("146392", "Léfka", "", "CY", "196", "", "04", "", "", "35.11199", "32.84997", "Asia/Nicosia"),
("146400", "Larnaca", "Ларнака", "CY", "196", "", "03", "", "", "34.92291", "33.6233", "Asia/Nicosia"),
("146403", "Lápithos", "", "CY", "196", "", "02", "", "", "35.33823", "33.17368", "Asia/Nicosia"),
("146412", "Kyrenia", "Кирения", "CY", "196", "", "02", "", "", "35.33634", "33.31729", "Asia/Nicosia"),
("146617", "Famagusta", "Фамагуста", "CY", "196", "", "01", "", "", "35.12054", "33.93894", "Asia/Nicosia"),
("146654", "Dhromolaxia", "", "CY", "196", "", "03", "", "", "34.87551", "33.58684", "Asia/Nicosia"),
("146661", "Derýneia", "", "CY", "196", "", "01", "", "", "35.06484", "33.96083", "Asia/Nicosia"),
("146666", "Dáli", "", "CY", "196", "", "04", "", "", "35.02294", "33.42195", "Asia/Nicosia"),
("146796", "Aradíppou", "", "CY", "196", "", "03", "", "", "34.95151", "33.59199", "Asia/Nicosia"),
("3061284", "Dvůr Králové nad Labem", "Двур-Кралове-над-Лабем", "CZ", "203", "", "82", "0525", "", "50.43172", "15.81402", "Europe/Prague"),
("3061327", "Zubří", "", "CZ", "203", "", "90", "0723", "", "49.46603", "18.09249", "Europe/Prague"),
("3061344", "Znojmo", "Зноймо", "CZ", "203", "", "78", "0627", "", "48.8555", "16.0488", "Europe/Prague"),
("3061370", "Zlín", "Злин", "CZ", "203", "", "90", "0724", "", "49.22645", "17.67065", "Europe/Prague"),
("3061562", "Železný Brod", "", "CZ", "203", "", "83", "0512", "", "50.64274", "15.25408", "Europe/Prague"),
("3061692", "Žďár nad Sázavou Druhy", "", "CZ", "203", "", "80", "0615", "", "49.58726", "15.93215", "Europe/Prague"),
("3061695", "Žďár nad Sázavou", "Ждяр-над-Сазавоу", "CZ", "203", "CZ", "80", "0615", "", "49.56263", "15.93924", "Europe/Prague"),
("3061822", "Žatec", "Жатец", "CZ", "203", "", "89", "0424", "", "50.32717", "13.54577", "Europe/Prague"),
("3061888", "Žamberk", "", "CZ", "203", "", "86", "0534", "", "50.08601", "16.46738", "Europe/Prague"),
("3062111", "Zábřeh", "", "CZ", "203", "", "84", "0715", "", "49.8826", "16.87223", "Europe/Prague"),
("3062214", "Vysoké Mýto", "", "CZ", "203", "", "86", "0532", "", "49.9532", "16.16169", "Europe/Prague"),
("3062257", "Vysočany", "", "CZ", "203", "", "52", "8378777", "", "50.10938", "14.51667", "Europe/Prague"),
("3062283", "Vyškov", "Вышков", "CZ", "203", "", "78", "0626", "", "49.27747", "16.99897", "Europe/Prague"),
("3062339", "Vsetín", "Всетин", "CZ", "203", "", "90", "0723", "", "49.33871", "17.99619", "Europe/Prague"),
("3062439", "Vrchlabí", "", "CZ", "203", "", "82", "0525", "", "50.62697", "15.60937", "Europe/Prague"),
("3062446", "Vrbno pod Pradědem", "", "CZ", "203", "", "85", "0801", "", "50.12095", "17.38316", "Europe/Prague"),
("3062497", "Vratimov", "", "CZ", "203", "", "85", "0806", "", "49.76995", "18.31015", "Europe/Prague"),
("3062642", "Vodňany", "", "CZ", "203", "", "79", "0316", "", "49.14789", "14.17513", "Europe/Prague"),
("3062759", "Vlašim", "", "CZ", "203", "", "88", "0201", "", "49.70632", "14.89881", "Europe/Prague"),
("3062811", "Vítkov", "", "CZ", "203", "", "85", "0805", "", "49.77445", "17.74941", "Europe/Prague"),
("3062888", "Vimperk", "", "CZ", "203", "", "79", "0315", "", "49.05857", "13.78286", "Europe/Prague"),
("3063032", "Veselí nad Moravou", "", "CZ", "203", "", "78", "0625", "", "48.95363", "17.37648", "Europe/Prague"),
("3063033", "Veselí nad Lužnicí", "", "CZ", "203", "", "79", "0317", "", "49.1843", "14.69734", "Europe/Prague"),
("3063196", "Velké Meziříčí", "", "CZ", "203", "", "80", "0615", "", "49.35522", "16.01224", "Europe/Prague"),
("3063375", "Varnsdorf", "Варнсдорф", "CZ", "203", "", "89", "0421", "", "50.91154", "14.61824", "Europe/Prague"),
("3063447", "Valašské Meziříčí", "Мезиржичи", "CZ", "203", "", "90", "0723", "", "49.47181", "17.97113", "Europe/Prague"),
("3063448", "Valašské Klobouky", "", "CZ", "203", "", "90", "0724", "", "49.14064", "18.0076", "Europe/Prague"),
("3063546", "Ústí nad Orlicí", "Усти-над-Орлици", "CZ", "203", "", "86", "0534", "", "49.97387", "16.39361", "Europe/Prague"),
("3063548", "Ústí nad Labem", "Усти-над-Лабем", "CZ", "203", "", "89", "0427", "", "50.6607", "14.03227", "Europe/Prague"),
("3063590", "Úpice", "", "CZ", "203", "", "82", "0525", "", "50.51237", "16.01607", "Europe/Prague"),
("3063596", "Uničov", "", "CZ", "203", "", "84", "0712", "", "49.77092", "17.12144", "Europe/Prague"),
("3063736", "Uherský Brod", "Угерски-Брод", "CZ", "203", "", "90", "0722", "", "49.02513", "17.64715", "Europe/Prague"),
("3063739", "Uherské Hradiště", "Градиште", "CZ", "203", "", "90", "0722", "", "49.06975", "17.45969", "Europe/Prague"),
("3063794", "Týn nad Vltavou", "", "CZ", "203", "", "79", "0311", "", "49.2234", "14.42057", "Europe/Prague"),
("3063797", "Týniště nad Orlicí", "", "CZ", "203", "", "82", "0524", "", "50.15136", "16.0777", "Europe/Prague"),
("3063804", "Týnec nad Sázavou", "", "CZ", "203", "", "88", "0201", "", "49.83348", "14.58983", "Europe/Prague"),
("3063853", "Turnov", "", "CZ", "203", "", "83", "0514", "", "50.58356", "15.15186", "Europe/Prague"),
("3063907", "Trutnov", "Трутнов", "CZ", "203", "", "82", "0525", "", "50.56101", "15.9127", "Europe/Prague"),
("3064000", "Třinec", "Тршинец", "CZ", "203", "", "85", "0802", "", "49.67763", "18.67078", "Europe/Prague"),
("3064029", "Třešť", "", "CZ", "203", "CZ", "80", "0612", "", "49.29092", "15.48211", "Europe/Prague"),
("3064079", "Třeboň", "", "CZ", "203", "", "79", "0313", "", "49.00364", "14.77065", "Europe/Prague"),
("3064104", "Třebíč", "Тршебич", "CZ", "203", "", "80", "0614", "", "49.21492", "15.88166", "Europe/Prague"),
("3064122", "Třebechovice pod Orebem", "", "CZ", "203", "", "82", "0521", "", "50.20097", "15.99223", "Europe/Prague"),
("3064211", "Tišnov", "", "CZ", "203", "", "78", "0623", "", "49.34872", "16.42438", "Europe/Prague"),
("3064288", "Teplice", "Теплице", "CZ", "203", "", "89", "0426", "", "50.6404", "13.82451", "Europe/Prague"),
("3064316", "Telč", "", "CZ", "203", "", "80", "0612", "", "49.18418", "15.45275", "Europe/Prague"),
("3064358", "Tanvald", "", "CZ", "203", "", "83", "0512", "", "50.73735", "15.30585", "Europe/Prague"),
("3064373", "Tachov", "", "CZ", "203", "", "87", "0327", "", "49.79528", "12.63365", "Europe/Prague"),
("3064379", "Tábor", "Табор", "CZ", "203", "", "79", "0317", "", "49.41441", "14.6578", "Europe/Prague"),
("3064454", "Svitavy", "Свитави", "CZ", "203", "", "86", "0533", "", "49.75594", "16.46829", "Europe/Prague"),
("3064510", "Světlá nad Sázavou", "", "CZ", "203", "", "80", "0611", "", "49.66801", "15.40393", "Europe/Prague"),
("3064662", "Sušice", "", "CZ", "203", "", "87", "0322", "", "49.23106", "13.52018", "Europe/Prague"),
("3064673", "Šumperk", "Шумперк", "CZ", "203", "", "84", "0715", "", "49.96528", "16.97061", "Europe/Prague"),
("3064807", "Studénka", "", "CZ", "203", "", "85", "0804", "", "49.72342", "18.07853", "Europe/Prague"),
("3064894", "Střížkov", "", "CZ", "203", "", "52", "8378777", "", "50.12674", "14.49363", "Europe/Prague"),
("3064919", "Stříbro", "", "CZ", "203", "", "87", "0327", "", "49.75565", "12.997", "Europe/Prague"),
("3064995", "Strážnice", "", "CZ", "203", "", "78", "0625", "", "48.90102", "17.3168", "Europe/Prague"),
("3065067", "Strakonice", "Страконице", "CZ", "203", "", "79", "0316", "", "49.26141", "13.90237", "Europe/Prague"),
("3065117", "Stochov", "", "CZ", "203", "", "88", "0203", "", "50.14631", "13.96345", "Europe/Prague"),
("3065163", "Štětí", "", "CZ", "203", "", "89", "0423", "", "50.45298", "14.37421", "Europe/Prague"),
("3065166", "Šternberk", "", "CZ", "203", "", "84", "0712", "", "49.73044", "17.29889", "Europe/Prague"),
("3065281", "Starý Bohumín", "", "CZ", "203", "", "85", "0803", "", "49.9169", "18.33619", "Europe/Prague"),
("3065328", "Staré Město", "", "CZ", "203", "", "52", "8378769", "", "50.087", "14.42024", "Europe/Prague"),
("3065335", "Staré Město", "", "CZ", "203", "", "90", "0722", "", "49.07515", "17.43338", "Europe/Prague"),
("3065617", "Sokolov", "Соколов", "CZ", "203", "", "81", "0413", "", "50.1813", "12.6401", "Europe/Prague"),
("3065644", "Soběslav", "", "CZ", "203", "", "79", "0317", "", "49.25993", "14.71861", "Europe/Prague"),
("3065768", "Šluknov", "", "CZ", "203", "", "89", "0421", "", "51.00369", "14.45258", "Europe/Prague"),
("3065824", "Slavkov u Brna", "", "CZ", "203", "", "78", "0626", "", "49.15325", "16.87649", "Europe/Prague"),
("3065843", "Slavičín", "", "CZ", "203", "", "90", "0724", "", "49.08799", "17.87349", "Europe/Prague"),
("3065901", "Šlapanice", "", "CZ", "203", "", "78", "0623", "", "49.16863", "16.72731", "Europe/Prague"),
("3065903", "Slaný", "", "CZ", "203", "", "88", "0203", "", "50.23046", "14.08693", "Europe/Prague"),
("3065921", "Skuteč", "", "CZ", "203", "", "86", "0531", "", "49.84347", "15.99655", "Europe/Prague"),
("3066154", "Sezimovo Ústí", "", "CZ", "203", "", "79", "0317", "", "49.38519", "14.6848", "Europe/Prague"),
("3066184", "Šenov", "", "CZ", "203", "", "85", "0806", "", "49.79315", "18.37607", "Europe/Prague"),
("3066220", "Semily", "", "CZ", "203", "", "83", "0514", "", "50.60191", "15.33552", "Europe/Prague"),
("3066333", "Sedlčany", "", "CZ", "203", "", "88", "020B", "", "49.66057", "14.42664", "Europe/Prague"),
("3066483", "Rýmařov", "", "CZ", "203", "CZ", "85", "0801", "", "49.93183", "17.27177", "Europe/Prague"),
("3066492", "Rychvald", "", "CZ", "203", "", "85", "0803", "", "49.86625", "18.37626", "Europe/Prague"),
("3066503", "Rychnov nad Kněžnou", "", "CZ", "203", "", "82", "0524", "", "50.16284", "16.27488", "Europe/Prague"),
("3066578", "Rumburk", "", "CZ", "203", "", "89", "0421", "", "50.95151", "14.55699", "Europe/Prague"),
("3066636", "Roztoky", "", "CZ", "203", "", "88", "020A", "", "50.15841", "14.3976", "Europe/Prague"),
("3066651", "Rožnov pod Radhoštěm", "", "CZ", "203", "", "90", "0723", "", "49.45853", "18.14302", "Europe/Prague"),
("3066719", "Rousínov", "", "CZ", "203", "", "78", "0626", "", "49.20128", "16.88215", "Europe/Prague"),
("3066727", "Roudnice nad Labem", "", "CZ", "203", "", "89", "0423", "", "50.42528", "14.26175", "Europe/Prague"),
("3066759", "Rosice", "", "CZ", "203", "", "78", "0623", "", "49.18232", "16.38787", "Europe/Prague"),
("3066794", "Rokycany", "", "CZ", "203", "", "87", "0326", "", "49.7427", "13.59459", "Europe/Prague"),
("3066878", "Říčany", "", "CZ", "203", "", "88", "0209", "", "49.99168", "14.65427", "Europe/Prague"),
("3067051", "Rakovník", "", "CZ", "203", "", "88", "020C", "", "50.1037", "13.7334", "Europe/Prague"),
("3067395", "Protivín", "", "CZ", "203", "", "79", "0314", "", "49.19949", "14.21717", "Europe/Prague"),
("3067421", "Prostějov", "Простейов", "CZ", "203", "", "84", "0713", "", "49.47188", "17.11184", "Europe/Prague"),
("3067433", "Prosek", "", "CZ", "203", "", "52", "8378777", "", "50.11525", "14.50685", "Europe/Prague"),
("3067542", "Příbram", "Пршибрам", "CZ", "203", "", "88", "020B", "", "49.68988", "14.01043", "Europe/Prague"),
("3067544", "Příbor", "", "CZ", "203", "", "85", "0804", "", "49.64094", "18.14499", "Europe/Prague"),
("3067553", "Přeštice", "", "CZ", "203", "", "87", "0324", "", "49.57298", "13.3335", "Europe/Prague"),
("3067580", "Přerov", "Преров", "CZ", "203", "", "84", "0714", "", "49.45511", "17.4509", "Europe/Prague"),
("3067594", "Přelouč", "", "CZ", "203", "", "86", "0532", "", "50.03985", "15.56031", "Europe/Prague"),
("3067696", "Prague", "Прага", "CZ", "203", "", "52", "", "", "50.08804", "14.42076", "Europe/Prague"),
("3067713", "Prachatice", "", "CZ", "203", "", "79", "0315", "", "49.01292", "13.99752", "Europe/Prague"),
("3067870", "Polná", "", "CZ", "203", "", "80", "0612", "", "49.487", "15.71881", "Europe/Prague"),
("3067882", "Polička", "", "CZ", "203", "", "86", "0533", "", "49.71465", "16.26543", "Europe/Prague"),
("3068107", "Poděbrady", "", "CZ", "203", "", "88", "0208", "", "50.14242", "15.11881", "Europe/Prague"),
("3068119", "Podbořany", "", "CZ", "203", "", "89", "0424", "", "50.22937", "13.41192", "Europe/Prague"),
("3068160", "Pilsen", "Пльзень", "CZ", "203", "", "87", "0323", "", "49.74747", "13.37759", "Europe/Prague"),
("3068246", "Planá", "", "CZ", "203", "", "87", "0327", "", "49.86816", "12.74378", "Europe/Prague"),
("3068293", "Písek", "Писек", "CZ", "203", "", "79", "0314", "", "49.3088", "14.1475", "Europe/Prague"),
("3068329", "Petřvald", "", "CZ", "203", "", "85", "0803", "", "49.831", "18.3894", "Europe/Prague"),
("3068445", "Pelhřimov", "", "CZ", "203", "", "80", "0613", "", "49.43134", "15.22336", "Europe/Prague"),
("3068582", "Pardubice", "Пардубице", "CZ", "203", "", "86", "0532", "", "50.04075", "15.77659", "Europe/Prague"),
("3068647", "Pacov", "", "CZ", "203", "", "80", "0613", "", "49.47076", "15.00168", "Europe/Prague"),
("3068689", "Otrokovice", "", "CZ", "203", "", "90", "0724", "", "49.21667", "17.51667", "Europe/Prague"),
("3068690", "Otrokovice", "", "CZ", "203", "CZ", "90", "0724", "", "49.20934", "17.53944", "Europe/Prague"),
("3068766", "Ostrov", "Остров", "CZ", "203", "", "81", "0412", "", "50.30592", "12.93907", "Europe/Prague"),
("3068799", "Ostrava", "Острава", "CZ", "203", "", "85", "0806", "", "49.83465", "18.28204", "Europe/Prague"),
("3068873", "Orlová", "Орлова", "CZ", "203", "", "85", "0803", "", "49.84527", "18.43011", "Europe/Prague"),
("3068927", "Opava", "Опава", "CZ", "203", "", "85", "0805", "", "49.93866", "17.90257", "Europe/Prague"),
("3069011", "Olomouc", "Оломоуц", "CZ", "203", "", "84", "0712", "", "49.59552", "17.25175", "Europe/Prague"),
("3069136", "Odry", "", "CZ", "203", "", "85", "0804", "", "49.66255", "17.83084", "Europe/Prague"),
("3069230", "Nýrsko", "", "CZ", "203", "", "87", "0322", "", "49.29387", "13.14353", "Europe/Prague"),
("3069232", "Nýřany", "", "CZ", "203", "", "87", "0325", "", "49.71145", "13.21185", "Europe/Prague"),
("3069236", "Nymburk", "", "CZ", "203", "", "88", "0208", "", "50.18605", "15.04167", "Europe/Prague"),
("3069305", "Nový Jičín", "", "CZ", "203", "", "85", "0804", "", "49.59438", "18.01028", "Europe/Prague"),
("3069377", "Nový Bydžov", "", "CZ", "203", "", "82", "0521", "", "50.2415", "15.49082", "Europe/Prague"),
("3069381", "Nový Bor", "", "CZ", "203", "", "83", "0511", "", "50.75761", "14.55555", "Europe/Prague"),
("3069431", "Nové Strašecí", "", "CZ", "203", "", "88", "020C", "", "50.15272", "13.90043", "Europe/Prague"),
("3069465", "Nové Město na Moravě", "", "CZ", "203", "", "80", "0615", "", "49.56144", "16.07418", "Europe/Prague"),
("3069466", "Nové Město nad Metují", "", "CZ", "203", "", "82", "0523", "", "50.34456", "16.15147", "Europe/Prague"),
("3069669", "Nová Paka", "", "CZ", "203", "", "82", "0522", "", "50.49449", "15.51503", "Europe/Prague"),
("3069844", "Neratovice", "", "CZ", "203", "", "88", "0206", "", "50.25926", "14.51759", "Europe/Prague"),
("3069934", "Nejdek", "", "CZ", "203", "", "81", "0412", "", "50.32242", "12.72936", "Europe/Prague"),
("3070045", "Napajedla", "", "CZ", "203", "", "90", "0724", "", "49.17156", "17.51194", "Europe/Prague"),
("3070055", "Náměšť nad Oslavou", "", "CZ", "203", "CZ", "80", "0614", "", "49.20726", "16.15849", "Europe/Prague"),
("3070122", "Náchod", "", "CZ", "203", "", "82", "0523", "", "50.4167", "16.16289", "Europe/Prague"),
("3070291", "Most", "Мост", "CZ", "203", "", "89", "0425", "", "50.50301", "13.63617", "Europe/Prague"),
("3070310", "Moravský Krumlov", "", "CZ", "203", "", "78", "0627", "", "49.04893", "16.31169", "Europe/Prague"),
("3070323", "Moravské Budějovice", "", "CZ", "203", "", "80", "0614", "", "49.05209", "15.80864", "Europe/Prague"),
("3070325", "Moravská Třebová", "", "CZ", "203", "", "86", "0533", "", "49.75793", "16.66426", "Europe/Prague"),
("3070409", "Mohelnice", "", "CZ", "203", "", "84", "0715", "", "49.77698", "16.91946", "Europe/Prague"),
("3070420", "Modřany", "Модржаны", "CZ", "203", "CZ", "52", "8378780", "", "50.01116", "14.4096", "Europe/Prague"),
("3070451", "Mnichovo Hradiště", "", "CZ", "203", "", "88", "0207", "", "50.5272", "14.97134", "Europe/Prague"),
("3070544", "Mladá Boleslav", "Млада-Болеслав", "CZ", "203", "", "88", "0207", "", "50.41135", "14.90318", "Europe/Prague"),
("3070622", "Mimoň", "", "CZ", "203", "", "83", "0511", "", "50.65869", "14.72474", "Europe/Prague"),
("3070628", "Milovice", "", "CZ", "203", "", "88", "0208", "", "50.22596", "14.88863", "Europe/Prague"),
("3070678", "Milevsko", "", "CZ", "203", "", "79", "0314", "", "49.45089", "14.36", "Europe/Prague"),
("3070720", "Mikulov", "", "CZ", "203", "", "78", "0624", "", "48.80556", "16.6378", "Europe/Prague"),
("3070862", "Mělník", "Мельник", "CZ", "203", "", "88", "0206", "", "50.3505", "14.47411", "Europe/Prague"),
("3071024", "Mariánské Lázně", "", "CZ", "203", "", "81", "0411", "", "49.96459", "12.70118", "Europe/Prague"),
("3071213", "Malá Strana", "", "CZ", "203", "", "52", "8378769", "", "50.08774", "14.40449", "Europe/Prague"),
("3071304", "Lysá nad Labem", "", "CZ", "203", "", "88", "0208", "", "50.20143", "14.83281", "Europe/Prague"),
("3071407", "Luhačovice", "", "CZ", "203", "", "90", "0724", "", "49.09982", "17.75747", "Europe/Prague"),
("3071480", "Lovosice", "", "CZ", "203", "", "89", "0423", "", "50.51504", "14.05103", "Europe/Prague"),
("3071507", "Louny", "Лоуни", "CZ", "203", "", "89", "0424", "", "50.35699", "13.79667", "Europe/Prague"),
("3071606", "Lomnice nad Popelkou", "", "CZ", "203", "", "83", "0514", "", "50.53062", "15.37341", "Europe/Prague"),
("3071665", "Litvínov", "Литвинов", "CZ", "203", "", "89", "0425", "", "50.6042", "13.61812", "Europe/Prague"),
("3071669", "Litovel", "", "CZ", "203", "", "84", "0712", "", "49.70121", "17.07615", "Europe/Prague"),
("3071675", "Litomyšl", "", "CZ", "203", "", "86", "0533", "", "49.86809", "16.31298", "Europe/Prague"),
("3071677", "Litoměřice", "Литомержице", "CZ", "203", "", "89", "0423", "", "50.53348", "14.1318", "Europe/Prague"),
("3071791", "Lipník nad Bečvou", "", "CZ", "203", "", "84", "0714", "", "49.52721", "17.58594", "Europe/Prague"),
("3071961", "Liberec", "Либерец", "CZ", "203", "", "83", "0513", "", "50.76711", "15.05619", "Europe/Prague"),
("3071966", "Libeň", "", "CZ", "203", "", "52", "8378776", "", "50.10819", "14.47457", "Europe/Prague"),
("3072130", "Letovice", "", "CZ", "203", "", "78", "0621", "", "49.54709", "16.57357", "Europe/Prague"),
("3072134", "Letohrad", "", "CZ", "203", "", "86", "0534", "", "50.0358", "16.49879", "Europe/Prague"),
("3072137", "Letňany", "", "CZ", "203", "CZ", "52", "8378788", "", "50.13333", "14.51667", "Europe/Prague"),
("3072235", "Ledeč nad Sázavou", "", "CZ", "203", "", "80", "0611", "", "49.69517", "15.27772", "Europe/Prague"),
("3072332", "Lanškroun", "", "CZ", "203", "", "86", "0534", "", "49.91217", "16.6119", "Europe/Prague"),
("3072394", "Kynšperk nad Ohří", "", "CZ", "203", "", "81", "0413", "", "50.11893", "12.53027", "Europe/Prague"),
("3072407", "Kyjov", "", "CZ", "203", "CZ", "78", "0625", "", "49.01018", "17.12253", "Europe/Prague"),
("3072463", "Kutná Hora", "Кутна-Гора", "CZ", "203", "", "88", "0205", "", "49.94839", "15.26816", "Europe/Prague"),
("3072476", "Kuřim", "", "CZ", "203", "", "78", "0623", "", "49.29852", "16.53144", "Europe/Prague"),
("3072497", "Kunovice", "", "CZ", "203", "", "90", "0722", "", "49.04499", "17.47011", "Europe/Prague"),
("3072598", "Krupka", "", "CZ", "203", "", "89", "0426", "", "50.68449", "13.85815", "Europe/Prague"),
("3072649", "Kroměříž", "Кромнержиж", "CZ", "203", "", "90", "0721", "", "49.29785", "17.39312", "Europe/Prague"),
("3072656", "Krnov", "Крнов", "CZ", "203", "", "85", "0801", "", "50.08967", "17.70385", "Europe/Prague"),
("3072841", "Kravaře", "", "CZ", "203", "", "85", "0805", "", "49.93203", "18.00472", "Europe/Prague"),
("3072903", "Kraslice", "", "CZ", "203", "", "81", "0413", "", "50.32372", "12.51747", "Europe/Prague"),
("3072927", "Králův Dvůr", "", "CZ", "203", "CZ", "88", "0202", "", "49.94981", "14.03445", "Europe/Prague"),
("3072929", "Kralupy nad Vltavou", "Кралупи-над-Влтавой", "CZ", "203", "", "88", "", "", "50.24107", "14.31149", "Europe/Prague"),
("3073149", "Kostelec nad Orlicí", "", "CZ", "203", "", "82", "0524", "", "50.12267", "16.21319", "Europe/Prague"),
("3073254", "Kopřivnice", "Копршивницах", "CZ", "203", "", "85", "0804", "", "49.59947", "18.1448", "Europe/Prague"),
("3073371", "Kolín", "Колин", "CZ", "203", "", "88", "0204", "", "50.02806", "15.1998", "Europe/Prague"),
("3073407", "Kojetín", "", "CZ", "203", "", "84", "0714", "", "49.35179", "17.30207", "Europe/Prague"),
("3073660", "Klatovy", "Клатовы", "CZ", "203", "", "87", "0322", "", "49.39552", "13.29505", "Europe/Prague"),
("3073668", "Klášterec nad Ohří", "", "CZ", "203", "", "89", "0422", "", "50.3886", "13.18342", "Europe/Prague"),
("3073699", "Kladno", "Кладно", "CZ", "203", "", "88", "0203", "", "50.14734", "14.10285", "Europe/Prague"),
("3073743", "Kbely", "", "CZ", "203", "", "52", "8378789", "", "50.13333", "14.55", "Europe/Prague"),
("3073789", "Karviná", "Карвина", "CZ", "203", "", "85", "0803", "", "49.854", "18.54169", "Europe/Prague"),
("3073803", "Karlovy Vary", "Карловы Вары", "CZ", "203", "", "81", "0412", "", "50.23271", "12.87117", "Europe/Prague"),
("3073838", "Karlín", "", "CZ", "203", "CZ", "52", "8378776", "", "50.09272", "14.44711", "Europe/Prague"),
("3073862", "Kaplice", "", "CZ", "203", "", "79", "0312", "", "48.73881", "14.49449", "Europe/Prague"),
("3074020", "Kadaň", "", "CZ", "203", "", "89", "", "", "50.38333", "13.26667", "Europe/Prague"),
("3074110", "Jirkov", "Йирков", "CZ", "203", "", "89", "0422", "", "50.49979", "13.44769", "Europe/Prague"),
("3074149", "Jindřichův Hradec", "Йиндржихув-Градец", "CZ", "203", "", "79", "0313", "", "49.14404", "15.00301", "Europe/Prague"),
("3074181", "Jílové", "", "CZ", "203", "", "89", "0421", "", "50.76082", "14.10383", "Europe/Prague"),
("3074187", "Jilemnice", "", "CZ", "203", "", "83", "0514", "", "50.6089", "15.50653", "Europe/Prague"),
("3074199", "Jihlava", "Йиглава", "CZ", "203", "", "80", "0612", "", "49.3961", "15.59124", "Europe/Prague"),
("3074204", "Jičín", "Йичин", "CZ", "203", "", "82", "0522", "", "50.43723", "15.35162", "Europe/Prague"),
("3074281", "Jeseník", "", "CZ", "203", "", "84", "0711", "", "50.22937", "17.20464", "Europe/Prague"),
("3074462", "Jaroměř", "", "CZ", "203", "", "82", "0523", "", "50.3562", "15.92136", "Europe/Prague"),
("3074593", "Jablunkov", "", "CZ", "203", "", "85", "0802", "", "49.57672", "18.76458", "Europe/Prague"),
("3074603", "Jablonec nad Nisou", "Яблонец", "CZ", "203", "", "83", "0512", "", "50.72431", "15.17108", "Europe/Prague"),
("3074615", "Ivančice", "", "CZ", "203", "", "78", "0623", "", "49.10144", "16.37752", "Europe/Prague"),
("3074677", "Hustopeče", "", "CZ", "203", "", "78", "0624", "", "48.94085", "16.73762", "Europe/Prague"),
("3074723", "Humpolec", "", "CZ", "203", "", "80", "0613", "", "49.54152", "15.35932", "Europe/Prague"),
("3074731", "Hulín", "", "CZ", "203", "", "90", "0721", "", "49.31689", "17.46374", "Europe/Prague"),
("3074805", "Hronov", "", "CZ", "203", "", "82", "0523", "", "50.47968", "16.1823", "Europe/Prague"),
("3074893", "Hranice", "Границе", "CZ", "203", "", "84", "0714", "", "49.54796", "17.73469", "Europe/Prague"),
("3074944", "Hrádek nad Nisou", "", "CZ", "203", "", "83", "0513", "", "50.85279", "14.84455", "Europe/Prague"),
("3074967", "Hradec Králové", "Градец Кралове", "CZ", "203", "", "82", "0521", "", "50.20923", "15.83277", "Europe/Prague"),
("3074975", "Hradec nad Moravici", "", "CZ", "203", "", "85", "0805", "", "49.87042", "17.87843", "Europe/Prague"),
("3075119", "Hořovice", "", "CZ", "203", "", "88", "0202", "", "49.83597", "13.90268", "Europe/Prague"),
("3075208", "Horní Slavkov", "", "CZ", "203", "", "81", "0413", "", "50.13863", "12.80758", "Europe/Prague"),
("3075257", "Horní Počernice", "", "CZ", "203", "CZ", "52", "8378790", "", "50.1121", "14.61036", "Europe/Prague"),
("3075493", "Hořice", "", "CZ", "203", "", "82", "0522", "", "50.36609", "15.63183", "Europe/Prague"),
("3075522", "Horažďovice", "", "CZ", "203", "CZ", "87", "0322", "", "49.32069", "13.701", "Europe/Prague"),
("3075599", "Holice", "", "CZ", "203", "", "86", "0532", "", "50.06601", "15.9859", "Europe/Prague"),
("3075606", "Holešov", "", "CZ", "203", "", "90", "0721", "", "49.33331", "17.57832", "Europe/Prague"),
("3075654", "Hodonín", "Годонин", "CZ", "203", "", "78", "0625", "", "48.84893", "17.13244", "Europe/Prague"),
("3075716", "Hlučín", "", "CZ", "203", "", "85", "0805", "", "49.89795", "18.19196", "Europe/Prague"),
("3075766", "Hlinsko", "", "CZ", "203", "", "86", "0531", "", "49.76213", "15.90756", "Europe/Prague"),
("3075919", "Havlíčkův Brod", "Гавличкув-Брод", "CZ", "203", "", "80", "0611", "", "49.60785", "15.58069", "Europe/Prague"),
("3075921", "Havířov", "Гавиржов", "CZ", "203", "", "85", "", "", "49.77984", "18.43688", "Europe/Prague"),
("3076076", "Habartov", "", "CZ", "203", "", "81", "0413", "", "50.18297", "12.55054", "Europe/Prague"),
("3076116", "Fulnek", "", "CZ", "203", "", "85", "0804", "", "49.71238", "17.90319", "Europe/Prague"),
("3076123", "Frýdlant nad Ostravicí", "", "CZ", "203", "", "85", "0802", "", "49.5928", "18.35967", "Europe/Prague"),
("3076124", "Frýdlant", "", "CZ", "203", "", "83", "0513", "", "50.92139", "15.07974", "Europe/Prague"),
("3076127", "Frýdek-Místek", "Мистек", "CZ", "203", "", "85", "0802", "", "49.68333", "18.35", "Europe/Prague"),
("3076132", "Frenštát pod Radhoštěm", "", "CZ", "203", "", "85", "0804", "", "49.54835", "18.21078", "Europe/Prague"),
("3076136", "Františkovy Lázně", "", "CZ", "203", "", "81", "0411", "", "50.12033", "12.35174", "Europe/Prague"),
("3076311", "Duchcov", "", "CZ", "203", "", "89", "0426", "", "50.60376", "13.74621", "Europe/Prague"),
("3076329", "Dubňany", "", "CZ", "203", "", "78", "0625", "", "48.91694", "17.09004", "Europe/Prague"),
("3076346", "Dubí", "", "CZ", "203", "", "89", "0426", "", "50.68558", "13.78561", "Europe/Prague"),
("3076587", "Domažlice", "", "CZ", "203", "", "87", "0321", "", "49.44049", "12.92976", "Europe/Prague"),
("3076972", "Doksy", "", "CZ", "203", "", "83", "0511", "", "50.56471", "14.65553", "Europe/Prague"),
("3076985", "Dobruška", "", "CZ", "203", "", "82", "0524", "", "50.29201", "16.16001", "Europe/Prague"),
("3077024", "Dobříš", "", "CZ", "203", "", "88", "020B", "", "49.78113", "14.16717", "Europe/Prague"),
("3077073", "Dobřany", "", "CZ", "203", "", "87", "0324", "", "49.65482", "13.29307", "Europe/Prague"),
("3077244", "Děčín", "Дечин", "CZ", "203", "", "89", "0421", "", "50.78215", "14.21478", "Europe/Prague"),
("3077304", "Dačice", "", "CZ", "203", "", "79", "0313", "", "49.08154", "15.43727", "Europe/Prague"),
("3077539", "Chrudim", "Хрудим", "CZ", "203", "", "86", "0531", "", "49.95109", "15.79558", "Europe/Prague"),
("3077549", "Chropyně", "", "CZ", "203", "", "90", "0721", "", "49.35644", "17.36451", "Europe/Prague"),
("3077584", "Chrastava", "", "CZ", "203", "", "83", "0513", "", "50.81693", "14.96884", "Europe/Prague"),
("3077669", "Chotěboř", "", "CZ", "203", "", "80", "0611", "", "49.72072", "15.67018", "Europe/Prague"),
("3077685", "Chomutov", "Хомутов", "CZ", "203", "", "89", "0422", "", "50.46048", "13.41779", "Europe/Prague"),
("3077706", "Chodov", "", "CZ", "203", "", "81", "0413", "", "50.24018", "12.74551", "Europe/Prague"),
("3077725", "Choceň", "", "CZ", "203", "", "86", "0534", "", "50.00161", "16.22303", "Europe/Prague"),
("3077751", "Chlumec nad Cidlinou", "", "CZ", "203", "", "82", "0521", "", "50.1544", "15.46026", "Europe/Prague"),
("3077835", "Cheb", "Хеб", "CZ", "203", "", "81", "0411", "", "50.07963", "12.37392", "Europe/Prague"),
("3077882", "Český Těšín", "Чески-Тешин", "CZ", "203", "", "85", "", "", "49.74613", "18.62613", "Europe/Prague"),
("3077889", "Český Krumlov", "", "CZ", "203", "", "79", "0312", "", "48.81091", "14.31521", "Europe/Prague"),
("3077898", "Český Brod", "", "CZ", "203", "", "88", "0204", "", "50.0742", "14.86081", "Europe/Prague"),
("3077916", "České Budějovice", "Ческе-Будеёвице", "CZ", "203", "", "79", "0311", "", "48.97447", "14.47434", "Europe/Prague"),
("3077920", "Česká Třebová", "Ческа-Тршебова", "CZ", "203", "", "86", "0534", "", "49.90436", "16.44413", "Europe/Prague"),
("3077921", "Česká Skalice", "", "CZ", "203", "", "82", "0523", "", "50.39467", "16.04276", "Europe/Prague"),
("3077929", "Česká Lípa", "Ческа-Липа", "CZ", "203", "", "83", "0511", "", "50.68551", "14.53764", "Europe/Prague"),
("3077932", "Česká Kamenice", "", "CZ", "203", "", "89", "0421", "", "50.7978", "14.41767", "Europe/Prague"),
("3077955", "Červený Kostelec", "", "CZ", "203", "", "82", "0523", "", "50.47626", "16.09289", "Europe/Prague"),
("3078160", "Čelákovice", "", "CZ", "203", "", "88", "0209", "", "50.16038", "14.75005", "Europe/Prague"),
("3078234", "Čáslav", "", "CZ", "203", "", "88", "0205", "", "49.91099", "15.38972", "Europe/Prague"),
("3078286", "Bystřice pod Hostýnem", "", "CZ", "203", "", "90", "0721", "", "49.39924", "17.67401", "Europe/Prague"),
("3078288", "Bystřice nad Pernštejnem", "", "CZ", "203", "", "80", "0615", "", "49.52295", "16.26147", "Europe/Prague"),
("3078301", "Bystřice", "", "CZ", "203", "", "85", "0802", "", "49.63657", "18.72038", "Europe/Prague"),
("3078503", "Bučovice", "", "CZ", "203", "", "78", "0626", "", "49.14896", "17.00191", "Europe/Prague"),
("3078545", "Bruntál", "", "CZ", "203", "", "85", "0801", "", "49.98844", "17.4647", "Europe/Prague"),
("3078577", "Broumov", "", "CZ", "203", "", "82", "0523", "", "50.58566", "16.33181", "Europe/Prague"),
("3078610", "Brno", "Брно", "CZ", "203", "", "78", "0622", "", "49.19522", "16.60796", "Europe/Prague"),
("3078773", "Břeclav", "Бржецлав", "CZ", "203", "", "78", "0624", "", "48.75897", "16.88203", "Europe/Prague"),
("3078833", "Braník", "", "CZ", "203", "", "52", "", "", "50.03498", "14.41518", "Europe/Prague"),
("3078837", "Brandýs nad Labem-Stará Boleslav", "", "CZ", "203", "", "88", "0209", "", "50.18709", "14.66326", "Europe/Prague"),
("3078910", "Boskovice", "", "CZ", "203", "", "78", "0621", "", "49.48751", "16.65997", "Europe/Prague"),
("3079129", "Bohumín", "Богумин", "CZ", "203", "", "85", "0803", "", "49.90411", "18.35755", "Europe/Prague"),
("3079252", "Blatná", "", "CZ", "203", "", "79", "0316", "", "49.42489", "13.88176", "Europe/Prague"),
("3079273", "Blansko", "Бланско", "CZ", "203", "", "78", "0621", "", "49.36304", "16.64446", "Europe/Prague"),
("3079336", "Bílovec", "", "CZ", "203", "", "85", "0804", "", "49.75639", "18.01581", "Europe/Prague"),
("3079346", "Bílina Kyselka", "", "CZ", "203", "", "89", "0426", "", "50.55", "13.76667", "Europe/Prague"),
("3079348", "Bílina", "Билина", "CZ", "203", "CZ", "89", "0426", "", "50.54854", "13.77535", "Europe/Prague"),
("3079467", "Beroun", "Бероун", "CZ", "203", "", "88", "0202", "", "49.96382", "14.072", "Europe/Prague"),
("3079508", "Benešov", "Бенешов", "CZ", "203", "", "88", "0201", "", "49.78162", "14.68697", "Europe/Prague"),
("3079514", "Benátky nad Jizerou", "", "CZ", "203", "", "88", "0207", "", "50.29085", "14.82343", "Europe/Prague"),
("3079616", "Bechyně", "", "CZ", "203", "", "79", "0317", "", "49.29523", "14.4681", "Europe/Prague"),
("3079751", "Aš", "", "CZ", "203", "CZ", "81", "0411", "", "50.22387", "12.19499", "Europe/Prague"),
("6269470", "Černý Most", "", "CZ", "203", "", "52", "", "", "50.10475", "14.57974", "Europe/Prague"),
("2803476", "Zwönitz", "", "DE", "276", "", "13", "00", "14521", "50.63027", "12.80999", "Europe/Berlin"),
("2803515", "Zwingenberg", "", "DE", "276", "", "05", "064", "06431", "49.72389", "8.61084", "Europe/Berlin"),
("2803537", "Zwiesel", "", "DE", "276", "", "02", "092", "09276", "49.01693", "13.23765", "Europe/Berlin"),
("2803560", "Zwickau", "Цвиккау", "DE", "276", "", "13", "00", "14524", "50.72724", "12.48839", "Europe/Berlin"),
("2803588", "Zwenkau", "", "DE", "276", "", "13", "00", "14729", "51.21872", "12.33008", "Europe/Berlin"),
("2803620", "Zweibrücken", "Цвайбрюккен", "DE", "276", "", "08", "00", "07320", "49.24686", "7.36977", "Europe/Berlin"),
("2803655", "Zusmarshausen", "", "DE", "276", "", "02", "097", "09772", "48.40014", "10.59917", "Europe/Berlin"),
("2803723", "Zulpich", "Цюльпих", "DE", "276", "", "07", "053", "05366", "50.69447", "6.65414", "Europe/Berlin"),
("2803786", "Zschorlau", "", "DE", "276", "", "13", "00", "14521", "50.56667", "12.65", "Europe/Berlin"),
("2803798", "Zschopau", "", "DE", "276", "", "13", "00", "14521", "50.74818", "13.07691", "Europe/Berlin"),
("2803870", "Zossen", "Цоссен", "DE", "276", "", "11", "00", "12072", "52.216", "13.44909", "Europe/Berlin"),
("2803884", "Zorneding", "", "DE", "276", "", "02", "091", "09175", "48.08433", "11.82446", "Europe/Berlin"),
("2804008", "Zittau", "Циттау", "DE", "276", "", "13", "00", "14626", "50.89772", "14.80764", "Europe/Berlin"),
("2804034", "Zirndorf", "Цирндорф", "DE", "276", "", "02", "095", "09573", "49.4424", "10.95414", "Europe/Berlin"),
("2804159", "Zimmern ob Rottweil", "", "DE", "276", "", "01", "083", "08325", "48.1666", "8.59436", "Europe/Berlin"),
("2804297", "Zierenberg", "", "DE", "276", "", "05", "066", "06633", "51.36948", "9.30164", "Europe/Berlin"),
("2804642", "Zeven", "", "DE", "276", "", "06", "00", "03357", "53.29657", "9.27685", "Europe/Berlin"),
("2804646", "Zeuthen", "", "DE", "276", "", "11", "00", "12061", "52.36667", "13.61667", "Europe/Berlin"),
("2804654", "Zeulenroda", "", "DE", "276", "", "15", "00", "16076", "50.65278", "11.98377", "Europe/Berlin"),
("2804697", "Zetel", "", "DE", "276", "", "06", "00", "03455", "53.41667", "7.98333", "Europe/Berlin"),
("2804748", "Zerbst", "Цербст", "DE", "276", "", "14", "00", "15082", "51.9662", "12.08517", "Europe/Berlin"),
("2804808", "Zellingen", "", "DE", "276", "", "02", "096", "09677", "49.89737", "9.81746", "Europe/Berlin"),
("2804810", "Zell im Wiesental", "", "DE", "276", "", "01", "083", "08336", "47.70555", "7.85248", "Europe/Berlin"),
("2804867", "Zella-Mehlis", "", "DE", "276", "", "15", "00", "16066", "50.65642", "10.66046", "Europe/Berlin"),
("2804895", "Zell", "", "DE", "276", "", "01", "082", "08216", "48.69235", "8.06301", "Europe/Berlin"),
("2804922", "Zeitz", "Цайц", "DE", "276", "", "14", "00", "15084", "51.04962", "12.1369", "Europe/Berlin"),
("2804933", "Zeitlarn", "", "DE", "276", "", "02", "093", "09375", "49.07848", "12.11174", "Europe/Berlin"),
("2805008", "Zeil", "", "DE", "276", "", "02", "096", "09674", "50.00986", "10.5947", "Europe/Berlin"),
("2805059", "Zehlendorf", "Целендорф", "DE", "276", "", "16", "00", "11000", "52.43333", "13.25", "Europe/Berlin"),
("2805075", "Zehdenick", "", "DE", "276", "", "11", "00", "12065", "52.97852", "13.33165", "Europe/Berlin"),
("2805228", "Zapfendorf", "", "DE", "276", "", "02", "094", "09471", "50.01783", "10.93243", "Europe/Berlin"),
("2805385", "Xanten", "Ксантен", "DE", "276", "", "07", "051", "05170", "51.65877", "6.45297", "Europe/Berlin"),
("2805419", "Wutöschingen", "", "DE", "276", "", "01", "083", "08337", "47.66667", "8.36667", "Europe/Berlin"),
("2805480", "Wustermark", "", "DE", "276", "", "11", "00", "12063", "52.55", "12.95", "Europe/Berlin"),
("2805483", "Wusterhausen", "", "DE", "276", "", "11", "00", "12068", "52.8912", "12.46021", "Europe/Berlin"),
("2805497", "Wüstenrot", "", "DE", "276", "", "01", "081", "08125", "49.08083", "9.46056", "Europe/Berlin"),
("2805597", "Wurzen", "Вурцен", "DE", "276", "", "13", "00", "14729", "51.3707", "12.73939", "Europe/Berlin"),
("2805615", "Würzburg", "Вюрцбург", "DE", "276", "", "02", "096", "09663", "49.79391", "9.95121", "Europe/Berlin"),
("2805644", "Würselen", "Вюрзелен", "DE", "276", "", "07", "053", "05334", "50.81809", "6.1347", "Europe/Berlin"),
("2805753", "Wuppertal", "Вупперталь", "DE", "276", "", "07", "051", "05124", "51.27027", "7.16755", "Europe/Berlin"),
("2805761", "Wunstorf", "Вунсторф", "DE", "276", "", "06", "00", "03241", "52.42377", "9.43585", "Europe/Berlin"),
("2805762", "Wunsiedel", "", "DE", "276", "", "02", "094", "09479", "50.03923", "12.00342", "Europe/Berlin"),
("2805785", "Wünnenberg", "", "DE", "276", "", "07", "057", "05774", "51.52002", "8.69934", "Europe/Berlin"),
("2805910", "Wülfrath", "Вюльфрат", "DE", "276", "", "07", "051", "05158", "51.28195", "7.03821", "Europe/Berlin"),
("2805999", "Wriezen", "", "DE", "276", "", "11", "00", "12064", "52.72091", "14.13425", "Europe/Berlin"),
("2806081", "Wörth am Rhein", "Вёрт-на-Рейне", "DE", "276", "", "08", "00", "07334", "49.04888", "8.25959", "Europe/Berlin"),
("2806105", "Wörrstadt", "", "DE", "276", "", "08", "00", "07331", "49.84861", "8.12417", "Europe/Berlin"),
("2806108", "Worpswede", "", "DE", "276", "", "06", "00", "03356", "53.21667", "8.93333", "Europe/Berlin"),
("2806142", "Worms", "Вормс", "DE", "276", "", "08", "00", "07319", "49.63278", "8.35916", "Europe/Berlin"),
("2806192", "Worbis", "", "DE", "276", "", "15", "00", "16061", "51.41997", "10.3633", "Europe/Berlin"),
("2806287", "Woltersdorf", "", "DE", "276", "", "11", "00", "12067", "52.45", "13.76667", "Europe/Berlin"),
("2806339", "Wolnzach", "", "DE", "276", "", "02", "091", "09186", "48.6038", "11.62568", "Europe/Berlin"),
("2806342", "Wolmirstedt", "", "DE", "276", "", "14", "00", "15083", "52.24856", "11.62945", "Europe/Berlin"),
("2806501", "Wolgast", "", "DE", "276", "", "12", "00", "13075", "54.05275", "13.77201", "Europe/Berlin"),
("2806646", "Wolfschlugen", "", "DE", "276", "", "01", "081", "08116", "48.65", "9.28333", "Europe/Berlin"),
("2806654", "Wolfsburg", "Вольфсбург", "DE", "276", "", "06", "00", "03103", "52.42452", "10.7815", "Europe/Berlin"),
("2806768", "Wolfratshausen", "Вольфратсхаузен", "DE", "276", "", "02", "091", "09173", "47.91289", "11.42166", "Europe/Berlin"),
("2806799", "Wolfhagen", "", "DE", "276", "", "05", "066", "06633", "51.32611", "9.17015", "Europe/Berlin"),
("2806852", "Wölfersheim", "", "DE", "276", "", "05", "064", "06440", "50.4", "8.81667", "Europe/Berlin"),
("2806914", "Wolfenbüttel", "Вольфенбюттель", "DE", "276", "", "06", "00", "03158", "52.16442", "10.54095", "Europe/Berlin"),
("2806919", "Wolfen", "Вольфен", "DE", "276", "", "14", "00", "15082", "51.66122", "12.26873", "Europe/Berlin"),
("2806946", "Wolfach", "", "DE", "276", "", "01", "083", "08317", "48.29319", "8.2158", "Europe/Berlin"),
("2807184", "Witzenhausen", "Витценхаузен", "DE", "276", "", "05", "066", "06636", "51.34103", "9.8554", "Europe/Berlin"),
("2807201", "Wittstock", "", "DE", "276", "", "11", "00", "12068", "53.16118", "12.48287", "Europe/Berlin"),
("2807218", "Wittmund", "Витмунд", "DE", "276", "", "06", "00", "03462", "53.57674", "7.77839", "Europe/Berlin"),
("2807240", "Wittlich", "Виттлих", "DE", "276", "", "08", "00", "07231", "49.98596", "6.89308", "Europe/Berlin"),
("2807257", "Wittingen", "", "DE", "276", "", "06", "00", "03151", "52.72694", "10.73613", "Europe/Berlin"),
("2807265", "Wittichenau", "", "DE", "276", "", "13", "00", "14625", "51.38496", "14.24403", "Europe/Berlin"),
("2807335", "Wittenburg", "", "DE", "276", "", "12", "00", "13076", "53.50599", "11.08049", "Europe/Berlin"),
("2807344", "Wittenberge", "Виттенберге", "DE", "276", "", "11", "00", "12070", "53.00543", "11.75032", "Europe/Berlin"),
("2807360", "Wittenau", "", "DE", "276", "", "16", "00", "11000", "52.59319", "13.32127", "Europe/Berlin"),
("2807363", "Witten", "Виттен", "DE", "276", "", "07", "059", "05954", "51.44362", "7.35258", "Europe/Berlin"),
("2807440", "Wissen", "", "DE", "276", "", "08", "00", "07132", "50.77915", "7.73466", "Europe/Berlin"),
("2807465", "Wismar", "Висмар", "DE", "276", "", "12", "00", "13074", "53.89314", "11.45286", "Europe/Berlin"),
("2807549", "Wirges", "", "DE", "276", "", "08", "00", "07143", "50.47195", "7.79844", "Europe/Berlin"),
("2807594", "Wipperfürth", "Випперфюрт", "DE", "276", "", "07", "053", "05374", "51.1161", "7.39865", "Europe/Berlin"),
("2807736", "Winterlingen", "", "DE", "276", "", "01", "084", "08417", "48.18333", "9.11667", "Europe/Berlin"),
("2807748", "Winterhude", "", "DE", "276", "", "04", "00", "02000", "53.6", "10", "Europe/Berlin"),
("2807788", "Winterberg", "", "DE", "276", "", "07", "059", "05958", "51.19248", "8.53468", "Europe/Berlin"),
("2807825", "Winterbach", "", "DE", "276", "", "01", "081", "08119", "48.79918", "9.47914", "Europe/Berlin"),
("2807845", "Winsen", "", "DE", "276", "", "06", "00", "03353", "53.35753", "10.21282", "Europe/Berlin"),
("2807846", "Winsen", "", "DE", "276", "", "06", "00", "03351", "52.68301", "9.91362", "Europe/Berlin"),
("2807872", "Winnenden", "Винненден", "DE", "276", "", "01", "081", "08119", "48.87563", "9.39819", "Europe/Berlin"),
("2808101", "Windsbach", "", "DE", "276", "", "02", "095", "09571", "49.24786", "10.82651", "Europe/Berlin"),
("2808148", "Windischeschenbach", "", "DE", "276", "", "02", "093", "09374", "49.80108", "12.1571", "Europe/Berlin"),
("2808406", "Wilthen", "", "DE", "276", "", "13", "00", "14625", "51.09745", "14.3929", "Europe/Berlin"),
("2808436", "Wilsdruff", "", "DE", "276", "", "13", "00", "14628", "51.05199", "13.53657", "Europe/Berlin"),
("2808461", "Wilnsdorf", "Вильнсдорф", "DE", "276", "", "07", "059", "05970", "50.81667", "8.1", "Europe/Berlin"),
("2808473", "Wilmersdorf", "Вильмерсдорф", "DE", "276", "", "16", "00", "11000", "52.48333", "13.31667", "Europe/Berlin"),
("2808493", "Willstätt", "", "DE", "276", "", "01", "083", "08317", "48.53333", "7.88333", "Europe/Berlin"),
("2808533", "Willingshausen", "", "DE", "276", "", "05", "066", "06634", "50.85", "9.2", "Europe/Berlin"),
("2808544", "Willingen", "", "DE", "276", "", "05", "066", "06635", "51.29418", "8.6091", "Europe/Berlin"),
("2808559", "Willich", "Виллих", "DE", "276", "", "07", "051", "05166", "51.26371", "6.54734", "Europe/Berlin"),
("2808619", "Willebadessen", "", "DE", "276", "", "07", "057", "05762", "51.62564", "9.03694", "Europe/Berlin"),
("2808644", "Wilkau-Haßlau", "", "DE", "276", "", "13", "00", "14524", "50.67504", "12.51482", "Europe/Berlin"),
("2808649", "Wilhermsdorf", "", "DE", "276", "", "02", "095", "09573", "49.48308", "10.71555", "Europe/Berlin"),
("2808662", "Wilhelmstadt", "", "DE", "276", "", "16", "00", "11000", "52.52462", "13.17707", "Europe/Berlin"),
("2808664", "Wilhelmsruh", "", "DE", "276", "", "16", "00", "11000", "52.5871", "13.36855", "Europe/Berlin"),
("2808720", "Wilhelmshaven", "Вильгельмсхафен", "DE", "276", "", "06", "00", "03405", "53.52998", "8.11253", "Europe/Berlin"),
("2808893", "Wildeshausen", "Вильдесхаузен", "DE", "276", "", "06", "00", "03458", "52.89446", "8.43375", "Europe/Berlin"),
("2809013", "Wildberg", "", "DE", "276", "", "01", "082", "08235", "48.62336", "8.74518", "Europe/Berlin"),
("2809025", "Bad Wildbad", "", "DE", "276", "", "01", "082", "08235", "48.75071", "8.5504", "Europe/Berlin"),
("2809092", "Wietze", "", "DE", "276", "", "06", "00", "03351", "52.65", "9.83333", "Europe/Berlin"),
("2809100", "Wietmarschen", "", "DE", "276", "", "06", "00", "03456", "52.53333", "7.13333", "Europe/Berlin"),
("2809134", "Wiesmoor", "", "DE", "276", "", "06", "00", "03452", "53.41667", "7.73333", "Europe/Berlin"),
("2809138", "Wiesloch", "Вислох", "DE", "276", "", "01", "082", "08226", "49.29504", "8.69846", "Europe/Berlin"),
("2809259", "Wiesenburg", "", "DE", "276", "", "11", "00", "12069", "52.11456", "12.45534", "Europe/Berlin"),
("2809346", "Wiesbaden", "Висбаден", "DE", "276", "", "05", "064", "06414", "50.08258", "8.24932", "Europe/Berlin"),
("2809403", "Wiernsheim", "", "DE", "276", "", "01", "082", "08236", "48.88333", "8.85", "Europe/Berlin"),
("2809517", "Wiehl", "Виль", "DE", "276", "", "07", "053", "05374", "50.9495", "7.55062", "Europe/Berlin"),
("2809544", "Wiefelstede", "", "DE", "276", "", "06", "00", "03451", "53.25", "8.11667", "Europe/Berlin"),
("2809778", "Wickede", "", "DE", "276", "", "07", "059", "05974", "51.4964", "7.86587", "Europe/Berlin"),
("2809889", "Wetzlar", "Вецлар", "DE", "276", "", "05", "065", "06532", "50.56109", "8.50495", "Europe/Berlin"),
("2809897", "Wetzendorf", "", "DE", "276", "", "02", "095", "09564", "49.47056", "11.04148", "Europe/Berlin"),
("2809919", "Wettringen", "", "DE", "276", "", "07", "055", "05566", "52.20939", "7.31895", "Europe/Berlin"),
("2809984", "Wetter (Ruhr)", "", "DE", "276", "", "07", "059", "05954", "51.38747", "7.39277", "Europe/Berlin"),
("2809985", "Wetter", "", "DE", "276", "", "05", "065", "06534", "50.90254", "8.72366", "Europe/Berlin"),
("2810136", "Westhausen", "", "DE", "276", "", "01", "081", "08136", "48.88333", "10.18333", "Europe/Berlin"),
("2810188", "Westerstede", "Вестерстеде", "DE", "276", "", "06", "00", "03451", "53.25682", "7.92737", "Europe/Berlin"),
("2810204", "Westerrönfeld", "", "DE", "276", "", "10", "00", "01058", "54.28333", "9.65", "Europe/Berlin"),
("2810284", "Westerland", "", "DE", "276", "", "10", "00", "01054", "54.9079", "8.30326", "Europe/Berlin"),
("2810289", "Westerkappeln", "", "DE", "276", "", "07", "055", "05566", "52.31667", "7.88333", "Europe/Berlin"),
("2810413", "Westerburg", "", "DE", "276", "", "08", "00", "07143", "50.55938", "7.97482", "Europe/Berlin"),
("2810538", "Westend", "", "DE", "276", "", "16", "00", "11000", "52.51708", "13.27636", "Europe/Berlin"),
("2810587", "Weßling", "", "DE", "276", "", "02", "091", "09188", "48.07452", "11.2482", "Europe/Berlin"),
("2810612", "Wesseling", "Весселинг", "DE", "276", "", "07", "053", "05362", "50.82709", "6.9747", "Europe/Berlin"),
("2810678", "Wesel", "Везель", "DE", "276", "", "07", "051", "05170", "51.6669", "6.62037", "Europe/Berlin"),
("2810702", "Wertingen", "", "DE", "276", "", "02", "097", "09773", "48.56314", "10.68149", "Europe/Berlin"),
("2810710", "Werther", "", "DE", "276", "", "07", "057", "05754", "52.07771", "8.41793", "Europe/Berlin"),
("2810716", "Wertheim", "", "DE", "276", "", "01", "081", "08128", "49.759", "9.50852", "Europe/Berlin"),
("2810808", "Wernigerode", "Вернигероде", "DE", "276", "", "14", "00", "15085", "51.83652", "10.78216", "Europe/Berlin"),
("2810815", "Werneuchen", "", "DE", "276", "", "11", "00", "12060", "52.63275", "13.73437", "Europe/Berlin"),
("2810832", "Werneck", "", "DE", "276", "", "02", "096", "09678", "49.98201", "10.09884", "Europe/Berlin"),
("2810833", "Werne", "Верне", "DE", "276", "", "07", "059", "05978", "51.66446", "7.63421", "Europe/Berlin"),
("2810840", "Wernberg-Köblitz", "", "DE", "276", "", "02", "093", "09376", "49.53931", "12.1613", "Europe/Berlin"),
("2810841", "Wernau", "", "DE", "276", "", "01", "081", "08116", "48.69306", "9.41533", "Europe/Berlin"),
("2810848", "Wermsdorf", "", "DE", "276", "", "13", "00", "14730", "51.28333", "12.95", "Europe/Berlin"),
("2810855", "Wermelskirchen", "Вермельскирхен", "DE", "276", "", "07", "053", "05378", "51.1397", "7.21583", "Europe/Berlin"),
("2810860", "Werlte", "", "DE", "276", "", "06", "00", "03454", "52.85", "7.68333", "Europe/Berlin"),
("2810878", "Werl", "Верль", "DE", "276", "", "07", "059", "05974", "51.55493", "7.91403", "Europe/Berlin"),
("2810919", "Werdohl", "Вердоль", "DE", "276", "", "07", "059", "05962", "51.26011", "7.76608", "Europe/Berlin"),
("2810945", "Werder", "Вердер", "DE", "276", "", "11", "00", "12069", "52.37874", "12.934", "Europe/Berlin"),
("2810969", "Werdau", "Вердау", "DE", "276", "", "13", "00", "14524", "50.73604", "12.37534", "Europe/Berlin"),
("2811013", "Wenzenbach", "", "DE", "276", "", "02", "093", "09375", "49.07561", "12.19954", "Europe/Berlin"),
("2811031", "Wentorf bei Hamburg", "", "DE", "276", "", "10", "00", "01053", "53.5", "10.25", "Europe/Berlin"),
("2811072", "Wennigsen", "", "DE", "276", "", "06", "00", "03241", "52.27404", "9.57287", "Europe/Berlin"),
("2811204", "Wendlingen am Neckar", "Вендлинген-на-Неккаре", "DE", "276", "", "01", "081", "08116", "48.67124", "9.37632", "Europe/Berlin"),
("2811278", "Wenden", "Венден", "DE", "276", "", "07", "059", "05966", "50.96667", "7.86667", "Europe/Berlin"),
("2811292", "Wendelstein", "", "DE", "276", "", "02", "095", "09576", "49.3523", "11.15069", "Europe/Berlin"),
("2811317", "Wendeburg", "", "DE", "276", "", "06", "00", "03157", "52.32957", "10.39255", "Europe/Berlin"),
("2811342", "Wemding", "", "DE", "276", "", "02", "097", "09779", "48.87461", "10.72452", "Europe/Berlin"),
("2811354", "Welzheim", "", "DE", "276", "", "01", "081", "08119", "48.87675", "9.63434", "Europe/Berlin"),
("2811361", "Welver", "", "DE", "276", "", "07", "059", "05974", "51.61667", "7.96667", "Europe/Berlin"),
("2811461", "Wellingsbüttel", "", "DE", "276", "", "04", "00", "02000", "53.64104", "10.0798", "Europe/Berlin"),
("2811611", "Weitramsdorf", "", "DE", "276", "", "02", "094", "09473", "50.25", "10.88333", "Europe/Berlin"),
("2811614", "Weitnau", "", "DE", "276", "", "02", "097", "09780", "47.64171", "10.12732", "Europe/Berlin"),
("2811644", "Weiterstadt", "Вайтерштадт", "DE", "276", "", "05", "064", "06432", "49.9039", "8.58874", "Europe/Berlin"),
("2811698", "Weißwasser", "Вайсвассер", "DE", "276", "", "13", "00", "14626", "51.50403", "14.64017", "Europe/Berlin"),
("2811837", "Weißenthurm", "", "DE", "276", "", "08", "00", "07137", "50.41719", "7.45072", "Europe/Berlin"),
("2811879", "Weißenhorn", "", "DE", "276", "", "02", "097", "09775", "48.30501", "10.16047", "Europe/Berlin"),
("2811899", "Weißenfels", "Вайсенфельс", "DE", "276", "", "14", "00", "15084", "51.20148", "11.96843", "Europe/Berlin"),
("2811909", "Weißenburg in Bayern", "Вайсенбург", "DE", "276", "", "02", "095", "09577", "49.03095", "10.97221", "Europe/Berlin"),
("2812053", "Weissach", "", "DE", "276", "", "01", "081", "08115", "48.84687", "8.92828", "Europe/Berlin"),
("2812071", "Weiskirchen", "", "DE", "276", "", "09", "00", "10042", "49.55", "6.81667", "Europe/Berlin"),
("2812086", "Weisendorf", "", "DE", "276", "", "02", "095", "09572", "49.62283", "10.82531", "Europe/Berlin"),
("2812145", "Weinstadt-Endersbach", "", "DE", "276", "", "01", "081", "08119", "48.81311", "9.36387", "Europe/Berlin"),
("2812158", "Weinsberg", "", "DE", "276", "", "01", "081", "08125", "49.15127", "9.28762", "Europe/Berlin"),
("2812174", "Weinheim", "Вайнхайм", "DE", "276", "", "01", "082", "08226", "49.54887", "8.66697", "Europe/Berlin"),
("2812197", "Weingarten", "", "DE", "276", "", "01", "082", "08215", "49.05457", "8.52678", "Europe/Berlin"),
("2812204", "Weingarten", "Вайнгартен", "DE", "276", "", "01", "084", "08436", "47.81009", "9.63863", "Europe/Berlin"),
("2812225", "Weinböhla", "", "DE", "276", "", "13", "00", "14627", "51.16667", "13.56667", "Europe/Berlin"),
("2812482", "Weimar", "Веймар", "DE", "276", "", "15", "00", "16055", "50.9803", "11.32903", "Europe/Berlin"),
("2812497", "Weilmünster", "", "DE", "276", "", "05", "065", "06533", "50.43143", "8.37673", "Europe/Berlin"),
("2812502", "Weil im Schönbuch", "", "DE", "276", "", "01", "081", "08115", "48.6227", "9.06355", "Europe/Berlin"),
("2812509", "Weilheim an der Teck", "", "DE", "276", "", "01", "081", "08116", "48.61572", "9.53751", "Europe/Berlin"),
("2812515", "Weilheim", "Вайльхайм", "DE", "276", "", "02", "091", "09190", "47.84147", "11.15484", "Europe/Berlin"),
("2812522", "Weilerswist", "Вайлерсвист", "DE", "276", "", "07", "053", "05366", "50.76667", "6.83333", "Europe/Berlin"),
("2812625", "Weil der Stadt", "Вайль-дер-Штадт", "DE", "276", "", "01", "081", "08115", "48.74953", "8.87176", "Europe/Berlin"),
("2812626", "Weilburg", "", "DE", "276", "", "05", "065", "06533", "50.48438", "8.26249", "Europe/Berlin"),
("2812636", "Weil am Rhein", "Вайль-на-Рейне", "DE", "276", "", "01", "083", "08336", "47.59331", "7.62082", "Europe/Berlin"),
("2812655", "Weikersheim", "", "DE", "276", "", "01", "081", "08128", "49.47866", "9.89977", "Europe/Berlin"),
("2813040", "Weiden", "Вайден", "DE", "276", "", "02", "093", "09363", "49.67682", "12.15613", "Europe/Berlin"),
("2813110", "Weida", "", "DE", "276", "", "15", "00", "16076", "50.77449", "12.06028", "Europe/Berlin"),
("2813187", "Weißensee", "Вайсензее", "DE", "276", "DE", "16", "00", "11000", "52.55632", "13.46649", "Europe/Berlin"),
("2813216", "Wehrheim", "", "DE", "276", "", "05", "064", "06434", "50.3", "8.56667", "Europe/Berlin"),
("2813262", "Wehr", "", "DE", "276", "", "01", "083", "08337", "47.62983", "7.90423", "Europe/Berlin"),
("2813344", "Wegscheid", "", "DE", "276", "", "02", "092", "09275", "48.60136", "13.78733", "Europe/Berlin"),
("2813390", "Wegberg", "Вегберг", "DE", "276", "", "07", "053", "05370", "51.14221", "6.28436", "Europe/Berlin"),
("2813410", "Weeze", "", "DE", "276", "", "07", "051", "05154", "51.62678", "6.19792", "Europe/Berlin"),
("2813433", "Weener", "Венер", "DE", "276", "", "06", "00", "03457", "53.16332", "7.35052", "Europe/Berlin"),
("2813464", "Wedel", "Ведель", "DE", "276", "", "10", "00", "01056", "53.58374", "9.69835", "Europe/Berlin"),
("2813472", "Wedding", "", "DE", "276", "", "16", "00", "11000", "52.54734", "13.35594", "Europe/Berlin"),
("2813660", "Wathlingen", "", "DE", "276", "", "06", "00", "03351", "52.5369", "10.15069", "Europe/Berlin"),
("2813700", "Wassertrüdingen", "", "DE", "276", "", "02", "095", "09571", "49.04328", "10.59906", "Europe/Berlin"),
("2813755", "Wasserburg am Inn", "", "DE", "276", "", "02", "091", "09187", "48.0525", "12.22341", "Europe/Berlin"),
("2813786", "Wassenberg", "Вассенберг", "DE", "276", "", "07", "053", "05370", "51.10009", "6.15484", "Europe/Berlin"),
("2814005", "Warstein", "Варштайн", "DE", "276", "", "07", "059", "05974", "51.44488", "8.34851", "Europe/Berlin"),
("2814055", "Warnemünde", "", "DE", "276", "", "12", "00", "13003", "54.1767", "12.08402", "Europe/Berlin"),
("2814127", "Warendorf", "Варендорф", "DE", "276", "", "07", "055", "05570", "51.95109", "7.98756", "Europe/Berlin"),
("2814131", "Waren", "Варен", "DE", "276", "", "12", "00", "13071", "53.5204", "12.67985", "Europe/Berlin"),
("2814146", "Wardenburg", "Варденбург", "DE", "276", "", "06", "00", "03458", "53.06667", "8.2", "Europe/Berlin"),
("2814153", "Warburg", "Варбург", "DE", "276", "", "07", "057", "05762", "51.49011", "9.14641", "Europe/Berlin"),
("2814181", "Wanzleben", "", "DE", "276", "", "14", "00", "15083", "52.06087", "11.4408", "Europe/Berlin"),
("2814195", "Wannweil", "", "DE", "276", "", "01", "084", "08415", "48.51667", "9.15", "Europe/Berlin"),
("2814196", "Wannsee", "", "DE", "276", "", "16", "00", "11000", "52.41915", "13.15531", "Europe/Berlin"),
("2814270", "Wangen im Allgäu", "Ванген-им-Алльгой", "DE", "276", "", "01", "084", "08436", "47.6895", "9.83247", "Europe/Berlin"),
("2814305", "Wandlitz", "Вандлиц", "DE", "276", "", "11", "00", "12060", "52.74196", "13.45799", "Europe/Berlin"),
("2814362", "Waltrop", "Вальтроп", "DE", "276", "", "07", "055", "05562", "51.62125", "7.40238", "Europe/Berlin"),
("2814392", "Waltershausen", "", "DE", "276", "", "15", "00", "16067", "50.89827", "10.55791", "Europe/Berlin"),
("2814445", "Waltenhofen", "", "DE", "276", "", "02", "097", "09780", "47.66446", "10.30695", "Europe/Berlin"),
("2814462", "Walsrode", "Вальсроде", "DE", "276", "", "06", "00", "03358", "52.86147", "9.5926", "Europe/Berlin"),
("2814599", "Wallersdorf", "", "DE", "276", "", "02", "092", "09279", "48.73767", "12.74744", "Europe/Berlin"),
("2814613", "Wallerfangen", "", "DE", "276", "", "09", "00", "10044", "49.33333", "6.71667", "Europe/Berlin"),
("2814632", "Wallenhorst", "Валленхорст", "DE", "276", "", "06", "00", "03459", "52.35", "8.01667", "Europe/Berlin"),
("2814667", "Walldürn", "", "DE", "276", "", "01", "082", "08225", "49.58358", "9.36642", "Europe/Berlin"),
("2814670", "Walldorf", "", "DE", "276", "", "01", "082", "08226", "49.30637", "8.64236", "Europe/Berlin"),
("2814775", "Waldstetten", "", "DE", "276", "", "01", "081", "08136", "48.76615", "9.82135", "Europe/Berlin"),
("2814791", "Waldshut-Tiengen", "Вальдсхут-Тинген", "DE", "276", "", "01", "083", "08337", "47.62323", "8.21717", "Europe/Berlin"),
("2814795", "Waldsee", "", "DE", "276", "", "08", "00", "07338", "49.39528", "8.44028", "Europe/Berlin"),
("2814815", "Waldsassen", "", "DE", "276", "", "02", "093", "09377", "50.00167", "12.30434", "Europe/Berlin"),
("2814846", "Waldmünchen", "", "DE", "276", "", "02", "093", "09372", "49.37804", "12.70905", "Europe/Berlin"),
("2814851", "Waldmohr", "", "DE", "276", "", "08", "00", "07336", "49.38333", "7.33333", "Europe/Berlin"),
("2814853", "Wald-Michelbach", "", "DE", "276", "", "05", "064", "06431", "49.57", "8.83167", "Europe/Berlin"),
("2814874", "Waldkraiburg", "Вальдкрайбург", "DE", "276", "", "02", "091", "09183", "48.20854", "12.39893", "Europe/Berlin"),
("2814880", "Waldkirchen", "", "DE", "276", "", "02", "092", "09272", "48.7327", "13.60082", "Europe/Berlin"),
("2814883", "Waldkirch", "Вальдкирх", "DE", "276", "", "01", "083", "08316", "48.09585", "7.96371", "Europe/Berlin"),
("2814888", "Waldkappel", "", "DE", "276", "", "05", "066", "06636", "51.14462", "9.87695", "Europe/Berlin"),
("2814956", "Waldheim", "", "DE", "276", "", "13", "00", "14522", "51.07282", "13.02004", "Europe/Berlin"),
("2815032", "Waldfischbach-Burgalben", "", "DE", "276", "", "08", "00", "07340", "49.28333", "7.66667", "Europe/Berlin"),
("2815035", "Waldfeucht", "", "DE", "276", "", "07", "053", "05370", "51.0661", "5.98815", "Europe/Berlin"),
("2815076", "Waldenbuch", "", "DE", "276", "", "01", "081", "08115", "48.6383", "9.13256", "Europe/Berlin"),
("2815101", "Waldeck", "", "DE", "276", "", "05", "066", "06635", "51.20618", "9.06286", "Europe/Berlin"),
("2815127", "Waldbüttelbrunn", "", "DE", "276", "", "02", "096", "09679", "49.78833", "9.84667", "Europe/Berlin"),
("2815137", "Waldbröl", "Вальдбрёль", "DE", "276", "", "07", "053", "05374", "50.87576", "7.61688", "Europe/Berlin"),
("2815328", "Waibstadt", "", "DE", "276", "", "01", "082", "08226", "49.29505", "8.91771", "Europe/Berlin"),
("2815330", "Waiblingen", "Вайблинген", "DE", "276", "", "01", "081", "08119", "48.83241", "9.31641", "Europe/Berlin"),
("2815375", "Wahn-Heide", "", "DE", "276", "", "07", "053", "05315", "50.85891", "7.10662", "Europe/Berlin"),
("2815392", "Wahlstedt", "", "DE", "276", "", "10", "00", "01060", "53.95161", "10.20626", "Europe/Berlin"),
("2815484", "Waging am See", "", "DE", "276", "", "02", "091", "09189", "47.93414", "12.73392", "Europe/Berlin"),
("2815487", "Waghäusel", "Вагхойзель", "DE", "276", "", "01", "082", "08215", "49.24991", "8.51257", "Europe/Berlin"),
("2815523", "Wagenfeld", "", "DE", "276", "", "06", "00", "03251", "52.55", "8.58333", "Europe/Berlin"),
("2815559", "Wadgassen", "", "DE", "276", "", "09", "00", "10044", "49.26667", "6.78333", "Europe/Berlin"),
("2815563", "Wadersloh", "", "DE", "276", "", "07", "055", "05570", "51.73333", "8.25", "Europe/Berlin"),
("2815565", "Wadern", "Вадерн", "DE", "276", "", "09", "00", "10042", "49.54122", "6.88774", "Europe/Berlin"),
("2815642", "Wächtersbach", "", "DE", "276", "", "05", "064", "06435", "50.25511", "9.29564", "Europe/Berlin"),
("2815651", "Wachtendonk", "", "DE", "276", "", "07", "051", "05154", "51.40916", "6.33894", "Europe/Berlin"),
("2815678", "Wachtberg", "Вахтберг", "DE", "276", "", "07", "053", "05382", "50.63333", "7.1", "Europe/Berlin"),
("2815784", "Wabern", "", "DE", "276", "", "05", "066", "06634", "51.1", "9.35", "Europe/Berlin"),
("2815804", "Waakirchen", "", "DE", "276", "", "02", "091", "09182", "47.7725", "11.67315", "Europe/Berlin"),
("2815824", "Vreden", "Фреден", "DE", "276", "", "07", "055", "05554", "52.03792", "6.828", "Europe/Berlin"),
("2816616", "Volkmarsen", "", "DE", "276", "", "05", "066", "06635", "51.40895", "9.11814", "Europe/Berlin"),
("2816630", "Völklingen", "Фёльклинген", "DE", "276", "", "09", "00", "10041", "49.25162", "6.85873", "Europe/Berlin"),
("2816702", "Volkach", "", "DE", "276", "", "02", "096", "09675", "49.86352", "10.22813", "Europe/Berlin"),
("2816761", "Vöhringen", "", "DE", "276", "", "02", "097", "09775", "48.27839", "10.08236", "Europe/Berlin"),
("2816769", "Vöhl", "", "DE", "276", "", "05", "066", "06635", "51.20565", "8.9451", "Europe/Berlin"),
("2816770", "Vohenstrauß", "", "DE", "276", "", "02", "093", "09374", "49.62383", "12.33808", "Europe/Berlin"),
("2816776", "Vohburg an der Donau", "", "DE", "276", "", "02", "091", "09186", "48.76977", "11.61845", "Europe/Berlin"),
("2817065", "Voerde", "Ферде", "DE", "276", "", "07", "051", "05170", "51.59703", "6.6863", "Europe/Berlin"),
("2817105", "Vlotho", "Флото", "DE", "276", "", "07", "057", "05758", "52.1653", "8.85996", "Europe/Berlin"),
("2817130", "Visselhövede", "", "DE", "276", "", "06", "00", "03357", "52.98546", "9.58265", "Europe/Berlin"),
("2817139", "Visbek", "", "DE", "276", "", "06", "00", "03460", "52.83333", "8.31667", "Europe/Berlin"),
("2817202", "Vilshofen", "", "DE", "276", "", "02", "092", "09275", "48.62695", "13.19222", "Europe/Berlin"),
("2817207", "Vilseck", "", "DE", "276", "", "02", "093", "09371", "49.6148", "11.80261", "Europe/Berlin"),
("2817209", "Vilsbiburg", "", "DE", "276", "", "02", "092", "09274", "48.45296", "12.35604", "Europe/Berlin"),
("2817217", "Villmar", "", "DE", "276", "", "05", "065", "06533", "50.39287", "8.1931", "Europe/Berlin"),
("2817220", "Villingen-Schwenningen", "Виллинген-Швеннинген", "DE", "276", "", "01", "083", "08326", "48.06226", "8.49358", "Europe/Berlin"),
("2817311", "Viersen", "Фирзен", "DE", "276", "", "07", "051", "05166", "51.25435", "6.39441", "Europe/Berlin"),
("2817324", "Viernheim", "Фирнхайм", "DE", "276", "", "05", "064", "06431", "49.54033", "8.5782", "Europe/Berlin"),
("2817394", "Vienenburg", "", "DE", "276", "", "06", "00", "03153", "51.95242", "10.56374", "Europe/Berlin"),
("2817483", "Viechtach", "", "DE", "276", "", "02", "092", "09276", "49.08001", "12.88566", "Europe/Berlin"),
("2817506", "Vettweiß", "", "DE", "276", "", "07", "053", "05358", "50.73333", "6.6", "Europe/Berlin"),
("2817517", "Vetschau", "", "DE", "276", "", "11", "00", "12066", "51.78638", "14.07941", "Europe/Berlin"),
("2817537", "Versmold", "Ферсмольд", "DE", "276", "", "07", "057", "05754", "52.04009", "8.15272", "Europe/Berlin"),
("2817576", "Verl", "Ферль", "DE", "276", "", "07", "057", "05754", "51.88333", "8.51667", "Europe/Berlin"),
("2817599", "Verden", "Ферден", "DE", "276", "", "06", "00", "03361", "52.92343", "9.23491", "Europe/Berlin"),
("2817674", "Velten", "", "DE", "276", "", "11", "00", "12065", "52.69149", "13.17533", "Europe/Berlin"),
("2817704", "Velen", "", "DE", "276", "", "07", "055", "05554", "51.9", "6.98333", "Europe/Berlin"),
("2817719", "Velden", "", "DE", "276", "", "02", "092", "09274", "48.36632", "12.25596", "Europe/Berlin"),
("2817722", "Velburg", "", "DE", "276", "", "02", "093", "09373", "49.23212", "11.6716", "Europe/Berlin"),
("2817724", "Velbert", "Фельберт", "DE", "276", "", "07", "051", "05158", "51.33537", "7.04348", "Europe/Berlin"),
("2817733", "Veitshöchheim", "", "DE", "276", "", "02", "096", "09679", "49.83278", "9.88167", "Europe/Berlin"),
("2817736", "Veitsbronn", "", "DE", "276", "", "02", "095", "09573", "49.51239", "10.88797", "Europe/Berlin"),
("2817812", "Vechta", "Фехта", "DE", "276", "", "06", "00", "03460", "52.72632", "8.28598", "Europe/Berlin"),
("2817813", "Vechelde", "Фехельде", "DE", "276", "", "06", "00", "03157", "52.26038", "10.36491", "Europe/Berlin"),
("2817818", "Vaterstetten", "Фатерштеттен", "DE", "276", "", "02", "091", "09175", "48.10537", "11.76825", "Europe/Berlin"),
("2817873", "Varel", "", "DE", "276", "", "06", "00", "03455", "53.39693", "8.13621", "Europe/Berlin"),
("2817909", "Vallendar", "", "DE", "276", "", "08", "00", "07137", "50.39586", "7.62427", "Europe/Berlin"),
("2817927", "Vaihingen an der Enz", "Файхинген-на-Энце", "DE", "276", "", "01", "081", "08118", "48.93563", "8.96045", "Europe/Berlin"),
("2818067", "Uetersen", "Итерзен", "DE", "276", "", "10", "00", "01056", "53.68769", "9.66394", "Europe/Berlin"),
("2818094", "Uslar", "Услар", "DE", "276", "", "06", "00", "03155", "51.6569", "9.63501", "Europe/Berlin"),
("2818097", "Usingen", "", "DE", "276", "", "05", "064", "06434", "50.33554", "8.53688", "Europe/Berlin"),
("2818246", "Bad Urach", "", "DE", "276", "", "01", "084", "08415", "48.49107", "9.40009", "Europe/Berlin"),
("2818766", "Unterschleißheim", "Унтершлайсхайм", "DE", "276", "", "02", "091", "09184", "48.28038", "11.57684", "Europe/Berlin"),
("2819081", "Untermeitingen", "", "DE", "276", "", "02", "097", "09772", "48.16082", "10.80694", "Europe/Berlin"),
("2819399", "Unterhausen", "", "DE", "276", "", "01", "084", "08415", "48.4298", "9.25504", "Europe/Berlin"),
("2819465", "Unterhaching", "Унтерхахинг", "DE", "276", "", "02", "091", "09184", "48.06598", "11.61564", "Europe/Berlin"),
("2819479", "Untergruppenbach", "", "DE", "276", "", "01", "081", "08125", "49.0894", "9.27516", "Europe/Berlin"),
("2819497", "Untergriesbach", "", "DE", "276", "", "02", "092", "09275", "48.57434", "13.66725", "Europe/Berlin"),
("2819568", "Unterföhring", "", "DE", "276", "", "02", "091", "09184", "48.19253", "11.64293", "Europe/Berlin"),
("2819974", "Unterkrozingen", "", "DE", "276", "", "01", "083", "08315", "47.91933", "7.69045", "Europe/Berlin"),
("2820087", "Unna", "Унна", "DE", "276", "", "07", "059", "05978", "51.53795", "7.68969", "Europe/Berlin"),
("2820190", "Umkirch", "", "DE", "276", "", "01", "083", "08315", "48.03333", "7.76667", "Europe/Berlin"),
("2820256", "Ulm", "Ульм", "DE", "276", "", "01", "084", "08421", "48.39841", "9.99155", "Europe/Berlin"),
("2820407", "Uhingen", "", "DE", "276", "", "01", "081", "08117", "48.70475", "9.5857", "Europe/Berlin"),
("2820423", "Uffenheim", "", "DE", "276", "", "02", "095", "09575", "49.54415", "10.23286", "Europe/Berlin"),
("2820436", "Uetze", "", "DE", "276", "", "06", "00", "03241", "52.46511", "10.20467", "Europe/Berlin"),
("2820456", "Uelzen", "Ильцен", "DE", "276", "", "06", "00", "03360", "52.96572", "10.56111", "Europe/Berlin"),
("2820458", "Uelsen", "", "DE", "276", "", "06", "00", "03456", "52.5", "6.88333", "Europe/Berlin"),
("2820465", "Uedem", "", "DE", "276", "", "07", "051", "05154", "51.66667", "6.3", "Europe/Berlin"),
("2820471", "Ueckermünde", "", "DE", "276", "", "12", "00", "13075", "53.73795", "14.04473", "Europe/Berlin"),
("2820577", "Überlingen", "Иберлинген", "DE", "276", "", "01", "084", "08435", "47.76977", "9.17136", "Europe/Berlin"),
("2820583", "Überherrn", "", "DE", "276", "", "09", "00", "10044", "49.24187", "6.6984", "Europe/Berlin"),
("2820621", "Übach-Palenberg", "Ибах-Паленберг", "DE", "276", "", "07", "053", "05370", "50.93333", "6.11667", "Europe/Berlin"),
("2820643", "Twistringen", "", "DE", "276", "", "06", "00", "03251", "52.79926", "8.64163", "Europe/Berlin"),
("2820692", "Tutzing", "", "DE", "276", "", "02", "091", "09188", "47.90938", "11.2803", "Europe/Berlin"),
("2820693", "Tuttlingen", "Тутлинген", "DE", "276", "", "01", "083", "08327", "47.98464", "8.8177", "Europe/Berlin"),
("2820752", "Türkheim", "", "DE", "276", "", "02", "097", "09778", "48.06401", "10.64156", "Europe/Berlin"),
("2820775", "Tuntenhausen", "", "DE", "276", "", "02", "091", "09187", "47.93509", "12.01518", "Europe/Berlin"),
("2820860", "Tübingen", "Тюбинген", "DE", "276", "", "01", "084", "08416", "48.52266", "9.05222", "Europe/Berlin"),
("2820964", "Trostberg an der Alz", "", "DE", "276", "", "02", "091", "09189", "48.02802", "12.55804", "Europe/Berlin"),
("2820973", "Trossingen", "Троссинген", "DE", "276", "", "01", "083", "08327", "48.07667", "8.64409", "Europe/Berlin"),
("2821029", "Troisdorf", "Тройсдорф", "DE", "276", "", "07", "053", "05382", "50.80901", "7.14968", "Europe/Berlin"),
("2821065", "Trochtelfingen", "", "DE", "276", "", "01", "084", "08415", "48.30843", "9.24491", "Europe/Berlin"),
("2821085", "Trittau", "", "DE", "276", "", "10", "00", "01062", "53.61667", "10.4", "Europe/Berlin"),
("2821143", "Triftern", "", "DE", "276", "", "02", "092", "09277", "48.39468", "13.00627", "Europe/Berlin"),
("2821164", "Trier", "Трир", "DE", "276", "", "08", "00", "07211", "49.75565", "6.63935", "Europe/Berlin"),
("2821216", "Triberg im Schwarzwald", "", "DE", "276", "", "01", "083", "08326", "48.13175", "8.23317", "Europe/Berlin"),
("2821248", "Treuenbrietzen", "", "DE", "276", "", "11", "00", "12069", "52.09754", "12.87258", "Europe/Berlin"),
("2821251", "Treuen", "", "DE", "276", "", "13", "00", "14523", "50.54247", "12.30339", "Europe/Berlin"),
("2821254", "Treuchtlingen", "", "DE", "276", "", "02", "095", "09577", "48.95473", "10.90833", "Europe/Berlin"),
("2821292", "Alt-Treptow", "", "DE", "276", "DE", "16", "00", "11000", "52.48863", "13.4586", "Europe/Berlin"),
("2821336", "Trendelburg", "", "DE", "276", "", "05", "066", "06633", "51.57408", "9.42095", "Europe/Berlin"),
("2821395", "Treffurt", "", "DE", "276", "", "15", "00", "16063", "51.13691", "10.23361", "Europe/Berlin"),
("2821416", "Trebur", "", "DE", "276", "", "05", "064", "06433", "49.93111", "8.41611", "Europe/Berlin"),
("2821465", "Trebbin", "", "DE", "276", "", "11", "00", "12072", "52.21675", "13.22496", "Europe/Berlin"),
("2821480", "Travemünde", "", "DE", "276", "", "10", "00", "01003", "53.96304", "10.8709", "Europe/Berlin"),
("2821515", "Traunstein", "Траунштайн", "DE", "276", "", "02", "091", "09189", "47.86825", "12.64335", "Europe/Berlin"),
("2821517", "Traunreut", "Траунройт", "DE", "276", "", "02", "091", "09189", "47.96269", "12.59231", "Europe/Berlin"),
("2821558", "Trappenkamp", "", "DE", "276", "", "10", "00", "01060", "54.05", "10.25", "Europe/Berlin"),
("2821690", "Traben-Trarbach", "", "DE", "276", "", "08", "00", "07231", "49.95076", "7.11562", "Europe/Berlin"),
("2821736", "Tostedt", "", "DE", "276", "", "06", "00", "03353", "53.28333", "9.71667", "Europe/Berlin"),
("2821779", "Tornesch", "", "DE", "276", "", "10", "00", "01056", "53.7", "9.71667", "Europe/Berlin"),
("2821802", "Torgelow", "", "DE", "276", "", "12", "00", "13075", "53.63415", "14.01346", "Europe/Berlin"),
("2821807", "Torgau", "Торгау", "DE", "276", "", "13", "00", "14730", "51.56016", "12.99617", "Europe/Berlin"),
("2821878", "Tönning", "", "DE", "276", "", "10", "00", "01054", "54.31879", "8.94234", "Europe/Berlin"),
("2821899", "Tönisvorst", "Тёнисфорст", "DE", "276", "", "07", "051", "05166", "51.32092", "6.49412", "Europe/Berlin"),
("2821963", "Töging am Inn", "", "DE", "276", "", "02", "091", "09171", "48.26018", "12.5846", "Europe/Berlin"),
("2821975", "Todtnau", "", "DE", "276", "", "01", "083", "08336", "47.82941", "7.9438", "Europe/Berlin"),
("2822073", "Titz", "", "DE", "276", "", "07", "053", "05358", "51.00619", "6.42477", "Europe/Berlin"),
("2822075", "Tittmoning", "", "DE", "276", "", "02", "091", "09189", "48.06164", "12.7676", "Europe/Berlin"),
("2822083", "Titisee-Neustadt", "", "DE", "276", "", "01", "083", "08315", "47.92104", "8.19063", "Europe/Berlin"),
("2822100", "Tirschenreuth", "", "DE", "276", "", "02", "093", "09377", "49.88263", "12.33112", "Europe/Berlin"),
("2822160", "Timmendorfer Strand", "", "DE", "276", "", "10", "00", "01055", "53.9953", "10.77676", "Europe/Berlin"),
("2822224", "Tiergarten", "", "DE", "276", "", "16", "00", "11000", "52.51667", "13.36667", "Europe/Berlin"),
("2822401", "Tiefenbronn", "", "DE", "276", "", "01", "082", "08236", "48.83333", "8.8", "Europe/Berlin"),
("2822595", "Thum", "", "DE", "276", "", "13", "00", "14521", "50.67081", "12.95091", "Europe/Berlin"),
("2822713", "Tholey", "", "DE", "276", "", "09", "00", "10046", "49.48374", "7.03691", "Europe/Berlin"),
("2822939", "Tharandt", "", "DE", "276", "", "13", "00", "14628", "50.98525", "13.58035", "Europe/Berlin"),
("2822958", "Thannhausen", "", "DE", "276", "", "02", "097", "09774", "48.28334", "10.46917", "Europe/Berlin"),
("2823044", "Thalmässing", "", "DE", "276", "", "02", "095", "09576", "49.08834", "11.2215", "Europe/Berlin"),
("2823081", "Thalheim", "", "DE", "276", "", "13", "00", "14521", "50.70077", "12.84996", "Europe/Berlin"),
("2823141", "Thale", "", "DE", "276", "", "14", "00", "15085", "51.74861", "11.041", "Europe/Berlin"),
("2823230", "Teutschenthal", "", "DE", "276", "", "14", "00", "15088", "51.45", "11.8", "Europe/Berlin"),
("2823360", "Teublitz", "", "DE", "276", "", "02", "093", "09376", "49.22289", "12.08727", "Europe/Berlin"),
("2823368", "Tettnang", "", "DE", "276", "", "01", "084", "08435", "47.66857", "9.59132", "Europe/Berlin"),
("2823398", "Teterow", "", "DE", "276", "", "12", "00", "13072", "53.77545", "12.57487", "Europe/Berlin"),
("2823504", "Teningen", "", "DE", "276", "", "01", "083", "08316", "48.12952", "7.81205", "Europe/Berlin"),
("2823533", "Templin", "Темплин", "DE", "276", "", "11", "00", "12073", "53.11865", "13.5022", "Europe/Berlin"),
("2823538", "Tempelhof", "Темпельхоф", "DE", "276", "", "16", "00", "11000", "52.46667", "13.4", "Europe/Berlin"),
("2823567", "Teltow", "Тельтов", "DE", "276", "", "11", "00", "12069", "52.4031", "13.26014", "Europe/Berlin"),
("2823590", "Telgte", "Тельгте", "DE", "276", "", "07", "055", "05570", "51.97995", "7.78293", "Europe/Berlin"),
("2823611", "Teisendorf", "", "DE", "276", "", "02", "091", "09172", "47.84921", "12.81919", "Europe/Berlin"),
("2823708", "Tegel", "Тегель", "DE", "276", "", "16", "00", "11000", "52.57601", "13.29389", "Europe/Berlin"),
("2823728", "Tecklenburg", "", "DE", "276", "", "07", "055", "05566", "52.21957", "7.81357", "Europe/Berlin"),
("2823799", "Taunusstein", "Таунусштайн", "DE", "276", "", "05", "064", "06439", "50.14993", "8.15206", "Europe/Berlin"),
("2823810", "Taufkirchen", "", "DE", "276", "", "02", "091", "09177", "48.34987", "12.13202", "Europe/Berlin"),
("2823812", "Taufkirchen", "", "DE", "276", "", "02", "091", "09184", "48.0486", "11.61701", "Europe/Berlin"),
("2823836", "Taucha", "", "DE", "276", "", "13", "00", "14730", "51.38333", "12.48333", "Europe/Berlin"),
("2823854", "Tauberbischofsheim", "", "DE", "276", "", "01", "081", "08128", "49.62472", "9.66278", "Europe/Berlin"),
("2823978", "Tarp", "", "DE", "276", "", "10", "00", "01059", "54.66667", "9.4", "Europe/Berlin"),
("2824245", "Tangstedt", "", "DE", "276", "", "10", "00", "01062", "53.73333", "10.08333", "Europe/Berlin"),
("2824254", "Tangermünde", "", "DE", "276", "", "14", "00", "15090", "52.54463", "11.97647", "Europe/Berlin"),
("2824255", "Tangerhütte", "", "DE", "276", "", "14", "00", "15090", "52.4353", "11.80724", "Europe/Berlin"),
("2824284", "Tamm", "", "DE", "276", "", "01", "081", "08118", "48.91988", "9.11556", "Europe/Berlin"),
("2824420", "Tacherting", "", "DE", "276", "", "02", "091", "09189", "48.07825", "12.57008", "Europe/Berlin"),
("2824461", "Syke", "Зике", "DE", "276", "", "06", "00", "03251", "52.91345", "8.82209", "Europe/Berlin"),
("2824545", "Süßen", "", "DE", "276", "", "01", "081", "08117", "48.67934", "9.75534", "Europe/Berlin"),
("2824564", "Süsel", "", "DE", "276", "", "10", "00", "01055", "54.06667", "10.71667", "Europe/Berlin"),
("2824655", "Sundern", "Зундерн", "DE", "276", "", "07", "059", "05958", "51.3281", "8.00369", "Europe/Berlin"),
("2824801", "Sulzbach-Rosenberg", "Зульцбах-Розенберг", "DE", "276", "", "02", "093", "09371", "49.50126", "11.74598", "Europe/Berlin"),
("2824804", "Sulzbach an der Murr", "", "DE", "276", "", "01", "081", "08119", "49.00303", "9.5003", "Europe/Berlin"),
("2824806", "Sulzbach am Main", "", "DE", "276", "", "02", "096", "09676", "49.91149", "9.15315", "Europe/Berlin"),
("2824837", "Sulzbach", "", "DE", "276", "", "05", "064", "06436", "50.13396", "8.52797", "Europe/Berlin"),
("2824841", "Sulzbach", "Зульцбах", "DE", "276", "", "09", "00", "10041", "49.29882", "7.05696", "Europe/Berlin"),
("2824855", "Sulz am Neckar", "", "DE", "276", "", "01", "083", "08325", "48.36241", "8.63309", "Europe/Berlin"),
("2824902", "Sulingen", "", "DE", "276", "", "06", "00", "03251", "52.68373", "8.80949", "Europe/Berlin"),
("2824948", "Suhl", "Зуль", "DE", "276", "", "15", "00", "16054", "50.60911", "10.69401", "Europe/Berlin"),
("2824998", "Südlohn", "", "DE", "276", "", "07", "055", "05554", "51.93333", "6.86667", "Europe/Berlin"),
("2825297", "Stuttgart", "Штутгарт", "DE", "276", "", "01", "081", "08111", "48.78232", "9.17702", "Europe/Berlin"),
("2825422", "Stuhr", "", "DE", "276", "", "06", "00", "03251", "53.03333", "8.75", "Europe/Berlin"),
("2825429", "Stühlingen", "", "DE", "276", "", "01", "083", "08337", "47.7458", "8.44813", "Europe/Berlin"),
("2825638", "Strullendorf", "", "DE", "276", "", "02", "094", "09471", "49.84429", "10.97208", "Europe/Berlin"),
("2826082", "Strausberg", "Штраусберг", "DE", "276", "", "11", "00", "12064", "52.57859", "13.88741", "Europe/Berlin"),
("2826099", "Straubing", "Штраубинг", "DE", "276", "", "02", "092", "09263", "48.88126", "12.57385", "Europe/Berlin"),
("2826258", "Strasburg", "", "DE", "276", "", "12", "00", "13075", "53.5103", "13.74513", "Europe/Berlin"),
("2826287", "Stralsund", "Штральзунд", "DE", "276", "", "12", "00", "13073", "54.30911", "13.0818", "Europe/Berlin"),
("2826304", "Straelen", "Штрален", "DE", "276", "", "07", "051", "05154", "51.4419", "6.26639", "Europe/Berlin"),
("2826403", "Storkow", "", "DE", "276", "", "11", "00", "12067", "52.25662", "13.93337", "Europe/Berlin"),
("2826503", "Stolzenau", "", "DE", "276", "", "06", "00", "03256", "52.51667", "9.06667", "Europe/Berlin"),
("2826532", "Stolpen", "", "DE", "276", "", "13", "00", "14628", "51.04901", "14.07943", "Europe/Berlin"),
("2826584", "Stollberg", "", "DE", "276", "", "13", "00", "14521", "50.70999", "12.78034", "Europe/Berlin"),
("2826595", "Stolberg", "Штольберг", "DE", "276", "", "07", "053", "05334", "50.77368", "6.22595", "Europe/Berlin"),
("2826670", "Stockstadt am Main", "", "DE", "276", "", "02", "096", "09671", "49.97005", "9.07153", "Europe/Berlin"),
("2826671", "Stockstadt am Rhein", "", "DE", "276", "", "05", "064", "06433", "49.80944", "8.47278", "Europe/Berlin"),
("2826743", "Stockheim", "", "DE", "276", "", "02", "094", "09476", "50.3", "11.26667", "Europe/Berlin"),
("2826861", "Stockelsdorf", "", "DE", "276", "", "10", "00", "01055", "53.8922", "10.64713", "Europe/Berlin"),
("2826909", "Stockach", "Штоках", "DE", "276", "", "01", "083", "08335", "47.85105", "9.0091", "Europe/Berlin"),
("2827166", "Steyerberg", "", "DE", "276", "", "06", "00", "03256", "52.57017", "9.02423", "Europe/Berlin"),
("2827216", "Stetten am Kalten Markt", "", "DE", "276", "", "01", "084", "08437", "48.12419", "9.07775", "Europe/Berlin"),
("2827406", "Stephanskirchen", "", "DE", "276", "", "02", "091", "09187", "47.85389", "12.1856", "Europe/Berlin"),
("2827479", "Stendal", "Стендаль", "DE", "276", "", "14", "00", "15090", "52.6069", "11.85867", "Europe/Berlin"),
("2827552", "Stellingen", "", "DE", "276", "", "04", "00", "02000", "53.5922", "9.9287", "Europe/Berlin"),
("2827574", "Stelle", "", "DE", "276", "", "06", "00", "03353", "53.38416", "10.11138", "Europe/Berlin"),
("2827988", "Steinheim am der Murr", "", "DE", "276", "", "01", "081", "08118", "48.96821", "9.27708", "Europe/Berlin"),
("2827989", "Steinheim am Albuch", "", "DE", "276", "", "01", "081", "08135", "48.6909", "10.06382", "Europe/Berlin"),
("2827990", "Steinheim", "", "DE", "276", "", "07", "057", "05762", "51.87066", "9.09136", "Europe/Berlin"),
("2828050", "Steinhagen", "", "DE", "276", "", "07", "057", "05754", "52", "8.4", "Europe/Berlin"),
("2828105", "Steinfurt", "Штайнфурт", "DE", "276", "", "07", "055", "05566", "52.15045", "7.33664", "Europe/Berlin"),
("2828136", "Steinfeld", "", "DE", "276", "", "06", "00", "03460", "52.58596", "8.21417", "Europe/Berlin"),
("2828206", "Steinenbronn", "", "DE", "276", "", "01", "081", "08115", "48.66667", "9.11667", "Europe/Berlin"),
("2828228", "Steinen", "", "DE", "276", "", "01", "083", "08336", "47.64446", "7.73914", "Europe/Berlin"),
("2828685", "Stein", "", "DE", "276", "", "02", "095", "09573", "49.41581", "11.01599", "Europe/Berlin"),
("2828723", "Steinbach-Hallenberg", "", "DE", "276", "", "15", "00", "16066", "50.69624", "10.56541", "Europe/Berlin"),
("2828737", "Steinbach am Taunus", "", "DE", "276", "", "05", "064", "06434", "50.16774", "8.57278", "Europe/Berlin"),
("2828871", "Steinau an der Straße", "", "DE", "276", "", "05", "064", "06435", "50.31401", "9.46335", "Europe/Berlin"),
("2828994", "Steilshoop", "", "DE", "276", "", "04", "00", "02000", "53.61028", "10.05917", "Europe/Berlin"),
("2829109", "Steglitz", "Штеглиц", "DE", "276", "", "16", "00", "11000", "52.45606", "13.332", "Europe/Berlin"),
("2829145", "Stegaurach", "", "DE", "276", "", "02", "094", "09471", "49.86543", "10.84385", "Europe/Berlin"),
("2829322", "Staufenberg", "", "DE", "276", "", "05", "065", "06531", "50.66197", "8.73158", "Europe/Berlin"),
("2829333", "Staufen", "", "DE", "276", "", "01", "083", "08337", "47.75686", "8.21078", "Europe/Berlin"),
("2829422", "Staßfurt", "Штасфурт", "DE", "276", "", "14", "00", "15089", "51.85186", "11.58508", "Europe/Berlin"),
("2829457", "Starnberg", "Штарнберг", "DE", "276", "", "02", "091", "09188", "48.00193", "11.34416", "Europe/Berlin"),
("2829657", "Stahnsdorf", "", "DE", "276", "", "11", "00", "12069", "52.38333", "13.21667", "Europe/Berlin"),
("2829701", "Bad Staffelstein", "", "DE", "276", "", "02", "094", "09478", "50.10199", "11.00128", "Europe/Berlin"),
("2829750", "Stadtroda", "", "DE", "276", "", "15", "00", "16074", "50.85684", "11.72677", "Europe/Berlin"),
("2829753", "Stadtoldendorf", "", "DE", "276", "", "06", "00", "03255", "51.88242", "9.6265", "Europe/Berlin"),
("2829758", "Stadtlohn", "Штадтлон", "DE", "276", "", "07", "055", "05554", "51.99399", "6.91918", "Europe/Berlin"),
("2829765", "Stadtilm", "", "DE", "276", "", "15", "00", "16070", "50.77596", "11.08262", "Europe/Berlin"),
("2829777", "Stadthagen", "Штадтхаген", "DE", "276", "", "06", "00", "03257", "52.32333", "9.20311", "Europe/Berlin"),
("2829790", "Stadtbergen", "", "DE", "276", "", "02", "097", "09772", "48.36641", "10.84636", "Europe/Berlin"),
("2829804", "Stadtallendorf", "Штадталлендорф", "DE", "276", "", "05", "065", "06534", "50.82261", "9.01294", "Europe/Berlin"),
("2829901", "Stade", "Штаде", "DE", "276", "", "06", "00", "03359", "53.59337", "9.47629", "Europe/Berlin"),
("2829962", "Staaken", "", "DE", "276", "", "16", "00", "11000", "52.53661", "13.15057", "Europe/Berlin"),
("2829998", "Sprockhövel", "Шпрокхёфель", "DE", "276", "", "07", "059", "05954", "51.34669", "7.24343", "Europe/Berlin"),
("2830035", "Springe", "Шпринге", "DE", "276", "", "06", "00", "03241", "52.20845", "9.55416", "Europe/Berlin"),
("2830452", "Spiesen-Elversberg", "", "DE", "276", "", "09", "00", "10043", "49.31667", "7.13333", "Europe/Berlin"),
("2830582", "Speyer", "Шпайер", "DE", "276", "", "08", "00", "07318", "49.32083", "8.43111", "Europe/Berlin"),
("2830637", "Spenge", "", "DE", "276", "", "07", "057", "05758", "52.14021", "8.48475", "Europe/Berlin"),
("2830652", "Spelle", "", "DE", "276", "", "06", "00", "03454", "52.36667", "7.46667", "Europe/Berlin"),
("2830670", "Speichersdorf", "", "DE", "276", "", "02", "094", "09472", "49.88333", "11.78333", "Europe/Berlin"),
("2830829", "Spangenberg", "", "DE", "276", "", "05", "066", "06634", "51.11644", "9.6627", "Europe/Berlin"),
("2830849", "Spalt", "", "DE", "276", "", "02", "095", "09576", "49.17553", "10.92453", "Europe/Berlin"),
("2830851", "Spaichingen", "", "DE", "276", "", "01", "083", "08327", "48.07477", "8.73508", "Europe/Berlin"),
("2830880", "Sottrum", "", "DE", "276", "", "06", "00", "03357", "53.11667", "9.23333", "Europe/Berlin"),
("2831083", "Sontra", "", "DE", "276", "", "05", "066", "06636", "51.07171", "9.93558", "Europe/Berlin"),
("2831088", "Sonthofen", "Зонтхофен", "DE", "276", "", "02", "097", "09780", "47.51821", "10.28262", "Europe/Berlin"),
("2831091", "Sontheim an der Brenz", "", "DE", "276", "", "01", "081", "08135", "48.55235", "10.29097", "Europe/Berlin"),
("2831105", "Sonsbeck", "", "DE", "276", "", "07", "051", "05170", "51.61667", "6.36667", "Europe/Berlin"),
("2831239", "Sonnefeld", "", "DE", "276", "", "02", "094", "09473", "50.21667", "11.13333", "Europe/Berlin"),
("2831250", "Sonneberg", "Зоннеберг", "DE", "276", "", "15", "00", "16072", "50.3592", "11.17463", "Europe/Berlin"),
("2831276", "Sondershausen", "Зондерсхаузен", "DE", "276", "", "15", "00", "16065", "51.36973", "10.87011", "Europe/Berlin"),
("2831403", "Sömmerda", "Зёммерда", "DE", "276", "", "15", "00", "16068", "51.15914", "11.11524", "Europe/Berlin"),
("2831486", "Soltau", "Зольтау", "DE", "276", "", "06", "00", "03358", "52.98638", "9.84338", "Europe/Berlin"),
("2831580", "Solingen", "Золинген", "DE", "276", "", "07", "051", "05122", "51.17343", "7.0845", "Europe/Berlin"),
("2831671", "Söhlde", "", "DE", "276", "", "06", "00", "03254", "52.18898", "10.23239", "Europe/Berlin"),
("2831685", "Sohland", "", "DE", "276", "", "13", "00", "14625", "51.04089", "14.41897", "Europe/Berlin"),
("2831699", "Sögel", "", "DE", "276", "", "06", "00", "03454", "52.85", "7.51667", "Europe/Berlin"),
("2831708", "Soest", "Зоест", "DE", "276", "", "07", "059", "05974", "51.57558", "8.10619", "Europe/Berlin"),
("2831802", "Sittensen", "", "DE", "276", "", "06", "00", "03357", "53.27615", "9.50429", "Europe/Berlin"),
("2831847", "Sinzing", "", "DE", "276", "", "02", "093", "09375", "49", "12.03333", "Europe/Berlin"),
("2831852", "Sinzig", "Зинциг", "DE", "276", "", "08", "00", "07131", "50.54384", "7.24639", "Europe/Berlin"),
("2831853", "Sinzheim", "", "DE", "276", "", "01", "082", "08216", "48.76667", "8.16667", "Europe/Berlin"),
("2831872", "Sinsheim", "Зинсхайм", "DE", "276", "", "01", "082", "08226", "49.2529", "8.87867", "Europe/Berlin"),
("2831888", "Sinnersdorf", "", "DE", "276", "", "07", "053", "05362", "51.02445", "6.81787", "Europe/Berlin"),
("2831896", "Sinn", "", "DE", "276", "", "05", "065", "06532", "50.65", "8.33333", "Europe/Berlin"),
("2831924", "Singen", "Зинген", "DE", "276", "", "01", "083", "08335", "47.75935", "8.8403", "Europe/Berlin"),
("2831948", "Sindelfingen", "Зиндельфинген", "DE", "276", "", "01", "081", "08115", "48.7", "9.01667", "Europe/Berlin"),
("2832013", "Simmern", "", "DE", "276", "", "08", "00", "07140", "49.98198", "7.52351", "Europe/Berlin"),
("2832023", "Simmerath", "Зиммерат", "DE", "276", "", "07", "053", "05334", "50.6", "6.3", "Europe/Berlin"),
("2832043", "Simbach am Inn", "", "DE", "276", "", "02", "092", "09277", "48.26548", "13.02309", "Europe/Berlin"),
("2832232", "Sigmaringen", "Зигмаринген", "DE", "276", "", "01", "084", "08437", "48.08829", "9.23033", "Europe/Berlin"),
("2832373", "Siemensstadt", "", "DE", "276", "", "16", "00", "11000", "52.54053", "13.26294", "Europe/Berlin"),
("2832424", "Siegsdorf", "", "DE", "276", "", "02", "091", "09189", "47.82278", "12.64277", "Europe/Berlin"),
("2832495", "Siegen", "Зиген", "DE", "276", "", "07", "059", "05970", "50.87481", "8.02431", "Europe/Berlin"),
("2832521", "Siegburg", "Зигбург", "DE", "276", "", "07", "053", "05382", "50.80019", "7.20769", "Europe/Berlin"),
("2832884", "Seubersdorf", "", "DE", "276", "", "02", "093", "09373", "49.16212", "11.62714", "Europe/Berlin"),
("2832939", "Sersheim", "", "DE", "276", "", "01", "081", "08118", "48.96667", "9.01667", "Europe/Berlin"),
("2833073", "Senftenberg", "Зенфтенберг", "DE", "276", "", "11", "00", "12066", "51.52517", "14.00164", "Europe/Berlin"),
("2833076", "Sendenhorst", "", "DE", "276", "", "07", "055", "05570", "51.84303", "7.82996", "Europe/Berlin"),
("2833079", "Senden", "", "DE", "276", "", "07", "055", "05558", "51.85", "7.5", "Europe/Berlin"),
("2833080", "Senden", "", "DE", "276", "", "02", "097", "09775", "48.32441", "10.04442", "Europe/Berlin"),
("2833139", "Selters", "", "DE", "276", "", "05", "065", "06533", "50.51681", "8.28953", "Europe/Berlin"),
("2833170", "Selm", "Зельм", "DE", "276", "", "07", "059", "05978", "51.69689", "7.46809", "Europe/Berlin"),
("2833242", "Seligenstadt", "Зелигенштадт", "DE", "276", "", "05", "064", "06438", "50.0432", "8.97394", "Europe/Berlin"),
("2833296", "Selb", "Зельб", "DE", "276", "", "02", "094", "09479", "50.17058", "12.13054", "Europe/Berlin"),
("2833475", "Sehnde", "Зенде", "DE", "276", "", "06", "00", "03241", "52.31394", "9.9682", "Europe/Berlin"),
("2833564", "Seevetal", "Зеветаль", "DE", "276", "", "06", "00", "03353", "53.4", "9.96667", "Europe/Berlin"),
("2833592", "Seesen", "Зезен", "DE", "276", "", "06", "00", "03153", "51.89095", "10.17847", "Europe/Berlin"),
("2833641", "Seelze", "Зельце", "DE", "276", "", "06", "00", "03241", "52.39635", "9.59727", "Europe/Berlin"),
("2833651", "Seelow", "", "DE", "276", "", "11", "00", "12064", "52.53392", "14.38128", "Europe/Berlin"),
("2833704", "Seelbach", "", "DE", "276", "", "01", "083", "08317", "48.31667", "7.95", "Europe/Berlin"),
("2833866", "Seefeld", "", "DE", "276", "", "02", "091", "09188", "48.03505", "11.21395", "Europe/Berlin"),
("2834102", "Sebnitz", "", "DE", "276", "", "13", "00", "14628", "50.9754", "14.27579", "Europe/Berlin"),
("2834226", "Schwieberdingen", "", "DE", "276", "", "01", "081", "08118", "48.87644", "9.07439", "Europe/Berlin"),
("2834240", "Schwetzingen", "Шветцинген", "DE", "276", "", "01", "082", "08226", "49.38217", "8.5823", "Europe/Berlin"),
("2834265", "Schwerte", "Шверте", "DE", "276", "", "07", "059", "05978", "51.44387", "7.5675", "Europe/Berlin"),
("2834282", "Schwerin", "Шверин", "DE", "276", "", "12", "00", "13004", "53.62937", "11.41316", "Europe/Berlin"),
("2834334", "Schwendi", "", "DE", "276", "", "01", "084", "08426", "48.18333", "9.96667", "Europe/Berlin"),
("2834372", "Schwelm", "Швельм", "DE", "276", "", "07", "059", "05954", "51.28635", "7.29388", "Europe/Berlin"),
("2834498", "Schweinfurt", "Швайнфурт", "DE", "276", "", "02", "096", "09662", "50.04937", "10.22175", "Europe/Berlin"),
("2834594", "Schweich", "", "DE", "276", "", "08", "00", "07235", "49.82215", "6.75256", "Europe/Berlin"),
("2834629", "Schwedt (Oder)", "", "DE", "276", "", "11", "00", "12073", "53.05963", "14.28154", "Europe/Berlin"),
("2834740", "Schwarzheide", "", "DE", "276", "", "11", "00", "12066", "51.47671", "13.85559", "Europe/Berlin"),
("2834945", "Schwarzenfeld", "", "DE", "276", "", "02", "093", "09376", "49.38774", "12.13484", "Europe/Berlin"),
("2834955", "Schwarzenbruck", "", "DE", "276", "", "02", "095", "09574", "49.35778", "11.24333", "Europe/Berlin"),
("2834978", "Schwarzenberg", "Шварценберг", "DE", "276", "", "13", "00", "14521", "50.53791", "12.78522", "Europe/Berlin"),
("2835013", "Schwarzenbek", "", "DE", "276", "", "10", "00", "01053", "53.50303", "10.48055", "Europe/Berlin"),
("2835018", "Schwarzenbach an der Saale", "", "DE", "276", "", "02", "094", "09475", "50.22279", "11.93504", "Europe/Berlin"),
("2835220", "Schwarmstedt", "", "DE", "276", "", "06", "00", "03358", "52.67794", "9.61767", "Europe/Berlin"),
("2835260", "Schwanewede", "Шваневеде", "DE", "276", "", "06", "00", "03356", "53.23333", "8.6", "Europe/Berlin"),
("2835297", "Schwandorf in Bayern", "", "DE", "276", "", "02", "093", "09376", "49.32534", "12.1098", "Europe/Berlin"),
("2835342", "Schwalmtal", "", "DE", "276", "", "07", "051", "05166", "51.21667", "6.26667", "Europe/Berlin"),
("2835345", "Schwalmstadt", "Швальмштадт", "DE", "276", "", "05", "066", "06634", "50.93333", "9.21667", "Europe/Berlin"),
("2835381", "Schwalbach am Taunus", "", "DE", "276", "", "05", "064", "06436", "50.15", "8.53333", "Europe/Berlin"),
("2835382", "Schwalbach", "", "DE", "276", "", "09", "00", "10044", "49.3", "6.81667", "Europe/Berlin"),
("2835385", "Schwaikheim", "", "DE", "276", "", "01", "081", "08119", "48.87733", "9.34958", "Europe/Berlin"),
("2835411", "Schwaigern", "", "DE", "276", "", "01", "081", "08125", "49.14494", "9.05525", "Europe/Berlin"),
("2835421", "Schwaig", "", "DE", "276", "", "02", "095", "09574", "49.46955", "11.20064", "Europe/Berlin"),
("2835477", "Schwabmünchen", "", "DE", "276", "", "02", "097", "09772", "48.17928", "10.75675", "Europe/Berlin"),
("2835481", "Schwäbisch Hall", "", "DE", "276", "", "01", "081", "08127", "49.11127", "9.73908", "Europe/Berlin"),
("2835482", "Schwäbisch Gmünd", "Швебиш-Гмюнд", "DE", "276", "", "01", "081", "08136", "48.79947", "9.79809", "Europe/Berlin"),
("2835496", "Schwabhausen", "", "DE", "276", "", "02", "091", "09174", "48.40157", "11.35729", "Europe/Berlin"),
("2835537", "Schwabach", "Швабах", "DE", "276", "", "02", "095", "09565", "49.33047", "11.02346", "Europe/Berlin"),
("2835542", "Schwaan", "", "DE", "276", "", "12", "00", "13072", "53.94047", "12.10715", "Europe/Berlin"),
("2835587", "Schüttorf", "", "DE", "276", "", "06", "00", "03456", "52.32281", "7.22176", "Europe/Berlin"),
("2835596", "Schutterwald", "", "DE", "276", "", "01", "083", "08317", "48.45", "7.88333", "Europe/Berlin"),
("2835635", "Bad Schussenried", "", "DE", "276", "", "01", "084", "08426", "48.00468", "9.65741", "Europe/Berlin"),
("2835787", "Schulzendorf", "", "DE", "276", "", "11", "00", "12061", "52.36667", "13.58333", "Europe/Berlin"),
("2836040", "Schrozberg", "", "DE", "276", "", "01", "081", "08127", "49.34528", "9.97944", "Europe/Berlin"),
("2836084", "Schrobenhausen", "Шробенхаузен", "DE", "276", "", "02", "091", "09185", "48.56067", "11.26071", "Europe/Berlin"),
("2836089", "Schriesheim", "", "DE", "276", "", "01", "082", "08226", "49.47372", "8.6636", "Europe/Berlin"),
("2836203", "Schramberg", "Шрамберг", "DE", "276", "", "01", "083", "08325", "48.22399", "8.38583", "Europe/Berlin"),
("2836251", "Schotten", "", "DE", "276", "", "05", "065", "06535", "50.50346", "9.12516", "Europe/Berlin"),
("2836282", "Schortens", "", "DE", "276", "", "06", "00", "03455", "53.53333", "7.95", "Europe/Berlin"),
("2836320", "Schorndorf", "Шорндорф", "DE", "276", "", "01", "081", "08119", "48.80537", "9.52721", "Europe/Berlin"),
("2836390", "Schöppingen", "", "DE", "276", "", "07", "055", "05554", "52.1", "7.23333", "Europe/Berlin"),
("2836396", "Schöppenstedt", "", "DE", "276", "", "06", "00", "03158", "52.14308", "10.7745", "Europe/Berlin"),
("2836413", "Schopfheim", "Шопфхайм", "DE", "276", "", "01", "083", "08336", "47.65105", "7.82089", "Europe/Berlin"),
("2836455", "Schonungen", "", "DE", "276", "", "02", "096", "09678", "50.05008", "10.30809", "Europe/Berlin"),
("2836532", "Schönkirchen", "", "DE", "276", "", "10", "00", "01057", "54.33333", "10.23333", "Europe/Berlin"),
("2836543", "Schöningen", "", "DE", "276", "", "06", "00", "03154", "52.13802", "10.96745", "Europe/Berlin"),
("2836581", "Schönheide", "", "DE", "276", "", "13", "00", "14521", "50.50458", "12.52158", "Europe/Berlin"),
("2836616", "Schongau", "", "DE", "276", "", "02", "091", "09190", "47.8124", "10.89664", "Europe/Berlin"),
("2836746", "Schöneiche", "", "DE", "276", "", "11", "00", "12067", "52.47286", "13.69226", "Europe/Berlin"),
("2836761", "Schönefeld", "", "DE", "276", "", "11", "00", "12061", "52.38333", "13.51667", "Europe/Berlin"),
("2836788", "Schöneberg", "", "DE", "276", "", "16", "00", "11000", "52.46667", "13.35", "Europe/Berlin"),
("2836809", "Schönebeck", "Шёнебек", "DE", "276", "", "14", "00", "15089", "52.01682", "11.7307", "Europe/Berlin"),
("2837085", "Schönau am Königssee", "", "DE", "276", "DE", "02", "091", "09172", "47.60055", "12.98704", "Europe/Berlin"),
("2837093", "Schönaich", "", "DE", "276", "", "01", "081", "08115", "48.65871", "9.06012", "Europe/Berlin"),
("2837115", "Schömberg", "", "DE", "276", "", "01", "082", "08235", "48.78713", "8.64495", "Europe/Berlin"),
("2837134", "Schöllnach", "", "DE", "276", "", "02", "092", "09271", "48.75412", "13.17781", "Europe/Berlin"),
("2837291", "Schneverdingen", "Шнефердинген", "DE", "276", "", "06", "00", "03358", "53.11685", "9.79524", "Europe/Berlin"),
("2837470", "Schneeberg", "Шнеберг", "DE", "276", "", "13", "00", "14521", "50.59465", "12.64139", "Europe/Berlin"),
("2837572", "Schnaittach", "", "DE", "276", "", "02", "095", "09574", "49.55958", "11.34328", "Europe/Berlin"),
("2837652", "Schmölln", "", "DE", "276", "", "15", "00", "16077", "50.89678", "12.35339", "Europe/Berlin"),
("2837706", "Schmitten", "", "DE", "276", "", "05", "064", "06434", "50.26667", "8.45", "Europe/Berlin"),
("2837954", "Schmelz", "", "DE", "276", "", "09", "00", "10044", "49.43333", "6.85", "Europe/Berlin"),
("2838009", "Schmargendorf", "", "DE", "276", "", "16", "00", "11000", "52.47517", "13.29071", "Europe/Berlin"),
("2838053", "Schmallenberg", "Шмалленберг", "DE", "276", "", "07", "059", "05958", "51.15473", "8.28505", "Europe/Berlin"),
("2838059", "Schmalkalden", "Шмалькальден", "DE", "276", "", "15", "00", "16066", "50.72136", "10.44386", "Europe/Berlin"),
("2838167", "Schlüsselfeld", "", "DE", "276", "", "02", "094", "09471", "49.75621", "10.61873", "Europe/Berlin"),
("2838201", "Schlüchtern", "Шлюхтерн", "DE", "276", "", "05", "064", "06435", "50.34891", "9.52532", "Europe/Berlin"),
("2838459", "Schlitz", "", "DE", "276", "", "05", "065", "06535", "50.67416", "9.56102", "Europe/Berlin"),
("2838502", "Schliersee", "", "DE", "276", "", "02", "091", "09182", "47.73621", "11.85936", "Europe/Berlin"),
("2838534", "Schliengen", "", "DE", "276", "", "01", "083", "08336", "47.75698", "7.57645", "Europe/Berlin"),
("2838600", "Schleusingen", "", "DE", "276", "", "15", "00", "16069", "50.51076", "10.75658", "Europe/Berlin"),
("2838634", "Schleswig", "Шлезвиг", "DE", "276", "", "10", "00", "01059", "54.52156", "9.5586", "Europe/Berlin"),
("2838671", "Bad Schlema", "", "DE", "276", "", "13", "00", "14521", "50.60257", "12.67288", "Europe/Berlin"),
("2838673", "Schleiz", "", "DE", "276", "", "15", "00", "16075", "50.57866", "11.81024", "Europe/Berlin"),
("2838744", "Schleiden", "", "DE", "276", "", "07", "053", "05366", "50.52896", "6.47692", "Europe/Berlin"),
("2838918", "Schlangenbad", "", "DE", "276", "", "05", "064", "06439", "50.1", "8.1", "Europe/Berlin"),
("2838922", "Schlangen", "", "DE", "276", "", "07", "057", "05766", "51.80978", "8.84605", "Europe/Berlin"),
("2839010", "Schladen", "", "DE", "276", "", "06", "00", "03158", "52.02218", "10.53967", "Europe/Berlin"),
("2839050", "Schkeuditz", "Шкойдиц", "DE", "276", "", "13", "00", "14730", "51.39678", "12.22141", "Europe/Berlin"),
("2839101", "Schipkau", "", "DE", "276", "", "11", "00", "12066", "51.51667", "13.88333", "Europe/Berlin"),
("2839316", "Schiffweiler", "Шифвайлер", "DE", "276", "", "09", "00", "10043", "49.36667", "7.13333", "Europe/Berlin"),
("2839335", "Schifferstadt", "Шифферштадт", "DE", "276", "", "08", "00", "07338", "49.38417", "8.3775", "Europe/Berlin"),
("2839345", "Schiffdorf", "", "DE", "276", "", "06", "00", "03352", "53.53333", "8.65", "Europe/Berlin"),
("2839393", "Schierling", "", "DE", "276", "", "02", "093", "09375", "48.83422", "12.13946", "Europe/Berlin"),
("2839613", "Scheßlitz", "", "DE", "276", "", "02", "094", "09471", "49.97568", "11.03299", "Europe/Berlin"),
("2839674", "Schermbeck", "", "DE", "276", "", "07", "051", "05170", "51.68333", "6.86667", "Europe/Berlin"),
("2839819", "Schellerten", "", "DE", "276", "", "06", "00", "03254", "52.1853", "10.10227", "Europe/Berlin"),
("2839888", "Schelklingen", "", "DE", "276", "", "01", "084", "08425", "48.37575", "9.73273", "Europe/Berlin"),
("2840070", "Scheeßel", "", "DE", "276", "", "06", "00", "03357", "53.16667", "9.48333", "Europe/Berlin"),
("2840393", "Scharbeutz", "", "DE", "276", "", "10", "00", "01055", "54.03333", "10.75", "Europe/Berlin"),
("2840526", "Schallstadt", "", "DE", "276", "", "01", "083", "08315", "47.95855", "7.75755", "Europe/Berlin"),
("2840555", "Schalksmühle", "", "DE", "276", "", "07", "059", "05962", "51.23333", "7.53333", "Europe/Berlin"),
("2840634", "Schäftlarn", "", "DE", "276", "", "02", "091", "09184", "47.99027", "11.45591", "Europe/Berlin"),
("2841039", "Schaafheim", "", "DE", "276", "", "05", "064", "06432", "49.92417", "9.00944", "Europe/Berlin"),
("2841125", "Saulgau", "", "DE", "276", "", "01", "084", "08437", "48.01676", "9.50064", "Europe/Berlin"),
("2841178", "Sauerlach", "", "DE", "276", "", "02", "091", "09184", "47.97171", "11.65383", "Europe/Berlin"),
("2841290", "Satteldorf", "", "DE", "276", "", "01", "081", "08127", "49.16953", "10.07957", "Europe/Berlin"),
("2841321", "Satow-Oberhagen", "", "DE", "276", "", "12", "00", "13072", "53.99545", "11.88466", "Europe/Berlin"),
("2841333", "Saßnitz", "", "DE", "276", "", "12", "00", "13073", "54.5157", "13.64451", "Europe/Berlin"),
("2841351", "Sassenberg", "", "DE", "276", "", "07", "055", "05570", "51.99223", "8.04068", "Europe/Berlin"),
("2841374", "Sasel", "", "DE", "276", "", "04", "00", "02000", "53.65385", "10.11184", "Europe/Berlin"),
("2841380", "Sasbach", "", "DE", "276", "", "01", "083", "08317", "48.63971", "8.09375", "Europe/Berlin"),
("2841386", "Sarstedt", "Зарштедт", "DE", "276", "", "06", "00", "03254", "52.23495", "9.85411", "Europe/Berlin"),
("2841463", "Sankt Wendel", "Санкт-Вендель", "DE", "276", "", "09", "00", "10046", "49.46633", "7.16814", "Europe/Berlin"),
("2841577", "Sankt Johann", "", "DE", "276", "", "01", "084", "08415", "48.45397", "9.34396", "Europe/Berlin"),
("2841590", "Sankt Ingbert", "", "DE", "276", "", "09", "00", "10045", "49.27697", "7.11672", "Europe/Berlin"),
("2841619", "Sankt Georgen im Schwarzwald", "", "DE", "276", "", "01", "083", "08326", "48.12716", "8.33513", "Europe/Berlin"),
("2841631", "St. Georg", "", "DE", "276", "", "04", "00", "02000", "53.55513", "10.01231", "Europe/Berlin"),
("2841648", "Sankt Augustin", "Санкт-Августин", "DE", "276", "", "07", "053", "05382", "50.77538", "7.197", "Europe/Berlin"),
("2841684", "Alt-Sanitz", "", "DE", "276", "", "12", "00", "13075", "53.81363", "13.58786", "Europe/Berlin"),
("2841693", "Sangerhausen", "Зангерхаузен", "DE", "276", "", "14", "00", "15087", "51.47221", "11.29533", "Europe/Berlin"),
("2841835", "Sandhausen", "", "DE", "276", "", "01", "082", "08226", "49.34278", "8.65917", "Europe/Berlin"),
("2841879", "Sandersdorf", "", "DE", "276", "", "14", "00", "15082", "51.62841", "12.26492", "Europe/Berlin"),
("2841895", "Sande", "", "DE", "276", "", "06", "00", "03455", "53.50489", "8.01418", "Europe/Berlin"),
("2842109", "Salzweg", "", "DE", "276", "", "02", "092", "09275", "48.61667", "13.48333", "Europe/Berlin"),
("2842112", "Salzwedel", "Зальцведель", "DE", "276", "", "14", "00", "15081", "52.85435", "11.1525", "Europe/Berlin"),
("2842131", "Salzkotten", "Зальцкоттен", "DE", "276", "", "07", "057", "05774", "51.6717", "8.60092", "Europe/Berlin"),
("2842143", "Salzhemmendorf", "", "DE", "276", "", "06", "00", "03252", "52.067", "9.5872", "Europe/Berlin"),
("2842175", "Salzbergen", "", "DE", "276", "", "06", "00", "03454", "52.33333", "7.35", "Europe/Berlin"),
("2842331", "Salach", "", "DE", "276", "", "01", "081", "08117", "48.69198", "9.73715", "Europe/Berlin"),
("2842441", "Saerbeck", "", "DE", "276", "", "07", "055", "05566", "52.17372", "7.63395", "Europe/Berlin"),
("2842621", "Saarwellingen", "", "DE", "276", "", "09", "00", "10044", "49.3543", "6.80487", "Europe/Berlin"),
("2842632", "Saarlouis", "Саарлуисе", "DE", "276", "", "09", "00", "10044", "49.31366", "6.75154", "Europe/Berlin"),
("2842644", "Saarburg", "", "DE", "276", "", "08", "00", "07235", "49.60641", "6.54365", "Europe/Berlin"),
("2842647", "Saarbrücken", "Саарбрюккен", "DE", "276", "", "09", "00", "10041", "49.2354", "6.98165", "Europe/Berlin"),
("2842688", "Saalfeld", "Заальфельд", "DE", "276", "", "15", "00", "16073", "50.64826", "11.36536", "Europe/Berlin"),
("2842728", "Saal", "", "DE", "276", "", "02", "092", "09273", "48.90099", "11.93196", "Europe/Berlin"),
("2842816", "Rüthen", "", "DE", "276", "", "07", "059", "05974", "51.4909", "8.43596", "Europe/Berlin"),
("2842824", "Rutesheim", "", "DE", "276", "", "01", "081", "08115", "48.80808", "8.94536", "Europe/Berlin"),
("2842884", "Rüsselsheim", "Рюссельсхайм", "DE", "276", "", "05", "064", "06433", "49.98955", "8.42251", "Europe/Berlin"),
("2842960", "Ruppichteroth", "", "DE", "276", "", "07", "053", "05382", "50.84367", "7.48409", "Europe/Berlin"),
("2843042", "Runkel", "", "DE", "276", "", "05", "065", "06533", "50.40574", "8.15457", "Europe/Berlin"),
("2843106", "Rummelsburg", "", "DE", "276", "", "16", "00", "11000", "52.50146", "13.4934", "Europe/Berlin"),
("2843146", "Rülzheim", "", "DE", "276", "", "08", "00", "07334", "49.16278", "8.28583", "Europe/Berlin"),
("2843185", "Ruhstorf", "", "DE", "276", "", "02", "092", "09279", "48.53976", "12.68305", "Europe/Berlin"),
("2843203", "Ruhpolding", "", "DE", "276", "", "02", "091", "09189", "47.76667", "12.65", "Europe/Berlin"),
("2843258", "Ruhla", "", "DE", "276", "", "15", "00", "16063", "50.89296", "10.36573", "Europe/Berlin"),
("2843350", "Rudow", "", "DE", "276", "", "16", "00", "11000", "52.42407", "13.48529", "Europe/Berlin"),
("2843355", "Rudolstadt", "Рудольштадт", "DE", "276", "", "15", "00", "16073", "50.72043", "11.34046", "Europe/Berlin"),
("2843395", "Rüdesheim am Rhein", "", "DE", "276", "", "05", "064", "06439", "49.98214", "7.92964", "Europe/Berlin"),
("2843415", "Rudersberg", "", "DE", "276", "", "01", "081", "08119", "48.88515", "9.52927", "Europe/Berlin"),
("2843636", "Rottweil", "Ротвайль", "DE", "276", "", "01", "083", "08325", "48.16783", "8.62719", "Europe/Berlin"),
("2843682", "Rotthalmünster", "", "DE", "276", "", "02", "092", "09275", "48.35825", "13.20162", "Europe/Berlin"),
("2843724", "Rottendorf", "", "DE", "276", "", "02", "096", "09679", "49.8", "10.03333", "Europe/Berlin"),
("2843728", "Rottenburg an der Laaber", "", "DE", "276", "", "02", "092", "09274", "48.70233", "12.02717", "Europe/Berlin"),
("2843729", "Rottenburg", "", "DE", "276", "", "01", "084", "08416", "48.47629", "8.93528", "Europe/Berlin"),
("2843775", "Rottach-Egern", "", "DE", "276", "", "02", "091", "09182", "47.68966", "11.77065", "Europe/Berlin"),
("2844056", "Rothenburg ob der Tauber", "", "DE", "276", "", "02", "095", "09571", "49.37885", "10.18711", "Europe/Berlin"),
("2844062", "Rothenburg", "", "DE", "276", "", "13", "00", "14626", "51.334", "14.96874", "Europe/Berlin"),
("2844126", "Röthenbach an der Pegnitz", "", "DE", "276", "", "02", "095", "09574", "49.48301", "11.24116", "Europe/Berlin"),
("2844265", "Roth", "Рота", "DE", "276", "", "02", "095", "09576", "49.24762", "11.09111", "Europe/Berlin"),
("2844277", "Roetgen", "", "DE", "276", "", "07", "053", "05334", "50.65", "6.2", "Europe/Berlin"),
("2844434", "Rotenburg an der Fulda", "", "DE", "276", "", "05", "066", "06632", "50.99556", "9.72838", "Europe/Berlin"),
("2844437", "Rotenburg", "Ротенбург", "DE", "276", "", "06", "00", "03357", "53.11125", "9.41082", "Europe/Berlin"),
("2844567", "Rot am See", "", "DE", "276", "", "01", "081", "08127", "49.25", "10.01667", "Europe/Berlin"),
("2844588", "Rostock", "Росток", "DE", "276", "", "12", "00", "13003", "54.0887", "12.14049", "Europe/Berlin"),
("2844604", "Roßwein", "", "DE", "276", "", "13", "00", "14522", "51.06589", "13.18308", "Europe/Berlin"),
("2844616", "Roßtal", "", "DE", "276", "", "02", "095", "09573", "49.39567", "10.88848", "Europe/Berlin"),
("2844651", "Roßleben", "", "DE", "276", "", "15", "00", "16065", "51.29886", "11.43435", "Europe/Berlin"),
("2844654", "Roßlau", "", "DE", "276", "", "14", "00", "15001", "51.88736", "12.24192", "Europe/Berlin"),
("2844756", "Roßdorf", "", "DE", "276", "", "05", "064", "06432", "49.85972", "8.76167", "Europe/Berlin"),
("2844862", "Rösrath", "Рёсрат", "DE", "276", "", "07", "053", "05378", "50.89559", "7.18175", "Europe/Berlin"),
("2844910", "Rosenthal", "", "DE", "276", "DE", "16", "00", "11000", "52.59976", "13.37774", "Europe/Berlin"),
("2844988", "Rosenheim", "Розенхайм", "DE", "276", "", "02", "091", "09163", "47.85637", "12.12247", "Europe/Berlin"),
("2845027", "Rosenfeld", "", "DE", "276", "", "01", "084", "08417", "48.28639", "8.72357", "Europe/Berlin"),
("2845131", "Rosdorf", "", "DE", "276", "", "06", "00", "03152", "51.5", "9.9", "Europe/Berlin"),
("2845160", "Rosbach vor der Höhe", "", "DE", "276", "", "05", "064", "06440", "50.30332", "8.68976", "Europe/Berlin"),
("2845222", "Ronnenberg", "", "DE", "276", "", "06", "00", "03241", "52.31939", "9.65544", "Europe/Berlin"),
("2845229", "Ronneburg", "", "DE", "276", "", "15", "00", "16076", "50.8634", "12.18666", "Europe/Berlin"),
("2845273", "Rommerskirchen", "", "DE", "276", "", "07", "051", "05162", "51.03333", "6.68333", "Europe/Berlin"),
("2845565", "Röhrmoos", "", "DE", "276", "", "02", "091", "09174", "48.32966", "11.44672", "Europe/Berlin"),
("2845641", "Rohrdorf", "", "DE", "276", "", "02", "091", "09187", "47.79713", "12.1701", "Europe/Berlin"),
("2845723", "Rohrbach", "", "DE", "276", "", "02", "091", "09183", "48.28933", "12.55603", "Europe/Berlin"),
("2845919", "Rödinghausen", "", "DE", "276", "", "07", "057", "05758", "52.25", "8.48333", "Europe/Berlin"),
("2845924", "Roding", "", "DE", "276", "", "02", "093", "09372", "49.19426", "12.51956", "Europe/Berlin"),
("2845953", "Rodewisch", "", "DE", "276", "", "13", "00", "14523", "50.53083", "12.41329", "Europe/Berlin"),
("2846040", "Rodenberg", "", "DE", "276", "", "06", "00", "03257", "52.31152", "9.3564", "Europe/Berlin"),
("2846063", "Rodenbach", "", "DE", "276", "", "05", "064", "06435", "50.15", "9.03333", "Europe/Berlin"),
("2846158", "Rodalben", "", "DE", "276", "", "08", "00", "07340", "49.2394", "7.63962", "Europe/Berlin"),
("2846229", "Rockenhausen", "", "DE", "276", "", "08", "00", "07333", "49.62974", "7.82134", "Europe/Berlin"),
("2846261", "Rochlitz", "", "DE", "276", "", "13", "00", "14522", "51.05007", "12.79754", "Europe/Berlin"),
("2846286", "Röbel", "", "DE", "276", "", "12", "00", "13071", "53.37555", "12.60372", "Europe/Berlin"),
("2846398", "Ritterhude", "", "DE", "276", "", "06", "00", "03356", "53.18289", "8.7355", "Europe/Berlin"),
("2846523", "Rinteln", "Ринтельн", "DE", "276", "", "06", "00", "03257", "52.18604", "9.07917", "Europe/Berlin"),
("2846722", "Rimpar", "", "DE", "276", "", "02", "096", "09679", "49.85692", "9.95705", "Europe/Berlin"),
("2846754", "Rimbach", "", "DE", "276", "", "05", "064", "06431", "49.625", "8.76306", "Europe/Berlin"),
("2846843", "Rietberg", "Ритберг", "DE", "276", "", "07", "057", "05754", "51.80924", "8.42841", "Europe/Berlin"),
("2846939", "Riesa", "Риза", "DE", "276", "", "13", "00", "14627", "51.30777", "13.29168", "Europe/Berlin"),
("2847003", "Rielasingen-Worblingen", "", "DE", "276", "", "01", "083", "08335", "47.73465", "8.84013", "Europe/Berlin"),
("2847013", "Riehl", "", "DE", "276", "", "07", "053", "05315", "50.96686", "6.97572", "Europe/Berlin"),
("2847033", "Riegelsberg", "", "DE", "276", "", "09", "00", "10041", "49.3", "6.93333", "Europe/Berlin"),
("2847080", "Riedlingen", "", "DE", "276", "", "01", "084", "08426", "48.15455", "9.47558", "Europe/Berlin"),
("2847195", "Riedering", "", "DE", "276", "", "02", "091", "09187", "47.83874", "12.20778", "Europe/Berlin"),
("2847231", "Riedenburg", "", "DE", "276", "", "02", "092", "09273", "48.96383", "11.6888", "Europe/Berlin"),
("2847524", "Ribnitz-Damgarten", "Рибниц-Дамгартен", "DE", "276", "", "12", "00", "13073", "54.2422", "12.45666", "Europe/Berlin"),
("2847586", "Rheurdt", "", "DE", "276", "", "07", "051", "05154", "51.46667", "6.46667", "Europe/Berlin"),
("2847612", "Rheinsberg", "", "DE", "276", "", "11", "00", "12068", "53.09972", "12.89885", "Europe/Berlin"),
("2847639", "Rheinfelden (Baden)", "Райнфельден", "DE", "276", "", "01", "083", "08336", "47.56013", "7.78715", "Europe/Berlin"),
("2847645", "Rheine", "Райн", "DE", "276", "", "07", "055", "05566", "52.28509", "7.44055", "Europe/Berlin"),
("2847662", "Rheinberg", "", "DE", "276", "", "07", "051", "05170", "51.54649", "6.59525", "Europe/Berlin"),
("2847666", "Rheinbach", "Райнбах", "DE", "276", "", "07", "053", "05382", "50.62562", "6.94911", "Europe/Berlin"),
("2847669", "Rheinau", "", "DE", "276", "", "01", "082", "08216", "48.87173", "8.19133", "Europe/Berlin"),
("2847689", "Rhede", "Реде", "DE", "276", "", "07", "055", "05554", "51.83537", "6.69602", "Europe/Berlin"),
("2847690", "Rheda-Wiedenbrück", "Ред-Виденбрюк", "DE", "276", "", "07", "057", "05754", "51.84967", "8.30017", "Europe/Berlin"),
("2847736", "Reutlingen", "Ройтлинген", "DE", "276", "", "01", "084", "08415", "48.49144", "9.20427", "Europe/Berlin"),
("2848110", "Reppenstedt", "", "DE", "276", "", "06", "00", "03355", "53.25", "10.35", "Europe/Berlin"),
("2848175", "Renningen", "Реннинген", "DE", "276", "", "01", "081", "08115", "48.76974", "8.93871", "Europe/Berlin"),
("2848181", "Rennertshofen", "", "DE", "276", "", "02", "091", "09185", "48.75943", "11.04544", "Europe/Berlin"),
("2848245", "Rendsburg", "Рендсбург", "DE", "276", "", "10", "00", "01058", "54.30663", "9.66313", "Europe/Berlin"),
("2848251", "Renchen", "", "DE", "276", "", "01", "083", "08317", "48.5885", "8.01321", "Europe/Berlin"),
("2848273", "Remscheid", "Ремшайд", "DE", "276", "", "07", "051", "05120", "51.17983", "7.1925", "Europe/Berlin"),
("2848335", "Remagen", "Ремаген", "DE", "276", "", "08", "00", "07131", "50.57879", "7.22703", "Europe/Berlin"),
("2848340", "Rellingen", "", "DE", "276", "", "10", "00", "01056", "53.65", "9.81667", "Europe/Berlin"),
("2848543", "Reiskirchen", "", "DE", "276", "", "05", "065", "06531", "50.6", "8.83333", "Europe/Berlin"),
("2848621", "Reisbach", "", "DE", "276", "", "02", "092", "09279", "48.57008", "12.62799", "Europe/Berlin"),
("2848725", "Reinsdorf", "", "DE", "276", "", "13", "00", "14524", "50.7", "12.58333", "Europe/Berlin"),
("2848756", "Reinickendorf", "", "DE", "276", "", "16", "00", "11000", "52.56667", "13.33333", "Europe/Berlin"),
("2848762", "Reinheim", "Райнхайм", "DE", "276", "", "05", "064", "06432", "49.82923", "8.83572", "Europe/Berlin"),
("2848811", "Reinfeld", "", "DE", "276", "", "10", "00", "01062", "53.83184", "10.49126", "Europe/Berlin"),
("2848845", "Reinbek", "Райнбек", "DE", "276", "", "10", "00", "01062", "53.51703", "10.2488", "Europe/Berlin"),
("2848867", "Reilingen", "", "DE", "276", "", "01", "082", "08226", "49.29833", "8.56417", "Europe/Berlin"),
("2849017", "Reichertshofen", "", "DE", "276", "", "02", "091", "09186", "48.65775", "11.46612", "Europe/Berlin"),
("2849118", "Reichenbach an der Fils", "", "DE", "276", "", "01", "081", "08116", "48.71011", "9.46429", "Europe/Berlin"),
("2849156", "Reichenbach/Vogtland", "", "DE", "276", "", "13", "00", "14523", "50.62279", "12.30344", "Europe/Berlin"),
("2849197", "Reichelsheim", "", "DE", "276", "", "05", "064", "06440", "50.35638", "8.87446", "Europe/Berlin"),
("2849198", "Reichelsheim", "", "DE", "276", "", "05", "064", "06437", "49.71211", "8.83896", "Europe/Berlin"),
("2849371", "Rehburg-Loccum", "", "DE", "276", "", "06", "00", "03256", "52.46952", "9.19957", "Europe/Berlin"),
("2849446", "Rehau", "", "DE", "276", "", "02", "094", "09475", "50.24921", "12.03422", "Europe/Berlin"),
("2849476", "Regenstauf", "", "DE", "276", "", "02", "093", "09375", "49.12014", "12.13027", "Europe/Berlin"),
("2849483", "Regensburg", "Регенсбург", "DE", "276", "", "02", "093", "09362", "49.01513", "12.10161", "Europe/Berlin"),
("2849495", "Regen", "", "DE", "276", "", "02", "092", "09276", "48.9719", "13.12824", "Europe/Berlin"),
("2849548", "Rees", "Рес", "DE", "276", "", "07", "051", "05154", "51.76263", "6.39778", "Europe/Berlin"),
("2849568", "Rednitzhembach", "", "DE", "276", "", "02", "095", "09576", "49.30095", "11.07997", "Europe/Berlin"),
("2849647", "Recklinghausen", "Реклингхаузен", "DE", "276", "", "07", "055", "05562", "51.61379", "7.19738", "Europe/Berlin"),
("2849689", "Recke", "", "DE", "276", "", "07", "055", "05566", "52.38333", "7.71667", "Europe/Berlin"),
("2849740", "Rechberghausen", "", "DE", "276", "", "01", "081", "08117", "48.7308", "9.64419", "Europe/Berlin"),
("2849802", "Ravensburg", "Равенсбург", "DE", "276", "", "01", "084", "08436", "47.78198", "9.61062", "Europe/Berlin"),
("2849913", "Raunheim", "", "DE", "276", "", "05", "064", "06433", "50.0132", "8.45253", "Europe/Berlin"),
("2850056", "Rauenberg", "", "DE", "276", "", "01", "082", "08226", "49.26943", "8.70344", "Europe/Berlin"),
("2850085", "Raubling", "", "DE", "276", "", "02", "091", "09187", "47.7905", "12.11088", "Europe/Berlin"),
("2850132", "Ratzeburg", "", "DE", "276", "", "10", "00", "01053", "53.6947", "10.79084", "Europe/Berlin"),
("2850174", "Ratingen", "Ратинген", "DE", "276", "", "07", "051", "05158", "51.29724", "6.84929", "Europe/Berlin"),
("2850213", "Rathenow", "Ратенов", "DE", "276", "", "11", "00", "12063", "52.60659", "12.33696", "Europe/Berlin"),
("2850224", "Rath", "", "DE", "276", "", "07", "053", "05315", "50.92379", "7.0927", "Europe/Berlin"),
("2850235", "Ratekau", "Ратекау", "DE", "276", "", "10", "00", "01055", "53.95", "10.73333", "Europe/Berlin"),
("2850253", "Rastede", "Растеде", "DE", "276", "", "06", "00", "03451", "53.25", "8.2", "Europe/Berlin"),
("2850257", "Rastatt", "Раштатт", "DE", "276", "", "01", "082", "08216", "48.85851", "8.20965", "Europe/Berlin"),
("2850425", "Ranstadt", "", "DE", "276", "", "05", "064", "06440", "50.35", "8.98333", "Europe/Berlin"),
("2850490", "Rangsdorf", "", "DE", "276", "", "11", "00", "12072", "52.29126", "13.41946", "Europe/Berlin"),
("2850496", "Rangendingen", "", "DE", "276", "", "01", "084", "08417", "48.38168", "8.8894", "Europe/Berlin"),
("2850536", "Ramstein-Miesenbach", "", "DE", "276", "", "08", "00", "07335", "49.44452", "7.55533", "Europe/Berlin"),
("2850777", "Raisdorf", "", "DE", "276", "", "10", "00", "01057", "54.28127", "10.24915", "Europe/Berlin"),
("2850808", "Rain", "", "DE", "276", "", "02", "097", "09779", "48.69029", "10.91611", "Europe/Berlin"),
("2850850", "Rahnsdorf", "", "DE", "276", "DE", "16", "00", "11000", "52.44115", "13.68708", "Europe/Berlin"),
("2850887", "Rahden", "Раден", "DE", "276", "", "07", "057", "05770", "52.43367", "8.61263", "Europe/Berlin"),
("2850942", "Raesfeld", "", "DE", "276", "", "07", "055", "05554", "51.76667", "6.85", "Europe/Berlin"),
("2850954", "Radolfzell am Bodensee", "Радольфцелль", "DE", "276", "", "01", "083", "08335", "47.74194", "8.97098", "Europe/Berlin"),
("2850995", "Radevormwald", "Радеформвальд", "DE", "276", "", "07", "053", "05374", "51.20219", "7.36027", "Europe/Berlin"),
("2851074", "Radeburg", "", "DE", "276", "", "13", "00", "14627", "51.21516", "13.7281", "Europe/Berlin"),
("2851077", "Radebeul", "Радебойль", "DE", "276", "", "13", "00", "14627", "51.10654", "13.66047", "Europe/Berlin"),
("2851079", "Radeberg", "Радеберг", "DE", "276", "", "13", "00", "14625", "51.11112", "13.91199", "Europe/Berlin"),
("2851337", "Quierschied", "", "DE", "276", "", "09", "00", "10041", "49.31667", "7.05", "Europe/Berlin"),
("2851343", "Quickborn", "Квикборн", "DE", "276", "", "10", "00", "01056", "53.72831", "9.90934", "Europe/Berlin"),
("2851393", "Querfurt", "", "DE", "276", "", "14", "00", "15088", "51.38124", "11.60047", "Europe/Berlin"),
("2851465", "Quedlinburg", "Кведлинбург", "DE", "276", "", "14", "00", "15085", "51.78843", "11.15006", "Europe/Berlin"),
("2851523", "Quakenbrück", "", "DE", "276", "", "06", "00", "03459", "52.67502", "7.94983", "Europe/Berlin"),
("2851543", "Pyrbaum", "", "DE", "276", "", "02", "093", "09373", "49.29622", "11.28655", "Europe/Berlin"),
("2851567", "Putzbrunn", "", "DE", "276", "", "02", "091", "09184", "48.07579", "11.71572", "Europe/Berlin"),
("2851584", "Püttlingen", "Пютлинген", "DE", "276", "", "09", "00", "10041", "49.2855", "6.88723", "Europe/Berlin"),
("2851739", "Pullach im Isartal", "", "DE", "276", "", "02", "091", "09184", "48.06122", "11.52148", "Europe/Berlin"),
("2851746", "Pulheim", "Пульхайм", "DE", "276", "", "07", "053", "05362", "50.99965", "6.80632", "Europe/Berlin"),
("2851782", "Puchheim", "", "DE", "276", "", "02", "091", "09179", "48.15", "11.35", "Europe/Berlin"),
("2851826", "Prüm", "", "DE", "276", "", "08", "00", "07232", "50.20785", "6.42019", "Europe/Berlin"),
("2851962", "Pritzwalk", "", "DE", "276", "", "11", "00", "12070", "53.14945", "12.17405", "Europe/Berlin"),
("2852101", "Prien am Chiemsee", "", "DE", "276", "", "02", "091", "09187", "47.85602", "12.34623", "Europe/Berlin"),
("2852144", "Preußisch Oldendorf", "", "DE", "276", "", "07", "057", "05770", "52.30589", "8.49341", "Europe/Berlin"),
("2852217", "Prenzlauer Berg", "Пренцлауэр-Берг", "DE", "276", "", "16", "00", "11000", "52.53878", "13.42443", "Europe/Berlin"),
("2852218", "Prenzlau", "Пренцлау", "DE", "276", "", "11", "00", "12073", "53.31625", "13.86261", "Europe/Berlin"),
("2852233", "Premnitz", "", "DE", "276", "", "11", "00", "12063", "52.53184", "12.34845", "Europe/Berlin"),
("2852280", "Preetz", "Прец", "DE", "276", "", "10", "00", "01057", "54.2354", "10.27795", "Europe/Berlin"),
("2852422", "Pöttmes", "", "DE", "276", "", "02", "097", "09771", "48.58383", "11.08762", "Europe/Berlin"),
("2852440", "Pottenstein", "", "DE", "276", "", "02", "094", "09472", "49.77131", "11.40784", "Europe/Berlin"),
("2852458", "Potsdam", "Потсдам", "DE", "276", "", "11", "00", "12054", "52.39886", "13.06566", "Europe/Berlin"),
("2852512", "Pößneck", "", "DE", "276", "", "15", "00", "16075", "50.69358", "11.59229", "Europe/Berlin"),
("2852566", "Porz am Rhein", "", "DE", "276", "", "07", "053", "05315", "50.88637", "7.0583", "Europe/Berlin"),
("2852577", "Porta Westfalica", "", "DE", "276", "", "07", "057", "05770", "52.23779", "8.91901", "Europe/Berlin"),
("2852673", "Poppenbüttel", "", "DE", "276", "", "04", "00", "02000", "53.65917", "10.08472", "Europe/Berlin"),
("2852772", "Pommelsbrunn", "", "DE", "276", "", "02", "095", "09574", "49.50437", "11.51101", "Europe/Berlin"),
("2852863", "Poll", "", "DE", "276", "", "07", "053", "05315", "50.91256", "6.99057", "Europe/Berlin"),
("2852909", "Polch", "", "DE", "276", "", "08", "00", "07137", "50.29973", "7.31315", "Europe/Berlin"),
("2852939", "Poing", "", "DE", "276", "", "02", "091", "09175", "48.17004", "11.81863", "Europe/Berlin"),
("2853065", "Pocking", "", "DE", "276", "", "02", "092", "09275", "48.40149", "13.31315", "Europe/Berlin"),
("2853066", "Pöcking", "", "DE", "276", "", "02", "091", "09188", "47.96667", "11.3", "Europe/Berlin"),
("2853107", "Plüderhausen", "", "DE", "276", "", "01", "081", "08119", "48.79875", "9.59587", "Europe/Berlin"),
("2853162", "Plön", "", "DE", "276", "", "10", "00", "01057", "54.16241", "10.42333", "Europe/Berlin"),
("2853180", "Plochingen", "", "DE", "276", "", "01", "081", "08116", "48.71067", "9.41949", "Europe/Berlin"),
("2853192", "Pliezhausen", "", "DE", "276", "", "01", "084", "08415", "48.55934", "9.20749", "Europe/Berlin"),
("2853209", "Plettenberg", "Плеттенберг", "DE", "276", "", "07", "059", "05962", "51.20949", "7.87261", "Europe/Berlin"),
("2853260", "Pleinfeld", "", "DE", "276", "", "02", "095", "09577", "49.10473", "10.98194", "Europe/Berlin"),
("2853266", "Pleidelsheim", "", "DE", "276", "", "01", "081", "08118", "48.9592", "9.20311", "Europe/Berlin"),
("2853292", "Plauen", "Плауэн", "DE", "276", "", "13", "00", "14523", "50.4973", "12.13782", "Europe/Berlin"),
("2853297", "Plau am See", "", "DE", "276", "", "12", "00", "13076", "53.45821", "12.26246", "Europe/Berlin"),
("2853310", "Plattling", "", "DE", "276", "", "02", "092", "09271", "48.77866", "12.87509", "Europe/Berlin"),
("2853435", "Plankstadt", "", "DE", "276", "", "01", "082", "08226", "49.39444", "8.59611", "Europe/Berlin"),
("2853463", "Planegg", "", "DE", "276", "", "02", "091", "09184", "48.1", "11.41667", "Europe/Berlin"),
("2853471", "Plaidt", "", "DE", "276", "", "08", "00", "07137", "50.3926", "7.39251", "Europe/Berlin"),
("2853572", "Pirna", "Пирна", "DE", "276", "", "13", "00", "14628", "50.95843", "13.93702", "Europe/Berlin"),
("2853574", "Pirmasens", "Пирмазенс", "DE", "276", "", "08", "00", "07317", "49.20145", "7.60529", "Europe/Berlin"),
("2853658", "Pinneberg", "Пиннеберг", "DE", "276", "", "10", "00", "01056", "53.66732", "9.78936", "Europe/Berlin"),
("2853691", "Pilsting", "", "DE", "276", "", "02", "092", "09279", "48.70116", "12.65105", "Europe/Berlin"),
("2853855", "Piding", "", "DE", "276", "", "02", "091", "09172", "47.76667", "12.91667", "Europe/Berlin"),
("2853907", "Philippsburg", "", "DE", "276", "", "01", "082", "08215", "49.2317", "8.46074", "Europe/Berlin"),
("2853924", "Pfungstadt", "Пфунгштадт", "DE", "276", "", "05", "064", "06432", "49.80557", "8.60307", "Europe/Berlin"),
("2853928", "Pfullingen", "Пфуллинген", "DE", "276", "", "01", "084", "08415", "48.46458", "9.22796", "Europe/Berlin"),
("2853930", "Pfullendorf", "", "DE", "276", "", "01", "084", "08437", "47.9261", "9.2578", "Europe/Berlin"),
("2853949", "Pfronten", "", "DE", "276", "", "02", "097", "09777", "47.5822", "10.54962", "Europe/Berlin"),
("2853961", "Pfreimd", "", "DE", "276", "", "02", "093", "09376", "49.49114", "12.18069", "Europe/Berlin"),
("2853969", "Pforzheim", "Пфорцхайм", "DE", "276", "", "01", "082", "08231", "48.88436", "8.69892", "Europe/Berlin"),
("2854152", "Pfedelbach", "", "DE", "276", "", "01", "081", "08126", "49.17806", "9.505", "Europe/Berlin"),
("2854179", "Pfarrkirchen", "", "DE", "276", "", "02", "092", "09277", "48.43205", "12.93812", "Europe/Berlin"),
("2854252", "Pfalzgrafenweiler", "", "DE", "276", "", "01", "082", "08237", "48.5265", "8.56582", "Europe/Berlin"),
("2854384", "Pfaffenhofen an der Roth", "", "DE", "276", "", "02", "097", "09775", "48.35454", "10.16184", "Europe/Berlin"),
("2854386", "Pfaffenhofen an der Ilm", "Пфаффенхофен-ан-дер-Ильм", "DE", "276", "", "02", "091", "09186", "48.53053", "11.505", "Europe/Berlin"),
("2854646", "Petershausen", "", "DE", "276", "", "02", "091", "09174", "48.4", "11.46667", "Europe/Berlin"),
("2854653", "Petershagen", "", "DE", "276", "", "11", "00", "12064", "52.52078", "13.78748", "Europe/Berlin"),
("2854655", "Petershagen", "Петерсхаген", "DE", "276", "", "07", "057", "05770", "52.37513", "8.96538", "Europe/Berlin"),
("2854706", "Petersberg", "", "DE", "276", "", "05", "066", "06631", "50.56187", "9.71312", "Europe/Berlin"),
("2854737", "Petersaurach", "", "DE", "276", "", "02", "095", "09571", "49.3", "10.75", "Europe/Berlin"),
("2854848", "Perleberg", "", "DE", "276", "", "11", "00", "12070", "53.07583", "11.85739", "Europe/Berlin"),
("2854923", "Penzberg", "Пенцберг", "DE", "276", "", "02", "091", "09190", "47.75293", "11.377", "Europe/Berlin"),
("2854928", "Pentling", "", "DE", "276", "", "02", "093", "09375", "48.98343", "12.0587", "Europe/Berlin"),
("2854967", "Penig", "", "DE", "276", "", "13", "00", "14522", "50.93336", "12.70422", "Europe/Berlin"),
("2855024", "Peitz", "", "DE", "276", "", "11", "00", "12071", "51.85841", "14.41138", "Europe/Berlin"),
("2855025", "Peiting", "", "DE", "276", "", "02", "091", "09190", "47.79549", "10.92951", "Europe/Berlin"),
("2855029", "Peißenberg", "", "DE", "276", "", "02", "091", "09190", "47.80466", "11.0699", "Europe/Berlin"),
("2855047", "Peine", "Пайне", "DE", "276", "", "06", "00", "03157", "52.31928", "10.2352", "Europe/Berlin"),
("2855065", "Pegnitz", "", "DE", "276", "", "02", "094", "09472", "49.75216", "11.54187", "Europe/Berlin"),
("2855243", "Pattensen", "", "DE", "276", "", "06", "00", "03241", "52.26448", "9.76436", "Europe/Berlin"),
("2855328", "Passau", "Пассау", "DE", "276", "", "02", "092", "09262", "48.5665", "13.43122", "Europe/Berlin"),
("2855334", "Pasing", "", "DE", "276", "", "02", "091", "09162", "48.14146", "11.45599", "Europe/Berlin"),
("2855337", "Pasewalk", "", "DE", "276", "", "12", "00", "13075", "53.50627", "13.98997", "Europe/Berlin"),
("2855388", "Parsberg", "", "DE", "276", "", "02", "093", "09373", "49.16074", "11.71834", "Europe/Berlin"),
("2855441", "Parchim", "Пархим", "DE", "276", "", "12", "00", "13076", "53.42631", "11.84875", "Europe/Berlin"),
("2855525", "Papenburg", "Папенбург", "DE", "276", "", "06", "00", "03454", "53.07738", "7.40444", "Europe/Berlin"),
("2855598", "Pankow", "Панков", "DE", "276", "", "16", "00", "11000", "52.56926", "13.40186", "Europe/Berlin"),
("2855745", "Paderborn", "Падерборн", "DE", "276", "", "07", "057", "05774", "51.71905", "8.75439", "Europe/Berlin"),
("2855794", "Oyten", "", "DE", "276", "", "06", "00", "03361", "53.05", "9.01667", "Europe/Berlin"),
("2855859", "Overath", "Оверат", "DE", "276", "", "07", "053", "05378", "50.93275", "7.28389", "Europe/Berlin"),
("2855881", "Ovelgönne", "", "DE", "276", "", "06", "00", "03461", "53.34189", "8.42179", "Europe/Berlin"),
("2855917", "Ottweiler", "Отвайлер", "DE", "276", "", "09", "00", "10043", "49.40133", "7.16424", "Europe/Berlin"),
("2855935", "Ottobrunn", "Оттобрунн", "DE", "276", "", "02", "091", "09184", "48.06489", "11.66327", "Europe/Berlin"),
("2855937", "Ottobeuren", "", "DE", "276", "", "02", "097", "09778", "47.9413", "10.29971", "Europe/Berlin"),
("2855984", "Ottersweier", "", "DE", "276", "", "01", "082", "08216", "48.67022", "8.11323", "Europe/Berlin"),
("2856014", "Ottersberg", "", "DE", "276", "", "06", "00", "03361", "53.1099", "9.14408", "Europe/Berlin"),
("2856024", "Otterndorf", "", "DE", "276", "", "06", "00", "03352", "53.80908", "8.90068", "Europe/Berlin"),
("2856042", "Otterberg", "", "DE", "276", "", "08", "00", "07335", "49.50301", "7.76995", "Europe/Berlin"),
("2856107", "Ottendorf-Okrilla", "", "DE", "276", "", "13", "00", "14625", "51.18333", "13.83333", "Europe/Berlin"),
("2856184", "Oststeinbek", "", "DE", "276", "", "10", "00", "01062", "53.55", "10.16667", "Europe/Berlin"),
("2856193", "Ostseebad Kühlungsborn", "", "DE", "276", "", "12", "00", "13072", "54.15035", "11.75994", "Europe/Berlin"),
("2856198", "Ostseebad Binz", "", "DE", "276", "", "12", "00", "13073", "54.39995", "13.61052", "Europe/Berlin"),
("2856207", "Östringen", "", "DE", "276", "", "01", "082", "08215", "49.21911", "8.71192", "Europe/Berlin"),
("2856213", "Ostrhauderfehn", "", "DE", "276", "", "06", "00", "03457", "53.13333", "7.61667", "Europe/Berlin"),
("2856222", "Ostrach", "", "DE", "276", "", "01", "084", "08437", "47.95", "9.38333", "Europe/Berlin"),
("2856278", "Osthofen", "", "DE", "276", "", "08", "00", "07331", "49.70382", "8.32419", "Europe/Berlin"),
("2856288", "Ostheim", "", "DE", "276", "", "07", "053", "05315", "50.93117", "7.04412", "Europe/Berlin"),
("2856390", "Osterrönfeld", "", "DE", "276", "", "10", "00", "01058", "54.29013", "9.699", "Europe/Berlin"),
("2856500", "Osterholz-Scharmbeck", "Остерхольц-Шармбек", "DE", "276", "", "06", "00", "03356", "53.22698", "8.79528", "Europe/Berlin"),
("2856530", "Osterhofen", "", "DE", "276", "", "02", "092", "09271", "48.7", "13.02221", "Europe/Berlin"),
("2856629", "Ostercappeln", "", "DE", "276", "", "06", "00", "03459", "52.35", "8.23333", "Europe/Berlin"),
("2856637", "Osterburken", "", "DE", "276", "", "01", "082", "08225", "49.42997", "9.42252", "Europe/Berlin"),
("2856639", "Osterburg", "", "DE", "276", "", "14", "00", "15090", "52.78721", "11.75297", "Europe/Berlin"),
("2856816", "Ostbevern", "", "DE", "276", "", "07", "055", "05570", "52.05", "7.85", "Europe/Berlin"),
("2856883", "Osnabrück", "Оснабрюк", "DE", "276", "", "06", "00", "03404", "52.27264", "8.0498", "Europe/Berlin"),
("2856930", "Oschersleben", "Ошерслебен", "DE", "276", "", "14", "00", "15083", "52.03039", "11.22898", "Europe/Berlin"),
("2856944", "Oschatz", "Ошац", "DE", "276", "", "13", "00", "14730", "51.30001", "13.10984", "Europe/Berlin"),
("2857011", "Ortenburg", "", "DE", "276", "", "02", "092", "09275", "48.54597", "13.2225", "Europe/Berlin"),
("2857012", "Ortenberg", "", "DE", "276", "", "05", "064", "06440", "50.35584", "9.05602", "Europe/Berlin"),
("2857075", "Oerlenbach", "", "DE", "276", "", "02", "096", "09672", "50.15", "10.13333", "Europe/Berlin"),
("2857129", "Oranienburg", "Ораниенбург", "DE", "276", "", "11", "00", "12065", "52.75577", "13.24197", "Europe/Berlin"),
("2857167", "Oppenheim", "", "DE", "276", "", "08", "00", "07339", "49.8547", "8.35974", "Europe/Berlin"),
("2857185", "Opladen", "Опладен", "DE", "276", "", "07", "053", "05316", "51.05521", "7.01931", "Europe/Berlin"),
("2857291", "Olsberg", "Ольсберг", "DE", "276", "", "07", "059", "05958", "51.35613", "8.48899", "Europe/Berlin"),
("2857306", "Olpe", "Ольпе", "DE", "276", "", "07", "059", "05966", "51.02899", "7.85139", "Europe/Berlin"),
("2857363", "Olfen", "", "DE", "276", "", "07", "055", "05558", "51.70787", "7.37893", "Europe/Berlin"),
("2857451", "Oldenburg in Holstein", "", "DE", "276", "", "10", "00", "01055", "54.29576", "10.90156", "Europe/Berlin"),
("2857458", "Oldenburg", "Ольденбург", "DE", "276", "", "06", "00", "03403", "53.14118", "8.21467", "Europe/Berlin"),
("2857472", "Olching", "Ольхинг", "DE", "276", "", "02", "091", "09179", "48.2", "11.33333", "Europe/Berlin"),
("2857481", "Olbersdorf", "", "DE", "276", "", "13", "00", "14626", "50.87304", "14.77035", "Europe/Berlin"),
("2857484", "Olbernhau", "", "DE", "276", "", "13", "00", "14521", "50.6587", "13.3425", "Europe/Berlin"),
("2857565", "Öhringen", "Эринген", "DE", "276", "", "01", "081", "08126", "49.19884", "9.5072", "Europe/Berlin"),
("2857650", "Ohlsdorf", "", "DE", "276", "", "04", "00", "02000", "53.62594", "10.03145", "Europe/Berlin"),
("2857752", "Oftersheim", "", "DE", "276", "", "01", "082", "08226", "49.36528", "8.58306", "Europe/Berlin"),
("2857798", "Offenburg", "Оффенбург", "DE", "276", "", "01", "083", "08317", "48.47377", "7.94495", "Europe/Berlin"),
("2857803", "Offenbach an der Queich", "", "DE", "276", "", "08", "00", "07337", "49.20222", "8.18111", "Europe/Berlin"),
("2857807", "Offenbach", "", "DE", "276", "", "05", "064", "06413", "50.10061", "8.76647", "Europe/Berlin"),
("2857847", "Oettingen in Bayern", "", "DE", "276", "", "02", "097", "09779", "48.95274", "10.60465", "Europe/Berlin"),
("2857900", "Oerlinghausen", "Эрлингхаузен", "DE", "276", "", "07", "057", "05766", "51.95453", "8.6622", "Europe/Berlin"),
("2857904", "Oer-Erkenschwick", "Ор-Эркеншвик", "DE", "276", "", "07", "055", "05562", "51.64198", "7.26451", "Europe/Berlin"),
("2857918", "Oelsnitz", "", "DE", "276", "", "13", "00", "14521", "50.72584", "12.701", "Europe/Berlin"),
("2857919", "Oelsnitz", "", "DE", "276", "", "13", "00", "14523", "50.4147", "12.1695", "Europe/Berlin"),
("2857943", "Oelde", "Ольде", "DE", "276", "", "07", "055", "05570", "51.8289", "8.14724", "Europe/Berlin"),
("2857967", "Oedheim", "", "DE", "276", "", "01", "081", "08125", "49.24028", "9.25333", "Europe/Berlin"),
("2857970", "Oederan", "", "DE", "276", "", "13", "00", "14522", "50.86064", "13.17164", "Europe/Berlin"),
("2857985", "Oebisfelde", "", "DE", "276", "", "14", "00", "15083", "52.43421", "10.98786", "Europe/Berlin"),
("2858103", "Odenthal", "Оденталь", "DE", "276", "", "07", "053", "05378", "51.03333", "7.11667", "Europe/Berlin"),
("2858245", "Ochtrup", "Охтруп", "DE", "276", "", "07", "055", "05566", "52.20802", "7.18988", "Europe/Berlin"),
("2858253", "Ochtendung", "", "DE", "276", "", "08", "00", "07137", "50.35", "7.38333", "Europe/Berlin"),
("2858326", "Ochsenhausen", "", "DE", "276", "", "01", "084", "08426", "48.07029", "9.9503", "Europe/Berlin"),
("2858333", "Ochsenfurt", "", "DE", "276", "", "02", "096", "09679", "49.66429", "10.06227", "Europe/Berlin"),
("2858417", "Obrigheim", "", "DE", "276", "", "01", "082", "08225", "49.35194", "9.09083", "Europe/Berlin"),
("2858729", "Oberviechtach", "", "DE", "276", "", "02", "093", "09376", "49.45809", "12.41669", "Europe/Berlin"),
("2858738", "Oberursel", "", "DE", "276", "", "05", "064", "06434", "50.20731", "8.57747", "Europe/Berlin"),
("2858763", "Obertshausen", "Обертсхаузен", "DE", "276", "", "05", "064", "06438", "50.07139", "8.85123", "Europe/Berlin"),
("2858773", "Obertraubling", "", "DE", "276", "", "02", "093", "09375", "48.96667", "12.16667", "Europe/Berlin"),
("2858787", "Oberthulba", "", "DE", "276", "", "02", "096", "09672", "50.19904", "9.95882", "Europe/Berlin"),
("2858807", "Oberthal", "", "DE", "276", "", "09", "00", "10046", "49.51667", "7.1", "Europe/Berlin"),
("2858906", "Oberstenfeld", "", "DE", "276", "", "01", "081", "08118", "49.02611", "9.32083", "Europe/Berlin"),
("2858964", "Oberstdorf", "", "DE", "276", "", "02", "097", "09780", "47.40724", "10.27939", "Europe/Berlin"),
("2858966", "Oberstaufen", "", "DE", "276", "", "02", "097", "09780", "47.55568", "10.02245", "Europe/Berlin"),
("2859103", "Oberschöneweide", "", "DE", "276", "DE", "16", "00", "11000", "52.46106", "13.52108", "Europe/Berlin"),
("2859147", "Oberschleißheim", "", "DE", "276", "", "02", "091", "09184", "48.25", "11.56667", "Europe/Berlin"),
("2859199", "Ober-Saulheim", "", "DE", "276", "", "08", "00", "07331", "49.86376", "8.13526", "Europe/Berlin"),
("2859380", "Ober-Ramstadt", "Обер-Рамштадт", "DE", "276", "", "05", "064", "06432", "49.83078", "8.74887", "Europe/Berlin"),
("2859532", "Obernkirchen", "", "DE", "276", "", "06", "00", "03257", "52.2721", "9.12912", "Europe/Berlin"),
("2859654", "Oberndorf", "", "DE", "276", "", "01", "083", "08325", "48.2905", "8.57221", "Europe/Berlin"),
("2859675", "Obernburg am Main", "", "DE", "276", "", "02", "096", "09676", "49.83577", "9.13101", "Europe/Berlin"),
("2859739", "Ober-Mörlen", "", "DE", "276", "", "05", "064", "06440", "50.3735", "8.69087", "Europe/Berlin"),
("2859843", "Oberlungwitz", "", "DE", "276", "", "13", "00", "14524", "50.7823", "12.70789", "Europe/Berlin"),
("2860021", "Oberkotzau", "", "DE", "276", "", "02", "094", "09475", "50.26236", "11.93484", "Europe/Berlin"),
("2860049", "Oberkochen", "", "DE", "276", "", "01", "081", "08136", "48.78379", "10.10519", "Europe/Berlin"),
("2860080", "Oberkirch", "Оберкирх", "DE", "276", "", "01", "083", "08317", "48.53241", "8.07864", "Europe/Berlin"),
("2860400", "Oberhausen-Rheinhausen", "", "DE", "276", "", "01", "082", "08215", "49.27389", "8.47167", "Europe/Berlin"),
("2860410", "Oberhausen", "Оберхаузен", "DE", "276", "", "07", "051", "05119", "51.47311", "6.88074", "Europe/Berlin"),
("2860525", "Oberhaching", "", "DE", "276", "", "02", "091", "09184", "48.02455", "11.59744", "Europe/Berlin"),
("2860540", "Obergünzburg", "", "DE", "276", "", "02", "097", "09777", "47.84545", "10.41821", "Europe/Berlin"),
("2861096", "Oberding", "", "DE", "276", "", "02", "091", "09177", "48.31667", "11.85", "Europe/Berlin"),
("2861116", "Oberderdingen", "", "DE", "276", "", "01", "082", "08215", "49.06556", "8.80306", "Europe/Berlin"),
("2861232", "Oberboihingen", "", "DE", "276", "", "01", "081", "08116", "48.65", "9.36667", "Europe/Berlin"),
("2861402", "Oberasbach", "", "DE", "276", "", "02", "095", "09573", "49.42275", "10.95766", "Europe/Berlin"),
("2861422", "Oberammergau", "", "DE", "276", "", "02", "091", "09180", "47.59812", "11.06692", "Europe/Berlin"),
("2861579", "Nußloch", "", "DE", "276", "", "01", "082", "08226", "49.32389", "8.69556", "Europe/Berlin"),
("2861632", "Nürtingen", "Нюртинген", "DE", "276", "", "01", "081", "08116", "48.62565", "9.34203", "Europe/Berlin"),
("2861650", "Nürnberg", "Нюрнберг", "DE", "276", "", "02", "095", "09564", "49.45421", "11.07752", "Europe/Berlin"),
("2861671", "Nünchritz", "", "DE", "276", "", "13", "00", "14627", "51.29993", "13.38555", "Europe/Berlin"),
("2861677", "Nümbrecht", "Нюмбрехт", "DE", "276", "", "07", "053", "05374", "50.9", "7.55", "Europe/Berlin"),
("2861690", "Nufringen", "", "DE", "276", "", "01", "081", "08115", "48.62253", "8.89009", "Europe/Berlin"),
("2861733", "Nottuln", "Ноттульн", "DE", "276", "", "07", "055", "05558", "51.93333", "7.35", "Europe/Berlin"),
("2861788", "Nossen", "", "DE", "276", "", "13", "00", "14627", "51.05798", "13.29652", "Europe/Berlin"),
("2861801", "Nörvenich", "", "DE", "276", "", "07", "053", "05358", "50.80604", "6.63952", "Europe/Berlin"),
("2861804", "Nortorf", "", "DE", "276", "", "10", "00", "01058", "54.16738", "9.85437", "Europe/Berlin"),
("2861814", "Northeim", "Нортхайм", "DE", "276", "", "06", "00", "03155", "51.70662", "9.99997", "Europe/Berlin"),
("2861817", "Nörten-Hardenberg", "", "DE", "276", "", "06", "00", "03155", "51.62878", "9.93593", "Europe/Berlin"),
("2861847", "Nordwalde", "", "DE", "276", "", "07", "055", "05566", "52.08333", "7.48333", "Europe/Berlin"),
("2861866", "Nordstemmen", "", "DE", "276", "", "06", "00", "03254", "52.16196", "9.7835", "Europe/Berlin"),
("2861914", "Nördlingen", "Нёрдлинген", "DE", "276", "", "02", "097", "09779", "48.85122", "10.48868", "Europe/Berlin"),
("2861923", "Nordkirchen", "", "DE", "276", "", "07", "055", "05558", "51.73333", "7.53333", "Europe/Berlin"),
("2861934", "Nordhorn", "Нордхорн", "DE", "276", "", "06", "00", "03456", "52.43081", "7.06833", "Europe/Berlin"),
("2861939", "Nordholz", "", "DE", "276", "", "06", "00", "03352", "53.78333", "8.6", "Europe/Berlin"),
("2861973", "Nordheim", "", "DE", "276", "", "01", "081", "08125", "49.10861", "9.12778", "Europe/Berlin"),
("2861982", "Nordhausen", "Нордхаузен", "DE", "276", "", "15", "00", "16062", "51.5018", "10.7957", "Europe/Berlin"),
("2862026", "Norderstedt", "Нордерштедт", "DE", "276", "", "10", "00", "01060", "53.6859", "9.98041", "Europe/Berlin"),
("2862041", "Norderney", "", "DE", "276", "", "06", "00", "03452", "53.70828", "7.15819", "Europe/Berlin"),
("2862104", "Nordenham", "Норденхаме", "DE", "276", "", "06", "00", "03461", "53.4861", "8.48093", "Europe/Berlin"),
("2862118", "Norden", "Норден", "DE", "276", "", "06", "00", "03452", "53.59552", "7.20639", "Europe/Berlin"),
("2862174", "Nonnweiler", "", "DE", "276", "", "09", "00", "10046", "49.61667", "6.95", "Europe/Berlin"),
("2862294", "Nohfelden", "", "DE", "276", "", "09", "00", "10046", "49.58693", "7.14283", "Europe/Berlin"),
("2862347", "Nittendorf", "", "DE", "276", "", "02", "093", "09375", "49.02459", "11.96126", "Europe/Berlin"),
("2862348", "Nittenau", "", "DE", "276", "", "02", "093", "09376", "49.19425", "12.26741", "Europe/Berlin"),
("2862375", "Nippes", "", "DE", "276", "", "07", "053", "05315", "50.96545", "6.95314", "Europe/Berlin"),
("2862423", "Nikolassee", "", "DE", "276", "", "16", "00", "11000", "52.4344", "13.20095", "Europe/Berlin"),
("2862460", "Niesky", "", "DE", "276", "", "13", "00", "14626", "51.29241", "14.82107", "Europe/Berlin"),
("2862485", "Nierstein", "", "DE", "276", "", "08", "00", "07339", "49.87528", "8.34667", "Europe/Berlin"),
("2862620", "Nienburg", "Нинбург", "DE", "276", "", "06", "00", "03256", "52.6461", "9.22086", "Europe/Berlin"),
("2862675", "Nieheim", "", "DE", "276", "", "07", "057", "05762", "51.80499", "9.11302", "Europe/Berlin"),
("2862698", "Niederzier", "", "DE", "276", "", "07", "053", "05358", "50.88333", "6.46667", "Europe/Berlin"),
("2862724", "Niederwiesa", "", "DE", "276", "", "13", "00", "14522", "50.86667", "13.01667", "Europe/Berlin"),
("2862733", "Niederwerrn", "", "DE", "276", "", "02", "096", "09678", "50.06149", "10.1827", "Europe/Berlin"),
("2862831", "Niederstetten", "", "DE", "276", "", "01", "081", "08128", "49.4", "9.91944", "Europe/Berlin"),
("2862888", "Niederschönhausen", "Нидершёнхаузен", "DE", "276", "DE", "16", "00", "11000", "52.58483", "13.40272", "Europe/Berlin"),
("2862890", "Niederschöneweide", "", "DE", "276", "", "16", "00", "11000", "52.45564", "13.51554", "Europe/Berlin"),
("2863014", "Nieder-Olm", "", "DE", "276", "", "08", "00", "07339", "49.91166", "8.20533", "Europe/Berlin"),
("2863046", "Niedernhausen", "", "DE", "276", "", "05", "064", "06439", "50.15", "8.31667", "Europe/Berlin"),
("2863199", "Niederkrüchten", "", "DE", "276", "", "07", "051", "05166", "51.2", "6.21667", "Europe/Berlin"),
("2863223", "Niederkassel", "Нидеркассель", "DE", "276", "", "07", "053", "05382", "50.81503", "7.03777", "Europe/Berlin"),
("2863240", "Nieder-Ingelheim", "", "DE", "276", "", "08", "00", "07339", "49.97756", "8.07246", "Europe/Berlin"),
("2863401", "Niedergörsdorf", "", "DE", "276", "", "11", "00", "12072", "51.97943", "12.98541", "Europe/Berlin"),
("2863441", "Niederfischbach", "", "DE", "276", "", "08", "00", "07132", "50.85", "7.86667", "Europe/Berlin"),
("2863457", "Niedereschach", "", "DE", "276", "", "01", "083", "08326", "48.13333", "8.53333", "Europe/Berlin"),
("2863638", "Niederaula", "", "DE", "276", "", "05", "066", "06632", "50.8", "9.6", "Europe/Berlin"),
("2863652", "Aschau im Chiemgau", "", "DE", "276", "", "02", "091", "09187", "47.77689", "12.32297", "Europe/Berlin"),
("2863685", "Niedenstein", "", "DE", "276", "", "05", "066", "06634", "51.23342", "9.31029", "Europe/Berlin"),
("2863696", "Niebüll", "", "DE", "276", "", "10", "00", "01054", "54.78663", "8.82854", "Europe/Berlin"),
("2863711", "Nideggen", "", "DE", "276", "", "07", "053", "05358", "50.69268", "6.48437", "Europe/Berlin"),
("2863712", "Nidderau", "Ниддерау", "DE", "276", "", "05", "064", "06435", "50.23805", "8.86704", "Europe/Berlin"),
("2863716", "Nidda", "Нидда", "DE", "276", "", "05", "064", "06440", "50.4133", "9.00638", "Europe/Berlin"),
("2863795", "Neu Wulmstorf", "", "DE", "276", "", "06", "00", "03353", "53.46667", "9.8", "Europe/Berlin"),
("2863840", "Neuwied", "Нойвид", "DE", "276", "", "08", "00", "07138", "50.4336", "7.47057", "Europe/Berlin"),
("2863941", "Neu-Ulm", "Ной-Ульм", "DE", "276", "", "02", "097", "09775", "48.39279", "10.01112", "Europe/Berlin"),
("2863953", "Neutraubling", "", "DE", "276", "", "02", "093", "09375", "48.98737", "12.201", "Europe/Berlin"),
("2864005", "Neustrelitz", "Нойштрелице", "DE", "276", "", "12", "00", "13071", "53.3613", "13.07292", "Europe/Berlin"),
("2864034", "Neustadt in Holstein", "Нойштадт", "DE", "276", "", "10", "00", "01055", "54.10707", "10.8145", "Europe/Berlin"),
("2864036", "Neustadt-Glewe", "", "DE", "276", "", "12", "00", "13076", "53.37846", "11.59264", "Europe/Berlin"),
("2864053", "Neustadt bei Coburg", "Нойштадт-Кобург", "DE", "276", "", "02", "094", "09473", "50.32975", "11.12058", "Europe/Berlin"),
("2864054", "Neustadt", "Нойштадт-ан-дер-Вайнштрассе", "DE", "276", "", "08", "00", "07316", "49.35009", "8.13886", "Europe/Berlin"),
("2864055", "Neustadt an der Waldnaab", "", "DE", "276", "", "02", "093", "09374", "49.73287", "12.17773", "Europe/Berlin"),
("2864056", "Neustadt an der Donau", "", "DE", "276", "", "02", "092", "09273", "48.80705", "11.76952", "Europe/Berlin"),
("2864057", "Neustadt an der Aisch", "", "DE", "276", "", "02", "095", "09575", "49.57953", "10.61126", "Europe/Berlin"),
("2864058", "Neustadt am Rübenberge", "Нойштадт-ам-Рюбенберге", "DE", "276", "", "06", "00", "03241", "52.50462", "9.45871", "Europe/Berlin"),
("2864067", "Neustadt", "", "DE", "276", "", "04", "00", "02000", "53.55196", "9.98558", "Europe/Berlin"),
("2864072", "Neue Neustadt", "Нойштадт", "DE", "276", "", "14", "00", "15003", "52.15", "11.63333", "Europe/Berlin"),
("2864089", "Neustadt in Sachsen", "", "DE", "276", "", "13", "00", "14628", "51.02844", "14.21785", "Europe/Berlin"),
("2864091", "Neustadt (Hessen)", "", "DE", "276", "", "05", "065", "06534", "50.85", "9.11667", "Europe/Berlin"),
("2864118", "Neuss", "Нойс", "DE", "276", "", "07", "051", "05162", "51.19807", "6.68504", "Europe/Berlin"),
("2864276", "Neuruppin", "Нойруппин", "DE", "276", "", "11", "00", "12068", "52.92815", "12.80311", "Europe/Berlin"),
("2864303", "Neuried", "", "DE", "276", "", "02", "091", "09184", "48.09322", "11.46561", "Europe/Berlin"),
("2864387", "Neuötting", "", "DE", "276", "", "02", "091", "09171", "48.24102", "12.68998", "Europe/Berlin"),
("2864422", "Neunkirchen am Main", "", "DE", "276", "", "02", "094", "09472", "49.923", "11.64793", "Europe/Berlin"),
("2864425", "Neunkirchen", "", "DE", "276", "", "07", "059", "05970", "50.8", "8", "Europe/Berlin"),
("2864435", "Neunkirchen", "Нойнкирхен", "DE", "276", "", "09", "00", "10043", "49.34449", "7.18045", "Europe/Berlin"),
("2864468", "Neunburg vorm Wald", "", "DE", "276", "", "02", "093", "09376", "49.34782", "12.38621", "Europe/Berlin"),
("2864475", "Neumünster", "Ноймюнстер", "DE", "276", "", "10", "00", "01004", "54.07477", "9.98195", "Europe/Berlin"),
("2864547", "Neumarkt-Sankt Veit", "", "DE", "276", "", "02", "091", "09183", "48.36051", "12.50723", "Europe/Berlin"),
("2864549", "Neumarkt in der Oberpfalz", "Ноймаркт", "DE", "276", "", "02", "093", "09373", "49.28028", "11.46278", "Europe/Berlin"),
("2864577", "Neulußheim", "", "DE", "276", "", "01", "082", "08226", "49.29806", "8.51833", "Europe/Berlin"),
("2864748", "Neukirchen", "", "DE", "276", "", "05", "066", "06634", "50.86906", "9.34655", "Europe/Berlin"),
("2864750", "Neukirchen", "", "DE", "276", "", "13", "00", "14521", "50.77955", "12.86755", "Europe/Berlin"),
("2864771", "Neukirch/Lausitz", "", "DE", "276", "", "13", "00", "14625", "51.09727", "14.30789", "Europe/Berlin"),
("2864820", "Neu Isenburg", "Ной-Изенбург", "DE", "276", "", "05", "064", "06438", "50.04832", "8.69406", "Europe/Berlin"),
("2864869", "Neuhofen", "", "DE", "276", "", "08", "00", "07338", "49.42778", "8.42472", "Europe/Berlin"),
("2864936", "Neuhof", "", "DE", "276", "", "05", "066", "06631", "50.45313", "9.6175", "Europe/Berlin"),
("2865086", "Neuhausen auf den Fildern", "", "DE", "276", "", "01", "081", "08116", "48.68333", "9.28333", "Europe/Berlin"),
("2865104", "Neuhausen", "", "DE", "276", "", "01", "082", "08236", "48.8", "8.78333", "Europe/Berlin"),
("2865133", "Neuhaus am Rennweg", "", "DE", "276", "", "15", "00", "16072", "50.51006", "11.13787", "Europe/Berlin"),
("2865155", "Neuhaus", "", "DE", "276", "", "15", "00", "16070", "50.68333", "10.93333", "Europe/Berlin"),
("2865293", "Neugersdorf", "", "DE", "276", "", "13", "00", "14626", "50.97729", "14.60881", "Europe/Berlin"),
("2865341", "Neuffen", "", "DE", "276", "", "01", "081", "08116", "48.5546", "9.3755", "Europe/Berlin"),
("2865376", "Neufahrn bei Freising", "", "DE", "276", "", "02", "091", "09178", "48.31588", "11.66316", "Europe/Berlin"),
("2865557", "Neuenstein", "", "DE", "276", "", "01", "081", "08126", "49.2049", "9.58", "Europe/Berlin"),
("2865560", "Neuenstadt am Kocher", "", "DE", "276", "", "01", "081", "08125", "49.23498", "9.33215", "Europe/Berlin"),
("2865592", "Neuenrade", "", "DE", "276", "", "07", "059", "05962", "51.28278", "7.7825", "Europe/Berlin"),
("2865637", "Neuenkirchen", "", "DE", "276", "", "06", "00", "03358", "53.03259", "9.70642", "Europe/Berlin"),
("2865641", "Neuenkirchen", "", "DE", "276", "", "07", "055", "05566", "52.24472", "7.37183", "Europe/Berlin"),
("2865716", "Neuenhagen", "", "DE", "276", "", "11", "00", "12064", "52.52985", "13.68914", "Europe/Berlin"),
("2865798", "Neuendettelsau", "", "DE", "276", "", "02", "095", "09571", "49.28333", "10.78333", "Europe/Berlin"),
("2865812", "Neuenbürg", "", "DE", "276", "", "01", "082", "08236", "48.84516", "8.59574", "Europe/Berlin"),
("2865813", "Neuenburg am Rhein", "", "DE", "276", "", "01", "083", "08315", "47.81431", "7.56005", "Europe/Berlin"),
("2866022", "Neudenau", "", "DE", "276", "", "01", "081", "08125", "49.29181", "9.26975", "Europe/Berlin"),
("2866070", "Neuburg an der Donau", "Нойбург-ан-дер-Донау", "DE", "276", "", "02", "091", "09185", "48.73218", "11.18709", "Europe/Berlin"),
("2866086", "Neubulach", "", "DE", "276", "", "01", "082", "08235", "48.66092", "8.69611", "Europe/Berlin"),
("2866110", "Neubrück", "", "DE", "276", "", "07", "051", "05162", "51.13434", "6.63857", "Europe/Berlin"),
("2866135", "Neubrandenburg", "Нойбранденбурге", "DE", "276", "", "12", "00", "13071", "53.56414", "13.27532", "Europe/Berlin"),
("2866174", "Neubiberg", "", "DE", "276", "", "02", "091", "09184", "48.0771", "11.65812", "Europe/Berlin"),
("2866280", "Neu-Anspach", "Ной-Анспах", "DE", "276", "", "05", "064", "06434", "50.31667", "8.5", "Europe/Berlin"),
("2866333", "Nettetal", "Неттеталь", "DE", "276", "", "07", "051", "05166", "51.31667", "6.28333", "Europe/Berlin"),
("2866336", "Nettersheim", "", "DE", "276", "", "07", "053", "05366", "50.49372", "6.62896", "Europe/Berlin"),
("2866375", "Netphen", "Нетфен", "DE", "276", "", "07", "059", "05970", "50.91667", "8.1", "Europe/Berlin"),
("2866473", "Nersingen", "", "DE", "276", "", "02", "097", "09775", "48.42829", "10.12356", "Europe/Berlin"),
("2866486", "Neresheim", "", "DE", "276", "", "01", "081", "08136", "48.75511", "10.33041", "Europe/Berlin"),
("2866755", "Neckartenzlingen", "", "DE", "276", "", "01", "081", "08116", "48.58981", "9.23478", "Europe/Berlin"),
("2866758", "Neckarsulm", "Неккарзульм", "DE", "276", "", "01", "081", "08125", "49.18912", "9.22527", "Europe/Berlin"),
("2866774", "Neckargemünd", "", "DE", "276", "", "01", "082", "08226", "49.38899", "8.7959", "Europe/Berlin"),
("2866861", "Naunhof", "", "DE", "276", "", "13", "00", "14729", "51.2777", "12.58827", "Europe/Berlin"),
("2866905", "Naumburg", "", "DE", "276", "", "05", "066", "06633", "51.24816", "9.16569", "Europe/Berlin"),
("2866906", "Naumburg", "Наумбург", "DE", "276", "", "14", "00", "15084", "51.14987", "11.80979", "Europe/Berlin"),
("2866930", "Nauen", "Науэн", "DE", "276", "", "11", "00", "12063", "52.60701", "12.87374", "Europe/Berlin"),
("2866942", "Nattheim", "", "DE", "276", "", "01", "081", "08135", "48.69963", "10.24209", "Europe/Berlin"),
("2867037", "Nassau", "", "DE", "276", "", "08", "00", "07141", "50.31453", "7.80025", "Europe/Berlin"),
("2867112", "Nandlstadt", "", "DE", "276", "", "02", "091", "09178", "48.53644", "11.8073", "Europe/Berlin"),
("2867120", "Namborn", "", "DE", "276", "", "09", "00", "10046", "49.51667", "7.13333", "Europe/Berlin"),
("2867127", "Nalbach", "", "DE", "276", "", "09", "00", "10044", "49.38333", "6.78333", "Europe/Berlin"),
("2867138", "Naila", "", "DE", "276", "", "02", "094", "09475", "50.33034", "11.70463", "Europe/Berlin"),
("2867164", "Nagold", "Нагольд", "DE", "276", "", "01", "082", "08235", "48.5498", "8.72366", "Europe/Berlin"),
("2867229", "Nackenheim", "", "DE", "276", "", "08", "00", "07339", "49.91528", "8.33889", "Europe/Berlin"),
("2867252", "Nachrodt-Wiblingwerde", "", "DE", "276", "", "07", "059", "05962", "51.31667", "7.61667", "Europe/Berlin"),
("2867262", "Nabburg", "", "DE", "276", "", "02", "093", "09376", "49.45347", "12.17996", "Europe/Berlin"),
("2867310", "Mutterstadt", "", "DE", "276", "", "08", "00", "07338", "49.44139", "8.35611", "Europe/Berlin"),
("2867335", "Mutlangen", "", "DE", "276", "", "01", "081", "08136", "48.82588", "9.79714", "Europe/Berlin"),
("2867431", "Murrhardt", "", "DE", "276", "", "01", "081", "08119", "48.98191", "9.57047", "Europe/Berlin"),
("2867436", "Murr", "", "DE", "276", "", "01", "081", "08118", "48.96207", "9.25924", "Europe/Berlin"),
("2867445", "Murnau am Staffelsee", "", "DE", "276", "", "02", "091", "09180", "47.68085", "11.20125", "Europe/Berlin"),
("2867467", "Murg", "", "DE", "276", "", "01", "083", "08337", "47.55492", "8.02182", "Europe/Berlin"),
("2867492", "Münzenberg", "", "DE", "276", "", "05", "064", "06440", "50.45346", "8.7743", "Europe/Berlin"),
("2867542", "Munster", "Мунстер", "DE", "276", "", "06", "00", "03358", "52.98569", "10.08756", "Europe/Berlin"),
("2867543", "Münster", "Мюнстер", "DE", "276", "", "07", "055", "05515", "51.96236", "7.62571", "Europe/Berlin"),
("2867548", "Münster", "", "DE", "276", "", "05", "064", "06432", "49.92278", "8.86778", "Europe/Berlin"),
("2867560", "Münsingen", "", "DE", "276", "", "01", "084", "08415", "48.41126", "9.49704", "Europe/Berlin"),
("2867571", "Münnerstadt", "", "DE", "276", "", "02", "096", "09672", "50.24636", "10.20187", "Europe/Berlin"),
("2867608", "Munderkingen", "", "DE", "276", "", "01", "084", "08425", "48.23568", "9.64398", "Europe/Berlin"),
("2867613", "Hannoversch Münden", "", "DE", "276", "", "06", "00", "03152", "51.41505", "9.65046", "Europe/Berlin"),
("2867714", "Munich", "Мюнхен", "DE", "276", "", "02", "091", "09162", "48.13743", "11.57549", "Europe/Berlin"),
("2867723", "Müncheberg", "", "DE", "276", "", "11", "00", "12064", "52.50704", "14.13716", "Europe/Berlin"),
("2867726", "Münchberg", "", "DE", "276", "", "02", "094", "09475", "50.18952", "11.78823", "Europe/Berlin"),
("2867753", "Mülsen", "", "DE", "276", "", "13", "00", "14524", "50.75", "12.56667", "Europe/Berlin"),
("2867770", "Müllheim", "Мюльхайм", "DE", "276", "", "01", "083", "08315", "47.8082", "7.63035", "Europe/Berlin"),
("2867838", "Mülheim", "Мюльхайм-на-Руре", "DE", "276", "", "07", "051", "05117", "51.43218", "6.87967", "Europe/Berlin"),
("2867985", "Mühlheim am Main", "Мюльхайм-на-Майне", "DE", "276", "", "05", "064", "06438", "50.11667", "8.83333", "Europe/Berlin"),
("2867993", "Stuttgart Mühlhausen", "", "DE", "276", "DE", "01", "081", "08111", "48.84232", "9.23028", "Europe/Berlin"),
("2867996", "Mühlhausen", "Мюльхаузен", "DE", "276", "", "15", "00", "16064", "51.20896", "10.45275", "Europe/Berlin"),
("2868004", "Mühlhausen", "", "DE", "276", "", "01", "082", "08226", "49.24861", "8.72667", "Europe/Berlin"),
("2868506", "Mühldorf", "", "DE", "276", "", "02", "091", "09183", "48.2467", "12.52155", "Europe/Berlin"),
("2868788", "Mühlacker", "Мюлакер", "DE", "276", "", "01", "082", "08236", "48.94754", "8.83675", "Europe/Berlin"),
("2868807", "Muggensturm", "", "DE", "276", "", "01", "082", "08216", "48.86667", "8.28333", "Europe/Berlin"),
("2868837", "Müggelheim", "", "DE", "276", "DE", "16", "00", "11000", "52.41137", "13.66403", "Europe/Berlin"),
("2868853", "Mudersbach", "", "DE", "276", "", "08", "00", "07132", "50.81667", "7.95", "Europe/Berlin"),
("2868861", "Müden", "", "DE", "276", "", "06", "00", "03151", "52.52771", "10.36011", "Europe/Berlin"),
("2868867", "Mudau", "", "DE", "276", "", "01", "082", "08225", "49.53444", "9.20444", "Europe/Berlin"),
("2868933", "Mücheln", "", "DE", "276", "", "14", "00", "15088", "51.29688", "11.80759", "Europe/Berlin"),
("2868936", "Much", "", "DE", "276", "", "07", "053", "05382", "50.91667", "7.4", "Europe/Berlin"),
("2869019", "Mössingen", "Мёссинген", "DE", "276", "", "01", "084", "08416", "48.40567", "9.05419", "Europe/Berlin"),
("2869120", "Mosbach", "", "DE", "276", "", "01", "082", "08225", "49.35357", "9.15106", "Europe/Berlin"),
("2869196", "Morsbach", "", "DE", "276", "", "07", "053", "05374", "50.86667", "7.75", "Europe/Berlin"),
("2869221", "Mörlenbach", "", "DE", "276", "", "05", "064", "06431", "49.59917", "8.73472", "Europe/Berlin"),
("2869244", "Moritzburg", "", "DE", "276", "", "13", "00", "14627", "51.15922", "13.68021", "Europe/Berlin"),
("2869257", "Moringen", "", "DE", "276", "", "06", "00", "03155", "51.69915", "9.87107", "Europe/Berlin"),
("2869306", "Morbach", "", "DE", "276", "", "08", "00", "07231", "49.81667", "7.11667", "Europe/Berlin"),
("2869361", "Moosinning", "", "DE", "276", "", "02", "091", "09177", "48.27708", "11.84446", "Europe/Berlin"),
("2869449", "Moosburg", "", "DE", "276", "", "02", "091", "09178", "48.47089", "11.93811", "Europe/Berlin"),
("2869746", "Montabaur", "", "DE", "276", "", "08", "00", "07143", "50.43588", "7.8232", "Europe/Berlin"),
("2869756", "Monschau", "", "DE", "276", "", "07", "053", "05334", "50.55462", "6.24001", "Europe/Berlin"),
("2869791", "Monheim am Rhein", "", "DE", "276", "", "07", "051", "05158", "51.09162", "6.89217", "Europe/Berlin"),
("2869894", "Mönchengladbach", "Мёнхенгладбах", "DE", "276", "", "07", "051", "05116", "51.18539", "6.44172", "Europe/Berlin"),
("2869934", "Mömlingen", "", "DE", "276", "", "02", "096", "09676", "49.85972", "9.08333", "Europe/Berlin"),
("2869936", "Mömbris", "", "DE", "276", "", "02", "096", "09671", "50.06921", "9.16371", "Europe/Berlin"),
("2869994", "Mölln", "Мёльн", "DE", "276", "", "10", "00", "01053", "53.61702", "10.68742", "Europe/Berlin"),
("2870094", "Molbergen", "", "DE", "276", "", "06", "00", "03453", "52.86667", "7.93333", "Europe/Berlin"),
("2870194", "Möglingen", "", "DE", "276", "", "01", "081", "08118", "48.88741", "9.12694", "Europe/Berlin"),
("2870221", "Moers", "Мерс", "DE", "276", "", "07", "051", "05170", "51.45342", "6.6326", "Europe/Berlin"),
("2870266", "Mockrehna", "", "DE", "276", "", "13", "00", "14730", "51.50757", "12.81418", "Europe/Berlin"),
("2870269", "Möckmühl", "", "DE", "276", "", "01", "081", "08125", "49.3249", "9.35837", "Europe/Berlin"),
("2870278", "Möckern", "", "DE", "276", "", "14", "00", "15086", "52.14099", "11.95203", "Europe/Berlin"),
("2870310", "Moabit", "Моабит", "DE", "276", "", "16", "00", "11000", "52.52635", "13.33903", "Europe/Berlin"),
("2870318", "Mittweida", "Митвайда", "DE", "276", "", "13", "00", "14522", "50.98622", "12.97537", "Europe/Berlin"),
("2870355", "Mitterteich", "", "DE", "276", "", "02", "093", "09377", "49.95141", "12.24206", "Europe/Berlin"),
("2870481", "Mittenwalde", "", "DE", "276", "", "11", "00", "12061", "52.26007", "13.53945", "Europe/Berlin"),
("2870482", "Mittenwald", "", "DE", "276", "", "02", "091", "09180", "47.4422", "11.26187", "Europe/Berlin"),
("2870490", "Mittenaar", "", "DE", "276", "", "05", "065", "06532", "50.7", "8.38333", "Europe/Berlin"),
("2870584", "Mittelschöntal", "", "DE", "276", "", "01", "081", "08119", "48.94615", "9.3952", "Europe/Berlin"),
("2870911", "Mittegroßefehn", "", "DE", "276", "", "06", "00", "03452", "53.39165", "7.56602", "Europe/Berlin"),
("2871039", "Minden", "Минден", "DE", "276", "", "07", "057", "05770", "52.28953", "8.91455", "Europe/Berlin"),
("2871045", "Mindelheim", "", "DE", "276", "", "02", "097", "09778", "48.04578", "10.49222", "Europe/Berlin"),
("2871079", "Miltenberg", "", "DE", "276", "", "02", "096", "09676", "49.70452", "9.26725", "Europe/Berlin"),
("2871198", "Miesbach", "", "DE", "276", "", "02", "091", "09182", "47.78903", "11.83382", "Europe/Berlin"),
("2871279", "Michendorf", "", "DE", "276", "", "11", "00", "12069", "52.31352", "13.02996", "Europe/Berlin"),
("2871284", "Michelstadt", "Михельштадт", "DE", "276", "", "05", "064", "06437", "49.67569", "9.00373", "Europe/Berlin"),
("2871367", "Michelau", "", "DE", "276", "", "02", "094", "09478", "50.16233", "11.11207", "Europe/Berlin"),
("2871437", "Meuselwitz", "", "DE", "276", "", "15", "00", "16077", "51.04315", "12.29935", "Europe/Berlin"),
("2871486", "Metzingen", "Метцинген", "DE", "276", "", "01", "084", "08415", "48.53695", "9.2833", "Europe/Berlin"),
("2871535", "Mettmann", "Меттман", "DE", "276", "", "07", "051", "05158", "51.2504", "6.97536", "Europe/Berlin"),
("2871540", "Mettingen", "", "DE", "276", "", "07", "055", "05566", "52.31667", "7.78333", "Europe/Berlin"),
("2871591", "Metelen", "", "DE", "276", "", "07", "055", "05566", "52.14434", "7.2127", "Europe/Berlin"),
("2871601", "Meßstetten", "", "DE", "276", "", "01", "084", "08417", "48.18317", "8.96565", "Europe/Berlin"),
("2871609", "Meßkirch", "", "DE", "276", "", "01", "084", "08437", "47.99457", "9.11479", "Europe/Berlin"),
("2871668", "Meschede", "Мешеде", "DE", "276", "", "07", "059", "05958", "51.3502", "8.28332", "Europe/Berlin"),
("2871675", "Merzig", "Мерциге", "DE", "276", "", "09", "00", "10042", "49.44331", "6.63874", "Europe/Berlin"),
("2871736", "Merseburg", "Мерзебург", "DE", "276", "", "14", "00", "15088", "51.35478", "11.98923", "Europe/Berlin"),
("2871813", "Mering", "", "DE", "276", "", "02", "097", "09771", "48.2656", "10.98461", "Europe/Berlin"),
("2871832", "Merchweiler", "", "DE", "276", "", "09", "00", "10043", "49.35", "7.05", "Europe/Berlin"),
("2871845", "Meppen", "Меппен", "DE", "276", "", "06", "00", "03454", "52.69064", "7.29097", "Europe/Berlin"),
("2871950", "Mengkofen", "", "DE", "276", "", "02", "092", "09279", "48.71894", "12.44047", "Europe/Berlin"),
("2871953", "Mengerskirchen", "", "DE", "276", "", "05", "065", "06533", "50.56392", "8.15555", "Europe/Berlin"),
("2871963", "Mengenich", "", "DE", "276", "", "07", "053", "05315", "50.9785", "6.86737", "Europe/Berlin"),
("2871964", "Mengen", "", "DE", "276", "", "01", "084", "08437", "48.04951", "9.33005", "Europe/Berlin"),
("2871979", "Mendig", "", "DE", "276", "", "08", "00", "07137", "50.36667", "7.28333", "Europe/Berlin"),
("2871983", "Menden", "Менден", "DE", "276", "", "07", "059", "05962", "51.44337", "7.77825", "Europe/Berlin"),
("2871992", "Memmingen", "Мемминген", "DE", "276", "", "02", "097", "09764", "47.98372", "10.18527", "Europe/Berlin"),
("2872003", "Memmelsdorf", "", "DE", "276", "", "02", "094", "09471", "49.93012", "10.95921", "Europe/Berlin"),
("2872028", "Melsungen", "", "DE", "276", "", "05", "066", "06634", "51.13029", "9.55236", "Europe/Berlin"),
("2872047", "Mellrichstadt", "", "DE", "276", "", "02", "096", "09673", "50.42849", "10.30334", "Europe/Berlin"),
("2872079", "Melle", "Мелле", "DE", "276", "", "06", "00", "03459", "52.20197", "8.33826", "Europe/Berlin"),
("2872100", "Meldorf", "", "DE", "276", "", "10", "00", "01051", "54.09182", "9.0687", "Europe/Berlin"),
("2872126", "Meitingen", "", "DE", "276", "", "02", "097", "09772", "48.54586", "10.85179", "Europe/Berlin"),
("2872155", "Meissen", "Мейсен", "DE", "276", "", "13", "00", "14627", "51.16158", "13.4737", "Europe/Berlin"),
("2872225", "Meiningen", "Майнинген", "DE", "276", "", "15", "00", "16066", "50.56787", "10.41521", "Europe/Berlin"),
("2872237", "Meinerzhagen", "Майнерцхаген", "DE", "276", "", "07", "059", "05962", "51.1074", "7.64838", "Europe/Berlin"),
("2872244", "Meinersen", "", "DE", "276", "", "06", "00", "03151", "52.47436", "10.35247", "Europe/Berlin"),
("2872347", "Meiderich", "", "DE", "276", "", "07", "051", "05112", "51.46667", "6.76667", "Europe/Berlin"),
("2872380", "Mehrhoog", "", "DE", "276", "", "07", "051", "05170", "51.73826", "6.51164", "Europe/Berlin"),
("2872486", "Meersburg", "", "DE", "276", "", "01", "084", "08435", "47.69419", "9.27113", "Europe/Berlin"),
("2872504", "Meerbusch", "Мербуш", "DE", "276", "", "07", "051", "05162", "51.26118", "6.6717", "Europe/Berlin"),
("2872519", "Meerane", "Меране", "DE", "276", "", "13", "00", "14524", "50.84688", "12.46473", "Europe/Berlin"),
("2872557", "Medebach", "", "DE", "276", "", "07", "059", "05958", "51.19713", "8.70635", "Europe/Berlin"),
("2872580", "Meckesheim", "", "DE", "276", "", "01", "082", "08226", "49.32167", "8.81944", "Europe/Berlin"),
("2872582", "Meckenheim", "Меккенхайм", "DE", "276", "", "07", "053", "05382", "50.62388", "7.02942", "Europe/Berlin"),
("2872585", "Meckenbeuren", "", "DE", "276", "", "01", "084", "08435", "47.7", "9.56667", "Europe/Berlin"),
("2872611", "Mechernich", "Мехерних", "DE", "276", "", "07", "053", "05366", "50.59304", "6.65224", "Europe/Berlin"),
("2872649", "Mayen", "Майен", "DE", "276", "", "08", "00", "07137", "50.32797", "7.22277", "Europe/Berlin"),
("2872670", "Maxhütte-Haidhof", "", "DE", "276", "", "02", "093", "09376", "49.19963", "12.09229", "Europe/Berlin"),
("2872686", "Maxdorf", "", "DE", "276", "", "08", "00", "07338", "49.48806", "8.29167", "Europe/Berlin"),
("2872777", "Maulbronn", "", "DE", "276", "", "01", "082", "08236", "48.99958", "8.80337", "Europe/Berlin"),
("2873074", "Marzahn", "", "DE", "276", "", "16", "00", "11000", "52.54525", "13.56983", "Europe/Berlin"),
("2873211", "Marsberg", "Марсберг", "DE", "276", "", "07", "059", "05958", "51.46171", "8.84949", "Europe/Berlin"),
("2873224", "Marpingen", "", "DE", "276", "", "09", "00", "10046", "49.45228", "7.0582", "Europe/Berlin"),
("2873263", "Marl", "Марль", "DE", "276", "", "07", "055", "05562", "51.65671", "7.09038", "Europe/Berlin"),
("2873285", "Markt Schwaben", "", "DE", "276", "", "02", "091", "09175", "48.18949", "11.8691", "Europe/Berlin"),
("2873289", "Marktredwitz", "Марктредвиц", "DE", "276", "", "02", "094", "09479", "50.00443", "12.08593", "Europe/Berlin"),
("2873291", "Marktoberdorf", "Марктобердорф", "DE", "276", "", "02", "097", "09777", "47.77964", "10.61713", "Europe/Berlin"),
("2873300", "Markt Indersdorf", "", "DE", "276", "", "02", "091", "09174", "48.36058", "11.37789", "Europe/Berlin"),
("2873301", "Marktheidenfeld", "", "DE", "276", "", "02", "096", "09677", "49.8454", "9.60359", "Europe/Berlin"),
("2873304", "Markt Erlbach", "", "DE", "276", "", "02", "095", "09575", "49.49367", "10.65265", "Europe/Berlin"),
("2873331", "Markranstädt", "", "DE", "276", "", "13", "00", "14729", "51.30146", "12.2202", "Europe/Berlin"),
("2873340", "Markneukirchen", "", "DE", "276", "", "13", "00", "14523", "50.31144", "12.32951", "Europe/Berlin"),
("2873352", "Markkleeberg", "", "DE", "276", "", "13", "00", "14729", "51.2755", "12.36906", "Europe/Berlin"),
("2873356", "Märkisches Viertel", "", "DE", "276", "", "16", "00", "11000", "52.59841", "13.35766", "Europe/Berlin"),
("2873369", "Markgröningen", "", "DE", "276", "", "01", "081", "08118", "48.90493", "9.08059", "Europe/Berlin"),
("2873427", "Markdorf", "", "DE", "276", "", "01", "084", "08435", "47.71916", "9.39028", "Europe/Berlin"),
("2873574", "Marienheide", "", "DE", "276", "", "07", "053", "05374", "51.08317", "7.53087", "Europe/Berlin"),
("2873589", "Marienfelde", "", "DE", "276", "", "16", "00", "11000", "52.41868", "13.36723", "Europe/Berlin"),
("2873606", "Mariendorf", "Мариендорф", "DE", "276", "", "16", "00", "11000", "52.4378", "13.38109", "Europe/Berlin"),
("2873632", "Marienberg", "", "DE", "276", "", "13", "00", "14521", "50.65051", "13.16122", "Europe/Berlin"),
("2873759", "Marburg an der Lahn", "Марбург", "DE", "276", "", "05", "065", "06534", "50.80904", "8.77069", "Europe/Berlin"),
("2873776", "Marbach am Neckar", "Марбах-на-Неккаре", "DE", "276", "", "01", "081", "08118", "48.93964", "9.25995", "Europe/Berlin"),
("2873891", "Mannheim", "Мангейм", "DE", "276", "", "01", "082", "08222", "49.49671", "8.47955", "Europe/Berlin"),
("2873992", "Manching", "", "DE", "276", "", "02", "091", "09186", "48.71656", "11.49393", "Europe/Berlin"),
("2874048", "Malsch", "", "DE", "276", "", "01", "082", "08215", "48.88333", "8.33333", "Europe/Berlin"),
("2874111", "Malente", "", "DE", "276", "", "10", "00", "01055", "54.17226", "10.55968", "Europe/Berlin"),
("2874122", "Malchow", "", "DE", "276", "", "12", "00", "13071", "53.47477", "12.4221", "Europe/Berlin"),
("2874131", "Malchin", "", "DE", "276", "", "12", "00", "13071", "53.7399", "12.76539", "Europe/Berlin"),
("2874200", "Maisach", "", "DE", "276", "", "02", "091", "09179", "48.21667", "11.26667", "Europe/Berlin"),
("2874225", "Mainz", "Майнц", "DE", "276", "", "08", "00", "07315", "49.98419", "8.2791", "Europe/Berlin"),
("2874230", "Maintal", "Майнталь", "DE", "276", "", "05", "064", "06435", "50.15", "8.83333", "Europe/Berlin"),
("2874239", "Mainleus", "", "DE", "276", "", "02", "094", "09477", "50.09987", "11.37664", "Europe/Berlin"),
("2874246", "Mainhardt", "", "DE", "276", "", "01", "081", "08127", "49.07611", "9.55639", "Europe/Berlin"),
("2874252", "Mainburg", "", "DE", "276", "", "02", "092", "09273", "48.64182", "11.78093", "Europe/Berlin"),
("2874263", "Mainaschaff", "", "DE", "276", "", "02", "096", "09671", "49.98167", "9.09", "Europe/Berlin"),
("2874455", "Mahlsdorf", "", "DE", "276", "DE", "16", "00", "11000", "52.50935", "13.61373", "Europe/Berlin"),
("2874509", "Magstadt", "", "DE", "276", "", "01", "081", "08115", "48.73333", "8.96667", "Europe/Berlin"),
("2874545", "Magdeburg", "Магдебург", "DE", "276", "", "14", "00", "15003", "52.12773", "11.62916", "Europe/Berlin"),
("2874642", "Machern", "", "DE", "276", "", "13", "00", "14729", "51.36667", "12.63333", "Europe/Berlin"),
("2874768", "Lützelbach", "", "DE", "276", "", "05", "064", "06432", "49.74233", "8.76687", "Europe/Berlin"),
("2874919", "Lütjenburg", "", "DE", "276", "", "10", "00", "01057", "54.29188", "10.58945", "Europe/Berlin"),
("2875067", "Lunzenau", "", "DE", "276", "", "13", "00", "14522", "50.96269", "12.75594", "Europe/Berlin"),
("2875107", "Lünen", "Люнен", "DE", "276", "", "07", "059", "05978", "51.61634", "7.52872", "Europe/Berlin"),
("2875115", "Lüneburg", "Люнебург", "DE", "276", "", "06", "00", "03355", "53.2509", "10.41409", "Europe/Berlin"),
("2875282", "Lügde", "", "DE", "276", "", "07", "057", "05766", "51.95828", "9.24706", "Europe/Berlin"),
("2875286", "Lugau", "", "DE", "276", "", "13", "00", "14521", "50.73843", "12.74861", "Europe/Berlin"),
("2875343", "Ludwigslust", "", "DE", "276", "", "12", "00", "13076", "53.32917", "11.49714", "Europe/Berlin"),
("2875376", "Ludwigshafen am Rhein", "Людвигсхафен-на-Рейне", "DE", "276", "", "08", "00", "07314", "49.48121", "8.44641", "Europe/Berlin"),
("2875379", "Ludwigsfelde", "Людвигсфельде", "DE", "276", "", "11", "00", "12072", "52.30322", "13.25405", "Europe/Berlin"),
("2875392", "Ludwigsburg", "Людвигсбург", "DE", "276", "", "01", "081", "08118", "48.89731", "9.19161", "Europe/Berlin"),
("2875417", "Lüdinghausen", "Людингхаузен", "DE", "276", "", "07", "055", "05558", "51.7683", "7.44379", "Europe/Berlin"),
("2875457", "Lüdenscheid", "Люденшайд", "DE", "276", "", "07", "059", "05962", "51.21977", "7.6273", "Europe/Berlin"),
("2875484", "Luckenwalde", "Луккенвальде", "DE", "276", "", "11", "00", "12072", "52.09029", "13.16772", "Europe/Berlin"),
("2875509", "Luckau", "", "DE", "276", "", "11", "00", "12061", "51.85245", "13.70735", "Europe/Berlin"),
("2875542", "Lüchow", "", "DE", "276", "", "06", "00", "03354", "52.96811", "11.15397", "Europe/Berlin"),
("2875558", "Lübz", "", "DE", "276", "", "12", "00", "13076", "53.46261", "12.02917", "Europe/Berlin"),
("2875601", "Lübeck", "Любек", "DE", "276", "", "10", "00", "01003", "53.86893", "10.68729", "Europe/Berlin"),
("2875623", "Lübbenau", "Люббенау", "DE", "276", "", "11", "00", "12066", "51.86217", "13.95168", "Europe/Berlin"),
("2875625", "Lübben", "", "DE", "276", "", "11", "00", "12061", "51.93814", "13.88826", "Europe/Berlin"),
("2875626", "Lübbecke", "Люббекке", "DE", "276", "", "07", "057", "05770", "52.30699", "8.61423", "Europe/Berlin"),
("2875645", "Loxstedt", "Локсштедт", "DE", "276", "", "06", "00", "03352", "53.46667", "8.65", "Europe/Berlin"),
("2875760", "Lotte", "", "DE", "276", "", "07", "055", "05566", "52.28333", "7.91667", "Europe/Berlin"),
("2875799", "Lößnitz", "", "DE", "276", "", "13", "00", "14521", "50.62181", "12.73147", "Europe/Berlin"),
("2875815", "Loßburg", "", "DE", "276", "", "01", "082", "08237", "48.4", "8.45", "Europe/Berlin"),
("2875831", "Losheim", "", "DE", "276", "", "09", "00", "10042", "49.5099", "6.74549", "Europe/Berlin"),
("2875877", "Lorsch", "", "DE", "276", "", "05", "064", "06431", "49.65", "8.56667", "Europe/Berlin"),
("2875881", "Lörrach", "Лёррах", "DE", "276", "", "01", "083", "08336", "47.61497", "7.66457", "Europe/Berlin"),
("2875909", "Lorch", "", "DE", "276", "", "01", "081", "08136", "48.79833", "9.6914", "Europe/Berlin"),
("2875987", "Löningen", "", "DE", "276", "", "06", "00", "03453", "52.73678", "7.75809", "Europe/Berlin"),
("2876009", "Lommatzsch", "", "DE", "276", "", "13", "00", "14627", "51.19537", "13.30917", "Europe/Berlin"),
("2876027", "Lollar", "", "DE", "276", "", "05", "065", "06531", "50.64652", "8.70495", "Europe/Berlin"),
("2876144", "Lohra", "", "DE", "276", "", "05", "065", "06534", "50.73333", "8.63333", "Europe/Berlin"),
("2876147", "Lohr am Main", "Лор-на-Майне", "DE", "276", "", "02", "096", "09677", "49.98922", "9.57223", "Europe/Berlin"),
("2876185", "Lohne", "", "DE", "276", "", "06", "00", "03460", "52.66625", "8.2375", "Europe/Berlin"),
("2876186", "Lohne", "", "DE", "276", "", "06", "00", "03456", "52.49778", "7.22629", "Europe/Berlin"),
("2876187", "Löhne", "", "DE", "276", "", "07", "057", "05758", "52.18848", "8.6922", "Europe/Berlin"),
("2876218", "Lohmar", "Ломар", "DE", "276", "", "07", "053", "05382", "50.83868", "7.21399", "Europe/Berlin"),
("2876282", "Lohfelden", "", "DE", "276", "", "05", "066", "06633", "51.26667", "9.53333", "Europe/Berlin"),
("2876461", "Löffingen", "", "DE", "276", "", "01", "083", "08315", "47.88405", "8.34384", "Europe/Berlin"),
("2876604", "Löchgau", "", "DE", "276", "", "01", "081", "08118", "49.00361", "9.10639", "Europe/Berlin"),
("2876721", "Bad Lobenstein", "", "DE", "276", "", "15", "00", "16075", "50.45223", "11.6393", "Europe/Berlin"),
("2876755", "Löbau", "Лёбау", "DE", "276", "", "13", "00", "14626", "51.09954", "14.66738", "Europe/Berlin"),
("2876787", "Litzendorf", "", "DE", "276", "", "02", "094", "09471", "49.91444", "11.01028", "Europe/Berlin"),
("2876865", "Lippstadt", "Липпштадте", "DE", "276", "", "07", "059", "05974", "51.67369", "8.34482", "Europe/Berlin"),
("2876952", "Linz am Rhein", "", "DE", "276", "", "08", "00", "07138", "50.56884", "7.28445", "Europe/Berlin"),
("2877021", "Linnich", "", "DE", "276", "", "07", "053", "05358", "50.98002", "6.27049", "Europe/Berlin"),
("2877082", "Lingenfeld", "", "DE", "276", "", "08", "00", "07334", "49.25389", "8.33861", "Europe/Berlin"),
("2877088", "Lingen", "Линген", "DE", "276", "", "06", "00", "03454", "52.52143", "7.31845", "Europe/Berlin"),
("2877142", "Lindlar", "Линдлар", "DE", "276", "", "07", "053", "05374", "51.01959", "7.37758", "Europe/Berlin"),
("2877315", "Lindenfels", "", "DE", "276", "", "05", "064", "06431", "49.68369", "8.78151", "Europe/Berlin"),
("2877550", "Lindau", "Линдау", "DE", "276", "", "02", "097", "09776", "47.54612", "9.68431", "Europe/Berlin"),
("2877647", "Limburgerhof", "", "DE", "276", "", "08", "00", "07338", "49.42444", "8.39194", "Europe/Berlin"),
("2877648", "Limburg an der Lahn", "Лимбург-на-Лане", "DE", "276", "", "05", "065", "06533", "50.3836", "8.0503", "Europe/Berlin"),
("2877673", "Limbach-Oberfrohna", "Лимбах-Оберфрона", "DE", "276", "", "13", "00", "14524", "50.85882", "12.76165", "Europe/Berlin"),
("2877709", "Lilienthal", "Лилиенталь", "DE", "276", "", "06", "00", "03356", "53.13333", "8.91667", "Europe/Berlin"),
("2877843", "Lienen", "", "DE", "276", "", "07", "055", "05566", "52.15", "7.98333", "Europe/Berlin"),
("2877969", "Liebenburg", "", "DE", "276", "", "06", "00", "03153", "52.02176", "10.43169", "Europe/Berlin"),
("2878018", "Lichterfelde", "", "DE", "276", "DE", "16", "00", "11000", "52.4333", "13.30762", "Europe/Berlin"),
("2878027", "Lichtentanne", "", "DE", "276", "", "13", "00", "14524", "50.7", "12.43333", "Europe/Berlin"),
("2878037", "Lichtenstein", "", "DE", "276", "", "13", "00", "14524", "50.75659", "12.63025", "Europe/Berlin"),
("2878044", "Lichtenrade", "", "DE", "276", "", "16", "00", "11000", "52.39844", "13.40637", "Europe/Berlin"),
("2878074", "Lichtenfels", "Лихтенфельс", "DE", "276", "", "02", "094", "09478", "50.14567", "11.05928", "Europe/Berlin"),
("2878102", "Lichtenberg", "", "DE", "276", "", "16", "00", "11000", "52.51395", "13.49975", "Europe/Berlin"),
("2878133", "Lichtenau", "", "DE", "276", "", "07", "057", "05774", "51.61707", "8.89665", "Europe/Berlin"),
("2878140", "Lichtenau", "", "DE", "276", "", "01", "082", "08216", "48.72607", "8.00486", "Europe/Berlin"),
("2878166", "Lich", "", "DE", "276", "", "05", "065", "06531", "50.52085", "8.81567", "Europe/Berlin"),
("2878234", "Leverkusen", "Леверкузен", "DE", "276", "", "07", "053", "05316", "51.0303", "6.98432", "Europe/Berlin"),
("2878270", "Leutkirch im Allgäu", "Лойткирх", "DE", "276", "", "01", "084", "08436", "47.82672", "10.0205", "Europe/Berlin"),
("2878289", "Leutershausen", "", "DE", "276", "", "02", "095", "09571", "49.29869", "10.41189", "Europe/Berlin"),
("2878313", "Leutenbach", "", "DE", "276", "", "01", "081", "08119", "48.88791", "9.39267", "Europe/Berlin"),
("2878350", "Leuna", "", "DE", "276", "", "14", "00", "15088", "51.31783", "12.01589", "Europe/Berlin"),
("2878351", "Leun", "", "DE", "276", "", "05", "065", "06532", "50.55129", "8.35836", "Europe/Berlin"),
("2878673", "Leopoldshöhe", "Леопольдсхёэ", "DE", "276", "", "07", "057", "05766", "52.01246", "8.69834", "Europe/Berlin"),
("2878695", "Leonberg", "Леонберг", "DE", "276", "", "01", "081", "08115", "48.8", "9.01667", "Europe/Berlin"),
("2878702", "Lenzkirch", "", "DE", "276", "", "01", "083", "08315", "47.86832", "8.20211", "Europe/Berlin"),
("2878773", "Lensahn", "", "DE", "276", "", "10", "00", "01055", "54.23333", "10.88333", "Europe/Berlin"),
("2878784", "Lennestadt", "Леннештадт", "DE", "276", "", "07", "059", "05966", "51.11721", "8.06707", "Europe/Berlin"),
("2878824", "Lenggries", "", "DE", "276", "", "02", "091", "09173", "47.68333", "11.56667", "Europe/Berlin"),
("2878840", "Lengerich", "", "DE", "276", "", "07", "055", "05566", "52.18661", "7.86043", "Europe/Berlin"),
("2878852", "Lengenfeld", "", "DE", "276", "", "13", "00", "14523", "50.5694", "12.36408", "Europe/Berlin"),
("2878879", "Lengede", "", "DE", "276", "", "06", "00", "03157", "52.20487", "10.30775", "Europe/Berlin"),
("2878912", "Lemwerder", "", "DE", "276", "", "06", "00", "03461", "53.16667", "8.61667", "Europe/Berlin"),
("2878918", "Lemsahl-Mellingstedt", "", "DE", "276", "", "04", "00", "02000", "53.68998", "10.09648", "Europe/Berlin"),
("2878943", "Lemgo", "Лемго", "DE", "276", "", "07", "057", "05766", "52.02786", "8.89901", "Europe/Berlin"),
("2879109", "Leisnig", "", "DE", "276", "", "13", "00", "14522", "51.15743", "12.9279", "Europe/Berlin"),
("2879139", "Leipzig", "Лейпциг", "DE", "276", "", "13", "00", "14713", "51.33962", "12.37129", "Europe/Berlin"),
("2879150", "Leipheim", "", "DE", "276", "", "02", "097", "09774", "48.45004", "10.22278", "Europe/Berlin"),
("2879185", "Leinfelden-Echterdingen", "Лайнфельден-Эхтердинген", "DE", "276", "", "01", "081", "08116", "48.69406", "9.16809", "Europe/Berlin"),
("2879193", "Leinefelde", "", "DE", "276", "", "15", "00", "16061", "51.38796", "10.3262", "Europe/Berlin"),
("2879200", "Leinburg", "", "DE", "276", "", "02", "095", "09574", "49.45167", "11.31", "Europe/Berlin"),
("2879241", "Leimen", "Лаймен", "DE", "276", "", "01", "082", "08226", "49.34737", "8.68733", "Europe/Berlin"),
("2879315", "Leichlingen", "Лайхлинген", "DE", "276", "", "07", "053", "05378", "51.10628", "7.01873", "Europe/Berlin"),
("2879367", "Lehrte", "Лерте", "DE", "276", "", "06", "00", "03241", "52.37193", "9.97919", "Europe/Berlin"),
("2879378", "Lehre", "", "DE", "276", "", "06", "00", "03154", "52.33333", "10.66667", "Europe/Berlin"),
("2879653", "Legden", "", "DE", "276", "", "07", "055", "05554", "52.03333", "7.1", "Europe/Berlin"),
("2879697", "Leer", "Лер", "DE", "276", "", "06", "00", "03457", "53.23157", "7.461", "Europe/Berlin"),
("2879713", "Leegebruch", "", "DE", "276", "", "11", "00", "12065", "52.7234", "13.19304", "Europe/Berlin"),
("2879758", "Leck", "", "DE", "276", "", "10", "00", "01054", "54.76667", "8.98333", "Europe/Berlin"),
("2879832", "Lebach", "Лебах", "DE", "276", "", "09", "00", "10044", "49.41122", "6.90988", "Europe/Berlin"),
("2879929", "Lauterbach", "", "DE", "276", "", "05", "065", "06535", "50.63558", "9.39777", "Europe/Berlin"),
("2879964", "Lauter", "", "DE", "276", "", "13", "00", "14521", "50.56264", "12.73513", "Europe/Berlin"),
("2880077", "Laupheim", "Лаупхайм", "DE", "276", "", "01", "084", "08426", "48.22786", "9.87874", "Europe/Berlin"),
("2880099", "Lauingen", "", "DE", "276", "", "02", "097", "09773", "48.56775", "10.42706", "Europe/Berlin"),
("2880111", "Lauffen am Neckar", "", "DE", "276", "", "01", "081", "08125", "49.0734", "9.14567", "Europe/Berlin"),
("2880121", "Laufenburg", "", "DE", "276", "", "01", "083", "08337", "47.56512", "8.06045", "Europe/Berlin"),
("2880129", "Laufen", "", "DE", "276", "", "02", "091", "09172", "47.93568", "12.92856", "Europe/Berlin"),
("2880144", "Lauf an der Pegnitz", "Лауф-ан-дер-Пегниц", "DE", "276", "", "02", "095", "09574", "49.51386", "11.28247", "Europe/Berlin"),
("2880146", "Laufach", "", "DE", "276", "", "02", "096", "09671", "50.01667", "9.3", "Europe/Berlin"),
("2880181", "Lauenburg", "", "DE", "276", "", "10", "00", "01053", "53.37199", "10.55654", "Europe/Berlin"),
("2880204", "Laudenbach", "", "DE", "276", "", "01", "082", "08226", "49.61333", "8.65389", "Europe/Berlin"),
("2880221", "Lauchhammer", "Лауххаммер", "DE", "276", "", "11", "00", "12066", "51.48813", "13.76623", "Europe/Berlin"),
("2880308", "Laubach", "", "DE", "276", "", "05", "065", "06531", "50.54196", "8.99034", "Europe/Berlin"),
("2880351", "Lathen", "", "DE", "276", "", "06", "00", "03454", "52.86667", "7.31667", "Europe/Berlin"),
("2880357", "Lastrup", "", "DE", "276", "", "06", "00", "03453", "52.78333", "7.85", "Europe/Berlin"),
("2880425", "Lappersdorf", "", "DE", "276", "", "02", "093", "09375", "49.04694", "12.0913", "Europe/Berlin"),
("2880498", "Lankwitz", "Ланквиц", "DE", "276", "", "16", "00", "11000", "52.43623", "13.3459", "Europe/Berlin"),
("2880503", "Lankow", "", "DE", "276", "", "12", "00", "13004", "53.64983", "11.36913", "Europe/Berlin"),
("2880539", "Langweid", "", "DE", "276", "", "02", "097", "09772", "48.49095", "10.8531", "Europe/Berlin"),
("2880547", "Langwedel", "", "DE", "276", "", "06", "00", "03361", "52.97864", "9.18542", "Europe/Berlin"),
("2880597", "Langquaid", "", "DE", "276", "", "02", "092", "09273", "48.82318", "12.05134", "Europe/Berlin"),
("2880672", "Langgöns", "", "DE", "276", "", "05", "065", "06531", "50.5", "8.66667", "Europe/Berlin"),
("2880726", "Langerwehe", "", "DE", "276", "", "07", "053", "05358", "50.81667", "6.35", "Europe/Berlin"),
("2880862", "Langenzenn", "", "DE", "276", "", "02", "095", "09573", "49.49463", "10.7923", "Europe/Berlin"),
("2880913", "Langenselbold", "", "DE", "276", "", "05", "064", "06435", "50.17657", "9.04003", "Europe/Berlin"),
("2881018", "Langenhorn", "", "DE", "276", "", "04", "00", "02000", "53.66556", "10.00137", "Europe/Berlin"),
("2881062", "Langenhagen", "Лангенхаген", "DE", "276", "", "06", "00", "03241", "52.44758", "9.73741", "Europe/Berlin"),
("2881085", "Langenfeld", "Лангенфельд", "DE", "276", "", "07", "051", "05158", "51.10821", "6.94831", "Europe/Berlin"),
("2881175", "Langenberg", "", "DE", "276", "", "07", "057", "05754", "51.78333", "8.31667", "Europe/Berlin"),
("2881259", "Langenau", "", "DE", "276", "", "01", "084", "08425", "48.49616", "10.11849", "Europe/Berlin"),
("2881263", "Langenargen", "", "DE", "276", "", "01", "084", "08435", "47.59858", "9.54163", "Europe/Berlin"),
("2881276", "Langen", "", "DE", "276", "", "06", "00", "03352", "53.60554", "8.59509", "Europe/Berlin"),
("2881279", "Langen", "Ланген", "DE", "276", "", "05", "064", "06438", "49.98955", "8.66852", "Europe/Berlin"),
("2881291", "Langelsheim", "", "DE", "276", "", "06", "00", "03153", "51.93789", "10.33264", "Europe/Berlin"),
("2881477", "Landstuhl", "", "DE", "276", "", "08", "00", "07335", "49.41306", "7.57021", "Europe/Berlin"),
("2881485", "Landshut", "Ландсхут", "DE", "276", "", "02", "092", "09261", "48.52961", "12.16179", "Europe/Berlin"),
("2881509", "Landsberg am Lech", "Ландсберг-на-Лехе", "DE", "276", "", "02", "091", "09181", "48.04819", "10.88282", "Europe/Berlin"),
("2881646", "Landau in der Pfalz", "Ландау", "DE", "276", "", "08", "00", "07313", "49.19844", "8.11692", "Europe/Berlin"),
("2881650", "Landau an der Isar", "", "DE", "276", "", "02", "092", "09279", "48.67249", "12.69316", "Europe/Berlin"),
("2881695", "Lampertheim", "Лампертхайм", "DE", "276", "", "05", "064", "06431", "49.59786", "8.4725", "Europe/Berlin"),
("2881767", "Lambsheim", "", "DE", "276", "", "08", "00", "07338", "49.51361", "8.28778", "Europe/Berlin"),
("2881857", "Laichingen", "", "DE", "276", "", "01", "084", "08425", "48.48939", "9.68612", "Europe/Berlin"),
("2881885", "Lahr", "Лар", "DE", "276", "", "01", "083", "08317", "48.34042", "7.86886", "Europe/Berlin"),
("2881889", "Lahnstein", "Ланштайн", "DE", "276", "", "08", "00", "07141", "50.3", "7.61667", "Europe/Berlin"),
("2881956", "Lage", "Лаге", "DE", "276", "", "07", "057", "05766", "51.99223", "8.79301", "Europe/Berlin"),
("2881972", "Bad Laer", "", "DE", "276", "", "06", "00", "03459", "52.1", "8.08333", "Europe/Berlin"),
("2881973", "Laer", "", "DE", "276", "", "07", "055", "05566", "52.05555", "7.35775", "Europe/Berlin"),
("2881980", "Ladenburg", "", "DE", "276", "", "01", "082", "08226", "49.47307", "8.60896", "Europe/Berlin"),
("2881991", "Ladbergen", "", "DE", "276", "", "07", "055", "05566", "52.13333", "7.75", "Europe/Berlin"),
("2882028", "Lachendorf", "", "DE", "276", "", "06", "00", "03351", "52.61667", "10.25", "Europe/Berlin"),
("2882059", "Laboe", "", "DE", "276", "", "10", "00", "01057", "54.4", "10.21667", "Europe/Berlin"),
("2882087", "Laatzen", "Латцен", "DE", "276", "", "06", "00", "03241", "52.31506", "9.79739", "Europe/Berlin"),
("2882091", "Bad Laasphe", "Бад-Ласфе", "DE", "276", "", "07", "059", "05970", "50.93139", "8.42502", "Europe/Berlin"),
("2882161", "Kyritz", "", "DE", "276", "", "11", "00", "12068", "52.94212", "12.39704", "Europe/Berlin"),
("2882237", "Kusterdingen", "", "DE", "276", "", "01", "084", "08416", "48.52291", "9.11977", "Europe/Berlin"),
("2882265", "Kusel", "", "DE", "276", "", "08", "00", "07336", "49.53772", "7.40472", "Europe/Berlin"),
("2882318", "Kürten", "Кюртен", "DE", "276", "", "07", "053", "05378", "51.05", "7.26667", "Europe/Berlin"),
("2882366", "Kueps Oberfranken", "", "DE", "276", "", "02", "094", "09476", "50.19265", "11.27599", "Europe/Berlin"),
("2882375", "Kuppenheim", "", "DE", "276", "", "01", "082", "08216", "48.82794", "8.25417", "Europe/Berlin"),
("2882399", "Kupferzell", "", "DE", "276", "", "01", "081", "08126", "49.22778", "9.69", "Europe/Berlin"),
("2882439", "Künzelsau", "Кюнцельзау", "DE", "276", "", "01", "081", "08126", "49.2818", "9.68352", "Europe/Berlin"),
("2882440", "Künzell", "", "DE", "276", "", "05", "066", "06631", "50.5442", "9.71792", "Europe/Berlin"),
("2882529", "Kümmersbruck", "", "DE", "276", "", "02", "093", "09371", "49.41917", "11.88833", "Europe/Berlin"),
("2882575", "Külsheim", "", "DE", "276", "", "01", "081", "08128", "49.66942", "9.52361", "Europe/Berlin"),
("2882588", "Kulmbach", "Кульмбах", "DE", "276", "", "02", "094", "09477", "50.10068", "11.45032", "Europe/Berlin"),
("2883151", "Kuchen", "", "DE", "276", "", "01", "081", "08117", "48.63583", "9.79989", "Europe/Berlin"),
("2883410", "Krumbach", "", "DE", "276", "", "02", "097", "09774", "48.24182", "10.3632", "Europe/Berlin"),
("2883591", "Kropp", "", "DE", "276", "", "10", "00", "01059", "54.41667", "9.51667", "Europe/Berlin"),
("2883647", "Kronshagen", "", "DE", "276", "", "10", "00", "01058", "54.33333", "10.08333", "Europe/Berlin"),
("2883754", "Kronberg", "", "DE", "276", "", "05", "064", "06434", "50.18424", "8.5232", "Europe/Berlin"),
("2883777", "Kronau", "", "DE", "276", "", "01", "082", "08215", "49.2225", "8.63111", "Europe/Berlin"),
("2883784", "Kronach", "Кронах", "DE", "276", "", "02", "094", "09476", "50.23963", "11.33308", "Europe/Berlin"),
("2883920", "Kriftel", "", "DE", "276", "", "05", "064", "06436", "50.08408", "8.46977", "Europe/Berlin"),
("2884050", "Kreuztal", "Кройцталь", "DE", "276", "", "07", "059", "05970", "50.96775", "7.98848", "Europe/Berlin"),
("2884161", "Kreuzberg", "", "DE", "276", "", "16", "00", "11000", "52.49973", "13.40338", "Europe/Berlin"),
("2884245", "Kreuzau", "Кройцау", "DE", "276", "", "07", "053", "05358", "50.74699", "6.49069", "Europe/Berlin"),
("2884344", "Kressbronn am Bodensee", "", "DE", "276", "", "01", "084", "08435", "47.5976", "9.59707", "Europe/Berlin"),
("2884403", "Kremmen", "", "DE", "276", "", "11", "00", "12065", "52.76216", "13.02515", "Europe/Berlin"),
("2884482", "Kreiensen", "", "DE", "276", "", "06", "00", "03155", "51.85363", "9.96481", "Europe/Berlin"),
("2884509", "Krefeld", "Крефельд", "DE", "276", "", "07", "051", "05114", "51.33921", "6.58615", "Europe/Berlin"),
("2884667", "Krauchenwies", "", "DE", "276", "", "01", "084", "08437", "48.03333", "9.25", "Europe/Berlin"),
("2884779", "Kranenburg", "", "DE", "276", "", "07", "051", "05154", "51.78333", "6.01667", "Europe/Berlin"),
("2884878", "Krailling", "", "DE", "276", "", "02", "091", "09188", "48.1", "11.4", "Europe/Berlin"),
("2885070", "Kötzting", "", "DE", "276", "", "02", "093", "09372", "49.17649", "12.85515", "Europe/Berlin"),
("2885237", "Köthen", "Кётен", "DE", "276", "", "14", "00", "15082", "51.75185", "11.97093", "Europe/Berlin"),
("2885397", "Korschenbroich", "Коршенбройх", "DE", "276", "", "07", "051", "05162", "51.19139", "6.51352", "Europe/Berlin"),
("2885408", "Kornwestheim", "Корнвестхайм", "DE", "276", "", "01", "081", "08118", "48.86158", "9.18569", "Europe/Berlin"),
("2885412", "Korntal", "", "DE", "276", "", "01", "081", "08118", "48.83218", "9.1214", "Europe/Berlin"),
("2885536", "Korbach", "Корбах", "DE", "276", "", "05", "066", "06635", "51.27561", "8.873", "Europe/Berlin"),
("2885540", "Korb", "", "DE", "276", "", "01", "081", "08119", "48.84303", "9.36258", "Europe/Berlin"),
("2885656", "Köpenick", "Кёпеник", "DE", "276", "DE", "16", "00", "11000", "52.4455", "13.57455", "Europe/Berlin"),
("2885657", "Berlin Köpenick", "", "DE", "276", "DE", "16", "00", "11000", "52.44254", "13.58228", "Europe/Berlin"),
("2885672", "Konz", "Конц", "DE", "276", "", "08", "00", "07235", "49.70045", "6.57652", "Europe/Berlin"),
("2885679", "Konstanz", "Констанц", "DE", "276", "", "01", "083", "08335", "47.66033", "9.17582", "Europe/Berlin"),
("2885689", "Konradshöhe", "", "DE", "276", "", "16", "00", "11000", "52.58535", "13.22758", "Europe/Berlin"),
("2885716", "Könnern", "", "DE", "276", "", "14", "00", "15089", "51.6712", "11.77068", "Europe/Berlin"),
("2885732", "Königs Wusterhausen", "Кёнигс-Вустерхаузен", "DE", "276", "", "11", "00", "12061", "52.30141", "13.633", "Europe/Berlin"),
("2885734", "Königswinter", "Кёнигсвинтер", "DE", "276", "", "07", "053", "05382", "50.68376", "7.18675", "Europe/Berlin"),
("2885760", "Königstein im Taunus", "Кёнигштайн", "DE", "276", "", "05", "064", "06434", "50.17943", "8.47132", "Europe/Berlin"),
("2885800", "Königslutter am Elm", "Кёнигслуттер-ам-Эльм", "DE", "276", "", "06", "00", "03154", "52.25116", "10.81683", "Europe/Berlin"),
("2885829", "Bad Königshofen im Grabfeld", "", "DE", "276", "", "02", "096", "09673", "50.30082", "10.46887", "Europe/Berlin"),
("2885888", "Königsfeld im Schwarzwald", "", "DE", "276", "", "01", "083", "08326", "48.13814", "8.41973", "Europe/Berlin"),
("2885895", "Königsee", "", "DE", "276", "", "15", "00", "16073", "50.66143", "11.09748", "Europe/Berlin"),
("2885908", "Königsbrunn", "", "DE", "276", "", "02", "097", "09772", "48.27506", "10.89178", "Europe/Berlin"),
("2885912", "Königsbronn", "", "DE", "276", "", "01", "081", "08135", "48.74317", "10.11193", "Europe/Berlin"),
("2886008", "Köngen", "", "DE", "276", "", "01", "081", "08116", "48.68333", "9.36667", "Europe/Berlin"),
("2886242", "Köln", "Кёльн", "DE", "276", "", "07", "053", "05315", "50.93333", "6.95", "Europe/Berlin"),
("2886363", "Kölleda", "", "DE", "276", "", "15", "00", "16068", "51.18745", "11.24488", "Europe/Berlin"),
("2886382", "Kolkwitz", "", "DE", "276", "", "11", "00", "12071", "51.75", "14.25", "Europe/Berlin"),
("2886404", "Kolitzheim", "", "DE", "276", "", "02", "096", "09678", "49.91667", "10.23333", "Europe/Berlin"),
("2886446", "Kolbermoor", "Кольбермор", "DE", "276", "", "02", "091", "09187", "47.84965", "12.06696", "Europe/Berlin"),
("2886946", "Koblenz", "Кобленц", "DE", "276", "", "08", "00", "07111", "50.35357", "7.57883", "Europe/Berlin"),
("2887140", "Knittlingen", "", "DE", "276", "", "01", "082", "08236", "49.02487", "8.75606", "Europe/Berlin"),
("2887194", "Knetzgau", "", "DE", "276", "", "02", "096", "09674", "49.98333", "10.55", "Europe/Berlin"),
("2887380", "Klötze", "", "DE", "276", "", "14", "00", "15081", "52.62725", "11.16424", "Europe/Berlin"),
("2887645", "Klipphausen", "", "DE", "276", "", "13", "00", "14627", "51.08333", "13.53333", "Europe/Berlin"),
("2887713", "Klingenthal", "", "DE", "276", "", "13", "00", "14523", "50.35963", "12.46463", "Europe/Berlin"),
("2887736", "Klingenberg am Main", "", "DE", "276", "", "02", "096", "09676", "49.78507", "9.18025", "Europe/Berlin"),
("2887835", "Kleve", "Клеве", "DE", "276", "", "07", "051", "05154", "51.78826", "6.13865", "Europe/Berlin"),
("2888053", "Kleinwallstadt", "", "DE", "276", "", "02", "096", "09676", "49.87464", "9.16927", "Europe/Berlin"),
("2888222", "Klein Schwülper", "", "DE", "276", "", "06", "00", "03151", "52.34153", "10.42903", "Europe/Berlin"),
("2888344", "Klein Reken", "", "DE", "276", "", "07", "055", "05554", "51.7871", "7.04367", "Europe/Berlin"),
("2888411", "Kleinostheim", "", "DE", "276", "", "02", "096", "09671", "50", "9.06667", "Europe/Berlin"),
("2888523", "Kleinmachnow", "Клайнмахнов", "DE", "276", "", "11", "00", "12069", "52.40786", "13.22514", "Europe/Berlin"),
("2889709", "Kleinblittersdorf", "", "DE", "276", "", "09", "00", "10041", "49.1578", "7.03734", "Europe/Berlin"),
("2889990", "Klausdorf", "", "DE", "276", "", "10", "00", "01057", "54.30899", "10.21372", "Europe/Berlin"),
("2890136", "Kladow", "", "DE", "276", "DE", "16", "00", "11000", "52.45423", "13.14445", "Europe/Berlin"),
("2890155", "Kitzscher", "", "DE", "276", "", "13", "00", "14729", "51.16444", "12.5526", "Europe/Berlin"),
("2890158", "Kitzingen", "Китцинген", "DE", "276", "", "02", "096", "09675", "49.73973", "10.15072", "Europe/Berlin"),
("2890199", "Kißlegg", "", "DE", "276", "", "01", "084", "08436", "47.78894", "9.88383", "Europe/Berlin"),
("2890202", "Kissing", "", "DE", "276", "", "02", "097", "09771", "48.30375", "10.97088", "Europe/Berlin"),
("2890314", "Kirn", "", "DE", "276", "", "08", "00", "07133", "49.78912", "7.45765", "Europe/Berlin"),
("2890322", "Kirkel", "", "DE", "276", "", "09", "00", "10045", "49.28333", "7.23333", "Europe/Berlin"),
("2890328", "Kirchzarten", "", "DE", "276", "", "01", "083", "08315", "47.96667", "7.95", "Europe/Berlin"),
("2890381", "Kirchseeon", "", "DE", "276", "", "02", "091", "09175", "48.07143", "11.88875", "Europe/Berlin"),
("2890420", "Kirchlinteln", "", "DE", "276", "", "06", "00", "03361", "52.95", "9.31667", "Europe/Berlin"),
("2890425", "Kirchlengern", "Кирхленгерн", "DE", "276", "", "07", "057", "05758", "52.2", "8.63333", "Europe/Berlin"),
("2890442", "Kirchhundem", "", "DE", "276", "", "07", "059", "05966", "51.1", "8.1", "Europe/Berlin"),
("2890473", "Kirchheim unter Teck", "Кирхгайм-унтер-Тек", "DE", "276", "", "01", "081", "08116", "48.64683", "9.45378", "Europe/Berlin"),
("2890478", "Kirchheimbolanden", "", "DE", "276", "", "08", "00", "07333", "49.66249", "8.01513", "Europe/Berlin"),
("2890479", "Kirchheim bei München", "", "DE", "276", "", "02", "091", "09184", "48.17656", "11.75563", "Europe/Berlin"),
("2890482", "Kirchheim am Neckar", "", "DE", "276", "", "01", "081", "08118", "49.045", "9.14222", "Europe/Berlin"),
("2890504", "Kirchhain", "Кирхгайн", "DE", "276", "", "05", "065", "06534", "50.8272", "8.92806", "Europe/Berlin"),
("2890527", "Kirchentellinsfurt", "", "DE", "276", "", "01", "084", "08416", "48.53315", "9.14732", "Europe/Berlin"),
("2890586", "Kirchen", "", "DE", "276", "", "08", "00", "07132", "50.80849", "7.88634", "Europe/Berlin"),
("2890602", "Kirchdorf am Inn", "", "DE", "276", "", "02", "092", "09277", "48.24755", "12.98453", "Europe/Berlin"),
("2890659", "Kirchberg", "", "DE", "276", "", "13", "00", "14524", "50.6219", "12.52449", "Europe/Berlin"),
("2890769", "Kirchardt", "", "DE", "276", "", "01", "081", "08125", "49.205", "8.99167", "Europe/Berlin"),
("2890795", "Kippenheim", "", "DE", "276", "", "01", "083", "08317", "48.29564", "7.8251", "Europe/Berlin"),
("2891014", "Kierspe", "Кирспе", "DE", "276", "", "07", "059", "05962", "51.13403", "7.59075", "Europe/Berlin"),
("2891122", "Kiel", "Киль", "DE", "276", "", "10", "00", "01002", "54.32133", "10.13489", "Europe/Berlin"),
("2891175", "Kiefersfelden", "", "DE", "276", "", "02", "091", "09187", "47.61409", "12.19096", "Europe/Berlin"),
("2891258", "Kevelaer", "Кевелар", "DE", "276", "", "07", "051", "05154", "51.58243", "6.24603", "Europe/Berlin"),
("2891282", "Ketzin", "", "DE", "276", "", "11", "00", "12063", "52.47809", "12.8453", "Europe/Berlin"),
("2891343", "Ketsch", "", "DE", "276", "", "01", "082", "08226", "49.36778", "8.53111", "Europe/Berlin"),
("2891524", "Kerpen", "Керпен", "DE", "276", "", "07", "053", "05362", "50.86991", "6.69691", "Europe/Berlin"),
("2891590", "Kenzingen", "", "DE", "276", "", "01", "083", "08316", "48.1963", "7.76974", "Europe/Berlin"),
("2891621", "Kempten (Allgäu)", "", "DE", "276", "", "02", "097", "09763", "47.72674", "10.31389", "Europe/Berlin"),
("2891643", "Kempen", "Кемпен", "DE", "276", "", "07", "051", "05166", "51.36432", "6.41858", "Europe/Berlin"),
("2891668", "Kemnath", "", "DE", "276", "", "02", "093", "09377", "49.87007", "11.89077", "Europe/Berlin"),
("2891742", "Kelsterbach", "", "DE", "276", "", "05", "064", "06433", "50.06135", "8.52916", "Europe/Berlin"),
("2891750", "Kellinghusen", "", "DE", "276", "", "10", "00", "01061", "53.95202", "9.71959", "Europe/Berlin"),
("2891832", "Kelkheim (Taunus)", "", "DE", "276", "", "05", "064", "06436", "50.13703", "8.4502", "Europe/Berlin"),
("2891834", "Kelheim", "Кельхайм", "DE", "276", "", "02", "092", "09273", "48.91725", "11.88618", "Europe/Berlin"),
("2891951", "Kehl", "Кель", "DE", "276", "", "01", "083", "08317", "48.57297", "7.81523", "Europe/Berlin"),
("2892051", "Kaulsdorf", "", "DE", "276", "DE", "16", "00", "11000", "52.51732", "13.58871", "Europe/Berlin"),
("2892078", "Kaufering", "", "DE", "276", "", "02", "091", "09181", "48.09121", "10.87913", "Europe/Berlin"),
("2892080", "Kaufbeuren", "Кауфбойрен", "DE", "276", "", "02", "097", "09762", "47.88238", "10.62192", "Europe/Berlin"),
("2892485", "Kastellaun", "", "DE", "276", "", "08", "00", "07140", "50.06922", "7.44154", "Europe/Berlin"),
("2892518", "Kassel", "Кассель", "DE", "276", "", "05", "066", "06611", "51.31667", "9.5", "Europe/Berlin"),
("2892648", "Karstädt", "", "DE", "276", "", "11", "00", "12070", "53.15", "11.75", "Europe/Berlin"),
("2892705", "Karow", "", "DE", "276", "DE", "16", "00", "11000", "52.60904", "13.48117", "Europe/Berlin"),
("2892786", "Karlstadt", "Карлштадт", "DE", "276", "", "02", "096", "09677", "49.96034", "9.77239", "Europe/Berlin"),
("2892794", "Karlsruhe", "Карлсруэ", "DE", "276", "", "01", "082", "08212", "49.00937", "8.40444", "Europe/Berlin"),
("2892810", "Karlshuld", "", "DE", "276", "", "02", "091", "09185", "48.68333", "11.3", "Europe/Berlin"),
("2892811", "Karlshorst", "Карлсхорст", "DE", "276", "DE", "16", "00", "11000", "52.48419", "13.53185", "Europe/Berlin"),
("2892874", "Karlsfeld", "", "DE", "276", "", "02", "091", "09174", "48.21667", "11.46667", "Europe/Berlin"),
("2892980", "Karben", "Карбен", "DE", "276", "", "05", "064", "06440", "50.23019", "8.77155", "Europe/Berlin"),
("2893022", "Kappelrodeck", "", "DE", "276", "", "01", "083", "08317", "48.59182", "8.11692", "Europe/Berlin"),
("2893023", "Kappeln", "", "DE", "276", "", "10", "00", "01059", "54.66122", "9.9313", "Europe/Berlin"),
("2893237", "Kandern", "", "DE", "276", "", "01", "083", "08336", "47.71393", "7.66237", "Europe/Berlin"),
("2893244", "Kandel", "", "DE", "276", "", "08", "00", "07334", "49.08277", "8.1972", "Europe/Berlin"),
("2893264", "Kamp-Lintfort", "Камп-Линтфорт", "DE", "276", "", "07", "051", "05170", "51.50467", "6.54587", "Europe/Berlin"),
("2893437", "Kamenz", "Каменц", "DE", "276", "", "13", "00", "14625", "51.26798", "14.09374", "Europe/Berlin"),
("2893438", "Kamen", "Камен", "DE", "276", "", "07", "059", "05978", "51.59231", "7.6638", "Europe/Berlin"),
("2893544", "Kaltenkirchen", "Кальтенкирхен", "DE", "276", "", "10", "00", "01060", "53.83292", "9.9581", "Europe/Berlin"),
("2893762", "Kall", "", "DE", "276", "", "07", "053", "05366", "50.55", "6.55", "Europe/Berlin"),
("2893837", "Kalkar", "", "DE", "276", "", "07", "051", "05154", "51.73907", "6.29101", "Europe/Berlin"),
("2893868", "Kalefeld", "", "DE", "276", "", "06", "00", "03155", "51.8", "10.03333", "Europe/Berlin"),
("2894003", "Kaiserslautern", "Кайзерслаутерн", "DE", "276", "", "08", "00", "07312", "49.443", "7.77161", "Europe/Berlin"),
("2894245", "Kahl am Main", "", "DE", "276", "", "02", "096", "09671", "50.06981", "9.00553", "Europe/Berlin"),
("2894247", "Kahla", "", "DE", "276", "", "15", "00", "16074", "50.80651", "11.58516", "Europe/Berlin"),
("2894375", "Kaarst", "Карст", "DE", "276", "", "07", "051", "05162", "51.22929", "6.61883", "Europe/Berlin"),
("2894394", "Jüterbog", "", "DE", "276", "", "11", "00", "12072", "51.99607", "13.07979", "Europe/Berlin"),
("2894553", "Jülich", "Юлих", "DE", "276", "", "07", "053", "05358", "50.92149", "6.36267", "Europe/Berlin"),
("2894637", "Jüchen", "Йюхен", "DE", "276", "", "07", "051", "05162", "51.1", "6.5", "Europe/Berlin"),
("2894702", "Jork", "", "DE", "276", "", "06", "00", "03359", "53.53198", "9.68076", "Europe/Berlin"),
("2894742", "Jöhlingen", "", "DE", "276", "", "01", "082", "08215", "49.03218", "8.5735", "Europe/Berlin"),
("2894755", "Johannisthal", "", "DE", "276", "DE", "16", "00", "11000", "52.44653", "13.5066", "Europe/Berlin"),
("2894814", "Johanngeorgenstadt", "", "DE", "276", "", "13", "00", "14521", "50.43254", "12.7114", "Europe/Berlin"),
("2894855", "Jockgrim", "", "DE", "276", "", "08", "00", "07334", "49.09889", "8.26778", "Europe/Berlin"),
("2894897", "Jever", "", "DE", "276", "", "06", "00", "03455", "53.57368", "7.89806", "Europe/Berlin"),
("2894944", "Jestetten", "", "DE", "276", "", "01", "083", "08337", "47.65", "8.56667", "Europe/Berlin"),
("2894945", "Jesteburg", "", "DE", "276", "", "06", "00", "03353", "53.3", "9.96667", "Europe/Berlin"),
("2894962", "Jessen", "", "DE", "276", "", "14", "00", "15091", "51.79337", "12.95762", "Europe/Berlin"),
("2895044", "Jena", "Йена", "DE", "276", "", "15", "00", "16053", "50.92878", "11.5899", "Europe/Berlin"),
("2895284", "Jahnsdorf", "", "DE", "276", "", "13", "00", "14521", "50.74509", "12.85414", "Europe/Berlin"),
("2895569", "Itzehoe", "Итцехо", "DE", "276", "", "10", "00", "01061", "53.92099", "9.51529", "Europe/Berlin"),
("2895617", "Issum", "", "DE", "276", "", "07", "051", "05154", "51.53333", "6.43333", "Europe/Berlin"),
("2895630", "Isselburg", "", "DE", "276", "", "07", "055", "05554", "51.83232", "6.46428", "Europe/Berlin"),
("2895636", "Ispringen", "", "DE", "276", "", "01", "082", "08236", "48.91667", "8.66667", "Europe/Berlin"),
("2895638", "Isny im Allgäu", "", "DE", "276", "", "01", "084", "08436", "47.6926", "10.03857", "Europe/Berlin"),
("2895643", "Ismaning", "", "DE", "276", "", "02", "091", "09184", "48.23333", "11.68333", "Europe/Berlin"),
("2895664", "Isernhagen Farster Bauerschaft", "", "DE", "276", "", "06", "00", "03241", "52.47093", "9.84179", "Europe/Berlin"),
("2895669", "Iserlohn", "Изерлон", "DE", "276", "", "07", "059", "05962", "51.37547", "7.70281", "Europe/Berlin"),
("2895688", "Isenbüttel", "", "DE", "276", "", "06", "00", "03151", "52.43333", "10.58333", "Europe/Berlin"),
("2895702", "Isen", "", "DE", "276", "", "02", "091", "09177", "48.21203", "12.05672", "Europe/Berlin"),
("2895992", "Ingolstadt", "Ингольштадт", "DE", "276", "", "02", "091", "09161", "48.76508", "11.42372", "Europe/Berlin"),
("2896021", "Ingelfingen", "", "DE", "276", "", "01", "081", "08126", "49.30028", "9.65303", "Europe/Berlin"),
("2896120", "Inden", "", "DE", "276", "", "07", "053", "05358", "50.86667", "6.36667", "Europe/Berlin"),
("2896261", "Immenstadt im Allgäu", "", "DE", "276", "", "02", "097", "09780", "47.55996", "10.21394", "Europe/Berlin"),
("2896263", "Immenstaad am Bodensee", "", "DE", "276", "", "01", "084", "08435", "47.66667", "9.36667", "Europe/Berlin"),
("2896279", "Immenhausen", "", "DE", "276", "", "05", "066", "06633", "51.42763", "9.48017", "Europe/Berlin"),
("2896288", "Immendingen", "", "DE", "276", "", "01", "083", "08327", "47.93333", "8.73333", "Europe/Berlin"),
("2896468", "Ilvesheim", "", "DE", "276", "", "01", "082", "08226", "49.47404", "8.5674", "Europe/Berlin"),
("2896476", "Ilshofen", "", "DE", "276", "", "01", "081", "08127", "49.17015", "9.91825", "Europe/Berlin"),
("2896477", "Ilsfeld", "", "DE", "276", "", "01", "081", "08125", "49.05548", "9.24598", "Europe/Berlin"),
("2896483", "Ilsenburg", "", "DE", "276", "", "14", "00", "15085", "51.86695", "10.67817", "Europe/Berlin"),
("2896514", "Ilmenau", "Ильменау", "DE", "276", "", "15", "00", "16070", "50.68322", "10.91858", "Europe/Berlin"),
("2896538", "Illingen", "", "DE", "276", "", "09", "00", "10043", "49.37362", "7.04758", "Europe/Berlin"),
("2896539", "Illingen", "", "DE", "276", "", "01", "082", "08236", "48.95616", "8.92459", "Europe/Berlin"),
("2896546", "Illertissen", "Иллертиссен", "DE", "276", "", "02", "097", "09775", "48.22336", "10.10347", "Europe/Berlin"),
("2896616", "Ihringen", "", "DE", "276", "", "01", "083", "08315", "48.04303", "7.6476", "Europe/Berlin"),
("2896687", "Igersheim", "", "DE", "276", "", "01", "081", "08128", "49.49444", "9.81694", "Europe/Berlin"),
("2896736", "Idstein", "Идштайн", "DE", "276", "", "05", "064", "06439", "50.21773", "8.26679", "Europe/Berlin"),
("2896753", "Idar-Oberstein", "Идар-Оберштайн", "DE", "276", "", "08", "00", "07134", "49.71443", "7.30776", "Europe/Berlin"),
("2896776", "Ichenhausen", "", "DE", "276", "", "02", "097", "09774", "48.37119", "10.30706", "Europe/Berlin"),
("2896817", "Ibbenbüren", "Иббенбюрен", "DE", "276", "", "07", "055", "05566", "52.27964", "7.71457", "Europe/Berlin"),
("2896834", "Huy-Neinstedt", "", "DE", "276", "", "14", "00", "15085", "51.96585", "10.91457", "Europe/Berlin"),
("2896877", "Hüttlingen", "", "DE", "276", "", "01", "081", "08136", "48.89266", "10.10064", "Europe/Berlin"),
("2896898", "Hutthurm", "", "DE", "276", "", "02", "092", "09275", "48.67276", "13.47146", "Europe/Berlin"),
("2897132", "Husum", "Хузум", "DE", "276", "", "10", "00", "01054", "54.4858", "9.05239", "Europe/Berlin"),
("2897216", "Hürth", "Хюрт", "DE", "276", "", "07", "053", "05362", "50.87079", "6.86761", "Europe/Berlin"),
("2897219", "Hürtgenwald", "", "DE", "276", "", "07", "053", "05358", "50.71667", "6.36667", "Europe/Berlin"),
("2897283", "Hünxe", "", "DE", "276", "", "07", "051", "05170", "51.65", "6.78333", "Europe/Berlin"),
("2897436", "Hünfeld", "Хюнфельд", "DE", "276", "", "05", "066", "06631", "50.67966", "9.76727", "Europe/Berlin"),
("2897674", "Hummelsbüttel", "", "DE", "276", "", "04", "00", "02000", "53.64773", "10.04149", "Europe/Berlin"),
("2897732", "Humboldtkolonie", "", "DE", "276", "", "07", "053", "05315", "50.93182", "6.99469", "Europe/Berlin"),
("2897844", "Hüllhorst", "", "DE", "276", "", "07", "057", "05770", "52.28333", "8.66667", "Europe/Berlin"),
("2898028", "Hüfingen", "", "DE", "276", "", "01", "083", "08326", "47.92543", "8.48831", "Europe/Berlin"),
("2898079", "Hude", "", "DE", "276", "", "06", "00", "03458", "53.10766", "8.46322", "Europe/Berlin"),
("2898098", "Hückeswagen", "Хюккесваген", "DE", "276", "", "07", "053", "05374", "51.14979", "7.34471", "Europe/Berlin"),
("2898111", "Hückelhoven", "Хюккельхофен", "DE", "276", "", "07", "053", "05370", "51.0555", "6.22658", "Europe/Berlin"),
("2898304", "Hoyerswerda", "Хойерсверда", "DE", "276", "", "13", "00", "14625", "51.43787", "14.23549", "Europe/Berlin"),
("2898321", "Höxter", "Хёкстер", "DE", "276", "", "07", "057", "05762", "51.77501", "9.38155", "Europe/Berlin"),
("2898364", "Hövelhof", "Хёфельхоф", "DE", "276", "", "07", "057", "05774", "51.81667", "8.65", "Europe/Berlin"),
("2898494", "Hösbach", "", "DE", "276", "", "02", "096", "09671", "50.00646", "9.20765", "Europe/Berlin"),
("2898541", "Horstmar", "", "DE", "276", "", "07", "055", "05566", "52.08098", "7.30539", "Europe/Berlin"),
("2898603", "Hörstel", "Хёрстель", "DE", "276", "", "07", "055", "05566", "52.29763", "7.58382", "Europe/Berlin"),
("2898640", "Horst", "", "DE", "276", "", "10", "00", "01061", "53.81195", "9.62307", "Europe/Berlin"),
("2898847", "Horneburg", "", "DE", "276", "", "06", "00", "03359", "53.50672", "9.57546", "Europe/Berlin"),
("2898924", "Horn", "", "DE", "276", "", "07", "057", "05766", "51.87151", "8.9451", "Europe/Berlin"),
("2899101", "Horb am Neckar", "Хорб-на-Неккаре", "DE", "276", "", "01", "082", "08237", "48.44423", "8.6913", "Europe/Berlin"),
("2899449", "Homburg", "", "DE", "276", "", "09", "00", "10045", "49.32637", "7.33867", "Europe/Berlin"),
("2899478", "Homberg", "", "DE", "276", "", "05", "066", "06634", "51.02994", "9.40261", "Europe/Berlin"),
("2899479", "Homberg", "", "DE", "276", "", "05", "065", "06535", "50.73108", "8.99644", "Europe/Berlin"),
("2899538", "Holzwickede", "Хольцвиккеде", "DE", "276", "", "07", "059", "05978", "51.5", "7.63333", "Europe/Berlin"),
("2899601", "Holzminden", "Хольцминден", "DE", "276", "", "06", "00", "03255", "51.82798", "9.4455", "Europe/Berlin"),
("2899676", "Holzkirchen", "Хольцкирхен", "DE", "276", "", "02", "091", "09182", "47.87663", "11.70181", "Europe/Berlin"),
("2899880", "Holzgerlingen", "", "DE", "276", "", "01", "081", "08115", "48.63969", "9.01149", "Europe/Berlin"),
("2900453", "Hollfeld", "", "DE", "276", "", "02", "094", "09472", "49.93793", "11.29153", "Europe/Berlin"),
("2900623", "Holle", "", "DE", "276", "", "06", "00", "03254", "52.08721", "10.16012", "Europe/Berlin"),
("2900740", "Holdorf", "", "DE", "276", "", "06", "00", "03460", "52.58333", "8.11667", "Europe/Berlin"),
("2900825", "Höhr-Grenzhausen", "", "DE", "276", "", "08", "00", "07143", "50.43474", "7.66903", "Europe/Berlin"),
("2901348", "Hohenwestedt", "", "DE", "276", "", "10", "00", "01058", "54.08333", "9.66667", "Europe/Berlin"),
("2901420", "Hohenstein-Ernstthal", "Хоэнштайн-Эрнстталь", "DE", "276", "", "13", "00", "14524", "50.80064", "12.71287", "Europe/Berlin"),
("2901588", "Hohen Neuendorf", "Хоэн-Нойендорф", "DE", "276", "", "11", "00", "12065", "52.67631", "13.27775", "Europe/Berlin"),
("2901601", "Hohenmölsen", "", "DE", "276", "", "14", "00", "15084", "51.15769", "12.1", "Europe/Berlin"),
("2901621", "Hohenlockstedt", "", "DE", "276", "", "10", "00", "01061", "53.96667", "9.61667", "Europe/Berlin"),
("2901731", "Hohenhameln", "", "DE", "276", "", "06", "00", "03157", "52.25755", "10.06416", "Europe/Berlin"),
("2901872", "Hohenbrunn", "", "DE", "276", "", "02", "091", "09184", "48.04785", "11.70224", "Europe/Berlin"),
("2901908", "Höhenberg", "", "DE", "276", "", "07", "053", "05315", "50.93323", "7.04138", "Europe/Berlin"),
("2902235", "Hohberg", "", "DE", "276", "", "01", "083", "08317", "48.3227", "7.89972", "Europe/Berlin"),
("2902531", "Hofheim in Unterfranken", "", "DE", "276", "", "02", "096", "09674", "50.13675", "10.52321", "Europe/Berlin"),
("2902533", "Hofheim am Taunus", "Хофхайм-ам-Таунус", "DE", "276", "", "05", "064", "06436", "50.09019", "8.4493", "Europe/Berlin"),
("2902559", "Hofgeismar", "Хофгайсмар", "DE", "276", "", "05", "066", "06633", "51.49607", "9.385", "Europe/Berlin"),
("2902731", "Hofbieber", "", "DE", "276", "", "05", "066", "06631", "50.58629", "9.83534", "Europe/Berlin"),
("2902768", "Hof", "Хоф", "DE", "276", "", "02", "094", "09464", "50.31297", "11.91261", "Europe/Berlin"),
("2902852", "Hockenheim", "Хоккенхайм", "DE", "276", "", "01", "082", "08226", "49.32334", "8.55194", "Europe/Berlin"),
("2902951", "Höchst im Odenwald", "", "DE", "276", "", "05", "064", "06437", "49.79972", "8.99944", "Europe/Berlin"),
("2903012", "Höchstädt an der Donau", "", "DE", "276", "", "02", "097", "09773", "48.61124", "10.56816", "Europe/Berlin"),
("2903016", "Höchstadt an der Aisch", "", "DE", "276", "", "02", "095", "09572", "49.70617", "10.81329", "Europe/Berlin"),
("2903175", "Hochheim am Main", "Хохгайм-на-Майне", "DE", "276", "", "05", "064", "06436", "50.01436", "8.35218", "Europe/Berlin"),
("2903237", "Hochfeld", "", "DE", "276", "", "07", "051", "05112", "51.41943", "6.75462", "Europe/Berlin"),
("2903327", "Höchberg", "", "DE", "276", "", "02", "096", "09679", "49.78446", "9.88223", "Europe/Berlin"),
("2903470", "Hitzacker", "", "DE", "276", "", "06", "00", "03354", "53.15254", "11.04418", "Europe/Berlin"),
("2903806", "Hirschau", "", "DE", "276", "", "02", "093", "09371", "49.54396", "11.94617", "Europe/Berlin"),
("2903810", "Hirschaid", "", "DE", "276", "", "02", "094", "09471", "49.81789", "10.98918", "Europe/Berlin"),
("2904397", "Hinte", "", "DE", "276", "", "06", "00", "03452", "53.41667", "7.18333", "Europe/Berlin"),
("2904591", "Hilzingen", "", "DE", "276", "", "01", "083", "08335", "47.76667", "8.78333", "Europe/Berlin"),
("2904607", "Hilter", "", "DE", "276", "", "06", "00", "03459", "52.13573", "8.14715", "Europe/Berlin"),
("2904638", "Hilpoltstein", "", "DE", "276", "", "02", "095", "09576", "49.19047", "11.1906", "Europe/Berlin"),
("2904725", "Hille", "", "DE", "276", "", "07", "057", "05770", "52.33333", "8.75", "Europe/Berlin"),
("2904789", "Hildesheim", "Хильдесхайм", "DE", "276", "", "06", "00", "03254", "52.15077", "9.95112", "Europe/Berlin"),
("2904795", "Hilden", "Хильден", "DE", "276", "", "07", "051", "05158", "51.16818", "6.93093", "Europe/Berlin"),
("2904804", "Hildburghausen", "", "DE", "276", "", "15", "00", "16069", "50.42553", "10.73184", "Europe/Berlin"),
("2904808", "Hilchenbach", "Хильхенбах", "DE", "276", "", "07", "059", "05970", "50.99687", "8.11062", "Europe/Berlin"),
("2904886", "Hiddenhausen", "Хидденхаузен", "DE", "276", "", "07", "057", "05758", "52.16667", "8.61667", "Europe/Berlin"),
("2904985", "Heusweiler", "Хойсвайлер", "DE", "276", "", "09", "00", "10041", "49.35", "6.93333", "Europe/Berlin"),
("2904992", "Heusenstamm", "Хойзенштамм", "DE", "276", "", "05", "064", "06438", "50.05553", "8.80076", "Europe/Berlin"),
("2905070", "Heuchelheim", "", "DE", "276", "", "05", "065", "06531", "50.58333", "8.63333", "Europe/Berlin"),
("2905154", "Heubach", "", "DE", "276", "", "01", "081", "08136", "48.79267", "9.9337", "Europe/Berlin"),
("2905206", "Hettstedt", "Хетштедт", "DE", "276", "", "14", "00", "15087", "51.6503", "11.51146", "Europe/Berlin"),
("2905290", "Hessisch Oldendorf", "Хессиш-Ольдендорф", "DE", "276", "", "06", "00", "03252", "52.17269", "9.24913", "Europe/Berlin"),
("2905293", "Hessisch Lichtenau", "", "DE", "276", "", "05", "066", "06636", "51.19954", "9.71857", "Europe/Berlin"),
("2905455", "Herzogenrath", "Херцогенрат", "DE", "276", "", "07", "053", "05334", "50.87067", "6.10136", "Europe/Berlin"),
("2905457", "Herzogenaurach", "Херцогенаурах", "DE", "276", "", "02", "095", "09572", "49.56798", "10.88565", "Europe/Berlin"),
("2905496", "Herzberg am Harz", "", "DE", "276", "", "06", "00", "03156", "51.65546", "10.33938", "Europe/Berlin"),
("2905504", "Herzberg", "", "DE", "276", "", "11", "00", "12062", "51.68692", "13.22016", "Europe/Berlin"),
("2905527", "Herxheim am Berg", "", "DE", "276", "", "08", "00", "07332", "49.50917", "8.17917", "Europe/Berlin"),
("2905560", "Herten", "Хертен", "DE", "276", "", "07", "055", "05562", "51.59638", "7.14387", "Europe/Berlin"),
("2905587", "Herscheid", "", "DE", "276", "", "07", "059", "05962", "51.17901", "7.74355", "Europe/Berlin"),
("2905599", "Hersbruck", "", "DE", "276", "", "02", "095", "09574", "49.51083", "11.43151", "Europe/Berlin"),
("2905604", "Herrsching am Ammersee", "", "DE", "276", "", "02", "091", "09188", "47.99888", "11.17679", "Europe/Berlin"),
("2905706", "Herrieden", "", "DE", "276", "", "02", "095", "09571", "49.23779", "10.5035", "Europe/Berlin"),
("2905826", "Herrenberg", "Херренберг", "DE", "276", "", "01", "081", "08115", "48.59523", "8.86648", "Europe/Berlin"),
("2905878", "Heroldsberg", "", "DE", "276", "", "02", "095", "09572", "49.53247", "11.15551", "Europe/Berlin"),
("2905881", "Heroldsbach", "", "DE", "276", "", "02", "094", "09474", "49.69342", "10.99882", "Europe/Berlin"),
("2905891", "Herne", "Херне", "DE", "276", "", "07", "059", "05916", "51.5388", "7.22572", "Europe/Berlin"),
("2905904", "Hermsdorf", "", "DE", "276", "", "16", "00", "11000", "52.61131", "13.31783", "Europe/Berlin"),
("2905916", "Hermsdorf", "", "DE", "276", "", "15", "00", "16074", "50.89694", "11.85549", "Europe/Berlin"),
("2905929", "Hermeskeil", "", "DE", "276", "", "08", "00", "07235", "49.65528", "6.94407", "Europe/Berlin"),
("2906015", "Hermannsburg", "", "DE", "276", "", "06", "00", "03351", "52.83254", "10.08957", "Europe/Berlin"),
("2906088", "Heringen", "", "DE", "276", "", "05", "066", "06632", "50.88798", "10.00717", "Europe/Berlin"),
("2906121", "Herford", "Херфорд", "DE", "276", "", "07", "057", "05758", "52.11457", "8.67343", "Europe/Berlin"),
("2906143", "Herdorf", "", "DE", "276", "", "08", "00", "07132", "50.77704", "7.95366", "Europe/Berlin"),
("2906152", "Herdecke", "Хердекке", "DE", "276", "", "07", "059", "05954", "51.39999", "7.43584", "Europe/Berlin"),
("2906175", "Herbstein", "", "DE", "276", "", "05", "065", "06535", "50.56105", "9.34592", "Europe/Berlin"),
("2906194", "Herbrechtingen", "", "DE", "276", "", "01", "081", "08135", "48.62173", "10.176", "Europe/Berlin"),
("2906199", "Herborn", "Херборн", "DE", "276", "", "05", "065", "06532", "50.68135", "8.30369", "Europe/Berlin"),
("2906205", "Herbolzheim", "", "DE", "276", "", "01", "083", "08316", "48.21884", "7.77746", "Europe/Berlin"),
("2906268", "Heppenheim an der Bergstrasse", "", "DE", "276", "", "05", "064", "06431", "49.64145", "8.63206", "Europe/Berlin"),
("2906331", "Hennigsdorf", "Хеннигсдорф", "DE", "276", "", "11", "00", "12065", "52.63598", "13.20419", "Europe/Berlin"),
("2906376", "Hennef", "Хеннеф", "DE", "276", "", "07", "053", "05382", "50.77555", "7.28308", "Europe/Berlin"),
("2906464", "Hengersberg", "", "DE", "276", "", "02", "092", "09271", "48.77255", "13.05485", "Europe/Berlin"),
("2906514", "Hemsbach", "", "DE", "276", "", "01", "082", "08226", "49.59075", "8.64779", "Europe/Berlin"),
("2906524", "Hemmoor", "", "DE", "276", "", "06", "00", "03352", "53.68702", "9.15492", "Europe/Berlin"),
("2906530", "Hemmingen", "", "DE", "276", "", "06", "00", "03241", "52.31425", "9.72359", "Europe/Berlin"),
("2906531", "Hemmingen", "", "DE", "276", "", "01", "081", "08118", "48.86667", "9.03333", "Europe/Berlin"),
("2906583", "Hemhofen", "", "DE", "276", "", "02", "095", "09572", "49.68333", "10.93333", "Europe/Berlin"),
("2906595", "Hemer", "Хемер", "DE", "276", "", "07", "059", "05962", "51.38707", "7.77019", "Europe/Berlin"),
("2906625", "Hemau", "", "DE", "276", "", "02", "093", "09375", "49.05399", "11.78195", "Europe/Berlin"),
("2906654", "Helsa", "", "DE", "276", "", "05", "066", "06633", "51.26667", "9.68333", "Europe/Berlin"),
("2906676", "Helmstedt", "Хельмштедт", "DE", "276", "", "06", "00", "03154", "52.2279", "11.00985", "Europe/Berlin"),
("2906744", "Helmbrechts", "", "DE", "276", "", "02", "094", "09475", "50.23557", "11.71589", "Europe/Berlin"),
("2906809", "Hellersdorf", "", "DE", "276", "", "16", "00", "11000", "52.53319", "13.6088", "Europe/Berlin"),
("2906843", "Hellenthal", "", "DE", "276", "", "07", "053", "05366", "50.48333", "6.43333", "Europe/Berlin"),
("2907068", "Heitersheim", "", "DE", "276", "", "01", "083", "08315", "47.87468", "7.65721", "Europe/Berlin"),
("2907201", "Heinsberg", "Хайнсберг", "DE", "276", "", "07", "053", "05370", "51.06358", "6.0998", "Europe/Berlin"),
("2907280", "Heiningen", "", "DE", "276", "", "01", "081", "08117", "48.66177", "9.64977", "Europe/Berlin"),
("2907298", "Heinersdorf", "", "DE", "276", "DE", "16", "00", "11000", "52.57173", "13.43757", "Europe/Berlin"),
("2907359", "Heimsheim", "", "DE", "276", "", "01", "082", "08236", "48.80656", "8.86744", "Europe/Berlin"),
("2907488", "Heilsbronn", "", "DE", "276", "", "02", "095", "09571", "49.33572", "10.78741", "Europe/Berlin"),
("2907545", "Heilbad Heiligenstadt", "Хайльбад-Хайлигенштадт", "DE", "276", "", "15", "00", "16061", "51.37819", "10.13744", "Europe/Berlin"),
("2907551", "Heiligensee", "", "DE", "276", "DE", "16", "00", "11000", "52.61449", "13.24501", "Europe/Berlin"),
("2907585", "Heiligenhaus", "Хайлигенхаус", "DE", "276", "", "07", "051", "05158", "51.32662", "6.97106", "Europe/Berlin"),
("2907589", "Heiligenhafen", "", "DE", "276", "", "10", "00", "01055", "54.36964", "10.98022", "Europe/Berlin"),
("2907669", "Heilbronn", "Хайльбронн", "DE", "276", "", "01", "081", "08121", "49.13995", "9.22054", "Europe/Berlin"),
("2907685", "Heikendorf", "", "DE", "276", "", "10", "00", "01057", "54.36667", "10.2", "Europe/Berlin"),
("2907790", "Heidesheim", "", "DE", "276", "", "08", "00", "07332", "49.58247", "8.19537", "Europe/Berlin"),
("2907851", "Heidenheim an der Brenz", "Хайденхайм-на-Бренце", "DE", "276", "", "01", "081", "08135", "48.67798", "10.15162", "Europe/Berlin"),
("2907887", "Heidenau", "Хайденау", "DE", "276", "", "13", "00", "14628", "50.97221", "13.86741", "Europe/Berlin"),
("2907889", "Heiden", "", "DE", "276", "", "07", "055", "05554", "51.83333", "6.93333", "Europe/Berlin"),
("2907911", "Heidelberg", "Хайдельберг", "DE", "276", "", "01", "082", "08221", "49.40768", "8.69079", "Europe/Berlin"),
("2907983", "Heideck", "", "DE", "276", "", "02", "095", "09576", "49.13365", "11.12726", "Europe/Berlin"),
("2908032", "Heide", "Хайде", "DE", "276", "", "10", "00", "01051", "54.19579", "9.0988", "Europe/Berlin"),
("2908330", "Heek", "", "DE", "276", "", "07", "055", "05554", "52.11667", "7.1", "Europe/Berlin"),
("2908398", "Heddesheim", "", "DE", "276", "", "01", "082", "08226", "49.50556", "8.60361", "Europe/Berlin"),
("2908495", "Hechingen", "Хехинген", "DE", "276", "", "01", "084", "08417", "48.35149", "8.96317", "Europe/Berlin"),
("2908529", "Hebertshausen", "", "DE", "276", "", "02", "091", "09174", "48.28959", "11.46526", "Europe/Berlin"),
("2908597", "Havixbeck", "", "DE", "276", "", "07", "055", "05558", "51.98333", "7.41667", "Europe/Berlin"),
("2908644", "Havelberg", "", "DE", "276", "", "14", "00", "15090", "52.83088", "12.07552", "Europe/Berlin"),
("2908661", "Hauzenberg", "", "DE", "276", "", "02", "092", "09275", "48.64957", "13.62645", "Europe/Berlin"),
("2908783", "Hausham", "", "DE", "276", "", "02", "091", "09182", "47.7466", "11.84069", "Europe/Berlin"),
("2908974", "Hausach", "", "DE", "276", "", "01", "083", "08317", "48.28426", "8.17602", "Europe/Berlin"),
("2909230", "Hattingen", "Хаттинген", "DE", "276", "", "07", "059", "05954", "51.39894", "7.18557", "Europe/Berlin"),
("2909240", "Hattersheim", "", "DE", "276", "", "05", "064", "06436", "50.07854", "8.47552", "Europe/Berlin"),
("2909268", "Hatten", "", "DE", "276", "", "06", "00", "03458", "53.05", "8.38333", "Europe/Berlin"),
("2909313", "Haßloch", "", "DE", "276", "", "08", "00", "07332", "49.36278", "8.25806", "Europe/Berlin"),
("2909335", "Haßfurt", "", "DE", "276", "", "02", "096", "09674", "50.03521", "10.5156", "Europe/Berlin"),
("2909544", "Haslach", "", "DE", "276", "", "01", "083", "08317", "48.56531", "8.05658", "Europe/Berlin"),
("2909761", "Haselünne", "", "DE", "276", "", "06", "00", "03454", "52.67412", "7.4846", "Europe/Berlin"),
("2909794", "Haselhorst", "", "DE", "276", "", "16", "00", "11000", "52.54409", "13.23743", "Europe/Berlin"),
("2909915", "Hasbergen", "", "DE", "276", "", "06", "00", "03459", "52.23333", "7.93333", "Europe/Berlin"),
("2910140", "Hartha", "", "DE", "276", "", "13", "00", "14522", "51.09863", "12.97391", "Europe/Berlin"),
("2910167", "Hartenstein", "", "DE", "276", "", "13", "00", "14524", "50.66236", "12.66966", "Europe/Berlin"),
("2910269", "Harsum", "", "DE", "276", "", "06", "00", "03254", "52.21045", "9.96486", "Europe/Berlin"),
("2910278", "Harsewinkel", "Харзевинкель", "DE", "276", "", "07", "057", "05754", "51.96224", "8.22766", "Europe/Berlin"),
("2910280", "Harsefeld", "", "DE", "276", "", "06", "00", "03359", "53.45399", "9.50297", "Europe/Berlin"),
("2910302", "Harrislee", "", "DE", "276", "", "10", "00", "01059", "54.8", "9.38333", "Europe/Berlin"),
("2910514", "Haren", "", "DE", "276", "", "06", "00", "03454", "52.79262", "7.24142", "Europe/Berlin"),
("2910633", "Hardheim", "", "DE", "276", "", "01", "082", "08225", "49.61194", "9.47194", "Europe/Berlin"),
("2910663", "Hardegsen", "", "DE", "276", "", "06", "00", "03155", "51.65227", "9.8305", "Europe/Berlin"),
("2910685", "Harburg", "Харбург", "DE", "276", "", "04", "00", "02000", "53.46057", "9.98388", "Europe/Berlin"),
("2910686", "Harburg", "", "DE", "276", "", "02", "097", "09779", "48.78674", "10.68927", "Europe/Berlin"),
("2910831", "Hannover", "Ганновер", "DE", "276", "", "06", "00", "03241", "52.37052", "9.73322", "Europe/Berlin"),
("2910875", "Hänigsen", "", "DE", "276", "", "06", "00", "03241", "52.48425", "10.09129", "Europe/Berlin"),
("2910986", "Handewitt", "", "DE", "276", "", "10", "00", "01059", "54.76667", "9.33333", "Europe/Berlin"),
("2911007", "Hanau am Main", "", "DE", "276", "", "05", "064", "06435", "50.13423", "8.91418", "Europe/Berlin"),
("2911051", "Hamminkeln", "Хамминкельн", "DE", "276", "", "07", "051", "05170", "51.73262", "6.59031", "Europe/Berlin"),
("2911214", "Hammelburg", "", "DE", "276", "", "02", "096", "09672", "50.11633", "9.89143", "Europe/Berlin"),
("2911240", "Hamm", "Хамм", "DE", "276", "", "07", "059", "05915", "51.68033", "7.82089", "Europe/Berlin"),
("2911271", "Hameln", "Хамельн", "DE", "276", "", "06", "00", "03252", "52.10397", "9.35623", "Europe/Berlin"),
("2911285", "Wandsbek", "", "DE", "276", "", "04", "00", "02000", "53.56667", "10.1", "Europe/Berlin"),
("2911287", "Marienthal", "", "DE", "276", "", "04", "00", "02000", "53.56667", "10.08333", "Europe/Berlin"),
("2911288", "Hamburg-Mitte", "", "DE", "276", "", "04", "00", "02000", "53.55", "10.01667", "Europe/Berlin"),
("2911293", "Eimsbüttel", "Аймсбюттель", "DE", "276", "", "04", "00", "02000", "53.56667", "9.98333", "Europe/Berlin"),
("2911296", "Altona", "Альтона", "DE", "276", "", "04", "00", "02000", "53.55", "9.93333", "Europe/Berlin"),
("2911298", "Hamburg", "Гамбург", "DE", "276", "", "04", "00", "02000", "53.57532", "10.01534", "Europe/Berlin"),
("2911300", "Hambühren", "", "DE", "276", "", "06", "00", "03351", "52.63333", "9.98333", "Europe/Berlin"),
("2911308", "Hambrücken", "", "DE", "276", "", "01", "082", "08215", "49.19", "8.54056", "Europe/Berlin"),
("2911322", "Hambergen", "", "DE", "276", "", "06", "00", "03356", "53.30826", "8.8252", "Europe/Berlin"),
("2911384", "Halver", "Хальфер", "DE", "276", "", "07", "059", "05962", "51.18612", "7.49817", "Europe/Berlin"),
("2911395", "Haltern", "Хальтерне", "DE", "276", "", "07", "055", "05562", "51.74297", "7.18163", "Europe/Berlin"),
("2911408", "Halstenbek", "", "DE", "276", "", "10", "00", "01056", "53.63333", "9.85", "Europe/Berlin"),
("2911463", "Hallstadt", "", "DE", "276", "", "02", "094", "09471", "49.92901", "10.87539", "Europe/Berlin"),
("2911520", "Halle", "Галле", "DE", "276", "", "07", "057", "05754", "52.06007", "8.36083", "Europe/Berlin"),
("2911522", "Halle (Saale)", "Галле", "DE", "276", "DE", "14", "00", "15002", "51.5", "12", "Europe/Berlin"),
("2911530", "Hallbergmoos", "", "DE", "276", "", "02", "091", "09178", "48.32747", "11.75142", "Europe/Berlin"),
("2911559", "Halensee", "", "DE", "276", "", "16", "00", "11000", "52.49005", "13.29602", "Europe/Berlin"),
("2911584", "Haldensleben I", "Хальденслебен", "DE", "276", "", "14", "00", "15083", "52.28906", "11.40982", "Europe/Berlin"),
("2911665", "Halberstadt", "Хальберштадт", "DE", "276", "", "14", "00", "15085", "51.89562", "11.05622", "Europe/Berlin"),
("2911710", "Hakenfelde", "", "DE", "276", "", "16", "00", "11000", "52.55877", "13.20831", "Europe/Berlin"),
("2911739", "Haiterbach", "", "DE", "276", "", "01", "082", "08235", "48.52066", "8.64435", "Europe/Berlin"),
("2911795", "Hainichen", "", "DE", "276", "", "13", "00", "14522", "50.97044", "13.12287", "Europe/Berlin"),
("2911825", "Hain-Gründau", "", "DE", "276", "", "05", "064", "06435", "50.24284", "9.14287", "Europe/Berlin"),
("2911960", "Haigerloch", "", "DE", "276", "", "01", "084", "08417", "48.36614", "8.80357", "Europe/Berlin"),
("2911964", "Haiger", "Хайгер", "DE", "276", "", "05", "065", "06532", "50.74162", "8.20778", "Europe/Berlin"),
("2912159", "Haibach", "", "DE", "276", "", "02", "096", "09671", "49.96444", "9.20722", "Europe/Berlin"),
("2912351", "Hahnbach", "", "DE", "276", "", "02", "093", "09371", "49.53389", "11.80302", "Europe/Berlin"),
("2912481", "Hagenow", "", "DE", "276", "", "12", "00", "13076", "53.43134", "11.19159", "Europe/Berlin"),
("2912577", "Hagenbach", "", "DE", "276", "", "08", "00", "07334", "49.02611", "8.2375", "Europe/Berlin"),
("2912618", "Hagen", "", "DE", "276", "", "06", "00", "03459", "52.19629", "7.98041", "Europe/Berlin"),
("2912621", "Hagen", "Хаген", "DE", "276", "", "07", "059", "05914", "51.36081", "7.47168", "Europe/Berlin"),
("2912681", "Hage", "", "DE", "276", "", "06", "00", "03452", "53.60274", "7.28527", "Europe/Berlin"),
("2912829", "Hadamar", "", "DE", "276", "", "05", "065", "06533", "50.44593", "8.04253", "Europe/Berlin"),
("2912921", "Hachenburg", "", "DE", "276", "", "08", "00", "07143", "50.65998", "7.82276", "Europe/Berlin"),
("2913192", "Haar", "Хар", "DE", "276", "", "02", "091", "09184", "48.10881", "11.72653", "Europe/Berlin"),
("2913195", "Haan", "Хаан", "DE", "276", "", "07", "051", "05158", "51.19382", "7.0133", "Europe/Berlin"),
("2913210", "Haag in Oberbayern", "", "DE", "276", "", "02", "091", "09183", "48.16196", "12.17942", "Europe/Berlin"),
("2913286", "Guxhagen", "", "DE", "276", "", "05", "066", "06634", "51.2", "9.48333", "Europe/Berlin"),
("2913366", "Gütersloh", "Гютерсло", "DE", "276", "", "07", "057", "05754", "51.90693", "8.37853", "Europe/Berlin"),
("2913433", "Güstrow", "Гюстров", "DE", "276", "", "12", "00", "13072", "53.7972", "12.17337", "Europe/Berlin"),
("2913537", "Gunzenhausen", "Гунценхаузен", "DE", "276", "", "02", "095", "09577", "49.11663", "10.75971", "Europe/Berlin"),
("2913555", "Günzburg", "Гюнцбург", "DE", "276", "", "02", "097", "09774", "48.45599", "10.27695", "Europe/Berlin"),
("2913693", "Gundelsheim", "", "DE", "276", "", "01", "081", "08125", "49.2833", "9.16037", "Europe/Berlin"),
("2913711", "Gundelfingen", "", "DE", "276", "", "02", "097", "09773", "48.55347", "10.37223", "Europe/Berlin"),
("2913713", "Gundelfingen", "", "DE", "276", "", "01", "083", "08315", "48.04246", "7.8657", "Europe/Berlin"),
("2913761", "Gummersbach", "Гуммерсбах", "DE", "276", "", "07", "053", "05374", "51.02608", "7.56473", "Europe/Berlin"),
("2913838", "Güglingen", "", "DE", "276", "", "01", "081", "08125", "49.06642", "9.00175", "Europe/Berlin"),
("2913890", "Gudensberg", "", "DE", "276", "", "05", "066", "06634", "51.17706", "9.36748", "Europe/Berlin"),
("2913922", "Guben", "Губен", "DE", "276", "", "11", "00", "12071", "51.94987", "14.71447", "Europe/Berlin"),
("2913972", "Gschwend", "", "DE", "276", "", "01", "081", "08136", "48.93333", "9.74436", "Europe/Berlin"),
("2914064", "Grünwald", "", "DE", "276", "", "02", "091", "09184", "48.03947", "11.5232", "Europe/Berlin"),
("2914101", "Grünstadt", "", "DE", "276", "", "08", "00", "07332", "49.56302", "8.16279", "Europe/Berlin"),
("2914177", "Grünheide", "", "DE", "276", "", "11", "00", "12067", "52.42343", "13.81324", "Europe/Berlin"),
("2914210", "Grunewald", "", "DE", "276", "", "16", "00", "11000", "52.48338", "13.26586", "Europe/Berlin"),
("2914432", "Grünberg", "", "DE", "276", "", "05", "065", "06531", "50.59403", "8.95866", "Europe/Berlin"),
("2914477", "Grünau", "", "DE", "276", "DE", "16", "00", "11000", "52.41642", "13.58039", "Europe/Berlin"),
("2914801", "Groß-Zimmern", "", "DE", "276", "", "05", "064", "06432", "49.87583", "8.83444", "Europe/Berlin"),
("2914929", "Groß-Umstadt", "Грос-Умштадт", "DE", "276", "", "05", "064", "06432", "49.86899", "8.9321", "Europe/Berlin"),
("2915067", "Großschönau", "", "DE", "276", "", "13", "00", "14626", "50.9", "14.68333", "Europe/Berlin"),
("2915076", "Großschirma", "", "DE", "276", "", "13", "00", "14522", "50.96602", "13.2859", "Europe/Berlin"),
("2915116", "Großrosseln", "", "DE", "276", "", "09", "00", "10041", "49.20296", "6.84148", "Europe/Berlin"),
("2915124", "Großröhrsdorf", "", "DE", "276", "", "13", "00", "14625", "51.14528", "14.01917", "Europe/Berlin"),
("2915157", "Großräschen", "", "DE", "276", "", "11", "00", "12066", "51.5876", "14.01093", "Europe/Berlin"),
("2915173", "Großpösna", "", "DE", "276", "", "13", "00", "14729", "51.26667", "12.5", "Europe/Berlin"),
("2915196", "Großostheim", "", "DE", "276", "", "02", "096", "09671", "49.91985", "9.07596", "Europe/Berlin"),
("2915372", "Großkrotzenburg", "", "DE", "276", "", "05", "064", "06435", "50.08333", "8.98333", "Europe/Berlin"),
("2915375", "Groß Kreutz", "", "DE", "276", "", "11", "00", "12069", "52.40281", "12.7794", "Europe/Berlin"),
("2915438", "Großkarolinenfeld", "", "DE", "276", "", "02", "091", "09187", "47.89102", "12.08101", "Europe/Berlin"),
("2915511", "Großheubach", "", "DE", "276", "", "02", "096", "09676", "49.72834", "9.2228", "Europe/Berlin"),
("2915556", "Großhansdorf", "", "DE", "276", "", "10", "00", "01062", "53.66667", "10.28333", "Europe/Berlin"),
("2915613", "Groß-Gerau", "Грос-Герау", "DE", "276", "", "05", "064", "06433", "49.92139", "8.48255", "Europe/Berlin"),
("2916606", "Großenlüder", "", "DE", "276", "", "05", "066", "06631", "50.5925", "9.54231", "Europe/Berlin"),
("2916611", "Großenkneten", "", "DE", "276", "", "06", "00", "03458", "52.95", "8.26667", "Europe/Berlin"),
("2916630", "Großenhain", "Гросенхайн", "DE", "276", "", "13", "00", "14627", "51.28951", "13.5335", "Europe/Berlin"),
("2916936", "Großbottwar", "", "DE", "276", "", "01", "081", "08118", "49.00147", "9.29348", "Europe/Berlin"),
("2916996", "Großbeeren", "", "DE", "276", "", "11", "00", "12072", "52.35862", "13.30994", "Europe/Berlin"),
("2917053", "Großalmerode", "", "DE", "276", "", "05", "066", "06636", "51.25858", "9.7845", "Europe/Berlin"),
("2917138", "Gronau", "Гронау", "DE", "276", "", "07", "055", "05554", "52.21099", "7.02238", "Europe/Berlin"),
("2917139", "Gronau", "", "DE", "276", "", "06", "00", "03254", "52.0846", "9.77678", "Europe/Berlin"),
("2917150", "Grömitz", "", "DE", "276", "", "10", "00", "01055", "54.15", "10.96667", "Europe/Berlin"),
("2917170", "Groitzsch", "", "DE", "276", "", "13", "00", "14729", "51.15536", "12.28279", "Europe/Berlin"),
("2917221", "Gröbenzell", "", "DE", "276", "", "02", "091", "09179", "48.2", "11.36667", "Europe/Berlin"),
("2917309", "Grimmen", "", "DE", "276", "", "12", "00", "13073", "54.11215", "13.04051", "Europe/Berlin"),
("2917325", "Grimma", "Гримма", "DE", "276", "", "13", "00", "14729", "51.23367", "12.71959", "Europe/Berlin"),
("2917412", "Griesheim", "", "DE", "276", "", "05", "064", "06432", "49.86085", "8.5725", "Europe/Berlin"),
("2917461", "Bad Griesbach", "", "DE", "276", "DE", "02", "092", "09275", "48.45181", "13.19329", "Europe/Berlin"),
("2917520", "Grevesmühlen", "", "DE", "276", "", "12", "00", "13074", "53.86337", "11.1916", "Europe/Berlin"),
("2917540", "Grevenbroich", "Гревенброх", "DE", "276", "", "07", "051", "05162", "51.09102", "6.5827", "Europe/Berlin"),
("2917544", "Greven", "Гревен", "DE", "276", "", "07", "055", "05566", "52.09364", "7.59396", "Europe/Berlin"),
("2917698", "Grenzach-Wyhlen", "", "DE", "276", "", "01", "083", "08336", "47.55", "7.68333", "Europe/Berlin"),
("2917737", "Greiz", "Грайц", "DE", "276", "", "15", "00", "16076", "50.65778", "12.19918", "Europe/Berlin"),
("2917788", "Greifswald", "Грайфсвальд", "DE", "276", "", "12", "00", "13075", "54.09311", "13.38786", "Europe/Berlin"),
("2917793", "Greifenstein", "", "DE", "276", "", "05", "065", "06532", "50.61667", "8.3", "Europe/Berlin"),
("2917816", "Grefrath", "Грефрат", "DE", "276", "", "07", "051", "05166", "51.3363", "6.34072", "Europe/Berlin"),
("2917833", "Greding", "", "DE", "276", "", "02", "095", "09576", "49.04699", "11.35703", "Europe/Berlin"),
("2917848", "Grebenstein", "", "DE", "276", "", "05", "066", "06633", "51.44648", "9.4125", "Europe/Berlin"),
("2917850", "Grebenhain", "", "DE", "276", "", "05", "065", "06535", "50.48924", "9.33855", "Europe/Berlin"),
("2917868", "Grävenwiesbach", "", "DE", "276", "", "05", "064", "06434", "50.39024", "8.4569", "Europe/Berlin"),
("2917978", "Grassau", "", "DE", "276", "", "02", "091", "09189", "47.78099", "12.45359", "Europe/Berlin"),
("2918037", "Grasbrunn", "", "DE", "276", "", "02", "091", "09184", "48.07905", "11.74361", "Europe/Berlin"),
("2918041", "Grasberg", "", "DE", "276", "", "06", "00", "03356", "53.18333", "8.98333", "Europe/Berlin"),
("2918088", "Gransee", "", "DE", "276", "", "11", "00", "12065", "53.00704", "13.1575", "Europe/Berlin"),
("2918241", "Grafing bei München", "", "DE", "276", "", "02", "091", "09175", "48.04596", "11.96797", "Europe/Berlin"),
("2918258", "Grafenwöhr", "", "DE", "276", "", "02", "093", "09374", "49.71728", "11.90645", "Europe/Berlin"),
("2918321", "Gräfenhainichen", "", "DE", "276", "", "14", "00", "15091", "51.72892", "12.45651", "Europe/Berlin"),
("2918365", "Grafenau", "", "DE", "276", "", "02", "092", "09272", "48.85768", "13.3974", "Europe/Berlin"),
("2918368", "Gräfelfing", "", "DE", "276", "", "02", "091", "09184", "48.11878", "11.42939", "Europe/Berlin"),
("2918405", "Grabow", "", "DE", "276", "", "12", "00", "13076", "53.27966", "11.56502", "Europe/Berlin"),
("2918612", "Gottmadingen", "", "DE", "276", "", "01", "083", "08335", "47.73511", "8.77687", "Europe/Berlin"),
("2918632", "Göttingen", "Гёттинген", "DE", "276", "", "06", "00", "03152", "51.53443", "9.93228", "Europe/Berlin"),
("2918752", "Gotha", "Гота", "DE", "276", "", "15", "00", "16067", "50.94823", "10.70193", "Europe/Berlin"),
("2918840", "Goslar", "Гослар", "DE", "276", "", "06", "00", "03153", "51.90425", "10.42766", "Europe/Berlin"),
("2918987", "Görlitz", "Гёрлиц", "DE", "276", "", "13", "00", "14626", "51.15518", "14.98853", "Europe/Berlin"),
("2919054", "Göppingen", "Гёппинген", "DE", "276", "", "01", "081", "08117", "48.70354", "9.65209", "Europe/Berlin"),
("2919138", "Gommern", "", "DE", "276", "", "14", "00", "15086", "52.07391", "11.82297", "Europe/Berlin"),
("2919146", "Gomaringen", "", "DE", "276", "", "01", "084", "08416", "48.45349", "9.09582", "Europe/Berlin"),
("2919310", "Goldenstedt", "", "DE", "276", "", "06", "00", "03460", "52.78833", "8.43201", "Europe/Berlin"),
("2919438", "Goldbach", "", "DE", "276", "", "02", "096", "09671", "49.99951", "9.1844", "Europe/Berlin"),
("2919620", "Gochsheim", "", "DE", "276", "", "02", "096", "09678", "50.01667", "10.28333", "Europe/Berlin"),
("2919625", "Goch", "Гох", "DE", "276", "", "07", "051", "05154", "51.67873", "6.15895", "Europe/Berlin"),
("2919692", "Gnarrenburg", "", "DE", "276", "", "06", "00", "03357", "53.38333", "9", "Europe/Berlin"),
("2919717", "Gmund am Tegernsee", "", "DE", "276", "", "02", "091", "09182", "47.75119", "11.7381", "Europe/Berlin"),
("2919763", "Glückstadt", "", "DE", "276", "", "10", "00", "01061", "53.78893", "9.42576", "Europe/Berlin"),
("2919765", "Glücksburg", "", "DE", "276", "", "10", "00", "01059", "54.83522", "9.54853", "Europe/Berlin"),
("2919880", "Glinde", "", "DE", "276", "", "10", "00", "01062", "53.5441", "10.20048", "Europe/Berlin"),
("2919908", "Glienicke", "", "DE", "276", "", "11", "00", "12065", "52.63353", "13.32564", "Europe/Berlin"),
("2920020", "Glauchau", "Глаухау", "DE", "276", "", "13", "00", "14524", "50.81987", "12.54493", "Europe/Berlin"),
("2920085", "Glashütten", "", "DE", "276", "", "05", "064", "06434", "50.21667", "8.4", "Europe/Berlin"),
("2920205", "Glandorf", "", "DE", "276", "", "06", "00", "03459", "52.08333", "8.01667", "Europe/Berlin"),
("2920229", "Gladenbach", "", "DE", "276", "", "05", "065", "06534", "50.76847", "8.58085", "Europe/Berlin"),
("2920236", "Gladbeck", "Гладбек", "DE", "276", "", "07", "055", "05562", "51.57077", "6.98593", "Europe/Berlin"),
("2920329", "Ginsheim-Gustavsburg", "Гинсхайм-Густавсбург", "DE", "276", "", "05", "064", "06433", "49.9711", "8.34532", "Europe/Berlin"),
("2920433", "Gilching", "", "DE", "276", "", "02", "091", "09188", "48.10755", "11.2936", "Europe/Berlin"),
("2920478", "Gifhorn", "Гифхорн", "DE", "276", "", "06", "00", "03151", "52.47774", "10.5511", "Europe/Berlin"),
("2920512", "Gießen", "Гиссен", "DE", "276", "", "05", "065", "06531", "50.58727", "8.67554", "Europe/Berlin"),
("2920620", "Giengen an der Brenz", "Гинген-на-Бренце", "DE", "276", "", "01", "081", "08135", "48.62219", "10.24312", "Europe/Berlin"),
("2920757", "Gevelsberg", "Гефельсберг", "DE", "276", "", "07", "059", "05954", "51.31971", "7.3392", "Europe/Berlin"),
("2920776", "Gettorf", "", "DE", "276", "", "10", "00", "01058", "54.4", "9.98333", "Europe/Berlin"),
("292078